/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.cache.util;

import com.google.common.collect.Sets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.cache.constant.PermHelperConst;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.cache.util.SqlUtil;
import kd.bos.permission.model.PermResult;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class AppendPermByAdminUpgradeUtil {
    private static final Log logger = LogFactory.getLog(AppendPermByAdminUpgradeUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PermResult upgrade(List<Object[]> needAppendPermList, StringBuilder pProcessInfo) {
        DLock lock = null;
        try {
            lock = DLock.create((String)"bos/permissinon/AppendPermByAdminUpgradeUtil");
            lock.lock();
            if (null == pProcessInfo) {
                pProcessInfo = new StringBuilder();
            }
            if (null == needAppendPermList || needAppendPermList.isEmpty()) {
                logger.debug("AppendPermByAdminUpgradeUtil.upgrade, needAppendPermList is empty.");
                PermResult permResult = PermResult.ok();
                return permResult;
            }
            for (int i = 0; i < needAppendPermList.size(); ++i) {
                Object[] needAppendPermObj = needAppendPermList.get(i);
                if (null == needAppendPermObj || Objects.equals(0, needAppendPermObj.length)) {
                    logger.debug("AppendPermByAdminUpgradeUtil.upgrade, needAppendPermObj is empty, i:{}", (Object)i);
                    continue;
                }
                Object appIdObj = needAppendPermObj[0];
                Object entNumObj = needAppendPermObj[1];
                Object permItemIdObj = needAppendPermObj[2];
                if (Objects.isNull(appIdObj) || Objects.isNull(entNumObj) || Objects.isNull(permItemIdObj)) {
                    logger.debug("AppendPermByAdminUpgradeUtil.upgrade, appIdObj:{}, entNumObj:{}, permItemIdObj:{}, i:{}", new Object[]{appIdObj, entNumObj, permItemIdObj, i});
                    continue;
                }
                String appId = (String)appIdObj;
                String entNum = (String)entNumObj;
                String permItemId = (String)permItemIdObj;
                if (StringUtils.isEmpty((String)appId) || StringUtils.isEmpty((String)entNum) || StringUtils.isEmpty((String)permItemId)) {
                    logger.debug("AppendPermByAdminUpgradeUtil.upgrade, appId or entNum or permItemId is empty, appId:{}, entNum:{}, permItemId:{}, i:{}", new Object[]{appId, entNum, permItemId, i});
                    continue;
                }
                Object threeStrategyEntryIdObj = Objects.equals(3, needAppendPermObj.length) ? null : needAppendPermObj[3];
                Object[] threeStrategyEntryIdArr = Objects.isNull(threeStrategyEntryIdObj) ? new Long[]{} : (Long[])threeStrategyEntryIdObj;
                try (TXHandle h = TX.requiresNew();){
                    try {
                        if (null != threeStrategyEntryIdArr && threeStrategyEntryIdArr.length > 0) {
                            AppendPermByAdminUpgradeUtil.appendAdminSchemeDetail((Long[])threeStrategyEntryIdArr, appId, entNum, permItemId);
                        }
                        AppendPermByAdminUpgradeUtil.copyPermForAdmingroupFunperm(appId, entNum, permItemId);
                        continue;
                    }
                    catch (Exception e) {
                        String errInfo = String.format(ResManager.loadKDString((String)"\u3010\u6839\u636e\u7ba1\u7406\u5458\u8ffd\u52a0\u6388\u6743\u3011\u5347\u7ea7\u5f02\u5e38\uff0cappId\uff1a%1$s\uff0centNum\uff1a%2$s\uff0cpermItemId\uff1a%3$s\uff0cthreeStrategyEntryIdArr\uff1a%4$s\uff0c%5$s", (String)"AppendPermByAdminUpgradeUtil_0", (String)"bos-permission-cache", (Object[])new Object[0]), appId, entNum, permItemId, Arrays.toString(threeStrategyEntryIdArr), e.getMessage());
                        logger.warn(errInfo, (Throwable)e);
                        h.markRollback();
                        pProcessInfo.append(errInfo);
                        throw e;
                    }
                }
            }
        }
        finally {
            CacheMrg.clearAllCache();
            CacheMrg.clearHasEnableOldAdmin();
            if (null != lock) {
                lock.unlock();
            }
        }
        return PermResult.ok();
    }

    private static void appendAdminSchemeDetail(Long[] threeStrategyEntryIdArr, String appId, String entNum, String permItemId) {
        boolean needCheckAdminPerm = PermCommonUtil.needCheckAdminPerm(appId, entNum);
        if (!needCheckAdminPerm) {
            return;
        }
        Set<String> exist = AppendPermByAdminUpgradeUtil.queryForAdminSchemeDetail(threeStrategyEntryIdArr, appId, entNum, permItemId);
        int size = threeStrategyEntryIdArr.length - exist.size();
        if (Objects.equals(0, size)) {
            return;
        }
        long[] detailIds = DB.genLongIds((String)"t_perm_adminschemedetail", (int)size);
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(size);
        int idx = 0;
        for (Long threeStrategyEntryId : threeStrategyEntryIdArr) {
            String unique = threeStrategyEntryId + "_" + appId + "_" + entNum + "_" + permItemId;
            if (exist.contains(unique)) continue;
            paramList.add(new Object[]{threeStrategyEntryId, detailIds[idx], 0, appId, entNum, permItemId});
            ++idx;
        }
        String sql = "insert into t_perm_adminschemedetail (fentryid, fdetailid, fseq, fbizappid, fentitynum, fpermitemid) values(?, ?, ?, ?, ?, ?)";
        SqlUtil.syncInsert(paramList, sql, PermHelperConst.SQL_INSERT_BATCH_NUM_5000, DBRoute.base, true);
    }

    private static Set<String> queryForAdminSchemeDetail(Long[] threeStrategyEntryIdArr, String appId, String entNum, String permItemId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fentryid, fdetailid, fseq, fbizappid, fentitynum, fpermitemid from t_perm_adminschemedetail where 1=1 ", new Object[0]);
        sqlBuilder.appendIn(" and fentryid", (Object[])threeStrategyEntryIdArr);
        sqlBuilder.appendIn(" and fbizappid", (Object[])new String[]{appId});
        sqlBuilder.appendIn(" and fentitynum", (Object[])new String[]{entNum});
        sqlBuilder.appendIn(" and fpermitemid", (Object[])new String[]{permItemId});
        return (Set)DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)sqlBuilder, (ResultSetHandler)new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet rs) throws SQLException {
                HashSet<String> exist = new HashSet<String>(8);
                while (rs.next()) {
                    exist.add(rs.getObject("fentryid") + "_" + rs.getObject("fbizappid") + "_" + rs.getObject("fentitynum") + "_" + rs.getObject("fpermitemid"));
                }
                return exist;
            }
        });
    }

    private static void copyPermForAdmingroupFunperm(String appId, String entNum, String permItemId) {
        HashSet<Long> userGroupIdSet = new HashSet<Long>(8);
        StringBuilder querySql = new StringBuilder();
        querySql.append("select a.fid");
        querySql.append(" from t_perm_admingroup a ");
        querySql.append(" inner join t_perm_admingroupfunperm b on a.fid = b.fusergroupid ");
        try (DataSet dataSet = DB.queryDataSet((String)"AppendPermByAdminUpgradeUtil#copyPermForAdmingroupFunperm", (DBRoute)DBRoute.basedata, (String)querySql.toString(), null).distinct();){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                userGroupIdSet.add(row.getLong("fid"));
            }
        }
        if (null == userGroupIdSet || userGroupIdSet.isEmpty()) {
            return;
        }
        HashSet<Long> exists = new HashSet<Long>(8);
        StringBuilder sb = new StringBuilder();
        sb.append("select fusergroupid");
        sb.append(" from t_perm_admingroupfunperm ");
        sb.append(" where fappid = ? and fentitynum = ? and fpermitemid = ? ");
        try (DataSet ds = DB.queryDataSet((String)"AppendPermByAdminUpgradeUtil#copyPermForAdmingroupFunperm2", (DBRoute)DBRoute.basedata, (String)sb.toString(), (Object[])new Object[]{appId, entNum, permItemId}).distinct();){
            while (ds.hasNext()) {
                Row row = ds.next();
                exists.add(row.getLong("fusergroupid"));
            }
        }
        Sets.SetView difference = Sets.difference(userGroupIdSet, exists);
        if (null == difference || difference.isEmpty()) {
            return;
        }
        StringBuilder insertSql = new StringBuilder();
        insertSql.append("INSERT INTO t_perm_admingroupfunperm");
        insertSql.append(" (fid, fusergroupid, fappid, fpermitemid, fentitynum)");
        insertSql.append(" VALUES(?,?,?,?,?);");
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>(10);
        long[] entryIds = DB.genLongIds((String)"t_perm_admingroupfunperm", (int)userGroupIdSet.size());
        int index = 0;
        for (Long userGroupId : difference) {
            Object[] params = new Object[]{entryIds[index++], userGroupId, appId, permItemId, entNum};
            insertParams.add(params);
        }
        DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql.toString(), insertParams);
    }
}

