/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.cache.util;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.cache.util.DateUtil;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.model.PermResult;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class AppendPermByAppEntNumMapAuthorizeUtil {
    private static final Log logger = LogFactory.getLog(AppendPermByAppEntNumMapAuthorizeUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PermResult upgrade(List<Object[]> appIdEntNumMapObjList, StringBuilder pProcessInfo) {
        DLock lock = null;
        try {
            lock = DLock.create((String)"bos/permissinon/AppendPermByAppEntNumMapAuthorizeUtil");
            lock.lock();
            if (null == pProcessInfo) {
                pProcessInfo = new StringBuilder();
            }
            if (null == appIdEntNumMapObjList || appIdEntNumMapObjList.isEmpty()) {
                logger.debug("AppendPermByAppEntNumMapAuthorizeUtil.upgrade appIdEntNumMapList is empty.");
                throw new Exception("AppendPermByAppEntNumMapAuthorizeUtil.upgrade appIdEntNumMapList is empty.");
            }
            ArrayList<Object[]> adminSchemeDetailInsertParamList = new ArrayList<Object[]>(10);
            ArrayList<Object[]> admingroupFunpermInsertParamList = new ArrayList<Object[]>(10);
            ArrayList<Object[]> userPermDetailInsertParamList = new ArrayList<Object[]>(10);
            ArrayList<Object[]> disFunPermInsertParamList = new ArrayList<Object[]>(10);
            ArrayList<Object[]> rolePermDetailInsertParamList = new ArrayList<Object[]>(10);
            ArrayList<Object[]> bizRolePermInsertParamList = new ArrayList<Object[]>(10);
            ArrayList<Object[]> bizRoleDisPermInsertParamList = new ArrayList<Object[]>(10);
            ArrayList<Object[]> fieldPermDetailInsertParamList = new ArrayList<Object[]>(10);
            ArrayList<Object[]> userDirectDrInsertParamList = new ArrayList<Object[]>(10);
            ArrayList<Object[]> userDirectDrPrInsertParamList = new ArrayList<Object[]>(10);
            HashMap<String, List<Object[]>> roleDrInsertParamMap = new HashMap<String, List<Object[]>>(8);
            boolean hasEnableRoleDataRuleNewModel = AppendPermByAppEntNumMapAuthorizeUtil.isHasEnableRoleDataRuleNewModel();
            if (hasEnableRoleDataRuleNewModel) {
                roleDrInsertParamMap.put("paramList_t_perm_roledatarule", new ArrayList(1));
                roleDrInsertParamMap.put("paramList_t_perm_roledatarule_prop", new ArrayList(1));
            } else {
                roleDrInsertParamMap.put("paramList_t_perm_datarules_entry", new ArrayList(1));
                roleDrInsertParamMap.put("paramList_t_perm_datarule", new ArrayList(1));
                roleDrInsertParamMap.put("paramList_t_perm_datarule_l", new ArrayList(1));
                roleDrInsertParamMap.put("paramList_t_perm_datarule_entry", new ArrayList(1));
                roleDrInsertParamMap.put("paramList_t_perm_datarule_prop", new ArrayList(1));
            }
            HashMap<String, List<Object[]>> specialPermInsertParamMap = new HashMap<String, List<Object[]>>(8);
            specialPermInsertParamMap.put("paramList_t_perm_operationrule", new ArrayList(1));
            specialPermInsertParamMap.put("paramList_t_perm_operationrule_l", new ArrayList(1));
            specialPermInsertParamMap.put("paramList_t_perm_operationruleobj", new ArrayList(1));
            specialPermInsertParamMap.put("paramList_t_perm_director", new ArrayList(1));
            specialPermInsertParamMap.put("paramList_t_perm_exceptuser", new ArrayList(1));
            specialPermInsertParamMap.put("paramList_t_perm_oprexusrgrp", new ArrayList(1));
            specialPermInsertParamMap.put("paramList_t_perm_oprexrole", new ArrayList(1));
            for (int i = 0; i < appIdEntNumMapObjList.size(); ++i) {
                Object[] appIdEntNumMapObj = appIdEntNumMapObjList.get(i);
                if (null == appIdEntNumMapObj || Objects.equals(0, appIdEntNumMapObj.length)) {
                    logger.debug("AppendPermByAppEntNumMapAuthorizeUtil.upgrade, appIdEntNumMapObj is empty, i: {}", (Object)i);
                    continue;
                }
                if (!Objects.equals(3, appIdEntNumMapObj.length)) {
                    logger.debug("AppendPermByAppEntNumMapAuthorizeUtil.upgrade, appIdEntNumMapObj illegal, i: {}", (Object)i);
                    continue;
                }
                Object authorizedAppIdObj = appIdEntNumMapObj[0];
                Object entNumObj = appIdEntNumMapObj[1];
                Object newAppIdObj = appIdEntNumMapObj[2];
                if (Objects.isNull(authorizedAppIdObj) || Objects.isNull(entNumObj) || Objects.isNull(newAppIdObj)) {
                    logger.debug("AppendPermByAppEntNumMapAuthorizeUtil.upgrade, authorizedAppIdObj: {}, entNumObj: {}, newAppIdObj: {}, i: {}", new Object[]{authorizedAppIdObj, entNumObj, newAppIdObj, i});
                    continue;
                }
                String authorizedAppId = (String)authorizedAppIdObj;
                String entNumStr = (String)entNumObj;
                String newAppId = (String)newAppIdObj;
                if (StringUtils.isEmpty((String)authorizedAppId) || StringUtils.isEmpty((String)entNumStr) || StringUtils.isEmpty((String)newAppId)) {
                    logger.debug("AppendPermItemAuthByAppUpgradeUtil.upgrade, authorizedAppId or entNumStr or newAppId or entNumStr is empty, authorizedAppId: {}, entNumStr: {}, newAppId: {}, i: {}", new Object[]{authorizedAppId, entNumStr, newAppId, i});
                    continue;
                }
                adminSchemeDetailInsertParamList.addAll(AppendPermByAppEntNumMapAuthorizeUtil.appendPermForAdminSchemeDetail(newAppId, entNumStr, authorizedAppId));
                admingroupFunpermInsertParamList.addAll(AppendPermByAppEntNumMapAuthorizeUtil.appendPermForAdmingroupFunperm(newAppId, entNumStr, authorizedAppId));
                userPermDetailInsertParamList.addAll(AppendPermByAppEntNumMapAuthorizeUtil.appendPermForUserPermDetail(newAppId, entNumStr, authorizedAppId));
                disFunPermInsertParamList.addAll(AppendPermByAppEntNumMapAuthorizeUtil.appendPermForDisFunPerm(newAppId, entNumStr, authorizedAppId));
                rolePermDetailInsertParamList.addAll(AppendPermByAppEntNumMapAuthorizeUtil.appendPermForRolePermDetail(newAppId, entNumStr, authorizedAppId));
                bizRolePermInsertParamList.addAll(AppendPermByAppEntNumMapAuthorizeUtil.appendPermForBizRolePerm(newAppId, entNumStr, authorizedAppId));
                bizRoleDisPermInsertParamList.addAll(AppendPermByAppEntNumMapAuthorizeUtil.appendPermForBizRoleDisPerm(newAppId, entNumStr, authorizedAppId));
                fieldPermDetailInsertParamList.addAll(AppendPermByAppEntNumMapAuthorizeUtil.appendPermForFieldPermDetail(newAppId, entNumStr, authorizedAppId));
                userDirectDrInsertParamList.addAll(AppendPermByAppEntNumMapAuthorizeUtil.appendPermForUserDirectDr(newAppId, entNumStr, authorizedAppId));
                userDirectDrPrInsertParamList.addAll(AppendPermByAppEntNumMapAuthorizeUtil.appendPermForUserDirectDrPr(newAppId, entNumStr, authorizedAppId));
                Map<String, List<Object[]>> roleDrInsertParamMapOne = AppendPermByAppEntNumMapAuthorizeUtil.appendPermForRoleDr(newAppId, entNumStr, authorizedAppId, hasEnableRoleDataRuleNewModel);
                if (hasEnableRoleDataRuleNewModel) {
                    ((List)roleDrInsertParamMap.get("paramList_t_perm_roledatarule")).addAll((Collection)roleDrInsertParamMapOne.get("paramList_t_perm_roledatarule"));
                    ((List)roleDrInsertParamMap.get("paramList_t_perm_roledatarule_prop")).addAll((Collection)roleDrInsertParamMapOne.get("paramList_t_perm_roledatarule_prop"));
                } else {
                    ((List)roleDrInsertParamMap.get("paramList_t_perm_datarules_entry")).addAll((Collection)roleDrInsertParamMapOne.get("paramList_t_perm_datarules_entry"));
                    ((List)roleDrInsertParamMap.get("paramList_t_perm_datarule")).addAll((Collection)roleDrInsertParamMapOne.get("paramList_t_perm_datarule"));
                    ((List)roleDrInsertParamMap.get("paramList_t_perm_datarule_l")).addAll((Collection)roleDrInsertParamMapOne.get("paramList_t_perm_datarule_l"));
                    ((List)roleDrInsertParamMap.get("paramList_t_perm_datarule_entry")).addAll((Collection)roleDrInsertParamMapOne.get("paramList_t_perm_datarule_entry"));
                    ((List)roleDrInsertParamMap.get("paramList_t_perm_datarule_prop")).addAll((Collection)roleDrInsertParamMapOne.get("paramList_t_perm_datarule_prop"));
                }
                Map<String, List<Object[]>> specialPermInsertParamMapOne = AppendPermByAppEntNumMapAuthorizeUtil.appendPermForSpecialPerm(newAppId, entNumStr, authorizedAppId);
                ((List)specialPermInsertParamMap.get("paramList_t_perm_operationrule")).addAll((Collection)specialPermInsertParamMapOne.get("paramList_t_perm_operationrule"));
                ((List)specialPermInsertParamMap.get("paramList_t_perm_operationrule_l")).addAll((Collection)specialPermInsertParamMapOne.get("paramList_t_perm_operationrule_l"));
                ((List)specialPermInsertParamMap.get("paramList_t_perm_operationruleobj")).addAll((Collection)specialPermInsertParamMapOne.get("paramList_t_perm_operationruleobj"));
                ((List)specialPermInsertParamMap.get("paramList_t_perm_director")).addAll((Collection)specialPermInsertParamMapOne.get("paramList_t_perm_director"));
                ((List)specialPermInsertParamMap.get("paramList_t_perm_exceptuser")).addAll((Collection)specialPermInsertParamMapOne.get("paramList_t_perm_exceptuser"));
                ((List)specialPermInsertParamMap.get("paramList_t_perm_oprexusrgrp")).addAll((Collection)specialPermInsertParamMapOne.get("paramList_t_perm_oprexusrgrp"));
                ((List)specialPermInsertParamMap.get("paramList_t_perm_oprexrole")).addAll((Collection)specialPermInsertParamMapOne.get("paramList_t_perm_oprexrole"));
            }
            try (TXHandle h = TX.requiresNew();){
                try {
                    AppendPermByAppEntNumMapAuthorizeUtil.DBAppendPermForAdminSchemeDetail(adminSchemeDetailInsertParamList);
                    AppendPermByAppEntNumMapAuthorizeUtil.DBAppendPermForAdmingroupFunperm(admingroupFunpermInsertParamList);
                    AppendPermByAppEntNumMapAuthorizeUtil.DBAppendPermForUserPermDetail(userPermDetailInsertParamList);
                    AppendPermByAppEntNumMapAuthorizeUtil.DBAppendPermForDisFunPerm(disFunPermInsertParamList);
                    AppendPermByAppEntNumMapAuthorizeUtil.DBAppendPermForRolePermDetail(rolePermDetailInsertParamList);
                    AppendPermByAppEntNumMapAuthorizeUtil.DBAppendPermForBizRolePerm(bizRolePermInsertParamList);
                    AppendPermByAppEntNumMapAuthorizeUtil.DBAppendPermForBizRoleDisPerm(bizRoleDisPermInsertParamList);
                    AppendPermByAppEntNumMapAuthorizeUtil.DBAppendPermForFieldPermDetail(fieldPermDetailInsertParamList);
                    AppendPermByAppEntNumMapAuthorizeUtil.DBAppendPermForUserDirectDr(userDirectDrInsertParamList);
                    AppendPermByAppEntNumMapAuthorizeUtil.DBAppendPermForUserDirectDrPr(userDirectDrPrInsertParamList);
                    AppendPermByAppEntNumMapAuthorizeUtil.DBAppendPermForRoleDr(roleDrInsertParamMap);
                    AppendPermByAppEntNumMapAuthorizeUtil.DBAppendPermForSpecialPerm(specialPermInsertParamMap);
                }
                catch (Exception e) {
                    String errInfo = String.format(ResManager.loadKDString((String)"\u3010\u6839\u636e\u5e94\u7528\u8868\u5355\u6620\u5c04\u5173\u7cfb\u8ffd\u52a0\u6388\u6743\u3011\u5347\u7ea7\u5f02\u5e38\uff0c%s", (String)"AppendPermByAppEntNumMapAuthorizeUtil_0", (String)"bos-permission-cache", (Object[])new Object[0]), e.getMessage());
                    logger.warn(errInfo, (Throwable)e);
                    h.markRollback();
                    pProcessInfo.append(errInfo);
                    throw e;
                }
            }
        }
        catch (Exception e) {
            logger.warn("AppendPermByAppEntNumMapAuthorizeUtil.upgrade error", (Throwable)e);
            PermResult permResult = PermResult.fail((String)e.getMessage());
            return permResult;
        }
        finally {
            CacheMrg.clearAllCache();
            CacheMrg.clearHasEnableOldAdmin();
            CacheMrg.clearAllLocalCache();
            if (null != lock) {
                lock.unlock();
            }
        }
        return PermResult.ok();
    }

    private static void DBAppendPermForSpecialPerm(Map<String, List<Object[]>> specialPermInsertParamMap) {
        List<Object[]> paramList_t_perm_oprexrole;
        List<Object[]> paramList_t_perm_oprexusrgrp;
        List<Object[]> paramList_t_perm_exceptuser;
        List<Object[]> paramList_t_perm_director;
        List<Object[]> paramList_t_perm_operationruleobj;
        List<Object[]> paramList_t_perm_operationrule_l;
        if (null == specialPermInsertParamMap || specialPermInsertParamMap.isEmpty()) {
            return;
        }
        List<Object[]> paramList_t_perm_operationrule = specialPermInsertParamMap.get("paramList_t_perm_operationrule");
        if (null != paramList_t_perm_operationrule && !paramList_t_perm_operationrule.isEmpty()) {
            StringBuilder insertSql = new StringBuilder();
            insertSql.append("INSERT INTO t_perm_operationrule ");
            insertSql.append(" (fid, fenabled, foperationtype, fentitytypeid, fispublic, fbizappid, fispreset, frule, foperationkey, fname, fdescription) ");
            insertSql.append(" VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);");
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql.toString(), paramList_t_perm_operationrule);
        }
        if (null != (paramList_t_perm_operationrule_l = specialPermInsertParamMap.get("paramList_t_perm_operationrule_l")) && !paramList_t_perm_operationrule_l.isEmpty()) {
            StringBuilder insertSql = new StringBuilder();
            insertSql.append("INSERT INTO t_perm_operationrule_l ");
            insertSql.append(" (fpkid, fid, flocaleid, fname, fdescription) ");
            insertSql.append(" VALUES(?, ?, ?, ?, ?);");
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql.toString(), paramList_t_perm_operationrule_l);
        }
        if (null != (paramList_t_perm_operationruleobj = specialPermInsertParamMap.get("paramList_t_perm_operationruleobj")) && !paramList_t_perm_operationruleobj.isEmpty()) {
            StringBuilder insertSql = new StringBuilder();
            insertSql.append("INSERT INTO t_perm_operationruleobj ");
            insertSql.append(" (fid, foperationruleid, fseq, fentitytypeid, fobjenabled, fbizappid) ");
            insertSql.append(" VALUES(?, ?, ?, ?, ?, ?);");
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql.toString(), paramList_t_perm_operationruleobj);
        }
        if (null != (paramList_t_perm_director = specialPermInsertParamMap.get("paramList_t_perm_director")) && !paramList_t_perm_director.isEmpty()) {
            StringBuilder insertSql = new StringBuilder();
            insertSql.append("INSERT INTO t_perm_director ");
            insertSql.append(" (fid, foperationruleobjid, fdirectorid, forgid) ");
            insertSql.append(" VALUES(?, ?, ?, ?);");
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql.toString(), paramList_t_perm_director);
        }
        if (null != (paramList_t_perm_exceptuser = specialPermInsertParamMap.get("paramList_t_perm_exceptuser")) && !paramList_t_perm_exceptuser.isEmpty()) {
            StringBuilder insertSql = new StringBuilder();
            insertSql.append("INSERT INTO t_perm_exceptuser ");
            insertSql.append(" (fid, foperationruleobjid, fuserid)  ");
            insertSql.append(" VALUES(?, ?, ?);");
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql.toString(), paramList_t_perm_exceptuser);
        }
        if (null != (paramList_t_perm_oprexusrgrp = specialPermInsertParamMap.get("paramList_t_perm_oprexusrgrp")) && !paramList_t_perm_oprexusrgrp.isEmpty()) {
            StringBuilder insertSql = new StringBuilder();
            insertSql.append("INSERT INTO t_perm_oprexusrgrp ");
            insertSql.append(" (fid, foperationruleobjid, fusergroupid) ");
            insertSql.append(" VALUES(?, ?, ?);");
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql.toString(), paramList_t_perm_oprexusrgrp);
        }
        if (null != (paramList_t_perm_oprexrole = specialPermInsertParamMap.get("paramList_t_perm_oprexrole")) && !paramList_t_perm_oprexrole.isEmpty()) {
            StringBuilder insertSql = new StringBuilder();
            insertSql.append("INSERT INTO t_perm_oprexrole ");
            insertSql.append(" (fid, foperationruleobjid, froleid) ");
            insertSql.append(" VALUES(?, ?, ?);");
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql.toString(), paramList_t_perm_oprexrole);
        }
    }

    private static Map<String, List<Object[]>> appendPermForSpecialPerm(String newAppId, String entNumStr, String authorizedAppId) {
        Map<String, Object> paramMap_t_perm_operationrule = AppendPermByAppEntNumMapAuthorizeUtil.paramMap_t_perm_operationrule(newAppId, entNumStr, authorizedAppId);
        List paramList_t_perm_operationrule = (List)paramMap_t_perm_operationrule.get("paramList_t_perm_operationrule");
        List paramList_t_perm_operationrule_l = (List)paramMap_t_perm_operationrule.get("paramList_t_perm_operationrule_l");
        Map appidEntnumFopratonruleidMap = (Map)paramMap_t_perm_operationrule.get("appidEntnumFopratonruleidMap");
        Map<String, Object> paramMap_t_perm_operationruleobj = AppendPermByAppEntNumMapAuthorizeUtil.paramMap_t_perm_operationruleobj(appidEntnumFopratonruleidMap, newAppId, entNumStr, authorizedAppId);
        List paramList_t_perm_operationruleobj = (List)paramMap_t_perm_operationruleobj.get("paramList_t_perm_operationruleobj");
        Map oldObjId2NewObjIdMap = (Map)paramMap_t_perm_operationruleobj.get("oldObjId2NewObjIdMap");
        List<Object[]> paramList_t_perm_director = AppendPermByAppEntNumMapAuthorizeUtil.paramList_t_perm_director(oldObjId2NewObjIdMap, newAppId, entNumStr, authorizedAppId);
        List<Object[]> paramList_t_perm_exceptuser = AppendPermByAppEntNumMapAuthorizeUtil.paramList_t_perm_exceptuser(oldObjId2NewObjIdMap, newAppId, entNumStr, authorizedAppId);
        List<Object[]> paramList_t_perm_oprexusrgrp = AppendPermByAppEntNumMapAuthorizeUtil.paramList_t_perm_oprexusrgrp(oldObjId2NewObjIdMap, newAppId, entNumStr, authorizedAppId);
        List<Object[]> paramList_t_perm_oprexrole = AppendPermByAppEntNumMapAuthorizeUtil.paramList_t_perm_oprexrole(oldObjId2NewObjIdMap, newAppId, entNumStr, authorizedAppId);
        HashMap<String, List<Object[]>> map = new HashMap<String, List<Object[]>>(8);
        map.put("paramList_t_perm_operationrule", paramList_t_perm_operationrule);
        map.put("paramList_t_perm_operationrule_l", paramList_t_perm_operationrule_l);
        map.put("paramList_t_perm_operationruleobj", paramList_t_perm_operationruleobj);
        map.put("paramList_t_perm_director", paramList_t_perm_director);
        map.put("paramList_t_perm_exceptuser", paramList_t_perm_exceptuser);
        map.put("paramList_t_perm_oprexusrgrp", paramList_t_perm_oprexusrgrp);
        map.put("paramList_t_perm_oprexrole", paramList_t_perm_oprexrole);
        return map;
    }

    private static List<Object[]> paramList_t_perm_oprexrole(Map<String, Map<String, String>> oldObjId2NewObjIdMap, String newAppId, String entNumStr, String authorizedAppId) {
        Row row;
        HashSet<String> need2AppendAuthSet = new HashSet<String>(8);
        StringBuilder querySql = new StringBuilder();
        querySql.append("select a.fid, a.foperationruleobjid, a.froleid, b.fbizappid, b.fentitytypeid, b.foperationruleid ");
        querySql.append(" from t_perm_oprexrole a ");
        querySql.append(" inner join t_perm_operationruleobj b on a.foperationruleobjid = b.fid ");
        querySql.append(" where b.fbizappid in ('").append(authorizedAppId).append("')");
        querySql.append(" and b.fentitytypeid in ('").append(entNumStr).append("')");
        try (DataSet dataSet = DB.queryDataSet((String)"AppendPermByAppEntNumMapAuthorizeUtil#paramList_t_perm_oprexrole_1", (DBRoute)DBRoute.basedata, (String)querySql.toString());){
            while (dataSet.hasNext()) {
                String newObjId;
                row = dataSet.next();
                Map<String, String> newappentruleidObjIdMap = oldObjId2NewObjIdMap.get(row.getString("foperationruleobjid"));
                if (null == newappentruleidObjIdMap || newappentruleidObjIdMap.isEmpty() || StringUtils.isEmpty((String)(newObjId = newappentruleidObjIdMap.get(newAppId + "|" + row.get("fentitytypeid"))))) continue;
                need2AppendAuthSet.add(newObjId + "|" + row.get("froleid") + "|" + newAppId + "|" + row.get("fentitytypeid"));
            }
        }
        querySql.setLength(0);
        querySql.append("select a.fid, a.foperationruleobjid, a.froleid, b.fbizappid, b.fentitytypeid");
        querySql.append(" from t_perm_oprexrole a ");
        querySql.append(" inner join t_perm_operationruleobj b on a.foperationruleobjid = b.fid ");
        querySql.append(" where b.fbizappid in ('").append(newAppId).append("')");
        querySql.append(" and b.fentitytypeid in ('").append(entNumStr).append("')");
        var7_7 = null;
        try (DataSet ds = DB.queryDataSet((String)"AppendPermByAppEntNumMapAuthorizeUtil#paramList_t_perm_oprexrole_2", (DBRoute)DBRoute.basedata, (String)querySql.toString());){
            while (ds.hasNext()) {
                row = ds.next();
                need2AppendAuthSet.remove(row.get("foperationruleobjid") + "|" + row.get("froleid") + "|" + row.get("fbizappid") + "|" + row.get("fentitytypeid"));
            }
        }
        catch (Throwable row2) {
            var7_7 = row2;
            throw row2;
        }
        if (null == need2AppendAuthSet || need2AppendAuthSet.isEmpty()) {
            return new ArrayList<Object[]>(1);
        }
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>(10);
        String[] ids = DB.genStringIds((String)"t_perm_oprexrole", (int)need2AppendAuthSet.size());
        int index = 0;
        for (String need2AppendAuth : need2AppendAuthSet) {
            String[] split;
            if (StringUtils.isEmpty((String)need2AppendAuth) || null == (split = need2AppendAuth.split("\\|")) || !Objects.equals(4, split.length)) continue;
            Object[] params = new Object[]{ids[index++], split[0], split[1]};
            insertParams.add(params);
        }
        return insertParams;
    }

    private static List<Object[]> paramList_t_perm_oprexusrgrp(Map<String, Map<String, String>> oldObjId2NewObjIdMap, String newAppId, String entNumStr, String authorizedAppId) {
        Row row;
        HashSet<String> need2AppendAuthSet = new HashSet<String>(8);
        StringBuilder querySql = new StringBuilder();
        querySql.append("select a.fid, a.foperationruleobjid, a.fusergroupid, b.fbizappid, b.fentitytypeid");
        querySql.append(" from t_perm_oprexusrgrp a ");
        querySql.append(" inner join t_perm_operationruleobj b on a.foperationruleobjid = b.fid ");
        querySql.append(" where b.fbizappid in ('").append(authorizedAppId).append("')");
        querySql.append(" and b.fentitytypeid in ('").append(entNumStr).append("')");
        try (DataSet dataSet = DB.queryDataSet((String)"AppendPermByAppEntNumMapAuthorizeUtil#paramList_t_perm_oprexusrgrp_1", (DBRoute)DBRoute.basedata, (String)querySql.toString());){
            while (dataSet.hasNext()) {
                String newObjId;
                row = dataSet.next();
                Map<String, String> newappentruleidObjIdMap = oldObjId2NewObjIdMap.get(row.getString("foperationruleobjid"));
                if (null == newappentruleidObjIdMap || newappentruleidObjIdMap.isEmpty() || StringUtils.isEmpty((String)(newObjId = newappentruleidObjIdMap.get(newAppId + "|" + row.get("fentitytypeid"))))) continue;
                need2AppendAuthSet.add(newObjId + "|" + row.get("fusergroupid") + "|" + newAppId + "|" + row.get("fentitytypeid"));
            }
        }
        querySql.setLength(0);
        querySql.append("select a.fid, a.foperationruleobjid, a.fusergroupid, b.fbizappid, b.fentitytypeid");
        querySql.append(" from t_perm_oprexusrgrp a ");
        querySql.append(" inner join t_perm_operationruleobj b on a.foperationruleobjid = b.fid ");
        querySql.append(" where b.fbizappid in ('").append(newAppId).append("')");
        querySql.append(" and b.fentitytypeid in ('").append(entNumStr).append("')");
        var7_7 = null;
        try (DataSet ds = DB.queryDataSet((String)"AppendPermByAppEntNumMapAuthorizeUtil#paramList_t_perm_oprexusrgrp_2", (DBRoute)DBRoute.basedata, (String)querySql.toString());){
            while (ds.hasNext()) {
                row = ds.next();
                need2AppendAuthSet.remove(row.get("foperationruleobjid") + "|" + row.get("fusergroupid") + "|" + row.get("fbizappid") + "|" + row.get("fentitytypeid"));
            }
        }
        catch (Throwable row2) {
            var7_7 = row2;
            throw row2;
        }
        if (null == need2AppendAuthSet || need2AppendAuthSet.isEmpty()) {
            return new ArrayList<Object[]>(1);
        }
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>(10);
        String[] ids = DB.genStringIds((String)"t_perm_oprexusrgrp", (int)need2AppendAuthSet.size());
        int index = 0;
        for (String need2AppendAuth : need2AppendAuthSet) {
            String[] split;
            if (StringUtils.isEmpty((String)need2AppendAuth) || null == (split = need2AppendAuth.split("\\|")) || !Objects.equals(4, split.length)) continue;
            Object[] params = new Object[]{ids[index++], split[0], Long.valueOf(split[1])};
            insertParams.add(params);
        }
        return insertParams;
    }

    private static List<Object[]> paramList_t_perm_exceptuser(Map<String, Map<String, String>> oldObjId2NewObjIdMap, String newAppId, String entNumStr, String authorizedAppId) {
        Row row;
        HashSet<String> need2AppendAuthSet = new HashSet<String>(8);
        StringBuilder querySql = new StringBuilder();
        querySql.append("select a.fid, a.foperationruleobjid, a.fuserid, b.fbizappid, b.fentitytypeid");
        querySql.append(" from t_perm_exceptuser a ");
        querySql.append(" inner join t_perm_operationruleobj b on a.foperationruleobjid = b.fid ");
        querySql.append(" where b.fbizappid in ('").append(authorizedAppId).append("')");
        querySql.append(" and b.fentitytypeid in ('").append(entNumStr).append("')");
        try (DataSet dataSet = DB.queryDataSet((String)"AppendPermByAppEntNumMapAuthorizeUtil#paramList_t_perm_exceptuser_1", (DBRoute)DBRoute.basedata, (String)querySql.toString());){
            while (dataSet.hasNext()) {
                String newObjId;
                row = dataSet.next();
                Map<String, String> newappentruleidObjIdMap = oldObjId2NewObjIdMap.get(row.getString("foperationruleobjid"));
                if (null == newappentruleidObjIdMap || newappentruleidObjIdMap.isEmpty() || StringUtils.isEmpty((String)(newObjId = newappentruleidObjIdMap.get(newAppId + "|" + row.get("fentitytypeid"))))) continue;
                need2AppendAuthSet.add(newObjId + "|" + row.get("fuserid") + "|" + newAppId + "|" + row.get("fentitytypeid"));
            }
        }
        querySql.setLength(0);
        querySql.append("select a.fid, a.foperationruleobjid, a.fuserid, b.fbizappid, b.fentitytypeid");
        querySql.append(" from t_perm_exceptuser a ");
        querySql.append(" inner join t_perm_operationruleobj b on a.foperationruleobjid = b.fid ");
        querySql.append(" where b.fbizappid in ('").append(newAppId).append("')");
        querySql.append(" and b.fentitytypeid in ('").append(entNumStr).append("')");
        var7_7 = null;
        try (DataSet ds = DB.queryDataSet((String)"AppendPermByAppEntNumMapAuthorizeUtil#paramList_t_perm_exceptuser_2", (DBRoute)DBRoute.basedata, (String)querySql.toString());){
            while (ds.hasNext()) {
                row = ds.next();
                need2AppendAuthSet.remove(row.get("foperationruleobjid") + "|" + row.get("fuserid") + "|" + row.get("fbizappid") + "|" + row.get("fentitytypeid"));
            }
        }
        catch (Throwable row2) {
            var7_7 = row2;
            throw row2;
        }
        if (null == need2AppendAuthSet || need2AppendAuthSet.isEmpty()) {
            return new ArrayList<Object[]>(1);
        }
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>(10);
        String[] ids = DB.genStringIds((String)"t_perm_exceptuser", (int)need2AppendAuthSet.size());
        int index = 0;
        for (String need2AppendAuth : need2AppendAuthSet) {
            String[] split;
            if (StringUtils.isEmpty((String)need2AppendAuth) || null == (split = need2AppendAuth.split("\\|")) || !Objects.equals(4, split.length)) continue;
            Object[] params = new Object[]{ids[index++], split[0], Long.valueOf(split[1])};
            insertParams.add(params);
        }
        return insertParams;
    }

    private static List<Object[]> paramList_t_perm_director(Map<String, Map<String, String>> oldObjId2NewObjIdMap, String newAppId, String entNumStr, String authorizedAppId) {
        Row row;
        HashSet<String> need2AppendAuthSet = new HashSet<String>(8);
        StringBuilder querySql = new StringBuilder();
        querySql.append("select a.fid, a.foperationruleobjid, a.fdirectorid, a.forgid, b.fbizappid, b.fentitytypeid");
        querySql.append(" from t_perm_director a ");
        querySql.append(" inner join t_perm_operationruleobj b on a.foperationruleobjid = b.fid ");
        querySql.append(" where b.fbizappid in ('").append(authorizedAppId).append("')");
        querySql.append(" and b.fentitytypeid in ('").append(entNumStr).append("')");
        try (DataSet dataSet = DB.queryDataSet((String)"AppendPermByAppEntNumMapAuthorizeUtil#paramList_t_perm_director_1", (DBRoute)DBRoute.basedata, (String)querySql.toString());){
            while (dataSet.hasNext()) {
                String newObjId;
                row = dataSet.next();
                Map<String, String> newappentruleidObjIdMap = oldObjId2NewObjIdMap.get(row.getString("foperationruleobjid"));
                if (null == newappentruleidObjIdMap || newappentruleidObjIdMap.isEmpty() || StringUtils.isEmpty((String)(newObjId = newappentruleidObjIdMap.get(newAppId + "|" + row.get("fentitytypeid"))))) continue;
                need2AppendAuthSet.add(newObjId + "|" + row.get("fdirectorid") + "|" + row.get("forgid") + "|" + newAppId + "|" + row.get("fentitytypeid"));
            }
        }
        querySql.setLength(0);
        querySql.append("select a.fid, a.foperationruleobjid, a.fdirectorid, a.forgid, b.fbizappid, b.fentitytypeid");
        querySql.append(" from t_perm_director a ");
        querySql.append(" inner join t_perm_operationruleobj b on a.foperationruleobjid = b.fid ");
        querySql.append(" where b.fbizappid in ('").append(newAppId).append("')");
        querySql.append(" and b.fentitytypeid in ('").append(entNumStr).append("')");
        var7_7 = null;
        try (DataSet ds = DB.queryDataSet((String)"AppendPermByAppEntNumMapAuthorizeUtil#paramList_t_perm_director_2", (DBRoute)DBRoute.basedata, (String)querySql.toString());){
            while (ds.hasNext()) {
                row = ds.next();
                need2AppendAuthSet.remove(row.get("foperationruleobjid") + "|" + row.get("fdirectorid") + "|" + row.get("forgid") + "|" + row.get("fbizappid") + "|" + row.get("fentitytypeid"));
            }
        }
        catch (Throwable row2) {
            var7_7 = row2;
            throw row2;
        }
        if (null == need2AppendAuthSet || need2AppendAuthSet.isEmpty()) {
            return new ArrayList<Object[]>(1);
        }
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>(10);
        String[] ids = DB.genStringIds((String)"t_perm_director", (int)need2AppendAuthSet.size());
        int index = 0;
        for (String need2AppendAuth : need2AppendAuthSet) {
            String[] split;
            if (StringUtils.isEmpty((String)need2AppendAuth) || null == (split = need2AppendAuth.split("\\|")) || !Objects.equals(5, split.length)) continue;
            Object[] params = new Object[]{ids[index++], split[0], Long.valueOf(split[1]), Long.valueOf(split[2])};
            insertParams.add(params);
        }
        return insertParams;
    }

    private static Map<String, Object> paramMap_t_perm_operationruleobj(Map<String, String> appidEntnumFopratonruleidMap, String newAppId, String entNumStr, String authorizedAppId) {
        Row row;
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("paramList_t_perm_operationruleobj", new ArrayList(1));
        HashMap<String, Map> oldObjId2NewObjIdMap = new HashMap<String, Map>(8);
        map.put("oldObjId2NewObjIdMap", oldObjId2NewObjIdMap);
        ArrayList<String> newObjIdList = new ArrayList<String>(10);
        ArrayList<String> need2AppendAuthList = new ArrayList<String>(10);
        StringBuilder querySql = new StringBuilder();
        querySql.append("select a.fid, a.foperationruleid, a.fseq, a.fentitytypeid, a.fobjenabled, a.fbizappid,  b.fispublic ");
        querySql.append(" from t_perm_operationruleobj a ");
        querySql.append(" inner join t_perm_operationrule b on a.foperationruleid = b.fid");
        querySql.append(" where a.fbizappid in ('").append(authorizedAppId).append("')");
        querySql.append(" and a.fentitytypeid in ('").append(entNumStr).append("')");
        try (DataSet dataSet = DB.queryDataSet((String)"AppendPermByAppEntNumMapAuthorizeUtil#paramMap_t_perm_operationruleobj_1", (DBRoute)DBRoute.basedata, (String)querySql.toString());){
            while (dataSet.hasNext()) {
                row = dataSet.next();
                Object entNum = row.get("fentitytypeid");
                String oldObjId = row.getString("fid");
                String fopratonruleid = "";
                String fispublic = row.getString("fispublic");
                fopratonruleid = Objects.equals("1", fispublic) ? row.getString("foperationruleid") : appidEntnumFopratonruleidMap.get(newAppId + "|" + entNum);
                if (StringUtils.isEmpty((String)fopratonruleid)) continue;
                need2AppendAuthList.add(fopratonruleid + "|" + row.get("fseq") + "|" + entNum + "|" + row.get("fobjenabled") + "|" + newAppId);
                String newObjId = DB.genStringId((String)"t_perm_operationruleobj");
                oldObjId2NewObjIdMap.computeIfAbsent(oldObjId, k -> new HashMap(8)).put(newAppId + "|" + entNum, newObjId);
                newObjIdList.add(newObjId);
            }
        }
        querySql.setLength(0);
        querySql.append("select fid, foperationruleid, fseq, fentitytypeid, fobjenabled, fbizappid from t_perm_operationruleobj ");
        querySql.append(" where fbizappid in ('").append(newAppId).append("')");
        querySql.append(" and fentitytypeid in ('").append(entNumStr).append("')");
        var10_10 = null;
        try (DataSet ds = DB.queryDataSet((String)"AppendPermByAppEntNumMapAuthorizeUtil#paramMap_t_perm_operationruleobj_2", (DBRoute)DBRoute.basedata, (String)querySql.toString());){
            while (ds.hasNext()) {
                row = ds.next();
                need2AppendAuthList.remove(row.get("foperationruleid") + "|" + row.get("fseq") + "|" + row.get("fentitytypeid") + "|" + row.get("fobjenabled") + "|" + row.get("fbizappid"));
            }
        }
        catch (Throwable throwable) {
            var10_10 = throwable;
            throw throwable;
        }
        if (null == need2AppendAuthList || need2AppendAuthList.isEmpty()) {
            return map;
        }
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>(10);
        int index = 0;
        for (String need2AppendAuth : need2AppendAuthList) {
            String[] split;
            if (StringUtils.isEmpty((String)need2AppendAuth) || null == (split = need2AppendAuth.split("\\|")) || !Objects.equals(5, split.length)) continue;
            Object[] params = new Object[]{newObjIdList.get(index++), split[0], Long.valueOf(split[1]), split[2], split[3], split[4]};
            insertParams.add(params);
        }
        map.put("paramList_t_perm_operationruleobj", insertParams);
        map.put("oldObjId2NewObjIdMap", oldObjId2NewObjIdMap);
        logger.debug("oldObjId2NewObjIdMap:{}", (Object)JSON.toJSONString(oldObjId2NewObjIdMap));
        return map;
    }

    private static Map<String, Object> paramMap_t_perm_operationrule(String newAppId, String entNumStr, String authorizedAppId) {
        Row row;
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("paramList_t_perm_operationrule", new ArrayList(1));
        map.put("paramList_t_perm_operationrule_l", new ArrayList(1));
        HashMap<String, String> appidEntnumFopratonruleidMap = new HashMap<String, String>(8);
        map.put("appidEntnumFopratonruleidMap", appidEntnumFopratonruleidMap);
        HashSet<String> need2AppendAuthSet = new HashSet<String>(8);
        StringBuilder querySql = new StringBuilder();
        querySql.append("select fid, fenabled, foperationtype, fentitytypeid, fispublic, fbizappid, fispreset, frule, foperationkey, fname, fdescription from t_perm_operationrule ");
        querySql.append(" where fbizappid in ('").append(authorizedAppId).append("')");
        querySql.append(" and fentitytypeid in ('").append(entNumStr).append("')");
        try (DataSet dataSet = DB.queryDataSet((String)"AppendPermByAppEntNumMapAuthorizeUtil#paramMap_t_perm_operationrule_1", (DBRoute)DBRoute.basedata, (String)querySql.toString());){
            while (dataSet.hasNext()) {
                row = dataSet.next();
                need2AppendAuthSet.add(row.get("fenabled") + "|" + row.get("foperationtype") + "|" + row.get("fentitytypeid") + "|" + row.get("fispublic") + "|" + newAppId + "|" + row.get("fispreset") + "|" + row.get("frule") + "|" + row.get("foperationkey") + "|" + row.get("fname") + "|" + (StringUtils.isEmpty((String)row.getString("fdescription")) ? " " : row.getString("fdescription")));
            }
        }
        querySql.setLength(0);
        querySql.append("select fid, fenabled, foperationtype, fentitytypeid, fispublic, fbizappid, fispreset, frule, foperationkey, fname, fdescription from t_perm_operationrule ");
        querySql.append(" where fbizappid in ('").append(newAppId).append("')");
        querySql.append(" and fentitytypeid in ('").append(entNumStr).append("')");
        var8_8 = null;
        try (DataSet ds = DB.queryDataSet((String)"AppendPermByAppEntNumMapAuthorizeUtil#paramMap_t_perm_operationrule_2", (DBRoute)DBRoute.basedata, (String)querySql.toString());){
            while (ds.hasNext()) {
                row = ds.next();
                need2AppendAuthSet.remove(row.get("fenabled") + "|" + row.get("foperationtype") + "|" + row.get("fentitytypeid") + "|" + row.get("fispublic") + "|" + row.get("fbizappid") + "|" + row.get("fispreset") + "|" + row.get("frule") + "|" + row.get("foperationkey") + "|" + row.get("fname") + "|" + (StringUtils.isEmpty((String)row.getString("fdescription")) ? " " : row.getString("fdescription")));
            }
        }
        catch (Throwable row2) {
            var8_8 = row2;
            throw row2;
        }
        if (null == need2AppendAuthSet || need2AppendAuthSet.isEmpty()) {
            return map;
        }
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>(10);
        ArrayList<Object[]> insertLParams = new ArrayList<Object[]>(10);
        String[] ids = DB.genStringIds((String)"t_perm_operationrule", (int)need2AppendAuthSet.size());
        String[] pkids = DB.genStringIds((String)"t_perm_operationrule_l", (int)need2AppendAuthSet.size());
        int index = 0;
        int pkidsIndex = 0;
        for (String need2AppendAuth : need2AppendAuthSet) {
            String[] split;
            if (StringUtils.isEmpty((String)need2AppendAuth) || null == (split = need2AppendAuth.split("\\|")) || !Objects.equals(10, split.length)) continue;
            Object[] params = new Object[]{ids[index++], split[0], split[1], split[2], split[3], split[4], split[5], split[6], split[7], split[8], split[9]};
            insertParams.add(params);
            appidEntnumFopratonruleidMap.put(params[5] + "|" + params[3], String.valueOf(params[0]));
            insertLParams.add(new Object[]{pkids[pkidsIndex++], params[0], "zh_CN", params[9], " "});
        }
        map.put("paramList_t_perm_operationrule", insertParams);
        map.put("paramList_t_perm_operationrule_l", insertLParams);
        map.put("appidEntnumFopratonruleidMap", appidEntnumFopratonruleidMap);
        return map;
    }

    private static void DBAppendPermForRoleDr(Map<String, List<Object[]>> roleDrInsertParamMap) {
        if (null == roleDrInsertParamMap || roleDrInsertParamMap.isEmpty()) {
            return;
        }
        boolean hasEnableRoleDataRuleNewModel = AppendPermByAppEntNumMapAuthorizeUtil.isHasEnableRoleDataRuleNewModel();
        if (hasEnableRoleDataRuleNewModel) {
            List<Object[]> paramList_t_perm_roledatarule_prop;
            List<Object[]> paramList_t_perm_roledatarule = roleDrInsertParamMap.get("paramList_t_perm_roledatarule");
            if (null != paramList_t_perm_roledatarule && !paramList_t_perm_roledatarule.isEmpty()) {
                StringBuilder insertSql = new StringBuilder();
                insertSql.append("INSERT INTO t_perm_roledatarule ");
                insertSql.append(" (fid,froleid,fappid,fentitynum,fpermitemid,fdataruleid,fcreatorid,fcreatetime) ");
                insertSql.append(" VALUES(?, ?, ?, ?, ?, ?, ?, ?);");
                DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql.toString(), paramList_t_perm_roledatarule);
            }
            if (null != (paramList_t_perm_roledatarule_prop = roleDrInsertParamMap.get("paramList_t_perm_roledatarule_prop")) && !paramList_t_perm_roledatarule_prop.isEmpty()) {
                StringBuilder insertSql = new StringBuilder();
                insertSql.append("INSERT INTO t_perm_roledatarule_prop ");
                insertSql.append(" (fid,froleid,fappid,fentitynum,fpropkey,fpropentnum,fdataruleid,fcreatorid,fcreatetime) ");
                insertSql.append(" VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?);");
                DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql.toString(), paramList_t_perm_roledatarule_prop);
            }
        } else {
            List<Object[]> paramList_t_perm_datarule_prop;
            List<Object[]> paramList_t_perm_datarule_entry;
            List<Object[]> paramList_t_perm_datarule_l;
            List<Object[]> paramList_t_perm_datarule;
            List<Object[]> paramList_t_perm_datarules_entry = roleDrInsertParamMap.get("paramList_t_perm_datarules_entry");
            if (null != paramList_t_perm_datarules_entry && !paramList_t_perm_datarules_entry.isEmpty()) {
                StringBuilder insertSql = new StringBuilder();
                insertSql.append("INSERT INTO t_perm_datarules_entry ");
                insertSql.append(" (fentryid, fid, fseq, fbizappid, fentitynum, fdataruleid) ");
                insertSql.append(" VALUES(?, ?, ?, ?, ?, ?);");
                DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql.toString(), paramList_t_perm_datarules_entry);
            }
            if (null != (paramList_t_perm_datarule = roleDrInsertParamMap.get("paramList_t_perm_datarule")) && !paramList_t_perm_datarule.isEmpty()) {
                StringBuilder insertSql = new StringBuilder();
                insertSql.append("INSERT INTO t_perm_datarule ");
                insertSql.append(" (fid, fmasterid, fnumber, fbizappid, fentitynum, frule, fisdetail, fcreatetime, fcreatorid, fmodifytime, fmodifierid, fstatus, fenable, fdescription, frule_tag, fname, fapplyscope, fcloudid) ");
                insertSql.append(" VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);");
                DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql.toString(), paramList_t_perm_datarule);
            }
            if (null != (paramList_t_perm_datarule_l = roleDrInsertParamMap.get("paramList_t_perm_datarule_l")) && !paramList_t_perm_datarule_l.isEmpty()) {
                StringBuilder insertSql = new StringBuilder();
                insertSql.append("INSERT INTO t_perm_datarule_l ");
                insertSql.append(" (fid, flocaleid, fname, fdescription, fpkid) ");
                insertSql.append(" VALUES(?, ?, ?, ?, ?);");
                DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql.toString(), paramList_t_perm_datarule_l);
            }
            if (null != (paramList_t_perm_datarule_entry = roleDrInsertParamMap.get("paramList_t_perm_datarule_entry")) && !paramList_t_perm_datarule_entry.isEmpty()) {
                StringBuilder insertSql = new StringBuilder();
                insertSql.append("INSERT INTO t_perm_datarule_entry ");
                insertSql.append(" (fentryid, fid, fseq, fpermitemid, fopkey, foptype, fdataruleid) ");
                insertSql.append(" VALUES(?, ?, ?, ?, ?, ?, ?);");
                DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql.toString(), paramList_t_perm_datarule_entry);
            }
            if (null != (paramList_t_perm_datarule_prop = roleDrInsertParamMap.get("paramList_t_perm_datarule_prop")) && !paramList_t_perm_datarule_prop.isEmpty()) {
                StringBuilder insertSql = new StringBuilder();
                insertSql.append("INSERT INTO t_perm_datarule_prop ");
                insertSql.append(" (fid, fentryid, fpropkey, fdataruleid, fpropentnum, fseq) ");
                insertSql.append(" VALUES(?, ?, ?, ?, ?, ?);");
                DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql.toString(), paramList_t_perm_datarule_prop);
            }
        }
    }

    private static boolean isHasEnableRoleDataRuleNewModel() {
        try {
            return PermCommonUtil.hasEnableRoleDataRuleNewModel();
        }
        catch (Exception e) {
            logger.error("AppendPermByAppEntNumMapAuthorizeUtil.isHasEnableRoleDataRuleNewModel error.", (Throwable)e);
            return false;
        }
    }

    private static Map<String, List<Object[]>> appendPermForRoleDr(String newAppId, String entNumStr, String authorizedAppId, boolean hasEnableRoleDataRuleNewModel) {
        if (hasEnableRoleDataRuleNewModel) {
            Map<String, List<Object[]>> paramMap = AppendPermByAppEntNumMapAuthorizeUtil.paramMap_roleDataRuleNewModel(newAppId, entNumStr, authorizedAppId);
            return paramMap;
        }
        HashMap<String, List<Object[]>> map = new HashMap<String, List<Object[]>>(8);
        Map<String, Object> paramMap_t_perm_datarules_entry = AppendPermByAppEntNumMapAuthorizeUtil.paramMap_t_perm_datarules_entry(newAppId, entNumStr, authorizedAppId);
        List paramList_t_perm_datarules_entry = (List)paramMap_t_perm_datarules_entry.get("paramList_t_perm_datarules_entry");
        Map appidEntnumFDataruleidMap = (Map)paramMap_t_perm_datarules_entry.get("appidEntnumFDataruleidMap");
        Map<String, Object> paramMap_t_perm_datarule = AppendPermByAppEntNumMapAuthorizeUtil.paramMap_t_perm_datarule(appidEntnumFDataruleidMap, newAppId, entNumStr, authorizedAppId);
        List paramList_t_perm_datarule = (List)paramMap_t_perm_datarule.get("paramList_t_perm_datarule");
        List paramList_t_perm_datarule_l = (List)paramMap_t_perm_datarule.get("paramList_t_perm_datarule_l");
        Map<String, Object> paramMap_t_perm_datarule_entry = AppendPermByAppEntNumMapAuthorizeUtil.paramMap_t_perm_datarule_entry(appidEntnumFDataruleidMap, newAppId, entNumStr, authorizedAppId);
        List paramList_t_perm_datarule_entry = (List)paramMap_t_perm_datarule_entry.get("paramList_t_perm_datarule_entry");
        Map<String, Object> paramMap_t_perm_datarule_prop = AppendPermByAppEntNumMapAuthorizeUtil.paramMap_t_perm_datarule_prop(appidEntnumFDataruleidMap, newAppId, entNumStr, authorizedAppId);
        List paramList_t_perm_datarule_prop = (List)paramMap_t_perm_datarule_prop.get("paramList_t_perm_datarule_prop");
        map.put("paramList_t_perm_datarules_entry", paramList_t_perm_datarules_entry);
        map.put("paramList_t_perm_datarule", paramList_t_perm_datarule);
        map.put("paramList_t_perm_datarule_l", paramList_t_perm_datarule_l);
        map.put("paramList_t_perm_datarule_entry", paramList_t_perm_datarule_entry);
        map.put("paramList_t_perm_datarule_prop", paramList_t_perm_datarule_prop);
        return map;
    }

    private static Map<String, Object> paramMap_t_perm_datarule_prop(Map<String, Long> appidEntnumFDataruleidMap, String newAppId, String entNumStr, String authorizedAppId) {
        Row row;
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("paramList_t_perm_datarule_prop", new ArrayList(1));
        Set dataruleidSet = appidEntnumFDataruleidMap.values().stream().collect(Collectors.toSet());
        if (null == dataruleidSet || dataruleidSet.isEmpty()) {
            return map;
        }
        HashSet<String> need2AppendAuthSet = new HashSet<String>(8);
        StringBuilder querySql = new StringBuilder();
        querySql.append("select a.fid, a.fentryid, a.fpropkey, a.fdataruleid, a.fpropentnum, a.fseq, b.fbizappid, b.fentitynum  from t_perm_datarule_prop a ");
        querySql.append(" inner join t_perm_datarule b on a.fid = b.fid  ");
        querySql.append("  where b.fbizappid in ('").append(authorizedAppId).append("')");
        querySql.append("  and b.fentitynum in ('").append(entNumStr).append("')");
        querySql.append("  and b.fisdetail = '0'");
        try (DataSet dataSet = DB.queryDataSet((String)"AppendPermByAppEntNumMapAuthorizeUtil#paramMap_t_perm_datarule_prop_1", (DBRoute)DBRoute.basedata, (String)querySql.toString());){
            while (dataSet.hasNext()) {
                row = dataSet.next();
                Long dataruleid = appidEntnumFDataruleidMap.get(newAppId + "|" + row.get("fentitynum") + "|" + row.getString("fid"));
                if (null == dataruleid || 0L == dataruleid) continue;
                need2AppendAuthSet.add(dataruleid + "|" + row.get("fpropkey") + "|" + row.get("fdataruleid") + "|" + row.get("fpropentnum") + "|" + row.get("fseq") + "|" + row.get("fentitynum"));
            }
        }
        querySql.setLength(0);
        querySql.append("select a.fid, a.fentryid, a.fpropkey, a.fdataruleid, a.fpropentnum, a.fseq, b.fbizappid, b.fentitynum  from t_perm_datarule_prop a ");
        querySql.append(" inner join t_perm_datarule b on a.fid = b.fid ");
        querySql.append("  where b.fbizappid in ('").append(newAppId).append("')");
        querySql.append("  and b.fentitynum in ('").append(entNumStr).append("')");
        querySql.append("  and b.fisdetail = '0'");
        var9_9 = null;
        try (DataSet ds = DB.queryDataSet((String)"AppendPermByAppEntNumMapAuthorizeUtil#paramMap_t_perm_datarule_prop_2", (DBRoute)DBRoute.basedata, (String)querySql.toString());){
            while (ds.hasNext()) {
                row = ds.next();
                need2AppendAuthSet.remove(row.get("fid") + "|" + row.get("fpropkey") + "|" + row.get("fdataruleid") + "|" + row.get("fpropentnum") + "|" + row.get("fseq") + "|" + row.get("fentitynum"));
            }
        }
        catch (Throwable row2) {
            var9_9 = row2;
            throw row2;
        }
        if (null == need2AppendAuthSet || need2AppendAuthSet.isEmpty()) {
            return map;
        }
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>(10);
        int size = need2AppendAuthSet.size();
        long[] fentryids = DB.genLongIds((String)"t_perm_datarule_prop", (int)size);
        int fentryidsIdx = 0;
        for (String need2AppendAuth : need2AppendAuthSet) {
            String[] split;
            if (StringUtils.isEmpty((String)need2AppendAuth) || null == (split = need2AppendAuth.split("\\|", 6)) || !Objects.equals(6, split.length)) continue;
            Object[] params = new Object[]{Long.valueOf(split[0]), fentryids[fentryidsIdx++], split[1], Long.valueOf(split[2]), split[3], Long.valueOf(split[4])};
            insertParams.add(params);
        }
        map.put("paramList_t_perm_datarule_prop", insertParams);
        return map;
    }

    private static Map<String, Object> paramMap_t_perm_datarule_entry(Map<String, Long> appidEntnumFDataruleidMap, String newAppId, String entNumStr, String authorizedAppId) {
        Row row;
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("paramList_t_perm_datarule_entry", new ArrayList(1));
        Set dataruleidSet = appidEntnumFDataruleidMap.values().stream().collect(Collectors.toSet());
        if (null == dataruleidSet || dataruleidSet.isEmpty()) {
            return map;
        }
        HashSet<String> need2AppendAuthSet = new HashSet<String>(8);
        StringBuilder querySql = new StringBuilder();
        querySql.append("select a.fentryid, a.fid, a.fseq, a.fpermitemid, a.fopkey, a.foptype, a.fdataruleid, b.fbizappid, b.fentitynum ");
        querySql.append(" from t_perm_datarule_entry a ");
        querySql.append(" inner join t_perm_datarule b on a.fid = b.fid  ");
        querySql.append("  where b.fbizappid in ('").append(authorizedAppId).append("')");
        querySql.append("  and b.fentitynum in ('").append(entNumStr).append("')");
        querySql.append("  and b.fisdetail = '0'");
        try (DataSet dataSet = DB.queryDataSet((String)"AppendPermByAppEntNumMapAuthorizeUtil#paramMap_t_perm_datarule_entry_1", (DBRoute)DBRoute.basedata, (String)querySql.toString());){
            while (dataSet.hasNext()) {
                row = dataSet.next();
                Long dataruleid = appidEntnumFDataruleidMap.get(newAppId + "|" + row.get("fentitynum") + "|" + row.getString("fid"));
                if (null == dataruleid || 0L == dataruleid) continue;
                need2AppendAuthSet.add(dataruleid + "|" + row.get("fseq") + "|" + row.get("fpermitemid") + "|" + row.get("fopkey") + "|" + row.get("foptype") + "|" + row.get("fdataruleid") + "|" + row.get("fentitynum"));
            }
        }
        querySql.setLength(0);
        querySql.append("select a.fentryid, a.fid, a.fseq, a.fpermitemid, a.fopkey, a.foptype, a.fdataruleid, b.fbizappid, b.fentitynum ");
        querySql.append(" from t_perm_datarule_entry a ");
        querySql.append(" inner join t_perm_datarule b on a.fid = b.fid  ");
        querySql.append("  where b.fbizappid in ('").append(newAppId).append("')");
        querySql.append("  and b.fentitynum in ('").append(entNumStr).append("')");
        querySql.append("  and b.fisdetail = '0'");
        var9_9 = null;
        try (DataSet ds = DB.queryDataSet((String)"AppendPermByAppEntNumMapAuthorizeUtil#paramMap_t_perm_datarule_entry_2", (DBRoute)DBRoute.basedata, (String)querySql.toString());){
            while (ds.hasNext()) {
                row = ds.next();
                need2AppendAuthSet.remove(row.get("fid") + "|" + row.get("fseq") + "|" + row.get("fpermitemid") + "|" + row.get("fopkey") + "|" + row.get("foptype") + "|" + row.get("fdataruleid") + "|" + row.get("fentitynum"));
            }
        }
        catch (Throwable row2) {
            var9_9 = row2;
            throw row2;
        }
        if (null == need2AppendAuthSet || need2AppendAuthSet.isEmpty()) {
            return map;
        }
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>(10);
        int size = need2AppendAuthSet.size();
        long[] fentryids = DB.genLongIds((String)"t_perm_datarule_entry", (int)size);
        int fentryidsIdx = 0;
        for (String need2AppendAuth : need2AppendAuthSet) {
            String[] split;
            if (StringUtils.isEmpty((String)need2AppendAuth) || null == (split = need2AppendAuth.split("\\|", 7)) || !Objects.equals(7, split.length)) continue;
            Object[] params = new Object[]{fentryids[fentryidsIdx++], Long.valueOf(split[0]), Long.valueOf(split[1]), split[2], split[3], split[4], Long.valueOf(split[5])};
            insertParams.add(params);
        }
        map.put("paramList_t_perm_datarule_entry", insertParams);
        return map;
    }

    @Deprecated
    private static Map<String, Object> paramMap_t_perm_datarule(Map<String, Long> appidEntnumFDataruleidMap, String newAppId, String entNumStr, String authorizedAppId) {
        Row row;
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("paramList_t_perm_datarule", new ArrayList(1));
        map.put("paramList_t_perm_datarule_l", new ArrayList(1));
        HashSet<String> need2AppendAuthSet = new HashSet<String>(8);
        StringBuilder querySql = new StringBuilder();
        querySql.append("select fid, fmasterid, fnumber, fbizappid, fentitynum, frule, fisdetail, fcreatetime, fcreatorid, fmodifytime, fmodifierid, fstatus, fenable, fdescription, frule_tag, fname, fapplyscope, fcloudid from t_perm_datarule ");
        querySql.append(" where fbizappid in ('").append(authorizedAppId).append("')");
        querySql.append(" and fentitynum in ('").append(entNumStr).append("')");
        querySql.append(" and fisdetail = '0' ");
        try (DataSet dataSet = DB.queryDataSet((String)"AppendPermByAppEntNumMapAuthorizeUtil#paramMap_t_perm_datarule_1", (DBRoute)DBRoute.basedata, (String)querySql.toString());){
            while (dataSet.hasNext()) {
                row = dataSet.next();
                String fentitynum = row.getString("fentitynum");
                Long fdataruleid = appidEntnumFDataruleidMap.get(newAppId + "|" + fentitynum + "|" + row.getString("fid"));
                if (null == fdataruleid) continue;
                String newFnumber = row.getString("fnumber");
                need2AppendAuthSet.add(fdataruleid + "|" + row.get("fmasterid") + "|" + newFnumber + "|" + newAppId + "|" + fentitynum + "|" + row.get("frule") + "|" + row.get("fisdetail") + "|" + (StringUtils.isEmpty((String)row.getString("fcreatetime")) ? "" : row.getString("fcreatetime").substring(0, 19)) + "|" + row.get("fcreatorid") + "|" + (StringUtils.isEmpty((String)row.getString("fmodifytime")) ? "" : row.getString("fmodifytime").substring(0, 19)) + "|" + row.get("fmodifierid") + "|" + row.get("fstatus") + "|" + row.get("fenable") + "|" + row.get("fdescription") + "|" + row.get("frule_tag") + "|" + newFnumber + "|" + row.get("fapplyscope") + "|" + row.get("fcloudid"));
            }
        }
        querySql.setLength(0);
        querySql.append("select fid, fmasterid, fnumber, fbizappid, fentitynum, frule, fisdetail, fcreatetime, fcreatorid, fmodifytime, fmodifierid, fstatus, fenable, fdescription, frule_tag, fname, fapplyscope, fcloudid from t_perm_datarule ");
        querySql.append(" where fbizappid in ('").append(newAppId).append("')");
        querySql.append(" and fentitynum in ('").append(entNumStr).append("')");
        querySql.append(" and fisdetail = '0' ");
        var8_8 = null;
        try (DataSet ds = DB.queryDataSet((String)"AppendPermByAppEntNumMapAuthorizeUtil#paramMap_t_perm_datarule_2", (DBRoute)DBRoute.basedata, (String)querySql.toString());){
            while (ds.hasNext()) {
                row = ds.next();
                need2AppendAuthSet.remove(row.get("fid") + "|" + row.get("fmasterid") + "|" + row.get("fnumber") + "|" + row.get("fbizappid") + "|" + row.get("fentitynum") + "|" + row.get("frule") + "|" + row.get("fisdetail") + "|" + (StringUtils.isEmpty((String)row.getString("fcreatetime")) ? "" : row.getString("fcreatetime").substring(0, 19)) + "|" + row.get("fcreatorid") + "|" + (StringUtils.isEmpty((String)row.getString("fmodifytime")) ? "" : row.getString("fmodifytime").substring(0, 19)) + "|" + row.get("fmodifierid") + "|" + row.get("fstatus") + "|" + row.get("fenable") + "|" + row.get("fdescription") + "|" + row.get("frule_tag") + "|" + row.get("fname") + "|" + row.get("fapplyscope") + "|" + row.get("fcloudid"));
            }
        }
        catch (Throwable row2) {
            var8_8 = row2;
            throw row2;
        }
        if (null == need2AppendAuthSet || need2AppendAuthSet.isEmpty()) {
            return map;
        }
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>(10);
        ArrayList<Object[]> insertLParams = new ArrayList<Object[]>(10);
        String localName = RequestContext.get().getLang().name();
        String[] fpkids = DB.genStringIds((String)"t_perm_datarule_l", (int)need2AppendAuthSet.size());
        int fpkidsIdx = 0;
        for (String need2AppendAuth : need2AppendAuthSet) {
            String[] split;
            if (StringUtils.isEmpty((String)need2AppendAuth) || null == (split = need2AppendAuth.split("\\|", 18)) || !Objects.equals(18, split.length)) continue;
            Object[] params = new Object[]{Long.valueOf(split[0]), Long.valueOf(split[1]), split[2], split[3], split[4], split[5], split[6], StringUtils.isEmpty((String)split[7]) ? null : DateUtil.toDate(split[7], "yyyy-MM-dd HH:mm:ss"), Long.valueOf(split[8]), StringUtils.isEmpty((String)split[9]) ? null : DateUtil.toDate(split[9], "yyyy-MM-dd HH:mm:ss"), Long.valueOf(split[10]), split[11], split[12], split[13], split[14], split[15], split[16], split[17]};
            insertParams.add(params);
            insertLParams.add(new Object[]{Long.valueOf(split[0]), localName, split[2], " ", fpkids[fpkidsIdx++]});
        }
        map.put("paramList_t_perm_datarule", insertParams);
        map.put("paramList_t_perm_datarule_l", insertLParams);
        return map;
    }

    private static Map<String, List<Object[]>> paramMap_roleDataRuleNewModel(String newAppId, String entNumStr, String authorizedAppId) {
        HashMap<String, List<Object[]>> result = new HashMap<String, List<Object[]>>(8);
        HashMap<String, Object[]> insertRoleDataRuleInfo = new HashMap<String, Object[]>(8);
        StringBuilder querySql = new StringBuilder();
        querySql.append("select fid,froleid,fappid,fentitynum,fpermitemid,fdataruleid from t_perm_roledatarule ");
        querySql.append(" where fappid = ? and fentitynum = ? ");
        DataSet dataSet = DB.queryDataSet((String)"AppendPermByAppEntNumMapAuthorizeUtil#paramMap_roleDataRuleNewModel", (DBRoute)DBRoute.permission, (String)querySql.toString(), (Object[])new Object[]{authorizedAppId, entNumStr});
        Object object = null;
        try {
            long curUserId = RequestContext.get().getCurrUserId();
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long newPkId = DB.genLongId((String)"t_perm_roledatarule");
                String roleId = row.getString("froleid");
                String entNum = row.getString("fentitynum");
                String permItemId = row.getString("fpermitemid");
                Long dataRuleId = row.getLong("fdataruleid");
                Long creatorId = curUserId;
                Date now = new Date();
                String uniqueStr = new StringBuilder(50).append(roleId).append("|").append(newAppId).append("|").append(entNum).append("|").append(permItemId).toString();
                Object[] paramArr = new Object[]{newPkId, roleId, newAppId, entNum, permItemId, dataRuleId, creatorId, now};
                insertRoleDataRuleInfo.put(uniqueStr, paramArr);
            }
        }
        catch (Throwable curUserId) {
            object = curUserId;
            throw curUserId;
        }
        finally {
            if (dataSet != null) {
                if (object != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable curUserId) {
                        ((Throwable)object).addSuppressed(curUserId);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        dataSet = DB.queryDataSet((String)"AppendPermByAppEntNumMapAuthorizeUtil#paramMap_roleDataRuleNewModel", (DBRoute)DBRoute.permission, (String)querySql.toString(), (Object[])new Object[]{newAppId, entNumStr});
        object = null;
        try {
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                String roleId = row.getString("froleid");
                String entNum = row.getString("fentitynum");
                String permItemId = row.getString("fpermitemid");
                String uniqueStr = new StringBuilder(50).append(roleId).append("|").append(newAppId).append("|").append(entNum).append("|").append(permItemId).toString();
                insertRoleDataRuleInfo.remove(uniqueStr);
            }
        }
        catch (Throwable row) {
            object = row;
            throw row;
        }
        finally {
            if (dataSet != null) {
                if (object != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable row) {
                        ((Throwable)object).addSuppressed(row);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        ArrayList<Object[]> t_perm_datarule_insertParams = new ArrayList<Object[]>(8);
        for (Object[] paramArr : insertRoleDataRuleInfo.values()) {
            t_perm_datarule_insertParams.add(paramArr);
        }
        result.put("paramList_t_perm_roledatarule", t_perm_datarule_insertParams);
        HashMap<String, Object[]> insertRoleDataRulePropInfo = new HashMap<String, Object[]>(8);
        querySql.setLength(0);
        querySql.append("select fid,froleid,fappid,fentitynum,fpropkey,fpropentnum,fdataruleid from t_perm_roledatarule_prop ");
        querySql.append(" where fappid = ? and fentitynum = ? ");
        DataSet dataSet2 = DB.queryDataSet((String)"AppendPermByAppEntNumMapAuthorizeUtil#paramMap_roleDataRuleNewModel", (DBRoute)DBRoute.permission, (String)querySql.toString(), (Object[])new Object[]{authorizedAppId, entNumStr});
        Object object2 = null;
        try {
            long curUserId = RequestContext.get().getCurrUserId();
            while (dataSet2.hasNext()) {
                Row row = dataSet2.next();
                Long newPkId = DB.genLongId((String)"t_perm_roledatarule_prop");
                String roleId = row.getString("froleid");
                String entNum = row.getString("fentitynum");
                String propKey = row.getString("fpropkey");
                String propEntNum = row.getString("fpropentnum");
                Long dataRuleId = row.getLong("fdataruleid");
                Long creatorId = curUserId;
                Date now = new Date();
                String uniqueStr = new StringBuilder(50).append(roleId).append("|").append(newAppId).append("|").append(entNum).append("|").append(propKey).toString();
                Object[] paramArr = new Object[]{newPkId, roleId, newAppId, entNum, propKey, propEntNum, dataRuleId, creatorId, now};
                insertRoleDataRulePropInfo.put(uniqueStr, paramArr);
            }
        }
        catch (Throwable curUserId) {
            object2 = curUserId;
            throw curUserId;
        }
        finally {
            if (dataSet2 != null) {
                if (object2 != null) {
                    try {
                        dataSet2.close();
                    }
                    catch (Throwable curUserId) {
                        ((Throwable)object2).addSuppressed(curUserId);
                    }
                } else {
                    dataSet2.close();
                }
            }
        }
        dataSet2 = DB.queryDataSet((String)"AppendPermByAppEntNumMapAuthorizeUtil#paramMap_roleDataRuleNewModel", (DBRoute)DBRoute.permission, (String)querySql.toString(), (Object[])new Object[]{newAppId, entNumStr});
        object2 = null;
        try {
            while (dataSet2.hasNext()) {
                Row row = dataSet2.next();
                String roleId = row.getString("froleid");
                String entNum = row.getString("fentitynum");
                String propKey = row.getString("fpropkey");
                String uniqueStr = new StringBuilder(50).append(roleId).append("|").append(newAppId).append("|").append(entNum).append("|").append(propKey).toString();
                insertRoleDataRulePropInfo.remove(uniqueStr);
            }
        }
        catch (Throwable row) {
            object2 = row;
            throw row;
        }
        finally {
            if (dataSet2 != null) {
                if (object2 != null) {
                    try {
                        dataSet2.close();
                    }
                    catch (Throwable row) {
                        ((Throwable)object2).addSuppressed(row);
                    }
                } else {
                    dataSet2.close();
                }
            }
        }
        ArrayList<Object[]> t_perm_datarule_prop_insertParams = new ArrayList<Object[]>(8);
        for (Object[] paramArr : insertRoleDataRulePropInfo.values()) {
            t_perm_datarule_prop_insertParams.add(paramArr);
        }
        result.put("paramList_t_perm_roledatarule_prop", t_perm_datarule_prop_insertParams);
        return result;
    }

    @Deprecated
    private static Map<String, Object> paramMap_t_perm_datarules_entry(String newAppId, String entNumStr, String authorizedAppId) {
        Row row;
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("paramList_t_perm_datarules_entry", new ArrayList(1));
        HashMap<String, Long> appidEntnumFDataruleidMap = new HashMap<String, Long>(8);
        map.put("appidEntnumFDataruleidMap", appidEntnumFDataruleidMap);
        HashMap<String, Long> appentfid2newolddataruleidMap = new HashMap<String, Long>(8);
        HashSet<String> need2AppendAuthSet = new HashSet<String>(8);
        StringBuilder querySql = new StringBuilder();
        querySql.append("select fentryid, fid, fseq, fbizappid, fentitynum, fdataruleid from t_perm_datarules_entry ");
        querySql.append(" where fbizappid in ('").append(authorizedAppId).append("')");
        querySql.append(" and fentitynum in ('").append(entNumStr).append("')");
        try (DataSet dataSet = DB.queryDataSet((String)"AppendPermByAppEntNumMapAuthorizeUtil#paramList_t_perm_datarules_entry_1", (DBRoute)DBRoute.basedata, (String)querySql.toString());){
            while (dataSet.hasNext()) {
                row = dataSet.next();
                need2AppendAuthSet.add(row.get("fid") + "|" + row.get("fseq") + "|" + newAppId + "|" + row.get("fentitynum"));
                appentfid2newolddataruleidMap.put(newAppId + "|" + row.get("fentitynum") + "|" + row.get("fid"), row.getLong("fdataruleid"));
                appidEntnumFDataruleidMap.put(newAppId + "|" + row.get("fentitynum") + "|" + row.get("fdataruleid"), DB.genLongId((String)"t_perm_datarule"));
            }
        }
        querySql.setLength(0);
        querySql.append("select fentryid, fid, fseq, fbizappid, fentitynum, fdataruleid from t_perm_datarules_entry ");
        querySql.append(" where fbizappid in ('").append(newAppId).append("')");
        querySql.append(" and fentitynum in ('").append(entNumStr).append("')");
        var9_9 = null;
        try (DataSet ds = DB.queryDataSet((String)"AppendPermByAppEntNumMapAuthorizeUtil#paramList_t_perm_datarules_entry_2", (DBRoute)DBRoute.basedata, (String)querySql.toString());){
            while (ds.hasNext()) {
                row = ds.next();
                need2AppendAuthSet.remove(row.get("fid") + "|" + row.get("fseq") + "|" + row.get("fbizappid") + "|" + row.get("fentitynum"));
            }
        }
        catch (Throwable row2) {
            var9_9 = row2;
            throw row2;
        }
        if (null == need2AppendAuthSet || need2AppendAuthSet.isEmpty()) {
            return map;
        }
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>(10);
        int size = need2AppendAuthSet.size();
        long[] fentryids = DB.genLongIds((String)"t_perm_datarules_entry", (int)size);
        int fentryidsIdx = 0;
        boolean fdataruleIdx = false;
        for (String need2AppendAuth : need2AppendAuthSet) {
            String[] split;
            if (StringUtils.isEmpty((String)need2AppendAuth) || null == (split = need2AppendAuth.split("\\|")) || !Objects.equals(4, split.length)) continue;
            Object[] params = new Object[6];
            params[0] = fentryids[fentryidsIdx++];
            params[1] = Long.valueOf(split[0]);
            params[2] = Long.valueOf(split[1]);
            params[3] = split[2];
            params[4] = split[3];
            Long oldDataruleid = (Long)appentfid2newolddataruleidMap.get(params[3] + "|" + params[4] + "|" + params[1]);
            params[5] = appidEntnumFDataruleidMap.get(params[3] + "|" + params[4] + "|" + oldDataruleid);
            insertParams.add(params);
        }
        map.put("paramList_t_perm_datarules_entry", insertParams);
        map.put("appidEntnumFDataruleidMap", appidEntnumFDataruleidMap);
        return map;
    }

    private static void DBAppendPermForUserDirectDrPr(List<Object[]> paramList) {
        if (null != paramList && !paramList.isEmpty()) {
            StringBuilder insertSql = new StringBuilder();
            insertSql.append("INSERT INTO t_perm_userdatarule_prop ");
            insertSql.append(" (fid, fuserid, fappid, fentitynum, fpropkey, fpropentnum, fdataruleid, fdimid, fisincludesub, fdimtype, fcreatetime, fcreatorid, fmodifytime, fmodifierid)  ");
            insertSql.append(" VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);");
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql.toString(), paramList);
        }
    }

    private static List<Object[]> appendPermForUserDirectDrPr(String newAppId, String entNumStr, String authorizedAppId) {
        Row row;
        HashSet<String> need2AppendAuthSet = new HashSet<String>(8);
        StringBuilder querySql = new StringBuilder();
        querySql.append("select fid, fuserid, fappid, fentitynum, fpropkey, fpropentnum, fdataruleid, fdimid, fisincludesub, fdimtype, fcreatetime, fcreatorid, fmodifytime, fmodifierid from t_perm_userdatarule_prop ");
        querySql.append(" where fappid in ('").append(authorizedAppId).append("')");
        querySql.append(" and fentitynum in ('").append(entNumStr).append("')");
        try (DataSet dataSet = DB.queryDataSet((String)"AppendPermByAppEntNumMapAuthorizeUtil#appendPermForUserDirectDrPr_1", (DBRoute)DBRoute.basedata, (String)querySql.toString());){
            while (dataSet.hasNext()) {
                row = dataSet.next();
                need2AppendAuthSet.add(row.get("fuserid") + "|" + newAppId + "|" + row.get("fentitynum") + "|" + row.get("fpropkey") + "|" + row.get("fpropentnum") + "|" + row.get("fdataruleid") + "|" + row.get("fdimid") + "|" + row.get("fisincludesub") + "|" + row.get("fdimtype") + "|" + (StringUtils.isEmpty((String)row.getString("fcreatetime")) ? "" : row.getString("fcreatetime").substring(0, 19)) + "|" + row.get("fcreatorid") + "|" + (StringUtils.isEmpty((String)row.getString("fmodifytime")) ? "" : row.getString("fmodifytime").substring(0, 19)) + "|" + row.get("fmodifierid"));
            }
        }
        querySql.setLength(0);
        querySql.append("select fid, fuserid, fappid, fentitynum, fpropkey, fpropentnum, fdataruleid, fdimid, fisincludesub, fdimtype, fcreatetime, fcreatorid, fmodifytime, fmodifierid from t_perm_userdatarule_prop ");
        querySql.append(" where fappid in ('").append(newAppId).append("')");
        querySql.append(" and fentitynum in ('").append(entNumStr).append("')");
        var6_6 = null;
        try (DataSet ds = DB.queryDataSet((String)"AppendPermByAppEntNumMapAuthorizeUtil#appendPermForUserDirectDrPr_2", (DBRoute)DBRoute.basedata, (String)querySql.toString());){
            while (ds.hasNext()) {
                row = ds.next();
                need2AppendAuthSet.remove(row.get("fuserid") + "|" + row.get("fappid") + "|" + row.get("fentitynum") + "|" + row.get("fpropkey") + "|" + row.get("fpropentnum") + "|" + row.get("fdataruleid") + "|" + row.get("fdimid") + "|" + row.get("fisincludesub") + "|" + row.get("fdimtype") + "|" + (StringUtils.isEmpty((String)row.getString("fcreatetime")) ? "" : row.getString("fcreatetime").substring(0, 19)) + "|" + row.get("fcreatorid") + "|" + (StringUtils.isEmpty((String)row.getString("fmodifytime")) ? "" : row.getString("fmodifytime").substring(0, 19)) + "|" + row.get("fmodifierid"));
            }
        }
        catch (Throwable row2) {
            var6_6 = row2;
            throw row2;
        }
        if (null == need2AppendAuthSet || need2AppendAuthSet.isEmpty()) {
            return new ArrayList<Object[]>(1);
        }
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>(10);
        long[] ids = DB.genLongIds((String)"t_perm_userdatarule_prop", (int)need2AppendAuthSet.size());
        int index = 0;
        for (String need2AppendAuth : need2AppendAuthSet) {
            String[] split;
            if (StringUtils.isEmpty((String)need2AppendAuth) || null == (split = need2AppendAuth.split("\\|")) || !Objects.equals(13, split.length)) continue;
            Object[] params = new Object[]{ids[index++], Long.valueOf(split[0]), split[1], split[2], split[3], split[4], Long.valueOf(split[5]), Long.valueOf(split[6]), split[7], split[8], StringUtils.isEmpty((String)split[9]) ? null : DateUtil.toDate(split[9], "yyyy-MM-dd HH:mm:ss"), Long.valueOf(split[10]), StringUtils.isEmpty((String)split[11]) ? null : DateUtil.toDate(split[11], "yyyy-MM-dd HH:mm:ss"), Long.valueOf(split[12])};
            insertParams.add(params);
        }
        return insertParams;
    }

    private static void DBAppendPermForUserDirectDr(List<Object[]> paramList) {
        if (null != paramList && !paramList.isEmpty()) {
            StringBuilder insertSql = new StringBuilder();
            insertSql.append("INSERT INTO t_perm_userdatarule ");
            insertSql.append(" (fid, fuserid, fappid, fentitynum, fpermitemid, fdataruleid, fdimid, fisincludesub, fdimtype, fcreatetime, fcreatorid, fmodifytime, fmodifierid) ");
            insertSql.append(" VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);");
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql.toString(), paramList);
        }
    }

    private static List<Object[]> appendPermForUserDirectDr(String newAppId, String entNumStr, String authorizedAppId) {
        Row row;
        HashSet<String> need2AppendAuthSet = new HashSet<String>(8);
        StringBuilder querySql = new StringBuilder();
        querySql.append("select fid, fuserid, fappid, fentitynum, fpermitemid, fdataruleid, fdimid, fisincludesub, fdimtype, fcreatetime, fcreatorid, fmodifytime, fmodifierid from t_perm_userdatarule ");
        querySql.append(" where fappid in ('").append(authorizedAppId).append("')");
        querySql.append(" and fentitynum in ('").append(entNumStr).append("')");
        try (DataSet dataSet = DB.queryDataSet((String)"AppendPermByAppEntNumMapAuthorizeUtil#appendPermForUserDirectDr_1", (DBRoute)DBRoute.basedata, (String)querySql.toString());){
            while (dataSet.hasNext()) {
                row = dataSet.next();
                need2AppendAuthSet.add(row.get("fuserid") + "|" + newAppId + "|" + row.get("fentitynum") + "|" + row.get("fpermitemid") + "|" + row.get("fdataruleid") + "|" + row.get("fdimid") + "|" + row.get("fisincludesub") + "|" + row.get("fdimtype") + "|" + (StringUtils.isEmpty((String)row.getString("fcreatetime")) ? "" : row.getString("fcreatetime").substring(0, 19)) + "|" + row.get("fcreatorid") + "|" + (StringUtils.isEmpty((String)row.getString("fmodifytime")) ? "" : row.getString("fmodifytime").substring(0, 19)) + "|" + row.get("fmodifierid"));
            }
        }
        querySql.setLength(0);
        querySql.append("select fid, fuserid, fappid, fentitynum, fpermitemid, fdataruleid, fdimid, fisincludesub, fdimtype, fcreatetime, fcreatorid, fmodifytime, fmodifierid from t_perm_userdatarule ");
        querySql.append(" where fappid in ('").append(newAppId).append("')");
        querySql.append(" and fentitynum in ('").append(entNumStr).append("')");
        var6_6 = null;
        try (DataSet ds = DB.queryDataSet((String)"AppendPermByAppEntNumMapAuthorizeUtil#appendPermForUserDirectDr_2", (DBRoute)DBRoute.basedata, (String)querySql.toString());){
            while (ds.hasNext()) {
                row = ds.next();
                need2AppendAuthSet.remove(row.get("fuserid") + "|" + row.get("fappid") + "|" + row.get("fentitynum") + "|" + row.get("fpermitemid") + "|" + row.get("fdataruleid") + "|" + row.get("fdimid") + "|" + row.get("fisincludesub") + "|" + row.get("fdimtype") + "|" + (StringUtils.isEmpty((String)row.getString("fcreatetime")) ? "" : row.getString("fcreatetime").substring(0, 19)) + "|" + row.get("fcreatorid") + "|" + (StringUtils.isEmpty((String)row.getString("fmodifytime")) ? "" : row.getString("fmodifytime").substring(0, 19)) + "|" + row.get("fmodifierid"));
            }
        }
        catch (Throwable row2) {
            var6_6 = row2;
            throw row2;
        }
        if (null == need2AppendAuthSet || need2AppendAuthSet.isEmpty()) {
            return new ArrayList<Object[]>(1);
        }
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>(10);
        long[] ids = DB.genLongIds((String)"t_perm_userdatarule", (int)need2AppendAuthSet.size());
        int index = 0;
        for (String need2AppendAuth : need2AppendAuthSet) {
            String[] split;
            if (StringUtils.isEmpty((String)need2AppendAuth) || null == (split = need2AppendAuth.split("\\|")) || !Objects.equals(12, split.length)) continue;
            Object[] params = new Object[]{ids[index++], Long.valueOf(split[0]), split[1], split[2], split[3], Long.valueOf(split[4]), Long.valueOf(split[5]), split[6], split[7], StringUtils.isEmpty((String)split[8]) ? null : DateUtil.toDate(split[8], "yyyy-MM-dd HH:mm:ss"), Long.valueOf(split[9]), StringUtils.isEmpty((String)split[10]) ? null : DateUtil.toDate(split[10], "yyyy-MM-dd HH:mm:ss"), Long.valueOf(split[11])};
            insertParams.add(params);
        }
        return insertParams;
    }

    private static void DBAppendPermForFieldPermDetail(List<Object[]> paramList) {
        if (null != paramList && !paramList.isEmpty()) {
            StringBuilder insertSql = new StringBuilder();
            insertSql.append("INSERT INTO t_perm_fieldpermdetail");
            insertSql.append(" (fentryid, fid, fseq, fentitytypeid, ffieldname, fcontrolmode, fbizappid) ");
            insertSql.append(" VALUES(?, ?, ?, ?, ?, ?, ?);");
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql.toString(), paramList);
        }
    }

    private static List<Object[]> appendPermForFieldPermDetail(String newAppId, String entNumStr, String authorizedAppId) {
        Row row;
        HashSet<String> need2AppendAuthSet = new HashSet<String>(8);
        StringBuilder querySql = new StringBuilder();
        querySql.append("select fentryid, fid, fseq, fentitytypeid, ffieldname, fcontrolmode, fbizappid from t_perm_fieldpermdetail ");
        querySql.append(" where fbizappid in ('").append(authorizedAppId).append("')");
        querySql.append(" and fentitytypeid in ('").append(entNumStr).append("')");
        try (DataSet dataSet = DB.queryDataSet((String)"AppendPermByAppEntNumMapAuthorizeUtil#appendPermForFieldPermDetail_1", (DBRoute)DBRoute.basedata, (String)querySql.toString());){
            while (dataSet.hasNext()) {
                row = dataSet.next();
                need2AppendAuthSet.add(row.get("fid") + "|" + row.get("fseq") + "|" + row.get("fentitytypeid") + "|" + row.get("ffieldname") + "|" + row.get("fcontrolmode") + "|" + newAppId);
            }
        }
        querySql.setLength(0);
        querySql.append("select fentryid, fid, fseq, fentitytypeid, ffieldname, fcontrolmode, fbizappid from t_perm_fieldpermdetail ");
        querySql.append(" where fbizappid in ('").append(newAppId).append("')");
        querySql.append(" and fentitytypeid in ('").append(entNumStr).append("')");
        var6_6 = null;
        try (DataSet ds = DB.queryDataSet((String)"AppendPermByAppEntNumMapAuthorizeUtil#appendPermForFieldPermDetail_2", (DBRoute)DBRoute.basedata, (String)querySql.toString());){
            while (ds.hasNext()) {
                row = ds.next();
                need2AppendAuthSet.remove(row.get("fid") + "|" + row.get("fseq") + "|" + row.get("fentitytypeid") + "|" + row.get("ffieldname") + "|" + row.get("fcontrolmode") + "|" + row.get("fbizappid"));
            }
        }
        catch (Throwable row2) {
            var6_6 = row2;
            throw row2;
        }
        if (null == need2AppendAuthSet || need2AppendAuthSet.isEmpty()) {
            return new ArrayList<Object[]>(1);
        }
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>(10);
        String[] entryIds = DB.genStringIds((String)"t_perm_fieldpermdetail", (int)need2AppendAuthSet.size());
        int index = 0;
        for (String need2AppendAuth : need2AppendAuthSet) {
            String[] split;
            if (StringUtils.isEmpty((String)need2AppendAuth) || null == (split = need2AppendAuth.split("\\|")) || !Objects.equals(6, split.length)) continue;
            Object[] params = new Object[]{entryIds[index++], split[0], Long.valueOf(split[1]), split[2], split[3], split[4], split[5]};
            insertParams.add(params);
        }
        return insertParams;
    }

    private static void DBAppendPermForBizRoleDisPerm(List<Object[]> paramList) {
        if (null != paramList && !paramList.isEmpty()) {
            StringBuilder insertSql = new StringBuilder();
            insertSql.append("INSERT INTO t_perm_bizroledisperm");
            insertSql.append(" (fentryid, fid, fseq, fpermitemid, fentitytypeid, fbizappid)");
            insertSql.append(" VALUES(?,?,?,?,?,?);");
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql.toString(), paramList);
        }
    }

    private static List<Object[]> appendPermForBizRoleDisPerm(String newAppId, String entNumStr, String authorizedAppId) {
        Row row;
        HashSet<String> need2AppendAuthSet = new HashSet<String>(8);
        StringBuilder querySql = new StringBuilder();
        querySql.append("select fentryid, fid, fseq, fpermitemid, fentitytypeid, fbizappid from t_perm_bizroledisperm ");
        querySql.append(" where fbizappid in ('").append(authorizedAppId).append("')");
        querySql.append(" and fentitytypeid in ('").append(entNumStr).append("')");
        try (DataSet dataSet = DB.queryDataSet((String)"AppendPermByAppEntNumMapAuthorizeUtil#appendPermForBizRoleDisPerm_1", (DBRoute)DBRoute.basedata, (String)querySql.toString());){
            while (dataSet.hasNext()) {
                row = dataSet.next();
                need2AppendAuthSet.add(row.get("fid") + "|" + row.get("fseq") + "|" + row.get("fpermitemid") + "|" + row.get("fentitytypeid") + "|" + newAppId);
            }
        }
        querySql.setLength(0);
        querySql.append("select fentryid, fid, fseq, fpermitemid, fentitytypeid, fbizappid from t_perm_bizroledisperm ");
        querySql.append(" where fbizappid in ('").append(newAppId).append("')");
        querySql.append(" and fentitytypeid in ('").append(entNumStr).append("')");
        var6_6 = null;
        try (DataSet ds = DB.queryDataSet((String)"AppendPermByAppEntNumMapAuthorizeUtil#appendPermForBizRoleDisPerm_2", (DBRoute)DBRoute.basedata, (String)querySql.toString());){
            while (ds.hasNext()) {
                row = ds.next();
                need2AppendAuthSet.remove(row.get("fid") + "|" + row.get("fseq") + "|" + row.get("fpermitemid") + "|" + row.get("fentitytypeid") + "|" + row.get("fbizappid"));
            }
        }
        catch (Throwable row2) {
            var6_6 = row2;
            throw row2;
        }
        if (null == need2AppendAuthSet || need2AppendAuthSet.isEmpty()) {
            return new ArrayList<Object[]>(1);
        }
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>(10);
        long[] entryIds = DB.genLongIds((String)"t_perm_bizroledisperm", (int)need2AppendAuthSet.size());
        int index = 0;
        for (String need2AppendAuth : need2AppendAuthSet) {
            String[] split;
            if (StringUtils.isEmpty((String)need2AppendAuth) || null == (split = need2AppendAuth.split("\\|")) || !Objects.equals(5, split.length)) continue;
            Object[] params = new Object[]{entryIds[index++], Long.valueOf(split[0]), Long.valueOf(split[1]), split[2], split[3], split[4]};
            insertParams.add(params);
        }
        return insertParams;
    }

    private static void DBAppendPermForBizRolePerm(List<Object[]> paramList) {
        if (null != paramList && !paramList.isEmpty()) {
            StringBuilder insertSql = new StringBuilder();
            insertSql.append("INSERT INTO t_perm_bizroleperm");
            insertSql.append(" (fentryid, fid, fseq, fpermitemid, fentitytypeid, fbizappid)");
            insertSql.append(" VALUES(?,?,?,?,?,?);");
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql.toString(), paramList);
        }
    }

    private static List<Object[]> appendPermForBizRolePerm(String newAppId, String entNumStr, String authorizedAppId) {
        Row row;
        HashSet<String> need2AppendAuthSet = new HashSet<String>(8);
        StringBuilder querySql = new StringBuilder();
        querySql.append("select fentryid, fid, fseq, fpermitemid, fentitytypeid, fbizappid from t_perm_bizroleperm ");
        querySql.append(" where fbizappid in ('").append(authorizedAppId).append("')");
        querySql.append(" and fentitytypeid in ('").append(entNumStr).append("')");
        try (DataSet dataSet = DB.queryDataSet((String)"AppendPermByAppEntNumMapAuthorizeUtil#appendPermForBizRolePerm_1", (DBRoute)DBRoute.basedata, (String)querySql.toString());){
            while (dataSet.hasNext()) {
                row = dataSet.next();
                need2AppendAuthSet.add(row.get("fid") + "|" + row.get("fseq") + "|" + row.get("fpermitemid") + "|" + row.get("fentitytypeid") + "|" + newAppId);
            }
        }
        querySql.setLength(0);
        querySql.append("select fentryid, fid, fseq, fpermitemid, fentitytypeid, fbizappid from t_perm_bizroleperm ");
        querySql.append(" where fbizappid in ('").append(newAppId).append("')");
        querySql.append(" and fentitytypeid in ('").append(entNumStr).append("')");
        var6_6 = null;
        try (DataSet ds = DB.queryDataSet((String)"AppendPermByAppEntNumMapAuthorizeUtil#appendPermForBizRolePerm_2", (DBRoute)DBRoute.basedata, (String)querySql.toString());){
            while (ds.hasNext()) {
                row = ds.next();
                need2AppendAuthSet.remove(row.get("fid") + "|" + row.get("fseq") + "|" + row.get("fpermitemid") + "|" + row.get("fentitytypeid") + "|" + row.get("fbizappid"));
            }
        }
        catch (Throwable row2) {
            var6_6 = row2;
            throw row2;
        }
        if (null == need2AppendAuthSet || need2AppendAuthSet.isEmpty()) {
            return new ArrayList<Object[]>(1);
        }
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>(10);
        long[] entryIds = DB.genLongIds((String)"t_perm_bizroleperm", (int)need2AppendAuthSet.size());
        int index = 0;
        for (String need2AppendAuth : need2AppendAuthSet) {
            String[] split;
            if (StringUtils.isEmpty((String)need2AppendAuth) || null == (split = need2AppendAuth.split("\\|")) || !Objects.equals(5, split.length)) continue;
            Object[] params = new Object[]{entryIds[index++], Long.valueOf(split[0]), Long.valueOf(split[1]), split[2], split[3], split[4]};
            insertParams.add(params);
        }
        return insertParams;
    }

    private static void DBAppendPermForRolePermDetail(List<Object[]> paramList) {
        if (null != paramList && !paramList.isEmpty()) {
            StringBuilder insertSql = new StringBuilder();
            insertSql.append("INSERT INTO t_perm_rolepermdetial");
            insertSql.append(" (fid, fentryid, fseq, fcontrolmode, fpermitemid, finheritmode, fentitytypeid, fbizappid, froleid)");
            insertSql.append(" VALUES(?,?,?,?,?,?,?,?,?);");
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql.toString(), paramList);
        }
    }

    private static List<Object[]> appendPermForRolePermDetail(String newAppId, String entNumStr, String authorizedAppId) {
        Row row;
        HashSet<String> need2AppendAuthSet = new HashSet<String>(8);
        StringBuilder querySql = new StringBuilder();
        querySql.append("select fid, fentryid, fseq, fcontrolmode, fpermitemid, finheritmode, fentitytypeid, fbizappid, froleid from t_perm_rolepermdetial ");
        querySql.append(" where fbizappid in ('").append(authorizedAppId).append("')");
        querySql.append(" and fentitytypeid in ('").append(entNumStr).append("')");
        try (DataSet dataSet = DB.queryDataSet((String)"AppendPermByAppEntNumMapAuthorizeUtil#appendPermForRolePermDetail_1", (DBRoute)DBRoute.basedata, (String)querySql.toString());){
            while (dataSet.hasNext()) {
                row = dataSet.next();
                need2AppendAuthSet.add(row.get("fid") + "|" + row.get("fseq") + "|" + row.get("fcontrolmode") + "|" + row.get("fpermitemid") + "|" + row.get("finheritmode") + "|" + row.get("fentitytypeid") + "|" + newAppId + "|" + row.get("froleid"));
            }
        }
        querySql.setLength(0);
        querySql.append("select fid, fentryid, fseq, fcontrolmode, fpermitemid, finheritmode, fentitytypeid, fbizappid, froleid from t_perm_rolepermdetial ");
        querySql.append(" where fbizappid in ('").append(newAppId).append("')");
        querySql.append(" and fentitytypeid in ('").append(entNumStr).append("')");
        var6_6 = null;
        try (DataSet ds = DB.queryDataSet((String)"AppendPermByAppEntNumMapAuthorizeUtil#appendPermForRolePermDetail_2", (DBRoute)DBRoute.basedata, (String)querySql.toString());){
            while (ds.hasNext()) {
                row = ds.next();
                need2AppendAuthSet.remove(row.get("fid") + "|" + row.get("fseq") + "|" + row.get("fcontrolmode") + "|" + row.get("fpermitemid") + "|" + row.get("finheritmode") + "|" + row.get("fentitytypeid") + "|" + row.get("fbizappid") + "|" + row.get("froleid"));
            }
        }
        catch (Throwable row2) {
            var6_6 = row2;
            throw row2;
        }
        if (null == need2AppendAuthSet || need2AppendAuthSet.isEmpty()) {
            return new ArrayList<Object[]>(1);
        }
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>(10);
        String[] entryIds = DB.genStringIds((String)"t_perm_rolepermdetial", (int)need2AppendAuthSet.size());
        int index = 0;
        for (String need2AppendAuth : need2AppendAuthSet) {
            String[] split;
            if (StringUtils.isEmpty((String)need2AppendAuth) || null == (split = need2AppendAuth.split("\\|")) || !Objects.equals(8, split.length)) continue;
            Object[] params = new Object[]{split[0], entryIds[index++], Long.valueOf(split[1]), split[2], split[3], split[4], split[5], split[6], split[7]};
            insertParams.add(params);
        }
        return insertParams;
    }

    private static void DBAppendPermForDisFunPerm(List<Object[]> paramList) {
        if (null != paramList && !paramList.isEmpty()) {
            StringBuilder insertSql = new StringBuilder();
            insertSql.append("INSERT INTO t_perm_disfunperm");
            insertSql.append(" (fid, fuserid, forgid, fpermitemid, fentitytypeid, fentryid, ffrom, fbizappid, fsource, fbizroleid, fdimtype, fisincludesuborg)");
            insertSql.append(" VALUES(?,?,?,?,?,?,?,?,?,?,?,?);");
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql.toString(), paramList);
        }
    }

    private static List<Object[]> appendPermForDisFunPerm(String newAppId, String entNumStr, String authorizedAppId) {
        Row row;
        HashSet<String> need2AppendAuthSet = new HashSet<String>(8);
        StringBuilder querySql = new StringBuilder();
        querySql.append("select fid, fuserid, forgid, fpermitemid, fentitytypeid, fentryid, ffrom, fbizappid, fsource, fbizroleid, fdimtype, fisincludesuborg from t_perm_disfunperm");
        querySql.append(" where fbizappid in ('").append(authorizedAppId).append("')");
        querySql.append(" and fentitytypeid in ('").append(entNumStr).append("')");
        try (DataSet dataSet = DB.queryDataSet((String)"AppendPermByAppEntNumMapAuthorizeUtil#appendPermForDisFunPerm_1", (DBRoute)DBRoute.basedata, (String)querySql.toString());){
            while (dataSet.hasNext()) {
                row = dataSet.next();
                need2AppendAuthSet.add(row.get("fuserid") + "|" + row.get("forgid") + "|" + row.get("fpermitemid") + "|" + row.get("fentitytypeid") + "|" + row.get("fentryid") + "|" + row.get("ffrom") + "|" + newAppId + "|" + row.get("fsource") + "|" + row.get("fbizroleid") + "|" + row.get("fdimtype") + "|" + row.get("fisincludesuborg"));
            }
        }
        querySql.setLength(0);
        querySql.append("select fid, fuserid, forgid, fpermitemid, fentitytypeid, fentryid, ffrom, fbizappid, fsource, fbizroleid, fdimtype, fisincludesuborg from t_perm_disfunperm");
        querySql.append(" where fbizappid in ('").append(newAppId).append("')");
        querySql.append(" and fentitytypeid in ('").append(entNumStr).append("')");
        var6_6 = null;
        try (DataSet ds = DB.queryDataSet((String)"AppendPermByAppEntNumMapAuthorizeUtil#appendPermForDisFunPerm_2", (DBRoute)DBRoute.basedata, (String)querySql.toString());){
            while (ds.hasNext()) {
                row = ds.next();
                need2AppendAuthSet.remove(row.get("fuserid") + "|" + row.get("forgid") + "|" + row.get("fpermitemid") + "|" + row.get("fentitytypeid") + "|" + row.get("fentryid") + "|" + row.get("ffrom") + "|" + row.get("fbizappid") + "|" + row.get("fsource") + "|" + row.get("fbizroleid") + "|" + row.get("fdimtype") + "|" + row.get("fisincludesuborg"));
            }
        }
        catch (Throwable row2) {
            var6_6 = row2;
            throw row2;
        }
        if (null == need2AppendAuthSet || need2AppendAuthSet.isEmpty()) {
            return new ArrayList<Object[]>(1);
        }
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>(10);
        String[] ids = DB.genStringIds((String)"t_perm_disfunperm", (int)need2AppendAuthSet.size());
        int index = 0;
        for (String need2AppendAuth : need2AppendAuthSet) {
            String[] split;
            if (StringUtils.isEmpty((String)need2AppendAuth) || null == (split = need2AppendAuth.split("\\|")) || !Objects.equals(11, split.length)) continue;
            Object[] params = new Object[]{ids[index++], Long.valueOf(split[0]), Long.valueOf(split[1]), split[2], split[3], split[4], Long.valueOf(split[5]), split[6], split[7], Long.valueOf(split[8]), split[9], split[10]};
            insertParams.add(params);
        }
        return insertParams;
    }

    private static void DBAppendPermForUserPermDetail(List<Object[]> paramList) {
        if (null != paramList && !paramList.isEmpty()) {
            StringBuilder insertSql = new StringBuilder();
            insertSql.append("INSERT INTO t_perm_userpermdetail");
            insertSql.append(" (fid, fuserid, fdimtype, fdimid, fisincludesub, fentryid, fseq, fcontrolmode, fpermitemid, fentitytypeid, fbizappid, fsource, fbizroleid)");
            insertSql.append(" VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?);");
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql.toString(), paramList);
        }
    }

    private static List<Object[]> appendPermForUserPermDetail(String newAppId, String entNumStr, String authorizedAppId) {
        Row row;
        HashSet<String> need2AppendAuthSet = new HashSet<String>(8);
        StringBuilder querySql = new StringBuilder();
        querySql.append("select fid, fuserid, fdimtype, fdimid, fisincludesub, fentryid, fseq, fcontrolmode, fpermitemid, fentitytypeid, fbizappid, fsource, fbizroleid from t_perm_userpermdetail ");
        querySql.append(" where fbizappid in ('").append(authorizedAppId).append("')");
        querySql.append(" and fentitytypeid in ('").append(entNumStr).append("')");
        try (DataSet dataSet = DB.queryDataSet((String)"AppendPermByAppEntNumMapAuthorizeUtil#appendPermForUserPermDetail_1", (DBRoute)DBRoute.basedata, (String)querySql.toString());){
            while (dataSet.hasNext()) {
                row = dataSet.next();
                need2AppendAuthSet.add(row.get("fid") + "|" + row.get("fuserid") + "|" + row.get("fdimtype") + "|" + row.get("fdimid") + "|" + row.get("fisincludesub") + "|" + row.get("fseq") + "|" + row.get("fcontrolmode") + "|" + row.get("fpermitemid") + "|" + row.get("fentitytypeid") + "|" + newAppId + "|" + row.get("fsource") + "|" + row.get("fbizroleid"));
            }
        }
        querySql.setLength(0);
        querySql.append("select fid, fuserid, fdimtype, fdimid, fisincludesub, fentryid, fseq, fcontrolmode, fpermitemid, fentitytypeid, fbizappid, fsource, fbizroleid from t_perm_userpermdetail ");
        querySql.append(" where fbizappid in ('").append(newAppId).append("')");
        querySql.append(" and fentitytypeid in ('").append(entNumStr).append("')");
        var6_6 = null;
        try (DataSet ds = DB.queryDataSet((String)"AppendPermByAppEntNumMapAuthorizeUtil#appendPermForUserPermDetail_2", (DBRoute)DBRoute.basedata, (String)querySql.toString());){
            while (ds.hasNext()) {
                row = ds.next();
                need2AppendAuthSet.remove(row.get("fid") + "|" + row.get("fuserid") + "|" + row.get("fdimtype") + "|" + row.get("fdimid") + "|" + row.get("fisincludesub") + "|" + row.get("fseq") + "|" + row.get("fcontrolmode") + "|" + row.get("fpermitemid") + "|" + row.get("fentitytypeid") + "|" + row.get("fbizappid") + "|" + row.get("fsource") + "|" + row.get("fbizroleid"));
            }
        }
        catch (Throwable row2) {
            var6_6 = row2;
            throw row2;
        }
        if (null == need2AppendAuthSet || need2AppendAuthSet.isEmpty()) {
            return new ArrayList<Object[]>(1);
        }
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>(10);
        long[] entryIds = DB.genLongIds((String)"t_perm_userpermdetail", (int)need2AppendAuthSet.size());
        int index = 0;
        for (String need2AppendAuth : need2AppendAuthSet) {
            String[] split;
            if (StringUtils.isEmpty((String)need2AppendAuth) || null == (split = need2AppendAuth.split("\\|")) || !Objects.equals(12, split.length)) continue;
            Object[] params = new Object[]{split[0], Long.valueOf(split[1]), split[2], Long.valueOf(split[3]), split[4], String.valueOf(entryIds[index++]), Integer.valueOf(split[5]), split[6], split[7], split[8], split[9], split[10], Long.valueOf(split[11])};
            insertParams.add(params);
        }
        return insertParams;
    }

    private static void DBAppendPermForAdmingroupFunperm(List<Object[]> paramList) {
        if (null != paramList && !paramList.isEmpty()) {
            StringBuilder insertSql = new StringBuilder();
            insertSql.append("INSERT INTO t_perm_admingroupfunperm");
            insertSql.append(" (fid, fusergroupid, fappid, fpermitemid, fentitynum)");
            insertSql.append(" VALUES(?,?,?,?,?);");
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql.toString(), paramList);
        }
    }

    private static List<Object[]> appendPermForAdmingroupFunperm(String newAppId, String entNumStr, String authorizedAppId) {
        Row row;
        HashSet<String> need2AppendAuthSet = new HashSet<String>(8);
        StringBuilder querySql = new StringBuilder();
        querySql.append("select fid, fusergroupid, fappid, fpermitemid, fentitynum from t_perm_admingroupfunperm ");
        querySql.append(" where fappid in ('").append(authorizedAppId).append("')");
        querySql.append(" and fentitynum in ('").append(entNumStr).append("')");
        try (DataSet dataSet = DB.queryDataSet((String)"AppendPermByAppEntNumMapAuthorizeUtil#appendPermForAdmingroupFunperm_1", (DBRoute)DBRoute.basedata, (String)querySql.toString());){
            while (dataSet.hasNext()) {
                row = dataSet.next();
                need2AppendAuthSet.add(row.get("fusergroupid") + "|" + newAppId + "|" + row.get("fpermitemid") + "|" + row.get("fentitynum"));
            }
        }
        querySql.setLength(0);
        querySql.append("select fid, fusergroupid, fappid, fpermitemid, fentitynum from t_perm_admingroupfunperm ");
        querySql.append(" where fappid in ('").append(newAppId).append("')");
        querySql.append(" and fentitynum in ('").append(entNumStr).append("')");
        var6_6 = null;
        try (DataSet ds = DB.queryDataSet((String)"AppendPermByAppEntNumMapAuthorizeUtil#appendPermForAdmingroupFunperm_2", (DBRoute)DBRoute.basedata, (String)querySql.toString());){
            while (ds.hasNext()) {
                row = ds.next();
                need2AppendAuthSet.remove(row.get("fusergroupid") + "|" + row.get("fappid") + "|" + row.get("fpermitemid") + "|" + row.get("fentitynum"));
            }
        }
        catch (Throwable row2) {
            var6_6 = row2;
            throw row2;
        }
        if (null == need2AppendAuthSet || need2AppendAuthSet.isEmpty()) {
            return new ArrayList<Object[]>(1);
        }
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>(10);
        long[] ids = DB.genLongIds((String)"t_perm_admingroupfunperm", (int)need2AppendAuthSet.size());
        int index = 0;
        for (String need2AppendAuth : need2AppendAuthSet) {
            String[] split;
            if (StringUtils.isEmpty((String)need2AppendAuth) || null == (split = need2AppendAuth.split("\\|")) || !Objects.equals(4, split.length)) continue;
            Object[] params = new Object[]{ids[index++], Long.valueOf(split[0]), split[1], split[2], split[3]};
            insertParams.add(params);
        }
        return insertParams;
    }

    private static void DBAppendPermForAdminSchemeDetail(List<Object[]> paramList) {
        if (null != paramList && !paramList.isEmpty()) {
            StringBuilder insertSql = new StringBuilder();
            insertSql.append("insert into t_perm_adminschemedetail");
            insertSql.append(" (fentryid, fdetailid, fseq, fbizappid, fentitynum, fpermitemid)");
            insertSql.append(" values(?, ?, ?, ?, ?, ?);");
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql.toString(), paramList);
        }
    }

    private static List<Object[]> appendPermForAdminSchemeDetail(String newAppId, String entNumStr, String authorizedAppId) {
        Row row;
        HashSet<String> need2AppendAuthSet = new HashSet<String>(8);
        StringBuilder querySql = new StringBuilder();
        querySql.append("select fentryid, fdetailid, fseq, fbizappid, fentitynum, fpermitemid from t_perm_adminschemedetail ");
        querySql.append(" where fbizappid in ('").append(authorizedAppId).append("')");
        querySql.append(" and fentitynum in ('").append(entNumStr).append("')");
        try (DataSet dataSet = DB.queryDataSet((String)"AppendPermByAppEntNumMapAuthorizeUtil#appendPermForAdminSchemeDetail_1", (DBRoute)DBRoute.basedata, (String)querySql.toString());){
            while (dataSet.hasNext()) {
                row = dataSet.next();
                need2AppendAuthSet.add(row.get("fentryid") + "|" + row.get("fseq") + "|" + newAppId + "|" + row.get("fentitynum") + "|" + row.get("fpermitemid"));
            }
        }
        querySql.setLength(0);
        querySql.append("select fentryid, fdetailid, fseq, fbizappid, fentitynum, fpermitemid from t_perm_adminschemedetail ");
        querySql.append(" where fbizappid in ('").append(newAppId).append("')");
        querySql.append(" and fentitynum in ('").append(entNumStr).append("')");
        var6_6 = null;
        try (DataSet ds = DB.queryDataSet((String)"AppendPermByAppEntNumMapAuthorizeUtil#appendPermForAdminSchemeDetail_2", (DBRoute)DBRoute.basedata, (String)querySql.toString());){
            while (ds.hasNext()) {
                row = ds.next();
                need2AppendAuthSet.remove(row.get("fentryid") + "|" + row.get("fseq") + "|" + row.get("fbizappid") + "|" + row.get("fentitynum") + "|" + row.get("fpermitemid"));
            }
        }
        catch (Throwable row2) {
            var6_6 = row2;
            throw row2;
        }
        if (null == need2AppendAuthSet || need2AppendAuthSet.isEmpty()) {
            return new ArrayList<Object[]>(1);
        }
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>(10);
        long[] detailIds = DB.genLongIds((String)"t_perm_adminschemedetail", (int)need2AppendAuthSet.size());
        int index = 0;
        for (String need2AppendAuth : need2AppendAuthSet) {
            String[] split;
            if (StringUtils.isEmpty((String)need2AppendAuth) || null == (split = need2AppendAuth.split("\\|")) || !Objects.equals(5, split.length)) continue;
            Object[] params = new Object[]{Long.valueOf(split[0]), detailIds[index++], Integer.valueOf(split[1]), split[2], split[3], split[4]};
            insertParams.add(params);
        }
        return insertParams;
    }
}

