/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.cache.util;

import com.google.common.collect.Sets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.cache.constant.PermHelperConst;
import kd.bos.permission.cache.util.SqlUtil;
import kd.bos.permission.model.PermResult;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class AppendPermItemAuthByAppUpgradeUtil {
    private static final Log logger = LogFactory.getLog(AppendPermItemAuthByAppUpgradeUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PermResult upgrade(List<Object[]> needAppendAppEntPermItemMapList, StringBuilder pProcessInfo) {
        DLock lock = null;
        try {
            lock = DLock.create((String)"bos/permissinon/AppendPermItemAuthByAppUpgradeUtil");
            lock.lock();
            if (null == pProcessInfo) {
                pProcessInfo = new StringBuilder();
            }
            if (null == needAppendAppEntPermItemMapList || needAppendAppEntPermItemMapList.isEmpty()) {
                logger.debug("AppendPermItemAuthByAppUpgradeUtil.upgrade, needAppendAppEntPermItemMapList is empty.");
                PermResult permResult = PermResult.ok();
                return permResult;
            }
            for (int i = 0; i < needAppendAppEntPermItemMapList.size(); ++i) {
                Object[] needAppendAppEntPermItemMap = needAppendAppEntPermItemMapList.get(i);
                if (null == needAppendAppEntPermItemMap || Objects.equals(0, needAppendAppEntPermItemMap.length)) {
                    logger.debug("AppendPermItemAuthByAppUpgradeUtil.upgrade, needAppendAppEntPermItemMap is empty, i: {}", (Object)i);
                    continue;
                }
                if (!Objects.equals(4, needAppendAppEntPermItemMap.length)) {
                    logger.debug("AppendPermItemAuthByAppUpgradeUtil.upgrade, needAppendAppEntPermItemMap illegal, i: {}", (Object)i);
                    continue;
                }
                Object appIdArrObj = needAppendAppEntPermItemMap[0];
                Object newEntNumObj = needAppendAppEntPermItemMap[1];
                Object newPermItemIdObj = needAppendAppEntPermItemMap[2];
                if (Objects.isNull(newEntNumObj) || Objects.isNull(newPermItemIdObj)) {
                    logger.debug("AppendPermItemAuthByAppUpgradeUtil.upgrade, newEntNumObj: {}, newPermItemIdObj: {}, i: {}", new Object[]{newEntNumObj, newPermItemIdObj, i});
                    continue;
                }
                String newEntNum = (String)newEntNumObj;
                String newPermItemId = (String)newPermItemIdObj;
                if (StringUtils.isEmpty((String)newEntNum) || StringUtils.isEmpty((String)newPermItemId)) {
                    logger.debug("AppendPermItemAuthByAppUpgradeUtil.upgrade, newEntNum or newPermItemId is empty, newEntNum: {}, newPermItemId: {}, i: {}", new Object[]{newEntNum, newPermItemId, i});
                    continue;
                }
                String needAuthorizeOriAppId = AppendPermItemAuthByAppUpgradeUtil.getOriAppId(newEntNum);
                if (StringUtils.isEmpty((String)needAuthorizeOriAppId)) {
                    logger.debug("AppendPermItemAuthByAppUpgradeUtil.upgrade, newEntNum: {}, needAuthorizeOriAppId is empty, i: {}", (Object)newEntNum, (Object)i);
                    continue;
                }
                Object threeStrategyEntryIdObj = needAppendAppEntPermItemMap[3];
                Object[] threeStrategyEntryIdArr = Objects.isNull(threeStrategyEntryIdObj) ? new Long[]{} : (Long[])threeStrategyEntryIdObj;
                try (TXHandle h = TX.requiresNew();){
                    String[] authorizeBasisAppIdArr;
                    if (null != threeStrategyEntryIdArr && threeStrategyEntryIdArr.length > 0 && StringUtils.isNotEmpty((String)newEntNum) && StringUtils.isNotEmpty((String)newPermItemId)) {
                        AppendPermItemAuthByAppUpgradeUtil.appendAdminSchemeDetail((Long[])threeStrategyEntryIdArr, newEntNum, newPermItemId);
                    }
                    if (null == (authorizeBasisAppIdArr = (String[])appIdArrObj) || Objects.equals(0, authorizeBasisAppIdArr.length)) {
                        logger.debug("AppendPermItemAuthByAppUpgradeUtil.upgrade, authorizeBasisAppIdArr is empty, i:{}", (Object)i);
                        continue;
                    }
                    Set<String> authorizeBasisAppIdSet = AppendPermItemAuthByAppUpgradeUtil.getAuthorizeBasisAppIdSet(authorizeBasisAppIdArr);
                    if (null == authorizeBasisAppIdSet || authorizeBasisAppIdSet.isEmpty()) {
                        logger.debug("AppendPermItemAuthByAppUpgradeUtil.upgrade, authorizeBasisAppIdSet is empty, i:{}", (Object)i);
                        continue;
                    }
                    try {
                        if (!StringUtils.isNotEmpty((String)newEntNum) || !StringUtils.isNotEmpty((String)newPermItemId)) continue;
                        AppendPermItemAuthByAppUpgradeUtil.copyPermForAdmingroupFunperm(needAuthorizeOriAppId, authorizeBasisAppIdSet, newEntNum, newPermItemId);
                        AppendPermItemAuthByAppUpgradeUtil.copyPermForUserPermDetail(needAuthorizeOriAppId, authorizeBasisAppIdSet, newEntNum, newPermItemId);
                        AppendPermItemAuthByAppUpgradeUtil.copyPermForDisFunPerm(needAuthorizeOriAppId, authorizeBasisAppIdSet, newEntNum, newPermItemId);
                        AppendPermItemAuthByAppUpgradeUtil.copyPermForRolePermDetail(needAuthorizeOriAppId, authorizeBasisAppIdSet, newEntNum, newPermItemId);
                        AppendPermItemAuthByAppUpgradeUtil.copyPermForBizRolePerm(needAuthorizeOriAppId, authorizeBasisAppIdSet, newEntNum, newPermItemId);
                        AppendPermItemAuthByAppUpgradeUtil.copyPermForBizRoleDisPerm(needAuthorizeOriAppId, authorizeBasisAppIdSet, newEntNum, newPermItemId);
                        continue;
                    }
                    catch (Exception e) {
                        String errInfo = String.format(ResManager.loadKDString((String)"\u3010\u6309\u5e94\u7528\u8ffd\u52a0\u6743\u9650\u9879\u6388\u6743\u3011\u5347\u7ea7\u5f02\u5e38\uff0cnewEntNum\uff1a%1$s\uff0cnewPermItemId\uff1a%2$s\uff0cthreeStrategyEntryIdArr\uff1a%3$s\uff0c%4$s", (String)"AppendPermItemAuthByAppUpgradeUtil_0", (String)"bos-permission-cache", (Object[])new Object[0]), newEntNum, newPermItemId, Arrays.toString(threeStrategyEntryIdArr), e.getMessage());
                        logger.warn(errInfo, (Throwable)e);
                        h.markRollback();
                        pProcessInfo.append(errInfo);
                        throw e;
                    }
                }
            }
        }
        finally {
            CacheMrg.clearAllCache();
            CacheMrg.clearHasEnableOldAdmin();
            if (null != lock) {
                lock.unlock();
            }
        }
        return PermResult.ok();
    }

    private static String getOriAppId(String newEntNum) {
        StringBuilder sb = new StringBuilder();
        sb.append("select fbizappid from t_meta_entitydesign where fnumber = ?  and ftype = '0'");
        return (String)DB.query((DBRoute)DBRoute.meta, (String)sb.toString(), (Object[])new Object[]{newEntNum}, (ResultSetHandler)new ResultSetHandler<String>(){

            public String handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    return rs.getString("fbizappid");
                }
                return "";
            }
        });
    }

    private static Set<String> getAuthorizeBasisAppIdSet(String[] addIdArr) {
        final HashSet<String> resultSet = new HashSet<String>(8);
        if (null == addIdArr || Objects.equals(0, addIdArr.length)) {
            return resultSet;
        }
        Set addIdSet = Arrays.stream(addIdArr).collect(Collectors.toSet());
        if (null == addIdSet || addIdSet.isEmpty()) {
            return resultSet;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("select fid, fmasterid from t_meta_bizapp ");
        String addIdSetStr = String.join((CharSequence)"','", addIdSet);
        sb.append(" where fid in ('").append(addIdSetStr).append("')");
        DB.query((DBRoute)DBRoute.meta, (String)sb.toString(), null, (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws Exception {
                while (rs.next()) {
                    String fid = rs.getString("fid");
                    String fmasterid = rs.getString("fmasterid").trim();
                    if (StringUtils.isEmpty((String)fmasterid)) {
                        resultSet.add(fid);
                        continue;
                    }
                    resultSet.add(fmasterid);
                }
                return null;
            }
        });
        return resultSet;
    }

    private static void appendAdminSchemeDetail(Long[] threeStrategyEntryIdArr, String newEntNum, String ... newPermItemIds) {
        final HashMap<String, String> appEntMap = new HashMap<String, String>(8);
        StringBuilder sb = new StringBuilder();
        sb.append("select distinct a.fnumber, a.fbizappid");
        sb.append(" from t_meta_entitydesign a ");
        sb.append(" inner join t_meta_bizapp b on a.fbizappid = b.fid");
        HashSet cloudSet = Sets.newHashSet((Object[])new String[]{"0QLCSO6KKZC9", "83bfebc800000bac"});
        String cloudSetStr = String.join((CharSequence)"','", cloudSet);
        sb.append(" where b.fbizcloudid in ('").append(cloudSetStr).append("')");
        sb.append(" and a.fnumber = ? ");
        DB.query((DBRoute)DBRoute.meta, (String)sb.toString(), (Object[])new Object[]{newEntNum}, (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws Exception {
                while (rs.next()) {
                    String fbizappid = rs.getString("fbizappid");
                    String fnumber = rs.getString("fnumber");
                    if (StringUtils.isEmpty((String)fbizappid) || StringUtils.isEmpty((String)fnumber)) continue;
                    appEntMap.put(fbizappid, fnumber);
                }
                return null;
            }
        });
        if (null == appEntMap || appEntMap.isEmpty()) {
            return;
        }
        Set<String> exist = AppendPermItemAuthByAppUpgradeUtil.queryForAdminSchemeDetail(threeStrategyEntryIdArr, appEntMap, newPermItemIds);
        int size = threeStrategyEntryIdArr.length * appEntMap.size() * newPermItemIds.length - exist.size();
        long[] detailIds = DB.genLongIds((String)"t_perm_adminschemedetail", (int)size);
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(size);
        int idx = 0;
        for (Long threeStrategyEntryId : threeStrategyEntryIdArr) {
            for (String newPermItemId : newPermItemIds) {
                for (Map.Entry appEnt : appEntMap.entrySet()) {
                    String appId = (String)appEnt.getKey();
                    String entNum = (String)appEnt.getValue();
                    String unique = threeStrategyEntryId + "_" + appId + "_" + entNum + "_" + newPermItemId;
                    if (exist.contains(unique)) continue;
                    paramList.add(new Object[]{threeStrategyEntryId, detailIds[idx], 0, appId, entNum, newPermItemId});
                    ++idx;
                }
            }
        }
        String sql = "insert into t_perm_adminschemedetail (fentryid, fdetailid, fseq, fbizappid, fentitynum, fpermitemid) values(?, ?, ?, ?, ?, ?)";
        SqlUtil.syncInsert(paramList, sql, PermHelperConst.SQL_INSERT_BATCH_NUM_5000, DBRoute.base, true);
    }

    private static Set<String> queryForAdminSchemeDetail(Long[] threeStrategyEntryIdArr, Map<String, String> appEntMap, String[] newPermItemIds) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fentryid, fdetailid, fseq, fbizappid, fentitynum, fpermitemid from t_perm_adminschemedetail where 1=1 ", new Object[0]);
        sqlBuilder.appendIn(" and fentryid", (Object[])threeStrategyEntryIdArr);
        sqlBuilder.appendIn(" and fbizappid", (Object[])appEntMap.keySet().toArray(new String[appEntMap.size()]));
        sqlBuilder.appendIn(" and fentitynum", (Object[])appEntMap.values().toArray(new String[appEntMap.size()]));
        sqlBuilder.appendIn(" and fpermitemid", (Object[])newPermItemIds);
        return (Set)DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)sqlBuilder, (ResultSetHandler)new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet rs) throws SQLException {
                HashSet<String> exist = new HashSet<String>(8);
                while (rs.next()) {
                    exist.add(rs.getObject("fentryid") + "_" + rs.getObject("fbizappid") + "_" + rs.getObject("fentitynum") + "_" + rs.getObject("fpermitemid"));
                }
                return exist;
            }
        });
    }

    private static void copyPermForBizRoleDisPerm(String needAuthorizeOriAppId, Set<String> authorizeBasisAppIdSet, String newEntityTypeId, String ... newPermItemIds) {
        try (DataSet dataSet = AppendPermItemAuthByAppUpgradeUtil.queryForBizRoleDisPerm(authorizeBasisAppIdSet);
             DataSet copyDs = dataSet.copy();){
            HashSet<String> exist = new HashSet<String>(8);
            int count = AppendPermItemAuthByAppUpgradeUtil.existForBizRoleDisPerm(needAuthorizeOriAppId, exist, copyDs, newEntityTypeId, newPermItemIds);
            AppendPermItemAuthByAppUpgradeUtil.insertForBizRoleDisPerm(needAuthorizeOriAppId, exist, dataSet, count, newEntityTypeId, newPermItemIds);
        }
    }

    private static void insertForBizRoleDisPerm(String needAuthorizeOriAppId, Set<String> exist, DataSet dataSet, int count, String newEntityTypeId, String[] newPermItemIds) {
        StringBuilder insertSql = new StringBuilder();
        insertSql.append("INSERT INTO t_perm_bizroledisperm");
        insertSql.append(" (fentryid, fid, fseq, fpermitemid, fentitytypeid, fbizappid)");
        insertSql.append(" VALUES(?,?,?,?,?,?);");
        long[] entryIds = DB.genLongIds((String)"t_perm_bizroledisperm", (int)(count * newPermItemIds.length));
        int index = 0;
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>(count * newPermItemIds.length);
        for (Row row : dataSet) {
            for (String newPermItemId : newPermItemIds) {
                String unique = row.get("fid") + "_" + newPermItemId + "_" + newEntityTypeId + "_" + needAuthorizeOriAppId;
                if (exist.contains(unique)) continue;
                Object[] params = new Object[]{entryIds[index++], row.get("fid"), row.get("fseq"), newPermItemId, newEntityTypeId, needAuthorizeOriAppId};
                insertParams.add(params);
                exist.add(unique);
            }
        }
        if (insertParams.size() <= 0) {
            return;
        }
        DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql.toString(), insertParams);
    }

    private static int existForBizRoleDisPerm(String needAuthorizeOriAppId, final Set<String> exist, DataSet dataSet, String newEntityTypeId, String[] newPermItemIds) {
        HashSet<Object> ids = new HashSet<Object>(8);
        HashSet<String> bizAppIds = new HashSet<String>(8);
        bizAppIds.add(needAuthorizeOriAppId);
        int count = 0;
        for (Row row : dataSet) {
            ids.add(row.get("fid"));
            ++count;
        }
        SqlBuilder existSql = new SqlBuilder();
        existSql.append("select fentryid, fid, fseq, fpermitemid, fentitytypeid, fbizappid from t_perm_bizroledisperm", new Object[0]);
        existSql.append(" where fentitytypeid = ?", new Object[]{newEntityTypeId});
        existSql.appendIn(" and fpermitemid", (Object[])newPermItemIds);
        if (!CollectionUtils.isEmpty(ids)) {
            existSql.appendIn(" and  fid ", ids.toArray());
        }
        if (!CollectionUtils.isEmpty(bizAppIds)) {
            existSql.appendIn(" and fbizappid ", bizAppIds.toArray());
        }
        DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)existSql, (ResultSetHandler)new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    exist.add(rs.getObject("fid") + "_" + rs.getObject("fpermitemid") + "_" + rs.getObject("fentitytypeid") + "_" + rs.getObject("fbizappid"));
                }
                return exist;
            }
        });
        return count;
    }

    private static DataSet queryForBizRoleDisPerm(Set<String> authorizeBasisAppIdSet) {
        String authorizeBasisAppIdSetStr = String.join((CharSequence)"','", authorizeBasisAppIdSet);
        StringBuilder querySql = new StringBuilder();
        querySql.append("select fentryid, fid, fseq, fpermitemid, fentitytypeid from t_perm_bizroledisperm ");
        querySql.append(" where fbizappid in ('").append(authorizeBasisAppIdSetStr).append("')");
        return DB.queryDataSet((String)"AppendPermItemAuthByAppUpgradeUtil#queryForBizRoleDisPerm", (DBRoute)DBRoute.basedata, (String)querySql.toString());
    }

    private static void copyPermForBizRolePerm(String needAuthorizeOriAppId, Set<String> authorizeBasisAppIdSet, String newEntityTypeId, String ... newPermItemIds) {
        try (DataSet dataSet = AppendPermItemAuthByAppUpgradeUtil.queryForBizRolePerm(authorizeBasisAppIdSet);
             DataSet copyDs = dataSet.copy();){
            HashSet<String> exist = new HashSet<String>(8);
            int count = AppendPermItemAuthByAppUpgradeUtil.existForBizRolePerm(needAuthorizeOriAppId, exist, copyDs, newEntityTypeId, newPermItemIds);
            AppendPermItemAuthByAppUpgradeUtil.insertForBizRolePerm(needAuthorizeOriAppId, exist, dataSet, count, newEntityTypeId, newPermItemIds);
        }
    }

    private static void insertForBizRolePerm(String needAuthorizeOriAppId, Set<String> exist, DataSet dataSet, int count, String newEntityTypeId, String[] newPermItemIds) {
        StringBuilder insertSql = new StringBuilder();
        insertSql.append("INSERT INTO t_perm_bizroleperm");
        insertSql.append(" (fentryid, fid, fseq, fpermitemid, fentitytypeid, fbizappid)");
        insertSql.append(" VALUES(?,?,?,?,?,?);");
        long[] entryIds = DB.genLongIds((String)"t_perm_bizroleperm", (int)(count * newPermItemIds.length));
        int index = 0;
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>(10);
        for (Row row : dataSet) {
            for (String newPermItemId : newPermItemIds) {
                String unique = row.get("fid") + "_" + newPermItemId + "_" + newEntityTypeId + "_" + needAuthorizeOriAppId;
                if (exist.contains(unique)) continue;
                Object[] params = new Object[]{entryIds[index++], row.get("fid"), row.get("fseq"), newPermItemId, newEntityTypeId, needAuthorizeOriAppId};
                insertParams.add(params);
                exist.add(unique);
            }
        }
        if (insertParams.size() <= 0) {
            return;
        }
        DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql.toString(), insertParams);
    }

    private static int existForBizRolePerm(String needAuthorizeOriAppId, final Set<String> exist, DataSet dataSet, String newEntityTypeId, String[] newPermItemIds) {
        HashSet<Object> ids = new HashSet<Object>(8);
        HashSet<String> bizAppIds = new HashSet<String>(8);
        bizAppIds.add(needAuthorizeOriAppId);
        int count = 0;
        for (Row row : dataSet) {
            ids.add(row.get("fid"));
            ++count;
        }
        SqlBuilder existSql = new SqlBuilder();
        existSql.append("select fentryid, fid, fseq, fpermitemid, fentitytypeid, fbizappid from t_perm_bizroleperm", new Object[0]);
        existSql.append(" where fentitytypeid = ?", new Object[]{newEntityTypeId});
        existSql.appendIn(" and fpermitemid", (Object[])newPermItemIds);
        if (!CollectionUtils.isEmpty(ids)) {
            existSql.appendIn(" and  fid ", ids.toArray());
        }
        if (!CollectionUtils.isEmpty(bizAppIds)) {
            existSql.appendIn(" and fbizappid ", bizAppIds.toArray());
        }
        DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)existSql, (ResultSetHandler)new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    exist.add(rs.getObject("fid") + "_" + rs.getObject("fpermitemid") + "_" + rs.getObject("fentitytypeid") + "_" + rs.getObject("fbizappid"));
                }
                return exist;
            }
        });
        return count;
    }

    private static DataSet queryForBizRolePerm(Set<String> authorizeBasisAppIdSet) {
        String authorizeBasisAppIdSetStr = String.join((CharSequence)"','", authorizeBasisAppIdSet);
        StringBuilder querySql = new StringBuilder();
        querySql.append("select fentryid, fid, fseq, fpermitemid, fentitytypeid from t_perm_bizroleperm ");
        querySql.append(" where fbizappid in ('").append(authorizeBasisAppIdSetStr).append("')");
        return DB.queryDataSet((String)"", (DBRoute)DBRoute.basedata, (String)querySql.toString());
    }

    private static void copyPermForDisFunPerm(String needAuthorizeOriAppId, Set<String> authorizeBasisAppIdSet, String newEntityTypeId, String ... newPermItemIds) {
        try (DataSet dataSet = AppendPermItemAuthByAppUpgradeUtil.queryForDisFunPerm(authorizeBasisAppIdSet);
             DataSet copyDs = dataSet.copy();){
            HashSet<String> exist = new HashSet<String>(8);
            int count = AppendPermItemAuthByAppUpgradeUtil.existForDisFunPerm(needAuthorizeOriAppId, exist, copyDs, newEntityTypeId, newPermItemIds);
            AppendPermItemAuthByAppUpgradeUtil.insertForUserRoleDisFunPerm(needAuthorizeOriAppId, exist, dataSet, count, newEntityTypeId, newPermItemIds);
        }
    }

    private static void insertForUserRoleDisFunPerm(String needAuthorizeOriAppId, Set<String> exist, DataSet copy, int count, String newEntityTypeId, String ... newPermItemIds) {
        StringBuilder insertSql = new StringBuilder();
        insertSql.append("INSERT INTO t_perm_disfunperm");
        insertSql.append(" (fid, fuserid, forgid, fpermitemid, fentitytypeid, fentryid, ffrom, fbizappid, fsource, fbizroleid, fdimtype, fisincludesuborg)");
        insertSql.append(" VALUES(?,?,?,?,?,?,?,?,?,?,?,?);");
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>(10);
        String[] ids = DB.genStringIds((String)"t_perm_disfunperm", (int)(count * newPermItemIds.length));
        int index = 0;
        for (Row row : copy) {
            for (String newPermItemId : newPermItemIds) {
                String unique = row.get("fuserid") + "_" + row.get("forgid") + "_" + needAuthorizeOriAppId + "_" + newEntityTypeId + "_" + newPermItemId + "_" + row.get("fdimtype") + "_" + row.get("fisincludesuborg");
                if (exist.contains(unique)) continue;
                Object[] params = new Object[]{ids[index++], row.get("fuserid"), row.get("forgid"), newPermItemId, newEntityTypeId, row.get("fentryid"), row.get("ffrom"), needAuthorizeOriAppId, row.get("fsource"), row.get("fbizroleid"), row.get("fdimtype"), row.get("fisincludesuborg")};
                insertParams.add(params);
                exist.add(unique);
            }
        }
        if (insertParams.size() <= 0) {
            return;
        }
        DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql.toString(), insertParams);
    }

    private static DataSet queryForDisFunPerm(Set<String> authorizeBasisAppIdSet) {
        String authorizeBasisAppIdSetStr = String.join((CharSequence)"','", authorizeBasisAppIdSet);
        StringBuilder querySql = new StringBuilder();
        querySql.append("select fid, fuserid, forgid, fpermitemid, fentitytypeid, fentryid, ffrom, fsource, fbizroleid, fdimtype, fisincludesuborg from t_perm_disfunperm ");
        querySql.append(" where fbizappid in ('").append(authorizeBasisAppIdSetStr).append("')");
        return DB.queryDataSet((String)"AppendPermItemAuthByAppUpgradeUtil#queryForDisFunPerm", (DBRoute)DBRoute.basedata, (String)querySql.toString());
    }

    private static int existForDisFunPerm(String needAuthorizeOriAppId, final Set<String> exist, DataSet dataSet, String newEntityTypeId, String ... newPermItemIds) {
        HashSet<Object> userIds = new HashSet<Object>(8);
        HashSet<Object> orgIds = new HashSet<Object>(8);
        HashSet<String> bizAppIds = new HashSet<String>(8);
        bizAppIds.add(needAuthorizeOriAppId);
        int count = 0;
        for (Row row : dataSet) {
            userIds.add(row.get("fuserid"));
            orgIds.add(row.get("forgid"));
            ++count;
        }
        SqlBuilder existSql = new SqlBuilder();
        existSql.append("select fuserid,forgid,fbizappid,fentitytypeid,fpermitemid,fdimtype,fisincludesuborg from t_perm_disfunperm", new Object[0]);
        existSql.append(" where fentitytypeid = ?", new Object[]{newEntityTypeId});
        existSql.appendIn(" and fpermitemid", (Object[])newPermItemIds);
        if (!CollectionUtils.isEmpty(userIds)) {
            existSql.appendIn(" and fuserid ", userIds.toArray());
        }
        if (!CollectionUtils.isEmpty(orgIds)) {
            existSql.appendIn(" and forgid ", orgIds.toArray());
        }
        if (!CollectionUtils.isEmpty(bizAppIds)) {
            existSql.appendIn(" and fbizappid", bizAppIds.toArray());
        }
        DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)existSql, (ResultSetHandler)new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    exist.add(rs.getObject("fuserid") + "_" + rs.getObject("forgid") + "_" + rs.getObject("fbizappid") + "_" + rs.getObject("fentitytypeid") + "_" + rs.getObject("fpermitemid") + "_" + rs.getObject("fdimtype") + "_" + rs.getObject("fisincludesuborg"));
                }
                return exist;
            }
        });
        return count;
    }

    private static void copyPermForRolePermDetail(String needAuthorizeOriAppId, Set<String> authorizeBasisAppIdSet, String newEntityTypeId, String ... newPermItemIds) {
        try (DataSet dataSet = AppendPermItemAuthByAppUpgradeUtil.queryForRolePermDetail(authorizeBasisAppIdSet);
             DataSet copyDs = dataSet.copy();){
            HashSet<String> exist = new HashSet<String>(8);
            int count = AppendPermItemAuthByAppUpgradeUtil.existForRolePermDetail(needAuthorizeOriAppId, exist, copyDs, newEntityTypeId, newPermItemIds);
            AppendPermItemAuthByAppUpgradeUtil.insertForUserRolePermDetail(needAuthorizeOriAppId, exist, dataSet, count, newEntityTypeId, newPermItemIds);
        }
    }

    private static DataSet queryForRolePermDetail(Set<String> authorizeBasisAppIdSet) {
        String authorizeBasisAppIdSetStr = String.join((CharSequence)"','", authorizeBasisAppIdSet);
        StringBuilder querySql = new StringBuilder();
        querySql.append("select fid, fentryid, fseq, fcontrolmode, fpermitemid, finheritmode, fentitytypeid, froleid from t_perm_rolepermdetial ");
        querySql.append(" where fbizappid in ('").append(authorizeBasisAppIdSetStr).append("')");
        return DB.queryDataSet((String)"AppendPermItemAuthByAppUpgradeUtil#queryForRolePermDetail", (DBRoute)DBRoute.basedata, (String)querySql.toString());
    }

    private static int existForRolePermDetail(String needAuthorizeOriAppId, final Set<String> exist, DataSet dataSet, String newEntityTypeId, String ... newPermItemIds) {
        HashSet<String> bizAppIds = new HashSet<String>(8);
        bizAppIds.add(needAuthorizeOriAppId);
        HashSet<Object> roleIds = new HashSet<Object>(8);
        int count = 0;
        for (Row row : dataSet) {
            roleIds.add(row.get("froleid"));
            ++count;
        }
        SqlBuilder existSql = new SqlBuilder();
        existSql.append("select fbizappid,fentitytypeid,fpermitemid,froleid from t_perm_rolepermdetial", new Object[0]);
        existSql.append(" where fentitytypeid = ?", new Object[]{newEntityTypeId});
        existSql.appendIn(" and fpermitemid", (Object[])newPermItemIds);
        if (!CollectionUtils.isEmpty(bizAppIds)) {
            existSql.appendIn(" and fbizappid ", bizAppIds.toArray());
        }
        if (!CollectionUtils.isEmpty(roleIds)) {
            existSql.appendIn(" and froleid", roleIds.toArray());
        }
        DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)existSql, (ResultSetHandler)new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    exist.add(rs.getObject("fbizappid") + "_" + rs.getObject("fentitytypeid") + "_" + rs.getObject("fpermitemid") + "_" + rs.getObject("froleid"));
                }
                return exist;
            }
        });
        return count;
    }

    private static void insertForUserRolePermDetail(String needAuthorizeOriAppId, Set<String> exist, DataSet dataSet, int count, String newEntityTypeId, String ... newPermItemIds) {
        StringBuilder insertSql = new StringBuilder();
        insertSql.append("INSERT INTO t_perm_rolepermdetial");
        insertSql.append(" (fid, fentryid, fseq, fcontrolmode, fpermitemid, finheritmode, fentitytypeid, fbizappid, froleid)");
        insertSql.append(" VALUES(?,?,?,?,?,?,?,?,?);");
        String[] entryIds = DB.genStringIds((String)"t_perm_rolepermdetial", (int)(count * newPermItemIds.length));
        int index = 0;
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>(10);
        for (Row row : dataSet) {
            for (String newPermItemId : newPermItemIds) {
                String unique = needAuthorizeOriAppId + "_" + newEntityTypeId + "_" + newPermItemId + "_" + row.get("froleid");
                if (exist.contains(unique)) continue;
                Object[] params = new Object[]{row.get("fid"), entryIds[index++], row.get("fseq"), row.get("fcontrolmode"), newPermItemId, row.get("finheritmode"), newEntityTypeId, needAuthorizeOriAppId, row.get("froleid")};
                insertParams.add(params);
                exist.add(unique);
            }
        }
        if (insertParams.size() <= 0) {
            return;
        }
        DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql.toString(), insertParams);
    }

    private static void copyPermForUserPermDetail(String needAuthorizeOriAppId, Set<String> authorizeBasisAppIdSet, String newEntNum, String ... newPermItemIds) {
        try (DataSet dataSet = AppendPermItemAuthByAppUpgradeUtil.queryForUserPermDetail(authorizeBasisAppIdSet);
             DataSet copyDs = dataSet.copy();){
            HashSet<String> exist = new HashSet<String>(8);
            int count = AppendPermItemAuthByAppUpgradeUtil.existForUserPermDetail(needAuthorizeOriAppId, exist, copyDs, newEntNum, newPermItemIds);
            AppendPermItemAuthByAppUpgradeUtil.insertForUserPermDetail(needAuthorizeOriAppId, exist, dataSet, count, newEntNum, newPermItemIds);
        }
    }

    private static DataSet queryForUserPermDetail(Set<String> authorizeBasisAppIdSet) {
        String authorizeBasisAppIdSetStr = String.join((CharSequence)"','", authorizeBasisAppIdSet);
        StringBuilder querySql = new StringBuilder();
        querySql.append("select fid, fuserid, fdimtype, fdimid, fisincludesub, fentryid, fseq, fcontrolmode, fpermitemid, fentitytypeid, fsource, fbizroleid from t_perm_userpermdetail ");
        querySql.append(" where fbizappid in ('").append(authorizeBasisAppIdSetStr).append("')");
        return DB.queryDataSet((String)"AppendPermItemAuthByAppUpgradeUtil#queryForUserPermDetail", (DBRoute)DBRoute.basedata, (String)querySql.toString());
    }

    private static int existForUserPermDetail(String needAuthorizeOriAppId, final Set<String> exist, DataSet dataSet, String newEntNum, String ... newPermItemIds) {
        HashSet<Object> userIds = new HashSet<Object>(8);
        HashSet<String> bizAppIds = new HashSet<String>(8);
        bizAppIds.add(needAuthorizeOriAppId);
        HashSet<Object> dimIds = new HashSet<Object>(8);
        int count = 0;
        for (Row row : dataSet) {
            userIds.add(row.get("fuserid"));
            dimIds.add(row.get("fdimid"));
            ++count;
        }
        SqlBuilder existSql = new SqlBuilder();
        existSql.append("select fuserid,fbizappid,fentitytypeid,fpermitemid,fdimid,fdimtype,fisincludesub from t_perm_userpermdetail", new Object[0]);
        existSql.append(" where fentitytypeid = ?", new Object[]{newEntNum});
        existSql.appendIn(" and fpermitemid", (Object[])newPermItemIds);
        if (!CollectionUtils.isEmpty(userIds)) {
            existSql.appendIn(" and  fuserid ", userIds.toArray());
        }
        if (!CollectionUtils.isEmpty(bizAppIds)) {
            existSql.appendIn(" and fbizappid ", bizAppIds.toArray());
        }
        if (!CollectionUtils.isEmpty(dimIds)) {
            existSql.appendIn(" and fdimid ", dimIds.toArray());
        }
        DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)existSql, (ResultSetHandler)new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    exist.add(rs.getObject("fuserid") + "_" + rs.getObject("fbizappid") + "_" + rs.getObject("fentitytypeid") + "_" + rs.getObject("fpermitemid") + "_" + rs.getObject("fdimid") + "_" + rs.getObject("fdimtype") + "_" + rs.getObject("fisincludesub"));
                }
                return exist;
            }
        });
        return count;
    }

    private static void insertForUserPermDetail(String needAuthorizeOriAppId, Set<String> exist, DataSet dataSet, int count, String newEntNum, String ... newPermItemIds) {
        StringBuilder insertSql = new StringBuilder();
        insertSql.append("INSERT INTO t_perm_userpermdetail");
        insertSql.append(" (fid, fuserid, fdimtype, fdimid, fisincludesub, fentryid, fseq, fcontrolmode, fpermitemid, fentitytypeid, fbizappid, fsource, fbizroleid)");
        insertSql.append(" VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?);");
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>(10);
        long[] entryIds = DB.genLongIds((String)"t_perm_userpermdetail", (int)(count * newPermItemIds.length));
        int index = 0;
        for (Row row : dataSet) {
            for (String newPermItemId : newPermItemIds) {
                String unique = row.get("fuserid") + "_" + needAuthorizeOriAppId + "_" + newEntNum + "_" + newPermItemId + "_" + row.get("fdimid") + "_" + row.get("fdimtype") + "_" + row.get("fisincludesub");
                if (exist.contains(unique)) continue;
                Object[] params = new Object[]{row.get("fid"), row.get("fuserid"), row.get("fdimtype"), row.get("fdimid"), row.get("fisincludesub"), String.valueOf(entryIds[index++]), row.get("fseq"), row.get("fcontrolmode"), newPermItemId, newEntNum, needAuthorizeOriAppId, row.get("fsource"), row.get("fbizroleid")};
                insertParams.add(params);
                exist.add(unique);
            }
        }
        if (insertParams.size() <= 0) {
            return;
        }
        DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql.toString(), insertParams);
    }

    private static void copyPermForAdmingroupFunperm(String needAuthorizeOriAppId, Set<String> authorizeBasisAppIdSet, String newEntNum, String ... newPermItemIds) {
        try (DataSet dataSet = AppendPermItemAuthByAppUpgradeUtil.queryForAdmingroupFunperm(authorizeBasisAppIdSet);
             DataSet copyDs = dataSet.copy();){
            HashSet<String> exist = new HashSet<String>(8);
            int count = AppendPermItemAuthByAppUpgradeUtil.existForAdmingroupFunperm(needAuthorizeOriAppId, exist, copyDs, newEntNum, newPermItemIds);
            AppendPermItemAuthByAppUpgradeUtil.insertForAdmingroupFunperm(needAuthorizeOriAppId, exist, dataSet, count, newEntNum, newPermItemIds);
        }
    }

    private static DataSet queryForAdmingroupFunperm(Set<String> authorizeBasisAppIdSet) {
        String authorizeBasisAppIdSetStr = String.join((CharSequence)"','", authorizeBasisAppIdSet);
        StringBuilder querySql = new StringBuilder();
        querySql.append("select fusergroupid from t_perm_admingroupfunperm ");
        querySql.append(" where fappid in ('").append(authorizeBasisAppIdSetStr).append("')");
        return DB.queryDataSet((String)"AppendPermItemAuthByAppUpgradeUtil#queryForAdmingroupFunperm", (DBRoute)DBRoute.basedata, (String)querySql.toString());
    }

    private static int existForAdmingroupFunperm(String needAuthorizeOriAppId, final Set<String> exist, DataSet dataSet, String newEntNum, String ... newPermItemIds) {
        HashSet<Object> usrgrpIds = new HashSet<Object>(8);
        HashSet<String> bizAppIds = new HashSet<String>(8);
        bizAppIds.add(needAuthorizeOriAppId);
        int count = 0;
        for (Row row : dataSet) {
            usrgrpIds.add(row.get("fusergroupid"));
            ++count;
        }
        SqlBuilder existSql = new SqlBuilder();
        existSql.append("select fusergroupid, fappid, fentitynum, fpermitemid from t_perm_admingroupfunperm", new Object[0]);
        existSql.append(" where fentitynum = ?", new Object[]{newEntNum});
        existSql.appendIn(" and fpermitemid", (Object[])newPermItemIds);
        if (!CollectionUtils.isEmpty(usrgrpIds)) {
            existSql.appendIn(" and  fusergroupid ", usrgrpIds.toArray());
        }
        if (!CollectionUtils.isEmpty(bizAppIds)) {
            existSql.appendIn(" and fappid ", bizAppIds.toArray());
        }
        DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)existSql, (ResultSetHandler)new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    exist.add(rs.getObject("fusergroupid") + "_" + rs.getObject("fappid") + "_" + rs.getObject("fentitynum") + "_" + rs.getObject("fpermitemid"));
                }
                return exist;
            }
        });
        return count;
    }

    private static void insertForAdmingroupFunperm(String needAuthorizeOriAppId, Set<String> exist, DataSet dataSet, int count, String newEntNum, String ... newPermItemIds) {
        StringBuilder insertSql = new StringBuilder();
        insertSql.append("INSERT INTO t_perm_admingroupfunperm");
        insertSql.append(" (fid, fusergroupid, fappid, fpermitemid, fentitynum)");
        insertSql.append(" VALUES(?,?,?,?,?);");
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>(10);
        long[] entryIds = DB.genLongIds((String)"t_perm_admingroupfunperm", (int)(count * newPermItemIds.length));
        int index = 0;
        for (Row row : dataSet) {
            for (String newPermItemId : newPermItemIds) {
                String unique = row.get("fusergroupid") + "_" + needAuthorizeOriAppId + "_" + newEntNum + "_" + newPermItemId;
                if (exist.contains(unique)) continue;
                Object[] params = new Object[]{entryIds[index++], row.get("fusergroupid"), needAuthorizeOriAppId, newPermItemId, newEntNum};
                insertParams.add(params);
                exist.add(unique);
            }
        }
        if (insertParams.size() <= 0) {
            return;
        }
        DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql.toString(), insertParams);
    }
}

