/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.cache.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.enums.EnumsDataChangeType;
import kd.bos.permission.model.DataRuleInfo;
import kd.bos.permission.model.DataRulesInfo;
import kd.bos.permission.model.EntDataRuleInfo;
import kd.bos.permission.model.perm.NewDrPerm;
import kd.bos.permission.model.perm.NewDrPrPerm;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class DataRuleInfoSerializeUtil {
    private static Log logger = LogFactory.getLog(DataRuleInfoSerializeUtil.class);

    public static String toJsonStr(Map<String, DataRulesInfo> map) {
        return JSON.toJSONString(map);
    }

    public static Map<String, DataRulesInfo> fromJsonStrForDataRulesInfoMap(String dataRulesInfoJson) throws KDException {
        HashMap<String, DataRulesInfo> res = new HashMap<String, DataRulesInfo>(8);
        if (StringUtils.isEmpty((String)dataRulesInfoJson)) {
            return res;
        }
        Set entries = JSON.parseObject((String)dataRulesInfoJson).entrySet();
        for (Map.Entry entry : entries) {
            JSONObject value;
            String key = (String)entry.getKey();
            if (StringUtils.isEmpty((String)key) || null == entry.getValue() || null == (value = (JSONObject)entry.getValue())) continue;
            DataRulesInfo dataRulesInfo = DataRuleInfoSerializeUtil.fromJsonStrForDataRulesInfo(value.toString());
            res.put(key, dataRulesInfo);
        }
        return res;
    }

    public static String toJsonStr(DataRulesInfo drsi) {
        return JSON.toJSONString((Object)drsi);
    }

    public static DataRulesInfo fromJsonStrForDataRulesInfo(String dataRulesInfoJson) throws KDException {
        JSONArray entryInfoArr;
        JSONObject nameMap;
        String number;
        if (StringUtils.isEmpty((String)dataRulesInfoJson)) {
            return null;
        }
        JSONObject parseObject = JSON.parseObject((String)dataRulesInfoJson);
        DataRulesInfo drsi = new DataRulesInfo();
        Long id = parseObject.getLong("id");
        if (id != null) {
            drsi.setId(id);
        }
        if (StringUtils.isNotEmpty((String)(number = parseObject.getString("number")))) {
            drsi.setNumber(number);
        }
        if (!CollectionUtils.isEmpty((Map)(nameMap = parseObject.getJSONObject("name")))) {
            LocaleString lsName = new LocaleString();
            for (Map.Entry entry : nameMap.entrySet()) {
                lsName.put(entry.getKey(), (Object)((String)entry.getValue()));
            }
            drsi.setName((ILocaleString)lsName);
        }
        if (!CollectionUtils.isEmpty((Collection)(entryInfoArr = parseObject.getJSONArray("entryInfos")))) {
            ArrayList<DataRulesInfo.DataRulesEntryInfo> eifos = new ArrayList<DataRulesInfo.DataRulesEntryInfo>();
            for (Object entryObj : entryInfoArr) {
                DataRulesInfo.DataRulesEntryInfo drei = new DataRulesInfo.DataRulesEntryInfo();
                JSONObject entryJsonObj = (JSONObject)entryObj;
                String appId = entryJsonObj.getString("appId");
                String entityNum = entryJsonObj.getString("entityNum");
                JSONObject dataRuleJsonObj = entryJsonObj.getJSONObject("dataRule");
                if (null != dataRuleJsonObj) {
                    String dataRuleStr = dataRuleJsonObj.toString();
                    DataRuleInfo pidrDataRule = DataRuleInfoSerializeUtil.fromJsonStr(dataRuleStr);
                    drei.setDataRule(pidrDataRule);
                }
                drei.setAppId(appId);
                drei.setEntityNum(entityNum);
                eifos.add(drei);
            }
            drsi.setEntryInfos(eifos);
        }
        return drsi;
    }

    public static DataRulesInfo fromJsonStrForDataRulesInfoNewMdl(String dataRulesInfoJson) throws KDException {
        JSONArray edriInfosJsonObj;
        if (StringUtils.isEmpty((String)dataRulesInfoJson)) {
            return null;
        }
        JSONObject parseObject = JSON.parseObject((String)dataRulesInfoJson);
        DataRulesInfo drsi = new DataRulesInfo();
        String strDataChangeType = parseObject.getString("dataChangeType");
        if (StringUtils.isNotEmpty((String)strDataChangeType)) {
            EnumsDataChangeType edct = EnumsDataChangeType.valueOf((String)strDataChangeType);
            drsi.setDataChangeType(edct);
        }
        if (CollectionUtils.isEmpty((Collection)(edriInfosJsonObj = parseObject.getJSONArray("entDataRuleInfos")))) {
            return drsi;
        }
        for (Object edriObj : edriInfosJsonObj) {
            JSONObject edriJsonObj = (JSONObject)edriObj;
            if (edriJsonObj == null) continue;
            EntDataRuleInfo edr = new EntDataRuleInfo();
            String appId = edriJsonObj.getString("appId");
            edr.setAppId(appId);
            String entNum = edriJsonObj.getString("entityNum");
            edr.setEntityNum(entNum);
            String entDrDataChgType = edriJsonObj.getString("dataChangeType");
            if (StringUtils.isNotEmpty((String)entDrDataChgType)) {
                EnumsDataChangeType edct = EnumsDataChangeType.valueOf((String)entDrDataChgType);
                edr.setDataChangeType(edct);
            }
            JSONArray pidrJsonArr = edriJsonObj.getJSONArray("permItemsDataRule");
            for (Object pidrEle : pidrJsonArr) {
                EntDataRuleInfo.PermItemsDataRule pidr = new EntDataRuleInfo.PermItemsDataRule();
                JSONObject pidrObj = (JSONObject)pidrEle;
                String permItemId = pidrObj.getString("permItemId");
                pidr.setPermItemId(permItemId);
                String pidrDtChgType = pidrObj.getString("dataChangeType");
                if (StringUtils.isNotEmpty((String)pidrDtChgType)) {
                    EnumsDataChangeType edct = EnumsDataChangeType.valueOf((String)pidrDtChgType);
                    pidr.setDataChangeType(edct);
                }
                JSONObject drObj = pidrObj.getJSONObject("dataRule");
                Long drId = drObj.getLong("id");
                DataRuleInfo dri = new DataRuleInfo();
                dri.setId(drId);
                pidr.setDataRule(dri);
                edr.getPermItemsDataRule().add(pidr);
            }
            JSONArray bdprJsonArr = edriJsonObj.getJSONArray("bdPropsDataRule");
            for (Object bdprEle : bdprJsonArr) {
                EntDataRuleInfo.BdPropsDataRule bpdr = new EntDataRuleInfo.BdPropsDataRule();
                JSONObject bdprObj = (JSONObject)bdprEle;
                String propKey = bdprObj.getString("propKey");
                bpdr.setPropKey(propKey);
                String propEntNum = bdprObj.getString("propEntNum");
                bpdr.setPropEntNum(propEntNum);
                String bdprDtChgType = bdprObj.getString("dataChangeType");
                if (StringUtils.isNotEmpty((String)bdprDtChgType)) {
                    EnumsDataChangeType edct = EnumsDataChangeType.valueOf((String)bdprDtChgType);
                    bpdr.setDataChangeType(edct);
                }
                JSONObject drObj = bdprObj.getJSONObject("dataRule");
                Long drId = drObj.getLong("id");
                DataRuleInfo dri = new DataRuleInfo();
                dri.setId(drId);
                bpdr.setDataRule(dri);
                edr.getBdPropsDataRule().add(bpdr);
            }
            drsi.getEntDataRuleInfos().add(edr);
        }
        return drsi;
    }

    public static String toJsonStr(DataRuleInfo dri) {
        return JSON.toJSONString((Object)dri);
    }

    public static String toJsonStr(EntDataRuleInfo dri) {
        return JSON.toJSONString((Object)dri);
    }

    public static DataRuleInfo fromJsonStr(String dataRuleJson) throws KDException {
        String number;
        JSONObject nameMap;
        Long id;
        String description;
        if (StringUtils.isEmpty((String)dataRuleJson)) {
            return null;
        }
        JSONObject parseObject = JSON.parseObject((String)dataRuleJson);
        DataRuleInfo dri = new DataRuleInfo();
        String appId = parseObject.getString("appId");
        if (StringUtils.isNotEmpty((String)appId)) {
            dri.setAppId(appId);
        }
        if (StringUtils.isNotEmpty((String)(description = parseObject.getString("description")))) {
            dri.setDescription(description);
        }
        boolean isDetail = parseObject.getBooleanValue("detail");
        dri.setDetail(isDetail);
        String entityNum = parseObject.getString("entityNum");
        if (StringUtils.isNotEmpty((String)entityNum)) {
            dri.setEntityNum(entityNum);
        }
        if ((id = parseObject.getLong("id")) != null) {
            dri.setId(id);
        }
        if (!CollectionUtils.isEmpty((Map)(nameMap = parseObject.getJSONObject("name")))) {
            LocaleString lsName = new LocaleString();
            for (Map.Entry entry : nameMap.entrySet()) {
                lsName.put(entry.getKey(), (Object)((String)entry.getValue()));
            }
            dri.setName((ILocaleString)lsName);
        }
        if (StringUtils.isNotEmpty((String)(number = parseObject.getString("number")))) {
            dri.setNumber(number);
        }
        if (isDetail) {
            JSONObject ruleJsonObj = parseObject.getJSONObject("rule");
            if (ruleJsonObj != null) {
                FilterCondition fc = new FilterCondition();
                JSONArray filterRows = ruleJsonObj.getJSONArray("filterRow");
                if (!CollectionUtils.isEmpty((Collection)filterRows)) {
                    ArrayList<SimpleFilterRow> sfrList = new ArrayList<SimpleFilterRow>();
                    for (Object filterRowObj : filterRows) {
                        JSONArray filterValues;
                        JSONObject filterRowJsonObj = (JSONObject)filterRowObj;
                        String filterRowId = filterRowJsonObj.getString("id");
                        String leftBracket = filterRowJsonObj.getString("leftBracket");
                        String compareType = filterRowJsonObj.getString("compareType");
                        String compareTypeDesc = filterRowJsonObj.getString("compareTypeDesc");
                        String fieldName = filterRowJsonObj.getString("fieldName");
                        String rightBracket = filterRowJsonObj.getString("rightBracket");
                        String logic = filterRowJsonObj.getString("logic");
                        String entityNumber = filterRowJsonObj.getString("entityNumber");
                        SimpleFilterRow sfr = new SimpleFilterRow();
                        if (StringUtils.isNotEmpty((String)filterRowId)) {
                            sfr.setId(filterRowId);
                        }
                        if (StringUtils.isNotEmpty((String)leftBracket)) {
                            sfr.setLeftBracket(leftBracket);
                        }
                        if (StringUtils.isNotEmpty((String)compareType)) {
                            sfr.setCompareType(compareType);
                        }
                        if (StringUtils.isNotEmpty((String)compareTypeDesc)) {
                            sfr.setCompareTypeDesc(compareTypeDesc);
                        }
                        if (StringUtils.isNotEmpty((String)fieldName)) {
                            sfr.setFieldName(fieldName);
                        }
                        if (StringUtils.isNotEmpty((String)rightBracket)) {
                            sfr.setRightBracket(rightBracket);
                        }
                        if (StringUtils.isNotEmpty((String)logic)) {
                            sfr.setLogic(logic);
                        }
                        if (StringUtils.isNotEmpty((String)entityNumber)) {
                            sfr.setEntityNumber(entityNumber);
                        }
                        if (!CollectionUtils.isEmpty((Collection)(filterValues = filterRowJsonObj.getJSONArray("value")))) {
                            ArrayList<FilterValue> fvList = new ArrayList<FilterValue>();
                            for (Object filterValue : filterValues) {
                                JSONObject filterValueJsonObj = (JSONObject)filterValue;
                                String filterValueId = filterValueJsonObj.getString("id");
                                String filterValueStr = filterValueJsonObj.getString("value");
                                FilterValue fv = new FilterValue();
                                if (StringUtils.isNotEmpty((String)filterValueId)) {
                                    fv.setId(filterValueId);
                                }
                                if (StringUtils.isNotEmpty((String)filterValueStr)) {
                                    fv.setValue((Object)filterValueStr);
                                }
                                fvList.add(fv);
                            }
                            sfr.setValue(fvList);
                        }
                        sfrList.add(sfr);
                    }
                    fc.setFilterRow(sfrList);
                }
                dri.setRule(fc);
            }
        } else {
            JSONArray bdPropsDataRule;
            JSONArray pidrJsonArr = parseObject.getJSONArray("permItemsDataRule");
            if (!CollectionUtils.isEmpty((Collection)pidrJsonArr)) {
                ArrayList<DataRuleInfo.PermItemsDataRule> pidrList = new ArrayList<DataRuleInfo.PermItemsDataRule>();
                for (Object pidrObj : pidrJsonArr) {
                    DataRuleInfo.PermItemsDataRule pidr = new DataRuleInfo.PermItemsDataRule();
                    JSONObject pidrJsonObj = (JSONObject)pidrObj;
                    String permItemId = pidrJsonObj.getString("permItemId");
                    pidr.setPermItemId(permItemId);
                    JSONObject dataRuleJsonObj = pidrJsonObj.getJSONObject("dataRule");
                    String dataRuleStr = dataRuleJsonObj.toString();
                    if (dataRuleStr.indexOf("\"detail\": false") != -1) {
                        throw new KDException(new ErrorCode("datarule_not_detail", ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u89c4\u5219\u65b9\u6848\u914d\u7f6e\u4e86\u975e\u660e\u7ec6\u65b9\u6848\uff0c\u53ef\u80fd\u6570\u636e\u6709\u95ee\u9898\uff0c\u8bf7\u68c0\u67e5", (String)"DataRuleInfoSerializeUtil_0", (String)"bos-permission-cache", (Object[])new Object[0])), new Object[0]);
                    }
                    DataRuleInfo pidrDataRule = DataRuleInfoSerializeUtil.fromJsonStr(dataRuleJsonObj.toString());
                    pidr.setDataRule(pidrDataRule);
                    pidrList.add(pidr);
                }
                dri.setPermItemsDataRule(pidrList);
            }
            if (!CollectionUtils.isEmpty((Collection)(bdPropsDataRule = parseObject.getJSONArray("bdPropsDataRule")))) {
                ArrayList<DataRuleInfo.BdPropsDataRule> bpdrList = new ArrayList<DataRuleInfo.BdPropsDataRule>();
                for (Object bpdrObj : bdPropsDataRule) {
                    DataRuleInfo.BdPropsDataRule bpdr = new DataRuleInfo.BdPropsDataRule();
                    JSONObject bpdrJsonObj = (JSONObject)bpdrObj;
                    String propEntNum = bpdrJsonObj.getString("propEntNum");
                    String propKey = bpdrJsonObj.getString("propKey");
                    bpdr.setPropEntNum(propEntNum);
                    bpdr.setPropKey(propKey);
                    JSONObject dataRuleJsonObj = bpdrJsonObj.getJSONObject("dataRule");
                    String dataRuleStr = dataRuleJsonObj.toString();
                    if (dataRuleStr.indexOf("\"detail\": false") != -1) {
                        throw new KDException(new ErrorCode("basedata_datarule_not_detail", ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u5c5e\u6027\u7684\u6570\u636e\u89c4\u5219\u65b9\u6848\u914d\u7f6e\u4e86\u975e\u660e\u7ec6\u65b9\u6848\uff0c\u53ef\u80fd\u6570\u636e\u6709\u95ee\u9898\uff0c\u8bf7\u68c0\u67e5", (String)"DataRuleInfoSerializeUtil_1", (String)"bos-permission-cache", (Object[])new Object[0])), new Object[0]);
                    }
                    DataRuleInfo bdprDataRule = DataRuleInfoSerializeUtil.fromJsonStr(dataRuleJsonObj.toString());
                    bpdr.setDataRule(bdprDataRule);
                    bpdrList.add(bpdr);
                }
                dri.setBdPropsDataRule(bpdrList);
            }
        }
        return dri;
    }

    public static Map<String, List<NewDrPerm>> fromJsonStrForNewDrPermMap(String jsonStr) {
        Map<String, List<Object>> map = new HashMap<String, List<NewDrPerm>>(8);
        try {
            map = (Map)new ObjectMapper().readValue(jsonStr, (TypeReference)new TypeReference<HashMap<String, List<NewDrPerm>>>(){});
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
        }
        return map;
    }

    public static Map<String, List<NewDrPrPerm>> fromJsonStrForNewDrPrPermMap(String jsonStr) {
        Map<String, List<Object>> map = new HashMap<String, List<NewDrPrPerm>>(8);
        try {
            map = (Map)new ObjectMapper().readValue(jsonStr, (TypeReference)new TypeReference<HashMap<String, List<NewDrPrPerm>>>(){});
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
        }
        return map;
    }

    public static String toJsonStr(Object obj) {
        return JSON.toJSONString((Object)obj);
    }
}

