/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.cache.util;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.support.util.Assert;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class DateUtil {
    private static final ZoneId DEFAULT_ZONE_ID = ZoneId.systemDefault();
    private static final ZoneOffset DEFAULT_ZONE_OFFSET = DEFAULT_ZONE_ID.getRules().getOffset(Instant.now());
    public static final String DATE_PATTERN = "yyyy-MM-dd";
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    public static final String DATE_TIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final Map<String, DateTimeFormatter> DATE_TIME_FORMATTER_MAP = new HashMap<String, DateTimeFormatter>(2);

    @SdkInternal
    private static DateTimeFormatter getFormatter(String pattern) {
        return DATE_TIME_FORMATTER_MAP.getOrDefault(pattern, DateTimeFormatter.ofPattern(pattern));
    }

    @SdkInternal
    public static String format(Date date, String pattern) {
        Assert.notNull((Object)date, (String)ResManager.loadKDString((String)"\u4f20\u5165\u7684\u65e5\u671f\u4e0d\u53ef\u4ee5\u4e3a [null]", (String)"DateUtil_0", (String)"bos-permission-cache", (Object[])new Object[0]));
        Assert.hasText((String)pattern, (String)("PATTERN: [" + pattern + "]" + ResManager.loadKDString((String)" \u53c2\u6570\u975e\u6cd5", (String)"DateUtil_1", (String)"bos-permission-cache", (Object[])new Object[0])));
        return DateUtil.formatLocalDateTime(DateUtil.toLocalDateTime(date), pattern);
    }

    @SdkInternal
    public static String formartLocalDate(LocalDate localDate, String pattern) {
        Assert.notNull((Object)localDate, (String)ResManager.loadKDString((String)"\u4f20\u5165\u7684\u65e5\u671f\u4e0d\u53ef\u4ee5\u4e3a [null]", (String)"DateUtil_0", (String)"bos-permission-cache", (Object[])new Object[0]));
        Assert.hasText((String)pattern, (String)("PATTERN: [" + pattern + "]" + ResManager.loadKDString((String)" \u53c2\u6570\u975e\u6cd5", (String)"DateUtil_1", (String)"bos-permission-cache", (Object[])new Object[0])));
        return DateUtil.formatLocalDateTime(DateUtil.toLocalDateTime(localDate), pattern);
    }

    @SdkInternal
    public static String formatLocalDateTime(LocalDateTime localDateTime, String pattern) {
        Assert.notNull((Object)localDateTime, (String)ResManager.loadKDString((String)"\u4f20\u5165\u7684\u65e5\u671f\u4e0d\u53ef\u4ee5\u4e3a [null]", (String)"DateUtil_0", (String)"bos-permission-cache", (Object[])new Object[0]));
        Assert.hasText((String)pattern, (String)("PATTERN: [" + pattern + "]" + ResManager.loadKDString((String)" \u53c2\u6570\u975e\u6cd5", (String)"DateUtil_1", (String)"bos-permission-cache", (Object[])new Object[0])));
        return localDateTime.format(DateUtil.getFormatter(pattern));
    }

    public static Date toDate(String str, String pattern) {
        Assert.hasText((String)str, (String)("STR: [" + str + "]" + ResManager.loadKDString((String)" \u53c2\u6570\u975e\u6cd5", (String)"DateUtil_1", (String)"bos-permission-cache", (Object[])new Object[0])));
        Assert.hasText((String)pattern, (String)("PATTERN: [" + pattern + "]" + ResManager.loadKDString((String)" \u53c2\u6570\u975e\u6cd5", (String)"DateUtil_1", (String)"bos-permission-cache", (Object[])new Object[0])));
        return DateUtil.toDate(LocalDateTime.parse(str, DateUtil.getFormatter(pattern)));
    }

    public static Date toDate(LocalDate localDate) {
        Assert.notNull((Object)localDate, (String)ResManager.loadKDString((String)"\u4f20\u5165\u7684\u65e5\u671f\u4e0d\u53ef\u4ee5\u4e3a [null]", (String)"DateUtil_0", (String)"bos-permission-cache", (Object[])new Object[0]));
        return Date.from(localDate.atStartOfDay(DEFAULT_ZONE_ID).toInstant());
    }

    public static Date toDate(LocalDateTime localDateTime) {
        Assert.notNull((Object)localDateTime, (String)ResManager.loadKDString((String)"\u4f20\u5165\u7684\u65e5\u671f\u4e0d\u53ef\u4ee5\u4e3a [null]", (String)"DateUtil_0", (String)"bos-permission-cache", (Object[])new Object[0]));
        return Date.from(localDateTime.atZone(DEFAULT_ZONE_ID).toInstant());
    }

    public static LocalDate toLocalDate(String str) {
        Assert.hasText((String)str, (String)("STR: [" + str + "]" + ResManager.loadKDString((String)" \u53c2\u6570\u975e\u6cd5", (String)"DateUtil_1", (String)"bos-permission-cache", (Object[])new Object[0])));
        return DateUtil.toLocalDate(str, DATE_PATTERN);
    }

    public static LocalDate toLocalDate(String str, String pattern) {
        Assert.hasText((String)str, (String)("STR: [" + str + "]" + ResManager.loadKDString((String)" \u53c2\u6570\u975e\u6cd5", (String)"DateUtil_1", (String)"bos-permission-cache", (Object[])new Object[0])));
        Assert.hasText((String)pattern, (String)("PATTERN: [" + pattern + "]" + ResManager.loadKDString((String)" \u53c2\u6570\u975e\u6cd5", (String)"DateUtil_1", (String)"bos-permission-cache", (Object[])new Object[0])));
        return LocalDate.parse(str, DateUtil.getFormatter(pattern));
    }

    public static LocalDate toLocalDate(Date date) {
        Assert.notNull((Object)date, (String)ResManager.loadKDString((String)"\u4f20\u5165\u7684\u65e5\u671f\u4e0d\u53ef\u4ee5\u4e3a [null]", (String)"DateUtil_0", (String)"bos-permission-cache", (Object[])new Object[0]));
        return DateUtil.toZonedDateTime(date).toLocalDate();
    }

    public static LocalDateTime toLocalDateTime(String str) {
        Assert.hasText((String)str, (String)("STR: [" + str + "]" + ResManager.loadKDString((String)" \u53c2\u6570\u975e\u6cd5", (String)"DateUtil_1", (String)"bos-permission-cache", (Object[])new Object[0])));
        return DateUtil.toLocalDateTime(str, DATE_TIME_PATTERN);
    }

    public static LocalDateTime toLocalDateTime(String str, String pattern) {
        Assert.hasText((String)str, (String)("STR: [" + str + "]" + ResManager.loadKDString((String)" \u53c2\u6570\u975e\u6cd5", (String)"DateUtil_1", (String)"bos-permission-cache", (Object[])new Object[0])));
        Assert.hasText((String)pattern, (String)("PATTERN: [" + pattern + "]" + ResManager.loadKDString((String)" \u53c2\u6570\u975e\u6cd5", (String)"DateUtil_1", (String)"bos-permission-cache", (Object[])new Object[0])));
        return LocalDateTime.parse(str, DateUtil.getFormatter(pattern));
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        Assert.notNull((Object)date, (String)ResManager.loadKDString((String)"\u4f20\u5165\u7684\u65e5\u671f\u4e0d\u53ef\u4ee5\u4e3a [null]", (String)"DateUtil_0", (String)"bos-permission-cache", (Object[])new Object[0]));
        return DateUtil.toZonedDateTime(date).toLocalDateTime();
    }

    public static LocalDateTime toLocalDateTime(LocalDate localDate) {
        Assert.notNull((Object)localDate, (String)ResManager.loadKDString((String)"\u4f20\u5165\u7684\u65e5\u671f\u4e0d\u53ef\u4ee5\u4e3a [null]", (String)"DateUtil_0", (String)"bos-permission-cache", (Object[])new Object[0]));
        return localDate.atStartOfDay();
    }

    @SdkInternal
    public static Date addDateSeconds(Date date, int seconds) {
        Assert.notNull((Object)date, (String)ResManager.loadKDString((String)"\u4f20\u5165\u7684\u65e5\u671f\u4e0d\u53ef\u4ee5\u4e3a [null]", (String)"DateUtil_0", (String)"bos-permission-cache", (Object[])new Object[0]));
        return DateUtil.toDate(DateUtil.toLocalDateTime(date).plusSeconds(seconds));
    }

    @SdkInternal
    public static Date addDateMinutes(Date date, int minutes) {
        Assert.notNull((Object)date, (String)ResManager.loadKDString((String)"\u4f20\u5165\u7684\u65e5\u671f\u4e0d\u53ef\u4ee5\u4e3a [null]", (String)"DateUtil_0", (String)"bos-permission-cache", (Object[])new Object[0]));
        return DateUtil.toDate(DateUtil.toLocalDateTime(date).plusMinutes(minutes));
    }

    @SdkInternal
    public static Date addDateHours(Date date, int hours) {
        Assert.notNull((Object)date, (String)ResManager.loadKDString((String)"\u4f20\u5165\u7684\u65e5\u671f\u4e0d\u53ef\u4ee5\u4e3a [null]", (String)"DateUtil_0", (String)"bos-permission-cache", (Object[])new Object[0]));
        return DateUtil.toDate(DateUtil.toLocalDateTime(date).plusHours(hours));
    }

    @SdkInternal
    public static Date addDateDays(Date date, int days) {
        Assert.notNull((Object)date, (String)ResManager.loadKDString((String)"\u4f20\u5165\u7684\u65e5\u671f\u4e0d\u53ef\u4ee5\u4e3a [null]", (String)"DateUtil_0", (String)"bos-permission-cache", (Object[])new Object[0]));
        return DateUtil.toDate(DateUtil.toLocalDateTime(date).plusDays(days));
    }

    @SdkInternal
    public static Date addDateWeeks(Date date, int weeks) {
        Assert.notNull((Object)date, (String)ResManager.loadKDString((String)"\u4f20\u5165\u7684\u65e5\u671f\u4e0d\u53ef\u4ee5\u4e3a [null]", (String)"DateUtil_0", (String)"bos-permission-cache", (Object[])new Object[0]));
        return DateUtil.toDate(DateUtil.toLocalDateTime(date).plusWeeks(weeks));
    }

    @SdkInternal
    public static Date addDateMonths(Date date, int months) {
        Assert.notNull((Object)date, (String)ResManager.loadKDString((String)"\u4f20\u5165\u7684\u65e5\u671f\u4e0d\u53ef\u4ee5\u4e3a [null]", (String)"DateUtil_0", (String)"bos-permission-cache", (Object[])new Object[0]));
        return DateUtil.toDate(DateUtil.toLocalDateTime(date).plusMonths(months));
    }

    @SdkInternal
    public static Date addDateYears(Date date, int years) {
        Assert.notNull((Object)date, (String)ResManager.loadKDString((String)"\u4f20\u5165\u7684\u65e5\u671f\u4e0d\u53ef\u4ee5\u4e3a [null]", (String)"DateUtil_0", (String)"bos-permission-cache", (Object[])new Object[0]));
        return DateUtil.toDate(DateUtil.toLocalDateTime(date).plusYears(years));
    }

    @SdkInternal
    public static ZonedDateTime toZonedDateTime(Date date) {
        Assert.notNull((Object)date, (String)ResManager.loadKDString((String)"\u4f20\u5165\u7684\u65e5\u671f\u4e0d\u53ef\u4ee5\u4e3a [null]", (String)"DateUtil_0", (String)"bos-permission-cache", (Object[])new Object[0]));
        return date.toInstant().atZone(DEFAULT_ZONE_ID);
    }

    @SdkInternal
    public static LocalDateTime fromSeconds(long seconds) {
        return LocalDateTime.ofEpochSecond(seconds, 0, DEFAULT_ZONE_OFFSET);
    }

    @SdkInternal
    public static LocalDateTime fromMillSeconds(long millSeconds) {
        Instant instant = Instant.ofEpochMilli(millSeconds);
        return LocalDateTime.ofInstant(instant, DEFAULT_ZONE_ID);
    }

    @SdkInternal
    public static long getSeconds(LocalDateTime localDateTime) {
        Assert.notNull((Object)localDateTime, (String)ResManager.loadKDString((String)"\u4f20\u5165\u7684\u65e5\u671f\u4e0d\u53ef\u4ee5\u4e3a [null]", (String)"DateUtil_0", (String)"bos-permission-cache", (Object[])new Object[0]));
        return DateUtil.getMillSeconds(localDateTime) / 1000L;
    }

    @SdkInternal
    public static long getMillSeconds(LocalDateTime localDateTime) {
        Assert.notNull((Object)localDateTime, (String)ResManager.loadKDString((String)"\u4f20\u5165\u7684\u65e5\u671f\u4e0d\u53ef\u4ee5\u4e3a [null]", (String)"DateUtil_0", (String)"bos-permission-cache", (Object[])new Object[0]));
        return localDateTime.toInstant(DEFAULT_ZONE_OFFSET).toEpochMilli();
    }

    static {
        DATE_TIME_FORMATTER_MAP.put(DATE_PATTERN, DATE_FORMATTER);
        DATE_TIME_FORMATTER_MAP.put(DATE_TIME_PATTERN, DATE_TIME_FORMATTER);
    }
}

