/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.cache.util;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.inte.api.EnabledLang;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class EncryptionSchemeStandardLangUpgradeUtil {
    private static final Log LOG = LogFactory.getLog(EncryptionSchemeStandardLangUpgradeUtil.class);
    private static final String KEY_SM4_NUMBER = "STANDARD-SM4-128";
    private static final String KEY_AES_NUMBER = "STANDARD-AES-256";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean preset(UpgradeResult result, StringBuilder info) {
        boolean isSuccess;
        if (info == null) {
            info = new StringBuilder();
        }
        DLock lock = DLock.create((String)"kd.bos.permission.cache.util.EncryptionSchemeStandardLangUpgradeUtil");
        lock.lock();
        try (TXHandle handle = TX.requiresNew();){
            try {
                List<Lang> langList = EncryptionSchemeStandardLangUpgradeUtil.getEnableLangList();
                result.setLog(ResManager.loadKDString((String)"\u5f00\u59cb\u9884\u7f6e\u6807\u51c6SM4-128\u52a0\u5bc6\u65b9\u6848\u591a\u8bed\u8a00\u6570\u636e", (String)"EncryptionSchemeStandardLangUpgradeUtil_1", (String)"bos-permission-cache", (Object[])new Object[0]));
                EncryptionSchemeStandardLangUpgradeUtil.insetStandSM4128SchemeLang(langList);
                result.setLog(ResManager.loadKDString((String)"\u5f00\u59cb\u9884\u7f6e\u6807\u51c6AES-256\u52a0\u5bc6\u65b9\u6848\u591a\u8bed\u8a00\u6570\u636e", (String)"EncryptionSchemeStandardLangUpgradeUtil_2", (String)"bos-permission-cache", (Object[])new Object[0]));
                EncryptionSchemeStandardLangUpgradeUtil.insetStandAES256SchemeLang(langList);
                isSuccess = true;
            }
            catch (Exception ex) {
                info.append(ex.getMessage());
                LOG.error(String.format(ResManager.loadKDString((String)"\u6807\u51c6\u52a0\u5bc6\u65b9\u6848\u591a\u8bed\u8a00\u6570\u636e\u9884\u7f6e\u5931\u8d25\uff0c\u539f\u56e0\uff1a%1$s", (String)"EncryptionSchemeStandardLangUpgradeUtil_0", (String)"bos-permission-cache", (Object[])new Object[0]), ExceptionUtils.getExceptionStackTraceMessage((Exception)ex)));
                isSuccess = false;
                handle.markRollback();
            }
            finally {
                lock.unlock();
            }
        }
        return isSuccess;
    }

    private static void insetStandSM4128SchemeLang(List<Lang> langList) {
        long schemeId = EncryptionSchemeStandardLangUpgradeUtil.getSchemeId(KEY_SM4_NUMBER);
        if (schemeId == 0L) {
            return;
        }
        LocaleString localeString = ResManager.getLocaleString((String)"\u6807\u51c6SM4-128\u52a0\u5bc6\u65b9\u6848", (String)"EncryptionSchemeStandardLangUpgradeUtil_3", (String)"bos-permission-cache");
        String localeValue = localeString.getLocaleValue();
        block8: for (Lang lang : langList) {
            switch (lang) {
                case zh_CN: {
                    EncryptionSchemeStandardLangUpgradeUtil.insertLangData(schemeId, Lang.zh_CN.name(), (String)localeString.getOrDefault((Object)Lang.zh_CN.toString(), (Object)localeValue));
                    continue block8;
                }
                case zh_TW: {
                    EncryptionSchemeStandardLangUpgradeUtil.insertLangData(schemeId, Lang.zh_TW.name(), (String)localeString.getOrDefault((Object)Lang.zh_TW.toString(), (Object)localeValue));
                    continue block8;
                }
                case en_US: {
                    EncryptionSchemeStandardLangUpgradeUtil.insertLangData(schemeId, Lang.en_US.name(), "Standard SM4-128 Encryption Scheme");
                    continue block8;
                }
                case vi_VN: {
                    EncryptionSchemeStandardLangUpgradeUtil.insertLangData(schemeId, Lang.vi_VN.name(), "M\u00e3 h\u00f3a ti\u00eau chu\u1ea9n sm4-128");
                    continue block8;
                }
                case AF: {
                    EncryptionSchemeStandardLangUpgradeUtil.insertLangData(schemeId, Lang.AF.name(), "Standaard SM4-128 koderingskema");
                    continue block8;
                }
                case th_TH: {
                    EncryptionSchemeStandardLangUpgradeUtil.insertLangData(schemeId, Lang.th_TH.name(), "\u0e23\u0e39\u0e1b\u0e41\u0e1a\u0e1a\u0e01\u0e32\u0e23\u0e40\u0e02\u0e49\u0e32\u0e23\u0e2b\u0e31\u0e2a\u0e21\u0e32\u0e15\u0e23\u0e10\u0e32\u0e19 SM4-128");
                    continue block8;
                }
            }
            EncryptionSchemeStandardLangUpgradeUtil.insertLangData(schemeId, lang.name(), KEY_SM4_NUMBER);
        }
    }

    private static void insetStandAES256SchemeLang(List<Lang> langList) {
        long schemeId = EncryptionSchemeStandardLangUpgradeUtil.getSchemeId(KEY_AES_NUMBER);
        if (schemeId == 0L) {
            return;
        }
        LocaleString localeString = ResManager.getLocaleString((String)"\u6807\u51c6AES-256\u52a0\u5bc6\u65b9\u6848", (String)"EncryptionSchemeStandardLangUpgradeUtil_4", (String)"bos-permission-cache");
        String localeValue = localeString.getLocaleValue();
        block8: for (Lang lang : langList) {
            switch (lang) {
                case zh_CN: {
                    EncryptionSchemeStandardLangUpgradeUtil.insertLangData(schemeId, Lang.zh_CN.name(), (String)localeString.getOrDefault((Object)Lang.zh_CN.toString(), (Object)localeValue));
                    continue block8;
                }
                case zh_TW: {
                    EncryptionSchemeStandardLangUpgradeUtil.insertLangData(schemeId, Lang.zh_TW.name(), (String)localeString.getOrDefault((Object)Lang.zh_TW.toString(), (Object)localeValue));
                    continue block8;
                }
                case en_US: {
                    EncryptionSchemeStandardLangUpgradeUtil.insertLangData(schemeId, Lang.en_US.name(), "Standard AES-256 Encryption Scheme");
                    continue block8;
                }
                case vi_VN: {
                    EncryptionSchemeStandardLangUpgradeUtil.insertLangData(schemeId, Lang.vi_VN.name(), "M\u00e3 h\u00f3a ti\u00eau chu\u1ea9n aes-256");
                    continue block8;
                }
                case AF: {
                    EncryptionSchemeStandardLangUpgradeUtil.insertLangData(schemeId, Lang.AF.name(), "Standaard AES-256 koderingskema");
                    continue block8;
                }
                case th_TH: {
                    EncryptionSchemeStandardLangUpgradeUtil.insertLangData(schemeId, Lang.th_TH.name(), "\u0e23\u0e39\u0e1b\u0e41\u0e1a\u0e1a\u0e01\u0e32\u0e23\u0e40\u0e02\u0e49\u0e32\u0e23\u0e2b\u0e31\u0e2a\u0e21\u0e32\u0e15\u0e23\u0e10\u0e32\u0e19 AES-256");
                    continue block8;
                }
            }
            EncryptionSchemeStandardLangUpgradeUtil.insertLangData(schemeId, lang.name(), KEY_AES_NUMBER);
        }
    }

    private static long getSchemeId(String schemeNumber) {
        String sql = "SELECT FID FROM T_PERM_ENCRYPTIONSCHEME WHERE FNUMBER = ?";
        return (Long)DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])new Object[]{schemeNumber}, rh -> {
            long id = 0L;
            if (rh.next()) {
                id = rh.getLong("FID");
            }
            return id;
        });
    }

    private static void insertLangData(long schemeId, String lang, String schemeName) {
        String sql = "DELETE FROM T_PERM_ENCRYPTIONSCHEME_L WHERE FID = ? and FLOCALEID = ? ";
        DB.execute((DBRoute)DBRoute.base, (String)sql, (Object[])new Object[]{schemeId, lang});
        sql = "INSERT INTO T_PERM_ENCRYPTIONSCHEME_L (FPKID, FID, FLOCALEID, FNAME) VALUES (?, ?, ?, ?)";
        ArrayList<Object> params = new ArrayList<Object>(4);
        String pkId = DB.genStringId((String)"T_PERM_ENCRYPTIONSCHEME_L");
        params.add(pkId);
        params.add(schemeId);
        params.add(lang);
        params.add(schemeName);
        DB.execute((DBRoute)DBRoute.base, (String)sql, (Object[])params.toArray());
    }

    private static List<Lang> getEnableLangList() {
        ArrayList<Lang> langList;
        try {
            List enabledLang = InteServiceHelper.getEnabledLang();
            langList = new ArrayList<Lang>(enabledLang.size());
            for (EnabledLang lang : enabledLang) {
                langList.add(Lang.from((String)lang.getNumber()));
            }
            LOG.debug("getEnableLangList return:" + langList);
        }
        catch (Exception ex) {
            LOG.error("getEnableLangList failed:" + ex);
            langList = new ArrayList(3);
            langList.add(Lang.zh_CN);
            langList.add(Lang.en_US);
            langList.add(Lang.zh_TW);
        }
        return langList;
    }
}

