/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.cache.util;

import java.sql.ResultSet;
import java.util.ArrayList;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class EncryptionSchemeStandardUpgradeUtil {
    private static final Log LOG = LogFactory.getLog(EncryptionSchemeStandardUpgradeUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean preset(UpgradeResult result, StringBuilder info) {
        boolean isSuccess;
        if (info == null) {
            info = new StringBuilder();
        }
        DLock lock = DLock.create((String)"kd.bos.permission.cache.util.EncryptionSchemeStandardUpgradeUtil");
        lock.lock();
        try (TXHandle handle = TX.requiresNew();){
            try {
                EncryptionSchemeStandardUpgradeUtil.discardOldSchemes();
                result.setLog(ResManager.loadKDString((String)"\u5f00\u59cb\u9884\u7f6e\u6807\u51c6SM4-128\u52a0\u5bc6\u65b9\u6848", (String)"EncryptionSchemeStandardUpgradeUtil_0", (String)"bos-permission-cache", (Object[])new Object[0]));
                EncryptionSchemeStandardUpgradeUtil.insetStandSM4128Scheme();
                result.setLog(ResManager.loadKDString((String)"\u5f00\u59cb\u9884\u7f6e\u6807\u51c6AES-256\u52a0\u5bc6\u65b9\u6848", (String)"EncryptionSchemeStandardUpgradeUtil_1", (String)"bos-permission-cache", (Object[])new Object[0]));
                EncryptionSchemeStandardUpgradeUtil.insetStandAES256Scheme();
                isSuccess = true;
            }
            catch (Exception ex) {
                info.append(ex.getMessage());
                LOG.error(String.format(ResManager.loadKDString((String)"\u52a0\u5bc6\u65b9\u6848\u9884\u7f6e\u5931\u8d25\uff0c\u539f\u56e0\uff1a%1$s", (String)"EncryptionSchemeLangUpgradeUtil_1", (String)"bos-permission-cache", (Object[])new Object[0]), ExceptionUtils.getExceptionStackTraceMessage((Exception)ex)));
                isSuccess = false;
                handle.markRollback();
            }
            finally {
                lock.unlock();
            }
        }
        return isSuccess;
    }

    private static void insetStandSM4128Scheme() {
        String schemeNumber = "STANDARD-SM4-128";
        String schemeName = ResManager.loadKDString((String)"\u6807\u51c6SM4-128\u52a0\u5bc6\u65b9\u6848", (String)"EncryptionSchemeStandardUpgradeUtil_2", (String)"bos-permission-cache", (Object[])new Object[0]);
        String algorithm = "SM4/GCM/NoPadding";
        String length = "128";
        String lang = RequestContext.get().getLang().name();
        long schemeId = EncryptionSchemeStandardUpgradeUtil.insert(schemeNumber, schemeName, algorithm, length);
        EncryptionSchemeStandardUpgradeUtil.insertLang(schemeId, schemeName, lang);
    }

    private static void insetStandAES256Scheme() {
        String schemeNumber = "STANDARD-AES-256";
        String schemeName = ResManager.loadKDString((String)"\u6807\u51c6AES-256\u52a0\u5bc6\u65b9\u6848", (String)"EncryptionSchemeStandardUpgradeUtil_3", (String)"bos-permission-cache", (Object[])new Object[0]);
        String algorithm = "AES/GCM/NoPadding";
        String length = "256";
        String lang = RequestContext.get().getLang().name();
        long schemeId = EncryptionSchemeStandardUpgradeUtil.insert(schemeNumber, schemeName, algorithm, length);
        EncryptionSchemeStandardUpgradeUtil.insertLang(schemeId, schemeName, lang);
    }

    private static long insert(String schemeNumber, String schemeName, String algorithm, String length) {
        String sql = "SELECT FID FROM T_PERM_ENCRYPTIONSCHEME WHERE FNUMBER = ?";
        long schemeId = (Long)DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])new Object[]{schemeNumber}, rh -> {
            long id = 0L;
            if (rh.next()) {
                id = rh.getLong("FID");
            }
            return id;
        });
        if (schemeId != 0L) {
            return schemeId;
        }
        sql = "INSERT INTO T_PERM_ENCRYPTIONSCHEME (FID, FALGORITHM, FLENGTH, FNUMBER, FNAME, FENABLE, FCREATORID, FCREATETIME, FISSYSTEM) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?);";
        ArrayList<Object> params = new ArrayList<Object>(9);
        schemeId = DB.genLongId((String)"T_PERM_ENCRYPTIONSCHEME");
        params.add(schemeId);
        params.add(algorithm);
        params.add(length);
        params.add(schemeNumber);
        params.add(schemeName);
        params.add("1");
        params.add(1);
        params.add(TimeServiceHelper.now());
        params.add("1");
        DB.execute((DBRoute)DBRoute.base, (String)sql, (Object[])params.toArray());
        return schemeId;
    }

    private static void insertLang(long schemeId, String schemeName, String lang) {
        String sql = "SELECT 1 FROM T_PERM_ENCRYPTIONSCHEME_L WHERE FID = ? and FLOCALEID = ?";
        boolean isExit = (Boolean)DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])new Object[]{schemeId, lang}, ResultSet::next);
        if (isExit) {
            return;
        }
        sql = "INSERT INTO T_PERM_ENCRYPTIONSCHEME_L (FPKID, FID, FLOCALEID, FNAME) VALUES (?, ?, ?, ?)";
        ArrayList<Object> params = new ArrayList<Object>(4);
        String pkId = DB.genStringId((String)"T_PERM_ENCRYPTIONSCHEME_L");
        params.add(pkId);
        params.add(schemeId);
        params.add(lang);
        params.add(schemeName);
        DB.execute((DBRoute)DBRoute.base, (String)sql, (Object[])params.toArray());
    }

    private static void discardOldSchemes() {
        String sql = "UPDATE T_PERM_ENCRYPTIONSCHEME set fnumber = ?, fname = ?, fenable = ? WHERE FID = ?;";
        ArrayList<Object[]> params = new ArrayList<Object[]>(2);
        Object[] param = new Object[]{"STANDARD-SM4-128-DISPOSAL", ResManager.loadKDString((String)"\u6807\u51c6SM4-128\u52a0\u5bc6\u65b9\u6848\uff08\u5e9f\u5f03\uff09", (String)"EncryptionSchemeStandardUpgradeUtil_4", (String)"bos-permission-cache", (Object[])new Object[0]), "2", 100001};
        params.add(param);
        param = new Object[]{"STANDARD-AES-256-DISPOSAL", ResManager.loadKDString((String)"\u6807\u51c6AES-256\u52a0\u5bc6\u65b9\u6848\uff08\u5e9f\u5f03\uff09", (String)"EncryptionSchemeStandardUpgradeUtil_5", (String)"bos-permission-cache", (Object[])new Object[0]), "2", 100002};
        params.add(param);
        DB.executeBatch((DBRoute)DBRoute.base, (String)sql, params);
    }
}

