/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.cache.util;

import java.sql.ResultSet;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class EncryptionSchemeUpgradeUtil {
    private static final Log LOG = LogFactory.getLog(EncryptionSchemeUpgradeUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean preset(String schemeNumber, StringBuilder info) {
        boolean isSuccess;
        if (info == null) {
            info = new StringBuilder();
        }
        DLock lock = DLock.create((String)"kd.bos.permission.cache.util.EncryptionSchemeUpgradeUtil");
        lock.lock();
        try (TXHandle handle = TX.requiresNew();){
            try {
                EncryptionSchemeUpgradeUtil.insert(schemeNumber);
                isSuccess = true;
            }
            catch (Exception ex) {
                info.append(ex.getMessage());
                LOG.error(String.format(ResManager.loadKDString((String)"\u52a0\u5bc6\u65b9\u6848\u9884\u7f6e\u5931\u8d25\uff0c\u539f\u56e0\uff1a%1$s", (String)"EncryptionSchemeUpgradeUtil_1", (String)"bos-permission-cache", (Object[])new Object[0]), ExceptionUtils.getExceptionStackTraceMessage((Exception)ex)));
                isSuccess = false;
                handle.markRollback();
            }
            finally {
                lock.unlock();
            }
        }
        return isSuccess;
    }

    private static void insert(String schemeNumber) {
        String sql = "SELECT 1 FROM T_PERM_ENCRYPTIONSCHEME WHERE FNUMBER = ?";
        boolean isExit = (Boolean)DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])new Object[]{schemeNumber}, ResultSet::next);
        if (isExit) {
            return;
        }
        sql = "INSERT INTO T_PERM_ENCRYPTIONSCHEME (FID, FALGORITHM, FLENGTH, FNUMBER, FNAME, FENABLE, FCREATORID, FCREATETIME, FISSYSTEM) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?);";
        ArrayList<Object> params = new ArrayList<Object>(9);
        long schemeId = DB.genLongId((String)"T_PERM_ENCRYPTIONSCHEME");
        params.add(schemeId);
        params.add("AES/GCM/NoPadding");
        params.add("128");
        params.add(schemeNumber);
        params.add(ResManager.loadKDString((String)"\u8bb8\u53ef\u4ef7\u7b7e\u9ed8\u8ba4\u52a0\u5bc6\u65b9\u6848", (String)"EncryptionSchemeUpgradeUtil_0", (String)"bos-permission-cache", (Object[])new Object[0]));
        params.add("1");
        params.add(1);
        params.add(TimeServiceHelper.now());
        params.add("1");
        DB.execute((DBRoute)DBRoute.base, (String)sql, (Object[])params.toArray());
    }
}

