/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.cache.util;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Sets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.CloudHelper;
import kd.bos.permission.cache.helper.FormHelper;
import kd.bos.permission.cache.model.permbase.App;
import kd.bos.permission.cache.model.permbase.Cloud;
import kd.bos.permission.model.perm.Entity;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class NotOriPublishAppFormAuthorizeUtil {
    private static final Log logger = LogFactory.getLog(NotOriPublishAppFormAuthorizeUtil.class);

    public static List<Map<String, String>> getList(Set<String> cloudIdSet) {
        try {
            Set<App> oriAppSet = AppHelper.getOriAppSet(cloudIdSet);
            if (null == oriAppSet || oriAppSet.isEmpty()) {
                logger.debug("NotOriPublishAppFormAuthorizeUtil getList, oriAppSet is empty");
                return new ArrayList<Map<String, String>>(1);
            }
            Map<String, String> appIdOriIdMap = AppHelper.getExtAppAndOrgnlAppRelPrivate(new HashSet<String>(1));
            logger.debug("NotOriPublishAppFormAuthorizeUtil.upgrade.appIdOriIdMap: {}", (Object)JSON.toJSONString(appIdOriIdMap));
            Map<String, String> extEntIdAndOriEntNumMap = FormHelper.getExtEntIdAndOriEntNumMap();
            logger.debug("NotOriPublishAppFormAuthorizeUtil.extEntIdAndOriEntNumMap: {}", (Object)JSON.toJSONString(extEntIdAndOriEntNumMap));
            Map<String, String> appNumIdMap = AppHelper.getAppNumIdMap(new HashSet<String>(1));
            Map<String, Set<String>> directMenuEntNumAppIdSetMap = NotOriPublishAppFormAuthorizeUtil.getDirectMenuEntNumAppIdSetMap(appIdOriIdMap, extEntIdAndOriEntNumMap, appNumIdMap);
            if (null == directMenuEntNumAppIdSetMap || directMenuEntNumAppIdSetMap.isEmpty()) {
                logger.debug("NotOriPublishAppFormAuthorizeUtil getList, directMenuEntNumAppIdSetMap is empty");
                return new ArrayList<Map<String, String>>(1);
            }
            logger.debug("NotOriPublishAppFormAuthorizeUtil.upgrade.directMenuEntNumAppIdSetMap: {}", (Object)JSON.toJSONString(directMenuEntNumAppIdSetMap));
            return NotOriPublishAppFormAuthorizeUtil.getResultList(cloudIdSet, appIdOriIdMap, directMenuEntNumAppIdSetMap, extEntIdAndOriEntNumMap, appNumIdMap);
        }
        catch (Exception e) {
            logger.warn("NotOriPublishAppFormAuthorizeUtil.upgrade error", (Throwable)e);
            return new ArrayList<Map<String, String>>(1);
        }
    }

    private static List<Map<String, String>> getResultList(Set<String> cloudIdSet, Map<String, String> appIdOriIdMap, Map<String, Set<String>> directMenuEntNumAppIdSetMap, Map<String, String> extEntIdAndOriEntNumMap, Map<String, String> appNumIdMap) {
        Set<String> directMenuEntNumSet = directMenuEntNumAppIdSetMap.keySet();
        Map<String, String> entNumOriAppIdMap = NotOriPublishAppFormAuthorizeUtil.getEntNumOriAppIdMap(appIdOriIdMap, directMenuEntNumSet);
        HashSet<String> allAppIdSet = new HashSet<String>(8);
        HashSet<String> allEntNumSet = new HashSet<String>(8);
        allAppIdSet.addAll(entNumOriAppIdMap.values());
        allEntNumSet.addAll(entNumOriAppIdMap.keySet());
        for (Map.Entry<String, Set<String>> directMenuEntNumAppIdSet : directMenuEntNumAppIdSetMap.entrySet()) {
            allAppIdSet.addAll((Collection<String>)directMenuEntNumAppIdSet.getValue());
            allEntNumSet.add(directMenuEntNumAppIdSet.getKey());
        }
        Map<String, Cloud> cloudMap = CloudHelper.getCloudMap(allAppIdSet);
        Map<String, App> appInfoMap = AppHelper.getAppMap(allAppIdSet);
        Map<String, Entity> entityInfoMap = FormHelper.getEntityInfoMap(allEntNumSet);
        Map<String, String> appEntMenuNameMap = NotOriPublishAppFormAuthorizeUtil.getAppEntMenuNameMap(extEntIdAndOriEntNumMap, appNumIdMap);
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>(10);
        HashMap<String, String> map = null;
        for (Map.Entry<String, Set<String>> directMenuEntNumAppIdSet : directMenuEntNumAppIdSetMap.entrySet()) {
            String appId;
            String entNumOne = directMenuEntNumAppIdSet.getKey();
            Set<String> value = directMenuEntNumAppIdSet.getValue();
            if (StringUtils.isEmpty((String)entNumOne) || null == value || value.isEmpty() || StringUtils.isEmpty((String)(appId = entNumOriAppIdMap.get(entNumOne)))) continue;
            for (String directMenuAppId : value) {
                Cloud menuCloud;
                map = new HashMap<String, String>(16);
                Cloud cloud = cloudMap.get(appId);
                if (null != cloud) {
                    String cloudId = cloud.getCloudId();
                    if (!CollectionUtils.isEmpty(cloudIdSet) && StringUtils.isNotEmpty((String)cloudId) && !cloudIdSet.contains(cloudId)) continue;
                    map.put("cloudId", cloudId);
                    map.put("cloudNumber", cloud.getCloudNumber());
                    map.put("cloudName", cloud.getCloudName());
                }
                map.put("appId", appId);
                App appInfo = appInfoMap.get(appId);
                if (null != appInfo) {
                    map.put("appNumber", appInfo.getAppNumber());
                    map.put("appName", appInfo.getAppName());
                }
                map.put("entNum", entNumOne);
                Entity entity = entityInfoMap.get(entNumOne);
                if (null != entity) {
                    map.put("entId", entity.getEntityId());
                    map.put("entName", entity.getEntityName());
                }
                if (null != (menuCloud = cloudMap.get(directMenuAppId))) {
                    map.put("menuCloudId", menuCloud.getCloudId());
                    map.put("menuCloudNumber", menuCloud.getCloudNumber());
                    map.put("menuCloudName", menuCloud.getCloudName());
                }
                map.put("menuAppId", directMenuAppId);
                App directMenuAppInfo = appInfoMap.get(directMenuAppId);
                if (null != directMenuAppInfo) {
                    map.put("menuAppNumber", directMenuAppInfo.getAppNumber());
                    map.put("menuAppName", directMenuAppInfo.getAppName());
                }
                map.put("menuName", appEntMenuNameMap.get(directMenuAppId + "|" + entNumOne));
                list.add(map);
            }
        }
        return list;
    }

    private static Map<String, String> getAppEntMenuNameMap(final Map<String, String> extEntIdAndOriEntNumMap, final Map<String, String> appNumIdMap) {
        StringBuilder sb = new StringBuilder();
        sb.append("select a.fappid, b.fentityid, aL.fname");
        sb.append(" from t_meta_menuruntime a");
        sb.append(" inner join t_meta_formdesign b on b.fnumber = a.fformid");
        sb.append(" left join t_meta_menuruntime_l aL on aL.fid = a.fid and aL.flocaleid = ?");
        sb.append(" where a.fformid != '' and a.fformid != ' ' and a.fformid is not null");
        return (Map)DB.query((DBRoute)DBRoute.meta, (String)sb.toString(), (Object[])new Object[]{RequestContext.get().getLang().name()}, (ResultSetHandler)new ResultSetHandler<Map<String, String>>(){

            public Map<String, String> handle(ResultSet rs) throws SQLException {
                HashMap<String, String> map = new HashMap<String, String>(8);
                while (rs.next()) {
                    String fappnum = rs.getString("fappid");
                    String appId = (String)appNumIdMap.get(fappnum);
                    String fentityid = rs.getString("fentityid");
                    String entityNum = (String)extEntIdAndOriEntNumMap.get(fentityid);
                    if (StringUtils.isEmpty((String)appId) || StringUtils.isEmpty((String)entityNum)) continue;
                    String menuName = rs.getString("fname");
                    String menuNameStr = (String)map.get(appId + "|" + entityNum);
                    if (StringUtils.isEmpty((String)menuNameStr)) {
                        map.put(appId + "|" + entityNum, menuName);
                        continue;
                    }
                    menuName = menuNameStr + "\u3001" + menuName;
                    map.put(appId + "|" + entityNum, menuName);
                }
                return map;
            }
        });
    }

    private static Map<String, String> getEntNumOriAppIdMap(final Map<String, String> appIdOriIdMap, Set<String> directMenuEntNumSet) {
        if (null == directMenuEntNumSet || directMenuEntNumSet.isEmpty()) {
            return new HashMap<String, String>(1);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("select distinct b.fbizappid, a.fnumber");
        sb.append(" from t_meta_entitydesign a");
        sb.append(" inner join t_meta_bizunitrelform b on b.fformid = a.fid");
        String directMenuEntNumSetStr = String.join((CharSequence)"','", directMenuEntNumSet);
        sb.append("  where a.fnumber in ('").append(directMenuEntNumSetStr).append("')");
        return (Map)DB.query((DBRoute)DBRoute.meta, (String)sb.toString(), (ResultSetHandler)new ResultSetHandler<Map<String, String>>(){

            public Map<String, String> handle(ResultSet rs) throws Exception {
                HashMap<String, String> map = new HashMap<String, String>(8);
                while (rs.next()) {
                    String fbizappid = rs.getString("fbizappid");
                    String fnumber = rs.getString("fnumber");
                    String oriAppId = (String)appIdOriIdMap.get(fbizappid);
                    if (StringUtils.isEmpty((String)oriAppId) || StringUtils.isEmpty((String)fnumber)) continue;
                    map.put(fnumber, oriAppId);
                }
                return map;
            }
        });
    }

    private static Map<String, Set<String>> getDirectMenuEntNumAppIdSetMap(Map<String, String> appIdOriIdMap, Map<String, String> extEntIdAndOriEntNumMap, Map<String, String> appNumIdMap) {
        Set<Entity> oriEntitySet = NotOriPublishAppFormAuthorizeUtil.getOriEntitySet(extEntIdAndOriEntNumMap, appIdOriIdMap);
        logger.debug("NotOriPublishAppFormAuthorizeUtil.oriEntitySet: {}", (Object)JSON.toJSONString(oriEntitySet));
        Set<Entity> publishEntitySet = NotOriPublishAppFormAuthorizeUtil.getPublishEntitySet();
        logger.debug("NotOriPublishAppFormAuthorizeUtil.publishEntitySet: {}", (Object)JSON.toJSONString(publishEntitySet));
        oriEntitySet.addAll(publishEntitySet);
        logger.debug("NotOriPublishAppFormAuthorizeUtil.oriEntitySet2: {}", (Object)JSON.toJSONString(oriEntitySet));
        Set<Entity> linkMenuEntitySet = NotOriPublishAppFormAuthorizeUtil.getLinkMenuEntitySet(extEntIdAndOriEntNumMap, null, appNumIdMap);
        logger.debug("NotOriPublishAppFormAuthorizeUtil.linkMenuEntitySet: {}", (Object)JSON.toJSONString(linkMenuEntitySet));
        Sets.SetView diffSet = Sets.difference(linkMenuEntitySet, oriEntitySet);
        if (null == diffSet || diffSet.isEmpty()) {
            return new HashMap<String, Set<String>>(1);
        }
        logger.debug("NotOriPublishAppFormAuthorizeUtil.diffSet: {}", (Object)JSON.toJSONString((Object)diffSet));
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>(8);
        for (Entity entity : diffSet) {
            map.computeIfAbsent(entity.getEntityNumber(), k -> new HashSet(8)).add(entity.getAppId());
        }
        return map;
    }

    private static Set<Entity> getLinkMenuEntitySet(final Map<String, String> extEntIdAndOriEntNumMap, Set<String> oriAppNumberParamSet, final Map<String, String> appNumIdMap) {
        logger.debug("appNumIdMap: {}", (Object)JSON.toJSONString(appNumIdMap));
        StringBuilder sb = new StringBuilder();
        sb.append("select distinct a.fappid, b.fentityid");
        sb.append(" from t_meta_menuruntime a");
        sb.append(" inner join t_meta_formdesign b on b.fnumber = a.fformid");
        sb.append(" where a.fformid != '' and a.fformid != ' ' and a.fformid is not null");
        if (null != oriAppNumberParamSet && !oriAppNumberParamSet.isEmpty()) {
            String oriAppNumberParamSetStr = String.join((CharSequence)"','", oriAppNumberParamSet);
            sb.append(" and a.fappid in ('").append(oriAppNumberParamSetStr).append("')");
        }
        return (Set)DB.query((DBRoute)DBRoute.meta, (String)sb.toString(), (ResultSetHandler)new ResultSetHandler<Set<Entity>>(){

            public Set<Entity> handle(ResultSet rs) throws Exception {
                HashSet<Entity> set = new HashSet<Entity>(8);
                Entity entity = null;
                while (rs.next()) {
                    String oriAppNum = rs.getString("fappid");
                    String fentityid = rs.getString("fentityid");
                    String oriAppId = (String)appNumIdMap.get(oriAppNum);
                    String oriEntNum = (String)extEntIdAndOriEntNumMap.get(fentityid);
                    if (StringUtils.isEmpty((String)oriAppId) || StringUtils.isEmpty((String)oriEntNum)) continue;
                    entity = new Entity();
                    entity.setAppId(oriAppId);
                    entity.setEntityNumber(oriEntNum);
                    set.add(entity);
                }
                return set;
            }
        });
    }

    private static Set<Entity> getPublishEntitySet() {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT distinct fbizappid, fbizobjid FROM t_perm_bizobjapp");
        return (Set)DB.query((DBRoute)DBRoute.permission, (String)sb.toString(), (ResultSetHandler)new ResultSetHandler<Set<Entity>>(){

            public Set<Entity> handle(ResultSet rs) throws Exception {
                HashSet<Entity> set = new HashSet<Entity>(8);
                Entity entity = null;
                while (rs.next()) {
                    String fbizappid = rs.getString("fbizappid");
                    String fbizobjid = rs.getString("fbizobjid");
                    entity = new Entity();
                    if (StringUtils.isEmpty((String)fbizappid) || StringUtils.isEmpty((String)fbizobjid)) continue;
                    entity.setAppId(fbizappid);
                    entity.setEntityNumber(fbizobjid);
                    set.add(entity);
                }
                return set;
            }
        });
    }

    private static Set<Entity> getOriEntitySet(final Map<String, String> extEntIdAndOriEntNumMap, final Map<String, String> appIdOriIdMap) {
        StringBuilder sb = new StringBuilder();
        sb.append("select distinct a.fbizappid, a.fformid");
        sb.append(" from t_meta_bizunitrelform a");
        sb.append(" inner join t_meta_entitydesign b on a.fformid = b.fid");
        return (Set)DB.query((DBRoute)DBRoute.meta, (String)sb.toString(), (ResultSetHandler)new ResultSetHandler<Set<Entity>>(){

            public Set<Entity> handle(ResultSet rs) throws Exception {
                HashSet<Entity> set = new HashSet<Entity>(8);
                Entity entity = null;
                while (rs.next()) {
                    String fbizappid = rs.getString("fbizappid");
                    String fformid = rs.getString("fformid");
                    entity = new Entity();
                    String oriAppId = (String)appIdOriIdMap.get(fbizappid);
                    String oriEntNum = (String)extEntIdAndOriEntNumMap.get(fformid);
                    if (StringUtils.isEmpty((String)oriAppId) || StringUtils.isEmpty((String)oriEntNum)) continue;
                    entity.setAppId(oriAppId);
                    entity.setEntityNumber(oriEntNum);
                    set.add(entity);
                }
                return set;
            }
        });
    }
}

