/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.cache.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.PermissionControlType;
import kd.bos.entity.RuntimeMetaType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.filter.CompareType;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.FieldName;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterBuilderParameter;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.filter.FilterObject;
import kd.bos.entity.filter.FilterRow;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.list.JoinProperty;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.RefBillProp;
import kd.bos.entity.property.org.OrgViewSchemeProp;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginCall;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.IFormView;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.ItemClassTypeEdit;
import kd.bos.framework.gray.GrayStrategy;
import kd.bos.license.api.ILicenseService;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.FormConfigFactory;
import kd.bos.mvc.report.ReportView;
import kd.bos.org.api.IOrgService;
import kd.bos.org.model.BizViewQueryParam;
import kd.bos.orm.query.MultiBaseDataFilterValue;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.param.ParameterOrgUtils;
import kd.bos.param.service.IParameterHelperService;
import kd.bos.permission.api.DataRuleResult;
import kd.bos.permission.api.DataRuleSingleResult;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.permission.api.PermissionService;
import kd.bos.permission.api.ext.IPermCtrlTypeExt;
import kd.bos.permission.cache.BizRoleService;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.cache.SuperUserCache;
import kd.bos.permission.cache.UserBizRoleCache;
import kd.bos.permission.cache.constant.PermHelperConst;
import kd.bos.permission.cache.helper.AdminSchemeHelper;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.DirectAuthorizeHelper;
import kd.bos.permission.cache.helper.DrHelper;
import kd.bos.permission.cache.helper.FormHelper;
import kd.bos.permission.cache.helper.IsoDimHelper;
import kd.bos.permission.cache.helper.MenuHelper;
import kd.bos.permission.cache.helper.OperationHelper;
import kd.bos.permission.cache.helper.PermBusiRoleHelper;
import kd.bos.permission.cache.helper.PermGrayHelper;
import kd.bos.permission.cache.helper.PermRoleHelper;
import kd.bos.permission.cache.helper.UserHelper;
import kd.bos.permission.cache.model.CustomPermServInfo;
import kd.bos.permission.cache.model.User;
import kd.bos.permission.cache.model.UserPermResult;
import kd.bos.permission.cache.util.DateUtil;
import kd.bos.permission.cache.util.ListUtil;
import kd.bos.permission.cache.util.PermLocalCacheUtil;
import kd.bos.permission.cache.util.SqlUtil;
import kd.bos.permission.model.perm.PermBuilder;
import kd.bos.permission.model.perm.PermCtrlType;
import kd.bos.permission.model.perm.req.PermCtrlTypeReq;
import kd.bos.permission.model.perm.req.common.GetBaseDataDynMapReq;
import kd.bos.permission.model.perm.req.permctrltype.GetSuitableDimTypeReq;
import kd.bos.permission.model.perm.req.permctrltype.GetTreeShowFormCtrlTypeReq;
import kd.bos.permission.model.perm.resp.common.GetBaseDataDynMapResp;
import kd.bos.permission.model.perm.resp.permctrltype.GetSuitableDimTypeResp;
import kd.bos.permission.model.perm.resp.permctrltype.GetTreeShowFormCtrlTypeResp;
import kd.bos.product.ProductSettingService;
import kd.bos.service.DispatchService;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import kd.bos.service.ServiceFactory;
import kd.bos.service.ServiceSvcFactory;
import kd.bos.service.TimeService;
import kd.bos.service.lookup.ServiceLookup;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.portal.InitailVersionServiceHelper;
import kd.bos.servicehelper.runmode.RunModeServiceHelper;
import kd.bos.servicehelper.user.UserService;
import kd.bos.session.SessionQuery;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

public class PermCommonUtil {
    private static Log logger = LogFactory.getLog(PermCommonUtil.class);
    private static ThreadPool pool = ThreadPools.newFixedThreadPool((String)"Perm_PermCommonUtil_Pool", (int)2);
    private static Object getPermControlType_objectLock = new Object();
    private static final String FIELDNAME = "fieldName";
    @Deprecated
    @SdkInternal
    public static final String MENUID_ADMINTYPE = "/SLXK+KV6J9S";
    @Deprecated
    @SdkInternal
    public static final String MENUID_VIRTUAL_ADMIN = "/SLXJ2Z=GE0J";
    @Deprecated
    @SdkInternal
    public static final String MENUID_ADMIN_PERM = "/SLXLT9=3VCC";
    @Deprecated
    @SdkInternal
    public static final String MENUID_ADMIN = "18XQ/L5XWABD";
    @SdkInternal
    public static final String SEQ_FIRST_PERMCTRLFIELD = "1";
    @SdkInternal
    public static final String SEQ_SEC_PERMCTRLFIELD = "2";
    @Deprecated
    @SdkInternal
    public static final String ENTNUM_PERM_ALLFIELDBILL = "perm_allfieldbill";
    private static final String FLAG_HASLOADEDFROMCACHE = "flag_hasLoadedFromCache";
    private static final String PROP_UPD_ENTNUM = "upd_entnum";
    private static final String PROP_ENT_NUM = "ent_num";
    private static final String PROP_ENT_ID = "ent_id";
    private static final String PROP_RPD_ENTNUM = "rpd_entnum";
    private static final String PROP_DFP_ENTNUM = "dfp_entnum";
    private static final String PROP_DFP_PERMITEMID = "dfp_permitemid";
    private static final String PROP_DFP_APPID = "dfp_appid";
    private static final String PROP_BRP_ENTNUM = "brp_entnum";
    private static final String PROP_BRCR_ENTNUM = "brcr_entnum";

    @Deprecated
    @SdkInternal
    public static Map<String, Map<String, List<String>>> getUserPermDetailByUser(Long userId) {
        return DirectAuthorizeHelper.getUserPermDetailByUser(userId);
    }

    @SdkInternal
    public static List<Long> getRobotIds() {
        StringBuilder robotIds = new StringBuilder().append("select fid from t_sec_usertypes where fbasedataid = '6' ");
        List robotResultList = (List)DB.query((DBRoute)DBRoute.permission, (String)robotIds.toString(), (ResultSetHandler)new ResultSetHandler<List<Long>>(){

            public List<Long> handle(ResultSet rs) throws Exception {
                ArrayList<Long> resultList = new ArrayList<Long>(1);
                while (rs.next()) {
                    Long fid = rs.getLong("fid");
                    resultList.add(fid);
                }
                return resultList;
            }
        });
        return robotResultList;
    }

    @SdkInternal
    public static void checkRobots(Long userId, String tips) {
        if (PermCommonUtil.getRobotIds().contains(userId)) {
            throw new KDBizException(tips);
        }
    }

    @SdkInternal
    public static void checkUserEnable(Long userIdl, String tips) {
        Map<Long, Boolean> userEnableMap = UserHelper.getUserEnableMap(Sets.newHashSet((Object[])new Long[]{userIdl}));
        if (null == userEnableMap || !userEnableMap.get(userIdl).booleanValue()) {
            throw new KDBizException(tips);
        }
    }

    public static List<Long> getUserByRole(String roleId) {
        HashSet<String> roleIdSet = new HashSet<String>(1);
        roleIdSet.add(roleId);
        Set<Long> userIdSet = PermRoleHelper.getEnableUserIds(roleIdSet);
        return new ArrayList<Long>(userIdSet);
    }

    public static List<Long> getUserByRole(List<String> roleIds) {
        Set<Long> userIdSet = PermRoleHelper.getEnableUserIds(new HashSet<String>(roleIds));
        return new ArrayList<Long>(userIdSet);
    }

    @Deprecated
    @SdkInternal
    public static List<Long> getInfluencedUserByRole(List<String> roleIds) {
        HashSet roleUserIdSet = new HashSet(8);
        Map<String, Set<Long>> roleUserIdSetMap = PermRoleHelper.getRoleUserIdSetMap(new HashSet<String>(roleIds));
        for (Map.Entry<String, Set<Long>> entry : roleUserIdSetMap.entrySet()) {
            roleUserIdSet.addAll(entry.getValue());
        }
        return new ArrayList<Long>(roleUserIdSet);
    }

    @Deprecated
    @SdkInternal
    public static List<Long> getUserByBizRole(String bizRoleId) {
        return BizRoleService.getUsersByBizRoleID(Long.valueOf(bizRoleId));
    }

    @SdkInternal
    public static Map<String, List<String>> getAppEntityByBizRole(Long bizRoleId) {
        String bizRoleIdStr = String.valueOf(bizRoleId);
        Map<String, Map<String, List<String>>> appEntityByBizRole = PermBusiRoleHelper.getAppEntityByBizRole(Sets.newHashSet((Object[])new String[]{bizRoleIdStr}), "id");
        return appEntityByBizRole.get(bizRoleIdStr);
    }

    @Deprecated
    @SdkInternal
    public static boolean hasPermInSpecificMap(String entityNum, String permItemId, Map<String, Map<String, Set<String>>> hasPermMap, Map<String, String> checkPermEntityAppMap) {
        String appIdForCheckPerm = checkPermEntityAppMap.get(entityNum);
        Set bindPermItems = EntityMetadataCache.getPermissionItems((String)entityNum);
        if (!bindPermItems.contains(permItemId)) {
            return true;
        }
        if (hasPermMap == null || hasPermMap.size() == 0) {
            return false;
        }
        Map<String, Set<String>> entityPermMap = hasPermMap.get(appIdForCheckPerm);
        if (entityPermMap == null || entityPermMap.size() == 0) {
            return false;
        }
        Set<String> permItemIds = entityPermMap.get(entityNum);
        if (permItemIds == null || permItemIds.size() == 0) {
            return false;
        }
        return permItemIds.contains(permItemId);
    }

    @SdkInternal
    public static String getEntityNumByFormNum(String formNum) {
        String entityNum;
        try {
            entityNum = FormMetadataCache.getFormConfig((String)formNum).getEntityTypeId();
        }
        catch (Exception e) {
            logger.warn(String.format("\u83b7\u53d6\u8868\u5355 %s \u5bf9\u5e94\u7684\u5b9e\u4f53\u6807\u8bc6\u65f6\u51fa\u9519", formNum), (Throwable)e);
            return null;
        }
        if (entityNum != null && entityNum.equals("empty")) {
            entityNum = formNum;
        }
        return entityNum;
    }

    public static Map<String, String> getEntityNumsByFormNums(List<String> pFormNumList) {
        ArrayList<String> pFormNums = null == pFormNumList || pFormNumList.isEmpty() ? new ArrayList<String>(0) : new ArrayList<String>(pFormNumList);
        Map<String, String> results = FormHelper.getFormEntNumMap(new HashSet<String>(pFormNums));
        if (pFormNums != null && !pFormNums.isEmpty()) {
            pFormNums.removeAll(results.keySet());
            if (!CollectionUtils.isEmpty(pFormNums)) {
                Map<String, String> resultsGrayMap = FormHelper.getFormEntNumMap(new HashSet<String>(pFormNums));
                results.putAll(resultsGrayMap);
            }
        }
        return results;
    }

    @SdkInternal
    public static boolean isSuperUser(long userId) {
        return SuperUserCache.isSuperUser(userId);
    }

    @SdkInternal
    public static List<String> getFormNumFromMenuMeta(List<AppMenuInfo> menuList) {
        HashSet<String> allMenuFormNums = new HashSet<String>(8);
        for (AppMenuInfo appMenuInfo : menuList) {
            String formNum = appMenuInfo.getFormId();
            if (StringUtils.isEmpty((String)formNum)) continue;
            allMenuFormNums.add(formNum);
        }
        return new ArrayList<String>(allMenuFormNums);
    }

    @SdkInternal
    public static List<String> getHasBindPermFormNums(List<String> allMenuFormNums) {
        return PermCommonUtil.getHasBindPermFormNums(allMenuFormNums, null);
    }

    @SdkInternal
    public static List<String> getHasBindPermFormNums(List<String> allMenuFormNums, Map<String, Set<String>> entityPermItemMap) {
        return PermCommonUtil.getHasBindPermFormNums(allMenuFormNums, entityPermItemMap, null);
    }

    @SdkInternal
    public static List<String> getHasBindPermFormNums(List<String> allMenuFormNums, Map<String, Set<String>> entityPermItemMap, Map<String, Object> paramMap) {
        Map menu_formEntityNumMap;
        if (null == paramMap) {
            paramMap = new HashMap<String, Object>(1);
        }
        if (allMenuFormNums == null || allMenuFormNums.size() == 0) {
            return new ArrayList<String>(0);
        }
        Map map = menu_formEntityNumMap = null == paramMap.get("menu_formEntityNumMap") ? PermCommonUtil.getEntityNumsByFormNums(allMenuFormNums) : (Map)paramMap.get("menu_formEntityNumMap");
        if (null == menu_formEntityNumMap || menu_formEntityNumMap.isEmpty()) {
            return new ArrayList<String>(0);
        }
        Set<String> entNumSet = menu_formEntityNumMap.values().stream().collect(Collectors.toSet());
        if (null == entNumSet || entNumSet.isEmpty()) {
            return new ArrayList<String>(0);
        }
        Map<String, Set<String>> entPermItemIdSetMap = FormHelper.getEntPermItemIdSetMap(entNumSet);
        HashSet<String> numSet = new HashSet<String>(8);
        boolean isCtrlFunction = true;
        for (String entNum : entNumSet) {
            Set<String> permitems;
            try {
                isCtrlFunction = FormHelper.getPermissionControlType(entNum).isControlFunction();
            }
            catch (Exception e) {
                logger.warn("PermCommonUtil.getHasBindPermFormNums error.", (Throwable)e);
            }
            if (!isCtrlFunction || null == (permitems = entPermItemIdSetMap.get(entNum)) || permitems.isEmpty()) continue;
            numSet.add(entNum);
            entityPermItemMap.computeIfAbsent(entNum, k -> new HashSet(8)).addAll(permitems);
        }
        return new ArrayList<String>(numSet);
    }

    @SdkInternal
    public static List<String> hasBindFuncPermFormNums(List<String> entityNums) {
        return PermCommonUtil.hasBindFuncPermFormNums(entityNums, null);
    }

    @SdkInternal
    public static List<String> hasBindFuncPermFormNums(List<String> entityNums, Map<String, Set<String>> entityPermItemMap) {
        if (null == entityNums || entityNums.isEmpty()) {
            return new ArrayList<String>(0);
        }
        HashSet<String> numSet = new HashSet<String>(8);
        for (String entNum : entityNums) {
            numSet.add(entNum);
            Set permitems = EntityMetadataCache.getPermissionItems((String)entNum);
            if (null == entityPermItemMap) continue;
            entityPermItemMap.computeIfAbsent(entNum, k -> new HashSet(8)).addAll(permitems);
        }
        return new ArrayList<String>(numSet);
    }

    @Deprecated
    @SdkInternal
    public static Map<String, String> getCheckPermEntityAppMap3(String curAppId, List<String> entityNums) {
        Map<String, String> extAppOrgnlAppMap = AppHelper.getExtAppAndOrgnlAppRel(new HashSet<String>(1));
        HashMap<String, Object> extAppAndOrgnlAppRelParamMap = new HashMap<String, Object>(8);
        extAppAndOrgnlAppRelParamMap.put("entityNumList", entityNums);
        extAppAndOrgnlAppRelParamMap.put("extAppOrgnlAppMap", extAppOrgnlAppMap);
        Map<String, String> entOriAppIdMap = FormHelper.getAppIdByFormNum(extAppAndOrgnlAppRelParamMap);
        return PermCommonUtil.getCheckPermEntityAppMap3(curAppId, entityNums, entOriAppIdMap);
    }

    @Deprecated
    @SdkInternal
    public static Map<String, String> getCheckPermEntityAppMap3(String curAppId, List<String> entityNums, Map<String, String> entOriAppIdMap) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(8);
        paramMap.put("entOriAppIdMap", entOriAppIdMap);
        Map<String, String> extAppOrgnlAppMap = AppHelper.getExtAppAndOrgnlAppRel(new HashSet<String>(1));
        paramMap.put("extAppOrgnlAppMap", extAppOrgnlAppMap);
        return PermCommonUtil.getCheckPermEntityAppMap3New(curAppId, entityNums, paramMap);
    }

    @SdkInternal
    public static Map<String, String> getCheckPermEntityAppMap3New(String curAppId, List<String> entityNums, Map<String, Object> paramMap) {
        HashMap<String, Object> extAppAndOrgnlAppRelParamMap;
        Map<String, String> entOriAppIdMap = null;
        Map<String, String> extAppOrgnlAppMap = null;
        if (null == paramMap) {
            extAppOrgnlAppMap = AppHelper.getExtAppAndOrgnlAppRel(new HashSet<String>(1));
            extAppAndOrgnlAppRelParamMap = new HashMap<String, Object>(8);
            extAppAndOrgnlAppRelParamMap.put("entityNumList", entityNums);
            extAppAndOrgnlAppRelParamMap.put("extAppOrgnlAppMap", extAppOrgnlAppMap);
            extAppAndOrgnlAppRelParamMap.put("perm_formEntityNumMap", new HashMap(0));
            entOriAppIdMap = FormHelper.getAppIdByFormNum(extAppAndOrgnlAppRelParamMap);
        } else {
            extAppOrgnlAppMap = null == paramMap.get("extAppOrgnlAppMap") ? AppHelper.getExtAppAndOrgnlAppRel(new HashSet<String>(1)) : (Map<String, String>)paramMap.get("extAppOrgnlAppMap");
            if (null == paramMap.get("entOriAppIdMap")) {
                extAppAndOrgnlAppRelParamMap = new HashMap(8);
                extAppAndOrgnlAppRelParamMap.put("entityNumList", entityNums);
                extAppAndOrgnlAppRelParamMap.put("extAppOrgnlAppMap", extAppOrgnlAppMap);
                Map perm_formEntityNumMap = null == paramMap.get("perm_formEntityNumMap") ? new HashMap(0) : (Map)paramMap.get("perm_formEntityNumMap");
                extAppAndOrgnlAppRelParamMap.put("perm_formEntityNumMap", perm_formEntityNumMap);
                entOriAppIdMap = FormHelper.getAppIdByFormNum(extAppAndOrgnlAppRelParamMap);
            } else {
                entOriAppIdMap = (Map<String, String>)paramMap.get("entOriAppIdMap");
            }
        }
        HashMap<String, String> result = new HashMap<String, String>();
        if (StringUtils.isEmpty((String)curAppId) || "bos".equals(curAppId)) {
            HashMap<String, String> tempResult = new HashMap<String, String>(entityNums.size());
            if (null != entityNums && !entityNums.isEmpty()) {
                for (String entityNum : entityNums) {
                    String appId = entOriAppIdMap.get(entityNum);
                    tempResult.put(entityNum, appId);
                }
            }
            return tempResult;
        }
        AppInfo appInfo = AppHelper.getMetaAppInfo(curAppId);
        if (appInfo == null) {
            return result;
        }
        String appId = appInfo.getId();
        ArrayList<String> noPublishEntityNums = new ArrayList<String>(10);
        Map<String, String> entPublishAppMap = PermCommonUtil.getMapInfoFromPublishApp(curAppId, entityNums);
        if (!appInfo.isAllUserApp()) {
            for (String tempEntityNum : entityNums) {
                if (entPublishAppMap.containsKey(tempEntityNum)) {
                    result.put(tempEntityNum, appId);
                    continue;
                }
                noPublishEntityNums.add(tempEntityNum);
            }
        } else {
            Map<String, List<String>> checkPermAllUserAppEntMap = PermCommonUtil.getCheckPermAllUserAppEntMap();
            List<String> checkPermEntList = checkPermAllUserAppEntMap.get(appId);
            for (String tempEntityNum : entityNums) {
                if (checkPermEntList != null && checkPermEntList.contains(tempEntityNum)) {
                    if (entPublishAppMap.containsKey(tempEntityNum)) {
                        result.put(tempEntityNum, appId);
                        continue;
                    }
                    noPublishEntityNums.add(tempEntityNum);
                    continue;
                }
                result.put(tempEntityNum, appId);
            }
        }
        if (!noPublishEntityNums.isEmpty()) {
            String tempAppId = null;
            for (String entityNum : noPublishEntityNums) {
                tempAppId = entOriAppIdMap.get(entityNum);
                if (StringUtils.isEmpty((String)tempAppId)) {
                    tempAppId = PermCommonUtil.getAppIdFromGrayInfo(entityNum);
                }
                result.put(entityNum, tempAppId);
            }
        }
        return result;
    }

    @SdkInternal
    private static String getAppIdFromGrayInfo(String pEntityNum) {
        String accountId;
        boolean isGrayUpgrade = PermGrayHelper.isGrayUpgrade();
        if (!isGrayUpgrade) {
            return null;
        }
        String curUserId = String.valueOf(RequestContext.get().getCurrUserId());
        Map appNumAndGroupMap = GrayStrategy.getUserAppGroup((String)curUserId, (String)(accountId = RequestContext.get().getAccountId()));
        if (CollectionUtils.isEmpty((Map)appNumAndGroupMap)) {
            return null;
        }
        HashSet<Object> appGroups = new HashSet<Object>(8);
        for (Object appGroup : appNumAndGroupMap.values()) {
            appGroups.add(appGroup);
        }
        String grayAppNum = null;
        for (String string : appGroups) {
            List<FormConfig> formConfigs = PermGrayHelper.loadGrayFormConfigList(string);
            if (CollectionUtils.isEmpty(formConfigs)) continue;
            for (FormConfig fc : formConfigs) {
                String entityNum = fc.getEntityTypeId();
                String tempAppNum = fc.getBizAppNumber();
                if (!pEntityNum.equals(entityNum) || !StringUtils.isNotEmpty((String)tempAppNum)) continue;
                grayAppNum = tempAppNum;
                break;
            }
            if (!StringUtils.isNotEmpty(grayAppNum)) continue;
            break;
        }
        if (StringUtils.isEmpty(grayAppNum)) {
            return null;
        }
        List<AppInfo> loadGrayAppInfoList = PermGrayHelper.loadGrayAppInfoList();
        AppInfo appInfo = PermGrayHelper.findGrayAppInfoByNum(grayAppNum, loadGrayAppInfoList);
        if (appInfo == null) {
            return null;
        }
        return appInfo.getId();
    }

    @Deprecated
    @SdkInternal
    public static Map<String, String> getCheckPermEntityAppMap(String curAppId, List<String> entityNums) {
        Map<String, String> extAppOrgnlAppMap = AppHelper.getExtAppAndOrgnlAppRel(new HashSet<String>(1));
        HashMap<String, Object> extAppAndOrgnlAppRelParamMap = new HashMap<String, Object>(8);
        extAppAndOrgnlAppRelParamMap.put("entityNumList", entityNums);
        extAppAndOrgnlAppRelParamMap.put("extAppOrgnlAppMap", extAppOrgnlAppMap);
        Map<String, String> entOriAppIdMap = FormHelper.getAppIdByFormNum(extAppAndOrgnlAppRelParamMap);
        return PermCommonUtil.getCheckPermEntityAppMap(curAppId, entityNums, entOriAppIdMap);
    }

    @Deprecated
    @SdkInternal
    public static Map<String, String> getCheckPermEntityAppMap(String curAppId, List<String> entityNums, Map<String, String> entOriAppIdMap) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(8);
        paramMap.put("entOriAppIdMap", entOriAppIdMap);
        Map<String, String> extAppOrgnlAppMap = AppHelper.getExtAppAndOrgnlAppRel(new HashSet<String>(1));
        paramMap.put("extAppOrgnlAppMap", extAppOrgnlAppMap);
        return PermCommonUtil.getCheckPermEntityAppMapNew(curAppId, entityNums, paramMap);
    }

    @SdkInternal
    public static Map<String, String> getCheckPermEntityAppMapNew(String curAppId, List<String> entityNums, Map<String, Object> paramMap) {
        HashMap<String, Object> extAppAndOrgnlAppRelParamMap;
        Map<String, String> entOriAppIdMap = null;
        Map<String, String> extAppOrgnlAppMap = null;
        if (null == paramMap) {
            extAppOrgnlAppMap = AppHelper.getExtAppAndOrgnlAppRel(new HashSet<String>(1));
            extAppAndOrgnlAppRelParamMap = new HashMap<String, Object>(8);
            extAppAndOrgnlAppRelParamMap.put("entityNumList", entityNums);
            extAppAndOrgnlAppRelParamMap.put("extAppOrgnlAppMap", extAppOrgnlAppMap);
            extAppAndOrgnlAppRelParamMap.put("perm_formEntityNumMap", new HashMap(0));
            entOriAppIdMap = FormHelper.getAppIdByFormNum(extAppAndOrgnlAppRelParamMap);
        } else {
            extAppOrgnlAppMap = null == paramMap.get("extAppOrgnlAppMap") ? AppHelper.getExtAppAndOrgnlAppRel(new HashSet<String>(1)) : (Map<String, String>)paramMap.get("extAppOrgnlAppMap");
            if (null == paramMap.get("entOriAppIdMap")) {
                extAppAndOrgnlAppRelParamMap = new HashMap(8);
                extAppAndOrgnlAppRelParamMap.put("entityNumList", entityNums);
                extAppAndOrgnlAppRelParamMap.put("extAppOrgnlAppMap", extAppOrgnlAppMap);
                Map perm_formEntityNumMap = null == paramMap.get("perm_formEntityNumMap") ? new HashMap(0) : (Map)paramMap.get("perm_formEntityNumMap");
                extAppAndOrgnlAppRelParamMap.put("perm_formEntityNumMap", perm_formEntityNumMap);
                entOriAppIdMap = FormHelper.getAppIdByFormNum(extAppAndOrgnlAppRelParamMap);
            } else {
                entOriAppIdMap = (Map<String, String>)paramMap.get("entOriAppIdMap");
            }
        }
        if (StringUtils.isEmpty((String)curAppId) || "bos".equals(curAppId)) {
            HashMap<String, String> result = new HashMap<String, String>(entityNums.size());
            if (null != entityNums && !entityNums.isEmpty()) {
                for (String entityNum : entityNums) {
                    String appId = entOriAppIdMap.get(entityNum);
                    result.put(entityNum, appId);
                }
            }
            return result;
        }
        ArrayList<String> noPublishEntityNums = new ArrayList<String>(10);
        Map<String, String> result = PermCommonUtil.getMapInfoFromPublishApp(curAppId, entityNums);
        AppInfo appInfo = AppHelper.getMetaAppInfo(curAppId);
        if (appInfo != null && !appInfo.isAllUserApp()) {
            for (String tempEntityNum : entityNums) {
                if (result.containsKey(tempEntityNum)) continue;
                noPublishEntityNums.add(tempEntityNum);
            }
        } else {
            List appMenus = AppMetadataCache.getAppMenusInfoByAppId((String)curAppId);
            ArrayList<String> formNumsFromMenu = new ArrayList<String>(8);
            for (AppMenuInfo appMenu : appMenus) {
                String formNumFromMenu = appMenu.getFormId();
                if (StringUtils.isEmpty((String)formNumFromMenu)) continue;
                formNumsFromMenu.add(formNumFromMenu);
            }
            Map<String, String> formNumAndEntNumMap = PermCommonUtil.getEntityNumsByFormNums(formNumsFromMenu);
            for (String tempEntityNum : entityNums) {
                if (result.containsKey(tempEntityNum)) continue;
                boolean ifFound = false;
                for (AppMenuInfo appMenu : appMenus) {
                    String entityNumFromFormId;
                    String formNumFromMenu = appMenu.getFormId();
                    if (StringUtils.isEmpty((String)formNumFromMenu) || StringUtils.isEmpty((String)(entityNumFromFormId = formNumAndEntNumMap.get(formNumFromMenu))) || !tempEntityNum.equals(entityNumFromFormId)) continue;
                    ifFound = true;
                    break;
                }
                if (ifFound) {
                    result.put(tempEntityNum, curAppId);
                    continue;
                }
                noPublishEntityNums.add(tempEntityNum);
            }
        }
        if (!noPublishEntityNums.isEmpty()) {
            for (String entityNum : noPublishEntityNums) {
                String appId = entOriAppIdMap.get(entityNum);
                result.put(entityNum, appId);
            }
        }
        return result;
    }

    @SdkInternal
    public static Map<String, String> getCheckPermEntityAppMap2(String curAppId, List<String> entityNums) {
        return PermCommonUtil.getCheckPermEntityAppMap2(curAppId, entityNums, null);
    }

    @Deprecated
    @SdkInternal
    public static Map<String, String> getCheckPermEntityAppMap2(String curAppId, List<String> entityNums, Map<String, String> entOriAppIdMap) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(8);
        paramMap.put("entOriAppIdMap", entOriAppIdMap);
        Map<String, String> extAppOrgnlAppMap = AppHelper.getExtAppAndOrgnlAppRel(new HashSet<String>(1));
        paramMap.put("extAppOrgnlAppMap", extAppOrgnlAppMap);
        return PermCommonUtil.getCheckPermEntityAppMap2New(curAppId, entityNums, paramMap);
    }

    @SdkInternal
    public static Map<String, String> getCheckPermEntityAppMap2New(String curAppId, List<String> entityNums, Map<String, Object> paramMap) {
        HashMap<String, Object> extAppAndOrgnlAppRelParamMap;
        Map<String, String> entOriAppIdMap = null;
        Map<String, String> extAppOrgnlAppMap = null;
        if (null == paramMap) {
            extAppOrgnlAppMap = AppHelper.getExtAppAndOrgnlAppRel(new HashSet<String>(1));
            extAppAndOrgnlAppRelParamMap = new HashMap<String, Object>(8);
            extAppAndOrgnlAppRelParamMap.put("entityNumList", entityNums);
            extAppAndOrgnlAppRelParamMap.put("extAppOrgnlAppMap", extAppOrgnlAppMap);
            entOriAppIdMap = FormHelper.getAppIdByFormNum(extAppAndOrgnlAppRelParamMap);
        } else {
            extAppOrgnlAppMap = null == paramMap.get("extAppOrgnlAppMap") ? AppHelper.getExtAppAndOrgnlAppRel(new HashSet<String>(1)) : (Map<String, String>)paramMap.get("extAppOrgnlAppMap");
            if (null == paramMap.get("entOriAppIdMap")) {
                extAppAndOrgnlAppRelParamMap = new HashMap(8);
                extAppAndOrgnlAppRelParamMap.put("entityNumList", entityNums);
                extAppAndOrgnlAppRelParamMap.put("extAppOrgnlAppMap", extAppOrgnlAppMap);
                entOriAppIdMap = FormHelper.getAppIdByFormNum(extAppAndOrgnlAppRelParamMap);
            } else {
                entOriAppIdMap = (Map<String, String>)paramMap.get("entOriAppIdMap");
            }
        }
        if (StringUtils.isEmpty((String)curAppId) || "bos".equals(curAppId)) {
            HashMap<String, String> result = new HashMap<String, String>(entityNums.size());
            if (null != entityNums && !entityNums.isEmpty()) {
                for (String entityNum : entityNums) {
                    String appId = entOriAppIdMap.get(entityNum);
                    result.put(entityNum, appId);
                }
            }
            return result;
        }
        ArrayList<String> noPublishEntityNums = new ArrayList<String>();
        Map<String, String> result = PermCommonUtil.getMapInfoFromPublishApp(curAppId, entityNums);
        AppInfo appInfo = AppHelper.getMetaAppInfo(curAppId);
        if (appInfo != null) {
            for (String tempEntityNum : entityNums) {
                if (result.containsKey(tempEntityNum)) continue;
                noPublishEntityNums.add(tempEntityNum);
            }
        }
        if (!noPublishEntityNums.isEmpty()) {
            for (String entityNum : noPublishEntityNums) {
                String appId = entOriAppIdMap.get(entityNum);
                result.put(entityNum, appId);
            }
        }
        return result;
    }

    @Deprecated
    @SdkInternal
    public static Map<String, String> getExtAppAndOrgnlAppRel() {
        return AppHelper.getExtAppAndOrgnlAppRel(new HashSet<String>(1));
    }

    @Deprecated
    @SdkInternal
    public static Map<String, String> getExtAppAndOrgnlAppRel(String appId) {
        return AppHelper.getExtAppAndOrgnlAppRel(appId);
    }

    @SdkInternal
    public static List<String> getExtAppByAppId(List<String> appIds) {
        ArrayList<String> result = new ArrayList<String>(10);
        QFilter[] qFilters = null;
        if (!CollectionUtils.isEmpty(appIds)) {
            qFilters = new QFilter[]{new QFilter("id", "in", appIds).or("masterid", "in", appIds)};
        }
        Map appInfoMap = BusinessDataServiceHelper.loadFromCache((String)"bos_devportal_bizapp", (String)"id, masterid", qFilters);
        for (DynamicObject dObj : appInfoMap.values()) {
            String id = dObj.getString("id");
            result.add(id);
        }
        return result;
    }

    @SdkInternal
    public static Map<String, String> getMapInfoFromPublishApp(String appId, List<String> entityNums) {
        HashMap<String, String> result = new HashMap<String, String>(16);
        for (String entityNum : entityNums) {
            List publishApps;
            PermissionControlType pct = FormHelper.getPermissionControlType(entityNum);
            if (pct == null || (publishApps = pct.getPublishApps()) == null || publishApps.size() == 0 || !publishApps.contains(appId)) continue;
            result.put(entityNum, appId);
        }
        return result;
    }

    @SdkInternal
    public static Map<String, Map<String, Set<String>>> getUserPermWithNoOrg(Long userId) {
        return PermCommonUtil.getUserPermWithNoOrg(userId, null);
    }

    @SdkInternal
    public static Map<String, Map<String, Set<String>>> getUserPermWithNoOrg(Long userId, String pAppId) {
        return PermCommonUtil.getUserPermWithNoOrg(userId, pAppId, null);
    }

    @SdkInternal
    public static UserPermResult getUserPermInfo(Long userId) {
        return PermCommonUtil.getUserPermInfo(userId, null);
    }

    @SdkInternal
    public static UserPermResult getUserPermInfo(Long userId, String pAppId) {
        return PermCommonUtil.getUserPermInfo(userId, pAppId, null);
    }

    @SdkInternal
    public static UserPermResult getUserPermInfo(Long userId, String pAppId, Map<String, String> formNumEntityNumMap) {
        UserPermResult upr = new UserPermResult();
        Map<String, Map<String, Set<String>>> userPermInfoMap = PermCommonUtil.getUserPermWithNoOrg(userId, pAppId, formNumEntityNumMap);
        upr.setUserPermInfoMap(userPermInfoMap);
        StringBuilder sbQueryCommonRoleClosestTimeSql = new StringBuilder().append(" select ur.fstarttime, ur.fendtime ").append(" from t_perm_userrole ur ").append(" inner join t_perm_role r on (ur.froleid = r.fid and r.fenable = '1') ").append(" where ur.fuserid = ? ");
        Date closestTime = PermCommonUtil.getDefaultEndTime();
        Date now = new Date();
        try (DataSet queryComRoleClosestTimeDS = DB.queryDataSet((String)"queryComRoleClosestTimeDS", (DBRoute)DBRoute.permission, (String)sbQueryCommonRoleClosestTimeSql.toString(), (Object[])new Object[]{userId});){
            while (queryComRoleClosestTimeDS.hasNext()) {
                Row row = queryComRoleClosestTimeDS.next();
                Date startTime = row.getDate("fstarttime");
                Date endTime = row.getDate("fendtime");
                if (endTime != null && endTime.before(closestTime) && endTime.after(now)) {
                    closestTime = endTime;
                }
                if (startTime == null || !startTime.before(closestTime) || !startTime.after(now)) continue;
                closestTime = startTime;
            }
        }
        StringBuilder sbQueryBizRoleClosestTimeSql = new StringBuilder().append(" select ubr.fstarttime, ubr.fendtime ").append(" from t_perm_userbizrole ubr ").append(" inner join t_perm_bizrole br on (ubr.fbizroleid = br.fid and br.fenable = '1') ").append(" where ubr.fuserid = ? ");
        try (DataSet queryBizRoleClosestTimeDS = DB.queryDataSet((String)"queryBizRoleClosestTimeDS", (DBRoute)DBRoute.permission, (String)sbQueryBizRoleClosestTimeSql.toString(), (Object[])new Object[]{userId});){
            while (queryBizRoleClosestTimeDS.hasNext()) {
                Row row = queryBizRoleClosestTimeDS.next();
                Date startTime = row.getDate("fstarttime");
                Date endTime = row.getDate("fendtime");
                if (endTime != null && endTime.before(closestTime) && endTime.after(now)) {
                    closestTime = endTime;
                }
                if (startTime == null || !startTime.before(closestTime) || !startTime.after(now)) continue;
                closestTime = startTime;
            }
        }
        if (closestTime.getYear() != 1099) {
            int remainExpireTime = PermCommonUtil.calcRemainExpireTime(new Date(), closestTime);
            upr.setRemainExpireTime(remainExpireTime);
        }
        return upr;
    }

    @SdkInternal
    private static Map<String, Object> getEntityNumDsAndSqlInEntNumMap(Map<String, String> formNumEntityNumMap) {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("sqlIn_EntNum", null);
        map.put("entityNumDs", null);
        String sqlIn_EntNum = null;
        Algo algo = Algo.create((String)(PermCommonUtil.class.getName() + ".getUserPermWithNoOrg_entityNumHs"));
        RowMeta rowMeta = new RowMeta(new String[]{"ht_entNum"}, new DataType[]{DataType.StringType});
        DataSetBuilder builder = algo.createDataSetBuilder(rowMeta);
        if (formNumEntityNumMap != null && !formNumEntityNumMap.isEmpty()) {
            StringBuilder sb = new StringBuilder("(");
            for (String entityNum : formNumEntityNumMap.values()) {
                sb.append(" '").append(entityNum).append("',");
                builder.append(new Object[]{entityNum});
            }
            sb.setCharAt(sb.lastIndexOf(","), ')');
            sqlIn_EntNum = sb.toString();
            map.put("sqlIn_EntNum", sb.toString());
        }
        if (StringUtils.isNotEmpty(sqlIn_EntNum)) {
            map.put("entityNumDs", builder.build());
        }
        return map;
    }

    @SdkInternal
    private static Map<String, Object> getAppEntRelDS2_3Map(String sqlIn_EntNum, String pAppId, Map<String, Map<String, Set<String>>> appEntityPermMap, Long userId, DataSet entityNumDs) {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("appEntRelDS2", null);
        map.put("appEntRelDS3", null);
        try (DataSet userPermDS = PermCommonUtil.getUserDirectPermDS(sqlIn_EntNum, pAppId, userId, entityNumDs, map);){
            while (userPermDS.hasNext()) {
                Row row = userPermDS.next();
                String appId = row.getString("upd_appid");
                String entityNum = row.getString(PROP_UPD_ENTNUM);
                String permItemId = row.getString("upd_permitemid");
                if (StringUtils.isEmpty((String)appId) || StringUtils.isEmpty((String)entityNum) || StringUtils.isEmpty((String)permItemId)) continue;
                appEntityPermMap.computeIfAbsent(appId, k -> new HashMap(16)).computeIfAbsent(entityNum, k -> new HashSet()).add(permItemId);
            }
        }
        return map;
    }

    @SdkInternal
    private static DataSet getUserDirectPermDS(String sqlIn_EntNum, String pAppId, Long userId, DataSet entityNumDs, Map<String, Object> map) {
        DataSet userPermDS = PermCommonUtil.getUserPermDS(sqlIn_EntNum, userId, entityNumDs);
        if (StringUtils.isNotEmpty((String)pAppId)) {
            DataSet appEntRelDS1 = PermCommonUtil.queryAppEntNums(pAppId);
            map.put("appEntRelDS2", appEntRelDS1.copy());
            map.put("appEntRelDS3", appEntRelDS1.copy());
            return userPermDS.join(appEntRelDS1, JoinType.LEFT).on(PROP_UPD_ENTNUM, PROP_ENT_NUM).select(new String[]{"upd_appid", PROP_UPD_ENTNUM, "upd_permitemid"}, new String[]{PROP_ENT_ID, PROP_ENT_NUM}).finish();
        }
        return userPermDS;
    }

    @SdkInternal
    private static DataSet getUserPermDS(String sqlIn_EntNum, Long userId, DataSet entityNumDs) {
        StringBuilder sbUserPermSql = new StringBuilder();
        sbUserPermSql.append(" SELECT DISTINCT fbizappid upd_appid, fentitytypeid upd_entnum, fpermitemid upd_permitemid");
        sbUserPermSql.append(" FROM t_perm_userpermdetail WHERE fuserid = ? and fbizappid > ' ' and fentitytypeid > ' ' and fpermitemid > ' ' and fdimid > 0 ");
        DataSet userPermDS = DB.queryDataSet((String)"PermCommonUtil.getAppEntRelDS2_3Map", (DBRoute)DBRoute.permission, (String)sbUserPermSql.toString(), (Object[])new Object[]{userId});
        if (StringUtils.isNotEmpty((String)sqlIn_EntNum)) {
            userPermDS = userPermDS.hashJoin(entityNumDs.toHashTable("ht_entNum"), PROP_UPD_ENTNUM, new String[0]).selectLeftFields(new String[]{"upd_appid", PROP_UPD_ENTNUM, "upd_permitemid"}).finish();
        }
        return userPermDS;
    }

    @SdkInternal
    public static Map<String, Map<String, Set<String>>> getUserPermWithNoOrg(Long userId, String pAppId, Map<String, String> formNumEntityNumMap) {
        Map<String, Object> appEntRelDS2_3Map;
        HashMap<String, Map<String, Set<String>>> appEntityPermMap = new HashMap<String, Map<String, Set<String>>>(16);
        Map<String, Object> entityNumDsAndSqlInEntNumMap = PermCommonUtil.getEntityNumDsAndSqlInEntNumMap(formNumEntityNumMap);
        String sqlIn_EntNum = (String)entityNumDsAndSqlInEntNumMap.get("sqlIn_EntNum");
        if (PermCommonUtil.isEnableSingleBizRole()) {
            return PermCommonUtil.getUserPermWithNoOrgBySingleBizRole(userId, pAppId, sqlIn_EntNum);
        }
        try (DataSet entityNumDs = (DataSet)entityNumDsAndSqlInEntNumMap.get("entityNumDs");){
            appEntRelDS2_3Map = PermCommonUtil.getAppEntRelDS2_3Map(sqlIn_EntNum, pAppId, appEntityPermMap, userId, entityNumDs);
        }
        var8_7 = null;
        try (DataSet appEntRelDS2 = null == appEntRelDS2_3Map.get("appEntRelDS2") ? null : (DataSet)appEntRelDS2_3Map.get("appEntRelDS2");
             DataSet appEntRelDS3 = null == appEntRelDS2_3Map.get("appEntRelDS3") ? null : (DataSet)appEntRelDS2_3Map.get("appEntRelDS3");){
            PermCommonUtil.fullAppEntityPermMapByRoleAuth(userId, pAppId, appEntityPermMap, sqlIn_EntNum, appEntRelDS2);
            PermCommonUtil.fullAppEntityPermMapByDisFuncPerm(userId, pAppId, appEntityPermMap, sqlIn_EntNum, appEntRelDS3);
        }
        catch (Throwable throwable) {
            var8_7 = throwable;
            throw throwable;
        }
        return appEntityPermMap;
    }

    @SdkInternal
    private static void fullAppEntityPermMapByDisFuncPerm(Long userId, String pAppId, Map<String, Map<String, Set<String>>> appEntityPermMap, String sqlIn_EntNum, DataSet appEntRelDS3) {
        StringBuilder sbDisfuncPermSql = new StringBuilder().append("SELECT distinct dfp.fbizappid dfp_appid, dfp.fentitytypeid dfp_entnum, dfp.fpermitemid dfp_permitemid").append(" FROM t_perm_disfunperm dfp ").append(" WHERE dfp.fuserid = ? ");
        if (StringUtils.isNotEmpty((String)sqlIn_EntNum)) {
            sbDisfuncPermSql.append(" and dfp.fentitytypeid in ").append(sqlIn_EntNum);
        }
        try (DataSet disfuncPermDS = PermCommonUtil.getDisfuncPermDS(userId, pAppId, appEntRelDS3, sbDisfuncPermSql);){
            while (disfuncPermDS.hasNext()) {
                Row row = disfuncPermDS.next();
                String appId = row.getString(PROP_DFP_APPID);
                String entityNum = row.getString(PROP_DFP_ENTNUM);
                String permItemId = row.getString(PROP_DFP_PERMITEMID);
                Map<String, Set<String>> formPermMap = appEntityPermMap.get(appId);
                if (formPermMap == null) continue;
                Set<String> valueSet = formPermMap.get(entityNum);
                if (valueSet != null) {
                    valueSet.remove(permItemId);
                    if (valueSet.size() == 0) {
                        formPermMap.remove(entityNum);
                    }
                }
                if (formPermMap.size() != 0) continue;
                appEntityPermMap.remove(appId);
            }
        }
    }

    @SdkInternal
    private static DataSet getDisfuncPermDS(Long userId, String pAppId, DataSet appEntRelDS3, StringBuilder sbDisfuncPermSql) {
        DataSet disfuncPermDS = DB.queryDataSet((String)"PermCommonUtil.fullAppEntityPermMapByDisFuncPerm_getDisfuncPermDS", (DBRoute)DBRoute.permission, (String)sbDisfuncPermSql.toString(), (Object[])new Object[]{userId});
        if (StringUtils.isNotEmpty((String)pAppId) && null != appEntRelDS3) {
            disfuncPermDS = disfuncPermDS.join(appEntRelDS3, JoinType.LEFT).on(PROP_DFP_ENTNUM, PROP_ENT_NUM).select(new String[]{PROP_DFP_APPID, PROP_DFP_ENTNUM, PROP_DFP_PERMITEMID}, new String[]{PROP_ENT_ID, PROP_ENT_NUM}).finish();
        }
        return disfuncPermDS;
    }

    @SdkInternal
    private static void fullAppEntityPermMapByRoleAuth(Long userId, String pAppId, Map<String, Map<String, Set<String>>> appEntityPermMap, String sqlIn_EntNum, DataSet appEntRelDS2) {
        String sqlPart = "";
        boolean enableValidateTime = PermCommonUtil.isEnableValidateTime();
        if (enableValidateTime) {
            sqlPart = " and (now() between ur.fstarttime and ur.fendtime or (ur.fstarttime is null and  ur.fendtime is null) or  (now() >= ur.fstarttime and ur.fendtime is null) or (ur.fstarttime is null and now() <=  ur.fendtime ))";
        }
        StringBuilder sbUserRoleSql = new StringBuilder().append("SELECT distinct rpd.fbizappid rpd_appid, rpd.fentitytypeid rpd_entnum, rpd.fpermitemid rpd_permitemid").append(" FROM t_perm_rolepermdetial rpd ").append(" INNER JOIN (").append("   SELECT DISTINCT ur.froleid FROM T_PERM_USERROLE ur ").append("     INNER JOIN T_PERM_ROLE r ON r.fid = ur.FROLEID ").append("   WHERE ur.fuserid = ? AND r.fenable = '1' ").append(sqlPart).append(" ) urr on (urr.froleid = rpd.froleid) ").append(" INNER JOIN t_perm_role r ON r.fid = urr.froleid ").append(" WHERE r.fenable = '1' ");
        if (StringUtils.isNotEmpty((String)sqlIn_EntNum)) {
            sbUserRoleSql.append(" and rpd.fentitytypeid in ").append(sqlIn_EntNum);
        }
        try (DataSet userRolePermDS = PermCommonUtil.getUserRolePermDS(userId, pAppId, appEntRelDS2, sbUserRoleSql);){
            while (userRolePermDS.hasNext()) {
                while (userRolePermDS.hasNext()) {
                    Row row = userRolePermDS.next();
                    String appId = row.getString("rpd_appid");
                    String entityNum = row.getString(PROP_RPD_ENTNUM);
                    String permItemId = row.getString("rpd_permitemid");
                    if (StringUtils.isEmpty((String)appId) || StringUtils.isEmpty((String)entityNum) || StringUtils.isEmpty((String)permItemId)) continue;
                    appEntityPermMap.computeIfAbsent(appId, k -> new HashMap(16)).computeIfAbsent(entityNum, k -> new HashSet()).add(permItemId);
                }
            }
        }
    }

    @SdkInternal
    private static DataSet getUserRolePermDS(Long userId, String pAppId, DataSet appEntRelDS2, StringBuilder sbUserRoleSql) {
        DataSet userRolePermDS = DB.queryDataSet((String)"PermCommonUtil.fullAppEntityPermMap", (DBRoute)DBRoute.permission, (String)sbUserRoleSql.toString(), (Object[])new Object[]{userId});
        if (StringUtils.isNotEmpty((String)pAppId) && null != appEntRelDS2) {
            userRolePermDS = userRolePermDS.join(appEntRelDS2, JoinType.LEFT).on(PROP_RPD_ENTNUM, PROP_ENT_NUM).select(new String[]{"rpd_appid", PROP_RPD_ENTNUM, "rpd_permitemid"}, new String[]{PROP_ENT_ID, PROP_ENT_NUM}).finish();
        }
        return userRolePermDS;
    }

    @SdkInternal
    private static Map<String, Object> getAppEntRelDS2_3MapSingleBizRole(String pAppId, String bizRoleId, String sqlIn_EntNum, Map<String, Map<String, Set<String>>> appEntityPermMap) {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("appEntRelDS2", null);
        map.put("appEntRelDS3", null);
        try (DataSet bizRolePermDS = PermCommonUtil.getBizRolePermDS(pAppId, bizRoleId, sqlIn_EntNum, map);){
            while (bizRolePermDS.hasNext()) {
                Row row = bizRolePermDS.next();
                String appId = row.getString("brp_appid");
                String entNum = row.getString(PROP_BRP_ENTNUM);
                String permItemId = row.getString("brp_permitemid");
                appEntityPermMap.computeIfAbsent(appId, k -> new HashMap(16)).computeIfAbsent(entNum, k -> new HashSet()).add(permItemId);
            }
        }
        return map;
    }

    @SdkInternal
    private static DataSet getBizRolePermDS(String pAppId, String bizRoleId, String sqlIn_EntNum, Map<String, Object> map) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT a.fbizappid brp_appid, a.fentitytypeid brp_entnum, a.fpermitemid brp_permitemid FROM t_perm_bizroleperm a ");
        sql.append(" WHERE a.fid = ? ");
        if (StringUtils.isNotEmpty((String)sqlIn_EntNum)) {
            sql.append(" AND a.fentitytypeid in ").append(sqlIn_EntNum);
        }
        try (DataSet bizRolePermDS = DB.queryDataSet((String)"PermCommonUtil.getAppEntRelDS2_3MapSingleBizRole", (DBRoute)DBRoute.permission, (String)sql.toString(), (Object[])new Object[]{Long.valueOf(bizRoleId)});){
            if (StringUtils.isNotEmpty((String)pAppId)) {
                try (DataSet appEntRelDS1 = PermCommonUtil.queryAppEntNums(pAppId);){
                    map.put("appEntRelDS2", appEntRelDS1.copy());
                    map.put("appEntRelDS3", appEntRelDS1.copy());
                    DataSet dataSet = bizRolePermDS.join(appEntRelDS1, JoinType.LEFT).on(PROP_BRP_ENTNUM, PROP_ENT_NUM).select(new String[]{"brp_appid", PROP_BRP_ENTNUM, "brp_permitemid"}, new String[]{PROP_ENT_ID, PROP_ENT_NUM}).finish();
                    return dataSet;
                }
            }
            DataSet dataSet = bizRolePermDS;
            return dataSet;
        }
    }

    @SdkInternal
    public static Map<String, Map<String, Set<String>>> getUserPermWithNoOrgBySingleBizRole(Long userId, String pAppId, String sqlIn_EntNum) {
        HashMap<String, Map<String, Set<String>>> appEntityPermMap = new HashMap<String, Map<String, Set<String>>>(16);
        String bizRoleId = UserBizRoleCache.getSelBizRole(userId);
        if (StringUtils.isEmpty((String)bizRoleId)) {
            return appEntityPermMap;
        }
        Map<String, Object> appEntRelDS2_3Map = PermCommonUtil.getAppEntRelDS2_3MapSingleBizRole(pAppId, bizRoleId, sqlIn_EntNum, appEntityPermMap);
        try (DataSet appEntRelDS2 = null == appEntRelDS2_3Map.get("appEntRelDS2") ? null : (DataSet)appEntRelDS2_3Map.get("appEntRelDS2");
             DataSet appEntRelDS3 = null == appEntRelDS2_3Map.get("appEntRelDS3") ? null : (DataSet)appEntRelDS2_3Map.get("appEntRelDS3");){
            PermCommonUtil.fullAppEntityPermMapByRoleInSingleBizRole(pAppId, sqlIn_EntNum, appEntityPermMap, bizRoleId, appEntRelDS2);
            PermCommonUtil.fullAppEntityPermMapByDisFuncPermInSingleBizRole(pAppId, sqlIn_EntNum, appEntityPermMap, bizRoleId, appEntRelDS3);
        }
        return appEntityPermMap;
    }

    private static void fullAppEntityPermMapByDisFuncPermInSingleBizRole(String pAppId, String sqlIn_EntNum, Map<String, Map<String, Set<String>>> appEntityPermMap, String bizRoleId, DataSet appEntRelDS3) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT a.fbizappid dfp_appid, a.fentitytypeid dfp_entnum, a.fpermitemid dfp_permitemid ").append(" FROM t_perm_bizroledisperm a ").append(" WHERE a.fid = ? ");
        if (StringUtils.isNotEmpty((String)sqlIn_EntNum)) {
            sql.append(" AND a.fentitytypeid in ").append(sqlIn_EntNum);
        }
        try (DataSet disfuncPermDS = PermCommonUtil.getDisfuncPermDSInSingleBizRole(pAppId, bizRoleId, appEntRelDS3, sql);){
            while (disfuncPermDS.hasNext()) {
                Row row = disfuncPermDS.next();
                String appId = row.getString(PROP_DFP_APPID);
                String entNum = row.getString(PROP_DFP_ENTNUM);
                String permItemId = row.getString(PROP_DFP_PERMITEMID);
                Map<String, Set<String>> formPermMap = appEntityPermMap.get(appId);
                if (formPermMap == null) continue;
                Set<String> valueSet = formPermMap.get(entNum);
                if (valueSet != null) {
                    valueSet.remove(permItemId);
                    if (valueSet.size() == 0) {
                        formPermMap.remove(entNum);
                    }
                }
                if (formPermMap.size() != 0) continue;
                appEntityPermMap.remove(appId);
            }
        }
    }

    private static DataSet getDisfuncPermDSInSingleBizRole(String pAppId, String bizRoleId, DataSet appEntRelDS3, StringBuilder sql) {
        DataSet disfuncPermDS = DB.queryDataSet((String)"PermCommonUtil.fullAppEntityPermMapByDisFuncPermInSingleBizRole", (DBRoute)DBRoute.permission, (String)sql.toString(), (Object[])new Object[]{Long.valueOf(bizRoleId)});
        if (StringUtils.isNotEmpty((String)pAppId)) {
            disfuncPermDS = disfuncPermDS.join(appEntRelDS3, JoinType.LEFT).on(PROP_DFP_ENTNUM, PROP_ENT_NUM).select(new String[]{PROP_DFP_APPID, PROP_DFP_ENTNUM, PROP_DFP_PERMITEMID}, new String[]{PROP_ENT_ID, PROP_ENT_NUM}).finish();
        }
        return disfuncPermDS;
    }

    private static void fullAppEntityPermMapByRoleInSingleBizRole(String pAppId, String sqlIn_EntNum, Map<String, Map<String, Set<String>>> appEntityPermMap, String bizRoleId, DataSet appEntRelDS2) {
        StringBuilder sql = new StringBuilder();
        sql.append("select distinct d.fbizappid brcr_appid, d.fentitytypeid brcr_entnum, d.fpermitemid brcr_permitemid ").append("from t_perm_bizrolecomrole a ").append("join t_perm_role b on a.froleid=b.fid ").append("join t_perm_rolepermdetial d on b.fid=d.froleid ").append("where a.fid = ? ").append("and b.fenable = '1' ");
        if (StringUtils.isNotEmpty((String)sqlIn_EntNum)) {
            sql.append(" AND d.fentitytypeid in ").append(sqlIn_EntNum);
        }
        try (DataSet bizRoleComRolePermDS = PermCommonUtil.getBizRoleComRolePermDSInSingleBizRole(pAppId, bizRoleId, appEntRelDS2, sql);){
            while (bizRoleComRolePermDS.hasNext()) {
                Row row = bizRoleComRolePermDS.next();
                String appId = row.getString("brcr_appid");
                String entNum = row.getString(PROP_BRCR_ENTNUM);
                String permItemId = row.getString("brcr_permitemid");
                appEntityPermMap.computeIfAbsent(appId, k -> new HashMap(16)).computeIfAbsent(entNum, k -> new HashSet()).add(permItemId);
            }
        }
    }

    private static DataSet getBizRoleComRolePermDSInSingleBizRole(String pAppId, String bizRoleId, DataSet appEntRelDS2, StringBuilder sql) {
        DataSet bizRoleComRolePermDS = DB.queryDataSet((String)"PermCommonUtil.getBizRoleComRolePermDSInSingleBizRole", (DBRoute)DBRoute.permission, (String)sql.toString(), (Object[])new Object[]{Long.valueOf(bizRoleId)});
        if (StringUtils.isNotEmpty((String)pAppId)) {
            bizRoleComRolePermDS = bizRoleComRolePermDS.join(appEntRelDS2, JoinType.LEFT).on(PROP_BRCR_ENTNUM, PROP_ENT_NUM).select(new String[]{"brcr_appid", PROP_BRCR_ENTNUM, "brcr_permitemid"}, new String[]{PROP_ENT_ID, PROP_ENT_NUM}).finish();
        }
        return bizRoleComRolePermDS;
    }

    private static DataSet queryAppEntNums(String pAppId) {
        StringBuilder sbAppEntRelSql = new StringBuilder().append("SELECT ent.fid ent_id, ent.fnumber ent_num from t_meta_entitydesign ent ").append(" INNER JOIN t_meta_bizunitrelform burf ON burf.fformid = ent.fid ").append(" WHERE burf.fbizappid = ? ");
        return DB.queryDataSet((String)(PermCommonUtil.class.getName() + ".queryAppEntNums"), (DBRoute)DBRoute.meta, (String)sbAppEntRelSql.toString(), (Object[])new Object[]{pAppId});
    }

    @SdkInternal
    public static String getDimTypeByEntityNum(String entityNum) {
        return PermCommonUtil.getDimTypeByEntityNum(entityNum, false);
    }

    @SdkInternal
    public static String getDimTypeByEntityNum(String entityNum, boolean multiDim) {
        PermissionControlType permControl = FormHelper.getPermissionControlType(entityNum);
        String dimType = permControl.getDimension();
        if (!multiDim && StringUtils.isEmpty((String)dimType)) {
            dimType = "bos_org";
        }
        return PermCommonUtil.getSuitableDimType(dimType, multiDim)[1];
    }

    @SdkInternal
    public static String getDimTypeNumByEntityNum(String entityNum) {
        PermissionControlType permControl = FormHelper.getPermissionControlType(entityNum);
        String dimType = permControl.getDimension();
        if (StringUtils.isEmpty((String)dimType)) {
            dimType = "DIM_ORG";
        }
        return dimType;
    }

    @SdkInternal
    public static boolean hasBindingFunctionPerm(String formNum) {
        if (StringUtils.isEmpty((String)formNum)) {
            return false;
        }
        String entityNum = FormMetadataCache.getFormConfig((String)formNum).getEntityTypeId();
        PermissionControlType permControl = FormHelper.getPermissionControlType(entityNum);
        if (!permControl.isControlFunction()) {
            return false;
        }
        Set permItemIDs = EntityMetadataCache.getPermissionItems((String)entityNum);
        return !CollectionUtils.isEmpty((Collection)permItemIDs);
    }

    @SdkInternal
    public static boolean hasBindingFunctionPerm(String formNum, String permItemID) {
        if (StringUtils.isEmpty((String)formNum) || StringUtils.isEmpty((String)permItemID)) {
            return false;
        }
        String entityNum = FormMetadataCache.getFormConfig((String)formNum).getEntityTypeId();
        PermissionControlType permControl = FormHelper.getPermissionControlType(entityNum);
        if (!permControl.isControlFunction()) {
            return false;
        }
        Set permItemIDs = EntityMetadataCache.getPermissionItems((String)entityNum);
        if (CollectionUtils.isEmpty((Collection)permItemIDs)) {
            return false;
        }
        return permItemIDs.contains(permItemID);
    }

    @SdkInternal
    public static boolean isInSysCloud(String appId) {
        if (StringUtils.isEmpty((String)appId)) {
            return false;
        }
        AppInfo appInfo = null;
        try {
            appInfo = AppHelper.getMetaAppInfo(appId);
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
            return false;
        }
        if (appInfo == null) {
            return false;
        }
        String cloudId = appInfo.getCloudId();
        return "83bfebc800000bac".equals(cloudId) || "0QLCSO6KKZC9".equals(cloudId);
    }

    public static boolean isAdminDomainApp(String appId) {
        if (StringUtils.isEmpty((String)appId)) {
            return false;
        }
        Set<String> adminDomainAppIds = PermCommonUtil.getAdminDomainAppIds(appId);
        return null != adminDomainAppIds && adminDomainAppIds.contains(appId);
    }

    @Deprecated
    public static Set<String> getAdminDomainAppIds() {
        return PermCommonUtil.getAdminDomainAppIds(null);
    }

    public static Set<String> getAdminDomainAppIds(String appId) {
        String key = String.format("%s%s%s", "getAdminDomainAppIds_", RequestContext.get().getAccountId(), appId);
        Map threadCacheMap = (Map)ThreadCache.get((Object)key, () -> {
            HashMap<String, Set<String>> map = new HashMap<String, Set<String>>(8);
            Set<String> result = PermCommonUtil.getAdminDomainAppIdNoCache(appId);
            if (null == result) {
                return map;
            }
            map.put("getAdminDomainAppIds_", result);
            return map;
        });
        return (Set)threadCacheMap.get("getAdminDomainAppIds_");
    }

    private static Set<String> getAdminDomainAppIdNoCache(String appId) {
        final HashSet<String> result = new HashSet<String>(8);
        ArrayList<String> params = new ArrayList<String>(1);
        StringBuilder sb = new StringBuilder();
        sb.append("select distinct fappid from t_perm_admindomainrange where 1=1 ");
        if (StringUtils.isNotEmpty((String)appId)) {
            sb.append(" and fappid = ? ");
            params.add(appId);
        }
        DB.query((DBRoute)DBRoute.permission, (String)sb.toString(), (Object[])params.toArray(new Object[params.size()]), (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws Exception {
                while (rs.next()) {
                    result.add(rs.getString("fappid"));
                }
                return null;
            }
        });
        return result;
    }

    @SdkInternal
    public static boolean inHrCloud(String appId) {
        if (StringUtils.isEmpty((String)appId)) {
            return false;
        }
        AppInfo appInfo = null;
        try {
            appInfo = AppHelper.getMetaAppInfo(appId);
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
            return false;
        }
        if (appInfo == null) {
            return false;
        }
        String cloudId = appInfo.getCloudId();
        ArrayList<String> cloudIds = new ArrayList<String>(10);
        cloudIds.add("0PEIU203SX4Y");
        return cloudIds.contains(cloudId);
    }

    @SdkInternal
    public static List<String> getAdminPermExcludedEntities() {
        ArrayList<String> excludedEntities = new ArrayList<String>(10);
        return excludedEntities;
    }

    @SdkInternal
    public static String getCheckPermAppId_old(String curAppId, String entityNum) {
        Map<String, String> extAppOrgnlAppMap = AppHelper.getExtAppAndOrgnlAppRel(new HashSet<String>(1));
        HashMap<String, Object> extAppAndOrgnlAppRelParamMap = new HashMap<String, Object>(8);
        extAppAndOrgnlAppRelParamMap.put("entityNumList", Lists.newArrayList((Object[])new String[]{entityNum}));
        extAppAndOrgnlAppRelParamMap.put("extAppOrgnlAppMap", extAppOrgnlAppMap);
        Map<String, String> entOriAppIdMap = FormHelper.getAppIdByFormNum(extAppAndOrgnlAppRelParamMap);
        HashMap<String, Object> paramMap = new HashMap<String, Object>(8);
        paramMap.put("entOriAppIdMap", entOriAppIdMap);
        paramMap.put("extAppOrgnlAppMap", extAppOrgnlAppMap);
        return PermCommonUtil.getCheckPermAppId_old(curAppId, entityNum, paramMap);
    }

    @SdkInternal
    public static String getCheckPermAppId_old(String curAppId, String entityNum, Map<String, Object> paramMap) {
        ArrayList<String> entityNums = new ArrayList<String>(10);
        entityNums.add(entityNum);
        Map<String, String> checkPermEntityAppMap = PermCommonUtil.getCheckPermEntityAppMapNew(curAppId, entityNums, paramMap);
        String checkPermAppId = checkPermEntityAppMap.get(entityNum);
        return checkPermAppId;
    }

    @Deprecated
    @SdkInternal
    public static String getCheckPermAppId(String curAppId, String entityNum) {
        Map<String, String> extAppOrgnlAppMap = AppHelper.getExtAppAndOrgnlAppRel(new HashSet<String>(1));
        HashMap<String, Object> extAppAndOrgnlAppRelParamMap = new HashMap<String, Object>(8);
        extAppAndOrgnlAppRelParamMap.put("entityNumList", Lists.newArrayList((Object[])new String[]{entityNum}));
        extAppAndOrgnlAppRelParamMap.put("extAppOrgnlAppMap", extAppOrgnlAppMap);
        Map<String, String> entOriAppIdMap = FormHelper.getAppIdByFormNum(extAppAndOrgnlAppRelParamMap);
        HashMap<String, Object> paramMap = new HashMap<String, Object>(8);
        paramMap.put("entOriAppIdMap", entOriAppIdMap);
        paramMap.put("extAppOrgnlAppMap", extAppOrgnlAppMap);
        return PermCommonUtil.getCheckPermAppId(curAppId, entityNum, paramMap);
    }

    @SdkInternal
    public static String getCheckPermAppId(String curAppId, String entityNum, Map<String, Object> paraMap) {
        ArrayList<String> entityNums = new ArrayList<String>(10);
        entityNums.add(entityNum);
        Map<String, String> checkPermEntityAppMap = PermCommonUtil.getCheckPermEntityAppMap3New(curAppId, entityNums, paraMap);
        String checkPermAppId = checkPermEntityAppMap.get(entityNum);
        if (!Objects.equals(curAppId, checkPermAppId)) {
            logger.debug("PermCommonUtil.getCheckPermAppId(): curAppId:" + curAppId + ", checkPermAppId:" + checkPermAppId);
        }
        return checkPermAppId;
    }

    @SdkInternal
    public static String getCheckPermAppId2(String curAppId, String entityNum) {
        Map<String, String> extAppOrgnlAppMap = AppHelper.getExtAppAndOrgnlAppRel(new HashSet<String>(1));
        HashMap<String, Object> extAppAndOrgnlAppRelParamMap = new HashMap<String, Object>(8);
        extAppAndOrgnlAppRelParamMap.put("entityNumList", Lists.newArrayList((Object[])new String[]{entityNum}));
        extAppAndOrgnlAppRelParamMap.put("extAppOrgnlAppMap", extAppOrgnlAppMap);
        Map<String, String> entOriAppIdMap = FormHelper.getAppIdByFormNum(extAppAndOrgnlAppRelParamMap);
        HashMap<String, Object> paramMap = new HashMap<String, Object>(8);
        paramMap.put("entOriAppIdMap", entOriAppIdMap);
        paramMap.put("extAppOrgnlAppMap", extAppOrgnlAppMap);
        return PermCommonUtil.getCheckPermAppId2(curAppId, entityNum, paramMap);
    }

    @SdkInternal
    public static String getCheckPermAppId2(String curAppId, String entityNum, Map<String, Object> paramMap) {
        ArrayList<String> entityNums = new ArrayList<String>();
        entityNums.add(entityNum);
        Map<String, String> checkPermEntityAppMap = PermCommonUtil.getCheckPermEntityAppMap2New(curAppId, entityNums, paramMap);
        String checkPermAppId = checkPermEntityAppMap.get(entityNum);
        return checkPermAppId;
    }

    @SdkInternal
    public static List<String> getAllCheckPermAppIds(String pFormNum) {
        HashSet<String> allCheckPermAppIds = new HashSet<String>(8);
        String entityNum = "";
        try {
            entityNum = FormMetadataCache.getFormConfig((String)pFormNum).getEntityTypeId();
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
            return new ArrayList<String>(0);
        }
        Map<String, String> extAppOrgnlAppMap = AppHelper.getExtAppAndOrgnlAppRel();
        String originalAppId = BizAppServiceHelp.getAppIdByFormNum((String)entityNum);
        String newOriginalAppId = extAppOrgnlAppMap.get(originalAppId);
        if (StringUtils.isEmpty((String)newOriginalAppId)) {
            extAppOrgnlAppMap = AppHelper.getExtAppAndOrgnlAppRel(null, true);
            newOriginalAppId = extAppOrgnlAppMap.get(originalAppId);
            if (StringUtils.isEmpty((String)newOriginalAppId)) {
                allCheckPermAppIds.add(originalAppId);
            } else {
                allCheckPermAppIds.add(newOriginalAppId);
            }
        } else {
            allCheckPermAppIds.add(newOriginalAppId);
        }
        PermissionControlType permissionControlType = FormHelper.getPermissionControlType(entityNum);
        List<String> publishAppIds = permissionControlType.getPublishApps();
        publishAppIds = PermCommonUtil.removeInvalidPublishAppIds(publishAppIds, entityNum);
        if (publishAppIds != null && !publishAppIds.isEmpty()) {
            allCheckPermAppIds.addAll(publishAppIds);
        }
        Iterator iterator = allCheckPermAppIds.iterator();
        while (iterator.hasNext()) {
            String appId = (String)iterator.next();
            if (StringUtils.isEmpty((String)appId)) {
                iterator.remove();
                continue;
            }
            try {
                AppMetadataCache.getAppInfo((String)appId);
            }
            catch (Exception e) {
                iterator.remove();
            }
        }
        logger.debug("PermCommonUtil.getAllCheckPermAppIds(" + pFormNum + "):" + allCheckPermAppIds);
        return new ArrayList<String>(allCheckPermAppIds);
    }

    private static List<String> removeInvalidPublishAppIds(List<String> publishAppIds, String entityNum) {
        if (publishAppIds == null || publishAppIds.isEmpty() || StringUtils.isEmpty((String)entityNum)) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> resultList = new ArrayList<String>(publishAppIds);
        Iterator iterator = resultList.iterator();
        while (iterator.hasNext()) {
            String appId = (String)iterator.next();
            try {
                boolean checkPermInAllUserApp = PermCommonUtil.checkPermInAllUserApp(appId, entityNum);
                if (!checkPermInAllUserApp) continue;
                iterator.remove();
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }
        return resultList;
    }

    @SdkInternal
    public static List<String> str2List(String str) {
        String[] strArray;
        ArrayList<String> list = new ArrayList<String>();
        for (String s1 : strArray = str.split(",")) {
            if (s1 == null || s1.length() <= 0) continue;
            list.add(s1);
        }
        return list;
    }

    @SdkInternal
    public static String list2Str(List<String> list) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        StringBuilder sbStr = new StringBuilder();
        for (String s : list) {
            if (sbStr.length() > 0) {
                sbStr.append(',');
            }
            sbStr.append(s);
        }
        return sbStr.toString();
    }

    @SdkInternal
    public static List<String> getAllUserAppIds() {
        StringBuilder sql = new StringBuilder();
        sql.append("select a.fid, a.falluserapp aAllUserApp, b.falluserapp bAllUserApp");
        sql.append(" from t_meta_bizapp a");
        sql.append(" left join t_meta_appruntime b on a.fid = b.fid ");
        List result = (List)DB.query((DBRoute)DBRoute.meta, (String)sql.toString(), null, (ResultSetHandler)new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws SQLException {
                ArrayList<String> list = new ArrayList<String>(20);
                while (rs.next()) {
                    String allUserApp;
                    String appId = rs.getString("fid");
                    String aAllUserApp = rs.getString("aAllUserApp");
                    String bAllUserApp = rs.getString("bAllUserApp");
                    String string = allUserApp = StringUtils.isEmpty((String)bAllUserApp) ? aAllUserApp : bAllUserApp;
                    if (!Objects.equals(PermCommonUtil.SEQ_FIRST_PERMCTRLFIELD, allUserApp)) continue;
                    list.add(appId);
                }
                return list;
            }
        });
        return result;
    }

    @SdkInternal
    public static String getDimTypeName(String dimType) {
        String[] suitableDimType = PermCommonUtil.getSuitableDimType(dimType);
        dimType = suitableDimType[0];
        return IsoDimHelper.getPermCtrlTypeName(dimType);
    }

    public static String[] getSuitableDimType(String dimType) {
        return PermCommonUtil.getSuitableDimType(dimType, false);
    }

    public static String[] getSuitableDimType(String dimType, boolean multiDim) {
        try {
            PluginProxy pluginProxy = PluginProxy.create(null, IPermCtrlTypeExt.class, (String)"kd.bos.permission.api.ext.IPermCtrlTypeExt", null);
            PluginCall call = p -> {
                if (p != null) {
                    Set extIdentitySet = p.getExtIdentitySet();
                    if (StringUtils.isNotEmpty((String)dimType) && null != extIdentitySet && extIdentitySet.contains(dimType)) {
                        GetSuitableDimTypeReq req = new GetSuitableDimTypeReq(dimType, multiDim);
                        return p.getSuitableDimType(req);
                    }
                }
                return null;
            };
            List pluginResults = pluginProxy.callReplaceIfPresent(call);
            if (null != pluginResults && !pluginResults.isEmpty()) {
                pluginResults.removeIf(x -> null == x);
                if (null != pluginResults && !pluginResults.isEmpty()) {
                    return ((GetSuitableDimTypeResp)pluginResults.get(0)).getSuitableDimType();
                }
            }
        }
        catch (Exception e) {
            logger.warn("PermCommonUtil.getSuitableDimType error.", (Throwable)e);
        }
        return PermCommonUtil.getGetSuitableDimTypeResp(new GetSuitableDimTypeReq(dimType, multiDim)).getSuitableDimType();
    }

    private static GetSuitableDimTypeResp getGetSuitableDimTypeResp(GetSuitableDimTypeReq req) {
        String dimType = req.getExtIdentity();
        if (StringUtils.isEmpty((String)dimType)) {
            return new GetSuitableDimTypeResp(new String[]{"", "", "", ""});
        }
        boolean multiDim = req.isMultiDim();
        if (!multiDim && dimType.equals("DIM_NULL")) {
            return new GetSuitableDimTypeResp(new String[]{"DIM_ORG", "bos_org", "DIM_ORG", ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"PermCommonUtil_0", (String)"bos-permission-cache", (Object[])new Object[0])});
        }
        DynamicObject dObj = BusinessDataServiceHelper.loadSingleFromCache((String)"perm_ctrltype", (String)"bizobjectid.id,id,name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)dimType)});
        if (dObj != null) {
            String dimTypeEntNum = dObj.getString("bizobjectid.id");
            String id = dObj.getString("id");
            String name = dObj.getString("name");
            return new GetSuitableDimTypeResp(new String[]{dimType, dimTypeEntNum, id, name});
        }
        dObj = BusinessDataServiceHelper.loadSingleFromCache((String)"perm_ctrltype", (String)"number,id,name", (QFilter[])new QFilter[]{new QFilter("bizobjectid", "=", (Object)dimType)});
        if (dObj != null) {
            String newDimType = dObj.getString("number");
            String id = dObj.getString("id");
            String name = dObj.getString("name");
            return new GetSuitableDimTypeResp(new String[]{newDimType, dimType, id, name});
        }
        return new GetSuitableDimTypeResp(new String[]{"", "", "", ""});
    }

    @SdkInternal
    public static boolean needDimControl(String entityNum) {
        if (StringUtils.isEmpty((String)entityNum)) {
            return false;
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNum);
        if (dataEntityType == null) {
            return false;
        }
        PermissionControlType permissionControlType = dataEntityType.getPermissionControlType();
        boolean controlFunction = permissionControlType.isControlFunction();
        if (!controlFunction) {
            return false;
        }
        String dimension = permissionControlType.getDimension();
        if ("DIM_NULL".equals(dimension)) {
            return false;
        }
        if ("DIM_ORG".equals(dimension)) {
            String dataDimensionField = permissionControlType.getDataDimensionField();
            String mainOrg = dataEntityType.getMainOrg();
            if (StringUtils.isEmpty((String)dataDimensionField) && StringUtils.isEmpty((String)mainOrg)) {
                return false;
            }
        } else {
            String dataDimensionField = permissionControlType.getDataDimensionField();
            if (StringUtils.isEmpty((String)dataDimensionField)) {
                return false;
            }
        }
        return true;
    }

    public static String getPermOrgViewScheme(String entityNum) {
        return PermCommonUtil.getPermOrgViewScheme(entityNum, SEQ_FIRST_PERMCTRLFIELD);
    }

    public static String getOriginalOrgFuncId(String entityNum) {
        return PermCommonUtil.getPermOriginalOrgFuncId(entityNum, SEQ_FIRST_PERMCTRLFIELD);
    }

    public static String getPermOrgFuncId(String entityNum) {
        return PermCommonUtil.getPermOrgFuncId(entityNum, SEQ_FIRST_PERMCTRLFIELD);
    }

    @SdkInternal
    public static Map<String, String> getPermOrgFuncNameMap(Set<String> orgViewSet) {
        if (null == orgViewSet || orgViewSet.isEmpty()) {
            return new HashMap<String, String>(1);
        }
        Map bos_org_biz = BusinessDataServiceHelper.loadFromCache((String)"bos_org_biz", (String)"fnumber, fname", (QFilter[])new QFilter[]{new QFilter("fnumber", "in", orgViewSet)});
        if (null == bos_org_biz || bos_org_biz.isEmpty()) {
            return new HashMap<String, String>(1);
        }
        HashMap<String, String> map = new HashMap<String, String>(8);
        for (Map.Entry mm : bos_org_biz.entrySet()) {
            DynamicObject value = (DynamicObject)mm.getValue();
            if (null == value) continue;
            map.put(value.getString("fnumber"), value.getString("fname"));
        }
        return map;
    }

    public static String getCheckPermOrg(String entityNum, String permCtrlFieldSeq) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNum);
        return PermCommonUtil.getCheckPermOrg(dataEntityType, permCtrlFieldSeq);
    }

    public static String getCheckPermOrg(String entityNum) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNum);
        return PermCommonUtil.getCheckPermOrg(dataEntityType, SEQ_FIRST_PERMCTRLFIELD);
    }

    public static String getCheckPermOrg(MainEntityType dataEntityType) {
        return PermCommonUtil.getCheckPermOrg(dataEntityType, SEQ_FIRST_PERMCTRLFIELD);
    }

    public static String getCheckPermOrg(MainEntityType dataEntityType, String permCtrlFieldSeq) {
        PermissionControlType permCtrlType = dataEntityType.getPermissionControlType();
        String entityNum = dataEntityType.getName();
        if (!SEQ_FIRST_PERMCTRLFIELD.equals(permCtrlFieldSeq) && !SEQ_SEC_PERMCTRLFIELD.equals(permCtrlFieldSeq)) {
            return null;
        }
        if (!PermCommonUtil.needDimControl(entityNum)) {
            return null;
        }
        if (!"DIM_ORG".equals(permCtrlType.getDimension())) {
            return null;
        }
        String orgFieldKey = null;
        if (SEQ_SEC_PERMCTRLFIELD.equals(permCtrlFieldSeq)) {
            String assistDimField = permCtrlType.getDataAssistDimensionField();
            if (StringUtils.isEmpty((String)assistDimField)) {
                return null;
            }
            orgFieldKey = assistDimField;
        } else {
            String mainDimField = permCtrlType.getDataDimensionField();
            if (StringUtils.isEmpty((String)mainDimField)) {
                String mainOrg = dataEntityType.getMainOrg();
                if (StringUtils.isEmpty((String)mainOrg)) {
                    return null;
                }
                orgFieldKey = mainOrg;
            } else {
                orgFieldKey = mainDimField;
            }
        }
        if ("null".equalsIgnoreCase(orgFieldKey)) {
            return "";
        }
        return orgFieldKey;
    }

    @SdkInternal
    public static String getCheckPermDimObjFieldKey(String entityNum) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNum);
        return PermCommonUtil.getCheckPermDimObjFieldKey(dataEntityType, SEQ_FIRST_PERMCTRLFIELD);
    }

    @SdkInternal
    public static String getCheckPermDimObjFieldKey(MainEntityType dataEntityType, String permCtrlFieldSeq) {
        PermissionControlType permCtrlType = dataEntityType.getPermissionControlType();
        String entityNum = dataEntityType.getName();
        if (!SEQ_FIRST_PERMCTRLFIELD.equals(permCtrlFieldSeq) && !SEQ_SEC_PERMCTRLFIELD.equals(permCtrlFieldSeq)) {
            return null;
        }
        if (!PermCommonUtil.needDimControl(entityNum)) {
            return null;
        }
        if ("DIM_ORG".equals(permCtrlType.getDimension())) {
            return PermCommonUtil.getCheckPermOrg(dataEntityType, permCtrlFieldSeq);
        }
        String dimObjFieldKey = null;
        if (SEQ_SEC_PERMCTRLFIELD.equals(permCtrlFieldSeq)) {
            String assistDimField = permCtrlType.getDataAssistDimensionField();
            if (StringUtils.isEmpty((String)assistDimField)) {
                return null;
            }
            dimObjFieldKey = assistDimField;
        } else {
            String mainDimField = permCtrlType.getDataDimensionField();
            if (StringUtils.isEmpty((String)mainDimField)) {
                return null;
            }
            dimObjFieldKey = mainDimField;
        }
        if ("null".equalsIgnoreCase(dimObjFieldKey)) {
            return "";
        }
        return dimObjFieldKey;
    }

    public static String getPermOriginalOrgFuncId(String entityNum, String permCtrlFieldSeq) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNum);
        String orgFieldKey = PermCommonUtil.getCheckPermOrg(dataEntityType, permCtrlFieldSeq);
        if (StringUtils.isEmpty((String)orgFieldKey)) {
            return "";
        }
        String orgFunc = null;
        DynamicProperty property = dataEntityType.getProperty(orgFieldKey);
        if (property == null) {
            return "";
        }
        if (property instanceof OrgProp) {
            OrgProp orgProp = (OrgProp)property;
            orgFunc = orgProp.getOrgFunc();
        } else if (property instanceof MulBasedataProp) {
            MulBasedataProp mulBasedataProp = (MulBasedataProp)property;
            orgFunc = mulBasedataProp.getOrgFunc();
        }
        return orgFunc;
    }

    public static String getPermOrgFuncId(String entityNum, String permCtrlFieldSeq) {
        String ORGFUNCID_BIZUNIT = "15";
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNum);
        String orgFieldKey = PermCommonUtil.getCheckPermOrg(dataEntityType, permCtrlFieldSeq);
        if (StringUtils.isEmpty((String)orgFieldKey)) {
            return ORGFUNCID_BIZUNIT;
        }
        String orgFunc = null;
        DynamicProperty property = dataEntityType.getProperty(orgFieldKey);
        if (property == null) {
            return ORGFUNCID_BIZUNIT;
        }
        if (property instanceof OrgProp) {
            OrgProp orgProp = (OrgProp)property;
            orgFunc = orgProp.getOrgFunc();
        } else if (property instanceof MulBasedataProp) {
            MulBasedataProp mulBasedataProp = (MulBasedataProp)property;
            orgFunc = mulBasedataProp.getOrgFunc();
        }
        if (StringUtils.isEmpty(orgFunc)) {
            return ORGFUNCID_BIZUNIT;
        }
        return orgFunc;
    }

    public static String getPermOrgViewScheme(String entityNum, String permCtrlFieldSeq) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNum);
        return PermCommonUtil.getPermOrgViewScheme(dataEntityType, permCtrlFieldSeq);
    }

    public static String getPermOrgViewScheme(MainEntityType dataEntityType) {
        return PermCommonUtil.getPermOrgViewScheme(dataEntityType, SEQ_FIRST_PERMCTRLFIELD);
    }

    public static String getPermOrgViewScheme(MainEntityType dataEntityType, String permCtrlFieldSeq) {
        String ORGFUNCID_BIZUNIT = "15";
        String orgFieldKey = PermCommonUtil.getCheckPermOrg(dataEntityType, permCtrlFieldSeq);
        if (StringUtils.isEmpty((String)orgFieldKey)) {
            return ORGFUNCID_BIZUNIT;
        }
        return PermCommonUtil.getPermOrgViewSchemeByOrgField(dataEntityType, orgFieldKey);
    }

    public static String getPermOrgViewSchemeByOrgField(String entityNum, String orgFieldKey) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNum);
        return PermCommonUtil.getPermOrgViewSchemeByOrgField(dataEntityType, orgFieldKey);
    }

    public static String getPermOrgViewSchemeByOrgField(MainEntityType dataEntityType, String orgFieldKey) {
        String orgViewSchemeNum;
        String ORGFUNCID_BIZUNIT = "15";
        OrgProp orgProp = null;
        DynamicProperty property = dataEntityType.getProperty(orgFieldKey);
        if (property instanceof OrgProp) {
            orgProp = (OrgProp)dataEntityType.getProperty(orgFieldKey);
        }
        if (property == null || orgProp == null) {
            return ORGFUNCID_BIZUNIT;
        }
        OrgViewSchemeProp orgViewScheme = orgProp.getOrgViewScheme();
        if (orgViewScheme != null && StringUtils.isNotEmpty((String)(orgViewSchemeNum = orgViewScheme.getNumber()))) {
            return orgViewSchemeNum;
        }
        String orgFunc = orgProp.getOrgFunc();
        if (StringUtils.isEmpty((String)orgFunc)) {
            return ORGFUNCID_BIZUNIT;
        }
        return orgFunc;
    }

    @SdkInternal
    public static String getUseOrgViewNum(String entityNum, String propKey) {
        if (StringUtils.isEmpty((String)entityNum) || StringUtils.isEmpty((String)propKey)) {
            return "15";
        }
        MainEntityType dataEntityType = null;
        try {
            dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNum);
        }
        catch (Exception e) {
            logger.warn("Can't find entity: " + entityNum, (Throwable)e);
            return "15";
        }
        IDataEntityProperty prop = null;
        try {
            prop = dataEntityType.findProperty(propKey);
        }
        catch (Exception e) {
            logger.warn("Can't find entity[" + entityNum + "]propkey[" + propKey + "]", (Throwable)e);
            return "15";
        }
        if (prop instanceof BasedataProp) {
            BasedataProp bdProp = (BasedataProp)prop;
            String orgKey = bdProp.getOrgProp();
            return PermCommonUtil.getPermOrgViewSchemeByOrgField(dataEntityType, orgKey);
        }
        if (prop instanceof MulBasedataProp) {
            MulBasedataProp mulBdProp = (MulBasedataProp)prop;
            String orgKey = mulBdProp.getOrgProp();
            return PermCommonUtil.getPermOrgViewSchemeByOrgField(dataEntityType, orgKey);
        }
        return "15";
    }

    @SdkInternal
    public static boolean existsDuplicateOpRulObjEnable(String curOpRuleObjId, List<Long> curOrgIdListFromView, String operationKey, String entityNum, String appId) {
        DynamicObject[] otherOpRuleObjDObjs;
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        filterList.add(new QFilter("entitytype.id", "=", (Object)entityNum));
        filterList.add(new QFilter("objenabled", "=", (Object)SEQ_FIRST_PERMCTRLFIELD));
        filterList.add(new QFilter("operationrule.operation_key", "=", (Object)operationKey));
        filterList.add(new QFilter("bizapp", "=", (Object)appId));
        if (StringUtils.isNotEmpty((String)curOpRuleObjId)) {
            filterList.add(new QFilter("id", "!=", (Object)curOpRuleObjId));
        }
        return (otherOpRuleObjDObjs = BusinessDataServiceHelper.load((String)"perm_operationruleobj", (String)"id", (QFilter[])filterList.toArray(new QFilter[0]))) != null && otherOpRuleObjDObjs.length != 0;
    }

    public static void closeDataSet(DataSet ... dataSets) {
        for (DataSet dataSet : dataSets) {
            if (dataSet == null) continue;
            dataSet.close();
        }
    }

    public static boolean isCosmicUser(Long userId) {
        return userId.equals(10L);
    }

    @SdkInternal
    public static QFilter getQFilterFromEntNumRuleJson(String pEntityNum, String ruleJsonStr) {
        if (StringUtils.isEmpty((String)ruleJsonStr)) {
            return null;
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)pEntityNum);
        return PermCommonUtil.getQFilterFromFilterGridJsonStr(entityType, ruleJsonStr);
    }

    @SdkInternal
    public static Date getDefaultEndTime() {
        Date date = new Date();
        date.setYear(1099);
        date.setMonth(11);
        date.setDate(31);
        date.setHours(23);
        date.setMinutes(59);
        date.setSeconds(59);
        long milliseconds = date.getTime();
        long mod = milliseconds % 1000L;
        if (mod > 500L) {
            date.setTime(milliseconds -= 500L);
        }
        return date;
    }

    @SdkInternal
    public static boolean isExpireTime(Date startTime, Date endTime) {
        return PermCommonUtil.isExpireTime(new Date(), startTime, endTime);
    }

    @SdkInternal
    public static boolean isExpireTime(Date specificDate, Date startTime, Date endTime) {
        if (startTime == null && endTime == null) {
            return false;
        }
        if (startTime == null && endTime != null) {
            return specificDate.after(endTime);
        }
        if (startTime != null && endTime == null) {
            return false;
        }
        return specificDate.after(endTime);
    }

    @SdkInternal
    public static boolean isInValidateTime(Date specificDate, Date startTime, Date endTime) {
        if (startTime == null && endTime == null) {
            return true;
        }
        if (startTime == null) {
            return specificDate.before(endTime);
        }
        if (endTime == null) {
            return specificDate.after(startTime);
        }
        return specificDate.after(startTime) && specificDate.before(endTime);
    }

    @SdkInternal
    public static boolean isInValidateTime(Date startTime, Date endTime) {
        Date now = new Date();
        return PermCommonUtil.isInValidateTime(now, startTime, endTime);
    }

    @SdkInternal
    public static List<String> checkValidateTime(Date startTime, Date endTime, Map<String, Object> paramMap) {
        boolean enableValidateTime;
        ArrayList<String> list = new ArrayList<String>(10);
        boolean bl = enableValidateTime = null == paramMap.get("enableValidateTime") ? PermCommonUtil.isEnableValidateTime() : (Boolean)paramMap.get("enableValidateTime");
        if (!enableValidateTime) {
            return list;
        }
        if (null != startTime && startTime.before(DateUtil.toDate("1900-01-01 00:00:00", "yyyy-MM-dd HH:mm:ss"))) {
            list.add(ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e1900-01-01 00:00:00\u3002", (String)"PermCommonUtil_6", (String)"bos-permission-cache", (Object[])new Object[0]));
        }
        if (null != endTime) {
            if (endTime.after(DateUtil.toDate("2999-12-31 23:59:59", "yyyy-MM-dd HH:mm:ss"))) {
                list.add(ResManager.loadKDString((String)"\u5931\u6548\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e2999-12-31 23:59:59\u3002", (String)"PermCommonUtil_7", (String)"bos-permission-cache", (Object[])new Object[0]));
            }
            if (endTime.before(new Date())) {
                list.add(ResManager.loadKDString((String)"\u201c\u5931\u6548\u65e5\u671f\u201d\u9700\u5927\u4e8e\u5f53\u524d\u65f6\u95f4\u3002", (String)"PermCommonUtil_8", (String)"bos-permission-cache", (Object[])new Object[0]));
            }
        }
        if (null != startTime && null != endTime && startTime.compareTo(endTime) >= 0) {
            list.add(ResManager.loadKDString((String)"\u201c\u751f\u6548\u65e5\u671f\u201d\u9700\u5c0f\u4e8e\u201c\u5931\u6548\u65e5\u671f\u201d\u3002", (String)"PermCommonUtil_9", (String)"bos-permission-cache", (Object[])new Object[0]));
        }
        return list;
    }

    @SdkInternal
    public static int calcRemainExpireTime(Date specificDate, Date endTime) {
        if (specificDate == null || endTime == null) {
            return CacheMrg.getExpireTime();
        }
        long remainTime = endTime.getTime() - specificDate.getTime();
        if (remainTime <= 0L) {
            return CacheMrg.getExpireTime();
        }
        int expireTimeInSec = CacheMrg.getExpireTime();
        long expireTimeInMillSec = 1000 * expireTimeInSec;
        if (remainTime >= expireTimeInMillSec) {
            return expireTimeInSec;
        }
        return (int)remainTime / 1000;
    }

    @SdkInternal
    public static int calcRemainExpireTime(Date endTime) {
        Date now = new Date();
        return PermCommonUtil.calcRemainExpireTime(now, endTime);
    }

    public static QFilter getQFilterFromFilterGridJsonStr(MainEntityType entityType, String ruleJsonStr) {
        if (StringUtils.isEmpty((String)ruleJsonStr)) {
            return null;
        }
        FilterCondition fc = (FilterCondition)SerializationUtils.fromJsonString((String)ruleJsonStr, FilterCondition.class);
        return PermCommonUtil.getQFilterFromFilterCondition(entityType, fc);
    }

    public static QFilter getQFilterFromFilterGridJsonStr(String appId, MainEntityType entityType, String ruleJsonStr) {
        if (StringUtils.isEmpty((String)ruleJsonStr)) {
            return null;
        }
        FilterCondition fc = (FilterCondition)SerializationUtils.fromJsonString((String)ruleJsonStr, FilterCondition.class);
        return PermCommonUtil.getQFilterFromFilterCondition(appId, entityType, fc);
    }

    @SdkInternal
    public static QFilter getQFilterFromEntNumFilterCondition(String pEntityNum, FilterCondition fc) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)pEntityNum);
        return PermCommonUtil.getQFilterFromFilterCondition(entityType, fc);
    }

    public static QFilter getQFilterFromFilterCondition(MainEntityType entityType, FilterCondition fc) {
        if (fc == null) {
            return null;
        }
        FilterBuilder builder = new FilterBuilder(entityType, fc);
        builder.setTimeService((ITimeService)new TimeService());
        builder.setUserService((IUserService)new UserService());
        builder.buildFilter();
        QFilter resultFilter = builder.getQFilter();
        return resultFilter;
    }

    public static QFilter getQFilterFromFilterCondition(String appId, MainEntityType entityType, FilterCondition fc) {
        if (fc == null) {
            return null;
        }
        fc = PermCommonUtil.replaceMyHasRight(appId, entityType, fc, true);
        FilterBuilder builder = new FilterBuilder(entityType, fc);
        builder.setTimeService((ITimeService)new TimeService());
        builder.setUserService((IUserService)new UserService());
        builder.buildFilter();
        QFilter resultFilter = builder.getQFilter();
        return resultFilter;
    }

    @SdkInternal
    public static FilterCondition replaceMyHasRight(String appId, MainEntityType entityType, FilterCondition fc, boolean mustQuery) {
        List filterList = fc.getFilterRow();
        PermCtrlTypeReq req = new PermCtrlTypeReq(null, (Set)Sets.newHashSet((Object[])new String[]{SEQ_FIRST_PERMCTRLFIELD}), null, null, null);
        Map<String, PermCtrlType> permCtrlTypeMap = IsoDimHelper.getEntPermCtrlTypeMap(req);
        HashSet dimIdSet = null;
        String orgView = null;
        String permItemId = "47150e89000000ac";
        long currUserId = RequestContext.get().getCurrUserId();
        Map allFields = entityType.getAllFields();
        for (SimpleFilterRow sfr : filterList) {
            FilterValue fv;
            String dimType;
            PermCtrlType permCtrlType;
            String orgnlFieldKey;
            String compType = sfr.getCompareType();
            if (!compType.contains("perm_myhasright_")) continue;
            String fieldKey = orgnlFieldKey = sfr.getFieldName();
            int i = orgnlFieldKey.lastIndexOf(46);
            if (i > 0) {
                fieldKey = orgnlFieldKey.substring(0, i);
            }
            if (null == (permCtrlType = permCtrlTypeMap.get(dimType = compType.replace("perm_myhasright_", "")))) continue;
            String entityNum = entityType.getName();
            PermissionService permService = (PermissionService)ServiceFactory.getService(PermissionService.class);
            HasPermOrgResult hasPermOrgResult = null;
            if (Objects.equals("bos_org", dimType)) {
                orgView = PermCommonUtil.getPermOrgViewSchemeByOrgField(entityNum, fieldKey);
                hasPermOrgResult = permService.getAllPermOrgs(currUserId, dimType, orgView, true, appId, entityNum, permItemId);
                if (mustQuery && hasPermOrgResult.hasAllOrgPerm()) {
                    hasPermOrgResult.getHasPermOrgs().addAll(OrgUnitServiceHelper.getAllOrg((String)orgView));
                }
                if (PermCommonUtil.ifFirstOrgProp(orgnlFieldKey, allFields)) {
                    sfr.setCompareType(CompareTypeEnum.ORGIN.getId());
                } else {
                    sfr.setCompareType(CompareTypeEnum.IN.getId());
                }
            } else {
                hasPermOrgResult = permService.getAllPermOrgs(currUserId, dimType, null, false, appId, entityNum, permItemId);
                sfr.setCompareType(CompareTypeEnum.IN.getId());
            }
            sfr.setCompareTypeDesc(DrHelper.getMyHasRightPrefixDesc() + permCtrlType.getName());
            String fieldName = sfr.getFieldName();
            if (fieldName.contains(".")) {
                fieldName = fieldName.substring(0, fieldName.lastIndexOf(46)) + ".id";
                sfr.setFieldName(fieldName);
            }
            ArrayList<FilterValue> valueList = new ArrayList<FilterValue>();
            boolean hasAllOrgPerm = hasPermOrgResult.hasAllOrgPerm();
            if (!mustQuery && hasAllOrgPerm) {
                fv = new FilterValue();
                fv.setId(Uuid16.create().toString());
                fv.setValue((Object)"999");
                valueList.add(fv);
                sfr.setValue(valueList);
                continue;
            }
            if (!mustQuery && !hasAllOrgPerm) {
                fv = new FilterValue();
                fv.setId(Uuid16.create().toString());
                fv.setValue((Object)"999");
                valueList.add(fv);
                sfr.setValue(valueList);
                continue;
            }
            dimIdSet = new HashSet(hasPermOrgResult.getHasPermOrgs());
            if (mustQuery && !hasAllOrgPerm && Objects.equals("bos_org", dimType)) {
                IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
                List dimIdList = orgService.filterOrgDuty(new ArrayList(dimIdSet), orgView);
                dimIdSet = new HashSet(dimIdList);
            }
            if (null == dimIdSet || dimIdSet.isEmpty()) {
                fv = new FilterValue();
                fv.setId(Uuid16.create().toString());
                fv.setValue((Object)"-1");
                valueList.add(fv);
            } else {
                for (Long dimId : dimIdSet) {
                    FilterValue fv2 = new FilterValue();
                    fv2.setId(Uuid16.create().toString());
                    fv2.setValue((Object)String.valueOf(dimId));
                    valueList.add(fv2);
                }
            }
            sfr.setValue(valueList);
        }
        return fc;
    }

    @SdkInternal
    public static void validateFilterCondition(String pEntityNum, FilterCondition fc) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)pEntityNum);
        PermCommonUtil.validateFilterCondition(entityType, fc);
    }

    @SdkInternal
    public static void validateFilterCondition(MainEntityType entityType, FilterCondition fc) {
        if (fc == null) {
            return;
        }
        fc = PermCommonUtil.replaceMyHasRight("", entityType, fc, false);
        FilterBuilderParameter fbp = new FilterBuilderParameter(entityType, fc);
        fbp.setNeedParse(false);
        FilterBuilder builder = new FilterBuilder(fbp);
        builder.setTimeService((ITimeService)new TimeService());
        builder.setUserService((IUserService)new UserService());
        builder.buildFilter();
    }

    @SdkInternal
    public static String getDataRuleScriptFromFilterCond(MainEntityType entityType, FilterCondition fc) {
        if (fc == null) {
            return null;
        }
        FilterBuilder builder = new FilterBuilder(entityType, fc);
        builder.setTimeService((ITimeService)new TimeService());
        builder.setUserService((IUserService)new UserService());
        builder.buildFilter();
        String dataRuleScript = builder.buildFilterScript()[0];
        return dataRuleScript;
    }

    @SdkInternal
    public static String getDataRuleScriptFromJson(MainEntityType entityType, String ruleJsonStr) {
        if (StringUtils.isEmpty((String)ruleJsonStr)) {
            return null;
        }
        FilterCondition fc = (FilterCondition)SerializationUtils.fromJsonString((String)ruleJsonStr, FilterCondition.class);
        FilterBuilder builder = new FilterBuilder(entityType, fc);
        builder.setTimeService((ITimeService)new TimeService());
        builder.setUserService((IUserService)new UserService());
        builder.buildFilter();
        String[] buildFilterScript = builder.buildFilterScript();
        if (buildFilterScript == null || buildFilterScript.length == 0) {
            return null;
        }
        String dataRuleScript = buildFilterScript[0];
        return dataRuleScript;
    }

    @SdkInternal
    public static String getDataRuleScriptFromJson(String appId, MainEntityType entityType, String ruleJsonStr) {
        if (StringUtils.isEmpty((String)ruleJsonStr)) {
            return null;
        }
        FilterCondition fc = (FilterCondition)SerializationUtils.fromJsonString((String)ruleJsonStr, FilterCondition.class);
        fc = PermCommonUtil.replaceMyHasRight(appId, entityType, fc, true);
        FilterBuilder builder = new FilterBuilder(entityType, fc);
        builder.setTimeService((ITimeService)new TimeService());
        builder.setUserService((IUserService)new UserService());
        builder.buildFilter();
        String[] buildFilterScript = builder.buildFilterScript();
        if (buildFilterScript == null || buildFilterScript.length == 0) {
            return null;
        }
        String dataRuleScript = buildFilterScript[0];
        return dataRuleScript;
    }

    @Deprecated
    @SdkInternal
    public static QFilter convertQFilter(String entityNum, QFilter srcQFilter) {
        HashMap<String, QFilter> convertRuleRowMap = new HashMap<String, QFilter>(16);
        return PermCommonUtil.convertQFilter(entityNum, srcQFilter, convertRuleRowMap);
    }

    @Deprecated
    @SdkInternal
    public static QFilter convertQFilter(String entityNum, QFilter srcQFilter, Map<String, QFilter> convertRuleRowMap) {
        if (srcQFilter == null) {
            return null;
        }
        String serializedQFilterStr = srcQFilter.toSerializedString();
        QFilter resultFromMap = convertRuleRowMap.get(serializedQFilterStr);
        if (resultFromMap != null) {
            return resultFromMap;
        }
        HashMap entityTypeInfo = new HashMap(16);
        QFilter resultQFilter = srcQFilter.trans(q -> {
            DynamicProperty dyProp;
            QFilter hasConvertQFilter = (QFilter)convertRuleRowMap.get(q.toSerializedString());
            if (hasConvertQFilter != null) {
                return hasConvertQFilter;
            }
            String propKey = q.getProperty();
            String[] propPartArr = propKey.split("\\.");
            if (propPartArr.length == 1) {
                return q;
            }
            QFilter returnQFilter = null;
            MainEntityType entityType = (MainEntityType)entityTypeInfo.get(entityNum);
            if (entityType == null) {
                entityType = EntityMetadataCache.getDataEntityType((String)entityNum);
                entityTypeInfo.put(entityNum, entityType);
            }
            if ((dyProp = entityType.getProperty(propPartArr[0])) instanceof JoinProperty) {
                JoinProperty jp = (JoinProperty)dyProp;
                String subEntNum = jp.getName();
                String subEntPropKey = q.getProperty();
                int dotIndex = subEntPropKey.indexOf(46);
                if (dotIndex == -1) {
                    return q;
                }
                String newSubEntPropKey = subEntPropKey.substring(dotIndex + 1);
                q = new QFilter(newSubEntPropKey, q.getCP(), q.getValue());
                q = PermCommonUtil.convertQFilter(subEntNum, q, convertRuleRowMap);
                q = new QFilter(subEntNum + "." + q.getProperty(), q.getCP(), q.getValue());
            } else {
                if (dyProp instanceof BasedataProp || dyProp instanceof RefBillProp || dyProp instanceof MulBasedataProp) {
                    return PermCommonUtil.propCollapse(null, convertRuleRowMap, q, propPartArr, dyProp);
                }
                if (dyProp instanceof EntryProp && ((dyProp = ((EntryProp)dyProp).getDynamicCollectionItemPropertyType().getProperty(propPartArr[1])) instanceof BasedataProp || dyProp instanceof RefBillProp || dyProp instanceof MulBasedataProp) && propPartArr.length >= 3) {
                    String baseEntityId = PermCommonUtil.getBaseOrBillEntityNum((IDataEntityProperty)dyProp);
                    QFilter bdPropInEntry = null;
                    MainEntityType subEntityType = EntityMetadataCache.getDataEntityType((String)baseEntityId);
                    DynamicProperty subEntProp = subEntityType.getProperty(propPartArr[2]);
                    bdPropInEntry = dyProp instanceof MulBasedataProp ? (propPartArr.length == 3 ? PermCommonUtil.propCollapse(null, convertRuleRowMap, q, new String[]{propPartArr[1], propPartArr[2], "id"}, dyProp) : PermCommonUtil.propCollapse(null, convertRuleRowMap, q, new String[]{propPartArr[1], propPartArr[2], propPartArr[3]}, dyProp)) : (subEntProp instanceof BasedataProp || subEntProp instanceof RefBillProp ? (propPartArr.length == 3 ? PermCommonUtil.propCollapse(null, convertRuleRowMap, q, new String[]{propPartArr[1], propPartArr[2], "id"}, dyProp) : PermCommonUtil.propCollapse(null, convertRuleRowMap, q, new String[]{propPartArr[1], propPartArr[2], propPartArr[3]}, dyProp)) : (subEntProp instanceof EntryProp ? (propPartArr.length == 3 ? PermCommonUtil.propCollapse(null, convertRuleRowMap, q, new String[]{propPartArr[1], propPartArr[2], "id"}, dyProp) : (propPartArr.length == 4 ? PermCommonUtil.propCollapse(null, convertRuleRowMap, q, new String[]{propPartArr[1], propPartArr[2], propPartArr[3], "id"}, dyProp) : PermCommonUtil.propCollapse(null, convertRuleRowMap, q, new String[]{propPartArr[1], propPartArr[2], propPartArr[3], propPartArr[4]}, dyProp))) : PermCommonUtil.propCollapse(null, convertRuleRowMap, q, new String[]{propPartArr[1], propPartArr[2]}, dyProp)));
                    if (bdPropInEntry.getValue() instanceof QEmptyValue) {
                        returnQFilter = new QFilter(propPartArr[0] + "." + bdPropInEntry.getProperty(), bdPropInEntry.getCP(), bdPropInEntry.getValue());
                    } else {
                        String finalCP = "in";
                        if ("not in".equals(bdPropInEntry.getCP())) {
                            finalCP = "not in";
                        }
                        returnQFilter = new QFilter(propPartArr[0] + "." + bdPropInEntry.getProperty(), finalCP, bdPropInEntry.getValue());
                    }
                    convertRuleRowMap.put(q.toSerializedString(), returnQFilter);
                    return returnQFilter;
                }
            }
            return q;
        });
        convertRuleRowMap.put(serializedQFilterStr, resultQFilter);
        return resultQFilter;
    }

    @SdkInternal
    private static String getBaseOrBillEntityNum(IDataEntityProperty prop) {
        String entityNum = "";
        if (prop instanceof BasedataProp) {
            entityNum = ((BasedataProp)prop).getBaseEntityId();
        } else if (prop instanceof MulBasedataProp) {
            entityNum = ((MulBasedataProp)prop).getBaseEntityId();
        } else if (prop instanceof RefBillProp) {
            entityNum = ((RefBillProp)prop).getBillEntityId();
        }
        return entityNum;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    @SdkInternal
    private static QFilter propCollapse(String baseEntityNum, Map<String, QFilter> convertRuleRowMap, QFilter q, String[] propPartArr, DynamicProperty dyProp) {
        QFilter returnQFilter;
        ArrayList<Object> ids;
        DynamicObjectCollection doc;
        QFilter newQ;
        if (propPartArr.length > 2) {
            QFilter resultFilter = null;
            String propKey0 = propPartArr[0];
            String propKey1 = propPartArr[1];
            String propKey2 = propPartArr[2];
            String propKey3 = "";
            if (propPartArr.length > 3) {
                propKey3 = propPartArr[3];
            }
            if (dyProp instanceof BasedataProp || dyProp instanceof RefBillProp) {
                baseEntityNum = PermCommonUtil.getBaseOrBillEntityNum((IDataEntityProperty)dyProp);
                DynamicProperty subProp = EntityMetadataCache.getDataEntityType((String)baseEntityNum).getProperty(propKey1);
                if (subProp instanceof BasedataProp || subProp instanceof RefBillProp) {
                    String subBaseDataEntityNum = PermCommonUtil.getBaseOrBillEntityNum((IDataEntityProperty)subProp);
                    DynamicProperty thirdProp = EntityMetadataCache.getDataEntityType((String)subBaseDataEntityNum).getProperty(propKey2);
                    resultFilter = new QFilter(propKey1 + "." + propKey2, q.getCP(), q.getValue());
                    resultFilter = PermCommonUtil.propCollapse(subBaseDataEntityNum, convertRuleRowMap, resultFilter, new String[]{propKey1, propKey2}, thirdProp);
                    resultFilter = new QFilter(propKey0 + "." + propKey1, resultFilter.getCP(), resultFilter.getValue());
                    return PermCommonUtil.propCollapse(baseEntityNum, convertRuleRowMap, resultFilter, new String[]{propKey0, propKey1}, subProp);
                }
                if (!(subProp instanceof EntryProp)) return q;
                DynamicProperty thirdProp = ((EntryProp)subProp).getDynamicCollectionItemPropertyType().getProperty(propKey2);
                if (thirdProp instanceof ItemClassTypeProp) {
                    return new QFilter(propKey0 + "." + propKey1 + "." + propKey2, q.getCP(), q.getValue());
                }
                if (thirdProp instanceof BasedataProp || thirdProp instanceof RefBillProp) {
                    String thirdBaseDataEntityNum = PermCommonUtil.getBaseOrBillEntityNum((IDataEntityProperty)thirdProp);
                    if (StringUtils.isEmpty((String)propKey3)) {
                        propKey3 = "id";
                    }
                    DynamicProperty lastProp = EntityMetadataCache.getDataEntityType((String)thirdBaseDataEntityNum).getProperty(propKey3);
                    resultFilter = new QFilter(propKey2 + "." + propKey3, q.getCP(), q.getValue());
                    resultFilter = PermCommonUtil.propCollapse(thirdBaseDataEntityNum, convertRuleRowMap, resultFilter, new String[]{propKey2, propKey3}, lastProp);
                    resultFilter = new QFilter(propKey0 + "." + propKey2, resultFilter.getCP(), resultFilter.getValue());
                    return PermCommonUtil.propCollapse(baseEntityNum, convertRuleRowMap, resultFilter, new String[]{propKey0, propKey1 + "." + propKey2}, dyProp);
                }
                resultFilter = new QFilter(propKey1 + "." + propKey2, q.getCP(), q.getValue());
                resultFilter = PermCommonUtil.propCollapse(baseEntityNum, convertRuleRowMap, resultFilter, new String[]{propKey1, propKey2}, dyProp);
                return new QFilter(propKey0, resultFilter.getCP(), resultFilter.getValue());
            }
            if (!(dyProp instanceof MulBasedataProp)) return resultFilter;
            return PermCommonUtil.collapseMulBasedataProp(q, dyProp, propKey0, propKey2);
        }
        if (StringUtils.isEmpty((String)baseEntityNum)) {
            baseEntityNum = PermCommonUtil.getBaseOrBillEntityNum((IDataEntityProperty)dyProp);
        }
        String propKey0 = propPartArr[0];
        String propKey1 = propPartArr[1];
        String compareType = q.getCP();
        Object value = q.getValue();
        if (value instanceof MultiBaseDataFilterValue) {
            MultiBaseDataFilterValue mulBdFilterValue = (MultiBaseDataFilterValue)value;
            value = mulBdFilterValue.getValue();
            if ("like".equalsIgnoreCase(compareType) || "not like".equalsIgnoreCase(compareType)) {
                if (value instanceof List) {
                    List tempValueList = (List)value;
                    if (!tempValueList.isEmpty()) {
                        Object tempValue = tempValueList.get(0);
                        value = "%" + tempValue + "%";
                    }
                } else if (value instanceof String) {
                    value = "%" + value + "%";
                }
            }
            baseEntityNum = mulBdFilterValue.getBaseDataName();
        }
        if (q.getCP().equals("<>") || q.getCP().equals("!=")) {
            newQ = new QFilter(propKey1, "=", value);
            doc = QueryServiceHelper.query((String)baseEntityNum, (String)"id", (QFilter[])new QFilter[]{newQ});
            ids = new ArrayList<Object>(10);
            for (DynamicObject dObj : doc) {
                ids.add(dObj.get("id"));
            }
            returnQFilter = new QFilter(propKey0, "not in", ids);
        } else if (q.getCP().equals("=") && q.getValue() instanceof QEmptyValue || q.getCP().equals("is null")) {
            IDataEntityType parentType = dyProp.getParent();
            returnQFilter = dyProp instanceof MulBasedataProp ? PermCommonUtil.collapseMulBasedataProp(q, dyProp, propKey0, "id") : new QFilter(propKey0, "=", (Object)QEmptyValue.value);
        } else if (q.getCP().equalsIgnoreCase("not in")) {
            newQ = new QFilter(propKey1, "in", value);
            doc = QueryServiceHelper.query((String)baseEntityNum, (String)"id", (QFilter[])new QFilter[]{newQ});
            ids = new ArrayList(10);
            for (DynamicObject dObj : doc) {
                ids.add(dObj.get("id"));
            }
            returnQFilter = new QFilter(propKey0, "not in", ids);
        } else {
            newQ = new QFilter(propKey1, q.getCP(), value);
            doc = QueryServiceHelper.query((String)baseEntityNum, (String)"id", (QFilter[])new QFilter[]{newQ});
            ids = new ArrayList(10);
            for (DynamicObject dObj : doc) {
                ids.add(dObj.get("id"));
            }
            returnQFilter = new QFilter(propKey0, "in", ids);
        }
        convertRuleRowMap.put(q.toSerializedString(), returnQFilter);
        return returnQFilter;
    }

    @SdkInternal
    private static QFilter collapseMulBasedataProp(QFilter q, DynamicProperty dyProp, String propKey0, String propKey2) {
        boolean emptyValue = q.getValue() instanceof QEmptyValue;
        ArrayList<Object> ids = new ArrayList<Object>(10);
        if (!emptyValue) {
            String baseEntityNum = PermCommonUtil.getBaseOrBillEntityNum((IDataEntityProperty)dyProp);
            QFilter bdFilter = new QFilter(propKey2, q.getCP(), q.getValue());
            DynamicObjectCollection bdDoc = QueryServiceHelper.query((String)baseEntityNum, (String)"id", (QFilter[])new QFilter[]{bdFilter});
            for (DynamicObject dObj : bdDoc) {
                ids.add(dObj.get("id"));
            }
        }
        IDataEntityType parent = dyProp.getParent();
        String topParentEntNum = "";
        String curFilterKey = "";
        String selFields = "";
        if (parent instanceof EntryType) {
            String entryEntityKey = parent.getName();
            topParentEntNum = parent.getParent().getName();
            curFilterKey = entryEntityKey + "." + propKey0 + ".fbasedataid";
            selFields = entryEntityKey;
        } else {
            topParentEntNum = parent.getName();
            curFilterKey = propKey0 + ".fbasedataid";
            selFields = "id";
        }
        QFilter mulBdFilter = null;
        mulBdFilter = emptyValue ? new QFilter(curFilterKey, q.getCP(), q.getValue()) : new QFilter(curFilterKey, "in", ids);
        DynamicObjectCollection mulBdDoc = QueryServiceHelper.query((String)topParentEntNum, (String)selFields, (QFilter[])new QFilter[]{mulBdFilter});
        ArrayList<Object> parentPkIds = new ArrayList<Object>(10);
        for (DynamicObject dObj : mulBdDoc) {
            parentPkIds.add(dObj.get(selFields));
        }
        return new QFilter("id", "in", parentPkIds);
    }

    @Deprecated
    @SdkInternal
    public static QFilter convertRule(MainEntityType entityType, String ruleJson, Map<String, QFilter> convertRuleMap, Map<String, QFilter> convertRuleRowMap) {
        QFilter resultRuleQFilter = convertRuleMap.get(ruleJson);
        if (resultRuleQFilter != null) {
            return resultRuleQFilter;
        }
        QFilter q = PermCommonUtil.getQFilterFromFilterGridJsonStr(entityType, ruleJson);
        q = PermCommonUtil.convertQFilter(entityType.getName(), q, convertRuleRowMap);
        convertRuleMap.put(ruleJson, q);
        return q;
    }

    public static String getAppIdFromSuspectedAppNum(String appIdOrNum) {
        RequestContext rc = RequestContext.get();
        String key = String.format("%s%s%s", "getAppIdFromSuspectedAppNum_", rc.getAccountId(), appIdOrNum);
        Map threadCacheMap = (Map)ThreadCache.get((Object)key, () -> {
            HashMap<String, String> map = new HashMap<String, String>(8);
            String appId = PermCommonUtil.getAppIdFromSuspectedAppNumPri(appIdOrNum);
            if (null == appId) {
                return map;
            }
            map.put("appId", appId);
            return map;
        });
        return (String)threadCacheMap.get("appId");
    }

    @SdkInternal
    private static String getAppIdFromSuspectedAppNumPri(String appIdOrNum) {
        if (StringUtils.isEmpty((String)appIdOrNum) || "bos".equals(appIdOrNum)) {
            return appIdOrNum;
        }
        AppInfo appInfo = AppHelper.getMetaAppInfo(appIdOrNum);
        return null == appInfo ? appIdOrNum : appInfo.getId();
    }

    @SdkInternal
    public static boolean hasEnableOldDataRule() {
        DynamicObject dObj = BusinessDataServiceHelper.loadSingleFromCache((Object)1L, (String)"perm_olddataruleenable");
        if (dObj == null) {
            return true;
        }
        return dObj.getBoolean("enable_olddatarule");
    }

    @SdkInternal
    public static boolean hasEnableRoleDataRuleNewModel() {
        DynamicObject dObj = BusinessDataServiceHelper.loadSingleFromCache((Object)1L, (String)"perm_olddataruleenable");
        if (dObj == null) {
            return true;
        }
        boolean enableFlag = false;
        try {
            enableFlag = dObj.getBoolean("enable_roledr_newmodel");
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
        }
        return enableFlag;
    }

    @SdkInternal
    public static boolean hasEnablePropCollapse() {
        try {
            DynamicObject dObj = BusinessDataServiceHelper.loadSingleFromCache((Object)1L, (String)"perm_olddataruleenable");
            if (dObj == null) {
                return false;
            }
            return dObj.getBoolean("enable_propcollapse");
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
            return false;
        }
    }

    @SdkInternal
    public static boolean hasEnableOldAdmin() {
        return PermCommonUtil.hasEnableOldAdmin(null);
    }

    @SdkInternal
    public static boolean hasEnableOldAdmin(Map<String, Object> paraMap) {
        String key;
        String type4HasEnableOldAdmin = null == paraMap || null == paraMap.get("type4HasEnableOldAdmin") ? CacheMrg.getType4HasEnableOldAdmin() : (String)paraMap.get("type4HasEnableOldAdmin");
        String hasEnableOldAdmin = CacheMrg.getCache(type4HasEnableOldAdmin, key = "hasEnableOldAdmin");
        if (StringUtils.isNotEmpty((String)hasEnableOldAdmin)) {
            return Boolean.parseBoolean(hasEnableOldAdmin);
        }
        DynamicObject dObj = BusinessDataServiceHelper.loadSingle((Object)1L, (String)"perm_oldadminenable", (String)"enable_admin");
        if (null == dObj) {
            CacheMrg.putCache(type4HasEnableOldAdmin, key, "true");
            return true;
        }
        boolean enable_admin = dObj.getBoolean("enable_admin");
        logger.debug("bleOldAdmin-->{}", (Object)enable_admin);
        CacheMrg.putCache(type4HasEnableOldAdmin, key, enable_admin ? "true" : "false");
        return enable_admin;
    }

    @SdkInternal
    public static boolean permResetInitPwd() {
        try (DataSet ds = DB.queryDataSet((String)"PermCommonUtil.permResetInitPwd", (DBRoute)DBRoute.basedata, (String)"select freset from t_perm_resetinitpwd where fid=1");){
            if (ds.hasNext()) {
                Row row = ds.next();
                String freset = row.getString("freset");
                boolean bl = StringUtils.isNotEmpty((String)freset) && Objects.equals(SEQ_FIRST_PERMCTRLFIELD, freset);
                return bl;
            }
        }
        return false;
    }

    @Deprecated
    @SdkInternal
    public static int queryDirectAssignPermSize(Long userId) {
        return DirectAuthorizeHelper.queryDirectAssignPermSize(userId);
    }

    @SdkInternal
    public static String replaceBackSlach(String json) {
        if (json == null) {
            return json;
        }
        while (json.contains("\\\"")) {
            json = json.replaceAll("\\\\\"", "\"");
        }
        return json;
    }

    @SdkInternal
    public static MainEntityType getEntTypeFromTempCacheMap(Map<String, MainEntityType> entityTypeInfoCache, String entNum) {
        MainEntityType tempEntType = entityTypeInfoCache.get(entNum);
        if (tempEntType == null) {
            tempEntType = EntityMetadataCache.getDataEntityType((String)entNum);
            entityTypeInfoCache.put(entNum, tempEntType);
        }
        return tempEntType;
    }

    @SdkInternal
    public static QFilter convertDataRuleResultToQFilter(DataRuleResult drr, long pUserId, String pAppId, String pEntityNum) {
        return PermCommonUtil.convertDataRuleResultToQFilter(drr, pUserId, pAppId, pEntityNum, null);
    }

    @SdkInternal
    public static QFilter convertDataRuleResultToQFilter(DataRuleResult drr, long pUserId, String pAppId, String pEntityNum, String pPropKey) {
        if (drr == null) {
            return null;
        }
        QFilter noResultFilter = drr.getNoResultFilter();
        if (noResultFilter != null) {
            return noResultFilter;
        }
        logger.debug("DataRuleResult\u8f6c\u5316\u4e3aQFilter\u524d\u7684\u5185\u5bb9\uff1a " + SerializationUtils.toJsonString((Object)drr));
        QFilter result = null;
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)pEntityNum);
        String dimObjFieldKey1 = PermCommonUtil.getCheckPermDimObjFieldKey(entityType, SEQ_FIRST_PERMCTRLFIELD);
        String dimObjFieldKey2 = PermCommonUtil.getCheckPermDimObjFieldKey(entityType, SEQ_SEC_PERMCTRLFIELD);
        String orgViewSchemeNum1 = PermCommonUtil.getPermOrgViewScheme(entityType, SEQ_FIRST_PERMCTRLFIELD);
        String orgViewSchemeNum2 = PermCommonUtil.getPermOrgViewScheme(entityType, SEQ_SEC_PERMCTRLFIELD);
        boolean needDimCtrl = drr.isNeedDimCtrl();
        List singleResultList = drr.getSingleResultList();
        if (CollectionUtils.isEmpty((Collection)singleResultList)) {
            return null;
        }
        HashSet allDimObjIds1 = new HashSet(16);
        HashSet allDimObjIds2 = new HashSet(16);
        HashMap subInfo = new HashMap(16);
        long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
        boolean existRootIncludeSubInOneSituation = false;
        for (DataRuleSingleResult drsr : singleResultList) {
            if (drsr == null) continue;
            String ruleJson = drsr.getFilterJson();
            QFilter curRuleFilter = null;
            if (StringUtils.isEmpty((String)ruleJson)) continue;
            if (StringUtils.isNotEmpty((String)ruleJson)) {
                curRuleFilter = PermCommonUtil.getQFilterFromFilterGridJsonStr(pAppId, entityType, ruleJson);
            }
            if (needDimCtrl) {
                boolean existRootOrgIncludeSubOrg = false;
                Map dimObjIncludeSubInfo = drsr.getDimObjIncludeSubInfo();
                HashSet<Long> oneRuleAllDimObjIds1 = new HashSet<Long>(16);
                HashSet<Long> oneRuleAllDimObjIds2 = new HashSet<Long>(16);
                if (!CollectionUtils.isEmpty((Map)dimObjIncludeSubInfo)) {
                    for (Map.Entry entry : dimObjIncludeSubInfo.entrySet()) {
                        Long tempDimObjId = (Long)entry.getKey();
                        if (tempDimObjId == null || tempDimObjId == 0L) continue;
                        Boolean includeSub = (Boolean)entry.getValue();
                        if (includeSub == null) {
                            includeSub = Boolean.FALSE;
                        }
                        if (tempDimObjId == rootOrgId && includeSub.booleanValue()) {
                            existRootOrgIncludeSubOrg = true;
                            break;
                        }
                        if (includeSub.booleanValue()) {
                            String tempDimObjIdView1 = String.valueOf(tempDimObjId) + "_" + orgViewSchemeNum1;
                            HashSet subDimObjIds = (HashSet)subInfo.get(tempDimObjIdView1);
                            if (subDimObjIds == null) {
                                ArrayList<Long> tempDimObjIds = new ArrayList<Long>(10);
                                tempDimObjIds.add(tempDimObjId);
                                ArrayList tempAllSubOrgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((String)orgViewSchemeNum1, tempDimObjIds, (boolean)false, (boolean)true);
                                if (CollectionUtils.isEmpty((Collection)tempAllSubOrgIds)) {
                                    tempAllSubOrgIds = new ArrayList(10);
                                }
                                subDimObjIds = new HashSet(tempAllSubOrgIds);
                                subInfo.put(tempDimObjIdView1, subDimObjIds);
                            }
                            if (subDimObjIds.isEmpty()) {
                                oneRuleAllDimObjIds1.add(tempDimObjId);
                            } else {
                                oneRuleAllDimObjIds1.add(tempDimObjId);
                                oneRuleAllDimObjIds1.addAll(subDimObjIds);
                            }
                            if (!StringUtils.isNotEmpty((String)dimObjFieldKey2)) continue;
                            String tempDimObjIdView2 = String.valueOf(tempDimObjId) + "_" + orgViewSchemeNum2;
                            HashSet subDimObjIds2 = (HashSet)subInfo.get(tempDimObjIdView2);
                            if (subDimObjIds2 == null) {
                                ArrayList<Long> tempDimObjIds = new ArrayList<Long>(10);
                                tempDimObjIds.add(tempDimObjId);
                                ArrayList tempAllSubOrgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((String)orgViewSchemeNum2, tempDimObjIds, (boolean)false, (boolean)true);
                                if (CollectionUtils.isEmpty((Collection)tempAllSubOrgIds)) {
                                    tempAllSubOrgIds = new ArrayList(10);
                                }
                                subDimObjIds2 = new HashSet(tempAllSubOrgIds);
                                subInfo.put(tempDimObjIdView2, subDimObjIds2);
                            }
                            if (subDimObjIds2.isEmpty()) {
                                oneRuleAllDimObjIds2.add(tempDimObjId);
                                continue;
                            }
                            oneRuleAllDimObjIds2.add(tempDimObjId);
                            oneRuleAllDimObjIds2.addAll(subDimObjIds2);
                            continue;
                        }
                        oneRuleAllDimObjIds1.add(tempDimObjId);
                        oneRuleAllDimObjIds2.add(tempDimObjId);
                    }
                }
                QFilter curFilter = null;
                if (existRootOrgIncludeSubOrg) {
                    curFilter = curRuleFilter;
                    existRootIncludeSubInOneSituation = true;
                } else {
                    Long tempDimObjId;
                    QFilter orgFilter = null;
                    String cp1 = "";
                    Object value1 = "";
                    String cp2 = "";
                    Object value2 = "";
                    if (oneRuleAllDimObjIds1.size() > 1) {
                        cp1 = "in";
                        value1 = oneRuleAllDimObjIds1;
                    } else if (oneRuleAllDimObjIds1.size() == 1) {
                        cp1 = "=";
                        tempDimObjId = (Long)oneRuleAllDimObjIds1.iterator().next();
                        value1 = tempDimObjId;
                    }
                    orgFilter = new QFilter(dimObjFieldKey1, cp1, value1);
                    if (StringUtils.isNotEmpty((String)dimObjFieldKey2)) {
                        if (oneRuleAllDimObjIds2.size() > 1) {
                            cp2 = "in";
                            value2 = oneRuleAllDimObjIds2;
                        } else if (oneRuleAllDimObjIds2.size() == 1) {
                            cp2 = "=";
                            tempDimObjId = (Long)oneRuleAllDimObjIds2.iterator().next();
                            value2 = tempDimObjId;
                        }
                        orgFilter = orgFilter.or(new QFilter(dimObjFieldKey2, cp2, value2));
                    }
                    curFilter = curRuleFilter != null ? curRuleFilter.and(orgFilter) : orgFilter;
                }
                result = result == null ? curFilter : result.or(curFilter);
                allDimObjIds1.addAll(oneRuleAllDimObjIds1);
                allDimObjIds2.addAll(oneRuleAllDimObjIds2);
                continue;
            }
            if (result == null) {
                result = curRuleFilter;
                continue;
            }
            result = result.or(curRuleFilter);
        }
        if (needDimCtrl && !existRootIncludeSubInOneSituation && result != null) {
            QFilter orgFilter = new QFilter(dimObjFieldKey1, "not in", allDimObjIds1);
            if (StringUtils.isNotEmpty((String)dimObjFieldKey2)) {
                orgFilter.and(new QFilter(dimObjFieldKey2, "not in", allDimObjIds2));
            }
            result = result.or(orgFilter);
        }
        String qFilterLogInfo = result == null ? "null" : result.toString();
        logger.debug("DataRuleResult\u8f6c\u5316\u4e3aQFilter\u540e\uff1a " + qFilterLogInfo);
        return result;
    }

    @SdkInternal
    public static Map<String, Set<String>> getPropEntNumAndKeysMap(String pEntityNum) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)pEntityNum);
        return PermCommonUtil.getPropEntNumAndKeysMap(entityType);
    }

    @SdkInternal
    public static Map<String, Set<String>> getPropEntNumAndKeysMap(MainEntityType entityType) {
        HashMap<String, Set<String>> propEntNumAndKeysMap = new HashMap<String, Set<String>>(16);
        Map allFields = entityType.getAllFields();
        for (Map.Entry entry : allFields.entrySet()) {
            String propKey = (String)entry.getKey();
            IDataEntityProperty idep = (IDataEntityProperty)entry.getValue();
            if (!(idep instanceof BasedataProp) || idep instanceof BasedataProp && StringUtils.isEmpty((String)idep.getAlias())) continue;
            String propBaseEntNum = ((BasedataProp)idep).getBaseEntityId();
            String parentKeyPrefix = "";
            IDataEntityType parentProp = idep.getParent();
            String parentPropKey = parentProp.getName();
            if (parentProp instanceof EntryType || parentProp instanceof SubEntryType) {
                parentKeyPrefix = parentPropKey + ".";
            }
            propKey = parentKeyPrefix + propKey;
            propEntNumAndKeysMap.computeIfAbsent(propBaseEntNum, k -> new HashSet(16)).add(propKey);
        }
        return propEntNumAndKeysMap;
    }

    @SdkInternal
    public static Map<String, String> getPropKeyAndEntNumMap(String entityName) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName);
        return PermCommonUtil.getPropKeyAndEntNumMap(entityType);
    }

    @SdkInternal
    public static Map<String, String> getPropKeyAndEntNumMap(Map<String, Set<String>> propEntNumAndKeysMap) {
        HashMap<String, String> result = new HashMap<String, String>(16);
        for (Map.Entry<String, Set<String>> entry : propEntNumAndKeysMap.entrySet()) {
            String propEntNum = entry.getKey();
            Set<String> propKeys = entry.getValue();
            for (String propKey : propKeys) {
                result.put(propKey, propEntNum);
            }
        }
        return result;
    }

    @SdkInternal
    public static Map<String, String> getPropKeyAndEntNumMap(MainEntityType entityType) {
        Map<String, Set<String>> propEntNumAndKeysMap = PermCommonUtil.getPropEntNumAndKeysMap(entityType);
        return PermCommonUtil.getPropKeyAndEntNumMap(propEntNumAndKeysMap);
    }

    @Deprecated
    @SdkInternal
    public static void addExtraColumnForTrdBaseData(List<Map<String, Object>> filterColumns, MainEntityType entityType) {
    }

    @Deprecated
    @SdkInternal
    public static void addExtraColumnForTrdBaseData(List<Map<String, Object>> filterColumns, MainEntityType entityType, int recursiveLevel) {
    }

    @SdkInternal
    public static void removeExtraColumn(List<Map<String, Object>> filterColumns, MainEntityType entityType) {
        Map allFields = entityType.getAllFields();
        Iterator<Map<String, Object>> iter = filterColumns.iterator();
        while (iter.hasNext()) {
            String alias;
            IDataEntityProperty dataEntityProperty;
            Map<String, Object> map = iter.next();
            String fieldName = (String)map.get(FIELDNAME);
            if (fieldName.indexOf(46) != -1) {
                fieldName = fieldName.split("\\.")[0];
            }
            if ((dataEntityProperty = (IDataEntityProperty)allFields.get(fieldName)) == null || !StringUtils.isBlank((String)(alias = dataEntityProperty.getAlias()))) continue;
            iter.remove();
        }
    }

    @SdkInternal
    public static String getKmsPublicKey() {
        Object publicKey = PermCommonUtil.getParameterFromCache("kms_public_key");
        return publicKey == null ? StringUtils.getEmpty() : String.valueOf(publicKey);
    }

    @SdkInternal
    public static void saveKmsPublicKey(String publicKey) {
        AppParam appParam = new AppParam();
        appParam.setAppId("83bfebc8000037ac");
        appParam.setViewType("15");
        appParam.setOrgId(Long.valueOf(((IParameterHelperService)ServiceSvcFactory.getService(IParameterHelperService.class)).getParamRootOrgId()));
        appParam.setActBookId(Long.valueOf(0L));
        HashMap<String, String> data = new HashMap<String, String>(1);
        data.put("kms_public_key", publicKey);
        SystemParamServiceHelper.saveAppParameter((AppParam)appParam, data);
    }

    @SdkInternal
    public static Object getParameterFromCache(String key) {
        String cacheKey = String.format("%s%s%s", "getParameterFromCache_", RequestContext.get().getAccountId(), key);
        Map threadCacheMap = (Map)ThreadCache.get((Object)cacheKey, () -> {
            HashMap<String, Object> map = new HashMap<String, Object>(8);
            Object parameterFromCachePri = PermCommonUtil.getParameterFromCachePri(key);
            if (null == parameterFromCachePri) {
                return map;
            }
            map.put("parameterFromCachePri", parameterFromCachePri);
            return map;
        });
        return threadCacheMap.get("parameterFromCachePri");
    }

    @SdkInternal
    private static Object getParameterFromCachePri(String key) {
        AppParam appParam = new AppParam();
        appParam.setAppId("83bfebc8000037ac");
        appParam.setViewType("15");
        appParam.setOrgId(Long.valueOf(((IParameterHelperService)ServiceSvcFactory.getService(IParameterHelperService.class)).getParamRootOrgId()));
        appParam.setActBookId(Long.valueOf(0L));
        Map paramMap = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
        return paramMap == null ? null : paramMap.get(key);
    }

    @SdkInternal
    public static boolean isEnableSingleBizRole() {
        return PermCommonUtil.isEnableSysParam("isenablesinglebizrole");
    }

    @SdkInternal
    public static boolean isEnableJustShowAdminCharged() {
        return PermCommonUtil.isEnableSysParam("enablejustshowchargedorg");
    }

    @SdkInternal
    public static boolean isEnableSysParam(String sysParamKey) {
        Object isEnable = PermCommonUtil.getParameterFromCache(sysParamKey);
        return isEnable != null && Boolean.parseBoolean(isEnable.toString());
    }

    @SdkInternal
    public static boolean isEnableForceUseDataRule() {
        return PermCommonUtil.isEnableSysParam("enableforcedatarule");
    }

    @SdkInternal
    public static boolean isEnableOverAllAutoMatch() {
        return PermCommonUtil.isEnableSysParam("enableautomatch");
    }

    public static boolean isEnableValidateTime() {
        return PermCommonUtil.isEnableSysParam("enablepermvalidatetime");
    }

    @SdkInternal
    public static boolean isEnableNoPermBtnHide() {
        boolean enable = PermCommonUtil.isEnableSysParam("enable_nopermbtnhide");
        return enable;
    }

    public static boolean isEnablePermLog() {
        return PermCommonUtil.isEnableSysParam("enablepermlog");
    }

    public static boolean isEnableAuthorityChangeNotice() {
        return PermCommonUtil.isEnableSysParam("authoritychangenotice");
    }

    @Deprecated
    public static boolean isEnableAllUserAppCheckPermTight() {
        return false;
    }

    @SdkInternal
    public static boolean isEnableSysAuthority() {
        String threadCacheKey = String.format("%s%s", "isEnableSysAuthority_", RequestContext.get().getAccountId());
        return (Boolean)ThreadCache.get((Object)threadCacheKey, () -> PermCommonUtil.isEnableSysAuthorityPri());
    }

    private static boolean isEnableSysAuthorityPri() {
        boolean result = PermCommonUtil.isEnableSysParam("sysauthority");
        try {
            if (!result) {
                boolean initVersion6 = InitailVersionServiceHelper.isInitailVersion((int)6);
                if (initVersion6) {
                    return result;
                }
                String querySql = "select fdata from t_bas_sysparameter  where fparamid in(select fid from t_bas_sysparaconsole tbs where fformid = 'bos_base_parameter' and fappid = '83bfebc8000037ac') and forgid = ? ";
                long rootOrgId = ParameterOrgUtils.getParamRootOrgId();
                String qryResult = (String)DB.query((DBRoute)DBRoute.base, (String)querySql, (Object[])new Object[]{rootOrgId}, (ResultSetHandler)new ResultSetHandler<String>(){

                    public String handle(ResultSet rs) throws SQLException {
                        String dataJson = "";
                        if (rs.next()) {
                            dataJson = rs.getString("fdata");
                        }
                        return dataJson;
                    }
                });
                if (StringUtils.isEmpty((String)qryResult)) {
                    return true;
                }
                Map dataMap = (Map)SerializationUtils.fromJsonString((String)qryResult, Map.class);
                Object sysAuthObj = dataMap.get("sysauthority");
                if (sysAuthObj == null) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
        }
        return result;
    }

    @SdkInternal
    public static int getAdminLevelLimit() {
        int result = 5;
        Object adminLevelLimit = PermCommonUtil.getParameterFromCache("admin_level_limit");
        if (adminLevelLimit != null && (result = ((Integer)adminLevelLimit).intValue()) > 8) {
            result = 8;
        }
        return result;
    }

    @Deprecated
    @SdkInternal
    public static List<String> getOverAllCtrlBdEntNums() {
        ArrayList<String> result = new ArrayList<String>(10);
        Map allEntityInfo = BusinessDataServiceHelper.loadFromCache((String)"perm_overallprop", (String)"entity", null);
        for (DynamicObject dObj : allEntityInfo.values()) {
            String entNum = dObj.getString("entity.id");
            if (!StringUtils.isNotEmpty((String)entNum)) continue;
            result.add(dObj.getString("entity.id"));
        }
        return result;
    }

    @SdkInternal
    public static List<Long> getAllOrgIds() {
        List orgIdList = (List)DB.query((DBRoute)DBRoute.main, (String)"select fid orgId from t_org_org where fenable = '1'", (Object[])new Object[0], (ResultSetHandler)new ResultSetHandler<List<Long>>(){

            public List<Long> handle(ResultSet result) throws SQLException {
                ArrayList<Long> orgIdList = new ArrayList<Long>(10000);
                while (result.next()) {
                    Long orgId = result.getLong("orgId");
                    orgIdList.add(orgId);
                }
                return orgIdList;
            }
        });
        return orgIdList;
    }

    @SdkInternal
    public static Set<Long> getAllLoginUserIds() {
        HashSet<Long> allLoginUserIds = new HashSet<Long>(8);
        String accountId = RequestContext.get().getAccountId();
        String[] parameters = new String[]{"userId"};
        List sessions = SessionQuery.getAllSessions((String)accountId, (String[])parameters);
        for (Map map : sessions) {
            allLoginUserIds.add(Long.valueOf((String)map.get("userId")));
        }
        return allLoginUserIds;
    }

    @SdkInternal
    public static boolean isValidateTimeInput(Date startTime, Date endTime) {
        if (startTime == null || endTime == null) {
            return false;
        }
        return startTime.before(endTime);
    }

    @SdkInternal
    public static boolean isTimeCross(Date startTime1, Date endTime1, Date startTime2, Date endTime2) {
        if (startTime1.before(startTime2) && endTime1.after(startTime2) || startTime1.before(endTime2) && endTime1.after(endTime2)) {
            return true;
        }
        return startTime2.before(startTime1) && endTime2.after(startTime1) || startTime2.before(endTime1) && endTime2.after(endTime1);
    }

    @SdkInternal
    public static Date processDateMilSecPart(Date date) {
        long milliseconds = date.getTime();
        long mod = milliseconds % 1000L;
        if (mod > 500L) {
            date.setTime(milliseconds -= 500L);
        }
        return date;
    }

    public static Map<String, String> getAllEntNumAndNameMap() {
        return FormHelper.getAllEntityNameMap(RequestContext.get().getLang().name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternal
    public static Map<String, PermissionControlType> getPermControlType() {
        try {
            CacheConfigInfo info = new CacheConfigInfo();
            info.setTimeout(86400);
            info.setMaxItemSize(100000);
            Object localCacheV = PermLocalCacheUtil.getLocalCacheByKey("BS_PERM_GETPERMCONTROLTYPE", info);
            if (null == localCacheV) {
                Object object = getPermControlType_objectLock;
                synchronized (object) {
                    localCacheV = PermLocalCacheUtil.getLocalCacheByKey("BS_PERM_GETPERMCONTROLTYPE", info);
                    if (null == localCacheV) {
                        Map<String, PermissionControlType> resultMap = PermCommonUtil.getPermControlType(null);
                        PermLocalCacheUtil.putLocalCache("BS_PERM_GETPERMCONTROLTYPE", resultMap, info);
                        return resultMap;
                    }
                    return (Map)localCacheV;
                }
            }
            return (Map)localCacheV;
        }
        catch (Exception e) {
            logger.debug("PermCommonUtil.getPermControlType() error.", (Object)e);
            return PermCommonUtil.getPermControlType(null);
        }
    }

    @SdkInternal
    public static Map<String, PermissionControlType> getPermControlType(Set<String> entNumSet) {
        long start = System.currentTimeMillis();
        ConcurrentHashMap<String, PermissionControlType> map = new ConcurrentHashMap<String, PermissionControlType>(8);
        ArrayList list = null;
        try {
            StringBuilder sql = new StringBuilder();
            sql.append("select fnumber, fdata from t_meta_entity where fkey = 'CtrlType' and FTYPE = ").append(RuntimeMetaType.PermissionControlType.getValue());
            if (null != entNumSet && !entNumSet.isEmpty()) {
                String entNumSetStr = entNumSet.stream().collect(Collectors.joining("','"));
                sql.append(" and fnumber in ('").append(entNumSetStr).append("') ");
            }
            try (DataSet queryDs = DB.queryDataSet((String)"kd.bos.permission.cache.util.PermCommonUtil.getPermControlType", (DBRoute)DBRoute.meta, (String)sql.toString());){
                HashMap<String, String> oneMap = null;
                if (queryDs.hasNext()) {
                    list = new ArrayList(2560);
                    while (queryDs.hasNext()) {
                        Row row = queryDs.next();
                        oneMap = new HashMap<String, String>(2);
                        String entityNum = row.getString("FNUMBER");
                        String fdata = row.getString("FDATA");
                        oneMap.put("entityNum", entityNum);
                        oneMap.put("fdata", fdata);
                        list.add(oneMap);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.warn("PermCommonUtil-getPermControlType ds error", (Throwable)e);
        }
        try {
            if (!CollectionUtils.isEmpty(list)) {
                PermCommonUtil.getFinalMapAndRebuildEntNumSet(list, map);
            }
        }
        catch (Exception e) {
            logger.warn("PermCommonUtil-getPermControlType error", (Throwable)e);
        }
        logger.debug("\n{}-\u8017\u65f6\uff0c{}ms", (Object)"getPermControlType", (Object)(System.currentTimeMillis() - start));
        return map;
    }

    @SdkInternal
    private static void getFinalMapAndRebuildEntNumSet(List<Map<String, String>> list, Map<String, PermissionControlType> map) throws Exception {
        try {
            int m = SqlUtil.getBatchCount(2000, list.size());
            final CountDownLatch countDownLatch = new CountDownLatch(m);
            LinkedList<Future> futureList = new LinkedList<Future>();
            List<List<Map<String, String>>> listAvg = ListUtil.averageAssign(list, m);
            for (int i = 0; i < listAvg.size(); ++i) {
                final List<Map<String, String>> schemeList = listAvg.get(i);
                futureList.add(pool.submit((Callable)new Callable<Map<String, Object>>(){

                    @Override
                    public Map<String, Object> call() throws Exception {
                        try {
                            HashMap schemeResultMap = new HashMap(2);
                            int schemeSize = schemeList.size();
                            ConcurrentHashMap<String, PermissionControlType> scheme_map = new ConcurrentHashMap<String, PermissionControlType>(schemeSize);
                            PermissionControlType pct = null;
                            for (Map schemeMap : schemeList) {
                                String entityNum = (String)schemeMap.get("entityNum");
                                String fdata = (String)schemeMap.get("fdata");
                                if (!StringUtils.isNotEmpty((String)fdata)) continue;
                                pct = (PermissionControlType)SerializationUtils.fromJsonString((String)fdata, PermissionControlType.class);
                                scheme_map.put(entityNum, pct);
                            }
                            schemeResultMap.put("scheme_map", scheme_map);
                            HashMap hashMap = schemeResultMap;
                            return hashMap;
                        }
                        catch (Exception e) {
                            logger.warn("PermCommonUtil.getFinalMapAndRebuildEntNumSet.call error.", (Throwable)e);
                            throw new Exception("PermCommonUtil.getFinalMapAndRebuildEntNumSet.call error.");
                        }
                        finally {
                            if (null != countDownLatch) {
                                countDownLatch.countDown();
                            }
                        }
                    }
                }));
            }
            countDownLatch.await();
            for (Future listFuture : futureList) {
                Map part = (Map)listFuture.get();
                Map scheme_map = (Map)part.get("scheme_map");
                map.putAll(scheme_map);
            }
        }
        catch (Exception e) {
            logger.warn("PermCommonUtil.getFinalMapAndRebuildEntNumSet error", (Throwable)e);
        }
    }

    @SdkInternal
    public static Map<String, String> getPermControlTypeStrMap(Set<String> entNumSet) {
        return new HashMap<String, String>(1);
    }

    public static void ifCtrlAndMatchDim(String dimension, Map<String, String> ifControlMap) {
        if (StringUtils.isNotEmpty((String)ifControlMap.get(FLAG_HASLOADEDFROMCACHE))) {
            return;
        }
        Map<String, PermissionControlType> permControlTypeMap = PermCommonUtil.getPermControlType();
        for (Map.Entry<String, PermissionControlType> entry : permControlTypeMap.entrySet()) {
            String entityNum = entry.getKey();
            PermissionControlType permControl = entry.getValue();
            if (permControl.isEmptyObject()) {
                ifControlMap.put(entityNum, "false");
                continue;
            }
            String ifControl = ifControlMap.get(entityNum);
            if (!StringUtils.isEmpty((String)ifControl)) continue;
            ifControlMap.put(entityNum, "true");
            boolean isCtrlFunction = permControl.isControlFunction();
            String curDim = permControl.getDimension();
            if (StringUtils.isEmpty((String)curDim) || "DIM_NULL".equals(curDim)) {
                curDim = "DIM_ORG";
            }
            if (StringUtils.isEmpty((String)dimension)) {
                ifControlMap.put(entityNum, "false");
                continue;
            }
            if (isCtrlFunction && ("DIM_NULL".equals(curDim) || curDim.equals(dimension))) continue;
            ifControlMap.put(entityNum, "false");
        }
    }

    @SdkInternal
    public static Map<String, Boolean> getEntityCtrlMap(String dimension) {
        Map<String, PermissionControlType> permControlTypeMap = PermCommonUtil.getPermControlType();
        if (CollectionUtils.isEmpty(permControlTypeMap)) {
            return new HashMap<String, Boolean>(1);
        }
        HashMap<String, Boolean> map = new HashMap<String, Boolean>(permControlTypeMap.size());
        for (Map.Entry<String, PermissionControlType> entry : permControlTypeMap.entrySet()) {
            String entityNum = entry.getKey();
            map.put(entityNum, Boolean.TRUE);
            PermissionControlType permControl = entry.getValue();
            if (permControl.isEmptyObject()) {
                map.put(entityNum, Boolean.FALSE);
                continue;
            }
            String curDim = permControl.getDimension();
            if (StringUtils.isEmpty((String)curDim) || "DIM_NULL".equals(curDim)) {
                curDim = "DIM_ORG";
            }
            if (StringUtils.isEmpty((String)dimension)) {
                map.put(entityNum, Boolean.FALSE);
                continue;
            }
            boolean isCtrlFunction = permControl.isControlFunction();
            if (isCtrlFunction && ("DIM_NULL".equals(curDim) || curDim.equals(dimension))) continue;
            map.put(entityNum, Boolean.FALSE);
        }
        return map;
    }

    @SdkInternal
    public static void isControlPerm(Map<String, String> ifControlMap) {
        if (StringUtils.isNotEmpty((String)ifControlMap.get(FLAG_HASLOADEDFROMCACHE))) {
            return;
        }
        Map<String, PermissionControlType> permControlTypeMap = PermCommonUtil.getPermControlType();
        for (Map.Entry<String, PermissionControlType> entry : permControlTypeMap.entrySet()) {
            String entityNum = entry.getKey();
            PermissionControlType permControl = entry.getValue();
            if (permControl.isEmptyObject()) {
                ifControlMap.put(entityNum, "false");
                continue;
            }
            String ifControl = ifControlMap.get(entityNum);
            if (!StringUtils.isEmpty((String)ifControl)) continue;
            ifControlMap.put(entityNum, "true");
            boolean isCtrlFunction = permControl.isControlFunction();
            if (isCtrlFunction) continue;
            ifControlMap.put(entityNum, "false");
        }
    }

    @SdkInternal
    public static void getFormShowOnTreeStatusMap(Map<String, Object> formShowOnTreeStatusParaMap, Map<String, String> formShowOnTreeStatusMap) {
        PermCommonUtil.getFormShowOnTreeStatusMap(formShowOnTreeStatusParaMap, formShowOnTreeStatusMap, null);
    }

    @SdkInternal
    public static void getFormShowOnTreeStatusMap(Map<String, Object> formShowOnTreeStatusParaMap, Map<String, String> formShowOnTreeStatusMap, Map<String, Boolean> entForbidDataPermTreeMap) {
        if (StringUtils.isNotEmpty((String)formShowOnTreeStatusMap.get(FLAG_HASLOADEDFROMCACHE))) {
            return;
        }
        String dimension = (String)formShowOnTreeStatusParaMap.get("dimension");
        String dimDiffHide = null == formShowOnTreeStatusParaMap.get("dimDiffHide") ? "0" : (String)formShowOnTreeStatusParaMap.get("dimDiffHide");
        String curDimNullShow = null == formShowOnTreeStatusParaMap.get("curDimNullShow") ? SEQ_FIRST_PERMCTRLFIELD : (String)formShowOnTreeStatusParaMap.get("curDimNullShow");
        Set<String> permCtrlTypeNumberSet = null == formShowOnTreeStatusParaMap.get("permCtrlTypeNumberSet") ? IsoDimHelper.getPermCtrlTypeNumberSet(Sets.newHashSet((Object[])new String[]{SEQ_FIRST_PERMCTRLFIELD}), null) : (Set<String>)formShowOnTreeStatusParaMap.get("permCtrlTypeNumberSet");
        Map<String, PermissionControlType> permControlTypeMap = PermCommonUtil.getPermControlType();
        GetTreeShowFormCtrlTypeResp treeShowFormCtrlTypeResp = PermCommonUtil.getTreeShowFormCtrlType(dimension);
        Set treeShowFormCtrlTypeSet = treeShowFormCtrlTypeResp.getDimTypeSet();
        for (Map.Entry<String, PermissionControlType> entry : permControlTypeMap.entrySet()) {
            String entityNum = entry.getKey();
            PermissionControlType permControl = entry.getValue();
            String formShowOnTreeStatus = PermCommonUtil.getFormShowOnTreeStatus(entityNum, permControl, dimension, dimDiffHide, curDimNullShow, permCtrlTypeNumberSet, entForbidDataPermTreeMap, treeShowFormCtrlTypeSet);
            formShowOnTreeStatusMap.put(entityNum, formShowOnTreeStatus);
        }
    }

    private static GetTreeShowFormCtrlTypeResp getTreeShowFormCtrlType(String dimension) {
        try {
            PluginProxy pluginProxy = PluginProxy.create(null, IPermCtrlTypeExt.class, (String)"kd.bos.permission.api.ext.IPermCtrlTypeExt", null);
            PluginCall call = p -> {
                if (p != null) {
                    Set extIdentitySet = p.getExtIdentitySet();
                    if (StringUtils.isNotEmpty((String)dimension) && null != extIdentitySet && extIdentitySet.contains(dimension)) {
                        GetTreeShowFormCtrlTypeReq req = new GetTreeShowFormCtrlTypeReq(dimension);
                        return p.getTreeShowFormCtrlType(req);
                    }
                }
                return null;
            };
            List pluginResults = pluginProxy.callReplaceIfPresent(call);
            if (null != pluginResults && !pluginResults.isEmpty()) {
                pluginResults.removeIf(x -> null == x);
                if (null != pluginResults && !pluginResults.isEmpty()) {
                    return (GetTreeShowFormCtrlTypeResp)pluginResults.get(0);
                }
            }
        }
        catch (Exception e) {
            logger.warn("PermCommonUtil.getTreeShowFormCtrlType error.", (Throwable)e);
        }
        return new GetTreeShowFormCtrlTypeResp(null);
    }

    @SdkInternal
    private static String getFormShowOnTreeStatus(String formNum, PermissionControlType permControl, String dimension, String dimDiffHide, String curDimNullShow, Set<String> permCtrlTypeNumberSet, Map<String, Boolean> entForbidDataPermTreeMap, Set<String> treeShowFormCtrlTypeSet) {
        if (null != entForbidDataPermTreeMap) {
            entForbidDataPermTreeMap.put(formNum, permControl.isForbidDataPerm());
        }
        if (StringUtils.isEmpty((String)dimension)) {
            return "false";
        }
        if (permControl.isEmptyObject()) {
            return "false";
        }
        boolean isCtrlFunction = permControl.isControlFunction();
        if (!isCtrlFunction) {
            return "false";
        }
        String curDim = permControl.getDimension();
        if (StringUtils.isEmpty((String)curDim)) {
            return "true";
        }
        if (permCtrlTypeNumberSet != null && permCtrlTypeNumberSet.contains(curDim)) {
            if (Objects.equals(SEQ_FIRST_PERMCTRLFIELD, curDimNullShow) && "DIM_NULL".equals(curDim)) {
                return "true";
            }
            if (Objects.equals("0", curDimNullShow) && "DIM_NULL".equals(curDim)) {
                return "false";
            }
            if (Objects.equals(SEQ_FIRST_PERMCTRLFIELD, dimDiffHide) && !curDim.equals(dimension)) {
                return "false";
            }
        } else {
            if (null != treeShowFormCtrlTypeSet && !treeShowFormCtrlTypeSet.contains(curDim)) {
                return "false";
            }
            if ("DIM_NULL".equals(curDim)) {
                return "false";
            }
            if (!curDim.equals(dimension)) {
                return "false";
            }
        }
        return "true";
    }

    public static void showMesIfUserIsNotAdmin(PreOpenFormEventArgs e) {
        boolean isCosmic;
        long userId = RequestContext.get().getCurrUserId();
        boolean isAdmin = PermissionServiceHelper.isAdminUser((long)userId);
        if (!isAdmin & !(isCosmic = PermCommonUtil.isCosmicUser(userId))) {
            e.setCancel(true);
            e.setCancelMessage(ConstantsHelper.getAdminCannotUseDesc());
        }
    }

    @SdkInternal
    public static boolean checkPermInAllUserApp(String appId, String entityNum) {
        Map<String, List<String>> checkPermAllUserAppEntMap;
        List<String> checkPermEntNums;
        boolean isAllUserApp = false;
        if (StringUtils.isEmpty((String)appId)) {
            appId = BizAppServiceHelp.getAppIdByFormNum((String)entityNum);
        }
        try {
            AppInfo appInfo = AppHelper.getMetaAppInfo(appId);
            isAllUserApp = appInfo.isAllUserApp();
        }
        catch (Exception e) {
            isAllUserApp = BizAppServiceHelp.isAllUserApp((String)appId);
        }
        return isAllUserApp && ((checkPermEntNums = (checkPermAllUserAppEntMap = PermCommonUtil.getCheckPermAllUserAppEntMap()).get(appId)) == null || checkPermEntNums.isEmpty() || !checkPermEntNums.contains(entityNum));
    }

    @SdkInternal
    public static boolean isValidPermItemId(String permItemId) {
        boolean result;
        DynamicObject permItemObj = null;
        try {
            permItemObj = BusinessDataServiceHelper.loadSingleFromCache((Object)permItemId, (String)"perm_permitem");
        }
        catch (Exception e) {
            logger.warn("PermCommonUtil.isValidPermItemId() occur Exception!", (Throwable)e);
            return false;
        }
        boolean bl = result = permItemObj != null;
        if (!result) {
            logger.warn("PermCommonUtil.isValidPermItemId(): permItemId is not valid !");
        }
        return result;
    }

    @SdkInternal
    @Deprecated
    public static Map<String, Map<String, List<String>>> getImplCfgCtrlAppList() {
        Map result = null;
        CustomPermServInfo custPermServInfo = CustomPermServInfo.getCustPermServInfo(1L);
        if (custPermServInfo == null) {
            return null;
        }
        String servAppNum = custPermServInfo.getServAppNum();
        String servFactory = custPermServInfo.getServiceFactory();
        String servName = custPermServInfo.getServiceName();
        String methodName = custPermServInfo.getMethodName();
        Object customResult = null;
        try {
            DispatchService service = (DispatchService)ServiceLookup.lookup(DispatchService.class, (String)servAppNum);
            customResult = service.invoke(servFactory, servName, methodName, new Object[0]);
            result = (Map)customResult;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    @Deprecated
    @SdkInternal
    public static Map<String, Object> getImpleConfigBlack() {
        HashMap<String, Object> blackMap = new HashMap<String, Object>();
        return blackMap;
    }

    @SdkInternal
    public static String getInSqlExprByStrParam(List<String> params) {
        if (!CollectionUtils.isEmpty(params)) {
            StringBuilder sb = new StringBuilder();
            for (String param : params) {
                sb.append('\'').append(param).append('\'').append(',');
            }
            if (sb.length() > 1) {
                sb.deleteCharAt(sb.length() - 1);
            }
            return sb.toString();
        }
        return "";
    }

    @SdkInternal
    public static List<String> getCheckPermAllUserAppIdList() {
        List<String> result = new ArrayList<String>(8);
        try {
            String sql = "select distinct fappid from t_perm_alluserappent";
            result = (List)DB.query((DBRoute)DBRoute.permission, (String)sql, rs -> {
                ArrayList<String> resultList = new ArrayList<String>(16);
                while (rs.next()) {
                    resultList.add(rs.getString("fappid"));
                }
                return resultList;
            });
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
        }
        return result;
    }

    @SdkInternal
    public static Set<String> getCheckPermAllUserEntNumSet() {
        Set<String> result = new HashSet<String>(8);
        try {
            String sql = "select distinct fentitynum from t_perm_alluserappent";
            result = (Set)DB.query((DBRoute)DBRoute.permission, (String)sql, rs -> {
                HashSet<String> set = new HashSet<String>(8);
                while (rs.next()) {
                    set.add(rs.getString("fentitynum"));
                }
                return set;
            });
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
        }
        return result;
    }

    @SdkInternal
    public static Map<String, List<String>> getCheckPermAllUserAppEntMap() {
        HashMap<String, List<String>> resultList = new HashMap<String, List<String>>(8);
        try {
            Map allUserAppEntMap = BusinessDataServiceHelper.loadFromCache((String)"perm_alluserappent", null);
            for (DynamicObject dObj : allUserAppEntMap.values()) {
                String entityNum;
                String appId;
                if (dObj == null || StringUtils.isEmpty((String)(appId = dObj.getString("app_id"))) || StringUtils.isEmpty((String)(entityNum = dObj.getString("entity_id")))) continue;
                resultList.computeIfAbsent(appId, k -> new ArrayList()).add(entityNum);
            }
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
        }
        return resultList;
    }

    @SdkInternal
    public static boolean isSingleOrg() {
        ILicenseService licenseService = (ILicenseService)ServiceFactory.getService(ILicenseService.class);
        return licenseService.isSingleOrgManageMode();
    }

    @SdkInternal
    public static List<String> getFieldKeysFromStdBlackList(String formNum) {
        ProductSettingService service = (ProductSettingService)ServiceFactory.getService(ProductSettingService.class);
        List fieldKeys = service.getFormDisVisitField(formNum);
        return fieldKeys;
    }

    public static boolean isGalaxyProduct() {
        ILicenseService licenseService = (ILicenseService)ServiceFactory.getService(ILicenseService.class);
        int modelType = licenseService.getModeType();
        boolean isGalaxyMode = modelType == 2 || modelType == 4;
        return isGalaxyMode;
    }

    @SdkInternal
    public static boolean isEnableProductSetting() {
        ILicenseService licenseService = (ILicenseService)ServiceFactory.getService(ILicenseService.class);
        int modelType = licenseService.getModeType();
        boolean result = modelType != 3;
        return result;
    }

    @Deprecated
    @SdkInternal
    public static void addLog(String opName, String opDescription, String bizObjID, Date operationTime) {
        PermCommonUtil.addLog(opName, opDescription, bizObjID, operationTime, RequestContext.get().getLoginIP());
    }

    @Deprecated
    @SdkInternal
    public static void addLog(String opName, String opDescription, String bizObjID, Date operationTime, String ip) {
        PermCommonUtil.addLog(opName, opDescription, bizObjID, operationTime, ip, "");
    }

    @Deprecated
    @SdkInternal
    public static void addLog(String opKey, String opDescription, String bizObjID, Date operationTime, String ip, String appNum) {
        PermCommonUtil.addLog(opKey, null, bizObjID, null, null, null, null, null, null, opDescription, operationTime, ip, appNum);
    }

    @SdkInternal
    public static void addLog(String opKey, String opNameZh_CN, String bizObjID, String modifyBillNo, String status, String btnKey, MultiLangEnumBridge btnOpMultiLangEnumBridge, MultiLangEnumBridge opDescLangEnumBridge, String[] opDescParam, String oldOpDescription, Date operationTime, String ip, String appNum) {
        OpLogAppInfo info = new OpLogAppInfo();
        info.setUserID(Long.valueOf(RequestContext.get().getCurrUserId()));
        info.setOrgID(Long.valueOf(RequestContext.get().getOrgId()));
        String clientType = RequestContext.get().getClient();
        clientType = StringUtils.isEmpty((String)clientType) ? "web" : clientType;
        clientType = Objects.equals("batch", clientType) ? "web" : clientType;
        info.setClientType(clientType);
        info.setClientIP(StringUtils.isEmpty((String)ip) ? RequestContext.get().getLoginIP() : ip);
        info.setBizObjID(bizObjID);
        String appId = "";
        if (StringUtils.isNotEmpty((String)appNum)) {
            appId = AppHelper.getCurAppId(bizObjID, appNum);
        }
        appId = StringUtils.isEmpty((String)appId) ? BizAppServiceHelp.getAppIdByFormNum((String)bizObjID) : appId;
        info.setBizAppID(appId);
        info.setOpDescription(oldOpDescription);
        if (operationTime == null) {
            info.setOpTime(TimeServiceHelper.now());
        } else {
            info.setOpTime(operationTime);
        }
        String opName = "";
        if (StringUtils.isNotEmpty((String)opNameZh_CN) && StringUtils.isNotEmpty((String)opKey)) {
            opName = opNameZh_CN;
        } else if (StringUtils.isEmpty((String)opNameZh_CN) && StringUtils.isNotEmpty((String)opKey)) {
            Map<String, String> operationInfoMap = OperationHelper.getOperationInfoMap(bizObjID);
            opName = operationInfoMap.get(opKey);
        }
        if (StringUtils.isNotEmpty((String)opKey) && StringUtils.isNotEmpty((String)opName)) {
            info.setOpName(opKey, opName);
        } else if (StringUtils.isNotEmpty((String)btnKey) && null != btnOpMultiLangEnumBridge) {
            info.setOpName(btnKey, btnOpMultiLangEnumBridge);
        }
        if (StringUtils.isNotEmpty((String)status)) {
            info.setStatus(status);
        }
        if (StringUtils.isNotEmpty((String)modifyBillNo)) {
            info.setKeyWord(modifyBillNo);
        }
        if (null != opDescLangEnumBridge && null != opDescParam) {
            info.setOpDesc(opDescLangEnumBridge, opDescParam);
        }
        LogServiceHelper.addLog((AppLogInfo)info);
    }

    @SdkInternal
    public static Map<String, String> getEntityUserFieldMap(String entityNum) {
        HashMap<String, String> result = new HashMap<String, String>(16);
        if (StringUtils.isEmpty((String)entityNum)) {
            return result;
        }
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNum);
        DataEntityPropertyCollection properties = mainEntityType.getProperties();
        for (IDataEntityProperty property : properties) {
            BasedataProp prop;
            if (property instanceof BasedataProp) {
                prop = (BasedataProp)property;
                String baseEntityId = prop.getBaseEntityId();
                if (!"bos_user".equals(baseEntityId)) continue;
                String fieldNum = property.getName();
                String fieldName = property.getDisplayName().getLocaleValue();
                result.put(fieldNum, fieldName);
                continue;
            }
            if (!(property instanceof EntryProp)) continue;
            prop = (EntryProp)property;
            String entryNum = prop.getName();
            String entryName = prop.getDisplayName().getLocaleValue();
            DataEntityPropertyCollection entryProperties = prop.getItemType().getProperties();
            for (IDataEntityProperty entryProperty : entryProperties) {
                BasedataProp entryProp;
                String baseEntityId;
                if (!(entryProperty instanceof BasedataProp) || !"bos_user".equals(baseEntityId = (entryProp = (BasedataProp)entryProperty).getBaseEntityId())) continue;
                String fieldNum = entryNum + "." + entryProperty.getName();
                String fieldName = entryName + "." + entryProperty.getDisplayName().getLocaleValue();
                result.put(fieldNum, fieldName);
            }
        }
        result.put("id", ResManager.loadKDString((String)"\u5355\u636e\u672c\u8eab", (String)"PermCommonUtil_3", (String)"bos-permission-cache", (Object[])new Object[0]));
        return result;
    }

    @SdkInternal
    public static Set<String> getEntityBaseDataType(List<String> entityNums) {
        HashSet<String> baseDataTypes = new HashSet<String>(16);
        if (CollectionUtils.isEmpty(entityNums)) {
            return baseDataTypes;
        }
        for (String entityNum : entityNums) {
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNum);
            DataEntityPropertyCollection properties = mainEntityType.getProperties();
            for (IDataEntityProperty property : properties) {
                BasedataProp prop;
                if (property instanceof BasedataProp) {
                    prop = (BasedataProp)property;
                    String baseEntityId = prop.getBaseEntityId();
                    MainEntityType baseEntityType = EntityMetadataCache.getDataEntityType((String)baseEntityId);
                    int dbType = baseEntityType.getPrimaryKey().getDbType();
                    if (dbType != -5) continue;
                    baseDataTypes.add(baseEntityId);
                    continue;
                }
                if (!(property instanceof EntryProp)) continue;
                prop = (EntryProp)property;
                DataEntityPropertyCollection entryProperties = prop.getItemType().getProperties();
                for (IDataEntityProperty entryProperty : entryProperties) {
                    BasedataProp entryProp;
                    String baseEntityId;
                    MainEntityType baseEntityType;
                    int dbType;
                    if (!(entryProperty instanceof BasedataProp) || (dbType = (baseEntityType = EntityMetadataCache.getDataEntityType((String)(baseEntityId = (entryProp = (BasedataProp)entryProperty).getBaseEntityId()))).getPrimaryKey().getDbType()) != -5) continue;
                    baseDataTypes.add(baseEntityId);
                }
            }
        }
        baseDataTypes.addAll(entityNums);
        return baseDataTypes;
    }

    @SdkInternal
    public static Map<String, String> getEntityBaseDataField(String entityNum) {
        HashMap<String, String> result = new HashMap<String, String>(16);
        if (StringUtils.isEmpty((String)entityNum)) {
            return result;
        }
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNum);
        DataEntityPropertyCollection properties = mainEntityType.getProperties();
        for (IDataEntityProperty property : properties) {
            BasedataProp prop;
            if (property instanceof BasedataProp) {
                prop = (BasedataProp)property;
                String fieldNum = property.getName();
                String fieldName = property.getDisplayName().getLocaleValue();
                result.put(fieldNum, fieldName);
                continue;
            }
            if (!(property instanceof EntryProp)) continue;
            prop = (EntryProp)property;
            String entryNum = prop.getName();
            String entryName = prop.getDisplayName().getLocaleValue();
            DataEntityPropertyCollection entryProperties = prop.getItemType().getProperties();
            for (IDataEntityProperty entryProperty : entryProperties) {
                if (!(entryProperty instanceof BasedataProp)) continue;
                BasedataProp entryProp = (BasedataProp)entryProperty;
                String fieldNum = entryNum + "." + entryProperty.getName();
                String fieldName = entryName + "." + entryProperty.getDisplayName().getLocaleValue();
                result.put(fieldNum, fieldName);
            }
        }
        result.put("id", ResManager.loadKDString((String)"\u5355\u636e\u672c\u8eab", (String)"PermCommonUtil_3", (String)"bos-permission-cache", (Object[])new Object[0]));
        return result;
    }

    @SdkInternal
    public static List<String[]> getEntityBaseDataFieldInfo(String entityNum) {
        ArrayList<String[]> result = new ArrayList<String[]>(10);
        if (StringUtils.isEmpty((String)entityNum)) {
            return result;
        }
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNum);
        DataEntityPropertyCollection properties = mainEntityType.getProperties();
        for (IDataEntityProperty property : properties) {
            String baseEntityId;
            BasedataProp prop;
            if (property instanceof BasedataProp) {
                prop = (BasedataProp)property;
                baseEntityId = prop.getBaseEntityId();
                MainEntityType baseEntityType = EntityMetadataCache.getDataEntityType((String)baseEntityId);
                int dbType = baseEntityType.getPrimaryKey().getDbType();
                if (dbType != -5) continue;
                String fieldNum = property.getName();
                String fieldName = property.getDisplayName().getLocaleValue();
                result.add(new String[]{fieldNum, fieldName, baseEntityId});
                continue;
            }
            if (!(property instanceof EntryProp)) continue;
            prop = (EntryProp)property;
            String entryNum = prop.getName();
            String entryName = prop.getDisplayName().getLocaleValue();
            DataEntityPropertyCollection entryProperties = prop.getItemType().getProperties();
            for (IDataEntityProperty entryProperty : entryProperties) {
                BasedataProp entryProp;
                MainEntityType baseEntityType;
                int dbType;
                if (!(entryProperty instanceof BasedataProp) || (dbType = (baseEntityType = EntityMetadataCache.getDataEntityType((String)(baseEntityId = (entryProp = (BasedataProp)entryProperty).getBaseEntityId()))).getPrimaryKey().getDbType()) != -5) continue;
                String fieldNum = entryNum + "." + entryProperty.getName();
                String fieldName = entryName + "." + entryProperty.getDisplayName().getLocaleValue();
                result.add(new String[]{fieldNum, fieldName, baseEntityId});
            }
        }
        return result;
    }

    @SdkInternal
    public static String convertDataRuleResultToScript(DataRuleResult drr, long pUserId, String pAppId, String pEntityNum) {
        if (drr == null) {
            return null;
        }
        logger.debug("DataRuleResult\u8f6c\u5316\u4e3aScript\u524d\u7684\u5185\u5bb9\uff1a " + SerializationUtils.toJsonString((Object)drr));
        String resultScript = null;
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)pEntityNum);
        String dimObjFieldKey1 = PermCommonUtil.getCheckPermDimObjFieldKey(entityType, SEQ_FIRST_PERMCTRLFIELD);
        String dimObjFieldKey2 = PermCommonUtil.getCheckPermDimObjFieldKey(entityType, SEQ_SEC_PERMCTRLFIELD);
        String orgViewSchemeNum1 = PermCommonUtil.getPermOrgViewScheme(entityType, SEQ_FIRST_PERMCTRLFIELD);
        String orgViewSchemeNum2 = PermCommonUtil.getPermOrgViewScheme(entityType, SEQ_SEC_PERMCTRLFIELD);
        boolean needDimCtrl = drr.isNeedDimCtrl();
        List singleResultList = drr.getSingleResultList();
        if (CollectionUtils.isEmpty((Collection)singleResultList)) {
            return null;
        }
        HashSet allDimObjIds1 = new HashSet(16);
        HashSet allDimObjIds2 = new HashSet(16);
        HashMap subInfo = new HashMap(16);
        long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
        boolean existRootIncludeSubInOneSituation = false;
        for (DataRuleSingleResult drsr : singleResultList) {
            if (drsr == null) continue;
            String ruleJson = drsr.getFilterJson();
            String curRuleScript = null;
            if (StringUtils.isEmpty((String)ruleJson)) continue;
            if (StringUtils.isNotEmpty((String)ruleJson)) {
                curRuleScript = PermCommonUtil.getDataRuleScriptFromJson(pAppId, entityType, ruleJson);
            }
            if (needDimCtrl) {
                Long tempDimObjId;
                boolean existRootOrgIncludeSubOrg = false;
                Map dimObjIncludeSubInfo = drsr.getDimObjIncludeSubInfo();
                HashSet<Long> oneRuleAllDimObjIds1 = new HashSet<Long>(16);
                HashSet<Long> oneRuleAllDimObjIds2 = new HashSet<Long>(16);
                if (!CollectionUtils.isEmpty((Map)dimObjIncludeSubInfo)) {
                    for (Map.Entry entry : dimObjIncludeSubInfo.entrySet()) {
                        tempDimObjId = (Long)entry.getKey();
                        if (tempDimObjId == null || tempDimObjId == 0L) continue;
                        Boolean includeSub = (Boolean)entry.getValue();
                        if (includeSub == null) {
                            includeSub = Boolean.FALSE;
                        }
                        if (tempDimObjId == rootOrgId && includeSub.booleanValue()) {
                            existRootOrgIncludeSubOrg = true;
                            break;
                        }
                        if (includeSub.booleanValue()) {
                            String tempDimObjIdView1 = String.valueOf(tempDimObjId) + "_" + orgViewSchemeNum1;
                            HashSet subDimObjIds = (HashSet)subInfo.get(tempDimObjIdView1);
                            if (subDimObjIds == null) {
                                ArrayList<Long> tempDimObjIds = new ArrayList<Long>(10);
                                tempDimObjIds.add(tempDimObjId);
                                ArrayList tempAllSubOrgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((String)orgViewSchemeNum1, tempDimObjIds, (boolean)false, (boolean)true);
                                if (CollectionUtils.isEmpty((Collection)tempAllSubOrgIds)) {
                                    tempAllSubOrgIds = new ArrayList(10);
                                }
                                subDimObjIds = new HashSet(tempAllSubOrgIds);
                                subInfo.put(tempDimObjIdView1, subDimObjIds);
                            }
                            if (subDimObjIds.isEmpty()) {
                                oneRuleAllDimObjIds1.add(tempDimObjId);
                            } else {
                                oneRuleAllDimObjIds1.add(tempDimObjId);
                                oneRuleAllDimObjIds1.addAll(subDimObjIds);
                            }
                            if (!StringUtils.isNotEmpty((String)dimObjFieldKey2)) continue;
                            String tempDimObjIdView2 = String.valueOf(tempDimObjId) + "_" + orgViewSchemeNum2;
                            HashSet subDimObjIds2 = (HashSet)subInfo.get(tempDimObjIdView2);
                            if (subDimObjIds2 == null) {
                                ArrayList<Long> tempDimObjIds = new ArrayList<Long>(10);
                                tempDimObjIds.add(tempDimObjId);
                                ArrayList tempAllSubOrgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((String)orgViewSchemeNum2, tempDimObjIds, (boolean)false, (boolean)true);
                                if (CollectionUtils.isEmpty((Collection)tempAllSubOrgIds)) {
                                    tempAllSubOrgIds = new ArrayList(10);
                                }
                                subDimObjIds2 = new HashSet(tempAllSubOrgIds);
                                subInfo.put(tempDimObjIdView2, subDimObjIds2);
                            }
                            if (subDimObjIds2.isEmpty()) {
                                oneRuleAllDimObjIds2.add(tempDimObjId);
                                continue;
                            }
                            oneRuleAllDimObjIds2.add(tempDimObjId);
                            oneRuleAllDimObjIds2.addAll(subDimObjIds2);
                            continue;
                        }
                        oneRuleAllDimObjIds1.add(tempDimObjId);
                        oneRuleAllDimObjIds2.add(tempDimObjId);
                    }
                }
                String curScript = " 1=1 ";
                if (existRootOrgIncludeSubOrg) {
                    curScript = curRuleScript;
                    existRootIncludeSubInOneSituation = true;
                } else {
                    String orgFilterScript = null;
                    if (oneRuleAllDimObjIds1.size() > 1) {
                        Set strOneRuleAllDimObjId1s = oneRuleAllDimObjIds1.stream().map(String::valueOf).collect(Collectors.toSet());
                        String oneRuleAllDimObjIds1Str = String.join((CharSequence)",", strOneRuleAllDimObjId1s);
                        orgFilterScript = dimObjFieldKey1 + ".id" + " in (" + oneRuleAllDimObjIds1Str + ") ";
                    } else if (oneRuleAllDimObjIds1.size() == 1) {
                        tempDimObjId = (Long)oneRuleAllDimObjIds1.iterator().next();
                        orgFilterScript = dimObjFieldKey1 + ".id" + " = " + tempDimObjId;
                    }
                    if (StringUtils.isNotEmpty((String)dimObjFieldKey2)) {
                        if (oneRuleAllDimObjIds2.size() > 1) {
                            Set strOneRuleAllDimObjId2s = oneRuleAllDimObjIds2.stream().map(String::valueOf).collect(Collectors.toSet());
                            String oneRuleAllDimObjIds2Str = String.join((CharSequence)",", strOneRuleAllDimObjId2s);
                            orgFilterScript = orgFilterScript + " or (" + dimObjFieldKey2 + ".id" + " in (" + oneRuleAllDimObjIds2Str + ")) ";
                        } else if (oneRuleAllDimObjIds2.size() == 1) {
                            tempDimObjId = (Long)oneRuleAllDimObjIds2.iterator().next();
                            orgFilterScript = orgFilterScript + " or (" + dimObjFieldKey2 + ".id" + " = " + tempDimObjId + ") ";
                        }
                    }
                    curScript = StringUtils.isNotEmpty((String)curRuleScript) ? curRuleScript + " and (" + orgFilterScript + ')' : orgFilterScript;
                }
                resultScript = StringUtils.isEmpty((String)resultScript) ? curScript : "(" + resultScript + ") or (" + curScript + ')';
                allDimObjIds1.addAll(oneRuleAllDimObjIds1);
                allDimObjIds2.addAll(oneRuleAllDimObjIds2);
                continue;
            }
            if (StringUtils.isEmpty(resultScript)) {
                resultScript = curRuleScript;
                continue;
            }
            resultScript = resultScript + " or (" + curRuleScript + ')';
        }
        if (needDimCtrl && !existRootIncludeSubInOneSituation && StringUtils.isNotEmpty(resultScript)) {
            Set strAllDimObjIds1 = allDimObjIds1.stream().map(String::valueOf).collect(Collectors.toSet());
            String allDimObjIds1Str = String.join((CharSequence)",", strAllDimObjIds1);
            Set strAllDimObjIds2 = allDimObjIds2.stream().map(String::valueOf).collect(Collectors.toSet());
            String allDimObjIds2Str = String.join((CharSequence)",", strAllDimObjIds2);
            String orgFilterScript = dimObjFieldKey1 + ".id" + " not in (" + allDimObjIds1Str + ") ";
            if (StringUtils.isNotEmpty((String)dimObjFieldKey2)) {
                orgFilterScript = orgFilterScript + " and (" + dimObjFieldKey2 + ".id" + " not in(" + allDimObjIds2Str + "))";
            }
            resultScript = resultScript + " or (" + orgFilterScript + ')';
        }
        logger.debug("DataRuleResult\u8f6c\u5316\u4e3aScript\u540e\uff1a " + resultScript);
        return resultScript;
    }

    @SdkInternal
    public static boolean isSuperAdminStrategy() {
        long adminSchemeId = PermCommonUtil.cunrrentAdminStrategy();
        return adminSchemeId == PermHelperConst.SUPERADMIN_STRATEGY_ID;
    }

    @SdkInternal
    public static Long cunrrentAdminStrategy() {
        DynamicObject adminScheme = BusinessDataServiceHelper.loadSingleFromCache((String)"perm_adminscheme", (String)"id,entryentity.admintype", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)Boolean.TRUE)});
        return adminScheme.getLong("id");
    }

    @SdkInternal
    public static List<String> getNotPublishedMenuIdByAppNum(String appNum) {
        ArrayList<String> result = new ArrayList<String>(10);
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT mr.fid menuid,mr.fformid formid FROM t_meta_menuruntime mr ").append("WHERE mr.fappid = ?  AND mr.fformid <> ' ' ").append("AND NOT EXISTS (SELECT 1 FROM t_meta_formdesign ed ").append("JOIN t_meta_bizapp app ON ed.fbizappid = app.fid ").append("JOIN t_meta_bizcloud bc ON (app.fbizcloudid = bc.fid AND bc.fid in('83bfebc800000bac', '0QLCSO6KKZC9')) WHERE ed.fnumber = mr.fformid) ");
        Object[] params = new Object[]{appNum};
        Map formMenuMap = (Map)DB.query((DBRoute)DBRoute.meta, (String)sql.toString(), (Object[])params, rs -> {
            HashMap<String, String> map = new HashMap<String, String>(16);
            while (rs.next()) {
                String menuId = rs.getString(1);
                String formId = rs.getString(2);
                map.put(formId, menuId);
            }
            return map;
        });
        if (formMenuMap.isEmpty()) {
            return result;
        }
        sql.setLength(0);
        sql.append("SELECT app.fid app_id FROM t_meta_bizapp app ").append(" INNER JOIN t_meta_bizcloud cloud ON (cloud.FID = app.FBIZCLOUDID) ").append(" WHERE app.fdeploystatus = '2' AND cloud.FID in('83bfebc800000bac', '0QLCSO6KKZC9') ");
        List appIds = (List)DB.query((DBRoute)DBRoute.meta, (String)sql.toString(), null, rs -> {
            ArrayList<String> res = new ArrayList<String>(10);
            while (rs.next()) {
                res.add(rs.getString(1));
            }
            return res;
        });
        if (appIds.isEmpty()) {
            return result;
        }
        StringBuilder appIdsBuilder = new StringBuilder("(");
        for (String bizappId : appIds) {
            if (!StringUtils.isNotEmpty((String)bizappId)) continue;
            appIdsBuilder.append('\'').append(bizappId).append("',");
        }
        appIdsBuilder.deleteCharAt(appIdsBuilder.length() - 1).append(')');
        Set<String> formIds = formMenuMap.keySet();
        Map<String, String> menuFormNum2EntNumMap = MenuHelper.getMenuFormNum2EntNumMap(formIds);
        Set entAndFormEnumSet = menuFormNum2EntNumMap.values().stream().collect(Collectors.toSet());
        String entAndFormEnumSetStr = String.join((CharSequence)"','", entAndFormEnumSet);
        sql.setLength(0);
        sql.append("SELECT boa.fbizobjid FROM t_perm_bizobjapp boa ").append("WHERE boa.fbizappid IN ").append((CharSequence)appIdsBuilder).append(" AND boa.fbizobjid IN ('").append(entAndFormEnumSetStr).append("')");
        List publishedEntNum = (List)DB.query((DBRoute)DBRoute.permission, (String)sql.toString(), null, rs -> {
            ArrayList<String> res = new ArrayList<String>(10);
            while (rs.next()) {
                res.add(rs.getString(1));
            }
            return res;
        });
        Iterator<Map.Entry<String, String>> iterator = menuFormNum2EntNumMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            String value = entry.getValue();
            if (!publishedEntNum.contains(value)) continue;
            iterator.remove();
        }
        ArrayList<String> notPublishedFormList = new ArrayList<String>(menuFormNum2EntNumMap.keySet());
        for (String notPublishedFormId : notPublishedFormList) {
            result.add((String)formMenuMap.get(notPublishedFormId));
        }
        return result;
    }

    @Deprecated
    @SdkInternal
    public static List<String> getSysCloudApp() {
        return AdminSchemeHelper.queryAllSysApp(false, true);
    }

    @SdkInternal
    public static void cancelShowForm(List<Long> userIds, List<Map<String, String>> entityIds, boolean entityIdsEmptyCall) {
        if (PermCommonUtil.isEnableAuthorityChangeNotice()) {
            try {
                if (!CollectionUtils.isEmpty(userIds)) {
                    FormConfigFactory.cancelShowFormRights(userIds);
                }
            }
            catch (Exception e) {
                logger.warn("[PermCommonUtil.cancelShowFormRights]\u6e05\u9664\u9886\u57df\u7f13\u5b58\u5f02\u5e38", (Throwable)e);
            }
            try {
                if (CollectionUtils.isEmpty(entityIds) && entityIdsEmptyCall && !CollectionUtils.isEmpty(userIds)) {
                    FormConfigFactory.cancelShowFormDataRights(userIds);
                } else if (!CollectionUtils.isEmpty(entityIds) && !CollectionUtils.isEmpty(userIds)) {
                    FormConfigFactory.cancelShowFormDataRights(userIds, entityIds);
                }
            }
            catch (Exception e) {
                logger.warn("[PermCommonUtil.cancelShowFormDataRights]\u6e05\u9664\u9886\u57df\u7f13\u5b58\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    @SdkInternal
    public static boolean needCheckAdminPerm(String appId, String entityNum) {
        String key = String.format("%s%s%s%s", "needCheckAdminPerm_", RequestContext.get().getAccountId(), appId, entityNum);
        Map threadCacheMap = (Map)ThreadCache.get((Object)key, () -> {
            HashMap<String, Boolean> map = new HashMap<String, Boolean>(8);
            Boolean result = PermCommonUtil.needCheckAdminPermNoCache(appId, entityNum);
            if (null == result) {
                return map;
            }
            map.put("needCheckAdminPerm_", result);
            return map;
        });
        Boolean needCheckAdminPerm = (Boolean)threadCacheMap.get("needCheckAdminPerm_");
        return null == needCheckAdminPerm ? false : needCheckAdminPerm;
    }

    private static Boolean needCheckAdminPermNoCache(String appId, String entityNum) {
        List<String> adminPermExcludedEntities;
        if (StringUtils.isEmpty((String)appId) || StringUtils.isEmpty((String)entityNum)) {
            return Boolean.FALSE;
        }
        if (PermCommonUtil.isInSysCloud(appId) && !(adminPermExcludedEntities = PermCommonUtil.getAdminPermExcludedEntities()).contains(entityNum)) {
            return Boolean.TRUE;
        }
        return PermCommonUtil.checkAdminPermByAppEnt(appId, entityNum);
    }

    private static boolean checkAdminPermByAppEnt(String appId, String entityNum) {
        if (StringUtils.isEmpty((String)appId) || StringUtils.isEmpty((String)entityNum)) {
            return false;
        }
        ArrayList<QFilter> qfilterList = new ArrayList<QFilter>(2);
        if (StringUtils.isNotEmpty((String)appId)) {
            qfilterList.add(new QFilter("entryentity.app", "=", (Object)appId));
        }
        if (StringUtils.isNotEmpty((String)entityNum)) {
            qfilterList.add(new QFilter("entryentity.entity", "=", (Object)entityNum));
        }
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"PermCommonUtil.needCheckAdminPermNoCache", (String)"perm_admindomain", (String)"id", (QFilter[])qfilterList.toArray(new QFilter[qfilterList.size()]), (String)"");){
            if (ds.hasNext()) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    @Deprecated
    @SdkInternal
    public static Set<String> getDomainChargeEntityRange() {
        String sql = " select distinct fentitynum from t_perm_admindomainrange ";
        Set changeRange = (Set)DB.query((DBRoute)DBRoute.permission, (String)sql, null, rs -> {
            HashSet<String> result = new HashSet<String>(50);
            while (rs.next()) {
                result.add(rs.getString(1));
            }
            return result;
        });
        return changeRange;
    }

    @SdkInternal
    public static void redirectToExistedPage(String newPageId, IFormView curPage) {
        IFormView newFv = curPage.getViewNoPlugin(newPageId);
        if (newFv != null) {
            newFv.activate();
            curPage.sendFormAction(newFv);
        }
    }

    @SdkInternal
    public static void buildDimTypeItemClassType(ItemClassTypeEdit dimTypeField) {
        HashSet sysTreeFilterSet = null;
        boolean isReportPage = dimTypeField.getView() instanceof ReportView;
        if (!isReportPage) {
            sysTreeFilterSet = Sets.newHashSet((Object[])new String[]{SEQ_FIRST_PERMCTRLFIELD});
        }
        HashSet<String> excludeBizEntNumSet = new HashSet<String>(2);
        excludeBizEntNumSet.add("bos_objecttype");
        PermCtrlTypeReq permCtrlTypeReq = new PermCtrlTypeReq((Set)sysTreeFilterSet, null, null, excludeBizEntNumSet, null);
        List<PermCtrlType> permCtrlTypeList = IsoDimHelper.getPermCtrlTypeList(permCtrlTypeReq);
        ArrayList<ComboItem> propertyItems = new ArrayList<ComboItem>(permCtrlTypeList.size());
        ItemClassTypeProp property = (ItemClassTypeProp)dimTypeField.getProperty();
        Map itemTypes = property.getItemTypes();
        ArrayList<String> baseEntityIds = new ArrayList<String>(permCtrlTypeList.size());
        for (PermCtrlType permCtrlType : permCtrlTypeList) {
            String entNum = permCtrlType.getBizobjectid();
            baseEntityIds.add(entNum);
            try {
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entNum);
                if (dataEntityType == null) {
                    throw new IllegalArgumentException("Perm DimType " + entNum + " Not Found ");
                }
                ComboItem comboItem = new ComboItem();
                comboItem.setId(entNum);
                comboItem.setValue(entNum);
                comboItem.setCaption(new LocaleString(permCtrlType.getName()));
                itemTypes.put(entNum, dataEntityType);
                propertyItems.add(comboItem);
            }
            catch (Exception e2) {
                logger.debug("Perm DimType: {} Not Found ", (Object)entNum);
            }
        }
        dimTypeField.setComboItems(propertyItems);
        property.setBaseEntityIds(baseEntityIds);
    }

    @SdkInternal
    public static MainEntityType getNewEntityType(MainEntityType originalEntityType, Map<String, String> entryFieldMap) {
        if (null == entryFieldMap || entryFieldMap.isEmpty()) {
            return originalEntityType;
        }
        PermCtrlTypeReq permCtrlTypeReq = new PermCtrlTypeReq((Set)Sets.newHashSet((Object[])new String[]{SEQ_FIRST_PERMCTRLFIELD}), null, null, (Set)Sets.newHashSet((Object[])new String[]{"bos_objecttype"}), null);
        List<PermCtrlType> permCtrlTypeList = IsoDimHelper.getPermCtrlTypeList(permCtrlTypeReq);
        if (null == permCtrlTypeList || permCtrlTypeList.isEmpty()) {
            return originalEntityType;
        }
        MainEntityType newEntityType = originalEntityType;
        try {
            HashMap<String, MainEntityType> entNumEntTypeMap = new HashMap<String, MainEntityType>(permCtrlTypeList.size());
            for (PermCtrlType permCtrlType : permCtrlTypeList) {
                String entNum = permCtrlType.getBizobjectid();
                try {
                    MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entNum);
                    if (dataEntityType == null) {
                        throw new IllegalArgumentException("Perm DimType [" + entNum + "] Not Found ");
                    }
                    entNumEntTypeMap.put(entNum, dataEntityType);
                }
                catch (Exception e2) {
                    logger.debug("PermCommonUtil.getNewEntityType,{}", (Object)e2.getMessage());
                }
            }
            newEntityType = (MainEntityType)originalEntityType.clone();
            for (Map.Entry entry : entryFieldMap.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                EntryProp entryProp = (EntryProp)newEntityType.getProperty(key);
                ItemClassTypeProp itemClassTypeProp = (ItemClassTypeProp)entryProp.getDynamicCollectionItemPropertyType().getProperty(value);
                itemClassTypeProp.setEditable(true);
                Map itemClassTypeMap = itemClassTypeProp.getItemTypes();
                itemClassTypeMap.putAll(entNumEntTypeMap);
            }
        }
        catch (Exception ex) {
            logger.debug("PermCommonUtil.getNewEntityType", (Object)ex);
        }
        return newEntityType;
    }

    @SdkInternal
    public static String[] getPermInfoFromNodeId(String prefix, String nodeId) {
        String[] result = null;
        int first = nodeId.indexOf(35);
        int second = nodeId.indexOf(64);
        int third = nodeId.indexOf(124);
        switch (prefix) {
            case "permitem#": {
                String permItemId = nodeId.substring(first + 1, second);
                String entityNum = nodeId.substring(second + 1, third);
                String appId = nodeId.substring(third + 1);
                result = new String[]{appId, entityNum, permItemId};
                break;
            }
            case "entity#": {
                String entityNum = nodeId.substring(first + 1, second);
                String appId = nodeId.substring(second + 1);
                result = new String[]{appId, entityNum};
                break;
            }
            case "app#": {
                String appId = nodeId.substring(first + 1);
                result = new String[]{appId};
                break;
            }
            case "cloud#": {
                String cloudId = nodeId.substring(first + 1);
                result = new String[]{cloudId};
            }
        }
        return result;
    }

    @SdkInternal
    public static String filterObjectToString(FilterObject filterObject) {
        int COMPARETYPE_FIELDCOMPARE = 9;
        try {
            String finalStr = "";
            if (filterObject == null) {
                return finalStr;
            }
            List filterRows = filterObject.getFilterRows();
            if (filterRows == null || filterRows.isEmpty()) {
                return finalStr;
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < filterRows.size(); ++i) {
                CompareType compareType;
                FilterField filterField;
                FilterRow filterRow = (FilterRow)filterRows.get(i);
                if (filterRow == null || (filterField = filterRow.getFilterField()) == null || (compareType = filterRow.getCompareType()) == null) continue;
                String leftBracket = filterRow.getLeftBracket();
                sb.append(leftBracket);
                String fieldName = filterField.getCaption().getLocaleValue();
                sb.append(fieldName);
                int groupId = compareType.getGroupId();
                String compareTypeName = compareType.getName().getLocaleValue();
                sb.append(' ').append(compareTypeName);
                StringBuilder sbValue = new StringBuilder(8);
                List value = filterRow.getValue();
                if (value != null && !value.isEmpty()) {
                    for (String valueStr : value) {
                        if (StringUtils.isEmpty((String)valueStr)) continue;
                        if (9 == groupId) {
                            try {
                                FieldName ormFieldName = EntityTypeUtil.getORMFieldName((String)valueStr, (EntityType)filterObject.getDataType());
                                if (ormFieldName != null) {
                                    valueStr = ormFieldName.getFieldCaption().getLocaleValue();
                                }
                            }
                            catch (Exception e) {
                                logger.warn((Throwable)e);
                            }
                        }
                        sbValue.append(valueStr).append(',');
                    }
                    if (sbValue.length() > 0) {
                        sbValue.deleteCharAt(sbValue.length() - 1);
                        if (sbValue.indexOf(",") != -1) {
                            sb.append(" (").append((CharSequence)sbValue).append(')');
                        } else {
                            sb.append(' ').append((CharSequence)sbValue);
                        }
                    }
                }
                String rightBracket = filterRow.getRightBracket();
                sb.append(rightBracket);
                if (i == filterRows.size() - 1) continue;
                String logicName = filterRow.getLogic().getName();
                sb.append(' ').append(logicName).append(' ');
            }
            return sb.toString();
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
            return "Exception Occur, more detail in monitor log.";
        }
    }

    @SdkInternal
    public static void buildUserTypeMulCombo(ComboEdit userTypeField) {
        DynamicObjectCollection typeList = PermCommonUtil.getBosUserTypeDoc();
        if (typeList == null || typeList.isEmpty()) {
            return;
        }
        ArrayList<ComboItem> propertyItems = new ArrayList<ComboItem>(typeList.size());
        for (DynamicObject obj : typeList) {
            ComboItem comboItem = new ComboItem();
            comboItem.setId(obj.getString("id"));
            comboItem.setValue(obj.getString("id"));
            comboItem.setCaption(new LocaleString(obj.getString("name")));
            propertyItems.add(comboItem);
        }
        userTypeField.setComboItems(propertyItems);
    }

    @SdkInternal
    private static DynamicObjectCollection getBosUserTypeDoc() {
        QFilter filter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection typeList = QueryServiceHelper.query((String)"bos_usertype", (String)"id,name", (QFilter[])filters, (String)"ispreset desc,number");
        return typeList;
    }

    @SdkInternal
    public static Map<Long, String> getBosUserTypeMap() {
        DynamicObjectCollection doc = PermCommonUtil.getBosUserTypeDoc();
        if (null == doc || doc.isEmpty()) {
            return new HashMap<Long, String>(1);
        }
        HashMap<Long, String> map = new HashMap<Long, String>(doc.size());
        for (DynamicObject dyn : doc) {
            map.put(dyn.getLong("id"), dyn.getString("name"));
        }
        return map;
    }

    @SdkInternal
    public static Set<String> getUserTypeNameSetByIdStr(String userTypeNameStr) {
        HashSet<String> userTypeNameSet = new HashSet<String>(8);
        if (StringUtils.isEmpty((String)userTypeNameStr)) {
            return userTypeNameSet;
        }
        String[] userTypeSplit = userTypeNameStr.split(",");
        if (null == userTypeSplit || Objects.equals(0, userTypeSplit.length)) {
            return userTypeNameSet;
        }
        Set collect = Arrays.stream(userTypeSplit).filter(x -> StringUtils.isNotEmpty((String)x.trim())).collect(Collectors.toSet());
        if (null == collect || collect.isEmpty()) {
            return userTypeNameSet;
        }
        Map<Long, String> bosUserTypeMap = PermCommonUtil.getBosUserTypeMap();
        for (String one : collect) {
            String oneName = bosUserTypeMap.get(Long.valueOf(one));
            if (StringUtils.isEmpty((String)oneName)) continue;
            userTypeNameSet.add(oneName);
        }
        return userTypeNameSet;
    }

    @SdkInternal
    public static String getUserTypeNameStrByIdStr(String userTypeNameStr) {
        if (StringUtils.isEmpty((String)userTypeNameStr)) {
            return "";
        }
        Set<String> userTypeNameSetByIdStr = PermCommonUtil.getUserTypeNameSetByIdStr(userTypeNameStr);
        if (null == userTypeNameSetByIdStr || userTypeNameSetByIdStr.isEmpty()) {
            return "";
        }
        return String.join((CharSequence)",", userTypeNameSetByIdStr);
    }

    @SdkInternal
    public static Long getViewIdByNumber(String orgViewNumber) {
        BizViewQueryParam bizViewQueryParam = new BizViewQueryParam();
        bizViewQueryParam.setCustomFilter(new QFilter("number", "=", (Object)orgViewNumber));
        Map viewMap = OrgUnitServiceHelper.getView((BizViewQueryParam)bizViewQueryParam);
        if (null == viewMap || viewMap.isEmpty()) {
            return null;
        }
        Iterator iterator = viewMap.keySet().iterator();
        if (iterator.hasNext()) {
            return (Long)iterator.next();
        }
        return null;
    }

    @SdkInternal
    public static String validateOpenSuperUserPage() {
        Map<Long, User> userInfoMap = AdminSchemeHelper.getUserMapOfCurSchemTag(null, Sets.newHashSet((Object[])new String[]{"perm_superusercard"}), AdminSchemeHelper.getCurEnableSchemeId());
        if (!userInfoMap.isEmpty() && !userInfoMap.containsKey(RequestContext.get().getCurrUserId())) {
            Collection<User> users = userInfoMap.values();
            StringBuilder userNamesStr = new StringBuilder();
            for (User user : users) {
                userNamesStr.append('\u201c').append(user.getFtruename()).append("\u201d\u3001");
            }
            userNamesStr.deleteCharAt(userNamesStr.length() - 1);
            return ResManager.loadKDString((String)"\u60a8\u65e0\u6cd5\u4f7f\u7528\u8be5\u529f\u80fd\uff0c\u53ea\u6709%s\u624d\u53ef\u4ee5\u4f7f\u7528\u3002", (String)"PermCommonUtil_4", (String)"bos-permission-cache", (Object[])new Object[]{userNamesStr.toString()});
        }
        if (userInfoMap.isEmpty()) {
            return ResManager.loadKDString((String)"\u60a8\u65e0\u6cd5\u4f7f\u7528\u8be5\u529f\u80fd\u3002", (String)"PermCommonUtil_5", (String)"bos-permission-cache", (Object[])new Object[0]);
        }
        return "";
    }

    @SdkInternal
    public static Map<String, Set<String>> getRunModeBlackList_AppEntMap() {
        int product = RunModeServiceHelper.getRunModeCode();
        final Map<String, String> appNumIdMap = AppHelper.getAllAppNumberIdMap(null);
        String sql = String.format("SELECT FAPPNUM, FENTITYNUM FROM T_META_EntityBlackList WHERE FPRODUCT = %d", product);
        Map result = (Map)DB.query((DBRoute)DBRoute.meta, (String)sql, null, (ResultSetHandler)new ResultSetHandler<Map<String, Set<String>>>(){

            public Map<String, Set<String>> handle(ResultSet rs) throws Exception {
                HashMap<String, Set<String>> dataMap = new HashMap<String, Set<String>>(8);
                while (rs.next()) {
                    String appNum = rs.getString("FAPPNUM");
                    String entityNum = rs.getString("FENTITYNUM");
                    if (StringUtils.isEmpty((String)appNum) || StringUtils.isEmpty((String)entityNum)) continue;
                    String appId = (String)appNumIdMap.get(appNum);
                    dataMap.computeIfAbsent(appId, k -> new HashSet(8)).add(entityNum);
                }
                return dataMap;
            }
        });
        return result;
    }

    @SdkInternal
    public static List<String> getAppIdsFromStdBlackList() {
        ProductSettingService service = (ProductSettingService)ServiceFactory.getService(ProductSettingService.class);
        List appIdsInBlackList = service.getAppIdBlackList();
        return appIdsInBlackList;
    }

    @SdkInternal
    public static List<String> getCloudIdsFromStdBlackList() {
        ProductSettingService service = (ProductSettingService)ServiceFactory.getService(ProductSettingService.class);
        List cloudIds = service.getCloudIdBlackList();
        return cloudIds;
    }

    public static boolean permEnableEntityOperservice(Map<String, String> variables) {
        if (null == variables || variables.isEmpty()) {
            return false;
        }
        String permEnableEntityOperservice = variables.get("PERM_ENABLE_ENTITY_OPERSERVICE");
        if (StringUtils.isEmpty((String)permEnableEntityOperservice)) {
            return false;
        }
        return Objects.equals(SEQ_FIRST_PERMCTRLFIELD, permEnableEntityOperservice);
    }

    public static GetBaseDataDynMapResp getBaseDataDynMap(GetBaseDataDynMapReq req) {
        PermBuilder builder = PermBuilder.of(GetBaseDataDynMapResp::new);
        Set admGrpIdSet = req.getAdmGrpIdSet();
        Set appIdSet = req.getAppIdSet();
        Set entNumSet = req.getEntNumSet();
        Set permItemIdSet = req.getPermItemIdSet();
        Set orgIdSet = req.getOrgIdSet();
        Set userIdSet = req.getUserIdSet();
        Set comRoleIdSet = req.getComRoleIdSet();
        HashMap admGrpDynMap = CollectionUtils.isEmpty((Collection)admGrpIdSet) ? new HashMap(0) : BusinessDataServiceHelper.loadFromCache((String)"perm_admingroup", (String)"id, number,name, adminscheme, level, parent_id, isdomain, domain_id", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)admGrpIdSet)});
        HashMap appDynMap = CollectionUtils.isEmpty((Collection)appIdSet) ? new HashMap(0) : BusinessDataServiceHelper.loadFromCache((String)"bos_devportal_bizapp", (String)"id, number,name", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)appIdSet)});
        HashMap<String, DynamicObject> entDynMap = new HashMap<String, DynamicObject>(8);
        DynamicObject[] formdesignArr = CollectionUtils.isEmpty((Collection)entNumSet) ? new DynamicObject[]{} : BusinessDataServiceHelper.load((String)"bos_objecttype", (String)"id, number,name", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)entNumSet)});
        for (int i = 0; i < formdesignArr.length; ++i) {
            DynamicObject value = formdesignArr[i];
            if (null == value) continue;
            entDynMap.put(value.getString("number"), value);
        }
        HashMap permitemDynMap = CollectionUtils.isEmpty((Collection)permItemIdSet) ? new HashMap(0) : BusinessDataServiceHelper.loadFromCache((String)"perm_permitem", (String)"id, number,name", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)permItemIdSet)});
        HashMap orgDynMap = CollectionUtils.isEmpty((Collection)orgIdSet) ? new HashMap(0) : BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"id, number,name", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)orgIdSet)});
        HashMap userDynMap = CollectionUtils.isEmpty((Collection)userIdSet) ? new HashMap(0) : BusinessDataServiceHelper.loadFromCache((String)"bos_user", (String)"id, number,name", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)userIdSet)});
        HashMap comRoleDynMap = CollectionUtils.isEmpty((Collection)comRoleIdSet) ? new HashMap(0) : BusinessDataServiceHelper.loadFromCache((String)"perm_role", (String)"id, number,name", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)comRoleIdSet)});
        return (GetBaseDataDynMapResp)builder.with(GetBaseDataDynMapResp::setAdmGrpDynMap, admGrpDynMap).with(GetBaseDataDynMapResp::setAppDynMap, appDynMap).with(GetBaseDataDynMapResp::setEntDynMap, entDynMap).with(GetBaseDataDynMapResp::setPermItemDynMap, permitemDynMap).with(GetBaseDataDynMapResp::setOrgDynMap, orgDynMap).with(GetBaseDataDynMapResp::setUserDynMap, userDynMap).with(GetBaseDataDynMapResp::setComRoleDynMap, comRoleDynMap).build();
    }

    private static boolean ifFirstOrgProp(String fieldKey, Map<String, IDataEntityProperty> allFields) {
        try {
            String[] arrFieldKey = fieldKey.split("\\.");
            if (arrFieldKey == null || arrFieldKey.length == 0) {
                return false;
            }
            BasedataProp property = null;
            if (arrFieldKey.length == 2) {
                fieldKey = arrFieldKey[0];
                property = (BasedataProp)allFields.get(fieldKey);
                if (property == null) {
                    return false;
                }
                return property instanceof OrgProp;
            }
            if (arrFieldKey.length == 3) {
                return false;
            }
            return false;
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
            return false;
        }
    }
}

