/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.cache.util;

import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.RefEntityType;
import kd.bos.entity.RuntimeMetaType;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.gray.AppGroupUtils;
import kd.bos.permission.cache.util.NumberUtil;
import kd.bos.sharemeta.ShareMetaUtil;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class PermLocalCacheUtil {
    private static final String cacheType = "Permission";
    private static final CacheConfigInfo info = new CacheConfigInfo();

    private PermLocalCacheUtil() {
    }

    @Deprecated
    public static Object getLocalCacheByKey(String key) {
        CacheConfigInfo info = new CacheConfigInfo();
        return PermLocalCacheUtil.getLocalCacheByKey(key, info);
    }

    @Deprecated
    public static void putLocalCache(String key, int timeout, int maxMemSize, Object value) {
        CacheConfigInfo info = new CacheConfigInfo();
        info.setTimeout(timeout);
        info.setMaxItemSize(maxMemSize);
        PermLocalCacheUtil.putLocalCache(key, value, info);
    }

    public static Object getLocalCacheByKey(String key, CacheConfigInfo info) {
        LocalMemoryCache localCache = CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(RequestContext.get().getAccountId(), cacheType, info);
        return localCache.get(key);
    }

    public static void putLocalCache(String key, Object value, CacheConfigInfo info) {
        LocalMemoryCache localCache = CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(RequestContext.get().getAccountId(), cacheType, info);
        localCache.put(key, value);
    }

    public static void removeLocalCacheByKey(String ... keys) {
        CacheConfigInfo info = new CacheConfigInfo();
        LocalMemoryCache localCache = CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(RequestContext.get().getAccountId(), cacheType, info);
        localCache.remove(keys);
    }

    private static LocalMemoryCache getLocalCache(String entitynumber) {
        String region = CacheKeyUtil.getAcctId();
        if (StringUtils.isNotBlank((CharSequence)entitynumber)) {
            region = ShareMetaUtil.getLocalCacheRegion((String)region, (String)entitynumber);
        }
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(region, cacheType, info);
    }

    private static String makeCacheKey(RuntimeMetaType type, String entitynumber) {
        String appGroup = AppGroupUtils.getCurrentAppGroup();
        return PermLocalCacheUtil.makeCacheKey(appGroup, type, entitynumber);
    }

    private static String makeCacheKey(String appGroup, RuntimeMetaType type, String entitynumber) {
        if (StringUtils.isNotBlank((CharSequence)appGroup) && !"defaultGroup".equals(appGroup)) {
            return String.format("%s.%s.%s", appGroup, entitynumber, type.getValue()).toLowerCase();
        }
        return String.format("%s.%s", entitynumber, type.getValue()).toLowerCase();
    }

    public static MainEntityType getDataEntityType(String entitynumber) {
        String key = PermLocalCacheUtil.makeCacheKey(RuntimeMetaType.Entity, entitynumber);
        return (MainEntityType)PermLocalCacheUtil.getLocalCache(entitynumber).get(key);
    }

    public static void putDataEntityType(MainEntityType dt) {
        String entitynumber = dt.getName();
        String key = PermLocalCacheUtil.makeCacheKey(RuntimeMetaType.Entity, entitynumber);
        PermLocalCacheUtil.getLocalCache(entitynumber).put(key, (Object)dt);
    }

    public static RefEntityType getRefDataEntityType(String entitynumber) {
        String key = PermLocalCacheUtil.makeCacheKey(RuntimeMetaType.Entity, entitynumber + ".ref");
        return (RefEntityType)PermLocalCacheUtil.getLocalCache(entitynumber).get(key);
    }

    public static void putRefDataEntityType(RefEntityType dt) {
        String entitynumber = dt.getName();
        String key = PermLocalCacheUtil.makeCacheKey(RuntimeMetaType.Entity, entitynumber + ".ref");
        PermLocalCacheUtil.getLocalCache(entitynumber).put(key, (Object)dt);
    }

    public static void remove(String entitynumber) {
        PermLocalCacheUtil.remove("", entitynumber);
    }

    static void remove(String appGroup, String entitynumber) {
        String key;
        LocalMemoryCache localCache = PermLocalCacheUtil.getLocalCache(entitynumber);
        String[] keys = new String[RuntimeMetaType.values().length];
        int i = 0;
        for (RuntimeMetaType type : RuntimeMetaType.values()) {
            keys[i] = key = PermLocalCacheUtil.makeCacheKey(appGroup, type, entitynumber);
            ++i;
        }
        localCache.remove(keys);
        key = PermLocalCacheUtil.makeCacheKey(appGroup, RuntimeMetaType.Entity, entitynumber + ".ref");
        localCache.remove(new String[]{key});
        PermLocalCacheUtil.getLocalCache(entitynumber).remove(new String[]{PermLocalCacheUtil.getBaseDataFieldFilterRegionKey(appGroup, entitynumber)});
    }

    private static String getBaseDataFieldFilterRegionKey(String appGroup, String formId) {
        return PermLocalCacheUtil.makeCacheKey(appGroup, RuntimeMetaType.BaseDataFieldFilter, formId);
    }

    static {
        info.setTimeout(NumberUtil.getRandomNum(43200));
        info.setMaxItemSize(1000);
    }
}

