/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.cache.util;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class PermVerifyUtil {
    private static Log log = LogFactory.getLog(PermVerifyUtil.class);

    public static Map<String, Boolean> getExistMapByNum(String entNum, Set<String> numSet) {
        try {
            Sets.SetView notExistSet;
            DynamicObjectCollection doc;
            if (StringUtils.isEmpty((String)entNum) || null == numSet || numSet.isEmpty()) {
                return new HashMap<String, Boolean>(1);
            }
            MainEntityType met = EntityMetadataCache.getDataEntityType((String)entNum);
            BasedataEntityType bdet = (BasedataEntityType)met;
            String numberProperty = bdet.getNumberProperty();
            HashMap<String, Boolean> map = new HashMap<String, Boolean>(8);
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
            if (null != numSet && !numSet.isEmpty()) {
                qFilters.add(new QFilter(numberProperty, "in", numSet));
            }
            if (Objects.equals("perm_datarule", entNum)) {
                qFilters.add(new QFilter("isdetail", "=", (Object)"1"));
            }
            if (null != (doc = QueryServiceHelper.query((String)entNum, (String)numberProperty, (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]))) && !doc.isEmpty()) {
                for (DynamicObject dym : doc) {
                    map.put(dym.getString(numberProperty), Boolean.TRUE);
                }
            }
            if (null == (notExistSet = Sets.difference(numSet, map.keySet())) || notExistSet.isEmpty()) {
                return map;
            }
            for (String name : notExistSet) {
                map.put(name, Boolean.FALSE);
            }
            return map;
        }
        catch (Exception e) {
            log.warn("PermVerifyUtil.getExistMapByNum error.", (Throwable)e);
            throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
        }
    }
}

