/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.cache.util;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Sets;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.CloudHelper;
import kd.bos.permission.cache.helper.FormHelper;
import kd.bos.permission.cache.model.permbase.App;
import kd.bos.permission.cache.model.permbase.Cloud;
import kd.bos.permission.model.perm.Entity;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class PublishNoMenuAuthorizeUtil {
    private static final Log logger = LogFactory.getLog(PublishNoMenuAuthorizeUtil.class);

    public static List<Map<String, String>> getList(Set<String> cloudIdSet) {
        try {
            Set<App> oriAppSet = AppHelper.getOriAppSet(cloudIdSet);
            if (null == oriAppSet || oriAppSet.isEmpty()) {
                logger.debug("PublishNoMenuAuthorizeUtil getList, oriAppSet is empty");
                return new ArrayList<Map<String, String>>(1);
            }
            Map<String, String> appIdOriIdMap = AppHelper.getExtAppAndOrgnlAppRelPrivate(new HashSet<String>(1));
            logger.debug("PublishNoMenuAuthorizeUtil.upgrade.appIdOriIdMap: {}", (Object)JSON.toJSONString(appIdOriIdMap));
            Map<String, Set<String>> publishNoMenuEntNumAppIdSetMap = PublishNoMenuAuthorizeUtil.getPublishNoMenuEntNumAppIdSetMap();
            if (null == publishNoMenuEntNumAppIdSetMap || publishNoMenuEntNumAppIdSetMap.isEmpty()) {
                logger.debug("PublishNoMenuAuthorizeUtil getList, publishNoMenuEntNumAppIdSetMap is empty");
                return new ArrayList<Map<String, String>>(1);
            }
            logger.debug("PublishNoMenuAuthorizeUtil.upgrade.publishNoMenuEntNumAppIdSetMap: {}", (Object)JSON.toJSONString(publishNoMenuEntNumAppIdSetMap));
            return PublishNoMenuAuthorizeUtil.getResultList(cloudIdSet, appIdOriIdMap, publishNoMenuEntNumAppIdSetMap);
        }
        catch (Exception e) {
            logger.warn("PublishNoMenuAuthorizeUtil.upgrade error", (Throwable)e);
            return new ArrayList<Map<String, String>>(1);
        }
    }

    private static List<Map<String, String>> getResultList(Set<String> cloudIdSet, Map<String, String> appIdOriIdMap, Map<String, Set<String>> publishNoMenuEntNumAppIdSetMap) {
        Set<String> publishNoMenuEntNumSet = publishNoMenuEntNumAppIdSetMap.keySet();
        Map<String, String> entNumOriAppIdMap = PublishNoMenuAuthorizeUtil.getEntNumOriAppIdMap(appIdOriIdMap, publishNoMenuEntNumSet);
        HashSet<String> allAppIdSet = new HashSet<String>(8);
        HashSet<String> allEntNumSet = new HashSet<String>(8);
        allAppIdSet.addAll(entNumOriAppIdMap.values());
        allEntNumSet.addAll(entNumOriAppIdMap.keySet());
        for (Map.Entry<String, Set<String>> directMenuEntNumAppIdSet : publishNoMenuEntNumAppIdSetMap.entrySet()) {
            allAppIdSet.addAll((Collection<String>)directMenuEntNumAppIdSet.getValue());
            allEntNumSet.add(directMenuEntNumAppIdSet.getKey());
        }
        Map<String, Cloud> cloudMap = CloudHelper.getCloudMap(allAppIdSet);
        Map<String, App> appInfoMap = AppHelper.getAppMap(allAppIdSet);
        Map<String, Entity> entityInfoMap = FormHelper.getEntityInfoMap(allEntNumSet);
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>(10);
        HashMap<String, String> map = null;
        for (Map.Entry<String, Set<String>> publishNoMenuEntNumAppIdSet : publishNoMenuEntNumAppIdSetMap.entrySet()) {
            String appId;
            String entNumOne = publishNoMenuEntNumAppIdSet.getKey();
            Set<String> value = publishNoMenuEntNumAppIdSet.getValue();
            if (StringUtils.isEmpty((String)entNumOne) || null == value || value.isEmpty() || StringUtils.isEmpty((String)(appId = entNumOriAppIdMap.get(entNumOne)))) continue;
            for (String publishNoMenuAppId : value) {
                Cloud publishNoMenuCloud;
                App publishNoMenuAppInfo = appInfoMap.get(publishNoMenuAppId);
                if (null == publishNoMenuAppInfo) continue;
                map = new HashMap<String, String>(16);
                Cloud cloud = cloudMap.get(appId);
                if (null != cloud) {
                    String cloudId = cloud.getCloudId();
                    if (!CollectionUtils.isEmpty(cloudIdSet) && StringUtils.isNotEmpty((String)cloudId) && !cloudIdSet.contains(cloudId)) continue;
                    map.put("cloudId", cloudId);
                    map.put("cloudNumber", cloud.getCloudNumber());
                    map.put("cloudName", cloud.getCloudName());
                }
                map.put("appId", appId);
                App appInfo = appInfoMap.get(appId);
                if (null != appInfo) {
                    map.put("appNumber", appInfo.getAppNumber());
                    map.put("appName", appInfo.getAppName());
                }
                map.put("entNum", entNumOne);
                Entity entity = entityInfoMap.get(entNumOne);
                if (null != entity) {
                    map.put("entId", entity.getEntityId());
                    map.put("entName", entity.getEntityName());
                }
                if (null != (publishNoMenuCloud = cloudMap.get(publishNoMenuAppId))) {
                    map.put("publishNoMenuCloudId", publishNoMenuCloud.getCloudId());
                    map.put("publishNoMenuCloudNumber", publishNoMenuCloud.getCloudNumber());
                    map.put("publishNoMenuCloudName", publishNoMenuCloud.getCloudName());
                }
                map.put("publishNoMenuAppId", publishNoMenuAppId);
                if (null != publishNoMenuAppInfo) {
                    map.put("publishNoMenuAppNumber", publishNoMenuAppInfo.getAppNumber());
                    map.put("publishNoMenuAppName", publishNoMenuAppInfo.getAppName());
                }
                list.add(map);
            }
        }
        return list;
    }

    private static Map<String, String> getEntNumOriAppIdMap(final Map<String, String> appIdOriIdMap, Set<String> publishNoMenuEntNumSet) {
        if (null == publishNoMenuEntNumSet || publishNoMenuEntNumSet.isEmpty()) {
            return new HashMap<String, String>(1);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("select distinct b.fbizappid, a.fnumber");
        sb.append(" from t_meta_entitydesign a");
        sb.append(" inner join t_meta_bizunitrelform b on b.fformid = a.fid");
        String directMenuEntNumSetStr = String.join((CharSequence)"','", publishNoMenuEntNumSet);
        sb.append("  where a.fnumber in ('").append(directMenuEntNumSetStr).append("')");
        return (Map)DB.query((DBRoute)DBRoute.meta, (String)sb.toString(), (ResultSetHandler)new ResultSetHandler<Map<String, String>>(){

            public Map<String, String> handle(ResultSet rs) throws Exception {
                HashMap<String, String> map = new HashMap<String, String>(8);
                while (rs.next()) {
                    String fbizappid = rs.getString("fbizappid");
                    String fnumber = rs.getString("fnumber");
                    String oriAppId = (String)appIdOriIdMap.get(fbizappid);
                    if (StringUtils.isEmpty((String)oriAppId) || StringUtils.isEmpty((String)fnumber)) continue;
                    map.put(fnumber, oriAppId);
                }
                return map;
            }
        });
    }

    private static Map<String, Set<String>> getPublishNoMenuEntNumAppIdSetMap() {
        Map<String, String> extEntIdAndOriEntNumMap = FormHelper.getExtEntIdAndOriEntNumMap();
        logger.debug("PublishNoMenuAuthorizeUtil.extEntIdAndOriEntNumMap: {}", (Object)JSON.toJSONString(extEntIdAndOriEntNumMap));
        Set<Entity> publishEntitySet = PublishNoMenuAuthorizeUtil.getPublishEntitySet();
        logger.debug("PublishNoMenuAuthorizeUtil.publishEntitySet: {}", (Object)JSON.toJSONString(publishEntitySet));
        Set<Entity> linkMenuEntitySet = PublishNoMenuAuthorizeUtil.getLinkMenuEntitySet(extEntIdAndOriEntNumMap, null);
        logger.debug("PublishNoMenuAuthorizeUtil.linkMenuEntitySet: {}", (Object)JSON.toJSONString(linkMenuEntitySet));
        Sets.SetView diffSet = Sets.difference(publishEntitySet, linkMenuEntitySet);
        if (null == diffSet || diffSet.isEmpty()) {
            return new HashMap<String, Set<String>>(1);
        }
        logger.debug("PublishNoMenuAuthorizeUtil.diffSet: {}", (Object)JSON.toJSONString((Object)diffSet));
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>(8);
        for (Entity entity : diffSet) {
            map.computeIfAbsent(entity.getEntityNumber(), k -> new HashSet(8)).add(entity.getAppId());
        }
        return map;
    }

    private static Set<Entity> getLinkMenuEntitySet(final Map<String, String> extEntIdAndOriEntNumMap, Set<String> oriAppNumberParamSet) {
        final Map<String, String> appNumIdMap = AppHelper.getAppNumIdMap(new HashSet<String>(1));
        logger.debug("appNumIdMap: {}", (Object)JSON.toJSONString(appNumIdMap));
        StringBuilder sb = new StringBuilder();
        sb.append("select distinct a.fappid, b.fentityid");
        sb.append(" from t_meta_menuruntime a");
        sb.append(" inner join t_meta_formdesign b on b.fnumber = a.fformid");
        sb.append(" where a.fformid != '' and a.fformid != ' ' and a.fformid is not null");
        if (null != oriAppNumberParamSet && !oriAppNumberParamSet.isEmpty()) {
            String oriAppNumberParamSetStr = String.join((CharSequence)"','", oriAppNumberParamSet);
            sb.append(" and a.fappid in ('").append(oriAppNumberParamSetStr).append("')");
        }
        return (Set)DB.query((DBRoute)DBRoute.meta, (String)sb.toString(), (ResultSetHandler)new ResultSetHandler<Set<Entity>>(){

            public Set<Entity> handle(ResultSet rs) throws Exception {
                HashSet<Entity> set = new HashSet<Entity>(8);
                Entity entity = null;
                while (rs.next()) {
                    String oriAppNum = rs.getString("fappid");
                    String fentityid = rs.getString("fentityid");
                    String oriAppId = (String)appNumIdMap.get(oriAppNum);
                    String oriEntNum = (String)extEntIdAndOriEntNumMap.get(fentityid);
                    if (StringUtils.isEmpty((String)oriAppId) || StringUtils.isEmpty((String)oriEntNum)) continue;
                    entity = new Entity();
                    entity.setAppId(oriAppId);
                    entity.setEntityNumber(oriEntNum);
                    set.add(entity);
                }
                return set;
            }
        });
    }

    private static Set<Entity> getPublishEntitySet() {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT distinct fbizappid, fbizobjid FROM t_perm_bizobjapp");
        return (Set)DB.query((DBRoute)DBRoute.permission, (String)sb.toString(), (ResultSetHandler)new ResultSetHandler<Set<Entity>>(){

            public Set<Entity> handle(ResultSet rs) throws Exception {
                HashSet<Entity> set = new HashSet<Entity>(8);
                Entity entity = null;
                while (rs.next()) {
                    String fbizappid = rs.getString("fbizappid");
                    String fbizobjid = rs.getString("fbizobjid");
                    entity = new Entity();
                    if (StringUtils.isEmpty((String)fbizappid) || StringUtils.isEmpty((String)fbizobjid)) continue;
                    entity.setAppId(fbizappid);
                    entity.setEntityNumber(fbizobjid);
                    set.add(entity);
                }
                return set;
            }
        });
    }

    private static Set<Entity> getOriEntitySet(final Map<String, String> extEntIdAndOriEntNumMap, final Map<String, String> appIdOriIdMap) {
        StringBuilder sb = new StringBuilder();
        sb.append("select distinct a.fbizappid, a.fformid");
        sb.append(" from t_meta_bizunitrelform a");
        sb.append(" inner join t_meta_entitydesign b on a.fformid = b.fid");
        return (Set)DB.query((DBRoute)DBRoute.meta, (String)sb.toString(), (ResultSetHandler)new ResultSetHandler<Set<Entity>>(){

            public Set<Entity> handle(ResultSet rs) throws Exception {
                HashSet<Entity> set = new HashSet<Entity>(8);
                Entity entity = null;
                while (rs.next()) {
                    String fbizappid = rs.getString("fbizappid");
                    String fformid = rs.getString("fformid");
                    entity = new Entity();
                    String oriAppId = (String)appIdOriIdMap.get(fbizappid);
                    String oriEntNum = (String)extEntIdAndOriEntNumMap.get(fformid);
                    if (StringUtils.isEmpty((String)oriAppId) || StringUtils.isEmpty((String)oriEntNum)) continue;
                    entity.setAppId(oriAppId);
                    entity.setEntityNumber(oriEntNum);
                    set.add(entity);
                }
                return set;
            }
        });
    }
}

