/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.cache.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.constant.PermHelperConst;
import kd.bos.permission.cache.util.ListUtil;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

public class SqlUtil {
    private static Log log = LogFactory.getLog(SqlUtil.class);
    private static ThreadPool pool = ThreadPools.newFixedThreadPool((String)"Permission_SqlUtil_Pool", (int)4);

    @SdkInternal
    public static int getBatchCount(Integer batchNum, int size) {
        if (null == batchNum || 0 == batchNum || 0 == size) {
            throw new KDBizException("batchNum or size error.");
        }
        int mod = size % batchNum;
        int divid = size / batchNum;
        return 0 == mod ? divid : divid + 1;
    }

    public static void syncInsert(List<Object[]> paramList, String sql, Integer batchNum, DBRoute dbRoute, boolean throwE) {
        if (CollectionUtils.isEmpty(paramList) || StringUtils.isEmpty((String)sql)) {
            return;
        }
        batchNum = null == batchNum ? PermHelperConst.SQL_INSERT_BATCH_NUM : batchNum;
        int size = paramList.size();
        int m = SqlUtil.getBatchCount(batchNum, size);
        List<List<Object[]>> listAvg = ListUtil.averageAssign(paramList, m);
        try (TXHandle h = TX.required();){
            try {
                for (int i = 0; i < listAvg.size(); ++i) {
                    List<Object[]> paramsList = listAvg.get(i);
                    if (null == paramsList || 0 == paramsList.size()) continue;
                    DB.executeBatch((DBRoute)dbRoute, (String)sql, paramsList);
                }
            }
            catch (Exception e) {
                log.warn("SqlUtil.syncInsert tx error.", (Throwable)e);
                h.markRollback();
                if (throwE) {
                    throw new KDBizException(e.getMessage());
                }
            }
        }
    }

    @SdkInternal
    public static void asyncInsert(List<Object[]> paramList, final String sql, Integer batchNum, final DBRoute dbRoute) {
        try {
            batchNum = null == batchNum ? PermHelperConst.SQL_INSERT_BATCH_NUM : batchNum;
            int size = paramList.size();
            int m = SqlUtil.getBatchCount(batchNum, size);
            final CountDownLatch countDownLatch = new CountDownLatch(m);
            final List<List<Object[]>> listAvg = ListUtil.averageAssign(paramList, m);
            int i = 0;
            while (i < listAvg.size()) {
                final int finalI = i++;
                pool.submit((Callable)new Callable<Void>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Void call() throws Exception {
                        try (TXHandle h = TX.requiresNew();){
                            try {
                                List paramsList = (List)listAvg.get(finalI);
                                if (null == paramsList || 0 == paramsList.size()) {
                                    Void void_ = null;
                                    return void_;
                                }
                                DB.executeBatch((DBRoute)dbRoute, (String)sql, (List)paramsList);
                            }
                            catch (Exception e) {
                                log.warn("SqlUtil.asyncInsert tx error.", (Throwable)e);
                                h.markRollback();
                            }
                            finally {
                                if (null != countDownLatch) {
                                    countDownLatch.countDown();
                                }
                            }
                        }
                        return null;
                    }
                });
            }
            countDownLatch.await();
        }
        catch (Exception e) {
            log.warn("SqlUtil.asyncInsert error.", (Throwable)e);
        }
    }

    @SdkInternal
    public static void asyncInsertThrowE(List<Object[]> paramList, final String sql, Integer batchNum, final DBRoute dbRoute) {
        if (CollectionUtils.isEmpty(paramList) || StringUtils.isEmpty((String)sql)) {
            return;
        }
        try {
            batchNum = null == batchNum ? PermHelperConst.SQL_INSERT_BATCH_NUM : batchNum;
            int size_ = paramList.size();
            int m = SqlUtil.getBatchCount(batchNum, size_);
            final CountDownLatch countDownLatch = new CountDownLatch(m);
            LinkedList<Future> futureList = new LinkedList<Future>();
            final List<List<Object[]>> listAvg = ListUtil.averageAssign(paramList, m);
            int size = listAvg.size();
            int i = 0;
            while (i < size) {
                final int finalI = i++;
                futureList.add(pool.submit((Callable)new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        try (TXHandle h = TX.requiresNew();){
                            try {
                                List paramsList = (List)listAvg.get(finalI);
                                if (null == paramsList || 0 == paramsList.size()) {
                                    Integer n = 1;
                                    return n;
                                }
                                DB.executeBatch((DBRoute)dbRoute, (String)sql, (List)paramsList);
                            }
                            catch (Exception e) {
                                log.warn("SqlUtil.asyncInsertThrowE tx error.", (Throwable)e);
                                h.markRollback();
                                throw new Exception(e.getMessage());
                            }
                            finally {
                                if (null != countDownLatch) {
                                    countDownLatch.countDown();
                                }
                            }
                        }
                        return 1;
                    }
                }));
            }
            countDownLatch.await();
            for (Future future : futureList) {
                future.get();
            }
        }
        catch (Exception e) {
            log.warn("SqlUtil.asyncInsertThrowE error.", (Throwable)e);
            throw new KDBizException(e.getMessage());
        }
    }

    @SdkInternal
    public static void syncDel(List<String> idList, String sql, String whereIdColumn, Integer inNum, DBRoute dbRoute) {
        if (CollectionUtils.isEmpty(idList) || StringUtils.isEmpty((String)sql) || StringUtils.isEmpty((String)whereIdColumn)) {
            return;
        }
        inNum = null == inNum ? PermHelperConst.SQL_IN_QUERY_NUM : inNum;
        int size_ = idList.size();
        int m = SqlUtil.getBatchCount(inNum, size_);
        List<List<String>> listAvg = ListUtil.averageAssign(idList, m);
        try {
            for (int i = 0; i < listAvg.size(); ++i) {
                List<String> paraList = listAvg.get(i);
                if (null == paraList || 0 == paraList.size()) continue;
                String idsStr = String.join((CharSequence)"','", paraList);
                StringBuilder sb = new StringBuilder(sql);
                sb.append(" where ").append(whereIdColumn).append(" in('").append(idsStr).append("')");
                DB.execute((DBRoute)dbRoute, (String)sb.toString());
            }
        }
        catch (Exception e) {
            log.warn("SqlUtil.syncDel error.", (Throwable)e);
            throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
        }
    }

    @SdkInternal
    public static void syncDelLong(List<Long> idList, String sql, String whereIdColumn, Integer inNum, DBRoute dbRoute) {
        if (CollectionUtils.isEmpty(idList) || StringUtils.isEmpty((String)sql) || StringUtils.isEmpty((String)whereIdColumn)) {
            return;
        }
        inNum = null == inNum ? PermHelperConst.SQL_IN_QUERY_NUM : inNum;
        int size = idList.size();
        int m = SqlUtil.getBatchCount(inNum, size);
        List<List<Long>> listAvg = ListUtil.averageAssign(idList, m);
        try {
            for (int i = 0; i < listAvg.size(); ++i) {
                List<Long> paraList = listAvg.get(i);
                if (null == paraList || 0 == paraList.size()) continue;
                List idsList = paraList.stream().map(String::valueOf).collect(Collectors.toList());
                String idsStr = String.join((CharSequence)",", idsList);
                StringBuilder sb = new StringBuilder(sql);
                sb.append(" where ").append(whereIdColumn).append(" in(").append(idsStr).append(")");
                DB.execute((DBRoute)dbRoute, (String)sb.toString());
            }
        }
        catch (Exception e) {
            log.warn("SqlUtil.syncDel error. ", (Throwable)e);
            throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
        }
    }

    @SdkInternal
    public static void asyncDelThrowE(List<String> idList, final String sql, final String whereIdColumn, Integer inNum, final DBRoute dbRoute) {
        if (CollectionUtils.isEmpty(idList) || StringUtils.isEmpty((String)sql) || StringUtils.isEmpty((String)whereIdColumn)) {
            return;
        }
        try {
            inNum = null == inNum ? PermHelperConst.SQL_IN_QUERY_NUM : inNum;
            int size = idList.size();
            int m = SqlUtil.getBatchCount(inNum, size);
            final CountDownLatch countDownLatch = new CountDownLatch(m);
            LinkedList<Future> futureList = new LinkedList<Future>();
            final List<List<String>> listAvg = ListUtil.averageAssign(idList, m);
            int i = 0;
            while (i < listAvg.size()) {
                final int finalI = i++;
                futureList.add(pool.submit((Callable)new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        try (TXHandle h = TX.requiresNew();){
                            try {
                                List paraList = (List)listAvg.get(finalI);
                                if (null == paraList || 0 == paraList.size()) {
                                    Integer n = 1;
                                    return n;
                                }
                                String idsStr = String.join((CharSequence)"','", (Iterable)listAvg.get(finalI));
                                StringBuilder sb = new StringBuilder(sql);
                                sb.append(" where ").append(whereIdColumn).append(" in('").append(idsStr).append("')");
                                DB.execute((DBRoute)dbRoute, (String)sb.toString());
                            }
                            catch (Exception e) {
                                log.warn("SqlUtil.asyncDelThrowE tx error.", (Throwable)e);
                                h.markRollback();
                                throw new Exception(e.getMessage());
                            }
                            finally {
                                if (null != countDownLatch) {
                                    countDownLatch.countDown();
                                }
                            }
                        }
                        return 1;
                    }
                }));
            }
            countDownLatch.await();
            for (Future future : futureList) {
                future.get();
            }
        }
        catch (Exception e) {
            log.warn("SqlUtil.asyncDelThrowE error.", (Throwable)e);
            throw new KDBizException(e.getMessage());
        }
    }

    @SdkInternal
    public static boolean checkSearchText(String searchText) {
        if (StringUtils.isEmpty((String)searchText)) {
            return true;
        }
        String pattern = "^[/_]*$|.*[%'].*";
        Pattern r = Pattern.compile(pattern);
        Matcher matcher = r.matcher(searchText);
        return !matcher.matches();
    }

    @SdkInternal
    public static String wrapInParam(Set<Object> inParamSet, List<Object> paramList) {
        for (Object one : inParamSet) {
            paramList.add(one);
        }
        return String.join((CharSequence)",", Collections.nCopies(inParamSet.size(), "?"));
    }

    @SdkInternal
    public static Set<Object> getIdSet(String entNum, List<QFilter> paramQFilterList) {
        try {
            if (StringUtils.isEmpty((String)entNum)) {
                return new HashSet<Object>(1);
            }
            MainEntityType met = EntityMetadataCache.getDataEntityType((String)entNum);
            String tableName = met.getAlias();
            SqlBuilder sb = new SqlBuilder();
            sb.append("select id from ", new Object[0]).append(tableName, new Object[0]);
            sb.append("where 1=1 ", new Object[0]);
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
            if (null != paramQFilterList && !paramQFilterList.isEmpty()) {
                qFilters.addAll(paramQFilterList);
            }
            HashSet<Object> result = new HashSet<Object>(8);
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"SqlUtil.getIdSet", (String)entNum, (String)"id", (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]), (String)"");){
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    result.add(row.get("id"));
                }
            }
            return result;
        }
        catch (Exception e) {
            log.warn("SqlUtil.getIdSet error.", (Throwable)e);
            return new HashSet<Object>(1);
        }
    }
}

