/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.cache.util;

import com.google.common.collect.Sets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.log.api.AppLogInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.newfeature.TenantService;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class UpgradeAdminUtil {
    private static final Log logger = LogFactory.getLog(UpgradeAdminUtil.class);
    public static final int UPGRADE_MODE_NEW = 0;
    public static final int UPGRADE_MODE_CONTINUE = 1;
    private static final String PERM_OLDADMINENABLE_ENTITY = "perm_oldadminenable";
    private static final String SYSTEM_TYPE = "bos-permission-cache";
    private static final String TABLE_T_PERM_USERADMINGROUP = "t_perm_useradmingroup";
    private static final String TABLE_T_PERM_ADMINGROUP = "t_perm_admingroup";
    private static final String TABLE_T_PERM_ADMINGROUP_L = "t_perm_admingroup_l";
    private static final String TABLE_T_PERM_ADMINGROUPBIZUNIT = "t_perm_admingroupbizunit";
    private static final String TABLE_T_PERM_ADMINGROUPORG = "t_perm_admingrouporg";
    private static final String TABLE_T_PERM_ADMINGROUPAPP = "t_perm_admingroupapp";
    private static final String TABLE_T_PERM_ADMINGROUPADDUSER = "t_perm_admingroupadduser";
    private static final String TABLE_T_PERM_ADMINGROUPFUNPERM = "t_perm_admingroupfunperm";
    private static List<Long> adminUserIdList = Arrays.asList(1L, 2L, 3L);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean upgrade(int upgradeMode, StringBuilder pProcessInfo, Integer fromType) {
        boolean bl;
        DLock lock;
        block46: {
            List<Map<String, Object>> adminList;
            Long adminschemeId;
            String upgradeModeStr;
            boolean changeOldAdminStatus;
            boolean upgradeOk;
            block44: {
                boolean action8;
                block45: {
                    List<Long> adminschemeList;
                    block42: {
                        boolean e22;
                        block43: {
                            Object mmsg;
                            block40: {
                                boolean e22;
                                block41: {
                                    block37: {
                                        boolean isNewCosmic2;
                                        block38: {
                                            String fenable;
                                            block33: {
                                                boolean bl2;
                                                block36: {
                                                    block34: {
                                                        boolean action22;
                                                        block35: {
                                                            block31: {
                                                                boolean bl3;
                                                                block32: {
                                                                    if (null == pProcessInfo) {
                                                                        pProcessInfo = new StringBuilder();
                                                                    }
                                                                    upgradeOk = true;
                                                                    changeOldAdminStatus = false;
                                                                    lock = DLock.create((String)"bas/permissinon/UpgradeAdminUtil");
                                                                    lock.lock();
                                                                    try {
                                                                        String string = upgradeModeStr = 0 == upgradeMode ? ResManager.loadKDString((String)"\u5168\u65b0\u5347\u7ea7", (String)"UpgradeAdminUtil_0", (String)SYSTEM_TYPE, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5dee\u91cf\u5347\u7ea7", (String)"UpgradeAdminUtil_1", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                                                                        if (null != fromType) break block31;
                                                                        String fromtype_isempty = ResManager.loadKDString((String)"\u6765\u6e90\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UpgradeAdminUtil_2", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                                                                        pProcessInfo.append(fromtype_isempty);
                                                                        String mmsg2 = upgradeModeStr + ", " + fromtype_isempty;
                                                                        UpgradeAdminUtil.addOperLog(mmsg2);
                                                                        logger.info(mmsg2);
                                                                        bl3 = upgradeOk = false;
                                                                        if (!changeOldAdminStatus) break block32;
                                                                    }
                                                                    catch (Throwable throwable) {
                                                                        if (changeOldAdminStatus) {
                                                                            UpgradeAdminUtil.enableNewAdmin();
                                                                        }
                                                                        CacheMrg.clearAllCache();
                                                                        String sql = "select FID from T_META_FORMDESIGN where FNUMBER = 'perm_oldadminenable'";
                                                                        ResultSetHandler<Void> action3 = new ResultSetHandler<Void>(){

                                                                            public Void handle(ResultSet rs) throws Exception {
                                                                                if (rs.next()) {
                                                                                    CacheMrg.clearHasEnableOldAdmin();
                                                                                }
                                                                                return null;
                                                                            }
                                                                        };
                                                                        DB.query((DBRoute)DBRoute.meta, (String)sql, (ResultSetHandler)action3);
                                                                        lock.unlock();
                                                                        throw throwable;
                                                                    }
                                                                    UpgradeAdminUtil.enableNewAdmin();
                                                                }
                                                                CacheMrg.clearAllCache();
                                                                String sql = "select FID from T_META_FORMDESIGN where FNUMBER = 'perm_oldadminenable'";
                                                                ResultSetHandler<Void> action22 = new /* invalid duplicate definition of identical inner class */;
                                                                DB.query((DBRoute)DBRoute.meta, (String)sql, (ResultSetHandler)action22);
                                                                lock.unlock();
                                                                return bl3;
                                                            }
                                                            Map<String, Object> enableMap = UpgradeAdminUtil.loadFromDB();
                                                            fenable = (String)enableMap.get("fenable");
                                                            if (1 != fromType) break block33;
                                                            if (!"0".equals(fenable)) break block34;
                                                            String already_new_admin = ResManager.loadKDString((String)"\u5df2\u7ecf\u662f\u65b0\u7ba1\u7406\u5458\u3002", (String)"UpgradeAdminUtil_3", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                                                            pProcessInfo.append(already_new_admin);
                                                            String mmsg3 = upgradeModeStr + ", " + already_new_admin;
                                                            UpgradeAdminUtil.addOperLog(mmsg3);
                                                            logger.info(mmsg3);
                                                            action22 = upgradeOk;
                                                            if (!changeOldAdminStatus) break block35;
                                                            UpgradeAdminUtil.enableNewAdmin();
                                                        }
                                                        CacheMrg.clearAllCache();
                                                        String sql = "select FID from T_META_FORMDESIGN where FNUMBER = 'perm_oldadminenable'";
                                                        ResultSetHandler<Void> action4 = new /* invalid duplicate definition of identical inner class */;
                                                        DB.query((DBRoute)DBRoute.meta, (String)sql, (ResultSetHandler)action4);
                                                        lock.unlock();
                                                        return action22;
                                                    }
                                                    String versionDateString = "2022-06-18";
                                                    String versionNumber = "5.0.001";
                                                    Boolean isNewCosmic2 = TenantService.isNewTenantByFeatureOFCosmic((String)versionDateString, (String)versionNumber);
                                                    if (isNewCosmic2.booleanValue()) break block33;
                                                    String new_admin = ResManager.loadKDString((String)"\u65b0\u7ba1\u7406\u5458", (String)"UpgradeAdminUtil_4", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                                                    String not_suit_newtenant = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u79df\u6237\u4e0d\u7b26\u5408[%1$s]\u65b0\u7279\u6027\u8981\u6c42\uff1a\u521b\u5efa\u79df\u6237\u65e5\u671f\uff08%2$s\uff09\uff0c\u82cd\u7a79\u7248\u672c\uff08%3$s\uff09\u3002", (String)"UpgradeAdminUtil_5", (String)SYSTEM_TYPE, (Object[])new Object[0]), new_admin, versionDateString, versionNumber);
                                                    pProcessInfo.append(not_suit_newtenant);
                                                    String mmsg4 = upgradeModeStr + ", " + not_suit_newtenant;
                                                    UpgradeAdminUtil.addOperLog(mmsg4);
                                                    logger.info(mmsg4);
                                                    bl2 = upgradeOk;
                                                    if (!changeOldAdminStatus) break block36;
                                                    UpgradeAdminUtil.enableNewAdmin();
                                                }
                                                CacheMrg.clearAllCache();
                                                String sql = "select FID from T_META_FORMDESIGN where FNUMBER = 'perm_oldadminenable'";
                                                ResultSetHandler<Void> action5 = new /* invalid duplicate definition of identical inner class */;
                                                DB.query((DBRoute)DBRoute.meta, (String)sql, (ResultSetHandler)action5);
                                                lock.unlock();
                                                return bl2;
                                            }
                                            if (!Objects.equals(3, fromType) || !"0".equals(fenable)) break block37;
                                            String already_new_admin = ResManager.loadKDString((String)"\u5df2\u7ecf\u662f\u65b0\u7ba1\u7406\u5458\u3002", (String)"UpgradeAdminUtil_3", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                                            pProcessInfo.append(already_new_admin);
                                            mmsg = upgradeModeStr + ", " + already_new_admin;
                                            UpgradeAdminUtil.addOperLog((String)mmsg);
                                            logger.info((String)mmsg);
                                            isNewCosmic2 = upgradeOk;
                                            if (!changeOldAdminStatus) break block38;
                                            UpgradeAdminUtil.enableNewAdmin();
                                        }
                                        CacheMrg.clearAllCache();
                                        String sql = "select FID from T_META_FORMDESIGN where FNUMBER = 'perm_oldadminenable'";
                                        ResultSetHandler<Void> action6 = new /* invalid duplicate definition of identical inner class */;
                                        DB.query((DBRoute)DBRoute.meta, (String)sql, (ResultSetHandler)action6);
                                        lock.unlock();
                                        return isNewCosmic2;
                                    }
                                    if (0 == upgradeMode) {
                                        TXHandle h = TX.required();
                                        mmsg = null;
                                        try {
                                            try {
                                                UpgradeAdminUtil.delAllNewAdmin();
                                            }
                                            catch (Exception e22) {
                                                logger.error("\u5168\u65b0\u66f4\u65b0\uff0c\u5220\u9664\u6240\u6709\u65b0\u7ba1\u7406\u5458\u529f\u80fd\u7684\u5185\u5bb9\uff0c\u5f02\u5e38", (Throwable)e22);
                                                h.markRollback();
                                                pProcessInfo.append(e22.getMessage());
                                                String mmsg5 = upgradeModeStr + ", " + ResManager.loadKDString((String)"\u5220\u9664\u6240\u6709\u65b0\u7ba1\u7406\u5458\u529f\u80fd\u7684\u5185\u5bb9\uff0c\u5f02\u5e38", (String)"UpgradeAdminUtil_6", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                                                UpgradeAdminUtil.addOperLog(mmsg5);
                                                throw e22;
                                            }
                                        }
                                        catch (Throwable e22) {
                                            mmsg = e22;
                                            throw e22;
                                        }
                                        finally {
                                            if (h != null) {
                                                if (mmsg != null) {
                                                    try {
                                                        h.close();
                                                    }
                                                    catch (Throwable e22) {
                                                        ((Throwable)mmsg).addSuppressed(e22);
                                                    }
                                                } else {
                                                    h.close();
                                                }
                                            }
                                        }
                                    }
                                    if (!CollectionUtils.isEmpty(adminschemeList = UpgradeAdminUtil.getAdminscheme())) break block40;
                                    pProcessInfo.append(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6682\u672a\u914d\u7f6e\u7ba1\u7406\u5458\u7b56\u7565\u3002", (String)"UpgradeAdminUtil_7", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                                    mmsg = upgradeModeStr + ", " + ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6682\u672a\u914d\u7f6e\u7ba1\u7406\u5458\u7b56\u7565\u3002", (String)"UpgradeAdminUtil_7", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                                    UpgradeAdminUtil.addOperLog((String)mmsg);
                                    logger.info((String)mmsg);
                                    e22 = upgradeOk = false;
                                    if (!changeOldAdminStatus) break block41;
                                    UpgradeAdminUtil.enableNewAdmin();
                                }
                                CacheMrg.clearAllCache();
                                String sql = "select FID from T_META_FORMDESIGN where FNUMBER = 'perm_oldadminenable'";
                                ResultSetHandler<Void> action7 = new /* invalid duplicate definition of identical inner class */;
                                DB.query((DBRoute)DBRoute.meta, (String)sql, (ResultSetHandler)action7);
                                lock.unlock();
                                return e22;
                            }
                            if (adminschemeList.size() <= 1) break block42;
                            pProcessInfo.append(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u914d\u7f6e\u7684\u7ba1\u7406\u5458\u7b56\u7565\u4e0d\u5408\u6cd5\u3002", (String)"UpgradeAdminUtil_8", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                            mmsg = upgradeModeStr + ", " + ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u914d\u7f6e\u7684\u7ba1\u7406\u5458\u7b56\u7565\u4e0d\u5408\u6cd5\u3002", (String)"UpgradeAdminUtil_8", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                            UpgradeAdminUtil.addOperLog((String)mmsg);
                            logger.info((String)mmsg);
                            e22 = upgradeOk = false;
                            if (!changeOldAdminStatus) break block43;
                            UpgradeAdminUtil.enableNewAdmin();
                        }
                        CacheMrg.clearAllCache();
                        String sql = "select FID from T_META_FORMDESIGN where FNUMBER = 'perm_oldadminenable'";
                        ResultSetHandler<Void> action8 = new /* invalid duplicate definition of identical inner class */;
                        DB.query((DBRoute)DBRoute.meta, (String)sql, (ResultSetHandler)action8);
                        lock.unlock();
                        return e22;
                    }
                    adminschemeId = adminschemeList.get(0);
                    adminList = UpgradeAdminUtil.getPermTopAdminList(adminschemeId);
                    if (!CollectionUtils.isEmpty(adminList)) break block44;
                    pProcessInfo.append(ResManager.loadKDString((String)"\u5f53\u524d\u6ca1\u6709\u9700\u8981\u5347\u7ea7\u7684\u9876\u7ea7\u7ba1\u7406\u5458\uff0c\u8bf7\u6838\u5b9e\u3002", (String)"UpgradeAdminUtil_9", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    String mmsg = upgradeModeStr + ", " + ResManager.loadKDString((String)"\u5f53\u524d\u6ca1\u6709\u9700\u8981\u5347\u7ea7\u7684\u9876\u7ea7\u7ba1\u7406\u5458\uff0c\u8bf7\u6838\u5b9e\u3002", (String)"UpgradeAdminUtil_9", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                    UpgradeAdminUtil.addOperLog(mmsg);
                    logger.info(mmsg);
                    changeOldAdminStatus = true;
                    action8 = upgradeOk;
                    if (!changeOldAdminStatus) break block45;
                    UpgradeAdminUtil.enableNewAdmin();
                }
                CacheMrg.clearAllCache();
                String sql = "select FID from T_META_FORMDESIGN where FNUMBER = 'perm_oldadminenable'";
                ResultSetHandler<Void> action9 = new /* invalid duplicate definition of identical inner class */;
                DB.query((DBRoute)DBRoute.meta, (String)sql, (ResultSetHandler)action9);
                lock.unlock();
                return action8;
            }
            boolean hasDoneNewAdmin = UpgradeAdminUtil.checkHasDoneNewAdmin();
            if (!hasDoneNewAdmin) {
                UpgradeAdminUtil.appendAdminList(adminList);
            }
            try {
                UpgradeAdminUtil.handlePermAdminList(upgradeModeStr, pProcessInfo, adminschemeId, adminList);
                String mmsg = upgradeModeStr + ", " + ResManager.loadKDString((String)"\u6210\u529f", (String)"UpgradeAdminUtil_10", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                UpgradeAdminUtil.addOperLog(mmsg);
                changeOldAdminStatus = true;
            }
            catch (Exception e) {
                logger.error("\u7ba1\u7406\u5458\u5347\u7ea7\uff0c\u5f02\u5e38", (Throwable)e);
                pProcessInfo.append("handlePermAdminList exception: ").append(e.getMessage());
                boolean sql = upgradeOk = false;
                if (changeOldAdminStatus) {
                    UpgradeAdminUtil.enableNewAdmin();
                }
                CacheMrg.clearAllCache();
                String sql2 = "select FID from T_META_FORMDESIGN where FNUMBER = 'perm_oldadminenable'";
                ResultSetHandler<Void> action = new /* invalid duplicate definition of identical inner class */;
                DB.query((DBRoute)DBRoute.meta, (String)sql2, (ResultSetHandler)action);
                lock.unlock();
                return sql;
            }
            bl = upgradeOk;
            if (!changeOldAdminStatus) break block46;
            UpgradeAdminUtil.enableNewAdmin();
        }
        CacheMrg.clearAllCache();
        String sql = "select FID from T_META_FORMDESIGN where FNUMBER = 'perm_oldadminenable'";
        ResultSetHandler<Void> action = new /* invalid duplicate definition of identical inner class */;
        DB.query((DBRoute)DBRoute.meta, (String)sql, (ResultSetHandler)action);
        lock.unlock();
        return bl;
    }

    private static void addOperLog(String procInfo) {
        try {
            AppLogInfo appLogInfo = new AppLogInfo();
            Long userId = Long.valueOf(RequestContext.get().getUserId());
            appLogInfo.setUserID(userId);
            appLogInfo.setOrgID(Long.valueOf(RequestContext.get().getOrgId()));
            appLogInfo.setOpDescription(procInfo);
            appLogInfo.setBizObjID(PERM_OLDADMINENABLE_ENTITY);
            try {
                appLogInfo.setBizAppID(BizAppServiceHelp.getAppIdByFormNum((String)PERM_OLDADMINENABLE_ENTITY));
            }
            catch (Throwable e) {
                appLogInfo.setBizAppID("0XWTKVOQW+ML");
            }
            appLogInfo.setClientType(RequestContext.get().getClient());
            appLogInfo.setClientIP(RequestContext.get().getLoginIP());
            appLogInfo.setOpName("btn_update");
            LogServiceHelper.addLog((AppLogInfo)appLogInfo);
        }
        catch (Throwable e) {
            logger.warn("\u5347\u7ea7\u65b0\u7ba1\u7406\u5458\u529f\u80fd\u8bb0\u5f55\u64cd\u4f5c\u65e5\u5fd7\u53d1\u751f\u5f02\u5e38\u3002", e);
        }
    }

    private static boolean checkHasDoneNewAdmin() {
        StringBuilder sql = new StringBuilder("select count(*) num  from ");
        sql.append(TABLE_T_PERM_ADMINGROUP);
        sql.append(" where fadminscheme is not null ");
        return (Boolean)DB.query((DBRoute)DBRoute.basedata, (String)sql.toString(), null, (ResultSetHandler)new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    Long num = rs.getLong("num");
                    if (num <= 0L) continue;
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
    }

    private static List<Map<String, Object>> getChildList(List<Map<String, Object>> parentList) {
        List parentIdList = parentList.stream().map(x -> (String)x.get("adminId")).collect(Collectors.toList());
        String parentIds = "'" + String.join((CharSequence)"','", parentIdList) + "'";
        StringBuilder sql = new StringBuilder("select a.fid, a.fadmintype, a.fparentid, a.flevel, a.fisleaf, a.fuserid, b.ftruename");
        sql.append(" from t_perm_admin a inner join t_sec_user_l b on a.fuserid = b.fid ");
        sql.append(" where a.fparentid in(").append(parentIds).append(") and b.flocaleid =?");
        sql.append(" order by a.fparentid asc, a.flevel asc, a.fid asc");
        Object[] params = new Object[]{RequestContext.get().getLang().name()};
        return (List)DB.query((DBRoute)DBRoute.basedata, (String)sql.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<List<Map<String, Object>>>(){

            public List<Map<String, Object>> handle(ResultSet rs) throws SQLException {
                ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(8);
                while (rs.next()) {
                    ConcurrentHashMap<String, Object> map = new ConcurrentHashMap<String, Object>(8);
                    map.put("adminId", rs.getString("fid"));
                    map.put("adminType", rs.getInt("fadmintype"));
                    map.put("adminParentId", rs.getString("fparentid"));
                    map.put("adminLevel", rs.getInt("flevel"));
                    map.put("adminIsLeaf", rs.getString("fisleaf"));
                    map.put("adminUserid", rs.getLong("fuserid"));
                    map.put("adminName", rs.getString("ftruename"));
                    list.add(map);
                }
                return list;
            }
        });
    }

    private static void recurAppendAdminList(List<Map<String, Object>> adminList, List<Map<String, Object>> parentList) {
        List<Map<String, Object>> childList = UpgradeAdminUtil.getChildList(parentList);
        if (CollectionUtils.isEmpty(childList)) {
            return;
        }
        adminList.addAll(childList);
        UpgradeAdminUtil.recurAppendAdminList(adminList, childList);
    }

    private static void appendAdminList(List<Map<String, Object>> adminList) {
        List<Map<String, Object>> childList = UpgradeAdminUtil.getChildList(adminList);
        if (CollectionUtils.isEmpty(childList)) {
            return;
        }
        adminList.addAll(childList);
        UpgradeAdminUtil.recurAppendAdminList(adminList, childList);
    }

    private static List<Map<String, Object>> getPermTopAdminList(Long adminschemeId) {
        final HashSet<Long> userIdSet = new HashSet<Long>(8);
        DB.query((DBRoute)DBRoute.basedata, (String)"select fuserid from t_perm_admin", null, (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    userIdSet.add(rs.getLong("fuserid"));
                }
                return null;
            }
        });
        final Map<Long, String> usersNameMap = UpgradeAdminUtil.getUserNames(userIdSet);
        StringBuilder sql = new StringBuilder("select d.fid, d.fadmintype, d.fparentid, d.flevel, d.fisleaf, d.fuserid, c.fid topAdminUserId");
        sql.append(" from t_perm_adminschemeentry a  ");
        sql.append(" inner join t_perm_admintype b on a.fadmintype  = b.fid");
        sql.append(" inner join t_perm_useradmintag c on c.fadmintag in (b.fid||'', b.fid||' ')");
        sql.append(" inner join t_perm_admin d on d.fuserid = c.fuserid");
        sql.append(" where a.fid = ? and b.fenable = '1' and b.fstatus ='C'");
        sql.append(" and not exists (select 1 from ").append(TABLE_T_PERM_ADMINGROUP).append(" e where e.fadminscheme = a.fid and e.fadmintype = a.fadmintype and e.foldadminid = (c.fuserid || ''))");
        sql.append(" order by d.fparentid asc, d.flevel asc, d.fid asc");
        Object[] params = new Object[]{adminschemeId};
        return (List)DB.query((DBRoute)DBRoute.basedata, (String)sql.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<List<Map<String, Object>>>(){

            public List<Map<String, Object>> handle(ResultSet rs) throws SQLException {
                ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(8);
                while (rs.next()) {
                    ConcurrentHashMap<String, Object> map = new ConcurrentHashMap<String, Object>(8);
                    map.put("adminId", rs.getString("fid"));
                    map.put("adminType", rs.getInt("fadmintype"));
                    map.put("adminParentId", rs.getString("fparentid"));
                    map.put("adminLevel", rs.getInt("flevel"));
                    map.put("adminIsLeaf", rs.getString("fisleaf"));
                    long fuserid = rs.getLong("fuserid");
                    map.put("adminUserid", fuserid);
                    map.put("adminName", usersNameMap.get(fuserid));
                    map.put("topAdminUserId", rs.getLong("topAdminUserId"));
                    list.add(map);
                }
                return list;
            }
        });
    }

    private static Map<Long, String> getUserNames(Set<Long> userIds) {
        HashMap<Long, String> usersNameMap = new HashMap<Long, String>(userIds.size());
        SqlBuilder queryUserInfoSql = new SqlBuilder().append("select t1.fid as userid, t1.fnumber as usernum, ", new Object[0]).append("case when t2.ftruename is null or t2.ftruename = '' or t2.ftruename = ' ' ", new Object[0]).append("then t1.fnumber ", new Object[0]).append("else t2.ftruename ", new Object[0]).append("end as truename ", new Object[0]).append("from t_sec_user t1 ", new Object[0]).append("left join t_sec_user_l t2 on(t1.fid=t2.fid and t2.flocaleid='zh_CN') ", new Object[0]).append("where ", new Object[0]);
        queryUserInfoSql.appendIn("t1.fid", new ArrayList<Long>(userIds));
        DB.query((DBRoute)DBRoute.permission, (SqlBuilder)queryUserInfoSql, rs -> {
            while (rs.next()) {
                Long userId = rs.getLong("userid");
                String userName = rs.getString("truename");
                usersNameMap.put(userId, userName);
            }
            return null;
        });
        return usersNameMap;
    }

    private static void handlePermAdminList(String upgradeModeStr, StringBuilder pProcessInfo, Long adminschemeId, List<Map<String, Object>> adminList) {
        Map<String, Integer> nameSizeMap = UpgradeAdminUtil.getNameSizeMap(adminschemeId);
        Long curUserId = RequestContext.get().getCurrUserId();
        int size = adminList.size();
        long[] newAdgFidArr = DB.genLongIds((String)TABLE_T_PERM_ADMINGROUP, (int)size);
        String langStr = RequestContext.get().getLang().name();
        for (int i = 0; i < size; ++i) {
            Map<String, Object> adminMap = adminList.get(i);
            try (TXHandle h = TX.required();){
                try {
                    String adminId = (String)adminMap.get("adminId");
                    Long adminUserid = (Long)adminMap.get("adminUserid");
                    Long topAdminUserId = (Long)adminMap.get("topAdminUserId");
                    long newAdgFid = newAdgFidArr[i];
                    Map<String, Object> adminGroupMap = UpgradeAdminUtil.insertPermAdmingroup(newAdgFid, adminMap, UpgradeAdminUtil.getFnumber(i), curUserId, adminschemeId, nameSizeMap);
                    UpgradeAdminUtil.insertPermAdmingroupL(adminGroupMap, langStr, adminUserid);
                    UpgradeAdminUtil.insertPermUseradmingroup(adminUserid, newAdgFid, topAdminUserId);
                    if (adminUserIdList.contains(adminUserid)) continue;
                    UpgradeAdminUtil.insertPermAdmingroupbizunit(adminId, newAdgFid);
                    UpgradeAdminUtil.insertPermAdmingrouporg(adminId, newAdgFid);
                    UpgradeAdminUtil.insertPermAdmingroupapp(adminId, newAdgFid);
                    UpgradeAdminUtil.insertPermAdmingroupadduser(adminId, newAdgFid);
                    continue;
                }
                catch (Exception e) {
                    logger.error("\u9010\u6761\u8fdb\u884c\u5347\u7ea7\u65b0\u7ba1\u7406\u5458\u529f\u80fd\uff0c\u5f02\u5e38", (Throwable)e);
                    h.markRollback();
                    pProcessInfo.append(e.getMessage());
                    UpgradeAdminUtil.addOperLog(upgradeModeStr + ", " + ResManager.loadKDString((String)"\u9010\u6761\u8fdb\u884c\u5347\u7ea7\u65b0\u7ba1\u7406\u5458\u529f\u80fd\uff0c\u5f02\u5e38", (String)"UpgradeAdminUtil_12", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    throw e;
                }
            }
        }
    }

    private static Map<String, Integer> getNameSizeMap(Long adminschemeId) {
        final HashMap<String, Integer> nameSizeMap = new HashMap<String, Integer>(8);
        StringBuilder sb = new StringBuilder();
        sb.append("select a.fname aName, b.fname bName");
        sb.append(" from t_perm_admingroup a ");
        sb.append(" inner join t_perm_admingroup_l b on a.fid =b.fid and b.flocaleid = ? ");
        sb.append(" where a.fadminscheme = ?");
        DB.query((DBRoute)DBRoute.basedata, (String)sb.toString(), (Object[])new Object[]{RequestContext.get().getLang().name(), adminschemeId}, (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws Exception {
                while (rs.next()) {
                    String aName = rs.getString("aName");
                    String bName = rs.getString("bName");
                    String adminGroupName = StringUtils.isEmpty((String)bName) ? aName : bName;
                    Integer size = (Integer)nameSizeMap.get(adminGroupName = adminGroupName.substring(0, adminGroupName.length() - 2));
                    if (null == size) {
                        nameSizeMap.put(adminGroupName, 1);
                        continue;
                    }
                    nameSizeMap.put(adminGroupName, size + 1);
                }
                return null;
            }
        });
        return nameSizeMap;
    }

    private static String getFnumber(int i) {
        DateTimeFormatter fmTime = DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS");
        LocalDateTime now = LocalDateTime.now();
        return now.format(fmTime) + i;
    }

    private static void insertPermAdmingroupadduser(String adminId, Long newAdgFid) {
        StringBuilder querySql = new StringBuilder("select distinct fuserid from t_perm_othermanageuser where fid = ? order by fuserid asc");
        Object[] queryParams = new Object[]{adminId};
        List list = (List)DB.query((DBRoute)DBRoute.basedata, (String)querySql.toString(), (Object[])queryParams, (ResultSetHandler)new ResultSetHandler<List<Long>>(){

            public List<Long> handle(ResultSet rs) throws SQLException {
                ArrayList<Long> innerList = new ArrayList<Long>(rs.getRow());
                while (rs.next()) {
                    innerList.add(rs.getLong("fuserid"));
                }
                return innerList;
            }
        });
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        StringBuilder insertSql = new StringBuilder("insert into ");
        insertSql.append(TABLE_T_PERM_ADMINGROUPADDUSER);
        insertSql.append(" (fid,fuserid,fusergroupid) values (?,?,?)");
        List insertParamsList = list.stream().map(x -> new Object[]{DB.genLongId((String)TABLE_T_PERM_ADMINGROUPADDUSER), x, newAdgFid}).collect(Collectors.toList());
        DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql.toString(), insertParamsList);
    }

    private static void insertPermAdmingroupapp(String adminId, Long newAdgFid) {
        StringBuilder querySql = new StringBuilder("select distinct fappid from t_perm_adminappentry where fid = ? order by fappid asc");
        Object[] queryParams = new Object[]{adminId};
        List list = (List)DB.query((DBRoute)DBRoute.basedata, (String)querySql.toString(), (Object[])queryParams, (ResultSetHandler)new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws SQLException {
                ArrayList<String> innerList = new ArrayList<String>(rs.getRow());
                while (rs.next()) {
                    innerList.add(rs.getString("fappid"));
                }
                return innerList;
            }
        });
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        StringBuilder insertSql = new StringBuilder("insert into ");
        insertSql.append(TABLE_T_PERM_ADMINGROUPAPP);
        insertSql.append(" (fid,fusergroupid,fappid) values (?,?,?)");
        List insertParamsList = list.stream().map(x -> new Object[]{DB.genLongId((String)TABLE_T_PERM_ADMINGROUPAPP), newAdgFid, x}).collect(Collectors.toList());
        DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql.toString(), insertParamsList);
    }

    private static void insertPermAdmingrouporg(String adminId, Long newAdgFid) {
        StringBuilder querySql = new StringBuilder();
        querySql.append("select distinct a.fadminorgid from t_perm_adminorgentry a");
        querySql.append(" where a.fid = ? and exists(select 1 from t_org_structure b where b.forgid = a.fadminorgid and b.fviewid=1) order by a.fadminorgid asc ");
        Object[] queryParams = new Object[]{adminId};
        List list = (List)DB.query((DBRoute)DBRoute.basedata, (String)querySql.toString(), (Object[])queryParams, (ResultSetHandler)new ResultSetHandler<List<Long>>(){

            public List<Long> handle(ResultSet rs) throws SQLException {
                ArrayList<Long> innerList = new ArrayList<Long>(rs.getRow());
                while (rs.next()) {
                    innerList.add(rs.getLong("fadminorgid"));
                }
                return innerList;
            }
        });
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        StringBuilder insertSql = new StringBuilder("insert into ");
        insertSql.append(TABLE_T_PERM_ADMINGROUPORG);
        insertSql.append(" (fid,fusergroupid,forgid) values (?,?,?)");
        List insertParamsList = list.stream().map(x -> new Object[]{DB.genLongId((String)TABLE_T_PERM_ADMINGROUPORG), newAdgFid, x}).collect(Collectors.toList());
        DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql.toString(), insertParamsList);
    }

    private static void insertPermAdmingroupbizunit(String adminId, Long newAdgFid) {
        StringBuilder querySql = new StringBuilder();
        querySql.append("select distinct a.fbizorgid from t_perm_adminbizentry a");
        querySql.append(" where a.fid = ? and exists(select 1 from t_org_structure b where b.forgid = a.fbizorgid and b.fviewid=15) order by a.fbizorgid asc ");
        Object[] queryParams = new Object[]{adminId};
        List list = (List)DB.query((DBRoute)DBRoute.basedata, (String)querySql.toString(), (Object[])queryParams, (ResultSetHandler)new ResultSetHandler<List<Long>>(){

            public List<Long> handle(ResultSet rs) throws SQLException {
                ArrayList<Long> innerList = new ArrayList<Long>(rs.getRow());
                while (rs.next()) {
                    innerList.add(rs.getLong("fbizorgid"));
                }
                return innerList;
            }
        });
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        StringBuilder insertSql = new StringBuilder("insert into ");
        insertSql.append(TABLE_T_PERM_ADMINGROUPBIZUNIT);
        insertSql.append(" (fid,fusergroupid,forgid) values (?,?,?)");
        List insertParamsList = list.stream().map(x -> new Object[]{DB.genLongId((String)TABLE_T_PERM_ADMINGROUPBIZUNIT), newAdgFid, x}).collect(Collectors.toList());
        DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql.toString(), insertParamsList);
    }

    private static void insertPermUseradmingroup(Long adminUserid, long newAdgFid, Long topAdminUserId) {
        StringBuilder sql = new StringBuilder("insert into ");
        sql.append(TABLE_T_PERM_USERADMINGROUP);
        sql.append(" (fid, fuserid, fadmingroupid) values (?,?,?)");
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(2);
        if (null != topAdminUserId && topAdminUserId > 0L) {
            Object[] obj1 = new Object[]{DB.genLongId((String)TABLE_T_PERM_USERADMINGROUP), topAdminUserId, newAdgFid};
            paramsList.add(obj1);
        }
        if (!adminUserid.equals(topAdminUserId)) {
            Object[] obj2 = new Object[]{DB.genLongId((String)TABLE_T_PERM_USERADMINGROUP), adminUserid, newAdgFid};
            paramsList.add(obj2);
        }
        DB.executeBatch((DBRoute)DBRoute.basedata, (String)sql.toString(), paramsList);
    }

    private static void insertPermAdmingroupL(Map<String, Object> adminGroupMap, String langStr, Long adminUserid) {
        Object fid = adminGroupMap.get("fid");
        Object fname = adminGroupMap.get("fname");
        StringBuilder sql = new StringBuilder("insert into ");
        sql.append(TABLE_T_PERM_ADMINGROUP_L);
        sql.append(" (fpkid, fid, flocaleid, fname, ffullname,fdescription) values (?,?,?,?,?,?)");
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        Object[] obj1 = new Object[]{DB.genStringId((String)TABLE_T_PERM_ADMINGROUP_L), fid, "zh_CN", fname, "", ""};
        paramsList.add(obj1);
        DB.executeBatch((DBRoute)DBRoute.basedata, (String)sql.toString(), paramsList);
        if (!Objects.equals(langStr, "en_US")) {
            Map<Long, String> userNames = UpgradeAdminUtil.getUserNames(Sets.newHashSet((Object[])new Long[]{adminUserid}));
            String userName = userNames.get(adminUserid);
            if (null == userName) {
                return;
            }
            sql.setLength(0);
            paramsList.clear();
            sql = new StringBuilder("insert into ");
            sql.append(TABLE_T_PERM_ADMINGROUP_L);
            sql.append(" (fpkid, fid, flocaleid, fname, ffullname,fdescription) values (?,?,?,?,?,?)");
            Object[] obj2 = new Object[]{DB.genStringId((String)TABLE_T_PERM_ADMINGROUP_L), fid, "en_US", userName + " group", "", ""};
            paramsList.add(obj2);
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)sql.toString(), paramsList);
        }
    }

    private static Map<String, Object> insertPermAdmingroup(long newAdgFid, Map<String, Object> adminMap, String fnumber, Long curUserId, Long adminschemeId, Map<String, Integer> nameSizeMap) {
        String adminParentId = (String)adminMap.get("adminParentId");
        String adminName = (String)adminMap.get("adminName");
        String adminId = (String)adminMap.get("adminId");
        String adminUserid = String.valueOf((Long)adminMap.get("adminUserid"));
        Integer adminType = (Integer)adminMap.get("adminType");
        StringBuilder sql = new StringBuilder("insert into ");
        sql.append(TABLE_T_PERM_ADMINGROUP);
        sql.append(" (fid, fmasterid, fnumber,flevel,flongnumber,fisleaf,fparentid,fenable,fstatus,fcreatorid,fcreatetime,fmodifierid,fmodifytime,fdisablerid,fname,ffullname, fdescription, fadminscheme, fadmintype, foldadminid, foldadminfid) values ( ");
        sql.append(newAdgFid).append(',');
        sql.append(newAdgFid).append(',');
        sql.append('\'').append(fnumber).append("',");
        String newFlongnumber = "";
        Long newParentId = 0L;
        Integer newLevel = 1;
        Map<String, Object> ParentNewRecordMap = UpgradeAdminUtil.getParentNewRecord(adminParentId);
        if (CollectionUtils.isEmpty(ParentNewRecordMap)) {
            newFlongnumber = fnumber;
        } else {
            newFlongnumber = ParentNewRecordMap.get("parentFlongnumber") + "." + fnumber;
            newParentId = (Long)ParentNewRecordMap.get("parentFid");
            newLevel = (Integer)ParentNewRecordMap.get("parentFlevel") + 1;
        }
        sql.append(newLevel).append(',');
        sql.append('\'').append(newFlongnumber).append("',");
        String adminIsLeaf = UpgradeAdminUtil.getIsLeaf(adminId);
        sql.append('\'').append(adminIsLeaf).append("',");
        sql.append(newParentId).append(",");
        sql.append("'1',");
        sql.append("'C',");
        sql.append(curUserId).append(',');
        sql.append("now(),");
        sql.append(curUserId).append(',');
        sql.append("now(),");
        sql.append("0,");
        Integer nameSize = nameSizeMap.get(adminName);
        if (null == nameSize || 0 == nameSize) {
            nameSizeMap.put(adminName, 1);
            adminName = adminName + ConstantsHelper.getFz();
        } else {
            nameSize = nameSize + 1;
            nameSizeMap.put(adminName, nameSize);
            nameSizeMap.put(adminName + "_" + nameSize, 1);
            adminName = adminName + "_" + nameSize + ConstantsHelper.getFz();
        }
        sql.append('\'').append(adminName).append("',");
        sql.append("' ',");
        sql.append("' ',");
        sql.append(adminschemeId).append(',');
        sql.append(adminType).append(',');
        sql.append('\'').append(adminUserid).append('\'').append(',');
        sql.append('\'').append(adminId).append('\'');
        sql.append(')');
        DB.execute((DBRoute)DBRoute.basedata, (String)sql.toString());
        ConcurrentHashMap<String, Object> map = new ConcurrentHashMap<String, Object>(4);
        map.put("fid", newAdgFid);
        map.put("fname", adminName);
        return map;
    }

    private static String getIsLeaf(String oldAdminId) {
        StringBuilder sql = new StringBuilder("select fid from t_perm_admin where fparentid = ? ");
        Object[] params = new Object[]{oldAdminId};
        return (String)DB.query((DBRoute)DBRoute.basedata, (String)sql.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<String>(){

            public String handle(ResultSet rs) throws SQLException {
                return rs.next() ? "0" : "1";
            }
        });
    }

    private static Map<String, Object> getParentNewRecord(String oldParentId) {
        StringBuilder sql = new StringBuilder("select fid, flongnumber, ffullname, flevel from ").append(TABLE_T_PERM_ADMINGROUP);
        sql.append(" where foldadminfid = ? ");
        Object[] params = new Object[]{oldParentId};
        return (Map)DB.query((DBRoute)DBRoute.basedata, (String)sql.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<Map<String, Object>>(){

            public Map<String, Object> handle(ResultSet rs) throws SQLException {
                ConcurrentHashMap<String, Object> map = new ConcurrentHashMap<String, Object>(4);
                while (rs.next()) {
                    map.put("parentFid", rs.getLong("fid"));
                    map.put("parentFlongnumber", rs.getString("flongnumber"));
                    map.put("parentFfullname", rs.getString("ffullname"));
                    map.put("parentFlevel", rs.getInt("flevel"));
                }
                return map;
            }
        });
    }

    private static List<Long> getAdminscheme() {
        StringBuilder sql = new StringBuilder("select fid from t_perm_adminscheme where fenable = ? and fstatus =?");
        Object[] params = new Object[]{Character.valueOf('1'), Character.valueOf('C')};
        return (List)DB.query((DBRoute)DBRoute.basedata, (String)sql.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<List<Long>>(){

            public List<Long> handle(ResultSet rs) throws SQLException {
                ArrayList<Long> list = new ArrayList<Long>(1);
                while (rs.next()) {
                    list.add(rs.getLong("fid"));
                }
                return list;
            }
        });
    }

    private static void delAllNewAdmin() {
        String deleteAdminSql0 = "delete from t_perm_useradmingroup where fadmingroupid in(select fid from t_perm_admingroup)";
        String deleteAdminSql1 = "delete from t_perm_admingroup_l where fid in(select fid from t_perm_admingroup)";
        String deleteAdminSql2 = "truncate table t_perm_admingroup";
        String deleteAdminSql3 = "truncate table t_perm_admingroupbizunit";
        String deleteAdminSql4 = "truncate table t_perm_admingrouporg";
        String deleteAdminSql5 = "truncate table t_perm_admingroupapp";
        String deleteAdminSql6 = "truncate table t_perm_admingroupadduser";
        String deleteAdminSql7 = "truncate table t_perm_admingroupfunperm";
        DB.execute((DBRoute)DBRoute.basedata, (String)deleteAdminSql0);
        DB.execute((DBRoute)DBRoute.basedata, (String)deleteAdminSql1);
        DB.execute((DBRoute)DBRoute.basedata, (String)deleteAdminSql2);
        DB.execute((DBRoute)DBRoute.basedata, (String)deleteAdminSql3);
        DB.execute((DBRoute)DBRoute.basedata, (String)deleteAdminSql4);
        DB.execute((DBRoute)DBRoute.basedata, (String)deleteAdminSql5);
        DB.execute((DBRoute)DBRoute.basedata, (String)deleteAdminSql6);
        DB.execute((DBRoute)DBRoute.basedata, (String)deleteAdminSql7);
    }

    public static Map<String, Object> loadFromDB() {
        StringBuilder querySql = new StringBuilder("select fid, fenable from t_perm_oldadminenable where fid = 1");
        Map map = (Map)DB.query((DBRoute)DBRoute.basedata, (String)querySql.toString(), null, (ResultSetHandler)new ResultSetHandler<Map<String, Object>>(){

            public Map<String, Object> handle(ResultSet rs) throws SQLException {
                ConcurrentHashMap<String, Object> innerMap = new ConcurrentHashMap<String, Object>(2);
                while (rs.next()) {
                    innerMap.put("fid", rs.getLong("fid"));
                    innerMap.put("fenable", rs.getString("fenable"));
                }
                return innerMap;
            }
        });
        if (CollectionUtils.isEmpty((Map)map)) {
            StringBuilder sql = new StringBuilder("insert into t_perm_oldadminenable");
            sql.append(" (fid, fenable,fmodifytime, fmodifierid) values ( ");
            sql.append(1L).append(',');
            sql.append("'1',");
            sql.append("now(),");
            sql.append(Long.valueOf(RequestContext.get().getUserId()));
            sql.append(')');
            DB.execute((DBRoute)DBRoute.basedata, (String)sql.toString());
            map.put("fid", 1L);
            map.put("fenable", "1");
        }
        return map;
    }

    private static void enableNewAdmin() {
        Map<String, Object> enableMap = UpgradeAdminUtil.loadFromDB();
        StringBuilder sql = new StringBuilder("update t_perm_oldadminenable set fmodifytime = now(), ");
        sql.append("fmodifierid=").append((Object)RequestContext.get().getCurrUserId()).append(", ");
        sql.append("fenable = ").append("'0'");
        sql.append(" where fid= ").append(enableMap.get("fid"));
        DB.execute((DBRoute)DBRoute.basedata, (String)sql.toString());
    }
}

