/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.cache.util;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.DataRuleCache;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.model.DataRuleInfo;
import kd.bos.permission.model.PermResult;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.portal.InitailVersionServiceHelper;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class UpgradeRoleDataRuleNewModelUtil {
    private static final Log logger = LogFactory.getLog(UpgradeRoleDataRuleNewModelUtil.class);
    private static final String SPLIT_STR = "!!";
    public static final int UPGRADE_MODE_MANUAL = 0;
    public static final int UPGRADE_MODE_AUTO = 1;
    private static final String SYSTEM_TYPE = "bos-permission-cache";

    public static PermResult upgrade(int upgradeMode) throws Exception {
        StringBuilder pProcessInfo = new StringBuilder();
        if (1 == upgradeMode) {
            boolean initVersion7 = InitailVersionServiceHelper.isInitailVersion((int)7);
            boolean isGalaxyProduct = PermCommonUtil.isGalaxyProduct();
            if (initVersion7 && !isGalaxyProduct) {
                UpgradeRoleDataRuleNewModelUtil.enableRoleNewDrNewModel();
                return PermResult.ok((StringBuilder)pProcessInfo);
            }
        }
        boolean enablNewDataRule = !PermCommonUtil.hasEnableOldDataRule();
        boolean enableRoleDataRuleNewModel = PermCommonUtil.hasEnableRoleDataRuleNewModel();
        if (enablNewDataRule && enableRoleDataRuleNewModel) {
            String finishInfo = ResManager.loadKDString((String)"\u5f53\u524d\u5df2\u542f\u7528\u65b0\u6570\u636e\u89c4\u5219\uff0c\u4ee5\u53ca\u901a\u7528\u89d2\u8272\u65b0\u6570\u636e\u89c4\u5219\u7684\u65b0\u6a21\u578b\uff0c\u65e0\u5347\u7ea7\u5904\u7406\u3002", (String)"UpgradRoleDataRuleNewModelUtil_0", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            pProcessInfo.append(finishInfo);
            return PermResult.ok((StringBuilder)pProcessInfo);
        }
        boolean upgradeResult = false;
        upgradeResult = enablNewDataRule ? UpgradeRoleDataRuleNewModelUtil.upgradeInNewDataRuleMode(upgradeMode, pProcessInfo) : UpgradeRoleDataRuleNewModelUtil.upgradeInOldDataRuleMode(upgradeMode, pProcessInfo);
        return upgradeResult ? PermResult.ok((StringBuilder)pProcessInfo) : PermResult.fail((StringBuilder)pProcessInfo);
    }

    private static boolean upgradeInNewDataRuleMode(int upgradeMode, StringBuilder pProcessInfo) {
        boolean existUserOldDr = UpgradeRoleDataRuleNewModelUtil.existsUserOldDataRuleData(upgradeMode);
        boolean existRoleOldDrOldMdlData = UpgradeRoleDataRuleNewModelUtil.existsRoleNewDrOldModeData();
        if (!existUserOldDr && !existRoleOldDrOldMdlData) {
            UpgradeRoleDataRuleNewModelUtil.enableRoleNewDrNewModel();
            return true;
        }
        Throwable throwable = null;
        try (TXHandle txHandle = TX.required();){
            Map<String, String> allAppInfo = UpgradeRoleDataRuleNewModelUtil.getAllAppInfo();
            Map<String, String> allEntInfo = UpgradeRoleDataRuleNewModelUtil.getAllEntInfo();
            boolean upgradeUserOldDrStatus = false;
            if (existUserOldDr) {
                boolean validUserOldDr = UpgradeRoleDataRuleNewModelUtil.checkUserOldDr(pProcessInfo);
                if (!validUserOldDr) {
                    boolean bl = false;
                    return bl;
                }
                upgradeUserOldDrStatus = UpgradeRoleDataRuleNewModelUtil.upgradeUserOldDr(pProcessInfo, allAppInfo, allEntInfo);
            } else {
                upgradeUserOldDrStatus = true;
            }
            boolean upgradeRoleOldDrStatus = false;
            if (existRoleOldDrOldMdlData) {
                boolean validRoleNewDrOldMdl = UpgradeRoleDataRuleNewModelUtil.checkRoleNewDrOldMdl(pProcessInfo);
                if (!validRoleNewDrOldMdl) {
                    boolean bl = false;
                    return bl;
                }
                upgradeRoleOldDrStatus = UpgradeRoleDataRuleNewModelUtil.upgradeRoleNewDrOldMdlToNewMdl(pProcessInfo);
            } else {
                upgradeRoleOldDrStatus = true;
            }
            if (upgradeUserOldDrStatus && upgradeRoleOldDrStatus) {
                UpgradeRoleDataRuleNewModelUtil.enableRoleNewDrNewModel();
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            txHandle.markRollback();
            logger.error("UpgradRoleDataRuleNewModelUtil.upgradeInNewDataRuleMode error", (Throwable)e);
            pProcessInfo.append(e.getMessage());
            boolean bl = false;
            return bl;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        return false;
    }

    private static boolean upgradeRoleNewDrOldMdlToNewMdl(StringBuilder pProcessInfo) {
        final Long userId = RequestContext.get().getCurrUserId();
        final HashSet roleIds = new HashSet(8);
        String allPermRuleSql = "select rdrs.froleid roleid, drse.fbizappid appid, drse.fentitynum entitynum, dre.fpermitemid permitemid, dr.fid drrule from t_perm_roledatarules rdrs join t_perm_datarules_entry drse on (rdrs.fdatarulesid = drse.fid) join t_perm_datarule_entry dre on (drse.fdataruleid = dre.fid) join t_perm_datarule dr on (dre.fdataruleid = dr.fid and dr.fisdetail = '1' ) inner join t_perm_role r on (rdrs.froleid = r.fid) where r.fgroupid <> '3G8DIP1FPT8X' and rdrs.fisupdate = '0' ";
        final ArrayList rolePermRuleInsParamList = new ArrayList(8);
        DB.query((DBRoute)DBRoute.permission, (String)allPermRuleSql, null, (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    String roleId = rs.getString("roleid");
                    String appId = rs.getString("appid");
                    String entityNum = rs.getString("entitynum");
                    String permItemId = rs.getString("permitemid");
                    Long drRuleId = rs.getLong("drrule");
                    roleIds.add(roleId);
                    rolePermRuleInsParamList.add(new Object[]{roleId, appId, entityNum, permItemId, drRuleId, userId, new Date()});
                }
                return null;
            }
        });
        String allPropRuleSql = "select rdrs.froleid roleid, drse.fbizappid appid, drse.fentitynum entitynum, drp.fpropkey propkey, drp.fpropentnum propentnum, dr.fid drrule from t_perm_roledatarules rdrs join t_perm_datarules_entry drse on (rdrs.fdatarulesid = drse.fid) join t_perm_datarule_prop drp on (drse.fdataruleid = drp.fid) join t_perm_datarule dr on (drp.fdataruleid = dr.fid and dr.fisdetail = '1') inner join t_perm_role r on (rdrs.froleid = r.fid) where r.fgroupid <> '3G8DIP1FPT8X' and rdrs.fisupdate = '0' ";
        final ArrayList rolePropRuleInsParamList = new ArrayList(8);
        DB.query((DBRoute)DBRoute.permission, (String)allPropRuleSql, null, (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    String roleId = rs.getString("roleid");
                    String appId = rs.getString("appid");
                    String entityNum = rs.getString("entitynum");
                    String propkey = rs.getString("propkey");
                    String propentnum = rs.getString("propentnum");
                    Long drRuleId = rs.getLong("drrule");
                    roleIds.add(roleId);
                    rolePropRuleInsParamList.add(new Object[]{roleId, appId, entityNum, propkey, propentnum, drRuleId, userId, new Date()});
                }
                return null;
            }
        });
        Throwable throwable = null;
        try (TXHandle h = TX.required();){
            Object[] objArr;
            long[] genLongIds;
            if (!rolePermRuleInsParamList.isEmpty()) {
                genLongIds = DB.genLongIds((String)"t_perm_roledatarule", (int)rolePermRuleInsParamList.size());
                ArrayList<Object[]> rolePermRuleInsParamList2 = new ArrayList<Object[]>(8);
                for (int i = 0; i < rolePermRuleInsParamList.size(); ++i) {
                    objArr = (Object[])rolePermRuleInsParamList.get(i);
                    rolePermRuleInsParamList2.add(new Object[]{genLongIds[i], objArr[0], objArr[1], objArr[2], objArr[3], objArr[4], objArr[5], objArr[6]});
                }
                String sql = "insert into t_perm_roledatarule(fid, froleid, fappid, fentitynum, fpermitemid, fdataruleid, fcreatorid, fcreatetime) values (?,?,?,?,?,?,?,?) ";
                DB.executeBatch((DBRoute)DBRoute.permission, (String)sql, rolePermRuleInsParamList2);
            }
            if (!rolePropRuleInsParamList.isEmpty()) {
                genLongIds = DB.genLongIds((String)"t_perm_roledatarule_prop", (int)rolePropRuleInsParamList.size());
                ArrayList<Object[]> rolePropRuleInsParamList2 = new ArrayList<Object[]>(8);
                for (int i = 0; i < rolePropRuleInsParamList.size(); ++i) {
                    objArr = (Object[])rolePropRuleInsParamList.get(i);
                    rolePropRuleInsParamList2.add(new Object[]{genLongIds[i], objArr[0], objArr[1], objArr[2], objArr[3], objArr[4], objArr[5], objArr[6], objArr[7]});
                }
                String sql = "insert into t_perm_roledatarule_prop(fid, froleid, fappid, fentitynum, fpropkey, fpropentnum, fdataruleid, fcreatorid, fcreatetime) values (?,?,?,?,?,?,?,?,?) ";
                DB.executeBatch((DBRoute)DBRoute.permission, (String)sql, rolePropRuleInsParamList2);
            }
            if (roleIds != null && !roleIds.isEmpty()) {
                SqlBuilder sqlBuilder = new SqlBuilder();
                sqlBuilder.append("update t_perm_roledatarules set fisupdate = '1' where ", new Object[0]);
                sqlBuilder.appendIn("froleid", new ArrayList(roleIds));
                DB.execute((DBRoute)DBRoute.permission, (SqlBuilder)sqlBuilder);
            }
            boolean sqlBuilder = true;
            return sqlBuilder;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            pProcessInfo.append(e.getMessage());
            h.markRollback();
            boolean bl = false;
            return bl;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }

    private static boolean checkRoleNewDrOldMdl(StringBuilder pProcessInfo) {
        return true;
    }

    private static boolean upgradeInOldDataRuleMode(int upgradeMode, StringBuilder pProcessInfo) {
        UpgradeRoleDataRuleNewModelUtil.clearRedundantDataInOldDrMode();
        boolean existUserOldDr = UpgradeRoleDataRuleNewModelUtil.existsUserOldDataRuleData(upgradeMode);
        boolean existRoleOldDr = UpgradeRoleDataRuleNewModelUtil.existsRoleOldDataRuleData(upgradeMode);
        if (!existUserOldDr && !existRoleOldDr) {
            UpgradeRoleDataRuleNewModelUtil.enableRoleNewDrNewModel();
            return true;
        }
        Throwable throwable = null;
        try (TXHandle txHandle = TX.required();){
            Map<String, String> allAppInfo = UpgradeRoleDataRuleNewModelUtil.getAllAppInfo();
            Map<String, String> allEntInfo = UpgradeRoleDataRuleNewModelUtil.getAllEntInfo();
            boolean upgradeUserOldDrStatus = false;
            if (existUserOldDr) {
                boolean validUserOldDr = UpgradeRoleDataRuleNewModelUtil.checkUserOldDr(pProcessInfo);
                if (!validUserOldDr) {
                    boolean bl = false;
                    return bl;
                }
                upgradeUserOldDrStatus = UpgradeRoleDataRuleNewModelUtil.upgradeUserOldDr(pProcessInfo, allAppInfo, allEntInfo);
            } else {
                upgradeUserOldDrStatus = true;
            }
            boolean upgradeRoleOldDrStatus = false;
            if (existRoleOldDr) {
                boolean validRoleOldDr = UpgradeRoleDataRuleNewModelUtil.checkRoleOldDr(pProcessInfo);
                if (!validRoleOldDr) {
                    boolean bl = false;
                    return bl;
                }
                upgradeRoleOldDrStatus = UpgradeRoleDataRuleNewModelUtil.upgradeRoleOldDr(pProcessInfo, allAppInfo, allEntInfo);
            } else {
                upgradeRoleOldDrStatus = true;
            }
            if (upgradeUserOldDrStatus && upgradeRoleOldDrStatus) {
                UpgradeRoleDataRuleNewModelUtil.enableRoleNewDrNewModel();
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            txHandle.markRollback();
            logger.error("UpgradRoleDataRuleNewModelUtil.upgradeInOldDataRuleMode error", (Throwable)e);
            pProcessInfo.append(e.getMessage());
            boolean bl = false;
            return bl;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        return false;
    }

    private static boolean checkUserOldDr(StringBuilder pProcessInfo) {
        return true;
    }

    private static boolean checkRoleOldDr(StringBuilder pProcessInfo) {
        return true;
    }

    private static boolean existsUserOldDataRuleData(int upgradeMode) {
        String userSql = "select count(fid) userdrcount from t_perm_userdataperm ";
        if (1 != upgradeMode) {
            userSql = userSql + " where fisupdate = '0' ";
        }
        Long userDrCount = (Long)DB.query((DBRoute)DBRoute.permission, (String)userSql, null, (ResultSetHandler)new ResultSetHandler<Long>(){

            public Long handle(ResultSet rs) throws SQLException {
                Long count = 0L;
                if (rs.next()) {
                    count = rs.getLong("userdrcount");
                }
                return count;
            }
        });
        boolean userDrExist = false;
        if (userDrCount != null && userDrCount != 0L) {
            userDrExist = true;
        }
        return userDrExist;
    }

    private static boolean existsRoleOldDataRuleData(int upgradeMode) {
        String roleSql = "select count(fid) roledrcount from t_perm_roledataperm ";
        if (1 != upgradeMode) {
            roleSql = roleSql + " where fisupdate = '0' ";
        }
        Long roleDrCount = (Long)DB.query((DBRoute)DBRoute.permission, (String)roleSql, null, (ResultSetHandler)new ResultSetHandler<Long>(){

            public Long handle(ResultSet rs) throws SQLException {
                Long count = 0L;
                if (rs.next()) {
                    count = rs.getLong("roledrcount");
                }
                return count;
            }
        });
        boolean roleDrExist = false;
        if (roleDrCount != null && roleDrCount != 0L) {
            roleDrExist = true;
        }
        return roleDrExist;
    }

    private static boolean existsRoleNewDrOldModeData() {
        String roleSql = "select count(rdrs.fid) roledrcount from t_perm_roledatarules rdrs inner join t_perm_role r on (rdrs.froleid = r.fid) where r.fgroupid <> '3G8DIP1FPT8X' and rdrs.fisupdate = '0' ";
        Long roleDrCount = (Long)DB.query((DBRoute)DBRoute.permission, (String)roleSql, null, (ResultSetHandler)new ResultSetHandler<Long>(){

            public Long handle(ResultSet rs) throws SQLException {
                Long count = 0L;
                if (rs.next()) {
                    count = rs.getLong("roledrcount");
                }
                return count;
            }
        });
        boolean roleDrOldMdlExist = false;
        if (roleDrCount != null && roleDrCount != 0L) {
            roleDrOldMdlExist = true;
        }
        return roleDrOldMdlExist;
    }

    private static void clearRedundantDataInOldDrMode() {
        String delRedundantDataPermSql = "delete from t_perm_dataperm where fid not in (select fid from t_perm_datapermentry) ";
        String delRedundantRoleDataPermSql = "delete from t_perm_roledataperm where fdatapermid not in(select fid from t_perm_dataperm) ";
        String delRedundantUserDataPermSql = "delete from t_perm_userdataperm where fdatapermid not in(select fid from t_perm_dataperm) ";
        DB.execute((DBRoute)DBRoute.permission, (String)delRedundantDataPermSql);
        DB.execute((DBRoute)DBRoute.permission, (String)delRedundantRoleDataPermSql);
        DB.execute((DBRoute)DBRoute.permission, (String)delRedundantUserDataPermSql);
    }

    private static boolean upgradeRoleOldDr(StringBuilder pProcessInfo, Map<String, String> appInfo, Map<String, String> entInfo) throws Exception {
        boolean upgradeState = false;
        Long userId = RequestContext.get().getCurrUserId();
        String langName = RequestContext.get().getLang().name();
        StringBuilder sbDataPermEntrySelSql = new StringBuilder("select rdp.froleid roleid, dpe.fentitytypeid entnum, dpe.fbizappid appid, dpe.frule datarule ").append(" from t_perm_roledataperm rdp").append(" inner join t_perm_datapermentry dpe on (rdp.fdatapermid = dpe.fid) ").append(" where rdp.fisupdate = '0' ").append(" order by roleid,appid,entnum ");
        final HashSet forUpdateRoleIds = new HashSet(8);
        final HashMap roleDataPermInfoMap = new HashMap();
        DB.query((DBRoute)DBRoute.permission, (String)sbDataPermEntrySelSql.toString(), null, (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    String roleId = rs.getString("roleid");
                    String entNum = rs.getString("entnum");
                    String appId = rs.getString("appid");
                    String rule = rs.getString("datarule");
                    if (StringUtils.isEmpty((String)entNum) || StringUtils.isEmpty((String)appId) || StringUtils.isEmpty((String)rule)) continue;
                    forUpdateRoleIds.add(roleId);
                    roleDataPermInfoMap.computeIfAbsent(roleId, k -> new HashMap()).put(entNum + UpgradeRoleDataRuleNewModelUtil.SPLIT_STR + appId, rule);
                }
                return null;
            }
        });
        ArrayList<Object[]> insertRoleDataRuleParamList = new ArrayList<Object[]>(8);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        int index = 0;
        for (Map.Entry roleEntry : roleDataPermInfoMap.entrySet()) {
            String roleId = (String)roleEntry.getKey();
            Map roleDataPermInfo = (Map)roleEntry.getValue();
            try {
                for (Map.Entry ruleEntry : roleDataPermInfo.entrySet()) {
                    String appId;
                    String appName;
                    ++index;
                    String entityNumAndAppIdStr = (String)ruleEntry.getKey();
                    String rule = (String)ruleEntry.getValue();
                    String entityNum = entityNumAndAppIdStr.split(SPLIT_STR)[0];
                    String entityName = entInfo.get(entityNum);
                    if (StringUtils.isEmpty((String)entityName)) {
                        entityName = entityNum;
                    }
                    if (StringUtils.isEmpty((String)(appName = appInfo.get(appId = entityNumAndAppIdStr.split(SPLIT_STR)[1])))) {
                        appName = appId;
                    }
                    String detailDateStr = sdf.format(new Date());
                    StringBuilder newDetailDataRuleProcessInfo = new StringBuilder();
                    DataRuleInfo detailDataRuleInfo = new DataRuleInfo();
                    detailDataRuleInfo.setAppId(appId);
                    detailDataRuleInfo.setEntityNum(entityNum);
                    detailDataRuleInfo.setDescription(detailDateStr + ResManager.loadKDString((String)"\u5347\u7ea7\u65f6\u4ea7\u751f\u7684\u89c4\u5219", (String)"UpgradeDataRuleUtil_5", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    detailDataRuleInfo.setDetail(true);
                    detailDataRuleInfo.setEnable(Boolean.TRUE);
                    String detailDataRuleNum = roleId + "_" + appId + "_" + entityNum + "_" + detailDateStr + "_" + index;
                    String detailDataRuleName = roleId + "_" + appName + "_" + entityName + "_" + detailDateStr + "_" + index;
                    detailDataRuleInfo.setNumber(detailDataRuleNum);
                    detailDataRuleInfo.setName((ILocaleString)new LocaleString(langName, detailDataRuleName));
                    FilterCondition fc = (FilterCondition)SerializationUtils.fromJsonString((String)rule, FilterCondition.class);
                    detailDataRuleInfo.setRule(fc);
                    boolean newDetailDataRule = DataRuleCache.newDataRule(detailDataRuleInfo, newDetailDataRuleProcessInfo);
                    if (!newDetailDataRule) {
                        throw new KDBizException(new ErrorCode("0", newDetailDataRuleProcessInfo.toString()), new Object[0]);
                    }
                    Long dataRuleId = detailDataRuleInfo.getId();
                    insertRoleDataRuleParamList.add(new Object[]{roleId, appId, entityNum, "47150e89000000ac", dataRuleId, userId, new Date()});
                }
            }
            catch (Exception e) {
                pProcessInfo.append(e.getMessage());
                upgradeState = false;
                throw e;
            }
        }
        if (!insertRoleDataRuleParamList.isEmpty()) {
            long[] genLongIds = DB.genLongIds((String)"t_perm_roledatarule", (int)insertRoleDataRuleParamList.size());
            ArrayList<Object[]> insertRoleDataRuleParamList2 = new ArrayList<Object[]>(8);
            for (int i = 0; i < insertRoleDataRuleParamList.size(); ++i) {
                Object[] objArr = (Object[])insertRoleDataRuleParamList.get(i);
                insertRoleDataRuleParamList2.add(new Object[]{genLongIds[i], objArr[0], objArr[1], objArr[2], objArr[3], objArr[4], objArr[5], objArr[6]});
            }
            String insertRoleDataPermSql = "insert into t_perm_roledatarule(fid,froleid, fappid, fentitynum, fpermitemid, fdataruleid, fcreatorid, fcreatetime) values (?,?,?,?,?,?,?,?) ";
            DB.executeBatch((DBRoute)DBRoute.permission, (String)insertRoleDataPermSql, insertRoleDataRuleParamList2);
        }
        if (forUpdateRoleIds != null && !forUpdateRoleIds.isEmpty()) {
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append("update t_perm_roledataperm set fisupdate = '1' where ", new Object[0]);
            sqlBuilder.appendIn("froleid", new ArrayList(forUpdateRoleIds));
            DB.execute((DBRoute)DBRoute.permission, (SqlBuilder)sqlBuilder);
        }
        upgradeState = true;
        return upgradeState;
    }

    private static void enableRoleNewDrNewModel() {
        String updateSql = "update t_perm_olddataruleenable set fenable = '0', fisnewmodel  = '1' where fid = 1 ";
        DB.execute((DBRoute)DBRoute.permission, (String)updateSql);
        PermissionServiceHelper.clearAllCache();
    }

    private static boolean upgradeUserOldDr(StringBuilder pProcessInfo, Map<String, String> appInfo, Map<String, String> entInfo) {
        boolean upgradeState = false;
        Long updatorId = RequestContext.get().getCurrUserId();
        String langName = RequestContext.get().getLang().name();
        String sql = "SELECT fid, fuserid, fdatapermid, forgid, fdimtype, fisincludesuborg FROM t_perm_userdataperm t1 WHERE fisupdate = '0' ";
        final HashMap userDataPermIdAndUserDataPermInfoMap = new HashMap();
        DB.query((DBRoute)DBRoute.permission, (String)sql, null, (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    String userDatapermId = rs.getString("fid");
                    Long userId = rs.getLong("fuserid");
                    String datapermId = rs.getString("fdatapermid");
                    Long orgId = rs.getLong("forgid");
                    String dimType = rs.getString("fdimtype");
                    boolean isincludeSub = rs.getBoolean("fisincludesuborg");
                    if (StringUtils.isEmpty((String)userDatapermId) || userId == null || userId == 0L || orgId == null || orgId == 0L || StringUtils.isEmpty((String)datapermId)) continue;
                    userDataPermIdAndUserDataPermInfoMap.put(userDatapermId, new Object[]{userId, dimType, orgId, isincludeSub, datapermId});
                }
                return null;
            }
        });
        if (CollectionUtils.isEmpty(userDataPermIdAndUserDataPermInfoMap)) {
            pProcessInfo.append(ResManager.loadKDString((String)"\u201c\u7528\u6237\u65e7\u6570\u636e\u89c4\u5219\u201d\u6ca1\u6709\u9700\u8981\u5904\u7406\u7684\u6570\u636e\u3002", (String)"UpgradeDataRuleUtil_4", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            upgradeState = true;
            return upgradeState;
        }
        StringBuilder sbUserDataPermIds = new StringBuilder();
        for (String userDataPermId : userDataPermIdAndUserDataPermInfoMap.keySet()) {
            sbUserDataPermIds.append('\'').append(userDataPermId).append('\'').append(",");
        }
        if (sbUserDataPermIds.lastIndexOf(",") == sbUserDataPermIds.length() - 1) {
            sbUserDataPermIds.deleteCharAt(sbUserDataPermIds.length() - 1);
        }
        StringBuilder sbDataPermEntrySelSql = new StringBuilder("select udp.fid udpid, dpe.fid datapermid, dpe.fentitytypeid entnum, dpe.fbizappid appid, dpe.frule datarule ").append(" from t_perm_datapermentry dpe ").append(" inner join t_perm_userdataperm udp on (udp.fdatapermid = dpe.fid) ").append(" where udp.fid in (").append((CharSequence)sbUserDataPermIds).append(") ").append(" order by udpid, datapermid, entnum, appid ");
        final HashMap userDataPermInfoMap = new HashMap();
        DB.query((DBRoute)DBRoute.permission, (String)sbDataPermEntrySelSql.toString(), null, (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    String userDataPermId = rs.getString("udpid");
                    String entNum = rs.getString("entnum");
                    String appId = rs.getString("appid");
                    String rule = rs.getString("datarule");
                    if (StringUtils.isEmpty((String)entNum) || StringUtils.isEmpty((String)appId) || StringUtils.isEmpty((String)rule)) continue;
                    userDataPermInfoMap.computeIfAbsent(userDataPermId, k -> new HashMap()).put(entNum + UpgradeRoleDataRuleNewModelUtil.SPLIT_STR + appId, rule);
                }
                return null;
            }
        });
        HashMap<String, String> dimTypeMap = new HashMap<String, String>(8);
        ArrayList<Object[]> updateOldDataPermParamList = new ArrayList<Object[]>(8);
        ArrayList<Object[]> newParamList = new ArrayList<Object[]>(8);
        try {
            int index = 0;
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
            for (Map.Entry userEntry : userDataPermInfoMap.entrySet()) {
                String userDataPermId = (String)userEntry.getKey();
                Map userDataPermInfo = (Map)userEntry.getValue();
                Object[] userPermInfo = (Object[])userDataPermIdAndUserDataPermInfoMap.get(userDataPermId);
                Long userId = (Long)userPermInfo[0];
                String dimType = (String)userPermInfo[1];
                Long dimObjId = (Long)userPermInfo[2];
                boolean isIncludeSub = (Boolean)userPermInfo[3];
                String suitableDimType = (String)dimTypeMap.get(dimType);
                if (StringUtils.isEmpty((String)suitableDimType)) {
                    String[] arrSuitableDimType = PermCommonUtil.getSuitableDimType(dimType);
                    suitableDimType = arrSuitableDimType[1];
                    dimTypeMap.put(dimType, suitableDimType);
                }
                for (Map.Entry ruleEntry : userDataPermInfo.entrySet()) {
                    ++index;
                    String dateStr = sdf.format(new Date());
                    String entityNumAndAppIdStr = (String)ruleEntry.getKey();
                    String rule = (String)ruleEntry.getValue();
                    String entityNum = entityNumAndAppIdStr.split(SPLIT_STR)[0];
                    String entityName = entInfo.get(entityNum);
                    if (StringUtils.isEmpty((String)entityName)) {
                        entityName = entityNum;
                    }
                    String appId = entityNumAndAppIdStr.split(SPLIT_STR)[1];
                    String appName = appInfo.get(appId);
                    StringBuilder newDetailDataRuleProcessInfo = new StringBuilder();
                    DataRuleInfo detailDataRuleInfo = new DataRuleInfo();
                    detailDataRuleInfo.setAppId(appId);
                    detailDataRuleInfo.setDescription(dateStr + ResManager.loadKDString((String)"\u5347\u7ea7\u65f6\u4ea7\u751f\u7684\u89c4\u5219", (String)"UpgradeDataRuleUtil_5", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    detailDataRuleInfo.setDetail(true);
                    detailDataRuleInfo.setEnable(Boolean.valueOf(true));
                    detailDataRuleInfo.setEntityNum(entityNum);
                    String detailDataRuleNum = userId + "_" + appId + "_" + entityNum + "_" + dateStr + "_" + index;
                    String detailDataRuleName = userId + "_" + appName + "_" + entityName + "_" + dateStr + "_" + index;
                    detailDataRuleInfo.setNumber(detailDataRuleNum);
                    detailDataRuleInfo.setName((ILocaleString)new LocaleString(langName, detailDataRuleName));
                    FilterCondition fc = (FilterCondition)SerializationUtils.fromJsonString((String)rule, FilterCondition.class);
                    detailDataRuleInfo.setRule(fc);
                    boolean newDetailDataRule = DataRuleCache.newDataRule(detailDataRuleInfo, newDetailDataRuleProcessInfo);
                    if (!newDetailDataRule) {
                        throw new KDBizException(new ErrorCode("0", newDetailDataRuleProcessInfo.toString()), new Object[0]);
                    }
                    Long dataRuleId = detailDataRuleInfo.getId();
                    newParamList.add(new Object[]{userId, appId, entityNum, "47150e89000000ac", dataRuleId, dimObjId, suitableDimType, isIncludeSub, new Date(), updatorId});
                }
                updateOldDataPermParamList.add(new Object[]{new Date(), updatorId, userDataPermId});
            }
            long[] genLongIds = DB.genLongIds((String)"t_perm_userdatarule", (int)newParamList.size());
            ArrayList<Object[]> newUserDataRuleParamList = new ArrayList<Object[]>(8);
            for (int i = 0; i < newParamList.size(); ++i) {
                Object[] newParamsArr = (Object[])newParamList.get(i);
                newUserDataRuleParamList.add(new Object[]{genLongIds[i], newParamsArr[0], newParamsArr[1], newParamsArr[2], newParamsArr[3], newParamsArr[4], newParamsArr[5], newParamsArr[6], newParamsArr[7], newParamsArr[8], newParamsArr[9]});
            }
            String insertPermItemRuleSql = "insert into t_perm_userdatarule(" + "fid, fuserid, fappid, fentitynum, fpermitemid, fdataruleid, fdimid, " + "fdimtype, fisincludesub, fcreatetime, fcreatorid) " + "values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?) ";
            DB.executeBatch((DBRoute)DBRoute.permission, (String)insertPermItemRuleSql, newUserDataRuleParamList);
            if (!updateOldDataPermParamList.isEmpty()) {
                String updateUserDataPermSql = "update t_perm_userdataperm set fisupdate = '1', fupdatetime = ?, fupdatorid = ? where fid = ? ";
                DB.executeBatch((DBRoute)DBRoute.permission, (String)updateUserDataPermSql, updateOldDataPermParamList);
            }
            upgradeState = true;
        }
        catch (Exception e) {
            pProcessInfo.append(e.getMessage());
            logger.error("\u4fdd\u5b58\u5f02\u5e38 " + pProcessInfo, (Throwable)e);
            upgradeState = false;
            throw e;
        }
        return upgradeState;
    }

    private static Map<String, String> getAllAppInfo() {
        String langName = RequestContext.get().getLang().name();
        StringBuilder sbQueryAllAppSql = new StringBuilder("select ar.fid appId, arl.fname appname").append(" from t_meta_appruntime ar left join t_meta_appruntime_l arl on (ar.fappid = arl.fappid and arl.flocaleid = ?) ");
        return (Map)DB.query((DBRoute)DBRoute.meta, (String)sbQueryAllAppSql.toString(), (Object[])new Object[]{langName}, (ResultSetHandler)new ResultSetHandler<Map<String, String>>(){

            public Map<String, String> handle(ResultSet rs) throws SQLException {
                HashMap<String, String> result = new HashMap<String, String>(256);
                while (rs.next()) {
                    String appId = rs.getString("appId");
                    String appname = rs.getString("appname");
                    if (StringUtil.isEmpty((CharSequence)appname)) {
                        appname = appId;
                    }
                    result.put(appId, appname);
                }
                return result;
            }
        });
    }

    private static Map<String, String> getAllEntInfo() {
        String langName = RequestContext.get().getLang().name();
        StringBuilder sbQueryAllEntSql = new StringBuilder("select m.fid entnum, ml.fname entname").append(" from t_meta_mainentityinfo m left join t_meta_mainentityinfo_l ml on (m.fid = ml.fid and ml.flocaleid = ?) ");
        return (Map)DB.query((DBRoute)DBRoute.meta, (String)sbQueryAllEntSql.toString(), (Object[])new Object[]{langName}, (ResultSetHandler)new ResultSetHandler<Map<String, String>>(){

            public Map<String, String> handle(ResultSet rs) throws SQLException {
                HashMap<String, String> result = new HashMap<String, String>(10000);
                while (rs.next()) {
                    String entnum = rs.getString("entnum");
                    String entname = rs.getString("entname");
                    if (StringUtil.isEmpty((CharSequence)entname)) {
                        entname = entnum;
                    }
                    result.put(entnum, entname);
                }
                return result;
            }
        });
    }
}

