/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.opplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import kd.bos.base.utils.user.UserUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.model.UserParam;
import kd.bos.permission.opplugin.BizPartnerUserUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;

public abstract class AbstractBizPartnerOperationPlugIn
extends AbstractOperationServicePlugIn {
    protected static final String KEY_BIZ_PARTNER = "bizpartner";
    protected static final String KEY_IS_ADMIN = "isadmin";
    protected static final String YES = "1";
    protected static final String KEY_ORG = "org";
    protected static final String ENTITY_BOS_USER = "bos_user";
    private static final String SELECT_FIELD_USER = "id,usertypes,enable";
    private static final String SELECT_FIELD_PARTNER = "id,bizpartner,enable,isadmin";
    private static final String SELECT_CONDITION_ORDER_DESC = "enable desc";
    private static final Map<String, Map<String, List<String>>> USER_PERMISSION_DISABLE = new HashMap<String, Map<String, List<String>>>(1);
    private static final String FBASEDATAID = "fbasedataid";

    void enableUser(Collection<Long> userIds, Collection<Long> disableBizpartner) {
        if (CollectionUtils.isEmpty(userIds)) {
            return;
        }
        ArrayList<UserParam> enableUserlist = new ArrayList<UserParam>(userIds.size());
        for (Long id : userIds) {
            UserParam param = new UserParam();
            param.setId(id.longValue());
            enableUserlist.add(param);
        }
        UserServiceHelper.enable(enableUserlist);
        for (UserParam param : enableUserlist) {
            if (param.isSuccess()) continue;
            disableBizpartner.add(param.getId());
            OperateErrorInfo operateErrorInfo = new OperateErrorInfo("", ErrorLevel.Error, (Object)param.getId());
            operateErrorInfo.setMessage(param.getMsg());
            this.operationResult.addErrorInfo(operateErrorInfo);
        }
    }

    void disableUser(Collection<Long> userIds) {
        if (CollectionUtils.isEmpty(userIds)) {
            return;
        }
        QFilter filter = new QFilter("id", "in", userIds);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObject[] users = BusinessDataServiceHelper.load((String)ENTITY_BOS_USER, (String)SELECT_FIELD_USER, (QFilter[])filters);
        if (users == null || users.length <= 0) {
            return;
        }
        ArrayList<UserParam> disableUserlist = new ArrayList<UserParam>(userIds.size());
        for (DynamicObject user : users) {
            if (UserUtils.checkUserType((DynamicObject)user, (Long)1L)) continue;
            UserParam param = new UserParam();
            param.setId(user.getLong("id"));
            disableUserlist.add(param);
        }
        UserServiceHelper.disable(disableUserlist);
        for (UserParam param : disableUserlist) {
            if (param.isSuccess()) continue;
            OperateErrorInfo operateErrorInfo = new OperateErrorInfo("", ErrorLevel.Error, (Object)param.getId());
            operateErrorInfo.setMessage(param.getMsg());
            this.operationResult.addErrorInfo(operateErrorInfo);
        }
    }

    @Deprecated
    void deleteUser(Map<Long, TreeSet<String>> map, List<Long> userIds) {
        this.deleteUser(map, userIds, new HashMap<Long, String>());
    }

    void deleteUser(Map<Long, TreeSet<String>> map, List<Long> userIds, HashMap<Long, String> notDeleteUserMap) {
        if (CollectionUtils.isEmpty(userIds)) {
            return;
        }
        QFilter filter = new QFilter("id", "in", userIds);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObject[] users = BusinessDataServiceHelper.load((String)ENTITY_BOS_USER, (String)"id,usertypes,usertype,modifier,modifytime", (QFilter[])filters);
        if (users == null || users.length <= 0) {
            return;
        }
        ArrayList<UserParam> deleteUser = new ArrayList<UserParam>();
        ArrayList<DynamicObject> deleteUserType = new ArrayList<DynamicObject>();
        long currUserId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        for (DynamicObject user : users) {
            DynamicObjectCollection userTypesCol = user.getDynamicObjectCollection("usertypes");
            Long userId = (Long)user.getPkValue();
            TreeSet<String> types = map.get(userId);
            if (CollectionUtils.isEmpty(types)) {
                types = new TreeSet();
            }
            Iterator userTypes = userTypesCol.iterator();
            boolean isDelete = true;
            while (userTypes.hasNext()) {
                DynamicObject userTypesObj = (DynamicObject)userTypes.next();
                DynamicObject userTypeObj = userTypesObj.getDynamicObject(FBASEDATAID);
                if (userTypeObj == null) continue;
                String userTypeId = userTypeObj.getPkValue().toString();
                if (YES.equals(userTypeId)) {
                    types.add(YES);
                    isDelete = false;
                    continue;
                }
                if (types.contains(userTypeId)) {
                    isDelete = false;
                    continue;
                }
                userTypes.remove();
            }
            if (isDelete) {
                UserParam userParam = new UserParam();
                userParam.setId(userId.longValue());
                deleteUser.add(userParam);
                continue;
            }
            user.set("usertype", (Object)BizPartnerUserUtils.parseUserTypeToString(types));
            user.set("modifier", (Object)currUserId);
            user.set("modifytime", (Object)date);
            deleteUserType.add(user);
        }
        if (!CollectionUtils.isEmpty(deleteUserType)) {
            SaveServiceHelper.save((DynamicObject[])deleteUserType.toArray(new DynamicObject[deleteUserType.size()]));
        }
        UserServiceHelper.delete(deleteUser);
        for (UserParam userParam : deleteUser) {
            if (userParam.isSuccess()) continue;
            notDeleteUserMap.put(userParam.getId(), userParam.getMsg());
        }
    }

    protected void deleteUserType(List<Long> userIds, Map<Long, TreeSet<String>> existsUserTypeMap) {
        if (CollectionUtils.isEmpty(userIds)) {
            return;
        }
        String selectFields = "id,usertype,usertypes,modifier,modifytime";
        QFilter filter = new QFilter("id", "in", userIds);
        DynamicObject[] users = BusinessDataServiceHelper.load((String)ENTITY_BOS_USER, (String)selectFields, (QFilter[])filter.toArray());
        if (users == null || users.length <= 0) {
            return;
        }
        long currUserId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        for (DynamicObject user : users) {
            DynamicObjectCollection userTypesCol = user.getDynamicObjectCollection("usertypes");
            if (CollectionUtils.isEmpty(userIds)) continue;
            Iterator userTypes = userTypesCol.iterator();
            TreeSet<String> otherUserTypes = existsUserTypeMap.get(user.getPkValue());
            if (otherUserTypes == null) {
                otherUserTypes = new TreeSet();
            }
            while (userTypes.hasNext()) {
                DynamicObject userTypesObj = (DynamicObject)userTypes.next();
                DynamicObject userTypeObj = userTypesObj.getDynamicObject(FBASEDATAID);
                boolean isUserTypeDeleted = false;
                if (userTypeObj == null) {
                    isUserTypeDeleted = true;
                } else {
                    String userTypeId = userTypeObj.getPkValue().toString();
                    if (YES.equals(userTypeId)) {
                        otherUserTypes.add(YES);
                    } else if (!otherUserTypes.contains(userTypeId)) {
                        isUserTypeDeleted = true;
                    }
                }
                if (!isUserTypeDeleted) continue;
                userTypes.remove();
            }
            user.set("usertype", (Object)BizPartnerUserUtils.parseUserTypeToString(otherUserTypes));
            user.set("modifier", (Object)currUserId);
            user.set("modifytime", (Object)date);
        }
        SaveServiceHelper.save((DynamicObject[])users);
    }

    @Deprecated
    void userDirectAssignPerm(DynamicObject partnerUser, boolean addOrRemove) {
        if (!partnerUser.getBoolean(KEY_IS_ADMIN)) {
            return;
        }
        DynamicObject org = partnerUser.getDynamicObject(KEY_ORG);
        DynamicObject user = partnerUser.getDynamicObject("user");
        if (null == org || null == user) {
            return;
        }
        Long orgId = Long.valueOf(org.getPkValue().toString());
        Long userId = user.getLong("id");
        PermissionServiceHelper.userDirectAssignPerm((Long)userId, (String)"DIM_ORG", (Long)orgId, USER_PERMISSION_DISABLE, (boolean)addOrRemove);
    }

    void setAdmin2PartnerUser(BeginOperationTransactionArgs e) {
        DynamicObject[] entities = e.getDataEntities();
        ArrayList<Object> ids = new ArrayList<Object>(entities.length);
        String entityName = entities[0].getDataEntityType().getName();
        for (DynamicObject entity : entities) {
            ids.add(entity.getPkValue());
        }
        DynamicObject[] selectPartners = BusinessDataServiceHelper.load((String)entityName, (String)SELECT_FIELD_PARTNER, (QFilter[])this.selectFilter(ids).toArray());
        if (CollectionUtils.isEmpty(Arrays.asList(selectPartners))) {
            return;
        }
        Map<String, List<DynamicObject>> selectPartnerUserMap = this.analyzeQueryResult(selectPartners);
        QFilter filter = this.partnerFilter(selectPartnerUserMap.keySet(), ids);
        DynamicObject[] dbPartners = BusinessDataServiceHelper.load((String)entityName, (String)SELECT_FIELD_PARTNER, (QFilter[])filter.toArray(), (String)SELECT_CONDITION_ORDER_DESC);
        if (CollectionUtils.isEmpty(Arrays.asList(dbPartners))) {
            return;
        }
        Map<String, List<DynamicObject>> dbPartnerUserMap = this.analyzeQueryResult(dbPartners);
        List<DynamicObject> updatePartners = this.needUpdatePartnerUsers(dbPartnerUserMap, selectPartnerUserMap);
        if (!CollectionUtils.isEmpty(updatePartners)) {
            DynamicObject[] arr = updatePartners.toArray(new DynamicObject[0]);
            SaveServiceHelper.save((DynamicObject[])arr);
        }
    }

    public QFilter selectFilter(List<Object> ids) {
        return new QFilter("id", "in", ids);
    }

    private Map<String, List<DynamicObject>> analyzeQueryResult(DynamicObject[] objects) {
        HashMap<String, List<DynamicObject>> partnerMap = new HashMap<String, List<DynamicObject>>();
        for (DynamicObject object : objects) {
            String partnerId = object.getDynamicObject(KEY_BIZ_PARTNER).getPkValue().toString();
            ArrayList<DynamicObject> dynamicObjects = (ArrayList<DynamicObject>)partnerMap.get(partnerId);
            if (Objects.isNull(dynamicObjects)) {
                dynamicObjects = new ArrayList<DynamicObject>();
                partnerMap.put(partnerId, dynamicObjects);
            }
            dynamicObjects.add(object);
        }
        return partnerMap;
    }

    public abstract QFilter partnerFilter(Set<String> var1, List<Object> var2);

    protected QFilter getPartnerFilter(Set<String> partnerIds) {
        ArrayList<Long> partnerLongIds = new ArrayList<Long>(partnerIds.size());
        for (String id : partnerIds) {
            partnerLongIds.add(Long.valueOf(id));
        }
        return new QFilter(KEY_BIZ_PARTNER, "in", partnerLongIds);
    }

    public abstract List<DynamicObject> needUpdatePartnerUsers(Map<String, List<DynamicObject>> var1, Map<String, List<DynamicObject>> var2);

    static {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>(1);
        map.put(ENTITY_BOS_USER, Collections.singletonList("47160c2b000000ac"));
        USER_PERMISSION_DISABLE.put("83bfebc8000037ac", map);
    }
}

