/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.opplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.util.StringUtils;
import kd.bos.permission.service.AdminGroupService;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class AdminCanModifyComRoleValidator
extends AbstractValidator {
    private static final String SYSTEM_TYPE = "bos-permission-opplugin";

    public void validate() {
        long currUserId = RequestContext.get().getCurrUserId();
        boolean isSuperAdmin = PermissionServiceHelper.isAdminUser((long)currUserId, (String)"10");
        List userAdminGrpIds = AdminGroupService.getAdminGrpIdsByUser((Long)currUserId);
        boolean userAdminGrpIdsIsNotEmpty = userAdminGrpIds != null && !userAdminGrpIds.isEmpty();
        HashMap<String, ExtendedDataEntity> roleIdAndObjMap = new HashMap<String, ExtendedDataEntity>();
        for (ExtendedDataEntity dynamicObject : this.dataEntities) {
            DynamicObject dataEntity;
            String billPkd = (String)dynamicObject.getBillPkId();
            if (StringUtils.isEmpty((Object)billPkd) || !(dataEntity = dynamicObject.getDataEntity()).getDataEntityState().getFromDatabase()) continue;
            boolean usescopeDirty = false;
            List iDataEntityProperties = dataEntity.getDataEntityState().GetDirtyProperties();
            for (IDataEntityProperty iDataEntityProperty : iDataEntityProperties) {
                String name = iDataEntityProperty.getName();
                if (!Objects.equals("usescope", name)) continue;
                usescopeDirty = true;
            }
            if (usescopeDirty) {
                if (userAdminGrpIdsIsNotEmpty) {
                    boolean canModifyAssignAdminGrpInfo;
                    Long createAdminGrpId = dataEntity.getLong("createadmingrp_id");
                    boolean bl = canModifyAssignAdminGrpInfo = isSuperAdmin || userAdminGrpIds.contains(createAdminGrpId);
                    if (!canModifyAssignAdminGrpInfo) {
                        this.addErrorMessage(dynamicObject, ResManager.loadKDString((String)"\u5f53\u524d\u7ba1\u7406\u5458\u4e0d\u5141\u8bb8\u201c\u516c\u5f00\u72b6\u6001\u201d\u3002", (String)"AdminCanModifyComRoleValidator_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    }
                } else {
                    this.addErrorMessage(dynamicObject, ResManager.loadKDString((String)"\u5f53\u524d\u7ba1\u7406\u5458\u4e0d\u5141\u8bb8\u201c\u516c\u5f00\u72b6\u6001\u201d\u3002", (String)"AdminCanModifyComRoleValidator_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                }
            }
            roleIdAndObjMap.put(billPkd, dynamicObject);
        }
        if (!roleIdAndObjMap.isEmpty()) {
            Map canModifyMap = AdminGroupService.canModifyRole((Long)currUserId, new ArrayList(roleIdAndObjMap.keySet()));
            for (Map.Entry entry : canModifyMap.entrySet()) {
                String comRoleId = (String)entry.getKey();
                Boolean canModify = (Boolean)entry.getValue();
                if (Boolean.TRUE.equals(canModify)) continue;
                this.addErrorMessage((ExtendedDataEntity)roleIdAndObjMap.get(comRoleId), ResManager.loadKDString((String)"\u5f53\u524d\u7ba1\u7406\u5458\u4e0d\u5141\u8bb8\u4fee\u6539\u8be5\u901a\u7528\u89d2\u8272\u3002", (String)"AdminCanModifyComRoleValidator_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            }
        }
    }
}

