/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.opplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.opplugin.AbstractBizPartnerOperationPlugIn;
import kd.bos.permission.opplugin.BizPartnerUserDisableAdminValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class BizPartnerUserDeletePlugin
extends AbstractBizPartnerOperationPlugIn {
    private static final Log LOG = LogFactory.getLog(BizPartnerUserDeletePlugin.class);
    private static final String PROP_ID = "id";
    private static final String PROP_USER = "user";
    private static final String PROP_ENABLE = "enable";
    private static final String ENTITY_USER = "bos_user";
    private static final String BIZPARTNER_TYPE = "type";
    private static final String ENTITY_BIZPARTNERUSER = "bos_bizpartneruser";
    private Map<DynamicObject, String> userRefMessageMap;

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new BizPartnerUserDisableAdminValidator());
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add(PROP_USER);
        e.getFieldKeys().add("isadmin");
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("bizpartner");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        DynamicObject[] entities = e.getDataEntities();
        if (entities == null || entities.length == 0) {
            return;
        }
        ArrayList<Long> userIds = new ArrayList<Long>(entities.length);
        ArrayList<Long> deleteBizpartnerUserId = new ArrayList<Long>(entities.length);
        for (DynamicObject tempObj : entities) {
            DynamicObject userObj = tempObj.getDynamicObject(PROP_USER);
            if (userObj == null) continue;
            userIds.add((Long)userObj.getPkValue());
            deleteBizpartnerUserId.add((Long)tempObj.getPkValue());
        }
        Map<Long, TreeSet<String>> userExistsOtherType = this.getExistsUserTypeMap(userIds, deleteBizpartnerUserId);
        HashMap<Long, String> notDeleteUserMap = new HashMap<Long, String>(entities.length);
        this.deleteUser(userExistsOtherType, userIds, notDeleteUserMap);
        HashMap<DynamicObject, String> errorMessageMap = new HashMap<DynamicObject, String>();
        Set<Long> notDeleteUserSet = notDeleteUserMap.keySet();
        if (!CollectionUtils.isEmpty(notDeleteUserMap)) {
            Iterator iterator = e.getValidExtDataEntities().iterator();
            while (iterator.hasNext()) {
                ExtendedDataEntity dataEntity = (ExtendedDataEntity)iterator.next();
                Long userId = dataEntity.getDataEntity().getDynamicObject(PROP_USER).getLong(PROP_ID);
                if (!notDeleteUserSet.contains(userId)) continue;
                errorMessageMap.put(dataEntity.getDataEntity(), notDeleteUserMap.get(userId));
                iterator.remove();
            }
        }
        this.userRefMessageMap = errorMessageMap;
        if (e.getValidExtDataEntities().size() == 0 && this.userRefMessageMap.size() > 0) {
            e.setCancel(true);
            this.setErrorMessage(this.userRefMessageMap);
            return;
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        if (this.userRefMessageMap.size() == 0) {
            return;
        }
        this.setErrorMessage(this.userRefMessageMap);
    }

    private void setErrorMessage(Map<DynamicObject, String> errorMessageMap) {
        Iterator<Map.Entry<DynamicObject, String>> iterator = errorMessageMap.entrySet().iterator();
        StringBuilder message = new StringBuilder();
        long dataId = 0L;
        if (iterator.hasNext()) {
            Map.Entry<DynamicObject, String> item = iterator.next();
            DynamicObject bizpartnerUser = item.getKey();
            String err = item.getValue();
            String name = bizpartnerUser.getDynamicObject(PROP_USER).getString("name");
            dataId = (Long)bizpartnerUser.getPkValue();
            name = StringUtils.isBlank((CharSequence)name) ? bizpartnerUser.getPkValue().toString() : name;
            message.append(name);
            message.append(" : ");
            message.append(err.replace("\u3002", ""));
            String tip = ResManager.loadKDString((String)"\u5173\u8054\u7684\u4eba\u5458\u57fa\u7840\u8d44\u6599\u3002", (String)"BizPartnerUserDeletePlugin_0", (String)"bos-permission-opplugin", (Object[])new Object[0]);
            message.append(tip);
        }
        OperateErrorInfo operateErrorInfo = new OperateErrorInfo("", ErrorLevel.Error, (Object)dataId);
        operateErrorInfo.setMessage(message.toString());
        this.operationResult.addErrorInfo(operateErrorInfo);
    }

    private Map<Long, TreeSet<String>> getExistsUserTypeMap(List<Long> userIds, List<Long> deleteBizpartnerUserIds) {
        QFilter userFilter = new QFilter(PROP_USER, "in", userIds);
        QFilter deleteBizpartnerFilter = new QFilter(PROP_ID, "not in", deleteBizpartnerUserIds);
        QFilter[] filters = new QFilter[]{userFilter, deleteBizpartnerFilter};
        DynamicObject[] bizPartnerObjArr = BusinessDataServiceHelper.load((String)ENTITY_BIZPARTNERUSER, (String)"user,usertype,enable", (QFilter[])filters);
        if (bizPartnerObjArr == null || bizPartnerObjArr.length == 0) {
            return new HashMap<Long, TreeSet<String>>(0);
        }
        HashMap<Long, TreeSet<String>> userTypeMap = new HashMap<Long, TreeSet<String>>(bizPartnerObjArr.length);
        for (DynamicObject bizPartnerObj : bizPartnerObjArr) {
            String[] userTypeArr;
            DynamicObject userObj = bizPartnerObj.getDynamicObject(PROP_USER);
            if (userObj == null) continue;
            Long userId = (Long)userObj.getPkValue();
            TreeSet<String> userTypeIds = userTypeMap.getOrDefault(userId, new TreeSet());
            String userType = bizPartnerObj.getString("usertype");
            if (StringUtils.isBlank((CharSequence)userType)) continue;
            for (String userTypeId : userTypeArr = userType.split(",")) {
                if (!StringUtils.isNotBlank((CharSequence)userTypeId)) continue;
                userTypeIds.add(userTypeId);
            }
            userTypeMap.put(userId, userTypeIds);
        }
        return userTypeMap;
    }

    @Override
    public QFilter selectFilter(List<Object> ids) {
        QFilter filter = new QFilter(PROP_ID, "in", ids);
        filter.and("isadmin", "=", (Object)Boolean.TRUE);
        return filter;
    }

    @Override
    public QFilter partnerFilter(Set<String> partnerIds, List<Object> ids) {
        QFilter filter = this.getPartnerFilter(partnerIds);
        filter.and(PROP_ID, "not in", ids);
        return filter;
    }

    @Override
    public List<DynamicObject> needUpdatePartnerUsers(Map<String, List<DynamicObject>> dbPartnerUserMap, Map<String, List<DynamicObject>> selectPartnerUserMap) {
        Collection<List<DynamicObject>> values = dbPartnerUserMap.values();
        if (CollectionUtils.isEmpty(values)) {
            return Collections.emptyList();
        }
        int length = dbPartnerUserMap.size();
        ArrayList<DynamicObject> updatePartners = new ArrayList<DynamicObject>(length);
        for (Map.Entry<String, List<DynamicObject>> entry : dbPartnerUserMap.entrySet()) {
            DynamicObject newAdminPartner = entry.getValue().get(0);
            newAdminPartner.set("isadmin", (Object)Boolean.TRUE);
            updatePartners.add(newAdminPartner);
        }
        return updatePartners;
    }
}

