/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.opplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class BizPartnerUserDisableAdminValidator
extends AbstractValidator {
    private static final String KEY_IS_ADMIN = "isadmin";
    private static final String KEY_BIZ_PARTNER = "bizpartner";

    public void validate() {
        HashMap<Long, ArrayList<Long>> partnerUserMap = new HashMap<Long, ArrayList<Long>>(this.dataEntities.length);
        HashMap<Long, ExtendedDataEntity> dataEntityMap = new HashMap<Long, ExtendedDataEntity>(this.dataEntities.length);
        String entityName = null;
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject partnerUserObj = dataEntity.getDataEntity();
            if (entityName == null) {
                entityName = partnerUserObj.getDataEntityType().getName();
            }
            DynamicObject partnerObj = partnerUserObj.getDynamicObject(KEY_BIZ_PARTNER);
            DynamicObject userObj = partnerUserObj.getDynamicObject("user");
            if (partnerObj == null || userObj == null) continue;
            long partnerId = partnerObj.getLong("id");
            ArrayList<Long> userIds = (ArrayList<Long>)partnerUserMap.get(partnerId);
            if (userIds == null) {
                userIds = new ArrayList<Long>();
                partnerUserMap.put(partnerId, userIds);
            }
            userIds.add(userObj.getLong("id"));
            if (!partnerUserObj.getBoolean(KEY_IS_ADMIN)) continue;
            dataEntityMap.put(partnerId, dataEntity);
        }
        if (dataEntityMap.isEmpty()) {
            return;
        }
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter partnerFilter = new QFilter(KEY_BIZ_PARTNER, "in", dataEntityMap.keySet());
        QFilter[] filters = new QFilter[]{enableFilter, partnerFilter};
        DynamicObjectCollection partnerObjCol = QueryServiceHelper.query((String)entityName, (String)"user,bizpartner", (QFilter[])filters);
        if (partnerObjCol == null || partnerObjCol.isEmpty()) {
            return;
        }
        HashSet<Long> errorBizPartnerIds = new HashSet<Long>(partnerUserMap.size());
        String msg = "\uff1a" + ResManager.loadKDString((String)"%s\u5931\u8d25\u3002\u5f53\u524d\u7528\u6237\u662f\u5546\u52a1\u4f19\u4f34\u7684\u7ba1\u7406\u5458\uff0c\u8bf7\u5148\u79fb\u4ea4\u7ed9\u5546\u52a1\u4f19\u4f34\u7684\u5176\u4ed6\u7528\u6237\u3002", (String)"BizPartnerUserDisableAdminValidator_0", (String)"bos-permission-opplugin", (Object[])new Object[0]);
        msg = String.format(msg, this.getOperationName());
        for (DynamicObject partnerObj : partnerObjCol) {
            ExtendedDataEntity dataEntity;
            List userIds;
            long bizpartnerId = partnerObj.getLong(KEY_BIZ_PARTNER);
            if (errorBizPartnerIds.contains(bizpartnerId) || (userIds = (List)partnerUserMap.get(bizpartnerId)) == null || userIds.contains(partnerObj.getLong("user")) || (dataEntity = (ExtendedDataEntity)dataEntityMap.get(bizpartnerId)) == null) continue;
            String userName = "";
            DynamicObject bizPartnerEntityObj = dataEntity.getDataEntity();
            DynamicObject userObj = bizPartnerEntityObj.getDynamicObject("user");
            if (userObj != null) {
                userName = userObj.getString("name");
            }
            this.addErrorMessage(dataEntity, userName + msg);
            errorBizPartnerIds.add(bizpartnerId);
        }
    }
}

