/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.opplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.opplugin.AbstractBizPartnerOperationPlugIn;
import kd.bos.permission.opplugin.BizPartnerUserDisableAdminValidator;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public class BizPartnerUserDisablePlugin
extends AbstractBizPartnerOperationPlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new BizPartnerUserDisableAdminValidator());
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("user");
        e.getFieldKeys().add("isadmin");
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("bizpartner");
        e.getFieldKeys().add("disabler");
        e.getFieldKeys().add("disabledate");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] objects = e.getDataEntities();
        String entityName = objects[0].getDataEntityType().getName();
        HashSet<Object> userIds = new HashSet<Object>(objects.length);
        ArrayList<Object> partnerIds = new ArrayList<Object>(objects.length);
        long currUserId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        for (DynamicObject partner : objects) {
            DynamicObject dynamicObject = partner.getDynamicObject("user");
            if (dynamicObject == null) continue;
            userIds.add(dynamicObject.getPkValue());
            partnerIds.add(partner.getPkValue());
            partner.set("disabler", (Object)currUserId);
            partner.set("disabledate", (Object)date);
        }
        QFilter filter = new QFilter("id", "not in", partnerIds);
        filter.and("user", "in", userIds);
        filter.and("enable", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection enableUsers = QueryServiceHelper.query((String)entityName, (String)"user", (QFilter[])filter.toArray());
        if (CollectionUtils.isNotEmpty((Collection)enableUsers)) {
            HashSet<Object> enableUserIds = new HashSet<Object>(enableUsers.size());
            for (DynamicObject dynamicObject : enableUsers) {
                enableUserIds.add(dynamicObject.get("user"));
            }
            userIds.removeIf(enableUserIds::contains);
        }
        if (CollectionUtils.isEmpty(userIds)) {
            return;
        }
        ArrayList<Long> disableUserIds = new ArrayList<Long>(userIds.size());
        for (Object e2 : userIds) {
            disableUserIds.add(Long.parseLong(String.valueOf(e2)));
        }
        this.disableUser(disableUserIds);
    }

    @Override
    public QFilter selectFilter(List<Object> ids) {
        QFilter selectFilter = new QFilter("id", "in", ids);
        selectFilter.and("enable", "=", (Object)"1");
        return selectFilter;
    }

    @Override
    public QFilter partnerFilter(Set<String> partnerIds, List<Object> ids) {
        QFilter filter = this.getPartnerFilter(partnerIds);
        filter.and("enable", "=", (Object)"1");
        filter.and("id", "not in", ids);
        return filter;
    }

    @Override
    public List<DynamicObject> needUpdatePartnerUsers(Map<String, List<DynamicObject>> dbPartnerUserMap, Map<String, List<DynamicObject>> selectPartnerUserMap) {
        ArrayList<DynamicObject> updatePartners = new ArrayList<DynamicObject>();
        block0: for (Map.Entry<String, List<DynamicObject>> entry : dbPartnerUserMap.entrySet()) {
            String key = entry.getKey();
            List<DynamicObject> selects = selectPartnerUserMap.get(key);
            for (DynamicObject select : selects) {
                if (!select.getBoolean("isadmin")) continue;
                select.set("isadmin", (Object)Boolean.FALSE);
                updatePartners.add(select);
                DynamicObject newAdminUser = entry.getValue().get(0);
                newAdminUser.set("isadmin", (Object)Boolean.TRUE);
                updatePartners.add(newAdminUser);
                continue block0;
            }
        }
        return updatePartners;
    }
}

