/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.opplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.opplugin.AbstractBizPartnerOperationPlugIn;

public class BizPartnerUserEnablePlugin
extends AbstractBizPartnerOperationPlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("user");
        e.getFieldKeys().add("isadmin");
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("disabler");
        e.getFieldKeys().add("disabledate");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject user;
        super.beginOperationTransaction(e);
        this.setAdmin2PartnerUser(e);
        DynamicObject[] entities = e.getDataEntities();
        HashSet<Long> disableUserIds = new HashSet<Long>();
        for (DynamicObject entity : entities) {
            user = entity.getDynamicObject("user");
            if (user == null || user.getBoolean("enable")) continue;
            disableUserIds.add(user.getLong("id"));
        }
        ArrayList<Long> disableBizParterner = new ArrayList<Long>();
        this.enableUser(disableUserIds, disableBizParterner);
        List<DynamicObject> dataList = Arrays.stream(e.getDataEntities()).collect(Collectors.toList());
        Iterator iterator = dataList.iterator();
        while (iterator.hasNext()) {
            DynamicObject bizPartner = (DynamicObject)iterator.next();
            user = bizPartner.getDynamicObject("user");
            if (user == null || !disableBizParterner.contains(user.getLong("id"))) continue;
            iterator.remove();
        }
        if (dataList.size() == 0) {
            e.setCancelOperation(true);
        }
        e.setDataEntities(dataList.toArray(new DynamicObject[dataList.size()]));
    }

    @Override
    public QFilter partnerFilter(Set<String> partnerIds, List<Object> ids) {
        QFilter filter = this.getPartnerFilter(partnerIds);
        filter.and("isadmin", "=", (Object)Boolean.TRUE);
        return filter;
    }

    @Override
    public List<DynamicObject> needUpdatePartnerUsers(Map<String, List<DynamicObject>> dbPartnerUserMap, Map<String, List<DynamicObject>> selectPartnerUserMap) {
        ArrayList<DynamicObject> updatePartners = new ArrayList<DynamicObject>();
        for (Map.Entry<String, List<DynamicObject>> entry : dbPartnerUserMap.entrySet()) {
            String key = entry.getKey();
            DynamicObject defaultAdminUser = entry.getValue().get(0);
            if (defaultAdminUser.getBoolean("enable")) continue;
            List<DynamicObject> selectPartners = selectPartnerUserMap.get(key);
            Object adminPk = defaultAdminUser.getPkValue();
            boolean isContain = false;
            for (DynamicObject select : selectPartners) {
                if (!Objects.equals(adminPk, select.getPkValue())) continue;
                isContain = true;
                break;
            }
            if (isContain) continue;
            DynamicObject newAdminUser = selectPartnerUserMap.get(key).get(0);
            newAdminUser.set("isadmin", (Object)Boolean.TRUE);
            defaultAdminUser.set("isadmin", (Object)Boolean.FALSE);
            updatePartners.add(newAdminUser);
            updatePartners.add(defaultAdminUser);
        }
        return updatePartners;
    }
}

