/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.opplugin;

import java.util.Collection;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class BizPartnerUserSaveOrgValidator
extends AbstractValidator {
    private static final String ENTITY_NAME = "bos-permission-opplugin";

    public void validate() {
        Long userId = RequestContext.get().getCurrUserId();
        HasPermOrgResult result = PermissionServiceHelper.getAdminChargeOrg((Long)userId, (String)"01");
        List extralUserIds = PermissionServiceHelper.getAdminExtraUser((Long)userId);
        if (result.hasAllOrgPerm()) {
            return;
        }
        List orgIds = result.getHasPermOrgs();
        if (CollectionUtils.isEmpty((Collection)orgIds)) {
            return;
        }
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            this.orgValidate(dataEntity, orgIds, extralUserIds);
        }
    }

    private void orgValidate(ExtendedDataEntity dataEntity, List<Long> orgIds, List<Long> extralUserIds) {
        DynamicObject partnerUser = dataEntity.getDataEntity();
        DynamicObject org = partnerUser.getDynamicObject("org");
        if (org == null) {
            return;
        }
        Long orgId = org.getLong("id");
        if (!orgIds.contains(orgId)) {
            Long userId;
            DynamicObject user = partnerUser.getDynamicObject("user");
            Long l = userId = user != null ? Long.valueOf(user.getLong("id")) : null;
            if (extralUserIds.contains(userId)) {
                return;
            }
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0d\u5728\u767b\u5f55\u7528\u6237\u7684\u7ba1\u7406\u5458\u884c\u653f\u7ec4\u7ec7\u7ba1\u8f96\u8303\u56f4\u4e4b\u5185\u3002", (String)"BizPartnerUserSaveOrgValidator_0", (String)ENTITY_NAME, (Object[])new Object[0]));
            return;
        }
    }
}

