/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.opplugin;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.model.UserParam;
import kd.bos.permission.opplugin.AbstractBizPartnerOperationPlugIn;
import kd.bos.permission.opplugin.BizPartnerUserSaveOrgValidator;
import kd.bos.permission.opplugin.BizPartnerUserSaveValidator;
import kd.bos.permission.opplugin.BizPartnerUserUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;

public class BizPartnerUserSavePlugin
extends AbstractBizPartnerOperationPlugIn {
    private static final Log LOG = LogFactory.getLog(BizPartnerUserSavePlugin.class);
    private static final String USER = "user";
    private static final String PROP_PHONE = "phone";
    private static final String PROP_NAME = "username";
    private static final String PROP_USER_FULL_NAME = "userfullname";
    private static final String PROP_EMAIL = "email";
    private static final String USER_TYPE = "usertype";
    private static final String ERROR_MSG_REGEX = "^[0-9]*:\\s";

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new BizPartnerUserSaveValidator());
        OperateOption operateOption = this.operateOption;
        String isSkipAdminScopePermission = operateOption.getVariableValue("skipadminscopepermission", "false");
        if (!"true".equals(isSkipAdminScopePermission)) {
            e.getValidators().add(new BizPartnerUserSaveOrgValidator());
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs evt) {
        super.beginOperationTransaction(evt);
        ArrayList<DynamicObject> successObjs = new ArrayList<DynamicObject>();
        DynamicObject[] dataEntities = evt.getDataEntities();
        Map<Long, TreeSet<String>> userTypeMap = this.getOtherBizPartnerUserType(dataEntities);
        for (DynamicObject object : evt.getDataEntities()) {
            try {
                UserParam userparam = this.saveUser(object, userTypeMap);
                if (!userparam.isSuccess()) {
                    String errorMsg = this.getErrorMessage(userparam);
                    throw new KDBizException(errorMsg);
                }
                DynamicObject userObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_user");
                userObj.set("id", (Object)userparam.getId());
                object.set(USER, (Object)userObj);
                object.set("status", (Object)"C");
                successObjs.add(object);
            }
            catch (UnsupportedEncodingException e) {
                LOG.error(ResManager.loadKDString((String)"\u4fdd\u5b58\u4eba\u5458\u65f6\uff0c\u59d3\u540d\u8f6c\u6362\u62fc\u97f3\u51fa\u73b0\u5f02\u5e38\u3002", (String)"BizPartnerUserSavePlugin_0", (String)"bos-permission-opplugin", (Object[])new Object[0]), (Throwable)e);
                this.addOperationResult(ResManager.loadKDString((String)"\u4fdd\u5b58\u4eba\u5458\u65f6\uff0c\u59d3\u540d\u8f6c\u6362\u62fc\u97f3\u51fa\u73b0\u5f02\u5e38\u3002", (String)"BizPartnerUserSavePlugin_0", (String)"bos-permission-opplugin", (Object[])new Object[0]), object);
            }
            catch (KDBizException e) {
                this.addOperationResult(e.getMessage(), object);
            }
            catch (Exception e) {
                LOG.error(ResManager.loadKDString((String)"\u540c\u6b65\u4eba\u5458\u6570\u636e\u53d1\u751f\u5f02\u5e38", (String)"BizPartnerUserSavePlugin_2", (String)"bos-permission-opplugin", (Object[])new Object[0]), (Throwable)e);
                this.addOperationResult(ResManager.loadKDString((String)"\u4eba\u5458\u4fdd\u5b58\u5f02\u5e38\uff0c \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BizPartnerUserSavePlugin_1", (String)"bos-permission-opplugin", (Object[])new Object[0]), object);
            }
        }
        evt.setDataEntities(successObjs.toArray(new DynamicObject[0]));
    }

    private Map<Long, TreeSet<String>> getOtherBizPartnerUserType(DynamicObject[] dataEntities) {
        ArrayList<Long> userIds = new ArrayList<Long>(dataEntities.length);
        for (DynamicObject partnerUserObj : dataEntities) {
            DynamicObject userObj = partnerUserObj.getDynamicObject(USER);
            if (userObj == null) continue;
            userIds.add(userObj.getLong("id"));
        }
        return BizPartnerUserUtils.getOtherBizPartnerUserType(userIds);
    }

    private void addOperationResult(String message, DynamicObject user) {
        OperateErrorInfo operateErrorInfo = new OperateErrorInfo("", ErrorLevel.Error, user.getPkValue());
        operateErrorInfo.setMessage(message);
        this.operationResult.addErrorInfo(operateErrorInfo);
    }

    private String getErrorMessage(UserParam userparam) {
        String errorMsg = userparam.getMsg();
        if (StringUtils.isEmpty((CharSequence)errorMsg)) {
            return "";
        }
        return errorMsg.replaceFirst(ERROR_MSG_REGEX, "");
    }

    private UserParam saveUser(DynamicObject partnerUser, Map<Long, TreeSet<String>> userTypeMap) throws UnsupportedEncodingException {
        ArrayList<UserParam> users = new ArrayList<UserParam>(1);
        UserParam addUser = new UserParam();
        DynamicObject user = partnerUser.getDynamicObject(USER);
        String phone = partnerUser.getString(PROP_PHONE);
        String email = partnerUser.getString(PROP_EMAIL);
        HashMap<String, Object> dataMap = new HashMap<String, Object>(6);
        dataMap.put("name", partnerUser.getString(PROP_NAME));
        dataMap.put(PROP_NAME, partnerUser.getString(PROP_USER_FULL_NAME));
        dataMap.put(PROP_PHONE, phone);
        dataMap.put(PROP_EMAIL, email);
        dataMap.put("fullpinyin", "");
        dataMap.put("simplepinyin", "");
        dataMap.put("sources", "BizPartnerUserSavePlugin");
        TreeSet<String> userTypeSet = BizPartnerUserUtils.getUserTypeSet(partnerUser);
        partnerUser.set(USER_TYPE, (Object)BizPartnerUserUtils.parseUserTypeToString(userTypeSet));
        if (user != null) {
            TreeSet<String> otherUserTypes = userTypeMap.get(Long.parseLong(user.getPkValue().toString()));
            if (userTypeSet != null && otherUserTypes != null) {
                userTypeSet.addAll(otherUserTypes);
            }
        }
        dataMap.put(USER_TYPE, BizPartnerUserUtils.parseUserTypeToString(userTypeSet));
        dataMap.put("usertypes", null);
        addUser.setDataMap(dataMap);
        users.add(addUser);
        if (user == null) {
            QFilter userFilter = null;
            if (StringUtils.isNotBlank((CharSequence)phone)) {
                userFilter = new QFilter(PROP_PHONE, "=", (Object)phone);
            } else if (StringUtils.isNotBlank((CharSequence)email)) {
                userFilter = new QFilter(PROP_EMAIL, "=", (Object)email);
            }
            try {
                if (userFilter != null) {
                    QFilter enableQfliter = new QFilter("enable", "=", (Object)Boolean.TRUE);
                    userFilter.and(enableQfliter);
                    user = BusinessDataServiceHelper.loadSingle((String)"bos_user", (String)"id,usertypes,enable", (QFilter[])userFilter.toArray());
                    user = BizPartnerUserUtils.isAdmin(user) ? null : user;
                }
            }
            catch (Exception e) {
                LOG.error(ResManager.loadKDString((String)"\u6839\u636e\u624b\u673a\u53f7\u6216\u8005\u90ae\u7bb1\u67e5\u8be2\u4eba\u5458\u4fe1\u606f\u5931\u8d25\u3002", (String)"BizPartnerUserSavePlugin_4", (String)"bos-permission-opplugin", (Object[])new Object[0]), (Throwable)e);
            }
            if (user != null) {
                Long userId = (Long)user.getPkValue();
                addUser.setId(userId.longValue());
            } else {
                ORM orm = ORM.create();
                dataMap.put("number", orm.genLongId("bos_user"));
            }
            UserServiceHelper.addOrUpdate(users);
        } else {
            addUser.setId(Long.parseLong(user.getPkValue().toString()));
            UserServiceHelper.addOrUpdate(users);
        }
        if (user != null && !user.getBoolean("enable")) {
            Long userId = Long.parseLong(user.getPkValue().toString());
            this.enableUser(Collections.singletonList(userId), null);
        }
        this.updateLicense(users);
        return (UserParam)users.get(0);
    }

    private void updateLicense(List<UserParam> users) {
        long userId = users.get(0).getId();
        if (userId == 0L) {
            return;
        }
        try {
            LicenseServiceHelper.addUser2LicGroupDif((Long)userId);
        }
        catch (Exception e) {
            LOG.error("BizPartnerUserSavePlugin.saveUser : " + userId, (Throwable)e);
        }
    }

    @Override
    public QFilter partnerFilter(Set<String> partnerIds, List<Object> ids) {
        return null;
    }

    @Override
    public List<DynamicObject> needUpdatePartnerUsers(Map<String, List<DynamicObject>> dbPartnerUserMap, Map<String, List<DynamicObject>> selectPartnerUserMap) {
        return Collections.emptyList();
    }
}

