/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.opplugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.base.utils.user.UserUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.opplugin.BizPartnerUserUtils;
import kd.bos.sec.user.utils.UserOperationUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class BizPartnerUserSaveValidator
extends AbstractValidator {
    private static final Log LOGGER = LogFactory.getLog(BizPartnerUserSaveValidator.class);
    private static final String MAINENTITY_BIZPARTNERUSER = "bos_bizpartneruser";
    private static final String PROP_TYPE = "type";
    private static final String PROP_BIZPARTNER = "bizpartner";
    private static final String PROP_USER = "user";
    private static final String PROP_ISADMIN = "isadmin";
    private static final String PROP_PHONE = "phone";
    private static final String PROP_EMAIL = "email";
    private static final String SELECT_FIELDS = "id,bizpartner.id,bizpartner,user.name,user.id,user.phone,user.email,user.usertypes,user.usertypes.fbasedataid,isadmin,enable";
    private static final String SYSTEM_TYPE = "bos-permission-opplugin";

    public void validate() {
        this.validateFields();
        RowDataModel rowDataModel = new RowDataModel(this.entityKey, this.getValidateContext().getSubEntityType());
        HashSet<Long> currentPartnerIds = new HashSet<Long>(16);
        HashSet<Long> changeUserIds = new HashSet<Long>(16);
        HashMap<Long, DynamicObject> adminPartnerMapFromImport = new HashMap<Long, DynamicObject>(16);
        HashMap<String, Set<String>> phoneAndEmailMap = new HashMap<String, Set<String>>(2);
        phoneAndEmailMap.put(PROP_EMAIL, new HashSet());
        phoneAndEmailMap.put(PROP_PHONE, new HashSet());
        this.validateCurrentData(rowDataModel, currentPartnerIds, adminPartnerMapFromImport, phoneAndEmailMap);
        Map<String, DynamicObject> dbPartnerUsersFromPhoneAndEmail = this.getBizPartnerUserFromPhoneAndEmail(phoneAndEmailMap);
        this.addUser(rowDataModel, dbPartnerUsersFromPhoneAndEmail, changeUserIds);
        HashMap<Long, DynamicObject> adminPartnerMapFromDb = new HashMap<Long, DynamicObject>(16);
        HashMap<Long, Boolean> userStaffMap = new HashMap<Long, Boolean>(16);
        Map<Long, List<DynamicObject>> dbPartnerUsers = this.getBizPartnerUserFromDb(currentPartnerIds, changeUserIds, adminPartnerMapFromDb, userStaffMap);
        Map userTypeCache = BusinessDataServiceHelper.loadFromCache((String)"bos_usertype", (QFilter[])new QFilter[0]);
        Set<Object> userTypeIdSet = userTypeCache.keySet();
        for (ExtendedDataEntity rowDataEntity : this.getDataEntities()) {
            DynamicObject partnerUser = rowDataEntity.getDataEntity();
            rowDataModel.setRowContext(partnerUser);
            Object types = rowDataModel.getValue(PROP_TYPE);
            if (types == null) continue;
            this.typeValidate(userTypeIdSet, rowDataEntity, types);
            this.emailValidate(rowDataEntity, rowDataModel);
            this.existPartnerValidate(rowDataModel, rowDataEntity, dbPartnerUsers, dbPartnerUsersFromPhoneAndEmail);
            this.adminPartnerValidate(adminPartnerMapFromDb, adminPartnerMapFromImport, rowDataModel, rowDataEntity, dbPartnerUsers);
            this.validateUserType(rowDataEntity, userStaffMap);
        }
    }

    private void addUser(RowDataModel rowDataModel, Map<String, DynamicObject> dbPartnerUsersFromPhoneAndEmail, Set<Long> changeUserIds) {
        if (dbPartnerUsersFromPhoneAndEmail.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.dataEntities.length; ++i) {
            Object user;
            rowDataModel.setRowContext(this.dataEntities[i].getDataEntity());
            String phone = (String)rowDataModel.getValue(PROP_PHONE);
            String email = (String)rowDataModel.getValue(PROP_EMAIL);
            if (rowDataModel.getValue(PROP_USER) == null && StringUtils.isNotEmpty((String)phone)) {
                rowDataModel.setValue(PROP_USER, (Object)dbPartnerUsersFromPhoneAndEmail.get(phone));
            }
            if (rowDataModel.getValue(PROP_USER) == null && StringUtils.isNotEmpty((String)email)) {
                rowDataModel.setValue(PROP_USER, (Object)dbPartnerUsersFromPhoneAndEmail.get(email));
            }
            if ((user = rowDataModel.getValue(PROP_USER)) == null) continue;
            Long userId = (Long)((DynamicObject)user).getPkValue();
            changeUserIds.add(userId);
        }
    }

    private void validateFields() {
        ArrayList<Long> ids = new ArrayList<Long>(this.dataEntities.length);
        HashMap<Long, ExtendedDataEntity> types = new HashMap<Long, ExtendedDataEntity>(this.dataEntities.length);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject object = dataEntity.getDataEntity();
            if (!object.getDataEntityState().getFromDatabase()) continue;
            ids.add(object.getLong("id"));
            types.put(object.getLong("id"), dataEntity);
        }
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        QFilter idFilter = new QFilter("id", "in", ids);
        QFilter[] filters = new QFilter[]{idFilter};
        Map bizPartnerUserTypes = BusinessDataServiceHelper.loadFromCache((String)MAINENTITY_BIZPARTNERUSER, (String)"usertype,bizpartner", (QFilter[])filters);
        for (Map.Entry entry : bizPartnerUserTypes.entrySet()) {
            String userType = ((DynamicObject)entry.getValue()).getString("usertype");
            DynamicObject bizPartner = ((DynamicObject)entry.getValue()).getDynamicObject(PROP_BIZPARTNER);
            ExtendedDataEntity dataEntity = (ExtendedDataEntity)types.get(Long.parseLong(entry.getKey().toString()));
            if (!userType.equals(BizPartnerUserUtils.getUserType(dataEntity.getDataEntity()))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u4fee\u6539\u7c7b\u578b\u3002", (String)"BizPartnerUserSaveValidator_14", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            }
            if (bizPartner.getLong("id") == dataEntity.getDataEntity().getDynamicObject(PROP_BIZPARTNER).getLong("id")) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u4fee\u6539\u5546\u52a1\u4f19\u4f34\u3002", (String)"BizPartnerUserSaveValidator_15", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
    }

    private Map<String, DynamicObject> getBizPartnerUserFromPhoneAndEmail(Map<String, Set<String>> phoneAndEmailMap) {
        DynamicObject[] users;
        HashMap<String, DynamicObject> result = new HashMap<String, DynamicObject>();
        Set<String> phoneSet = phoneAndEmailMap.get(PROP_PHONE);
        Set<String> emailSet = phoneAndEmailMap.get(PROP_EMAIL);
        QFilter qFilter = null;
        if (!CollectionUtils.isEmpty(phoneSet)) {
            qFilter = new QFilter(PROP_PHONE, "in", phoneSet);
        }
        if (!CollectionUtils.isEmpty(emailSet)) {
            if (qFilter == null) {
                qFilter = new QFilter(PROP_EMAIL, "in", emailSet);
            } else {
                qFilter.or(new QFilter(PROP_EMAIL, "in", emailSet));
            }
        }
        if (qFilter == null) {
            return result;
        }
        QFilter enableQFilter = new QFilter("enable", "=", (Object)"1");
        for (DynamicObject user : users = BusinessDataServiceHelper.load((String)"bos_user", (String)"id,usertypes,phone,email,enable", (QFilter[])new QFilter[]{qFilter, enableQFilter})) {
            String phone = user.getString(PROP_PHONE);
            String email = user.getString(PROP_EMAIL);
            if (StringUtils.isNotEmpty((String)phone)) {
                result.put(phone, user);
            }
            if (!StringUtils.isNotEmpty((String)email)) continue;
            result.put(email, user);
        }
        return result;
    }

    private void validateUserType(ExtendedDataEntity rowDataEntity, Map<Long, Boolean> userStaffMap) {
        DynamicObject partnerUser = rowDataEntity.getDataEntity();
        Long staffTypeId = 1L;
        boolean internalPartner = BizPartnerUserUtils.isInternalPartner(partnerUser);
        boolean isStaff = partnerUser.get(PROP_USER) instanceof DynamicObject ? UserUtils.checkUserType((DynamicObject)partnerUser.getDynamicObject(PROP_USER), (Long)staffTypeId) : userStaffMap.getOrDefault(partnerUser.getLong(PROP_USER), false);
        if (internalPartner && !isStaff) {
            this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u4e0d\u662f\u804c\u5458\uff0c\u4e0d\u80fd\u9009\u62e9\u5185\u90e8\u5546\u52a1\u4f19\u4f34\uff0c\u8bf7\u5148\u6dfb\u52a0\u4e3a\u201c\u804c\u5458\u201d\u6216\u8005\u4fee\u6539\u201c\u5546\u52a1\u4f19\u4f34\u201d\u3002", (String)"BizPartnerUserSaveValidator_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        } else if (!internalPartner && isStaff) {
            this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u4eba\u5458\u4e3a\u5185\u90e8\u804c\u5458\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u8bbe\u7f6e\u4e86\u201c\u5185\u90e8\u4e1a\u52a1\u5355\u5143\u201d\u7684\u201c\u5546\u52a1\u4f19\u4f34\u201d\u3002", (String)"BizPartnerUserSaveValidator_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        } else {
            partnerUser.set(PROP_TYPE, (Object)BizPartnerUserUtils.getUserType(partnerUser, internalPartner, isStaff));
        }
    }

    private void adminPartnerValidate(Map<Long, DynamicObject> adminPartnerMapFromDb, Map<Long, DynamicObject> adminPartnerMapFromImport, RowDataModel rowDataModel, ExtendedDataEntity rowDataEntity, Map<Long, List<DynamicObject>> dbPartnerUsers) {
        DynamicObject bizPartner = (DynamicObject)rowDataModel.getValue(PROP_BIZPARTNER);
        Long bizPartnerId = (Long)bizPartner.getPkValue();
        Boolean isAdmin = (Boolean)rowDataModel.getValue(PROP_ISADMIN);
        DynamicObject adminPartnerUser = adminPartnerMapFromDb.get(bizPartnerId);
        boolean existAdminFromDb = null != adminPartnerUser;
        Long bizpartnerUserId = (Long)rowDataEntity.getDataEntity().getPkValue();
        if (Boolean.TRUE.equals(existAdminFromDb && isAdmin == false) && bizpartnerUserId.equals(adminPartnerUser.getLong("id"))) {
            existAdminFromDb = false;
        }
        boolean existAdminFromImport = null != adminPartnerMapFromImport.get(bizPartnerId);
        if (Boolean.TRUE.equals(!existAdminFromDb && isAdmin == false) && !existAdminFromImport) {
            this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u5546\u52a1\u4f19\u4f34\u9700\u5148\u8bbe\u7f6e\u4e00\u4e2a\u7ba1\u7406\u5458\u3002", (String)"BizPartnerUserSaveValidator_2", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return;
        }
        if ("1".equals(this.getIsAdminFlag())) {
            existAdminFromDb = false;
        }
        if (Boolean.TRUE.equals(existAdminFromDb && isAdmin != false) && !bizpartnerUserId.equals(adminPartnerUser.getLong("id"))) {
            this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u8be5\u5546\u52a1\u4f19\u4f34\u5df2\u5b58\u5728\u4e00\u4e2a\u7ba1\u7406\u5458\u3002", (String)"BizPartnerUserSaveValidator_3", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return;
        }
        if (!this.isNewPartnerUser(dbPartnerUsers.get(bizPartnerId), rowDataEntity)) {
            Object currentPk = rowDataEntity.getBillPkId();
            if (adminPartnerUser != null && currentPk.equals(adminPartnerUser.getPkValue()) && Boolean.TRUE.equals(isAdmin == false)) {
                this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u8be5\u5546\u52a1\u4f19\u4f34\u4e0b\u5fc5\u987b\u5b58\u5728\u4e00\u4e2a\u7ba1\u7406\u5458\u3002", (String)"BizPartnerUserSaveValidator_4", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            }
        }
    }

    private String getIsAdminFlag() {
        try {
            return this.getOption().getVariableValue("isAdmin");
        }
        catch (Exception e) {
            LOGGER.warn(ResManager.loadKDString((String)"\u83b7\u53d6\u7ba1\u7406\u5458\u6807\u8bc6\u4fe1\u606f\u5f02\u5e38", (String)"BizPartnerUserSaveValidator_13", (String)SYSTEM_TYPE, (Object[])new Object[0]), (Throwable)e);
            return "0";
        }
    }

    private void validateCurrentData(RowDataModel rowDataModel, Set<Long> currentPartnerIds, Map<Long, DynamicObject> adminPartnerMapFromImport, Map<String, Set<String>> phoneAndEmailMap) {
        DynamicObject bizPartner;
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        boolean[] removeIndex = new boolean[dataEntities.length];
        for (int i = 0; i < dataEntities.length; ++i) {
            if (removeIndex[i]) continue;
            ExtendedDataEntity rowDataEntity = dataEntities[i];
            rowDataModel.setRowContext(rowDataEntity.getDataEntity());
            bizPartner = (DynamicObject)rowDataModel.getValue(PROP_BIZPARTNER);
            if (bizPartner == null) {
                this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u5546\u52a1\u4f19\u4f34\u5b57\u6bb5\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BizPartnerUserSaveValidator_5", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                removeIndex[i] = true;
                continue;
            }
            this.filterRepetitionData(rowDataModel, dataEntities, removeIndex, i, bizPartner);
        }
        ArrayList<ExtendedDataEntity> extendedDataEntities = new ArrayList<ExtendedDataEntity>(dataEntities.length);
        for (int i = 0; i < dataEntities.length; ++i) {
            if (removeIndex[i]) continue;
            rowDataModel.setRowContext(dataEntities[i].getDataEntity());
            bizPartner = (DynamicObject)rowDataModel.getValue(PROP_BIZPARTNER);
            Long bizPartnerId = (Long)bizPartner.getPkValue();
            currentPartnerIds.add(bizPartnerId);
            String email = rowDataModel.getValue(PROP_EMAIL).toString();
            String phone = rowDataModel.getValue(PROP_PHONE).toString();
            if (StringUtils.isNotEmpty((String)email)) {
                phoneAndEmailMap.get(PROP_EMAIL).add(email);
            }
            if (StringUtils.isNotEmpty((String)phone)) {
                phoneAndEmailMap.get(PROP_PHONE).add(phone);
            }
            if (Boolean.TRUE.equals(rowDataModel.getValue(PROP_ISADMIN))) {
                adminPartnerMapFromImport.put(bizPartnerId, bizPartner);
            }
            extendedDataEntities.add(dataEntities[i]);
        }
        this.setDataEntities(extendedDataEntities.toArray(new ExtendedDataEntity[0]));
    }

    private void filterRepetitionData(RowDataModel rowDataModel, ExtendedDataEntity[] dataEntities, boolean[] removeIndex, int i, DynamicObject bizPartner) {
        Long bizPartnerId = (Long)bizPartner.getPkValue();
        String email = (String)rowDataModel.getValue(PROP_EMAIL);
        String phone = (String)rowDataModel.getValue(PROP_PHONE);
        for (int j = i + 1; j < dataEntities.length; ++j) {
            boolean isRepetition;
            if (removeIndex[j]) continue;
            RowDataModel dataModel = new RowDataModel(this.entityKey, this.getValidateContext().getSubEntityType());
            ExtendedDataEntity dataEntity = dataEntities[j];
            dataModel.setRowContext(dataEntity.getDataEntity());
            DynamicObject partner = (DynamicObject)dataModel.getValue(PROP_BIZPARTNER);
            if (null == partner) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5546\u52a1\u4f19\u4f34\u5b57\u6bb5\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BizPartnerUserSaveValidator_5", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                removeIndex[j] = true;
                continue;
            }
            Long partnerId = (Long)partner.getPkValue();
            String partnerEmail = (String)dataModel.getValue(PROP_EMAIL);
            String partnerPhone = (String)dataModel.getValue(PROP_PHONE);
            boolean sameEmail = StringUtils.isNotEmpty((String)partnerEmail) && partnerEmail.equals(email);
            boolean samePhone = StringUtils.isNotEmpty((String)partnerPhone) && partnerPhone.equals(phone);
            boolean bl = isRepetition = partnerId.equals(bizPartnerId) && (sameEmail || samePhone);
            if (!isRepetition) continue;
            removeIndex[j] = true;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u7528\u6237\u5728\u5f53\u524d\u5546\u52a1\u4f19\u4f34\u4e0b\u5df2\u5b58\u5728\u3002", (String)"BizPartnerUserSaveValidator_7", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
    }

    private void existPartnerValidate(RowDataModel rowDataModel, ExtendedDataEntity rowDataEntity, Map<Long, List<DynamicObject>> dbPartnerUsers, Map<String, DynamicObject> dbPartnerUsersFromPhoneAndEmail) {
        DynamicObject bizPartner = (DynamicObject)rowDataModel.getValue(PROP_BIZPARTNER);
        Long bizPartnerId = (Long)bizPartner.getPkValue();
        List<DynamicObject> partnerUsers = dbPartnerUsers.get(bizPartnerId);
        if (!this.isNewPartnerUser(partnerUsers, rowDataEntity)) {
            return;
        }
        DynamicObject user = (DynamicObject)rowDataModel.getValue(PROP_USER);
        String phone = (String)rowDataModel.getValue(PROP_PHONE);
        String email = (String)rowDataModel.getValue(PROP_EMAIL);
        if (!CollectionUtils.isEmpty(partnerUsers)) {
            for (DynamicObject partnerUser : partnerUsers) {
                boolean sameEmail;
                Long dbUser = partnerUser.getLong("user.id");
                if (user != null && user.getPkValue().equals(dbUser)) {
                    rowDataModel.setValue(PROP_USER, (Object)dbUser);
                    this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u8be5\u7528\u6237\u5728\u5f53\u524d\u5546\u52a1\u4f19\u4f34\u4e0b\u5df2\u5b58\u5728\u3002", (String)"BizPartnerUserSaveValidator_7", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    return;
                }
                boolean samePhone = StringUtils.isNotEmpty((String)phone) && phone.equals(partnerUser.getString("user.phone"));
                boolean bl = sameEmail = StringUtils.isNotEmpty((String)email) && email.equals(partnerUser.getString("user.email"));
                if (!samePhone && !sameEmail) continue;
                rowDataModel.setValue(PROP_USER, (Object)dbUser);
                this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u8be5\u7528\u6237\u5728\u5f53\u524d\u5546\u52a1\u4f19\u4f34\u4e0b\u5df2\u5b58\u5728\u3002", (String)"BizPartnerUserSaveValidator_7", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return;
            }
        }
    }

    private boolean isNewPartnerUser(List<DynamicObject> dbPartnerUsers, ExtendedDataEntity rowDataEntity) {
        Object curPkValue = rowDataEntity.getBillPkId();
        if (CollectionUtils.isEmpty(dbPartnerUsers) || curPkValue.equals(0L)) {
            return true;
        }
        for (DynamicObject partnerUser : dbPartnerUsers) {
            if (!curPkValue.equals(partnerUser.getLong("id"))) continue;
            return false;
        }
        return true;
    }

    private void emailValidate(ExtendedDataEntity rowDataEntity, RowDataModel rowDataModel) {
        String email = (String)rowDataModel.getValue(PROP_EMAIL);
        if (StringUtils.isNotEmpty((String)email) && !UserOperationUtils.isEmail((String)email)) {
            this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u90ae\u7bb1\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"BizPartnerUserSaveValidator_8", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
    }

    private void typeValidate(Set<Object> userTypeIdSet, ExtendedDataEntity rowDataEntity, Object userType) {
        String[] types = userType.toString().split(",");
        StringBuilder validateType = new StringBuilder();
        validateType.append(',');
        int count = 0;
        for (String type : types) {
            if (StringUtils.isEmpty((String)type)) continue;
            Long typeId = null;
            try {
                typeId = Long.valueOf(type);
                validateType.append(typeId);
                validateType.append(',');
            }
            catch (Exception e) {
                LOGGER.error(String.format(ResManager.loadKDString((String)"\u7c7b\u578b\u89e3\u6790\u5f02\u5e38\uff0c\u4f20\u5165\u7c7b\u578bid\u4e3a\uff1a%s", (String)"BizPartnerUserSaveValidator_16", (String)SYSTEM_TYPE, (Object[])new Object[0]), type), (Throwable)e);
            }
            if (typeId == null) continue;
            ++count;
            if ("6".equals(typeId.toString()) || "7".equals(typeId.toString())) {
                this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u5546\u52a1\u4f19\u4f34\u7528\u6237\u7c7b\u578b\u4e0d\u5141\u8bb8\u8bbe\u4e3a\u673a\u5668\u4eba\u6216\u7ba1\u7406\u5458\u3002", (String)"BizPartnerUserSaveValidator_9", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return;
            }
            if (count > 5) {
                this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u201c\u7c7b\u578b\u201d\u4e0d\u80fd\u8d85\u8fc75\u79cd\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"BizPartnerUserSaveValidator_10", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return;
            }
            if (userTypeIdSet.contains(typeId)) continue;
            this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u7c7b\u578b\u5b57\u6bb5\u503c\u6709\u8bef\u3002", (String)"BizPartnerUserSaveValidator_11", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return;
        }
        if (count <= 0) {
            this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u7c7b\u578b\u5b57\u6bb5\u8bf7\u81f3\u5c11\u9009\u4e2d\u4e00\u79cd\u3002", (String)"BizPartnerUserSaveValidator_12", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        rowDataEntity.setValue(PROP_TYPE, (Object)validateType.toString());
    }

    private Map<Long, List<DynamicObject>> getBizPartnerUserFromDb(Set<Long> currentPartnerIds, Set<Long> currentUserIds, Map<Long, DynamicObject> adminPartnerMap, Map<Long, Boolean> staffMap) {
        if (CollectionUtils.isEmpty(currentPartnerIds)) {
            return Collections.emptyMap();
        }
        HashMap<Long, List<DynamicObject>> partnerUserMap = new HashMap<Long, List<DynamicObject>>(16);
        QFilter filter = new QFilter(PROP_BIZPARTNER, "in", currentPartnerIds);
        QFilter adminFilter = new QFilter(PROP_ISADMIN, "=", (Object)true);
        QFilter userQFilter = new QFilter(PROP_USER, "in", currentUserIds);
        adminFilter.or(userQFilter);
        filter.and(adminFilter);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)MAINENTITY_BIZPARTNERUSER, (String)SELECT_FIELDS, (QFilter[])filter.toArray());
        for (DynamicObject dynamicObject : collection) {
            Long partnerId = dynamicObject.getLong("bizpartner.id");
            List partnerUsers = partnerUserMap.computeIfAbsent(partnerId, k -> new ArrayList(10));
            if (dynamicObject.getBoolean("enable")) {
                partnerUsers.add(dynamicObject);
            }
            if (dynamicObject.getBoolean(PROP_ISADMIN)) {
                adminPartnerMap.put(partnerId, dynamicObject);
            }
            Long userID = dynamicObject.getLong("user.id");
            Long userType = dynamicObject.getLong("user.usertypes.fbasedataid");
            boolean isStaff = userType.equals(1L);
            boolean lastRecord = staffMap.getOrDefault(userID, false);
            if (lastRecord) continue;
            staffMap.put(userID, isStaff);
        }
        return partnerUserMap;
    }
}

