/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.opplugin;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import java.util.TreeSet;
import kd.bos.base.utils.user.UserUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public class BizPartnerUserUtils {
    public static final String TYPE = "type";
    public static final String USER_TYPE_SEPARATOR = ",";
    public static final String USER = "user";
    public static final String USER_TYPE = "usertype";
    public static final String USER_TYPES = "usertypes";
    public static final String ENTITY_BIZPARTNER_USER = "bos_bizpartneruser";
    public static final String USER_TYPE_STAFF_ID = "1";

    public static String getUserType(DynamicObject partnerUser) {
        return BizPartnerUserUtils.parseUserTypeToString(BizPartnerUserUtils.getUserTypeSet(partnerUser));
    }

    public static String getUserType(DynamicObject partnerUser, boolean isInternalPartner, boolean isInternalUserType) {
        return BizPartnerUserUtils.parseUserTypeToString(BizPartnerUserUtils.getUserTypeSet(partnerUser, isInternalPartner, isInternalUserType));
    }

    public static TreeSet<String> getUserTypeSet(DynamicObject partnerUser) {
        Long staffTypeId = 1L;
        return BizPartnerUserUtils.getUserTypeSet(partnerUser, BizPartnerUserUtils.isInternalPartner(partnerUser), UserUtils.checkUserType((DynamicObject)partnerUser.getDynamicObject(USER), (Long)staffTypeId));
    }

    public static TreeSet<String> getUserTypeSet(DynamicObject partnerUser, boolean isInternalPartner, boolean isInternalUserType) {
        if (partnerUser == null) {
            return new TreeSet<String>();
        }
        TreeSet<String> orderTypeSet = new TreeSet<String>();
        String userType = partnerUser.getString(TYPE);
        if (userType != null) {
            String[] types;
            for (String type : types = userType.split(USER_TYPE_SEPARATOR)) {
                if (!StringUtils.isNotBlank((CharSequence)type)) continue;
                orderTypeSet.add(type);
            }
        }
        if (isInternalPartner && isInternalUserType) {
            orderTypeSet.add(USER_TYPE_STAFF_ID);
        }
        return orderTypeSet;
    }

    public static String parseUserTypeToString(TreeSet<String> userTypeSet) {
        if (userTypeSet == null || userTypeSet.isEmpty()) {
            return "";
        }
        StringJoiner userTypeSj = new StringJoiner(USER_TYPE_SEPARATOR);
        for (String type : userTypeSet) {
            userTypeSj.add(type);
        }
        return userTypeSj.toString();
    }

    public static boolean isInternalPartner(DynamicObject partnerUser) {
        if (partnerUser == null) {
            return false;
        }
        DynamicObject bizpartner = partnerUser.getDynamicObject("bizpartner");
        if (bizpartner == null) {
            return false;
        }
        try {
            return bizpartner.getDynamicObject("internal_company") != null;
        }
        catch (Exception e) {
            DynamicObject bizPartnerObj = BusinessDataServiceHelper.loadSingleFromCache((Object)bizpartner.getPkValue(), (String)"bd_bizpartner");
            return bizPartnerObj != null && bizPartnerObj.getDynamicObject("internal_company") != null;
        }
    }

    public static Map<Long, TreeSet<String>> getOtherBizPartnerUserType(Collection<Long> userIds) {
        if (userIds == null || userIds.isEmpty()) {
            return new HashMap<Long, TreeSet<String>>(0);
        }
        QFilter userFilter = new QFilter(USER, "in", userIds);
        QFilter[] filters = new QFilter[]{userFilter};
        DynamicObjectCollection partnerUserObjCol = QueryServiceHelper.query((String)ENTITY_BIZPARTNER_USER, (String)"user,usertype", (QFilter[])filters);
        if (CollectionUtils.isEmpty((Collection)partnerUserObjCol)) {
            return new HashMap<Long, TreeSet<String>>(0);
        }
        HashMap<Long, TreeSet<String>> userTypeMap = new HashMap<Long, TreeSet<String>>(partnerUserObjCol.size());
        for (DynamicObject partnerUserObj : partnerUserObjCol) {
            String[] userTypeArr;
            String userTypeStr;
            long userId = partnerUserObj.getLong(USER);
            TreeSet<String> userTypeSet = (TreeSet<String>)userTypeMap.get(userId);
            if (userTypeSet == null) {
                userTypeSet = new TreeSet<String>();
                userTypeMap.put(userId, userTypeSet);
            }
            if (StringUtils.isBlank((CharSequence)(userTypeStr = partnerUserObj.getString(USER_TYPE)))) continue;
            for (String userType : userTypeArr = userTypeStr.split(USER_TYPE_SEPARATOR)) {
                if (!StringUtils.isNotBlank((CharSequence)userType)) continue;
                userTypeSet.add(userType);
            }
        }
        return userTypeMap;
    }

    public static boolean isAdmin(DynamicObject user) {
        if (user == null) {
            return false;
        }
        DynamicObjectCollection types = user.getDynamicObjectCollection(USER_TYPES);
        if (types == null || types.size() == 0) {
            return false;
        }
        for (DynamicObject typeObject : types) {
            DynamicObject userTypeObject = typeObject.getDynamicObject("fbasedataid");
            if (!"7".equals(userTypeObject.getPkValue().toString())) continue;
            return true;
        }
        return false;
    }
}

