/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.opplugin;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.helper.PermRoleHelper;
import kd.bos.permission.cache.helper.UserHelper;
import kd.bos.permission.model.perm.ComRoleFieldPermScheme;
import kd.bos.permission.model.perm.UserFieldPermScheme;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class FieldPermSchemeDelValidator
extends AbstractValidator {
    private static final String SYSTEM_TYPE = "bos-permission-opplugin";
    private static final String USER_MAIN_ENTITY_TYPE = "bos_user";
    private static final String BIZAPP_MAIN_ENTITY_TYPE = "bos_devportal_bizapp";
    private static final String ENTOBJ_MAIN_ENTITY_TYPE = "bos_entityobject";
    private static final String PERMITEM_MAIN_ENTITY_TYPE = "perm_permitem";
    private static final String PROP_NUMBER = "number";
    private static final String PROP_NAME = "name";
    private static final Log logger = LogFactory.getLog(FieldPermSchemeDelValidator.class);

    public void validate() {
        HashMap<Long, ExtendedDataEntity> idAndObjMap = new HashMap<Long, ExtendedDataEntity>(8);
        for (ExtendedDataEntity dynamicObject : this.dataEntities) {
            Long billPkd = (Long)dynamicObject.getBillPkId();
            if (billPkd == null || billPkd == 0L) continue;
            idAndObjMap.put(billPkd, dynamicObject);
        }
        StringBuilder queryEnable = new StringBuilder();
        queryEnable.append("select fid from t_perm_fieldscheme where fenable = '0' ");
        Set busiIdSet = idAndObjMap.keySet();
        List busiIds = busiIdSet.stream().map(String::valueOf).collect(Collectors.toList());
        String busiIdStr = String.join((CharSequence)",", busiIds);
        queryEnable.append(" and fid in (").append(busiIdStr).append(")");
        List queryEnableResult = (List)DB.query((DBRoute)DBRoute.permission, (String)queryEnable.toString(), (ResultSetHandler)new ResultSetHandler<List<Long>>(){

            public List<Long> handle(ResultSet rs) throws Exception {
                ArrayList<Long> ids = new ArrayList<Long>(8);
                while (rs.next()) {
                    Long fid = rs.getLong("fid");
                    ids.add(fid);
                }
                return ids;
            }
        });
        for (Object enableId : queryEnableResult) {
            String string = ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff0c\u201c\u7981\u7528\u201d\u72b6\u6001\u7684\u201c\u5b57\u6bb5\u6743\u9650\u65b9\u6848\u201d\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"FieldPermSchemeDelValidator_0", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            this.addErrorMessage((ExtendedDataEntity)idAndObjMap.remove(enableId), string);
        }
        if (CollectionUtils.isEmpty(idAndObjMap)) {
            return;
        }
        Map fpsComRoleIdSetMap = PermRoleHelper.getFpsComRoleMap(busiIdSet);
        if (null != fpsComRoleIdSetMap && !fpsComRoleIdSetMap.isEmpty()) {
            for (Map.Entry entry : fpsComRoleIdSetMap.entrySet()) {
                Long fpdId = (Long)entry.getKey();
                Set value = (Set)entry.getValue();
                if (null == fpdId || Objects.equals(0L, fpdId) || null == value || value.isEmpty()) continue;
                ArrayList crfpsList = new ArrayList(value);
                ComRoleFieldPermScheme crfps = (ComRoleFieldPermScheme)crfpsList.get(0);
                String number = crfps.getNumber();
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < crfpsList.size(); ++i) {
                    ComRoleFieldPermScheme comRoleFieldPermScheme = (ComRoleFieldPermScheme)crfpsList.get(i);
                    if (null == comRoleFieldPermScheme) continue;
                    if (0 == i) {
                        sb.append(comRoleFieldPermScheme.getRoleName());
                        continue;
                    }
                    sb.append("\u3001").append(comRoleFieldPermScheme.getRoleName());
                }
                String errorInfo = String.format(ResManager.loadKDString((String)"\u7f16\u7801\uff1a%1$s\u7684\u5b57\u6bb5\u65b9\u6848\u88ab\u901a\u7528\u89d2\u8272\uff08%2$s\uff09\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664\u3002\u5982\u4e0d\u9700\u8981\u4f7f\u7528\uff0c\u53ef\u4ee5\u5c06\u5176\u7981\u7528\u3002", (String)"FieldPermSchemeDelValidator_1", (String)SYSTEM_TYPE, (Object[])new Object[0]), number, sb.toString());
                this.addErrorMessage((ExtendedDataEntity)idAndObjMap.remove(fpdId), errorInfo);
            }
        }
        if (CollectionUtils.isEmpty(idAndObjMap)) {
            return;
        }
        Map fpsUserMap = UserHelper.getFpsUserMap(busiIdSet);
        if (null != fpsUserMap && !fpsUserMap.isEmpty()) {
            for (Map.Entry fpsUserSet : fpsUserMap.entrySet()) {
                Long fpdId = (Long)fpsUserSet.getKey();
                Set value = (Set)fpsUserSet.getValue();
                if (null == fpdId || Objects.equals(0L, fpdId) || null == value || value.isEmpty()) continue;
                ArrayList ufpsList = new ArrayList(value);
                UserFieldPermScheme ufps = (UserFieldPermScheme)ufpsList.get(0);
                String number = ufps.getNumber();
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < ufpsList.size(); ++i) {
                    UserFieldPermScheme userFieldPermScheme = (UserFieldPermScheme)ufpsList.get(i);
                    if (null == userFieldPermScheme) continue;
                    if (0 == i) {
                        sb.append(userFieldPermScheme.getUserName());
                        continue;
                    }
                    sb.append("\u3001").append(userFieldPermScheme.getUserName());
                }
                String errorInfo = String.format(ResManager.loadKDString((String)"\u7f16\u7801\uff1a%1$s\u7684\u5b57\u6bb5\u65b9\u6848\u88ab\u7528\u6237\uff08%2$s\uff09\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664\u3002\u5982\u4e0d\u9700\u8981\u4f7f\u7528\uff0c\u53ef\u4ee5\u5c06\u5176\u7981\u7528\u3002", (String)"FieldPermSchemeDelValidator_2", (String)SYSTEM_TYPE, (Object[])new Object[0]), number, sb.toString());
                this.addErrorMessage((ExtendedDataEntity)idAndObjMap.remove(fpdId), errorInfo);
            }
        }
        if (CollectionUtils.isEmpty(idAndObjMap)) {
            return;
        }
    }

    private Map<Object, DynamicObject> loadDimInfo(List<Long> dimObjIdList, String dimEntNum) {
        Map dimObjInfoMapLoadFromDb = BusinessDataServiceHelper.loadFromCache((Object[])dimObjIdList.toArray(), (String)dimEntNum);
        return dimObjInfoMapLoadFromDb;
    }
}

