/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.opplugin;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.FormHelper;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.factory.PermServiceFactory;
import kd.bos.permission.log.helper.PermLogHelper;
import kd.bos.permission.log.helper.PermRoleLogHelper;
import kd.bos.permission.model.perm.PermBuilder;
import kd.bos.permission.model.perm.req.PermLogReq;
import kd.bos.permission.model.perm.req.PermOperationReq;
import kd.bos.permission.model.perm.req.bat.afterdel.ComRoleAfterDelReq;
import kd.bos.permission.opplugin.AdminCanModifyComRoleValidator;
import kd.bos.permission.opplugin.RoleDelValidator;
import kd.bos.permission.service.ComRoleService;
import kd.bos.util.StringUtils;

public class RoleDelOP
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(RoleDelOP.class);
    private static final String[] PERM_IGNOREREFENTITYIDS = new String[]{"perm_roleperm", "perm_rolefieldperm", "perm_roledataperm", "perm_userrole", "perm_roledatarules", "perm_userrole_multype", "perm_role", "perm_busirole", "perm_rolefuncperm", "perm_rolefieldscheme", "perm_admingrouprole", "perm_roledatarule", "perm_roledatarule_prop"};

    private static ComRoleService getComRoleService() {
        return (ComRoleService)PermServiceFactory.getService((String)"ComRoleService");
    }

    private Map<String, String> getOptionVariables() {
        Map variables = this.getOption().getVariables();
        variables = null == variables ? new HashMap(8) : variables;
        return variables;
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        Set ignorerefentityNumSet = FormHelper.getIgnoreRefEntNumSet((String[])PERM_IGNOREREFENTITYIDS);
        this.getOption().setVariableValue("ignorerefentityids", String.join((CharSequence)",", ignorerefentityNumSet));
        e.getValidators().add(new RoleDelValidator());
        e.getValidators().add(new AdminCanModifyComRoleValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        try {
            super.beginOperationTransaction(e);
            DynamicObject[] dataEntities = e.getDataEntities();
            if (null == dataEntities || Objects.equals(0, dataEntities.length)) {
                return;
            }
            Map<String, String> variables = this.getOptionVariables();
            String preDataMapStr = variables.get("preDataMap");
            if (StringUtils.isEmpty((String)preDataMapStr)) {
                Set roleIdSet = Arrays.stream(dataEntities).map(x -> String.valueOf(x.getPkValue())).collect(Collectors.toSet());
                Map preDataMap = PermRoleLogHelper.commRoleEventImage(roleIdSet, (boolean)false, (boolean)true);
                this.getOption().setVariableValue("preDataMap", StrUtil.compress((String)new ObjectMapper().writeValueAsString((Object)preDataMap)));
            }
        }
        catch (Exception ex) {
            log.error("RoleDelOP.beginOperationTransaction error.", (Throwable)ex);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff1a%1$s", (String)"RoleDelOP_0", (String)"bos-permission-opplugin", (Object[])new Object[0]), ex.getMessage()));
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        try {
            DynamicObject[] dataEntities = e.getDataEntities();
            if (null == dataEntities || Objects.equals(0, dataEntities.length)) {
                return;
            }
            HashSet<String> roleIdSet = new HashSet<String>(8);
            for (DynamicObject dyn : dataEntities) {
                if (null == dyn) continue;
                String roleId = dyn.getString("id");
                roleIdSet.add(roleId);
            }
            Map<String, String> variables = this.getOptionVariables();
            String entNum = dataEntities[0].getDynamicObjectType().getName();
            PermLogReq permLogReq = PermLogHelper.wrapOperPermLogReq(variables, (String)entNum, (String)"common_role_del", (String)"delete", (String)ConstantsHelper.getDel(), (String)"kd.bos.permission.opplugin.RoleDelOP.endOperationTransaction");
            String preDataMapStr = variables.get("preDataMap");
            String appNum = variables.get("currbizappid");
            ComRoleAfterDelReq afterReq = (ComRoleAfterDelReq)PermBuilder.of(ComRoleAfterDelReq::new).with(PermOperationReq::setCurAppNum, (Object)appNum).with(PermOperationReq::setMainIdSet, roleIdSet).with(PermOperationReq::setPermLogReq, (Object)permLogReq).with(PermOperationReq::setPreDataMapStr, (Object)preDataMapStr).build();
            RoleDelOP.getComRoleService().afterDel((PermOperationReq)afterReq);
            super.endOperationTransaction(e);
        }
        catch (Exception ex) {
            log.error("RoleDelOP.afterExecuteOperationTransaction error.", (Throwable)ex);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff1a%1$s", (String)"RoleDelOP_0", (String)"bos-permission-opplugin", (Object[])new Object[0]), ex.getMessage()));
        }
    }
}

