/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.opplugin;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.factory.PermServiceFactory;
import kd.bos.permission.log.helper.PermLogHelper;
import kd.bos.permission.log.helper.PermRoleLogHelper;
import kd.bos.permission.model.perm.PermBuilder;
import kd.bos.permission.model.perm.req.PermLogReq;
import kd.bos.permission.model.perm.req.PermOperationReq;
import kd.bos.permission.model.perm.req.bat.aftersave.ComRoleAfterSaveReq;
import kd.bos.permission.opplugin.AdminCanModifyComRoleValidator;
import kd.bos.permission.service.ComRoleService;
import kd.bos.util.StringUtils;

public class RoleDisableOP
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(RoleDisableOP.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new AdminCanModifyComRoleValidator());
    }

    private Map<String, String> getOptionVariables() {
        Map variables = this.getOption().getVariables();
        variables = null == variables ? new HashMap(8) : variables;
        return variables;
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        try {
            super.beginOperationTransaction(e);
            DynamicObject[] dataEntities = e.getDataEntities();
            if (null == dataEntities || Objects.equals(0, dataEntities.length)) {
                return;
            }
            Map<String, String> variables = this.getOptionVariables();
            String preDataMapStr = variables.get("preDataMap");
            if (StringUtils.isEmpty((String)preDataMapStr)) {
                Set roleIdSet = Arrays.stream(dataEntities).map(x -> String.valueOf(x.getPkValue())).collect(Collectors.toSet());
                Map preDataMap = PermRoleLogHelper.commRoleEventImage(roleIdSet, (boolean)false, (boolean)true);
                this.getOption().setVariableValue("preDataMap", StrUtil.compress((String)new ObjectMapper().writeValueAsString((Object)preDataMap)));
            }
        }
        catch (Exception ex) {
            log.error("RoleDisableOP.beginOperationTransaction error.", (Throwable)ex);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7981\u7528\u5931\u8d25\uff1a%1$s", (String)"RoleDisableOP_0", (String)"bos-permission-opplugin", (Object[])new Object[0]), ex.getMessage()));
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        try {
            DynamicObject[] dataEntities = e.getDataEntities();
            if (null == dataEntities || Objects.equals(0, dataEntities.length)) {
                return;
            }
            Map<String, String> variables = this.getOptionVariables();
            Set roleIdSet = Arrays.stream(dataEntities).map(dyn -> dyn.getString("id")).collect(Collectors.toSet());
            String formNum = dataEntities[0].getDynamicObjectType().getName();
            PermLogReq permLogReq = PermLogHelper.wrapOperPermLogReq(variables, (String)formNum, (String)"common_role_disable", (String)"disable", (String)ConstantsHelper.getDisable(), (String)"kd.bos.permission.opplugin.RoleDisableOP.endOperationTransaction");
            String preDataMapStr = variables.get("preDataMap");
            String appNum = variables.get("currbizappid");
            ComRoleAfterSaveReq afterReq = (ComRoleAfterSaveReq)PermBuilder.of(ComRoleAfterSaveReq::new).with(PermOperationReq::setCurAppNum, (Object)appNum).with(PermOperationReq::setMainIdSet, roleIdSet).with(PermOperationReq::setPermLogReq, (Object)permLogReq).with(PermOperationReq::setPreDataMapStr, (Object)preDataMapStr).build();
            RoleDisableOP.getComRoleService().afterMainEntitySave((PermOperationReq)afterReq);
            super.endOperationTransaction(e);
        }
        catch (Exception ex) {
            log.error("RoleDisableOP.endOperationTransaction error.", (Throwable)ex);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7981\u7528\u5931\u8d25\uff1a%1$s", (String)"RoleDisableOP_0", (String)"bos-permission-opplugin", (Object[])new Object[0]), ex.getMessage()));
        }
    }

    private static ComRoleService getComRoleService() {
        ComRoleService comRoleService = (ComRoleService)PermServiceFactory.getService((String)"ComRoleService");
        return comRoleService;
    }
}

