/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.opplugin;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.PermRoleHelper;
import kd.bos.permission.cache.util.DataRuleInfoSerializeUtil;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.enums.EnumsUseScope;
import kd.bos.permission.factory.PermServiceFactory;
import kd.bos.permission.log.helper.PermRoleLogHelper;
import kd.bos.permission.log.model.PermLogBusiType;
import kd.bos.permission.log.service.PermLogService;
import kd.bos.permission.model.perm.ComRoleAdminGrp;
import kd.bos.permission.model.perm.ComRoleFieldPermScheme;
import kd.bos.permission.model.perm.NewDrPerm;
import kd.bos.permission.model.perm.NewDrPrPerm;
import kd.bos.permission.model.perm.PermBuilder;
import kd.bos.permission.model.perm.comrole.ComRoleFieldPerm;
import kd.bos.permission.model.perm.comrole.ComRoleFuncPerm;
import kd.bos.permission.model.perm.req.PermLogReq;
import kd.bos.permission.model.perm.req.PermOperationReq;
import kd.bos.permission.model.perm.req.bat.aftersave.ComRoleAfterSaveReq;
import kd.bos.permission.opplugin.AdminCanModifyComRoleValidator;
import kd.bos.permission.service.ComRoleService;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.util.StringUtils;

public class RoleSaveOP
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(RoleSaveOP.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new AdminCanModifyComRoleValidator());
    }

    private Map<String, String> getOptionVariables() {
        Map variables = this.getOption().getVariables();
        variables = null == variables ? new HashMap(8) : variables;
        return variables;
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        try {
            super.beginOperationTransaction(e);
            DynamicObject[] dataEntities = e.getDataEntities();
            if (null == dataEntities || Objects.equals(0, dataEntities.length)) {
                return;
            }
            Map<String, String> variables = this.getOptionVariables();
            String preDataMapStr = variables.get("preDataMap");
            if (StringUtils.isEmpty((String)preDataMapStr)) {
                Set roleIdSet = Arrays.stream(dataEntities).map(x -> String.valueOf(x.getPkValue())).collect(Collectors.toSet());
                Map preDataMap = PermRoleLogHelper.commRoleEventImage(roleIdSet, (boolean)false, (boolean)true);
                this.getOption().setVariableValue("preDataMap", StrUtil.compress((String)new ObjectMapper().writeValueAsString((Object)preDataMap)));
            }
        }
        catch (Exception ex) {
            log.error("RoleSaveOP.beginOperationTransaction error.", (Throwable)ex);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a%1$s", (String)"RoleSaveOP_0", (String)"bos-permission-opplugin", (Object[])new Object[0]), ex.getMessage()));
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        try {
            String willAddRoleFieldPermMapStr;
            String willAddFpsMapStr;
            String willAddFuncPermMapStr;
            super.endOperationTransaction(e);
            DynamicObject[] dataEntities = e.getDataEntities();
            if (null == dataEntities || Objects.equals(0, dataEntities.length)) {
                return;
            }
            Map<String, String> variables = this.getOptionVariables();
            Map willDelFuncPermMap = new HashMap(8);
            HashMap<String, Set<ComRoleFuncPerm>> willAddFuncPermMap = new HashMap(8);
            String willDelFuncPermMapStr = variables.get("willDelFuncPermMap");
            if (StringUtils.isNotEmpty((String)willDelFuncPermMapStr)) {
                willDelFuncPermMap = (Map)new ObjectMapper().readValue(willDelFuncPermMapStr, (TypeReference)new TypeReference<HashMap<String, Set<ComRoleFuncPerm>>>(){});
            }
            if (StringUtils.isNotEmpty((String)(willAddFuncPermMapStr = variables.get("willAddFuncPermMap")))) {
                willAddFuncPermMap = (Map)new ObjectMapper().readValue(willAddFuncPermMapStr, (TypeReference)new TypeReference<HashMap<String, Set<ComRoleFuncPerm>>>(){});
            }
            Map willDelFpsMap = new HashMap(8);
            Map willAddFpsMap = new HashMap(8);
            String willDelFpsMapStr = variables.get("willDelFpsMap");
            if (StringUtils.isNotEmpty((String)willDelFpsMapStr)) {
                willDelFpsMap = (Map)new ObjectMapper().readValue(willDelFpsMapStr, (TypeReference)new TypeReference<HashMap<String, Set<ComRoleFieldPermScheme>>>(){});
            }
            if (StringUtils.isNotEmpty((String)(willAddFpsMapStr = variables.get("willAddFpsMap")))) {
                willAddFpsMap = (Map)new ObjectMapper().readValue(willAddFpsMapStr, (TypeReference)new TypeReference<HashMap<String, Set<ComRoleFieldPermScheme>>>(){});
            }
            Map willDelRoleFieldPermMap = new HashMap(8);
            Map willAddRoleFieldPermMap = new HashMap(8);
            String willDelRoleFieldPermMapStr = variables.get("willDelRoleFieldPermMap");
            if (StringUtils.isNotEmpty((String)willDelRoleFieldPermMapStr)) {
                willDelRoleFieldPermMap = (Map)new ObjectMapper().readValue(willDelRoleFieldPermMapStr, (TypeReference)new TypeReference<HashMap<String, Set<ComRoleFieldPerm>>>(){});
            }
            if (StringUtils.isNotEmpty((String)(willAddRoleFieldPermMapStr = variables.get("willAddRoleFieldPermMap")))) {
                willAddRoleFieldPermMap = (Map)new ObjectMapper().readValue(willAddRoleFieldPermMapStr, (TypeReference)new TypeReference<HashMap<String, Set<ComRoleFieldPerm>>>(){});
            }
            boolean hasEnableRoleDataRuleNewModel = PermCommonUtil.hasEnableRoleDataRuleNewModel();
            Map willDelDrMap = new HashMap(8);
            Map willAddDrMap = new HashMap(8);
            Map<Object, Object> willDelDrPermMap = new HashMap(8);
            Map<Object, Object> willAddDrPermMap = new HashMap(8);
            Map<Object, Object> willDelDrPrMap = new HashMap(8);
            Map<Object, Object> willAddDrPrMap = new HashMap(8);
            if (hasEnableRoleDataRuleNewModel) {
                willDelDrPermMap = this.getNewDrPermMap(variables, "willDelDrPermMap");
                willAddDrPermMap = this.getNewDrPermMap(variables, "willAddDrPermMap");
                willDelDrPrMap = this.getNewDrPrPermMap(variables, "willDelDrPrMap");
                willAddDrPrMap = this.getNewDrPrPermMap(variables, "willAddDrPrMap");
            } else {
                String willAddDrMapStr;
                String willDelDrMapStr = variables.get("willDelDrMap");
                if (StringUtils.isNotEmpty((String)willDelDrMapStr)) {
                    willDelDrMap = DataRuleInfoSerializeUtil.fromJsonStrForDataRulesInfoMap((String)willDelDrMapStr);
                }
                if (StringUtils.isNotEmpty((String)(willAddDrMapStr = variables.get("willAddDrMap")))) {
                    willAddDrMap = DataRuleInfoSerializeUtil.fromJsonStrForDataRulesInfoMap((String)willAddDrMapStr);
                }
            }
            HashSet<String> willDelAdmGroupRoleIdSet = new HashSet(8);
            HashMap<String, Set<ComRoleAdminGrp>> willAddAdmGrpMap = new HashMap<String, Set<ComRoleAdminGrp>>(8);
            String willDelAdmGroupRoleIdSetStr = variables.get("willDelAdmGroupRoleIdSet");
            if (StringUtils.isNotEmpty((String)willDelAdmGroupRoleIdSetStr)) {
                willDelAdmGroupRoleIdSet = (Set)new ObjectMapper().readValue(willDelAdmGroupRoleIdSetStr, (TypeReference)new TypeReference<HashSet<String>>(){});
            }
            HashSet<String> roleIdSet = new HashSet<String>(8);
            Map admGrpMap = PermRoleHelper.queryAdmGrpMap(Arrays.stream(dataEntities).map(dyn -> dyn.getString("id")).collect(Collectors.toSet()));
            Map roleIdAdmGrpId2FidMap = (Map)admGrpMap.get("roleIdAdmGrpId2FidMap");
            for (DynamicObject dyn2 : dataEntities) {
                if (null == dyn2) continue;
                String roleId = dyn2.getString("id");
                roleIdSet.add(roleId);
                RoleSaveOP.fullRoleFuncPermMap(willAddFuncPermMap, dyn2, roleId);
                RoleSaveOP.fullRoleAdmGrpMap(willDelAdmGroupRoleIdSet, willAddAdmGrpMap, dyn2, roleId, roleIdAdmGrpId2FidMap);
            }
            String formNum = dataEntities[0].getDynamicObjectType().getName();
            PermLogReq permLogReq = this.wrapPermLogReq(variables, formNum);
            String preDataMapStr = variables.get("preDataMap");
            String appNum = variables.get("currbizappid");
            ComRoleAfterSaveReq afterSaveReq = (ComRoleAfterSaveReq)PermBuilder.of(ComRoleAfterSaveReq::new).with(PermOperationReq::setCurAppNum, (Object)appNum).with(PermOperationReq::setMainIdSet, roleIdSet).with(PermOperationReq::setPermLogReq, (Object)permLogReq).with(ComRoleAfterSaveReq::setWillDelFuncPermMap, willDelFuncPermMap).with(ComRoleAfterSaveReq::setWillAddFuncPermMap, willAddFuncPermMap).with(ComRoleAfterSaveReq::setWillDelFpsMap, willDelFpsMap).with(ComRoleAfterSaveReq::setWillAddFpsMap, willAddFpsMap).with(ComRoleAfterSaveReq::setWillDelRoleFieldPermMap, willDelRoleFieldPermMap).with(ComRoleAfterSaveReq::setWillAddRoleFieldPermMap, willAddRoleFieldPermMap).with(ComRoleAfterSaveReq::setWillDelDrMap, willDelDrMap).with(ComRoleAfterSaveReq::setWillAddDrMap, willAddDrMap).with(ComRoleAfterSaveReq::setWillDelDrPermMap, willDelDrPermMap).with(ComRoleAfterSaveReq::setWillAddDrPermMap, willAddDrPermMap).with(ComRoleAfterSaveReq::setWillDelDrPrMap, willDelDrPrMap).with(ComRoleAfterSaveReq::setWillAddDrPrMap, willAddDrPrMap).with(ComRoleAfterSaveReq::setWillDelAdmGroupRoleIdSet, willDelAdmGroupRoleIdSet).with(ComRoleAfterSaveReq::setWillAddAdmGrpMap, willAddAdmGrpMap).with(PermOperationReq::setPreDataMapStr, (Object)preDataMapStr).build();
            RoleSaveOP.getComRoleService().afterMainEntitySave((PermOperationReq)afterSaveReq);
        }
        catch (Exception ex) {
            log.error("RoleSaveOP.endOperationTransaction error.", (Throwable)ex);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a%1$s", (String)"RoleSaveOP_0", (String)"bos-permission-opplugin", (Object[])new Object[0]), ex.getMessage()));
        }
    }

    private Map<String, List<NewDrPrPerm>> getNewDrPrPermMap(Map<String, String> variables, String jsonKey) {
        Map<String, List<Object>> map = new HashMap<String, List<NewDrPrPerm>>(8);
        String jsonStr = variables.get(jsonKey);
        if (StringUtils.isNotEmpty((String)jsonStr)) {
            map = DataRuleInfoSerializeUtil.fromJsonStrForNewDrPrPermMap((String)jsonStr);
        }
        return map;
    }

    private Map<String, List<NewDrPerm>> getNewDrPermMap(Map<String, String> variables, String jsonKey) throws Exception {
        Map<String, List<Object>> map = new HashMap<String, List<NewDrPerm>>(8);
        String jsonStr = variables.get(jsonKey);
        if (StringUtils.isNotEmpty((String)jsonStr)) {
            map = DataRuleInfoSerializeUtil.fromJsonStrForNewDrPermMap((String)jsonStr);
        }
        return map;
    }

    private static void fullRoleAdmGrpMap(Set<String> willDelAdmGroupRoleIdSet, Map<String, Set<ComRoleAdminGrp>> willAddAdmGrpMap, DynamicObject dyn, String roleId, Map<String, String> roleIdAdmGrpId2FidMap) {
        ComRoleAdminGrp comRoleAdminGrp = null;
        String usescope = dyn.getString("usescope");
        if (StringUtils.isNotEmpty((String)usescope) && EnumsUseScope.ASSIGN.getType().equals(usescope)) {
            DynamicObjectCollection entry_assign_admingrpDoc = dyn.getDynamicObjectCollection("entry_assign_admingrp");
            if (null != entry_assign_admingrpDoc && !entry_assign_admingrpDoc.isEmpty()) {
                for (DynamicObject entry_assign_admingrp : entry_assign_admingrpDoc) {
                    if (null == entry_assign_admingrp) continue;
                    comRoleAdminGrp = new ComRoleAdminGrp();
                    String adminGroupId = "";
                    DynamicObject admingrpJSONObject = entry_assign_admingrp.getDynamicObject("admingrp");
                    if (null != admingrpJSONObject && StringUtils.isNotEmpty((String)(adminGroupId = admingrpJSONObject.getString("id")))) {
                        comRoleAdminGrp.setAdminGroupId(adminGroupId);
                    }
                    String fentryId = StringUtils.isEmpty((String)roleIdAdmGrpId2FidMap.get(roleId + "|" + adminGroupId)) ? "" : roleIdAdmGrpId2FidMap.get(roleId + "|" + adminGroupId);
                    String admgrp_entryid = entry_assign_admingrp.getString("admgrp_entryid");
                    comRoleAdminGrp.setRoleId(roleId);
                    comRoleAdminGrp.setEntryId(StringUtils.isEmpty((String)admgrp_entryid) ? fentryId : admgrp_entryid);
                    Boolean rolemodifiable = entry_assign_admingrp.getBoolean("rolemodifiable");
                    comRoleAdminGrp.setModifiable(rolemodifiable.booleanValue());
                    willAddAdmGrpMap.computeIfAbsent(roleId, k -> new HashSet(8)).add(comRoleAdminGrp);
                }
            }
        } else {
            willDelAdmGroupRoleIdSet.add(roleId);
        }
    }

    private static void fullRoleFuncPermMap(Map<String, Set<ComRoleFuncPerm>> willAddFuncPermMap, DynamicObject dyn, String roleId) {
        ComRoleFuncPerm comRoleFuncPerm = null;
        DynamicObjectCollection import_entry_funcpermDoc = dyn.getDynamicObjectCollection("import_entry_funcperm");
        if (null != import_entry_funcpermDoc && !import_entry_funcpermDoc.isEmpty()) {
            for (DynamicObject import_entry_funcperm : import_entry_funcpermDoc) {
                String permItemId;
                DynamicObject import_permitem;
                String entNum;
                DynamicObject import_ent;
                String appId;
                DynamicObject import_app;
                String cloudNum;
                if (null == import_entry_funcperm) continue;
                comRoleFuncPerm = new ComRoleFuncPerm();
                comRoleFuncPerm.setRoleId(roleId);
                String funcperm_entryid = import_entry_funcperm.getString("funcperm_entryid");
                comRoleFuncPerm.setEntryId(StringUtils.isEmpty((String)funcperm_entryid) ? null : funcperm_entryid);
                DynamicObject import_cloud = import_entry_funcperm.getDynamicObject("import_cloud");
                if (null != import_cloud && StringUtils.isNotEmpty((String)(cloudNum = import_cloud.getString("number")))) {
                    comRoleFuncPerm.setCloudNumber(cloudNum);
                }
                if (null != (import_app = import_entry_funcperm.getDynamicObject("import_app")) && StringUtils.isNotEmpty((String)(appId = import_app.getString("id")))) {
                    comRoleFuncPerm.setAppId(appId);
                }
                if (null != (import_ent = import_entry_funcperm.getDynamicObject("import_ent")) && StringUtils.isNotEmpty((String)(entNum = import_ent.getString("number")))) {
                    comRoleFuncPerm.setEntityNumber(entNum);
                }
                if (null != (import_permitem = import_entry_funcperm.getDynamicObject("import_permitem")) && StringUtils.isNotEmpty((String)(permItemId = import_permitem.getString("id")))) {
                    comRoleFuncPerm.setPermItemId(permItemId);
                }
                willAddFuncPermMap.computeIfAbsent(roleId, k -> new HashSet(8)).add(comRoleFuncPerm);
            }
        }
    }

    private PermLogReq wrapPermLogReq(Map<String, String> variables, String entNum) {
        try {
            if (!PermCommonUtil.isEnablePermLog()) {
                return null;
            }
            String entSavePermLog = "";
            String formNum = StringUtils.isEmpty((String)variables.get("permlog_formnum")) ? entNum : variables.get("permlog_formnum");
            String permlog_busitype = "";
            String op = "";
            String opbtn = "";
            String interfacemethod = "";
            String batchimport = variables.get("batchimport");
            if (Objects.equals("true", batchimport)) {
                entSavePermLog = "1";
                permlog_busitype = "common_role_import";
                op = "importdata";
                opbtn = ConstantsHelper.getImportData();
                interfacemethod = "kd.bos.permission.formplugin.plugin.impexp.imp.RoleAndFuncImportPlugin.save";
            } else {
                entSavePermLog = variables.get("ENTSAVE_PERMLOG");
                permlog_busitype = variables.get("permlog_busitype");
                op = variables.get("permlog_op");
                opbtn = variables.get("permlog_opbtn");
                interfacemethod = variables.get("permlog_interfacemethod");
            }
            if (!Objects.equals("1", entSavePermLog)) {
                return null;
            }
            String appNum = variables.get("currbizappid");
            String appId = AppHelper.getMetaAppInfo((String)appNum).getId();
            String appIdByFormNum = StringUtils.isEmpty((String)appId) ? BizAppServiceHelp.getAppIdByFormNum((String)formNum) : appId;
            String cloudId = AppHelper.getMetaAppInfo((String)appId).getCloudId();
            PermLogReq permLogReq = new PermLogReq();
            PermLogBusiType permLogBusiType = PermLogService.getPermLogBusiType((String)permlog_busitype);
            permLogReq.setBusiFrom(null == permLogBusiType ? "" : permLogBusiType.getBusiTypeDesc());
            permLogReq.setBusiType(null == permLogBusiType ? "" : permLogBusiType.getBusiType());
            permLogReq.setFormIdentity(formNum);
            permLogReq.setAppId(appIdByFormNum);
            permLogReq.setCloudId(cloudId);
            permLogReq.setOp(op);
            permLogReq.setOpbtn(opbtn);
            permLogReq.setInterfaceMethod(interfacemethod);
            permLogReq.setQueryFL(true);
            Map preDataMap = new HashMap(8);
            String preDataMapStr = variables.get("preDataMap");
            if (StringUtils.isNotEmpty((String)preDataMapStr)) {
                String uncompress = StrUtil.uncompress((String)preDataMapStr);
                preDataMap = (Map)new ObjectMapper().readValue(uncompress, Map.class);
            }
            permLogReq.setPreDataMap(preDataMap);
            permLogReq.setOperTime(TimeServiceHelper.now());
            permLogReq.setClientType(RequestContext.get().getClient());
            permLogReq.setClientIp(RequestContext.get().getLoginIP());
            return permLogReq;
        }
        catch (Exception e) {
            log.error("RoleSaveOP.wrapPermLogReq error.", (Throwable)e);
            return null;
        }
    }

    private static ComRoleService getComRoleService() {
        ComRoleService comRoleService = (ComRoleService)PermServiceFactory.getService((String)"ComRoleService");
        return comRoleService;
    }
}

