/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.opplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.cache.model.EncryptionScheme;
import kd.bos.permission.service.scheme.EncryptSchemeService;
import kd.bos.service.ServiceFactory;
import kd.bos.util.ExceptionUtils;

public class SchemeSubmitOp
extends AbstractOperationServicePlugIn {
    private static final Log LOG = LogFactory.getLog(SchemeSubmitOp.class);
    private static final String SYSTEM_TYPE = "bos-permission-opplugin";

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities == null || dataEntities.length <= 0) {
            return;
        }
        EncryptSchemeService service = (EncryptSchemeService)ServiceFactory.getService((String)"EncryptSchemeService");
        ArrayList<DynamicObject> errorDataEntities = new ArrayList<DynamicObject>(dataEntities.length);
        ArrayList<DynamicObject> successDataEntities = new ArrayList<DynamicObject>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            this.setSchemeKey(errorDataEntities, successDataEntities, dataEntity, service);
        }
        if (!errorDataEntities.isEmpty()) {
            e.setCancelOperation(true);
            this.getOperationResult().setSuccess(false);
            e.setDataEntities(successDataEntities.toArray(new DynamicObject[0]));
        }
    }

    private OperateErrorInfo createOperateErrorInfo(Object pkId, String errorMsg) {
        OperateErrorInfo info = new OperateErrorInfo("", ErrorLevel.Error, pkId);
        info.setMessage(errorMsg);
        return info;
    }

    private void setSchemeKey(List<DynamicObject> errorDataEntities, List<DynamicObject> successDataEntities, DynamicObject dataEntity, EncryptSchemeService service) {
        try {
            EncryptionScheme scheme = this.getScheme(dataEntity);
            String schemeKey = service.getSchemeKey(scheme);
            if (StringUtils.isBlank((CharSequence)schemeKey)) {
                this.setErrorMsg(errorDataEntities, dataEntity);
                return;
            }
            long schemeId = dataEntity.getLong("id");
            String length = dataEntity.getString("length");
            String algorithm = dataEntity.getString("algorithm");
            String workKey = service.getWorkKey(schemeId, schemeKey);
            JSONObject supportResult = service.encrypt(workKey, algorithm, Integer.parseInt(length), ResManager.loadKDString((String)"\u6570\u636e\u6d4b\u8bd5", (String)"SchemeSubmitOp_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            LOG.debug(String.format(ResManager.loadKDString((String)"\u52a0\u5bc6\u65b9\u6848\u63d0\u4ea4\u6d4b\u8bd5\u7ed3\u679c\uff1a%1$s", (String)"SchemeSubmitOp_4", (String)SYSTEM_TYPE, (Object[])new Object[0]), JSON.toJSONString((Object)supportResult)));
            boolean isSupport = supportResult.getBoolean("success");
            if (!isSupport) {
                String errorMsg = String.format(ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff0c\u5f53\u524d\u73af\u5883\u6682\u4e0d\u652f\u6301\u5bc6\u94a5\u957f\u5ea6\u4e3a%1$s\u7684[%2$s]\u52a0\u5bc6\u7b97\u6cd5\u3002", (String)"SchemeSubmitOp_1", (String)SYSTEM_TYPE, (Object[])new Object[0]), length, algorithm);
                this.setErrorMsg(errorDataEntities, dataEntity, errorMsg);
                return;
            }
            dataEntity.set("scheme_key", (Object)schemeKey);
            successDataEntities.add(dataEntity);
        }
        catch (Exception ex) {
            LOG.error(String.format(ResManager.loadKDString((String)"\u52a0\u5bc6\u65b9\u6848id\u5931\u8d25\uff0c\u539f\u56e0\uff1a%1$s", (String)"SchemeSubmitOp_3", (String)SYSTEM_TYPE, (Object[])new Object[0]), ExceptionUtils.getExceptionStackTraceMessage((Exception)ex)));
            this.setErrorMsg(errorDataEntities, dataEntity);
        }
    }

    private void setErrorMsg(List<DynamicObject> errorDataEntities, DynamicObject dataEntity) {
        String errorMsg = ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u65e5\u5fd7\u3002", (String)"SchemeSubmitOp_2", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        this.setErrorMsg(errorDataEntities, dataEntity, errorMsg);
    }

    private void setErrorMsg(List<DynamicObject> errorDataEntities, DynamicObject dataEntity, String errorMsg) {
        OperateErrorInfo info = this.createOperateErrorInfo(dataEntity.getPkValue(), errorMsg);
        this.getOperationResult().addErrorInfo(info);
        errorDataEntities.add(dataEntity);
    }

    private EncryptionScheme getScheme(DynamicObject dataEntity) {
        EncryptionScheme scheme = new EncryptionScheme();
        scheme.setPkId(dataEntity.getLong("id"));
        scheme.setNumber(dataEntity.getString("number"));
        scheme.setName(dataEntity.getString("name"));
        scheme.setAlgorithm(dataEntity.getString("algorithm"));
        scheme.setLength(Integer.parseInt(dataEntity.getString("length")));
        scheme.setSource(dataEntity.getString("source"));
        scheme.setTrustDataKey(dataEntity.getString("trust_data_key_tag"));
        return scheme;
    }
}

