/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.opplugin.validator.del.admingroup;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.helper.AdminSchemeHelper;
import kd.bos.permission.model.PermResult;
import kd.bos.permission.model.perm.PermBuilder;
import kd.bos.permission.model.perm.admingroup.AdmGrp;
import kd.bos.permission.model.perm.req.admin.delcheck.DelCheckAdmGrpReq;
import kd.bos.permission.model.perm.req.admin.get.GetAdmGrpReq;
import kd.bos.permission.service.AdminGroupService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class AdmGrpDelValidator
extends AbstractValidator {
    public void validate() {
        Set mainIdSet = Arrays.stream(this.dataEntities).map(x -> (Long)x.getBillPkId()).collect(Collectors.toSet());
        if (null == mainIdSet || mainIdSet.isEmpty()) {
            return;
        }
        long currUserId = RequestContext.get().getCurrUserId();
        Long curEnableSchemeId = AdminSchemeHelper.getCurEnableSchemeId();
        Set canOperAdmGroupIdSet = AdminGroupService.getCanOperAdmGroupIdSet((Long)currUserId, (boolean)true, (String)"0");
        boolean curUserIsAdmin = PermissionServiceHelper.isAdminUser((long)currUserId);
        Map dataMap = AdminGroupService.getAdmGrpMap((GetAdmGrpReq)((GetAdmGrpReq)PermBuilder.of(GetAdmGrpReq::new).with(GetAdmGrpReq::setAdmGrpIdSet, mainIdSet).build()));
        StringBuilder errorInfo = new StringBuilder();
        for (ExtendedDataEntity dyn : this.dataEntities) {
            Long billPkId;
            Object billPkIdObj = dyn.getBillPkId();
            if (null == billPkIdObj || null == (billPkId = (Long)billPkIdObj) || Objects.equals(0L, billPkId)) continue;
            AdmGrp curAdmGrpInfo = (AdmGrp)dataMap.get(billPkId);
            PermResult checkRes = this.check((DelCheckAdmGrpReq)PermBuilder.of(DelCheckAdmGrpReq::new).with(DelCheckAdmGrpReq::setCurAdmGrpInfo, (Object)curAdmGrpInfo).with(DelCheckAdmGrpReq::setCurUserIsAdmin, (Object)curUserIsAdmin).with(DelCheckAdmGrpReq::setCurEnableSchemeId, (Object)curEnableSchemeId).with(DelCheckAdmGrpReq::setCanOperAdmGroupIdSet, (Object)canOperAdmGroupIdSet).build());
            if (checkRes.isOk()) continue;
            this.appendErrorInfo(errorInfo, dyn, checkRes.getMsg());
            return;
        }
    }

    private PermResult check(DelCheckAdmGrpReq req) {
        boolean curUserIsAdmin = req.isCurUserIsAdmin();
        if (!curUserIsAdmin) {
            return PermResult.fail((String)ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u4e0d\u662f\u7ba1\u7406\u5458\u3002", (String)"AdmGrpSaveValidator_1", (String)"bos-permission-opplugin", (Object[])new Object[0]));
        }
        AdmGrp curAdmGrpInfo = req.getCurAdmGrpInfo();
        if (null == curAdmGrpInfo) {
            return PermResult.fail((String)ResManager.loadKDString((String)"\u8be5\u7ba1\u7406\u5458\u7ec4\u4e0d\u5b58\u5728\u3002", (String)"AdmGrpSaveValidator_2", (String)"bos-permission-opplugin", (Object[])new Object[0]));
        }
        Long curAdmGrpId = curAdmGrpInfo.getId();
        String curAdmGrpName = curAdmGrpInfo.getName();
        long curGroupAdminSchemeId = curAdmGrpInfo.getAdminScheme();
        Long curEnableSchemeId = req.getCurEnableSchemeId();
        if (!Objects.equals(curEnableSchemeId, curGroupAdminSchemeId)) {
            return PermResult.fail((String)String.format(ResManager.loadKDString((String)"\u8be5\u7ba1\u7406\u5458\u7ec4\u201c%1$s\u201d\u4e0d\u5c5e\u4e8e\u5f53\u524d\u865a\u62df\u7ba1\u7406\u5458\u63a7\u5236\u7b56\u7565\u3002", (String)"AdmGrpSaveValidator_3", (String)"bos-permission-opplugin", (Object[])new Object[0]), curAdmGrpName));
        }
        Set canOperAdmGroupIdSet = req.getCanOperAdmGroupIdSet();
        if (CollectionUtils.isEmpty((Collection)canOperAdmGroupIdSet) || !canOperAdmGroupIdSet.contains(String.valueOf(curAdmGrpId))) {
            return PermResult.fail((String)String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5206\u7ec4\u201c%1$s\u201d\u4e0d\u5728\u60a8\u7684\u63a7\u5236\u8303\u56f4\u5185\uff0c\u60a8\u65e0\u6743\u8fdb\u884c\u65b0\u589e\u5220\u9664\u7b49\u64cd\u4f5c\u3002", (String)"UserAdmGrpSaveValidator_0", (String)"bos-permission-opplugin", (Object[])new Object[0]), curAdmGrpName));
        }
        int level = curAdmGrpInfo.getLevel();
        if (level == 1) {
            return PermResult.fail((String)ResManager.loadKDString((String)"\u9876\u7ea7\u7ba1\u7406\u5458\u7ec4\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"AdmGrpDelValidator_3", (String)"bos-permission-opplugin", (Object[])new Object[0]));
        }
        DynamicObject subAdminGroup = BusinessDataServiceHelper.loadSingle((String)"perm_admingroup", (String)"id", (QFilter[])new QFilter[]{new QFilter("parent", "=", (Object)curAdmGrpId)});
        if (null != subAdminGroup) {
            return PermResult.fail((String)String.format(ResManager.loadKDString((String)"\u7ba1\u7406\u5458\u5206\u7ec4\u201c%1$s\u201d\u5220\u9664\u5931\u8d25\uff0c\u56e0\u4e3a\u8be5\u7ec4\u4e0b\u8fd8\u5b58\u5728\u4e0b\u7ea7\u5206\u7ec4\u3002", (String)"AdmGrpDelValidator_0", (String)"bos-permission-opplugin", (Object[])new Object[0]), curAdmGrpName));
        }
        DynamicObject user = BusinessDataServiceHelper.loadSingle((String)"perm_useradmingroup", (String)"id", (QFilter[])new QFilter[]{new QFilter("usergroup", "=", (Object)curAdmGrpId)});
        if (null != user) {
            return PermResult.fail((String)String.format(ResManager.loadKDString((String)"\u7ba1\u7406\u5458\u5206\u7ec4\u201c%1$s\u201d\u5220\u9664\u5931\u8d25\uff0c\u56e0\u4e3a\u8be5\u7ec4\u4e0b\u8fd8\u5b58\u5728\u7528\u6237\u3002", (String)"AdmGrpDelValidator_1", (String)"bos-permission-opplugin", (Object[])new Object[0]), curAdmGrpName));
        }
        PermResult cheAdmGrpRoleRes = AdmGrpDelValidator.cheAdmGrpRole(curAdmGrpId);
        if (!cheAdmGrpRoleRes.isOk()) {
            return cheAdmGrpRoleRes;
        }
        return PermResult.ok();
    }

    private static PermResult cheAdmGrpRole(Long curAdmGrpId) {
        StringBuilder sb = new StringBuilder();
        sb.append("select a.fnumber, a.fname from t_perm_role a  where a.fcreateadmingrp = ?");
        sb.append(" union ");
        sb.append(" select r.fnumber, r.fname from t_perm_admingrouprole agr ");
        sb.append(" left join t_perm_role r on agr.froleid = r.fid ");
        sb.append(" where agr.fadmingroupid = ?");
        Map relateRoleMap = (Map)DB.query((DBRoute)DBRoute.permission, (String)sb.toString(), (Object[])new Object[]{curAdmGrpId, curAdmGrpId}, rs -> {
            HashMap<String, String> result = new HashMap<String, String>(16);
            while (rs.next()) {
                String roleNum = rs.getString("fnumber");
                String roleName = rs.getString("fname");
                result.put(roleNum, roleName);
            }
            return result;
        });
        if (!relateRoleMap.isEmpty() && null != relateRoleMap.keySet() && !relateRoleMap.keySet().isEmpty()) {
            Set roleNumSet = relateRoleMap.keySet();
            String roleStr = String.join((CharSequence)"\uff0c", roleNumSet);
            return PermResult.fail((String)String.format(ResManager.loadKDString((String)"\u901a\u7528\u89d2\u8272\u7f16\u7801\uff1a%1$s\uff0c\u5176\u6240\u5c5e\u7ba1\u7406\u5458\u7ec4\u6216\u516c\u5f00\u8303\u56f4\u5f15\u7528\u4e86\u6b64\u6570\u636e\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)"AdmGrpDelValidator_2", (String)"bos-permission-opplugin", (Object[])new Object[0]), roleStr));
        }
        return PermResult.ok();
    }

    private void appendErrorInfo(StringBuilder errorInfo, ExtendedDataEntity dyn, String info) {
        errorInfo.setLength(0);
        errorInfo.append(info);
        this.addErrorMessage(dyn, errorInfo.toString());
    }
}

