/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.opplugin.validator.del.admingroup;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.util.StringUtils;
import kd.bos.permission.cache.helper.AdminSchemeHelper;
import kd.bos.permission.model.PermResult;
import kd.bos.permission.model.perm.PermBuilder;
import kd.bos.permission.model.perm.admingroup.AdmGrpOrgAddUser;
import kd.bos.permission.model.perm.req.admin.delcheck.DelCheckAdmGrpReq;
import kd.bos.permission.model.perm.req.admin.get.GetAdmGrpOrgAddUserReq;
import kd.bos.permission.service.AdminGroupService;
import kd.bos.permission.service.admingroup.AdmGrpOrgAddUserService;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class AdmGrpOrgAddUserDelValidator
extends AbstractValidator {
    private Map<String, String> getOptionVariables() {
        Map variables = this.getOption().getVariables();
        variables = null == variables ? new HashMap(8) : variables;
        return variables;
    }

    public void validate() {
        Map<String, String> optionVariables = this.getOptionVariables();
        String alreadyCheckBusiParam = optionVariables.get("ALREADY_CHECKBUSIPARAM");
        if (!StringUtils.isEmpty((Object)alreadyCheckBusiParam) && Objects.equals("1", alreadyCheckBusiParam)) {
            return;
        }
        long currUserId = RequestContext.get().getCurrUserId();
        boolean curUserIsAdmin = PermissionServiceHelper.isAdminUser((long)currUserId);
        Long curEnableSchemeId = AdminSchemeHelper.getCurEnableSchemeId();
        Set canSavePermAdmGroupIdSet = AdminGroupService.getCanOperAdmGroupIdSet((Long)currUserId, (boolean)false, (String)this.getOptionVariables().get("canSavePermAdmGroupIdSet_useThreadCache"));
        Set mainIdSet = Arrays.stream(this.dataEntities).map(x -> String.valueOf(x.getBillPkId())).collect(Collectors.toSet());
        Map dataMap = AdmGrpOrgAddUserService.getAdmGrpOrgAddUserMap((GetAdmGrpOrgAddUserReq)new GetAdmGrpOrgAddUserReq(mainIdSet, null, null, null, null, null));
        StringBuilder errorInfo = new StringBuilder();
        for (ExtendedDataEntity dyn : this.dataEntities) {
            Long billPkId;
            Object billPkIdObj = dyn.getBillPkId();
            if (null == billPkIdObj || null == (billPkId = (Long)billPkIdObj) || Objects.equals(0L, billPkId)) continue;
            AdmGrpOrgAddUser one = (AdmGrpOrgAddUser)dataMap.get(billPkId);
            PermResult checkRes = AdmGrpOrgAddUserDelValidator.check((DelCheckAdmGrpReq)PermBuilder.of(DelCheckAdmGrpReq::new).with(DelCheckAdmGrpReq::setCurAdmGrpOrgAddUser, (Object)one).with(DelCheckAdmGrpReq::setCanOperAdmGroupIdSet, (Object)canSavePermAdmGroupIdSet).with(DelCheckAdmGrpReq::setCurUserIsAdmin, (Object)curUserIsAdmin).with(DelCheckAdmGrpReq::setCurEnableSchemeId, (Object)curEnableSchemeId).build());
            if (checkRes.isOk()) continue;
            this.appendErrorInfo(errorInfo, dyn, checkRes.getMsg());
            return;
        }
    }

    public static PermResult check(DelCheckAdmGrpReq delCheckParam) {
        AdmGrpOrgAddUser curObj = delCheckParam.getCurAdmGrpOrgAddUser();
        if (null == curObj) {
            return PermResult.ok();
        }
        Long adminGroupId = curObj.getAdminGroupId();
        if (null == adminGroupId || Objects.equals(0L, adminGroupId)) {
            return PermResult.ok();
        }
        boolean curUserIsAdmin = delCheckParam.isCurUserIsAdmin();
        if (!curUserIsAdmin) {
            String info = ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u4e0d\u662f\u7ba1\u7406\u5458\u3002", (String)"AdmGrpSaveValidator_1", (String)"bos-permission-opplugin", (Object[])new Object[0]);
            return PermResult.fail((String)info);
        }
        String curAdmGrpName = curObj.getAdminGroupName();
        Long curGroupAdminSchemeId = curObj.getAdminScheme();
        Long curEnableSchemeId = delCheckParam.getCurEnableSchemeId();
        if (!Objects.equals(curEnableSchemeId, curGroupAdminSchemeId)) {
            return PermResult.fail((String)String.format(ResManager.loadKDString((String)"\u8be5\u7ba1\u7406\u5458\u7ec4\u201c%1$s\u201d\u4e0d\u5c5e\u4e8e\u5f53\u524d\u865a\u62df\u7ba1\u7406\u5458\u63a7\u5236\u7b56\u7565\u3002", (String)"AdmGrpSaveValidator_3", (String)"bos-permission-opplugin", (Object[])new Object[0]), curAdmGrpName));
        }
        Set canSavePermAdmGroupIdSet = delCheckParam.getCanOperAdmGroupIdSet();
        if (null == canSavePermAdmGroupIdSet || !canSavePermAdmGroupIdSet.contains(String.valueOf(adminGroupId))) {
            String info = String.format(ResManager.loadKDString((String)"\u60a8\u65e0\u6743\u4fee\u6539\u7ba1\u7406\u5458\u7ec4\u7f16\u7801\u4e3a\u201c%1$s\u201d\u7684\u5206\u7ec4\u6388\u6743\u4fe1\u606f\u3002", (String)"AdmGrpFunpermSaveValidator_1", (String)"bos-permission-opplugin", (Object[])new Object[0]), curObj.getAdminGroupName());
            return PermResult.fail((String)info);
        }
        return PermResult.ok();
    }

    private void appendErrorInfo(StringBuilder errorInfo, ExtendedDataEntity dyn, String info) {
        errorInfo.setLength(0);
        errorInfo.append(info);
        this.addErrorMessage(dyn, errorInfo.toString());
    }
}

