/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.opplugin.validator.del.admingroup;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.api.ext.IPermExt;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.FormHelper;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.factory.PermServiceFactory;
import kd.bos.permission.log.helper.PermLogHelper;
import kd.bos.permission.model.perm.PermBuilder;
import kd.bos.permission.model.perm.req.PermLogReq;
import kd.bos.permission.model.perm.req.PermOperationReq;
import kd.bos.permission.model.perm.req.admin.get.GetUserAdmGrpReq;
import kd.bos.permission.opplugin.validator.del.admingroup.UserAdmGrpDelValidator;
import kd.bos.permission.service.admingroup.UserAdmGrpService;
import kd.bos.util.StringUtils;

public class UserAdmGrpDelOp
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(UserAdmGrpDelOp.class);
    private static final String[] PERM_IGNOREREFENTITYIDS = new String[]{"perm_useradmingroup"};

    private Map<String, String> getOptionVariables() {
        Map variables = this.getOption().getVariables();
        variables = null == variables ? new HashMap(8) : variables;
        return variables;
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        Set ignorerefentityNumSet = FormHelper.getIgnoreRefEntNumSet((String[])PERM_IGNOREREFENTITYIDS);
        this.getOption().setVariableValue("ignorerefentityids", String.join((CharSequence)",", ignorerefentityNumSet));
        e.getValidators().add(new UserAdmGrpDelValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        try {
            super.beginOperationTransaction(e);
            Map<String, String> variables = this.getOptionVariables();
            DynamicObject[] dataEntities = e.getDataEntities();
            if (null == dataEntities || Objects.equals(0, dataEntities.length)) {
                return;
            }
            String preDataMapStr = variables.get("preDataMap");
            if (StringUtils.isEmpty((String)preDataMapStr)) {
                Set mainIdSet = Arrays.stream(dataEntities).map(x -> String.valueOf(x.getPkValue())).collect(Collectors.toSet());
                GetUserAdmGrpReq req = new GetUserAdmGrpReq(mainIdSet, null, null, null, null, null);
                Map userAdmGrpSetMap = UserAdmGrpService.getUserAdmGrpSetMap((GetUserAdmGrpReq)req);
                this.getOption().setVariableValue("preDataMap", StrUtil.compress((String)new ObjectMapper().writeValueAsString((Object)userAdmGrpSetMap)));
            }
        }
        catch (Exception ex) {
            log.error("{}.{} error.", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), Thread.currentThread().getStackTrace()[1].getMethodName(), ex});
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff1a%1$s", (String)"RoleDelOP_0", (String)"bos-permission-opplugin", (Object[])new Object[0]), ex.getMessage()));
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        try {
            String currbizappNum;
            super.endOperationTransaction(e);
            Map<String, String> variables = this.getOptionVariables();
            DynamicObject[] dataEntities = e.getDataEntities();
            if (null == dataEntities || Objects.equals(0, dataEntities.length)) {
                return;
            }
            HashSet<String> mainIdSet = new HashSet<String>(8);
            for (DynamicObject dyn : dataEntities) {
                if (null == dyn) continue;
                mainIdSet.add(dyn.getString("id"));
            }
            variables.put("ENTSAVE_PERMLOG", StringUtils.isEmpty((String)variables.get("ENTSAVE_PERMLOG")) ? "1" : variables.get("ENTSAVE_PERMLOG"));
            String defaultFormFlag = StringUtils.isEmpty((String)variables.get("permlog_formnum")) ? dataEntities[0].getDynamicObjectType().getName() : variables.get("permlog_formnum");
            String defaultPermlogBusitype = StringUtils.isEmpty((String)variables.get("permlog_busitype")) ? "admin_del" : variables.get("permlog_busitype");
            String defaultOp = StringUtils.isEmpty((String)variables.get("permlog_op")) ? "delete" : variables.get("permlog_op");
            String defaultOpbtn = StringUtils.isEmpty((String)variables.get("permlog_opbtn")) ? ConstantsHelper.getDel() : variables.get("permlog_opbtn");
            String defaultPermlogInterfacemethod = StringUtils.isEmpty((String)variables.get("permlog_interfacemethod")) ? "UserAdmGrpDelOp.endOperationTransaction" : variables.get("permlog_interfacemethod");
            String batchimport = variables.get("batchimport");
            if (Objects.equals("true", batchimport)) {
                defaultOp = "importdata";
                defaultOpbtn = ConstantsHelper.getImportData();
            }
            if (StringUtils.isEmpty((String)(currbizappNum = variables.get("currbizappid")))) {
                currbizappNum = "devportal";
                variables.put("currbizappid", currbizappNum);
            }
            PermLogReq permLogReq = PermLogHelper.wrapOperPermLogReq(variables, (String)defaultFormFlag, (String)defaultPermlogBusitype, (String)defaultOp, (String)defaultOpbtn, (String)defaultPermlogInterfacemethod);
            String preDataMapStr = variables.get("preDataMap");
            PermOperationReq afterDelReq = (PermOperationReq)PermBuilder.of(PermOperationReq::new).with(PermOperationReq::setCurAppNum, (Object)currbizappNum).with(PermOperationReq::setCurFormNum, (Object)defaultFormFlag).with(PermOperationReq::setMainIdSet, mainIdSet).with(PermOperationReq::setPermLogReq, (Object)permLogReq).with(PermOperationReq::setPreDataMapStr, (Object)preDataMapStr).with(PermOperationReq::setNeedClearAllCache, (Object)variables.get("NEED_CLEARALLCACHE")).with(PermOperationReq::setDoDelExcessData, (Object)variables.get("DO_DELEXCESSDATA")).build();
            ((IPermExt)PermServiceFactory.getService((String)"UserAdmGrpService")).afterDel(afterDelReq);
        }
        catch (Exception ex) {
            log.error("{}.{} error.", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), Thread.currentThread().getStackTrace()[1].getMethodName(), ex});
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff1a%1$s", (String)"RoleDelOP_0", (String)"bos-permission-opplugin", (Object[])new Object[0]), ex.getMessage()));
        }
    }
}

