/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.opplugin.validator.del.admingroup;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.util.StringUtils;
import kd.bos.permission.cache.helper.AdminSchemeHelper;
import kd.bos.permission.model.PermResult;
import kd.bos.permission.model.perm.PermBuilder;
import kd.bos.permission.model.perm.admingroup.UserAdmGrp;
import kd.bos.permission.model.perm.req.admin.delcheck.DelCheckUserAdmGrpReq;
import kd.bos.permission.model.perm.req.admin.get.GetUserAdmGrpReq;
import kd.bos.permission.service.AdminGroupService;
import kd.bos.permission.service.admingroup.UserAdmGrpService;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class UserAdmGrpDelValidator
extends AbstractValidator {
    private Map<String, String> getOptionVariables() {
        Map variables = this.getOption().getVariables();
        variables = null == variables ? new HashMap(8) : variables;
        return variables;
    }

    public void validate() {
        Map<String, String> optionVariables = this.getOptionVariables();
        String alreadyCheckBusiParam = optionVariables.get("ALREADY_CHECKBUSIPARAM");
        if (!StringUtils.isEmpty((Object)alreadyCheckBusiParam) && Objects.equals("1", alreadyCheckBusiParam)) {
            return;
        }
        long currUserId = RequestContext.get().getCurrUserId();
        boolean curUserIsAdmin = PermissionServiceHelper.isAdminUser((long)currUserId);
        Long curEnableSchemeId = AdminSchemeHelper.getCurEnableSchemeId();
        Set canSavePermAdmGroupIdSet = AdminGroupService.getCanOperAdmGroupIdSet((Long)currUserId, (boolean)false, (String)this.getOptionVariables().get("canSavePermAdmGroupIdSet_useThreadCache"));
        Set mainIdSet = Arrays.stream(this.dataEntities).map(x -> String.valueOf(x.getBillPkId())).collect(Collectors.toSet());
        Map dataMap = UserAdmGrpService.getUserAdmGrpMap((GetUserAdmGrpReq)new GetUserAdmGrpReq(mainIdSet, null, null, null, null, null));
        StringBuilder errorInfo = new StringBuilder();
        for (ExtendedDataEntity dyn : this.dataEntities) {
            Long billPkId;
            Object billPkIdObj = dyn.getBillPkId();
            if (null == billPkIdObj || null == (billPkId = (Long)billPkIdObj) || Objects.equals(0L, billPkId)) continue;
            UserAdmGrp one = (UserAdmGrp)dataMap.get(billPkId);
            PermResult checkRes = UserAdmGrpDelValidator.check((DelCheckUserAdmGrpReq)PermBuilder.of(DelCheckUserAdmGrpReq::new).with(DelCheckUserAdmGrpReq::setCurUserAdmGrp, (Object)one).with(DelCheckUserAdmGrpReq::setCanSavePermAdmGroupIdSet, (Object)canSavePermAdmGroupIdSet).with(DelCheckUserAdmGrpReq::setCurUserIsAdmin, (Object)curUserIsAdmin).with(DelCheckUserAdmGrpReq::setCurEnableSchemeId, (Object)curEnableSchemeId).build());
            if (checkRes.isOk()) continue;
            this.appendErrorInfo(errorInfo, dyn, checkRes.getMsg());
            return;
        }
    }

    public static PermResult check(DelCheckUserAdmGrpReq delCheckParam) {
        UserAdmGrp curObj = delCheckParam.getCurUserAdmGrp();
        if (null == curObj) {
            return PermResult.ok();
        }
        Long curAdmGrpId = curObj.getAdminGroupId();
        if (null == curAdmGrpId || Objects.equals(0L, curAdmGrpId)) {
            String info = ResManager.loadKDString((String)"\u7ba1\u7406\u5458\u7ec4\u4e0d\u5b58\u5728\u3002", (String)"AdmGrpFunpermSaveValidator_0", (String)"bos-permission-opplugin", (Object[])new Object[0]);
            return PermResult.fail((String)info);
        }
        boolean curUserIsAdmin = delCheckParam.isCurUserIsAdmin();
        if (!curUserIsAdmin) {
            String info = ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u4e0d\u662f\u7ba1\u7406\u5458\u3002", (String)"AdmGrpSaveValidator_1", (String)"bos-permission-opplugin", (Object[])new Object[0]);
            return PermResult.fail((String)info);
        }
        String curAdmGrpName = curObj.getAdminGroupName();
        Long curGroupAdminSchemeId = curObj.getAdminScheme();
        Long curEnableSchemeId = delCheckParam.getCurEnableSchemeId();
        if (!Objects.equals(curEnableSchemeId, curGroupAdminSchemeId)) {
            return PermResult.fail((String)String.format(ResManager.loadKDString((String)"\u8be5\u7ba1\u7406\u5458\u7ec4\u201c%1$s\u201d\u4e0d\u5c5e\u4e8e\u5f53\u524d\u865a\u62df\u7ba1\u7406\u5458\u63a7\u5236\u7b56\u7565\u3002", (String)"AdmGrpSaveValidator_3", (String)"bos-permission-opplugin", (Object[])new Object[0]), curAdmGrpName));
        }
        long level = curObj.getAdminLevel();
        if (level == 1L) {
            return PermResult.fail((String)ResManager.loadKDString((String)"\u865a\u62df\u7ba1\u7406\u5458\u7ec4\u4e0d\u5141\u8bb8\u6dfb\u52a0\u6216\u5220\u9664\u7528\u6237\u3002", (String)"UserAdmGrpSaveValidator_3", (String)"bos-permission-opplugin", (Object[])new Object[0]));
        }
        Set canSavePermAdmGroupIdSet = delCheckParam.getCanSavePermAdmGroupIdSet();
        if (null == canSavePermAdmGroupIdSet || !canSavePermAdmGroupIdSet.contains(String.valueOf(curAdmGrpId))) {
            String info = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5206\u7ec4\u201c%1$s\u201d\u4e0d\u5728\u60a8\u7684\u63a7\u5236\u8303\u56f4\u5185\uff0c\u60a8\u65e0\u6743\u8fdb\u884c\u65b0\u589e\u5220\u9664\u7b49\u64cd\u4f5c\u3002", (String)"UserAdmGrpSaveValidator_0", (String)"bos-permission-opplugin", (Object[])new Object[0]), curAdmGrpName);
            return PermResult.fail((String)info);
        }
        return PermResult.ok();
    }

    private void appendErrorInfo(StringBuilder errorInfo, ExtendedDataEntity dyn, String info) {
        errorInfo.setLength(0);
        errorInfo.append(info);
        this.addErrorMessage(dyn, errorInfo.toString());
    }
}

