/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.opplugin.validator.del.busirole;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.FormHelper;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.factory.PermServiceFactory;
import kd.bos.permission.log.helper.PermBusiRoleLogHelper;
import kd.bos.permission.log.helper.PermLogHelper;
import kd.bos.permission.model.perm.PermBuilder;
import kd.bos.permission.model.perm.req.PermLogReq;
import kd.bos.permission.model.perm.req.PermOperationReq;
import kd.bos.permission.model.perm.req.bat.afterdel.BusiRoleAfterDelReq;
import kd.bos.permission.service.BusiRoleService;
import kd.bos.util.StringUtils;

public class BusiRoleDelOP
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(BusiRoleDelOP.class);
    private static final String[] PERM_IGNOREREFENTITYIDS = new String[]{"perm_userrole", "perm_userrole_multype"};

    private static BusiRoleService getBusiRoleService() {
        return (BusiRoleService)PermServiceFactory.getService((String)"BusiRoleService");
    }

    private Map<String, String> getOptionVariables() {
        Map variables = this.getOption().getVariables();
        variables = null == variables ? new HashMap(8) : variables;
        return variables;
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        Set ignorerefentityNumSet = FormHelper.getIgnoreRefEntNumSet((String[])PERM_IGNOREREFENTITYIDS);
        this.getOption().setVariableValue("ignorerefentityids", String.join((CharSequence)",", ignorerefentityNumSet));
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        try {
            super.beginOperationTransaction(e);
            DynamicObject[] dataEntities = e.getDataEntities();
            if (null == dataEntities || Objects.equals(0, dataEntities.length)) {
                return;
            }
            Map<String, String> variables = this.getOptionVariables();
            String preDataMapStr = variables.get("preDataMap");
            if (StringUtils.isEmpty((String)preDataMapStr)) {
                Set bizRoleIdSet = Arrays.stream(dataEntities).map(x -> String.valueOf(x.getPkValue())).collect(Collectors.toSet());
                Map preDataMap = PermBusiRoleLogHelper.busiRoleEventImage(bizRoleIdSet, (boolean)false, (boolean)true);
                this.getOption().setVariableValue("preDataMap", StrUtil.compress((String)new ObjectMapper().writeValueAsString((Object)preDataMap)));
            }
        }
        catch (Exception ex) {
            log.error("BusiRoleDelOP.beginOperationTransaction error.", (Throwable)ex);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff1a%1$s", (String)"RoleDelOP_0", (String)"bos-permission-opplugin", (Object[])new Object[0]), ex.getMessage()));
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        try {
            DynamicObject[] dataEntities = e.getDataEntities();
            if (null == dataEntities || Objects.equals(0, dataEntities.length)) {
                return;
            }
            HashSet<String> bizRoleIdSet = new HashSet<String>(8);
            for (DynamicObject dyn : dataEntities) {
                if (null == dyn) continue;
                String roleId = dyn.getString("id");
                bizRoleIdSet.add(roleId);
            }
            Map<String, String> variables = this.getOptionVariables();
            String entNum = dataEntities[0].getDynamicObjectType().getName();
            PermLogReq permLogReq = PermLogHelper.wrapOperPermLogReq(variables, (String)entNum, (String)"busirole_role_del", (String)"delete", (String)ConstantsHelper.getDel(), (String)"kd.bos.permission.opplugin.validator.del.busirole.BusiRoleDelOP.endOperationTransaction");
            String preDataMapStr = variables.get("preDataMap");
            String appNum = variables.get("currbizappid");
            BusiRoleDelOP.getBusiRoleService().afterDel((PermOperationReq)PermBuilder.of(BusiRoleAfterDelReq::new).with(PermOperationReq::setCurAppNum, (Object)appNum).with(PermOperationReq::setMainIdSet, bizRoleIdSet).with(PermOperationReq::setPermLogReq, (Object)permLogReq).with(PermOperationReq::setPreDataMapStr, (Object)preDataMapStr).build());
            super.endOperationTransaction(e);
        }
        catch (Exception ex) {
            log.error("BusiRoleDelOP.afterExecuteOperationTransaction error.", (Throwable)ex);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff1a%1$s", (String)"RoleDelOP_0", (String)"bos-permission-opplugin", (Object[])new Object[0]), ex.getMessage()));
        }
    }
}

