/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.opplugin.validator.del.comrole;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.util.StringUtils;
import kd.bos.permission.model.PermResult;
import kd.bos.permission.model.perm.PermBuilder;
import kd.bos.permission.model.perm.comrole.ComRoleFuncPerm;
import kd.bos.permission.model.perm.req.comrole.delcheck.DelCheckComRoleReq;
import kd.bos.permission.model.perm.req.comrole.get.GetComRoleFuncPermReq;
import kd.bos.permission.service.AdminGroupService;
import kd.bos.permission.service.comrole.ComRoleFuncPermService;

public class ComRoleFuncPermDelValidator
extends AbstractValidator {
    private Map<String, String> getOptionVariables() {
        Map variables = this.getOption().getVariables();
        variables = null == variables ? new HashMap(8) : variables;
        return variables;
    }

    public void validate() {
        Map<String, String> optionVariables = this.getOptionVariables();
        String alreadyCheckBusiParam = optionVariables.get("ALREADY_CHECKBUSIPARAM");
        if (!StringUtils.isEmpty((Object)alreadyCheckBusiParam) && Objects.equals("1", alreadyCheckBusiParam)) {
            return;
        }
        Set mainIdSet = Arrays.stream(this.dataEntities).map(x -> String.valueOf(x.getBillPkId())).collect(Collectors.toSet());
        Map dataMap = ComRoleFuncPermService.getComRoleFuncPermMap((GetComRoleFuncPermReq)new GetComRoleFuncPermReq(mainIdSet, null, null, null, null, null, null, null, null));
        HashSet<String> roleIdSet = new HashSet<String>(8);
        for (Map.Entry data : dataMap.entrySet()) {
            ComRoleFuncPerm value = (ComRoleFuncPerm)data.getValue();
            if (null == value) continue;
            roleIdSet.add(value.getRoleId());
        }
        long currUserId = RequestContext.get().getCurrUserId();
        Map canModifyRoleIdMap = AdminGroupService.canModifyRole((Long)currUserId, new ArrayList(roleIdSet));
        StringBuilder errorInfo = new StringBuilder();
        for (ExtendedDataEntity dyn : this.dataEntities) {
            String billPkId;
            Object billPkIdObj = dyn.getBillPkId();
            if (null == billPkIdObj || StringUtils.isEmpty((Object)(billPkId = (String)billPkIdObj))) continue;
            ComRoleFuncPerm one = (ComRoleFuncPerm)dataMap.get(billPkId);
            PermResult checkRes = ComRoleFuncPermDelValidator.check((DelCheckComRoleReq)PermBuilder.of(DelCheckComRoleReq::new).with(DelCheckComRoleReq::setCurComRoleFuncPerm, (Object)one).with(DelCheckComRoleReq::setCanModifyRoleIdMap, (Object)canModifyRoleIdMap).build());
            if (checkRes.isOk()) continue;
            this.appendErrorInfo(errorInfo, dyn, checkRes.getMsg());
            return;
        }
    }

    public static PermResult check(DelCheckComRoleReq delCheckParam) {
        ComRoleFuncPerm curObj = delCheckParam.getCurComRoleFuncPerm();
        if (null == curObj) {
            return PermResult.ok();
        }
        String curComRoleId = curObj.getRoleId();
        if (StringUtils.isEmpty((Object)curComRoleId)) {
            return PermResult.ok();
        }
        Map canModifyRoleIdMap = delCheckParam.getCanModifyRoleIdMap();
        if (null != canModifyRoleIdMap.get(curComRoleId) && !((Boolean)canModifyRoleIdMap.get(curComRoleId)).booleanValue()) {
            String curComRoleNumber = curObj.getRoleNumber();
            String info = String.format(ResManager.loadKDString((String)"\u901a\u7528\u89d2\u8272\u7f16\u7801\u201c%1$s\u201d\u4e0d\u5728\u5f53\u524d\u7ba1\u7406\u5458\u7ba1\u8f96\u8303\u56f4\u5185\u3002", (String)"ComRoleFuncPermSaveValidator_7", (String)"bos-permission-opplugin", (Object[])new Object[0]), curComRoleNumber);
            return PermResult.fail((String)info);
        }
        return PermResult.ok();
    }

    private void appendErrorInfo(StringBuilder errorInfo, ExtendedDataEntity dyn, String info) {
        errorInfo.setLength(0);
        errorInfo.append(info);
        this.addErrorMessage(dyn, errorInfo.toString());
    }
}

