/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.opplugin.validator.del.userdirect;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.bos.permission.api.UserScopeResult;
import kd.bos.permission.api.UserScopeResultImpl;
import kd.bos.permission.cache.AdminPermCache;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.IsoDimHelper;
import kd.bos.permission.cache.helper.UserHelper;
import kd.bos.permission.cache.model.Dim;
import kd.bos.permission.cache.model.User;
import kd.bos.permission.cache.model.permbase.App;
import kd.bos.permission.model.perm.PermCtrlType;
import kd.bos.permission.model.perm.req.permctrltype.GetHasPermPermCtrlObjReq;
import kd.bos.permission.model.perm.resp.permctrltype.GetHasPermPermCtrlObjResp;
import kd.bos.permission.service.AbstractPermissionServiceImpl;
import kd.bos.permission.service.permctrltype.PermCtrlTypeService;
import kd.bos.permission.util.PermissionServiceImplFactory;
import kd.bos.servicehelper.QueryServiceHelper;

public class UserDirectPermDetailDelValidator
extends AbstractValidator {
    private static final Log log = LogFactory.getLog(UserDirectPermDetailDelValidator.class);

    private Map<String, String> getOptionVariables() {
        Map variables = this.getOption().getVariables();
        variables = null == variables ? new HashMap(8) : variables;
        return variables;
    }

    public void validate() {
        Map<String, String> variables = this.getOptionVariables();
        String skipCheckAdminDataRange = variables.get("skipCheckAdminDataRange");
        if ("true".equals(skipCheckAdminDataRange)) {
            return;
        }
        String need_execute_perm_validator = this.getOptionVariables().get("NEED_EXECUTE_PERM_VALIDATOR");
        if (!Objects.equals("1", need_execute_perm_validator)) {
            return;
        }
        HashMap<String, ExtendedDataEntity> extDataEntityMap = new HashMap<String, ExtendedDataEntity>(8);
        for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
            String billPkId;
            Object billPkIdObj;
            if (null == extendedDataEntity || null == (billPkIdObj = extendedDataEntity.getBillPkId()) || StringUtils.isEmpty((Object)(billPkId = (String)billPkIdObj))) continue;
            extDataEntityMap.put(billPkId, extendedDataEntity);
        }
        try {
            this.delPermCheck(extDataEntityMap);
        }
        catch (Exception e) {
            log.error("UserDirectPermDetailDelValidator.validate error.", (Throwable)e);
            throw new KDBizException("UserDirectPermDetailDelValidator.validate error.");
        }
    }

    private void delPermCheck(Map<String, ExtendedDataEntity> extDataEntityMap) throws Exception {
        HashSet<String> billPkIdSet = new HashSet<String>(extDataEntityMap.keySet());
        if (null != billPkIdSet && !billPkIdSet.isEmpty()) {
            HashMap<String, Long> billPkIdUserIdMap = new HashMap<String, Long>(8);
            HashMap<String, kd.bos.permission.model.perm.Dim> billPkIdDimMap = new HashMap<String, kd.bos.permission.model.perm.Dim>(8);
            HashMap<String, String> billPkIdAppIdMap = new HashMap<String, String>(8);
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"UserDirectPermDetailDelValidator.delPermCheck", (String)"perm_userpermdetail", (String)"id,user_id, dimtype, dimid_id, bizapp_id", (QFilter[])new QFilter[]{new QFilter("id", "in", billPkIdSet)}, (String)"");){
                while (ds.hasNext()) {
                    String appId;
                    String billPkId;
                    Object billPkIdObj;
                    Row row = ds.next();
                    String id = row.getString("id");
                    ExtendedDataEntity extendedDataEntity = extDataEntityMap.get(id);
                    if (null == extendedDataEntity || null == (billPkIdObj = extendedDataEntity.getBillPkId()) || StringUtils.isEmpty((Object)(billPkId = (String)billPkIdObj))) continue;
                    Long userId = row.getLong("user_id");
                    if (null != userId && !Objects.equals(0L, userId)) {
                        billPkIdUserIdMap.put(billPkId, userId);
                    }
                    String dimType = row.getString("dimtype");
                    Long dimId = row.getLong("dimid_id");
                    if (!StringUtils.isEmpty((Object)dimType) && null != dimId && dimId > 0L) {
                        billPkIdDimMap.put(billPkId, new kd.bos.permission.model.perm.Dim(dimType, dimId, Boolean.valueOf(false)));
                    }
                    if (StringUtils.isEmpty((Object)(appId = row.getString("bizapp_id")))) continue;
                    billPkIdAppIdMap.put(billPkId, appId);
                }
            }
            long currUserId = RequestContext.get().getCurrUserId();
            Map<String, String> variables = this.getOptionVariables();
            String adminChargeUser_allUserStr = variables.get("adminChargeUser_allUser");
            String adminChargeUser_userIDsStr = variables.get("adminChargeUser_userIDs");
            this.checkUserRange(billPkIdUserIdMap, currUserId, adminChargeUser_allUserStr, adminChargeUser_userIDsStr);
            String permCtrlTypeMapStr = variables.get("permCtrlTypeMap");
            String dimHasPermDimResultMapStr = variables.get("dimHasPermDimResultMap");
            this.checkDimManageRange(billPkIdDimMap, currUserId, permCtrlTypeMapStr, dimHasPermDimResultMapStr);
            String adminChargeAppsStr = variables.get("adminChargeApps");
            this.checkAppRange(billPkIdAppIdMap, currUserId, adminChargeAppsStr);
        }
    }

    private void checkAppRange(Map<String, String> billPkIdAppIdMap, long currUserId, String adminChargeAppsStr) throws Exception {
        if (null == billPkIdAppIdMap || billPkIdAppIdMap.isEmpty()) {
            return;
        }
        List adminChargeApps = StringUtils.isEmpty((Object)adminChargeAppsStr) ? AdminPermCache.getAdminChargeApps((Long)currUserId, null) : (List)new ObjectMapper().readValue(adminChargeAppsStr, (TypeReference)new TypeReference<List<String>>(){});
        Set want2DelAppIdSet = billPkIdAppIdMap.values().stream().collect(Collectors.toSet());
        Sets.SetView noPerm2DelAppIdSet = Sets.difference(want2DelAppIdSet, new HashSet(adminChargeApps));
        if (null == noPerm2DelAppIdSet || noPerm2DelAppIdSet.isEmpty()) {
            return;
        }
        Map appMap = AppHelper.getAppMap((Set)noPerm2DelAppIdSet);
        for (ExtendedDataEntity value : this.dataEntities) {
            String billPkId;
            String appId;
            App app;
            if (null == value || null == value.getBillPkId() || StringUtils.isEmpty((Object)((String)value.getBillPkId())) || null == (app = (App)appMap.get(appId = billPkIdAppIdMap.get(billPkId = (String)value.getBillPkId()))) || !noPerm2DelAppIdSet.contains((Object)appId)) continue;
            value.setBillNo(billPkId);
            this.addErrorMessage(value, String.format(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff0c\u5e94\u7528\u201c%1$s\u201d\u4e0d\u5728\u7ba1\u7406\u5458\u201c\u5e94\u7528\u7ba1\u8f96\u8303\u56f4\u201d\u5185\u3002", (String)"UserRoleDelValidator_2", (String)"bos-permission-opplugin", (Object[])new Object[0]), null == app ? "" : app.getAppName()));
        }
    }

    private void checkDimManageRange(Map<String, kd.bos.permission.model.perm.Dim> billPkIdDimMap, long currUserId, String permCtrlTypeMapStr, String dimHasPermDimResultMapStr) throws Exception {
        if (null == billPkIdDimMap || billPkIdDimMap.isEmpty()) {
            return;
        }
        Set want2DelDimSet = billPkIdDimMap.values().stream().collect(Collectors.toSet());
        if (null == want2DelDimSet || want2DelDimSet.isEmpty()) {
            return;
        }
        HashMap<String, Set> want2DelDimTypeIdSetMap = new HashMap<String, Set>(8);
        for (kd.bos.permission.model.perm.Dim dim : want2DelDimSet) {
            String dimType = dim.getDimType();
            Long dimId = dim.getDimId();
            if (StringUtils.isEmpty((Object)dimType) || null == dimId || Objects.equals(0L, dimId)) continue;
            want2DelDimTypeIdSetMap.computeIfAbsent(dim.getDimType(), k -> new HashSet(8)).add(dim.getDimId());
        }
        if (null == want2DelDimTypeIdSetMap || want2DelDimTypeIdSetMap.isEmpty()) {
            return;
        }
        HashMap<String, Map> dimErrorMsgMap = new HashMap<String, Map>(8);
        Map permCtrlTypeMap = StringUtils.isEmpty((Object)permCtrlTypeMapStr) ? IsoDimHelper.getEntPermCtrlTypeMap(null) : (Map)new ObjectMapper().readValue(permCtrlTypeMapStr, (TypeReference)new TypeReference<HashMap<String, PermCtrlType>>(){});
        permCtrlTypeMap = null == permCtrlTypeMap ? new HashMap(0) : permCtrlTypeMap;
        HashMap dimHasPermDimResultMap = StringUtils.isEmpty((Object)dimHasPermDimResultMapStr) ? new HashMap(0) : (Map)new ObjectMapper().readValue(dimHasPermDimResultMapStr, (TypeReference)new TypeReference<HashMap<String, GetHasPermPermCtrlObjResp>>(){});
        for (Map.Entry want2DelDimTypeIdSet : want2DelDimTypeIdSetMap.entrySet()) {
            Set hasPermDimSet;
            HashSet hasPermDimIdSet;
            Sets.SetView noPerm2DelDimIdSet;
            String dimType = (String)want2DelDimTypeIdSet.getKey();
            Set want2DelDimIdSet = (Set)want2DelDimTypeIdSet.getValue();
            if (StringUtils.isEmpty((Object)dimType) || null == want2DelDimIdSet || want2DelDimIdSet.isEmpty()) continue;
            GetHasPermPermCtrlObjReq hasPermPermCtrlObjReq = new GetHasPermPermCtrlObjReq(dimType, Long.valueOf(currUserId), want2DelDimIdSet, null);
            GetHasPermPermCtrlObjResp hasPermDimResult = (GetHasPermPermCtrlObjResp)dimHasPermDimResultMap.get(dimType);
            hasPermDimResult = null == hasPermDimResult ? PermCtrlTypeService.getAdminHasPermPermCtrlObj((GetHasPermPermCtrlObjReq)hasPermPermCtrlObjReq) : hasPermDimResult;
            if (hasPermDimResult.isHasAllDimPerm() || null == (noPerm2DelDimIdSet = Sets.difference((Set)want2DelDimIdSet, hasPermDimIdSet = null == (hasPermDimSet = hasPermDimResult.getHasPermDimSet()) ? new HashSet(0) : hasPermDimSet.stream().map(kd.bos.permission.model.perm.Dim::getDimId).collect(Collectors.toSet()))) || noPerm2DelDimIdSet.isEmpty()) continue;
            Map dimMap = IsoDimHelper.getDimMap(new ArrayList(noPerm2DelDimIdSet), (String)dimType);
            for (Long one : noPerm2DelDimIdSet) {
                Dim dim = (Dim)dimMap.get(one);
                if (null == dim) continue;
                String innerDimType = dim.getDimType();
                Long innerDimId = dim.getDimId();
                if (StringUtils.isEmpty((Object)innerDimType) || null == innerDimId || Objects.equals(0L, innerDimId)) continue;
                String dimName = null == dim ? "" : dim.getDimName();
                String dimTypeName = null == permCtrlTypeMap.get(dimType) ? "" : ((PermCtrlType)permCtrlTypeMap.get(dimType)).getName();
                dimErrorMsgMap.computeIfAbsent(innerDimType, k -> new HashMap(8)).put(innerDimId, String.format(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff0c%1$s\u201c%2$s\u201d\u4e0d\u5728\u7ba1\u7406\u5458\u201c%3$s\u7ba1\u8f96\u8303\u56f4\u201d\u5185\u3002", (String)"UserRoleDelValidator_1", (String)"bos-permission-opplugin", (Object[])new Object[0]), dimTypeName, dimName, dimTypeName));
            }
        }
        if (null == dimErrorMsgMap || dimErrorMsgMap.isEmpty()) {
            return;
        }
        for (ExtendedDataEntity value : this.dataEntities) {
            Long dimId;
            String dimType;
            Map dimIdErrorMsgMap;
            String billPkId;
            kd.bos.permission.model.perm.Dim dim;
            if (null == value || null == value.getBillPkId() || StringUtils.isEmpty((Object)String.valueOf(value.getBillPkId())) || null == (dim = billPkIdDimMap.get(billPkId = String.valueOf(value.getBillPkId()))) || StringUtils.isEmpty((Object)dim.getDimType()) || null == dim.getDimId() || Objects.equals(0L, dim.getDimId()) || null == (dimIdErrorMsgMap = (Map)dimErrorMsgMap.get(dimType = dim.getDimType())) || dimIdErrorMsgMap.isEmpty() || !dimIdErrorMsgMap.containsKey(dimId = dim.getDimId())) continue;
            String errorMsg = (String)dimIdErrorMsgMap.get(dimId);
            value.setBillNo(billPkId);
            this.addErrorMessage(value, errorMsg);
        }
    }

    private void checkUserRange(Map<String, Long> billPkIdUserIdMap, long currUserId, String adminChargeUser_allUserStr, String adminChargeUser_userIDsStr) throws Exception {
        if (null == billPkIdUserIdMap || billPkIdUserIdMap.isEmpty()) {
            return;
        }
        UserScopeResult adminChargeUser = null;
        if (StringUtils.isEmpty((Object)adminChargeUser_allUserStr) && StringUtils.isEmpty((Object)adminChargeUser_userIDsStr)) {
            adminChargeUser = UserDirectPermDetailDelValidator.getPermissionService().getAdminChargeUser(Long.valueOf(currUserId), false);
        } else {
            boolean allUser = !StringUtils.isEmpty((Object)adminChargeUser_allUserStr) && !Objects.equals("0", adminChargeUser_allUserStr);
            ArrayList userIDs = StringUtils.isEmpty((Object)adminChargeUser_userIDsStr) ? new ArrayList(0) : (List)new ObjectMapper().readValue(adminChargeUser_userIDsStr, (TypeReference)new TypeReference<List<Long>>(){});
            adminChargeUser = new UserScopeResultImpl(allUser, userIDs);
        }
        if (adminChargeUser.isAllUser()) {
            return;
        }
        List chargeUserList = adminChargeUser.getUserIDs();
        Set want2DelUserIdSet = billPkIdUserIdMap.values().stream().collect(Collectors.toSet());
        Sets.SetView noPerm2DelUserIdSet = Sets.difference(want2DelUserIdSet, new HashSet(chargeUserList));
        if (null == noPerm2DelUserIdSet || noPerm2DelUserIdSet.isEmpty()) {
            return;
        }
        Map userInfoMap = UserHelper.getUserInfoMapByIds((Set)noPerm2DelUserIdSet, (String)RequestContext.get().getLang().name());
        for (ExtendedDataEntity value : this.dataEntities) {
            String billPkId;
            Long userId;
            User user;
            if (null == value || null == value.getBillPkId() || StringUtils.isEmpty((Object)((String)value.getBillPkId())) || null == (user = (User)userInfoMap.get(userId = billPkIdUserIdMap.get(billPkId = (String)value.getBillPkId()))) || !noPerm2DelUserIdSet.contains((Object)userId)) continue;
            value.setBillNo(billPkId);
            this.addErrorMessage(value, String.format(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff0c\u4eba\u5458\u201c%1$s\u201d\u4e0d\u5728\u7ba1\u7406\u5458\u201c\u884c\u653f\u7ec4\u7ec7\u7ba1\u8f96\u8303\u56f4\u201d\u6216\u201c\u4f8b\u5916\u4eba\u5458\u201d\u5185\u3002", (String)"UserRoleDelValidator_0", (String)"bos-permission-opplugin", (Object[])new Object[0]), null == user ? "" : user.getFtruename()));
        }
    }

    private static AbstractPermissionServiceImpl getPermissionService() {
        return (AbstractPermissionServiceImpl)PermissionServiceImplFactory.getImpl(null);
    }
}

