/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.opplugin.validator.del.userrole;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.FormHelper;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.factory.PermServiceFactory;
import kd.bos.permission.log.helper.PermLogHelper;
import kd.bos.permission.model.perm.PermBuilder;
import kd.bos.permission.model.perm.req.PermLogReq;
import kd.bos.permission.model.perm.req.PermOperationReq;
import kd.bos.permission.model.perm.req.bat.afterdel.UserComRoleAfterDelReq;
import kd.bos.permission.model.perm.req.userrole.GetUserRoleDimReq;
import kd.bos.permission.model.perm.userrole.UserRoleDim;
import kd.bos.permission.opplugin.validator.del.userrole.UserRoleDelValidator;
import kd.bos.permission.service.UserRoleService;
import kd.bos.util.StringUtils;

public class UserRoleDelOP
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(UserRoleDelOP.class);
    private static final String[] PERM_IGNOREREFENTITYIDS = new String[]{"perm_userrole", "perm_userrole_multype"};

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        Set ignorerefentityNumSet = FormHelper.getIgnoreRefEntNumSet((String[])PERM_IGNOREREFENTITYIDS);
        this.getOption().setVariableValue("ignorerefentityids", String.join((CharSequence)",", ignorerefentityNumSet));
        e.getValidators().add(new UserRoleDelValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
    }

    private Map<String, String> getOptionVariables() {
        Map variables = this.getOption().getVariables();
        variables = null == variables ? new HashMap(8) : variables;
        return variables;
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        try {
            super.beginOperationTransaction(e);
            DynamicObject[] dataEntities = e.getDataEntities();
            if (null == dataEntities || Objects.equals(0, dataEntities.length)) {
                return;
            }
            Map<String, String> variables = this.getOptionVariables();
            String delUserRoleDimMapStr = variables.get("delUserRoleDimMap");
            if (StringUtils.isEmpty((String)delUserRoleDimMapStr)) {
                Set userRoleFidSet = Arrays.stream(dataEntities).map(x -> String.valueOf(x.getPkValue())).collect(Collectors.toSet());
                Map userRoleDimMap = UserRoleService.getUserRoleDimMap((GetUserRoleDimReq)new GetUserRoleDimReq(Integer.valueOf(2), userRoleFidSet, null, null, null, null, null, null, null));
                this.getOption().setVariableValue("delUserRoleDimMap", StrUtil.compress((String)new ObjectMapper().writeValueAsString((Object)userRoleDimMap)));
            }
        }
        catch (Exception ex) {
            log.error("UserRoleDelOP.beginOperationTransaction error.", (Throwable)ex);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff1a%1$s", (String)"RoleDelOP_0", (String)"bos-permission-opplugin", (Object[])new Object[0]), ex.getMessage()));
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        try {
            super.endOperationTransaction(e);
            DynamicObject[] dataEntities = e.getDataEntities();
            if (null == dataEntities || Objects.equals(0, dataEntities.length)) {
                return;
            }
            Map<String, String> variables = this.getOptionVariables();
            String delUserRoleDimMapStr = variables.get("delUserRoleDimMap");
            HashMap delUserRoleDimMap = StringUtils.isEmpty((String)delUserRoleDimMapStr) ? new HashMap(1) : (Map)new ObjectMapper().readValue(StrUtil.uncompress((String)delUserRoleDimMapStr), (TypeReference)new TypeReference<Map<String, UserRoleDim>>(){});
            Set userRoleFidSet = Arrays.stream(dataEntities).map(x -> String.valueOf(x.getPkValue())).collect(Collectors.toSet());
            Iterator it = delUserRoleDimMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (userRoleFidSet.contains(entry.getKey())) continue;
                it.remove();
            }
            String defaultFormNum = dataEntities[0].getDynamicObjectType().getName();
            PermLogReq permLogReq = PermLogHelper.wrapOperPermLogReq(variables, (String)defaultFormNum, (String)"common_role_assignuserlist_del", (String)"delete", (String)ConstantsHelper.getDel(), (String)"kd.bos.permission.opplugin.validator.del.userrole.UserRoleDelOP.endOperationTransaction");
            UserComRoleAfterDelReq afterDelReq = (UserComRoleAfterDelReq)PermBuilder.of(UserComRoleAfterDelReq::new).with(PermOperationReq::setPermLogReq, (Object)permLogReq).with(UserComRoleAfterDelReq::setDelUserRoleDimMap, delUserRoleDimMap).build();
            UserRoleDelOP.getUserRoleService().afterDel((PermOperationReq)afterDelReq);
        }
        catch (Exception ex) {
            log.error("UserRoleDelOP.endOperationTransaction error.", (Throwable)ex);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff1a%1$s", (String)"RoleDelOP_0", (String)"bos-permission-opplugin", (Object[])new Object[0]), ex.getMessage()));
        }
    }

    private static UserRoleService getUserRoleService() {
        return (UserRoleService)PermServiceFactory.getService((String)"UserRoleService");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
    }
}

