/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.opplugin.validator.del.usrgrprole;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.bos.permission.cache.helper.IsoDimHelper;
import kd.bos.permission.cache.model.Dim;
import kd.bos.permission.model.perm.PermCtrlType;
import kd.bos.permission.model.perm.req.permctrltype.GetHasPermPermCtrlObjReq;
import kd.bos.permission.model.perm.resp.permctrltype.GetHasPermPermCtrlObjResp;
import kd.bos.permission.service.permctrltype.PermCtrlTypeService;
import kd.bos.servicehelper.QueryServiceHelper;

public class UsrGrpRoleDelValidator
extends AbstractValidator {
    private static final Log log = LogFactory.getLog(UsrGrpRoleDelValidator.class);

    private Map<String, String> getOptionVariables() {
        Map variables = this.getOption().getVariables();
        variables = null == variables ? new HashMap(8) : variables;
        return variables;
    }

    public void validate() {
        HashMap<Long, ExtendedDataEntity> extDataEntityMap = new HashMap<Long, ExtendedDataEntity>(8);
        for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
            Long billPkId;
            Object billPkIdObj;
            if (null == extendedDataEntity || null == (billPkIdObj = extendedDataEntity.getBillPkId()) || StringUtils.isEmpty((Object)(billPkId = (Long)billPkIdObj))) continue;
            extDataEntityMap.put(billPkId, extendedDataEntity);
        }
        try {
            this.delPermCheck(extDataEntityMap);
        }
        catch (Exception e) {
            log.error("UsrGrpRoleDelValidator.validate error.", (Throwable)e);
            throw new KDBizException("UsrGrpRoleDelValidator.validate error.");
        }
    }

    private void delPermCheck(Map<Long, ExtendedDataEntity> extDataEntityMap) throws Exception {
        HashSet<Long> billPkIdSet = new HashSet<Long>(extDataEntityMap.keySet());
        if (null != billPkIdSet && !billPkIdSet.isEmpty()) {
            HashMap<String, kd.bos.permission.model.perm.Dim> billPkIdDimMap = new HashMap<String, kd.bos.permission.model.perm.Dim>(8);
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"UsrGrpRoleDelValidator.delPermCheck", (String)"perm_usrgrprole", (String)"id,usrgrpid_id, dimtype, dimid_id", (QFilter[])new QFilter[]{new QFilter("id", "in", billPkIdSet)}, (String)"");){
                while (ds.hasNext()) {
                    String billPkId;
                    Object billPkIdObj;
                    Row row = ds.next();
                    Long id = row.getLong("id");
                    ExtendedDataEntity extendedDataEntity = extDataEntityMap.get(id);
                    if (null == extendedDataEntity || null == (billPkIdObj = extendedDataEntity.getBillPkId()) || StringUtils.isEmpty((Object)(billPkId = String.valueOf(billPkIdObj)))) continue;
                    String dimType = row.getString("dimtype");
                    Long dimId = row.getLong("dimid_id");
                    if (StringUtils.isEmpty((Object)dimType) || null == dimId || dimId <= 0L) continue;
                    billPkIdDimMap.put(billPkId, new kd.bos.permission.model.perm.Dim(dimType, dimId, Boolean.valueOf(false)));
                }
            }
            long currUserId = RequestContext.get().getCurrUserId();
            Map<String, String> variables = this.getOptionVariables();
            String permPkRowNumMapStr = variables.get("permPkRowNumMap");
            HashMap<String, Integer> permPkRowNumMap = StringUtils.isEmpty((Object)permPkRowNumMapStr) ? new HashMap<String, Integer>(0) : (Map)new ObjectMapper().readValue(permPkRowNumMapStr, (TypeReference)new TypeReference<HashMap<String, Integer>>(){});
            String permCtrlTypeMapStr = variables.get("permCtrlTypeMap");
            String dimHasPermDimResultMapStr = variables.get("dimHasPermDimResultMap");
            this.checkDimManageRange(billPkIdDimMap, currUserId, permPkRowNumMap, permCtrlTypeMapStr, dimHasPermDimResultMapStr);
        }
    }

    private void checkDimManageRange(Map<String, kd.bos.permission.model.perm.Dim> billPkIdDimMap, long currUserId, Map<String, Integer> permPkRowNumMap, String permCtrlTypeMapStr, String dimHasPermDimResultMapStr) throws Exception {
        if (null == billPkIdDimMap || billPkIdDimMap.isEmpty()) {
            return;
        }
        Set want2DelDimSet = billPkIdDimMap.values().stream().collect(Collectors.toSet());
        if (null == want2DelDimSet || want2DelDimSet.isEmpty()) {
            return;
        }
        HashMap<String, Set> want2DelDimTypeIdSetMap = new HashMap<String, Set>(8);
        for (kd.bos.permission.model.perm.Dim dim : want2DelDimSet) {
            String dimType = dim.getDimType();
            Long dimId = dim.getDimId();
            if (StringUtils.isEmpty((Object)dimType) || null == dimId || Objects.equals(0L, dimId)) continue;
            want2DelDimTypeIdSetMap.computeIfAbsent(dim.getDimType(), k -> new HashSet(8)).add(dim.getDimId());
        }
        if (null == want2DelDimTypeIdSetMap || want2DelDimTypeIdSetMap.isEmpty()) {
            return;
        }
        HashMap<String, Map> dimErrorMsgMap = new HashMap<String, Map>(8);
        Map permCtrlTypeMap = StringUtils.isEmpty((Object)permCtrlTypeMapStr) ? IsoDimHelper.getEntPermCtrlTypeMap(null) : (Map)new ObjectMapper().readValue(permCtrlTypeMapStr, (TypeReference)new TypeReference<HashMap<String, PermCtrlType>>(){});
        permCtrlTypeMap = null == permCtrlTypeMap ? new HashMap(0) : permCtrlTypeMap;
        HashMap dimHasPermDimResultMap = StringUtils.isEmpty((Object)dimHasPermDimResultMapStr) ? new HashMap(0) : (Map)new ObjectMapper().readValue(dimHasPermDimResultMapStr, (TypeReference)new TypeReference<HashMap<String, GetHasPermPermCtrlObjResp>>(){});
        for (Map.Entry want2DelDimTypeIdSet : want2DelDimTypeIdSetMap.entrySet()) {
            Set hasPermDimSet;
            HashSet hasPermDimIdSet;
            Sets.SetView noPerm2DelDimIdSet;
            String dimType = (String)want2DelDimTypeIdSet.getKey();
            Set want2DelDimIdSet = (Set)want2DelDimTypeIdSet.getValue();
            if (StringUtils.isEmpty((Object)dimType) || null == want2DelDimIdSet || want2DelDimIdSet.isEmpty()) continue;
            GetHasPermPermCtrlObjReq hasPermPermCtrlObjReq = new GetHasPermPermCtrlObjReq(dimType, Long.valueOf(currUserId), want2DelDimIdSet, null);
            GetHasPermPermCtrlObjResp hasPermDimResult = (GetHasPermPermCtrlObjResp)dimHasPermDimResultMap.get(dimType);
            hasPermDimResult = null == hasPermDimResult ? PermCtrlTypeService.getAdminHasPermPermCtrlObj((GetHasPermPermCtrlObjReq)hasPermPermCtrlObjReq) : hasPermDimResult;
            if (hasPermDimResult.isHasAllDimPerm() || null == (noPerm2DelDimIdSet = Sets.difference((Set)want2DelDimIdSet, hasPermDimIdSet = null == (hasPermDimSet = hasPermDimResult.getHasPermDimSet()) ? new HashSet(0) : hasPermDimSet.stream().map(kd.bos.permission.model.perm.Dim::getDimId).collect(Collectors.toSet()))) || noPerm2DelDimIdSet.isEmpty()) continue;
            Map dimMap = IsoDimHelper.getDimMap(new ArrayList(noPerm2DelDimIdSet), (String)dimType);
            for (Long one : noPerm2DelDimIdSet) {
                Dim dim = (Dim)dimMap.get(one);
                if (null == dim) continue;
                String innerDimType = dim.getDimType();
                Long innerDimId = dim.getDimId();
                if (StringUtils.isEmpty((Object)innerDimType) || null == innerDimId || Objects.equals(0L, innerDimId)) continue;
                String dimName = null == dim ? "" : dim.getDimName();
                String dimTypeName = null == permCtrlTypeMap.get(dimType) ? "" : ((PermCtrlType)permCtrlTypeMap.get(dimType)).getName();
                dimErrorMsgMap.computeIfAbsent(innerDimType, k -> new HashMap(8)).put(innerDimId, String.format(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff0c%1$s\u201c%2$s\u201d\u4e0d\u5728\u7ba1\u7406\u5458\u201c%3$s\u7ba1\u8f96\u8303\u56f4\u201d\u5185\u3002", (String)"UserRoleDelValidator_1", (String)"bos-permission-opplugin", (Object[])new Object[0]), dimTypeName, dimName, dimTypeName));
            }
        }
        if (null == dimErrorMsgMap || dimErrorMsgMap.isEmpty()) {
            return;
        }
        for (ExtendedDataEntity value : this.dataEntities) {
            Long dimId;
            String dimType;
            Map dimIdErrorMsgMap;
            String billPkId;
            kd.bos.permission.model.perm.Dim dim;
            if (null == value || null == value.getBillPkId() || StringUtils.isEmpty((Object)String.valueOf(value.getBillPkId())) || null == (dim = billPkIdDimMap.get(billPkId = String.valueOf(value.getBillPkId()))) || StringUtils.isEmpty((Object)dim.getDimType()) || null == dim.getDimId() || Objects.equals(0L, dim.getDimId()) || null == (dimIdErrorMsgMap = (Map)dimErrorMsgMap.get(dimType = dim.getDimType())) || dimIdErrorMsgMap.isEmpty() || !dimIdErrorMsgMap.containsKey(dimId = dim.getDimId())) continue;
            String errorMsg = (String)dimIdErrorMsgMap.get(dimId);
            value.setBillNo(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c", (String)"UserRoleDelValidator_4", (String)"bos-permission-opplugin", (Object[])new Object[0]), null == permPkRowNumMap.get(billPkId) ? 0 : permPkRowNumMap.get(billPkId) + 1));
            this.addErrorMessage(value, errorMsg);
        }
    }
}

