/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.opplugin.validator.save.admingroup;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppInfo;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.permission.cache.helper.AdminSchemeHelper;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.model.PermResult;
import kd.bos.permission.model.perm.PermBuilder;
import kd.bos.permission.model.perm.admingroup.AdmGrpApp;
import kd.bos.permission.model.perm.req.admin.savecheck.SaveCheckAdmGrpReq;
import kd.bos.permission.model.perm.req.common.GetBaseDataDynMapReq;
import kd.bos.permission.model.perm.resp.admin.AdmGrpHasPermResp;
import kd.bos.permission.model.perm.resp.common.GetBaseDataDynMapResp;
import kd.bos.permission.opplugin.validator.save.admingroup.AdmGrpSaveValidator;
import kd.bos.permission.service.AdminGroupService;
import kd.bos.permission.service.admingroup.AdmGrpAppService;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class AdmGrpAppSaveValidator
extends AbstractValidator {
    private static final Log log = LogFactory.getLog(AdmGrpAppSaveValidator.class);

    private Map<String, String> getOptionVariables() {
        Map variables = this.getOption().getVariables();
        variables = null == variables ? new HashMap(8) : variables;
        return variables;
    }

    public void validate() {
        Map<String, String> optionVariables = this.getOptionVariables();
        String alreadyCheckBusiParam = optionVariables.get("ALREADY_CHECKBUSIPARAM");
        if (!StringUtils.isEmpty((Object)alreadyCheckBusiParam) && Objects.equals("1", alreadyCheckBusiParam)) {
            return;
        }
        long currUserId = RequestContext.get().getCurrUserId();
        boolean curUserIsAdmin = PermissionServiceHelper.isAdminUser((long)currUserId);
        Long curEnableSchemeId = AdminSchemeHelper.getCurEnableSchemeId();
        Set canSavePermAdmGroupIdSet = AdminGroupService.getCanOperAdmGroupIdSet((Long)currUserId, (boolean)false, (String)optionVariables.get("canSavePermAdmGroupIdSet_useThreadCache"));
        HashSet admGrpIdSet = new HashSet(8);
        Arrays.stream(this.dataEntities).forEach(extendedData -> {
            Object grpIdObj = extendedData.getValue("usergroup_id");
            if (null != grpIdObj) {
                admGrpIdSet.add((Long)grpIdObj);
            }
        });
        GetBaseDataDynMapResp baseDataDynMap = PermCommonUtil.getBaseDataDynMap((GetBaseDataDynMapReq)((GetBaseDataDynMapReq)PermBuilder.of(GetBaseDataDynMapReq::new).with(GetBaseDataDynMapReq::setAdmGrpIdSet, admGrpIdSet).build()));
        Map admGrpDynMap = baseDataDynMap.getAdmGrpDynMap();
        StringBuilder errorInfo = new StringBuilder();
        for (ExtendedDataEntity extendedData2 : this.dataEntities) {
            try {
                Object grpIdObj = extendedData2.getValue("usergroup_id");
                if (null == grpIdObj) {
                    String info = ResManager.loadKDString((String)"\u7ba1\u7406\u5458\u7ec4\u4e0d\u5b58\u5728\u3002", (String)"AdmGrpFunpermSaveValidator_0", (String)"bos-permission-opplugin", (Object[])new Object[0]);
                    this.appendErrorInfo(errorInfo, extendedData2, info);
                    return;
                }
                Long adminGroupId = (Long)grpIdObj;
                DynamicObject admGrpDyn = (DynamicObject)admGrpDynMap.get(adminGroupId);
                if (null == admGrpDyn) {
                    String info = ResManager.loadKDString((String)"\u7ba1\u7406\u5458\u7ec4\u4e0d\u5b58\u5728\u3002", (String)"AdmGrpFunpermSaveValidator_0", (String)"bos-permission-opplugin", (Object[])new Object[0]);
                    this.appendErrorInfo(errorInfo, extendedData2, info);
                    return;
                }
                Object appIdObj = extendedData2.getValue("app");
                if (null == appIdObj) {
                    String info = ResManager.loadKDString((String)"\u5e94\u7528\u4e0d\u5b58\u5728\u3002", (String)"AdmGrpFunpermSaveValidator_4", (String)"bos-permission-opplugin", (Object[])new Object[0]);
                    this.appendErrorInfo(errorInfo, extendedData2, info);
                    return;
                }
                String appId = (String)appIdObj;
                Long parentId = AdmGrpSaveValidator.getParentId(admGrpDyn);
                Map hasPermMap = AdmGrpAppService.getAssignableAdmGrpHasPerm((Set)Sets.newHashSet((Object[])new Long[]{parentId}));
                AdmGrpHasPermResp admGrpHasPermResp = (AdmGrpHasPermResp)hasPermMap.get(parentId);
                PermResult checkRes = AdmGrpAppSaveValidator.check((SaveCheckAdmGrpReq)PermBuilder.of(SaveCheckAdmGrpReq::new).with(SaveCheckAdmGrpReq::setAdmGrpFromDB, (Object)true).with(SaveCheckAdmGrpReq::setCanOperAdmGroupIdSet, (Object)canSavePermAdmGroupIdSet).with(SaveCheckAdmGrpReq::setAdmGrpHasPermResp, (Object)admGrpHasPermResp).with(SaveCheckAdmGrpReq::setCurAdmGrpDyn, (Object)admGrpDyn).with(SaveCheckAdmGrpReq::setCurAppId, (Object)appId).with(SaveCheckAdmGrpReq::setCurUserIsAdmin, (Object)curUserIsAdmin).with(SaveCheckAdmGrpReq::setCurEnableSchemeId, (Object)curEnableSchemeId).build());
                if (checkRes.isOk()) continue;
                this.appendErrorInfo(errorInfo, extendedData2, checkRes.getMsg());
                return;
            }
            catch (Exception e) {
                log.error("{}.{} error.", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), Thread.currentThread().getStackTrace()[1].getMethodName(), e});
                this.addErrorMessage(extendedData2, e.getMessage());
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a%1$s", (String)"RoleSaveOP_0", (String)"bos-permission-opplugin", (Object[])new Object[0]), e.getMessage()));
            }
        }
    }

    public static PermResult check(SaveCheckAdmGrpReq saveCheckParam) {
        String appName;
        boolean admGrpFromDB = saveCheckParam.isAdmGrpFromDB();
        Set canSavePermAdmGroupIdSet = saveCheckParam.getCanOperAdmGroupIdSet();
        AdmGrpHasPermResp admGrpHasPermResp = saveCheckParam.getAdmGrpHasPermResp();
        DynamicObject curAdmGrpDyn = saveCheckParam.getCurAdmGrpDyn();
        String curAppId = saveCheckParam.getCurAppId();
        boolean curUserIsAdmin = saveCheckParam.isCurUserIsAdmin();
        if (!curUserIsAdmin) {
            String info = ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u4e0d\u662f\u7ba1\u7406\u5458\u3002", (String)"AdmGrpSaveValidator_1", (String)"bos-permission-opplugin", (Object[])new Object[0]);
            return PermResult.fail((String)info);
        }
        if (null == curAdmGrpDyn) {
            String info = ResManager.loadKDString((String)"\u7ba1\u7406\u5458\u7ec4\u4e0d\u5b58\u5728\u3002", (String)"AdmGrpFunpermSaveValidator_0", (String)"bos-permission-opplugin", (Object[])new Object[0]);
            return PermResult.fail((String)info);
        }
        Long curAdmGrpId = curAdmGrpDyn.getLong("id");
        if (admGrpFromDB && (null == curAdmGrpId || Objects.equals(0L, curAdmGrpId))) {
            String info = ResManager.loadKDString((String)"\u7ba1\u7406\u5458\u7ec4\u4e0d\u5b58\u5728\u3002", (String)"AdmGrpFunpermSaveValidator_0", (String)"bos-permission-opplugin", (Object[])new Object[0]);
            return PermResult.fail((String)info);
        }
        AppInfo curApp = AppHelper.getMetaAppInfo((String)curAppId);
        if (null == curApp) {
            String info = ResManager.loadKDString((String)"\u5e94\u7528\u4e0d\u5b58\u5728\u3002", (String)"AdmGrpFunpermSaveValidator_4", (String)"bos-permission-opplugin", (Object[])new Object[0]);
            return PermResult.fail((String)info);
        }
        String curAdmGrpName = curAdmGrpDyn.getString("name");
        long curGroupAdminSchemeId = AdmGrpSaveValidator.getAdminschemeId(curAdmGrpDyn);
        Long curEnableSchemeId = saveCheckParam.getCurEnableSchemeId();
        if (!Objects.equals(curEnableSchemeId, curGroupAdminSchemeId)) {
            return PermResult.fail((String)String.format(ResManager.loadKDString((String)"\u8be5\u7ba1\u7406\u5458\u7ec4\u201c%1$s\u201d\u4e0d\u5c5e\u4e8e\u5f53\u524d\u865a\u62df\u7ba1\u7406\u5458\u63a7\u5236\u7b56\u7565\u3002", (String)"AdmGrpSaveValidator_3", (String)"bos-permission-opplugin", (Object[])new Object[0]), curAdmGrpName));
        }
        if (admGrpFromDB && CollectionUtils.isEmpty((Collection)canSavePermAdmGroupIdSet)) {
            String info = String.format(ResManager.loadKDString((String)"\u60a8\u65e0\u6743\u4fee\u6539\u7ba1\u7406\u5458\u7ec4\u7f16\u7801\u4e3a\u201c%1$s\u201d\u7684\u5206\u7ec4\u6388\u6743\u4fe1\u606f\u3002", (String)"AdmGrpFunpermSaveValidator_1", (String)"bos-permission-opplugin", (Object[])new Object[0]), curAdmGrpName);
            return PermResult.fail((String)info);
        }
        if (admGrpFromDB && !canSavePermAdmGroupIdSet.contains(String.valueOf(curAdmGrpId))) {
            String info = String.format(ResManager.loadKDString((String)"\u60a8\u65e0\u6743\u4fee\u6539\u7ba1\u7406\u5458\u7ec4\u7f16\u7801\u4e3a\u201c%1$s\u201d\u7684\u5206\u7ec4\u6388\u6743\u4fe1\u606f\u3002", (String)"AdmGrpFunpermSaveValidator_1", (String)"bos-permission-opplugin", (Object[])new Object[0]), curAdmGrpName);
            return PermResult.fail((String)info);
        }
        String appId = curApp.getId();
        String string = appName = null == curApp ? appId : curApp.getName().getLocaleValue();
        if (null == admGrpHasPermResp) {
            String info = String.format(ResManager.loadKDString((String)"\u60a8\u5728\u7ba1\u7406\u5458\u7ec4\u201c%1$s\u201d\u7684\u5e94\u7528\u8303\u56f4\u4e2d\u6ca1\u6709\u201c%2$s\u201d\u7684\u6743\u9650\u3002", (String)"AdmGrpAppSaveValidator_0", (String)"bos-permission-opplugin", (Object[])new Object[0]), curAdmGrpName, appName);
            return PermResult.fail((String)info);
        }
        boolean hasAllApp = admGrpHasPermResp.isHasAllApp();
        Set appSet = admGrpHasPermResp.getAppSet();
        if (!hasAllApp) {
            if (null == appSet || appSet.isEmpty()) {
                String info = String.format(ResManager.loadKDString((String)"\u60a8\u5728\u7ba1\u7406\u5458\u7ec4\u201c%1$s\u201d\u7684\u5e94\u7528\u8303\u56f4\u4e2d\u6ca1\u6709\u201c%2$s\u201d\u7684\u6743\u9650\u3002", (String)"AdmGrpAppSaveValidator_0", (String)"bos-permission-opplugin", (Object[])new Object[0]), curAdmGrpName, appName);
                return PermResult.fail((String)info);
            }
            AdmGrpApp findOne = appSet.stream().filter(x -> Objects.equals(appId, x.getAppId())).findFirst().orElse(null);
            if (null == findOne) {
                String info = String.format(ResManager.loadKDString((String)"\u60a8\u5728\u7ba1\u7406\u5458\u7ec4\u201c%1$s\u201d\u7684\u5e94\u7528\u8303\u56f4\u4e2d\u6ca1\u6709\u201c%2$s\u201d\u7684\u6743\u9650\u3002", (String)"AdmGrpAppSaveValidator_0", (String)"bos-permission-opplugin", (Object[])new Object[0]), curAdmGrpName, appName);
                return PermResult.fail((String)info);
            }
        }
        return PermResult.ok();
    }

    private void appendErrorInfo(StringBuilder errorInfo, ExtendedDataEntity dyn, String info) {
        errorInfo.setLength(0);
        errorInfo.append(info);
        this.addErrorMessage(dyn, errorInfo.toString());
    }
}

