/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.opplugin.validator.save.admingroup;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.api.ext.IPermExt;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.factory.PermServiceFactory;
import kd.bos.permission.log.helper.PermLogHelper;
import kd.bos.permission.model.perm.PermBuilder;
import kd.bos.permission.model.perm.admingroup.AdmGrpApp;
import kd.bos.permission.model.perm.admingroup.AdmGrpBizUnit;
import kd.bos.permission.model.perm.admingroup.AdmGrpFunperm;
import kd.bos.permission.model.perm.admingroup.AdmGrpOrg;
import kd.bos.permission.model.perm.admingroup.AdmGrpOrgAddUser;
import kd.bos.permission.model.perm.req.PermLogReq;
import kd.bos.permission.model.perm.req.PermOperationReq;
import kd.bos.permission.model.perm.req.admin.AdmGrpOperationReq;
import kd.bos.permission.model.perm.req.admin.get.GetAdmGrpReq;
import kd.bos.permission.opplugin.validator.save.admingroup.AdmGrpSaveValidator;
import kd.bos.permission.service.AdminGroupService;
import kd.bos.util.StringUtils;

public class AdmGrpSaveOp
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(AdmGrpSaveOp.class);

    private Map<String, String> getOptionVariables() {
        Map variables = this.getOption().getVariables();
        variables = null == variables ? new HashMap(8) : variables;
        return variables;
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        Map<String, String> variables = this.getOptionVariables();
        if (!PermCommonUtil.permEnableEntityOperservice(variables)) {
            return;
        }
        e.getValidators().add(new AdmGrpSaveValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        try {
            super.beginOperationTransaction(e);
            Map<String, String> variables = this.getOptionVariables();
            if (!PermCommonUtil.permEnableEntityOperservice(variables)) {
                return;
            }
            DynamicObject[] dataEntities = e.getDataEntities();
            if (null == dataEntities || Objects.equals(0, dataEntities.length)) {
                return;
            }
            String preDataMapStr = variables.get("preDataMap");
            if (StringUtils.isEmpty((String)preDataMapStr)) {
                Set mainIdSet = Arrays.stream(dataEntities).map(x -> (Long)x.getPkValue()).collect(Collectors.toSet());
                Map admGrpMap = AdminGroupService.getAdmGrpMap((GetAdmGrpReq)new GetAdmGrpReq(mainIdSet, true, true, true));
                this.getOption().setVariableValue("preDataMap", StrUtil.compress((String)new ObjectMapper().writeValueAsString((Object)admGrpMap)));
            }
        }
        catch (Exception ex) {
            log.error("{}.{} error.", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), Thread.currentThread().getStackTrace()[1].getMethodName(), ex});
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a%1$s", (String)"RoleSaveOP_0", (String)"bos-permission-opplugin", (Object[])new Object[0]), ex.getMessage()));
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        try {
            String currbizappNum;
            super.endOperationTransaction(e);
            Map<String, String> variables = this.getOptionVariables();
            if (!PermCommonUtil.permEnableEntityOperservice(variables)) {
                return;
            }
            DynamicObject[] dataEntities = e.getDataEntities();
            if (null == dataEntities || Objects.equals(0, dataEntities.length)) {
                return;
            }
            HashMap<String, Set<AdmGrpFunperm>> willDelFunpermMap = new HashMap<String, Set<AdmGrpFunperm>>(8);
            HashMap<String, Set<AdmGrpFunperm>> willAddFunpermMap = new HashMap<String, Set<AdmGrpFunperm>>(8);
            HashMap<String, Set<AdmGrpBizUnit>> willDelBizUnitMap = new HashMap<String, Set<AdmGrpBizUnit>>(8);
            HashMap<String, Set<AdmGrpBizUnit>> willAddBizUnitMap = new HashMap<String, Set<AdmGrpBizUnit>>(8);
            HashMap<String, Set<AdmGrpOrg>> willDelOrgMap = new HashMap<String, Set<AdmGrpOrg>>(8);
            HashMap<String, Set<AdmGrpOrg>> willAddOrgMap = new HashMap<String, Set<AdmGrpOrg>>(8);
            HashMap<String, Set<AdmGrpOrgAddUser>> willDelOrgAddUserMap = new HashMap<String, Set<AdmGrpOrgAddUser>>(8);
            HashMap<String, Set<AdmGrpOrgAddUser>> willAddOrgAddUserMap = new HashMap<String, Set<AdmGrpOrgAddUser>>(8);
            HashMap<String, Set<AdmGrpApp>> willDelAppMap = new HashMap<String, Set<AdmGrpApp>>(8);
            HashMap<String, Set<AdmGrpApp>> willAddAppMap = new HashMap<String, Set<AdmGrpApp>>(8);
            HashSet<String> mainIdSet = new HashSet<String>(8);
            AdmGrpSaveOp.getWillData(variables, dataEntities, willDelFunpermMap, willAddFunpermMap, willDelBizUnitMap, willAddBizUnitMap, willDelOrgMap, willAddOrgMap, willDelOrgAddUserMap, willAddOrgAddUserMap, willDelAppMap, willAddAppMap, mainIdSet);
            variables.put("ENTSAVE_PERMLOG", StringUtils.isEmpty((String)variables.get("ENTSAVE_PERMLOG")) ? "1" : variables.get("ENTSAVE_PERMLOG"));
            String defaultFormFlag = StringUtils.isEmpty((String)variables.get("permlog_formnum")) ? dataEntities[0].getDynamicObjectType().getName() : variables.get("permlog_formnum");
            String defaultPermlogBusitype = StringUtils.isEmpty((String)variables.get("permlog_busitype")) ? "admingroup_modify" : variables.get("permlog_busitype");
            String defaultOp = StringUtils.isEmpty((String)variables.get("permlog_op")) ? "save" : variables.get("permlog_op");
            String defaultOpbtn = StringUtils.isEmpty((String)variables.get("permlog_opbtn")) ? ConstantsHelper.getSave() : variables.get("permlog_opbtn");
            String defaultPermlogInterfacemethod = StringUtils.isEmpty((String)variables.get("permlog_interfacemethod")) ? "AdmGrpSaveOp.endOperationTransaction" : variables.get("permlog_interfacemethod");
            String batchimport = variables.get("batchimport");
            if (Objects.equals("true", batchimport)) {
                defaultOp = "importdata";
                defaultOpbtn = ConstantsHelper.getImportData();
            }
            if (StringUtils.isEmpty((String)(currbizappNum = variables.get("currbizappid")))) {
                currbizappNum = "devportal";
                variables.put("currbizappid", currbizappNum);
            }
            PermLogReq permLogReq = PermLogHelper.wrapOperPermLogReq(variables, (String)defaultFormFlag, (String)defaultPermlogBusitype, (String)defaultOp, (String)defaultOpbtn, (String)defaultPermlogInterfacemethod);
            String preDataMapStr = variables.get("preDataMap");
            AdmGrpOperationReq afterSaveReq = (AdmGrpOperationReq)PermBuilder.of(AdmGrpOperationReq::new).with(PermOperationReq::setCurAppNum, (Object)currbizappNum).with(PermOperationReq::setCurFormNum, (Object)defaultFormFlag).with(PermOperationReq::setMainIdSet, mainIdSet).with(PermOperationReq::setPermLogReq, (Object)permLogReq).with(PermOperationReq::setPreDataMapStr, (Object)preDataMapStr).with(AdmGrpOperationReq::setWillDelFunpermMap, willDelFunpermMap).with(AdmGrpOperationReq::setWillAddFunpermMap, willAddFunpermMap).with(AdmGrpOperationReq::setWillDelBizUnitMap, willDelBizUnitMap).with(AdmGrpOperationReq::setWillAddBizUnitMap, willAddBizUnitMap).with(AdmGrpOperationReq::setWillDelOrgMap, willDelOrgMap).with(AdmGrpOperationReq::setWillAddOrgMap, willAddOrgMap).with(AdmGrpOperationReq::setWillDelOrgAddUserMap, willDelOrgAddUserMap).with(AdmGrpOperationReq::setWillAddOrgAddUserMap, willAddOrgAddUserMap).with(AdmGrpOperationReq::setWillDelAppMap, willDelAppMap).with(AdmGrpOperationReq::setWillAddAppMap, willAddAppMap).with(PermOperationReq::setNeedClearAllCache, (Object)variables.get("NEED_CLEARALLCACHE")).with(PermOperationReq::setDoDelExcessData, (Object)variables.get("DO_DELEXCESSDATA")).with(PermOperationReq::setAlreadyCheckBusiParam, (Object)variables.get("ALREADY_CHECKBUSIPARAM")).build();
            ((IPermExt)PermServiceFactory.getService((String)"AdminGroupService")).afterMainEntitySave((PermOperationReq)afterSaveReq);
        }
        catch (Exception ex) {
            log.error("{}.{} error.", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), Thread.currentThread().getStackTrace()[1].getMethodName(), ex});
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a%1$s", (String)"RoleSaveOP_0", (String)"bos-permission-opplugin", (Object[])new Object[0]), ex.getMessage()));
        }
    }

    private static void getWillData(Map<String, String> variables, DynamicObject[] dataEntities, Map<String, Set<AdmGrpFunperm>> willDelFunpermMap, Map<String, Set<AdmGrpFunperm>> willAddFunpermMap, Map<String, Set<AdmGrpBizUnit>> willDelBizUnitMap, Map<String, Set<AdmGrpBizUnit>> willAddBizUnitMap, Map<String, Set<AdmGrpOrg>> willDelOrgMap, Map<String, Set<AdmGrpOrg>> willAddOrgMap, Map<String, Set<AdmGrpOrgAddUser>> willDelOrgAddUserMap, Map<String, Set<AdmGrpOrgAddUser>> willAddOrgAddUserMap, Map<String, Set<AdmGrpApp>> willDelAppMap, Map<String, Set<AdmGrpApp>> willAddAppMap, Set<String> mainIdSet) throws JsonProcessingException {
        String willAddAppMapStr;
        String willAddOrgAddUserMapStr;
        String willAddOrgMapStr;
        String willAddBizUnitMapStr;
        String willAddFunpermMapStr;
        Map willDelFunpermMap_ = new HashMap(8);
        Map willAddFunpermMap_ = new HashMap(8);
        String willDelFunpermMapStr = variables.get("willDelFunpermMap");
        if (StringUtils.isNotEmpty((String)willDelFunpermMapStr)) {
            willDelFunpermMap_ = (Map)new ObjectMapper().readValue(willDelFunpermMapStr, (TypeReference)new TypeReference<HashMap<String, Set<AdmGrpFunperm>>>(){});
        }
        if (StringUtils.isNotEmpty((String)(willAddFunpermMapStr = variables.get("willAddFunpermMap")))) {
            willAddFunpermMap_ = (Map)new ObjectMapper().readValue(willAddFunpermMapStr, (TypeReference)new TypeReference<HashMap<String, Set<AdmGrpFunperm>>>(){});
        }
        Map willDelBizUnitMap_ = new HashMap(8);
        Map willAddBizUnitMap_ = new HashMap(8);
        String willDelBizUnitMapStr = variables.get("willDelBizUnitMap");
        if (StringUtils.isNotEmpty((String)willDelBizUnitMapStr)) {
            willDelBizUnitMap_ = (Map)new ObjectMapper().readValue(willDelBizUnitMapStr, (TypeReference)new TypeReference<HashMap<String, Set<AdmGrpBizUnit>>>(){});
        }
        if (StringUtils.isNotEmpty((String)(willAddBizUnitMapStr = variables.get("willAddBizUnitMap")))) {
            willAddBizUnitMap_ = (Map)new ObjectMapper().readValue(willAddBizUnitMapStr, (TypeReference)new TypeReference<HashMap<String, Set<AdmGrpBizUnit>>>(){});
        }
        Map willDelOrgMap_ = new HashMap(8);
        Map willAddOrgMap_ = new HashMap(8);
        String willDelOrgMapStr = variables.get("willDelOrgMap");
        if (StringUtils.isNotEmpty((String)willDelOrgMapStr)) {
            willDelOrgMap_ = (Map)new ObjectMapper().readValue(willDelOrgMapStr, (TypeReference)new TypeReference<HashMap<String, Set<AdmGrpOrg>>>(){});
        }
        if (StringUtils.isNotEmpty((String)(willAddOrgMapStr = variables.get("willAddOrgMap")))) {
            willAddOrgMap_ = (Map)new ObjectMapper().readValue(willAddOrgMapStr, (TypeReference)new TypeReference<HashMap<String, Set<AdmGrpOrg>>>(){});
        }
        Map willDelOrgAddUserMap_ = new HashMap(8);
        Map willAddOrgAddUserMap_ = new HashMap(8);
        String willDelOrgAddUserMapStr = variables.get("willDelOrgAddUserMap");
        if (StringUtils.isNotEmpty((String)willDelOrgAddUserMapStr)) {
            willDelOrgAddUserMap_ = (Map)new ObjectMapper().readValue(willDelOrgAddUserMapStr, (TypeReference)new TypeReference<HashMap<String, Set<AdmGrpOrgAddUser>>>(){});
        }
        if (StringUtils.isNotEmpty((String)(willAddOrgAddUserMapStr = variables.get("willAddOrgAddUserMap")))) {
            willAddOrgAddUserMap_ = (Map)new ObjectMapper().readValue(willAddOrgAddUserMapStr, (TypeReference)new TypeReference<HashMap<String, Set<AdmGrpOrgAddUser>>>(){});
        }
        Map willDelAppMap_ = new HashMap(8);
        Map willAddAppMap_ = new HashMap(8);
        String willDelAppMapStr = variables.get("willDelAppMap");
        if (StringUtils.isNotEmpty((String)willDelAppMapStr)) {
            willDelAppMap_ = (Map)new ObjectMapper().readValue(willDelAppMapStr, (TypeReference)new TypeReference<HashMap<String, Set<AdmGrpApp>>>(){});
        }
        if (StringUtils.isNotEmpty((String)(willAddAppMapStr = variables.get("willAddAppMap")))) {
            willAddAppMap_ = (Map)new ObjectMapper().readValue(willAddAppMapStr, (TypeReference)new TypeReference<HashMap<String, Set<AdmGrpApp>>>(){});
        }
        for (DynamicObject dyn : dataEntities) {
            if (null == dyn) continue;
            String mainId = dyn.getString("id");
            mainIdSet.add(mainId);
            String number = dyn.getString("number");
            Set delAdmGrpFunperms = null == willDelFunpermMap_.get(number) ? new HashSet(0) : (Set)willDelFunpermMap_.get(number);
            willDelFunpermMap.computeIfAbsent(mainId, k -> new HashSet(0)).addAll(delAdmGrpFunperms);
            Set addAdmGrpFunperms = null == willAddFunpermMap_.get(number) ? new HashSet(0) : (Set)willAddFunpermMap_.get(number);
            willAddFunpermMap.computeIfAbsent(mainId, k -> new HashSet(0)).addAll(addAdmGrpFunperms);
            Set delAdmGrpBizUnits = null == willDelBizUnitMap_.get(number) ? new HashSet(0) : (Set)willDelBizUnitMap_.get(number);
            willDelBizUnitMap.computeIfAbsent(mainId, k -> new HashSet(0)).addAll(delAdmGrpBizUnits);
            Set addAdmGrpBizUnits = null == willAddBizUnitMap_.get(number) ? new HashSet(0) : (Set)willAddBizUnitMap_.get(number);
            willAddBizUnitMap.computeIfAbsent(mainId, k -> new HashSet(0)).addAll(addAdmGrpBizUnits);
            Set delAdmGrpOrgs = null == willDelOrgMap_.get(number) ? new HashSet(0) : (Set)willDelOrgMap_.get(number);
            willDelOrgMap.computeIfAbsent(mainId, k -> new HashSet(0)).addAll(delAdmGrpOrgs);
            Set addAdmGrpOrgs = null == willAddOrgMap_.get(number) ? new HashSet(0) : (Set)willAddOrgMap_.get(number);
            willAddOrgMap.computeIfAbsent(mainId, k -> new HashSet(0)).addAll(addAdmGrpOrgs);
            Set delAdmGrpOrgAddUsers = null == willDelOrgAddUserMap_.get(number) ? new HashSet(0) : (Set)willDelOrgAddUserMap_.get(number);
            willDelOrgAddUserMap.computeIfAbsent(mainId, k -> new HashSet(0)).addAll(delAdmGrpOrgAddUsers);
            Set addAdmGrpOrgAddUsers = null == willAddOrgAddUserMap_.get(number) ? new HashSet(0) : (Set)willAddOrgAddUserMap_.get(number);
            willAddOrgAddUserMap.computeIfAbsent(mainId, k -> new HashSet(0)).addAll(addAdmGrpOrgAddUsers);
            Set delAdmGrpApps = null == willDelAppMap_.get(number) ? new HashSet(0) : (Set)willDelAppMap_.get(number);
            willDelAppMap.computeIfAbsent(mainId, k -> new HashSet(0)).addAll(delAdmGrpApps);
            Set addAdmGrpApps = null == willAddAppMap_.get(number) ? new HashSet(0) : (Set)willAddAppMap_.get(number);
            willAddAppMap.computeIfAbsent(mainId, k -> new HashSet(0)).addAll(addAdmGrpApps);
        }
    }
}

