/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.opplugin.validator.save.admingroup;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.helper.AdminSchemeHelper;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.model.AdminType;
import kd.bos.permission.model.PermResult;
import kd.bos.permission.model.perm.PermBuilder;
import kd.bos.permission.model.perm.admingroup.AdmGrpApp;
import kd.bos.permission.model.perm.admingroup.AdmGrpBizUnit;
import kd.bos.permission.model.perm.admingroup.AdmGrpFunperm;
import kd.bos.permission.model.perm.admingroup.AdmGrpOrg;
import kd.bos.permission.model.perm.admingroup.AdmGrpOrgAddUser;
import kd.bos.permission.model.perm.req.admin.delcheck.DelCheckAdmGrpReq;
import kd.bos.permission.model.perm.req.admin.savecheck.SaveCheckAdmGrpReq;
import kd.bos.permission.model.perm.req.common.GetBaseDataDynMapReq;
import kd.bos.permission.model.perm.resp.admin.AdmGrpHasPermResp;
import kd.bos.permission.model.perm.resp.common.GetBaseDataDynMapResp;
import kd.bos.permission.opplugin.validator.del.admingroup.AdmGrpAppDelValidator;
import kd.bos.permission.opplugin.validator.del.admingroup.AdmGrpBizUnitDelValidator;
import kd.bos.permission.opplugin.validator.del.admingroup.AdmGrpFunpermDelValidator;
import kd.bos.permission.opplugin.validator.del.admingroup.AdmGrpOrgAddUserDelValidator;
import kd.bos.permission.opplugin.validator.del.admingroup.AdmGrpOrgDelValidator;
import kd.bos.permission.opplugin.validator.save.admingroup.AdmGrpAppSaveValidator;
import kd.bos.permission.opplugin.validator.save.admingroup.AdmGrpBizUnitSaveValidator;
import kd.bos.permission.opplugin.validator.save.admingroup.AdmGrpFunpermSaveValidator;
import kd.bos.permission.opplugin.validator.save.admingroup.AdmGrpOrgAddUserSaveValidator;
import kd.bos.permission.opplugin.validator.save.admingroup.AdmGrpOrgSaveValidator;
import kd.bos.permission.service.AdminGroupService;
import kd.bos.permission.service.admingroup.AdmGrpAppService;
import kd.bos.permission.service.admingroup.AdmGrpBizUnitService;
import kd.bos.permission.service.admingroup.AdmGrpFunpermService;
import kd.bos.permission.service.admingroup.AdmGrpOrgAddUserService;
import kd.bos.permission.service.admingroup.AdmGrpOrgService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;

public class AdmGrpSaveValidator
extends AbstractValidator {
    private static final Log log = LogFactory.getLog(AdmGrpSaveValidator.class);

    private Map<String, String> getOptionVariables() {
        Map variables = this.getOption().getVariables();
        variables = null == variables ? new HashMap(8) : variables;
        return variables;
    }

    public void validate() {
        try {
            long currUserId = RequestContext.get().getCurrUserId();
            Map<String, String> variables = this.getOptionVariables();
            String willDelFunpermMapStr = variables.get("willDelFunpermMap");
            HashMap<String, Set<AdmGrpFunperm>> willDelFunpermMap = StringUtils.isEmpty((String)willDelFunpermMapStr) ? new HashMap<String, Set<AdmGrpFunperm>>(0) : (Map)new ObjectMapper().readValue(willDelFunpermMapStr, (TypeReference)new TypeReference<HashMap<String, Set<AdmGrpFunperm>>>(){});
            String willAddFunpermMapStr = variables.get("willAddFunpermMap");
            HashMap<String, Set<AdmGrpFunperm>> willAddFunpermMap = StringUtils.isEmpty((String)willAddFunpermMapStr) ? new HashMap<String, Set<AdmGrpFunperm>>(0) : (Map)new ObjectMapper().readValue(willAddFunpermMapStr, (TypeReference)new TypeReference<HashMap<String, Set<AdmGrpFunperm>>>(){});
            String willDelBizUnitMapStr = variables.get("willDelBizUnitMap");
            HashMap<String, Set<AdmGrpBizUnit>> willDelBizUnitMap = StringUtils.isEmpty((String)willDelBizUnitMapStr) ? new HashMap<String, Set<AdmGrpBizUnit>>(0) : (Map)new ObjectMapper().readValue(willDelBizUnitMapStr, (TypeReference)new TypeReference<HashMap<String, Set<AdmGrpBizUnit>>>(){});
            String willAddBizUnitMapStr = variables.get("willAddBizUnitMap");
            HashMap<String, Set<AdmGrpBizUnit>> willAddBizUnitMap = StringUtils.isEmpty((String)willAddBizUnitMapStr) ? new HashMap<String, Set<AdmGrpBizUnit>>(0) : (Map)new ObjectMapper().readValue(willAddBizUnitMapStr, (TypeReference)new TypeReference<HashMap<String, Set<AdmGrpBizUnit>>>(){});
            String willDelOrgMapStr = variables.get("willDelOrgMap");
            HashMap<String, Set<AdmGrpOrg>> willDelOrgMap = StringUtils.isEmpty((String)willDelOrgMapStr) ? new HashMap<String, Set<AdmGrpOrg>>(0) : (Map)new ObjectMapper().readValue(willDelOrgMapStr, (TypeReference)new TypeReference<HashMap<String, Set<AdmGrpOrg>>>(){});
            String willAddOrgMapStr = variables.get("willAddOrgMap");
            HashMap<String, Set<AdmGrpOrg>> willAddOrgMap = StringUtils.isEmpty((String)willAddOrgMapStr) ? new HashMap<String, Set<AdmGrpOrg>>(0) : (Map)new ObjectMapper().readValue(willAddOrgMapStr, (TypeReference)new TypeReference<HashMap<String, Set<AdmGrpOrg>>>(){});
            String willDelOrgAddUserMapStr = variables.get("willDelOrgAddUserMap");
            HashMap<String, Set<AdmGrpOrgAddUser>> willDelOrgAddUserMap = StringUtils.isEmpty((String)willDelOrgAddUserMapStr) ? new HashMap<String, Set<AdmGrpOrgAddUser>>(0) : (Map)new ObjectMapper().readValue(willDelOrgAddUserMapStr, (TypeReference)new TypeReference<HashMap<String, Set<AdmGrpOrgAddUser>>>(){});
            String willAddOrgAddUserMapStr = variables.get("willAddOrgAddUserMap");
            HashMap<String, Set<AdmGrpOrgAddUser>> willAddOrgAddUserMap = StringUtils.isEmpty((String)willAddOrgAddUserMapStr) ? new HashMap<String, Set<AdmGrpOrgAddUser>>(0) : (Map)new ObjectMapper().readValue(willAddOrgAddUserMapStr, (TypeReference)new TypeReference<HashMap<String, Set<AdmGrpOrgAddUser>>>(){});
            String willDelAppMapStr = variables.get("willDelAppMap");
            HashMap<String, Set<AdmGrpApp>> willDelAppMap = StringUtils.isEmpty((String)willDelAppMapStr) ? new HashMap<String, Set<AdmGrpApp>>(0) : (Map)new ObjectMapper().readValue(willDelAppMapStr, (TypeReference)new TypeReference<HashMap<String, Set<AdmGrpApp>>>(){});
            String willAddAppMapStr = variables.get("willAddAppMap");
            HashMap<String, Set<AdmGrpApp>> willAddAppMap = StringUtils.isEmpty((String)willAddAppMapStr) ? new HashMap<String, Set<AdmGrpApp>>(0) : (Map)new ObjectMapper().readValue(willAddAppMapStr, (TypeReference)new TypeReference<HashMap<String, Set<AdmGrpApp>>>(){});
            int adminLevelLimit = PermCommonUtil.getAdminLevelLimit();
            Long curEnableSchemeId = AdminSchemeHelper.getCurEnableSchemeId();
            Set canOperAdmGroupIdSet = AdminGroupService.getCanOperAdmGroupIdSet((Long)currUserId, (boolean)true, (String)"0");
            boolean curUserIsAdmin = PermissionServiceHelper.isAdminUser((long)currUserId);
            Set canSavePermAdmGroupIdSet = AdminGroupService.getCanOperAdmGroupIdSet((Long)currUserId, (boolean)false, (String)"0");
            AdminType adminType = PermissionServiceHelper.getAdminType((long)currUserId);
            GetBaseDataDynMapResp relatedBd = this.getRelatedBd(this.dataEntities, willAddFunpermMap, willAddBizUnitMap, willAddOrgMap, willAddOrgAddUserMap, willAddAppMap);
            Map entDynMap = relatedBd.getEntDynMap();
            Map permitemDynMap = relatedBd.getPermItemDynMap();
            Map orgDynMap = relatedBd.getOrgDynMap();
            Map userDynMap = relatedBd.getUserDynMap();
            for (ExtendedDataEntity extendedData : this.dataEntities) {
                try {
                    DynamicObject dyn = extendedData.getDataEntity();
                    if (null == dyn) {
                        this.addErrorMessage(extendedData, ResManager.loadKDString((String)"\u6570\u636e\u5305\u5185\u5bb9\u4e3a\u7a7a\u3002", (String)"AdmGrpSaveValidator_5", (String)"bos-permission-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    boolean fromDataBase = dyn.getDataEntityState().getFromDatabase();
                    PermResult checkRes = this.check((SaveCheckAdmGrpReq)PermBuilder.of(SaveCheckAdmGrpReq::new).with(SaveCheckAdmGrpReq::setAdmGrpFromDB, (Object)fromDataBase).with(SaveCheckAdmGrpReq::setCurAdmGrpDyn, (Object)dyn).with(SaveCheckAdmGrpReq::setAdminLevelLimit, (Object)adminLevelLimit).with(SaveCheckAdmGrpReq::setCurUserIsAdmin, (Object)curUserIsAdmin).with(SaveCheckAdmGrpReq::setCurEnableSchemeId, (Object)curEnableSchemeId).with(SaveCheckAdmGrpReq::setCanOperAdmGroupIdSet, (Object)canOperAdmGroupIdSet).build());
                    if (checkRes.getCode() != 0) {
                        this.addErrorMessage(extendedData, checkRes.getMsg());
                        continue;
                    }
                    DynamicObject curAdmGrpDyn = (DynamicObject)checkRes.getData();
                    extendedData.setDataEntity(curAdmGrpDyn);
                    String billNo = extendedData.getBillNo();
                    if (StringUtils.isEmpty((String)billNo)) continue;
                    this.checkDelAdmGrpFunperm(willDelFunpermMap, canSavePermAdmGroupIdSet, extendedData, billNo, curEnableSchemeId, curUserIsAdmin);
                    this.checkAddAdmGrpFunperm(willAddFunpermMap, canSavePermAdmGroupIdSet, adminType, entDynMap, permitemDynMap, extendedData, fromDataBase, billNo, curEnableSchemeId, curUserIsAdmin);
                    this.checkDelAdmGrpBizUnit(willDelBizUnitMap, canSavePermAdmGroupIdSet, extendedData, billNo, curEnableSchemeId, curUserIsAdmin);
                    this.checkAddAdmGrpBizUnit(willAddBizUnitMap, canSavePermAdmGroupIdSet, orgDynMap, extendedData, fromDataBase, billNo, curEnableSchemeId, curUserIsAdmin);
                    this.checkDelAdmGrpOrg(willDelOrgMap, canSavePermAdmGroupIdSet, extendedData, billNo, curEnableSchemeId, curUserIsAdmin);
                    this.checkAddAdmGrpOrg(willAddOrgMap, canSavePermAdmGroupIdSet, orgDynMap, extendedData, fromDataBase, billNo, curEnableSchemeId, curUserIsAdmin);
                    this.checkDelAdmGrpOrgAddUser(willDelOrgAddUserMap, canSavePermAdmGroupIdSet, extendedData, billNo, curEnableSchemeId, curUserIsAdmin);
                    this.checkAddAdmGrpOrgAddUser(willAddOrgAddUserMap, canSavePermAdmGroupIdSet, userDynMap, extendedData, fromDataBase, billNo, curEnableSchemeId, curUserIsAdmin);
                    this.checkDelAdmGrpApp(willDelAppMap, canSavePermAdmGroupIdSet, extendedData, billNo, curEnableSchemeId, curUserIsAdmin);
                    this.checkAddAdmGrpApp(willAddAppMap, canSavePermAdmGroupIdSet, extendedData, fromDataBase, billNo, curEnableSchemeId, curUserIsAdmin);
                }
                catch (Exception e) {
                    log.error("{}.{} error.", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), Thread.currentThread().getStackTrace()[1].getMethodName(), e});
                    this.addErrorMessage(extendedData, e.getMessage());
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a%1$s", (String)"RoleSaveOP_0", (String)"bos-permission-opplugin", (Object[])new Object[0]), e.getMessage()));
                }
            }
            this.getOption().setVariableValue("willDelFunpermMap", SerializationUtils.toJsonString(willDelFunpermMap));
            this.getOption().setVariableValue("willAddFunpermMap", SerializationUtils.toJsonString(willAddFunpermMap));
            this.getOption().setVariableValue("willDelBizUnitMap", SerializationUtils.toJsonString(willDelBizUnitMap));
            this.getOption().setVariableValue("willAddBizUnitMap", SerializationUtils.toJsonString(willAddBizUnitMap));
            this.getOption().setVariableValue("willDelOrgMap", SerializationUtils.toJsonString(willDelOrgMap));
            this.getOption().setVariableValue("willAddOrgMap", SerializationUtils.toJsonString(willAddOrgMap));
            this.getOption().setVariableValue("willDelOrgAddUserMap", SerializationUtils.toJsonString(willDelOrgAddUserMap));
            this.getOption().setVariableValue("willAddOrgAddUserMap", SerializationUtils.toJsonString(willAddOrgAddUserMap));
            this.getOption().setVariableValue("willDelAppMap", SerializationUtils.toJsonString(willDelAppMap));
            this.getOption().setVariableValue("willAddAppMap", SerializationUtils.toJsonString(willAddAppMap));
            this.getOption().setVariableValue("ALREADY_CHECKBUSIPARAM", "1");
        }
        catch (Exception e) {
            log.error("{}.{} error.", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), Thread.currentThread().getStackTrace()[1].getMethodName(), e});
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a%1$s", (String)"RoleSaveOP_0", (String)"bos-permission-opplugin", (Object[])new Object[0]), e.getMessage()));
        }
    }

    private void checkDelAdmGrpApp(Map<String, Set<AdmGrpApp>> willDelAppMap, Set<String> canSavePermAdmGroupIdSet, ExtendedDataEntity extendedData, String billNo, Long curEnableSchemeId, boolean curUserIsAdmin) {
        Set<AdmGrpApp> willDelSet = willDelAppMap.get(billNo);
        if (null == willDelSet || willDelSet.isEmpty()) {
            return;
        }
        DynamicObject curAdmGrpDyn = extendedData.getDataEntity();
        String curAdmGrpNum = curAdmGrpDyn.getString("number");
        for (AdmGrpApp one : willDelSet) {
            AdmGrpApp curAdmGrpApp = new AdmGrpApp(null, Long.valueOf(curAdmGrpDyn.getLong("id")), curAdmGrpNum, curAdmGrpDyn.getString("name"), one.getAppId(), null, null);
            curAdmGrpApp.setAdminScheme(Long.valueOf(curAdmGrpDyn.getLong("adminscheme_id")));
            PermResult check = AdmGrpAppDelValidator.check((DelCheckAdmGrpReq)PermBuilder.of(DelCheckAdmGrpReq::new).with(DelCheckAdmGrpReq::setCurAdmGrpApp, (Object)curAdmGrpApp).with(DelCheckAdmGrpReq::setCanOperAdmGroupIdSet, canSavePermAdmGroupIdSet).with(DelCheckAdmGrpReq::setCurUserIsAdmin, (Object)curUserIsAdmin).with(DelCheckAdmGrpReq::setCurEnableSchemeId, (Object)curEnableSchemeId).build());
            if (check.isOk()) continue;
            this.addErrorMessage(extendedData, check.getMsg());
        }
        if (!Objects.equals(billNo, curAdmGrpNum)) {
            willDelAppMap.remove(billNo);
        }
        willDelAppMap.put(curAdmGrpNum, willDelSet);
    }

    private void checkAddAdmGrpApp(Map<String, Set<AdmGrpApp>> willAddAppMap, Set<String> canSavePermAdmGroupIdSet, ExtendedDataEntity extendedData, boolean fromDataBase, String billNo, Long curEnableSchemeId, boolean curUserIsAdmin) {
        Set<AdmGrpApp> willAddSet = willAddAppMap.get(billNo);
        if (null == willAddSet || willAddSet.isEmpty()) {
            return;
        }
        DynamicObject curAdmGrpDyn = extendedData.getDataEntity();
        String curAdmGrpNum = curAdmGrpDyn.getString("number");
        Long parentId = AdmGrpSaveValidator.getParentId(curAdmGrpDyn);
        Map hasPermMap = AdmGrpAppService.getAssignableAdmGrpHasPerm((Set)Sets.newHashSet((Object[])new Long[]{parentId}));
        AdmGrpHasPermResp admGrpHasPermResp = (AdmGrpHasPermResp)hasPermMap.get(parentId);
        for (AdmGrpApp one : willAddSet) {
            PermResult check = AdmGrpAppSaveValidator.check((SaveCheckAdmGrpReq)PermBuilder.of(SaveCheckAdmGrpReq::new).with(SaveCheckAdmGrpReq::setAdmGrpFromDB, (Object)fromDataBase).with(SaveCheckAdmGrpReq::setCanOperAdmGroupIdSet, canSavePermAdmGroupIdSet).with(SaveCheckAdmGrpReq::setAdmGrpHasPermResp, (Object)admGrpHasPermResp).with(SaveCheckAdmGrpReq::setCurAdmGrpDyn, (Object)curAdmGrpDyn).with(SaveCheckAdmGrpReq::setCurAppId, (Object)one.getAppId()).with(SaveCheckAdmGrpReq::setCurUserIsAdmin, (Object)curUserIsAdmin).with(SaveCheckAdmGrpReq::setCurEnableSchemeId, (Object)curEnableSchemeId).build());
            if (check.isOk()) continue;
            this.addErrorMessage(extendedData, check.getMsg());
        }
        if (!Objects.equals(billNo, curAdmGrpNum)) {
            willAddAppMap.remove(billNo);
        }
        willAddAppMap.put(curAdmGrpNum, willAddSet);
    }

    private void checkDelAdmGrpOrgAddUser(Map<String, Set<AdmGrpOrgAddUser>> willDelOrgAddUserMap, Set<String> canSavePermAdmGroupIdSet, ExtendedDataEntity extendedData, String billNo, Long curEnableSchemeId, boolean curUserIsAdmin) {
        Set<AdmGrpOrgAddUser> willDelSet = willDelOrgAddUserMap.get(billNo);
        if (null == willDelSet || willDelSet.isEmpty()) {
            return;
        }
        DynamicObject curAdmGrpDyn = extendedData.getDataEntity();
        String curAdmGrpNum = curAdmGrpDyn.getString("number");
        for (AdmGrpOrgAddUser one : willDelSet) {
            AdmGrpOrgAddUser curAdmGrpOrgAddUser = new AdmGrpOrgAddUser(null, Long.valueOf(curAdmGrpDyn.getLong("id")), curAdmGrpNum, curAdmGrpDyn.getString("name"), one.getUserId(), null, null, null);
            curAdmGrpOrgAddUser.setAdminScheme(Long.valueOf(curAdmGrpDyn.getLong("adminscheme_id")));
            PermResult check = AdmGrpOrgAddUserDelValidator.check((DelCheckAdmGrpReq)PermBuilder.of(DelCheckAdmGrpReq::new).with(DelCheckAdmGrpReq::setCurAdmGrpOrgAddUser, (Object)curAdmGrpOrgAddUser).with(DelCheckAdmGrpReq::setCanOperAdmGroupIdSet, canSavePermAdmGroupIdSet).with(DelCheckAdmGrpReq::setCurUserIsAdmin, (Object)curUserIsAdmin).with(DelCheckAdmGrpReq::setCurEnableSchemeId, (Object)curEnableSchemeId).build());
            if (check.isOk()) continue;
            this.addErrorMessage(extendedData, check.getMsg());
        }
        if (!Objects.equals(billNo, curAdmGrpNum)) {
            willDelOrgAddUserMap.remove(billNo);
        }
        willDelOrgAddUserMap.put(curAdmGrpNum, willDelSet);
    }

    private void checkAddAdmGrpOrgAddUser(Map<String, Set<AdmGrpOrgAddUser>> willAddOrgAddUserMap, Set<String> canSavePermAdmGroupIdSet, Map<Object, DynamicObject> userDynMap, ExtendedDataEntity extendedData, boolean fromDataBase, String billNo, Long curEnableSchemeId, boolean curUserIsAdmin) {
        Set<AdmGrpOrgAddUser> willAddSet = willAddOrgAddUserMap.get(billNo);
        if (null == willAddSet || willAddSet.isEmpty()) {
            return;
        }
        DynamicObject curAdmGrpDyn = extendedData.getDataEntity();
        String curAdmGrpNum = curAdmGrpDyn.getString("number");
        Map orgAddUserAssignedMap = AdmGrpOrgAddUserService.getAdmGrpUserIdSetMap((Set)Sets.newHashSet((Object[])new String[]{curAdmGrpNum}));
        for (AdmGrpOrgAddUser one : willAddSet) {
            PermResult check = AdmGrpOrgAddUserSaveValidator.check((SaveCheckAdmGrpReq)PermBuilder.of(SaveCheckAdmGrpReq::new).with(SaveCheckAdmGrpReq::setAdmGrpFromDB, (Object)fromDataBase).with(SaveCheckAdmGrpReq::setCanOperAdmGroupIdSet, canSavePermAdmGroupIdSet).with(SaveCheckAdmGrpReq::setCurAdmGrpDyn, (Object)curAdmGrpDyn).with(SaveCheckAdmGrpReq::setUserDynMap, userDynMap).with(SaveCheckAdmGrpReq::setCurUserId, (Object)one.getUserId()).with(SaveCheckAdmGrpReq::setCurUserIsAdmin, (Object)curUserIsAdmin).with(SaveCheckAdmGrpReq::setCurEnableSchemeId, (Object)curEnableSchemeId).with(SaveCheckAdmGrpReq::setOrgAddUserAssignedMap, (Object)orgAddUserAssignedMap).build());
            if (check.isOk()) continue;
            this.addErrorMessage(extendedData, check.getMsg());
        }
        if (!Objects.equals(billNo, curAdmGrpNum)) {
            willAddOrgAddUserMap.remove(billNo);
        }
        willAddOrgAddUserMap.put(curAdmGrpNum, willAddSet);
    }

    private void checkDelAdmGrpOrg(Map<String, Set<AdmGrpOrg>> willDelOrgMap, Set<String> canSavePermAdmGroupIdSet, ExtendedDataEntity extendedData, String billNo, Long curEnableSchemeId, boolean curUserIsAdmin) {
        Set<AdmGrpOrg> willDelSet = willDelOrgMap.get(billNo);
        if (null == willDelSet || willDelSet.isEmpty()) {
            return;
        }
        DynamicObject curAdmGrpDyn = extendedData.getDataEntity();
        String curAdmGrpNum = curAdmGrpDyn.getString("number");
        for (AdmGrpOrg one : willDelSet) {
            AdmGrpOrg curAdmGrpOrg = new AdmGrpOrg(null, Long.valueOf(curAdmGrpDyn.getLong("id")), curAdmGrpNum, curAdmGrpDyn.getString("name"), one.getOrgId(), null, null, null, false);
            curAdmGrpOrg.setAdminScheme(Long.valueOf(curAdmGrpDyn.getLong("adminscheme_id")));
            PermResult check = AdmGrpOrgDelValidator.check((DelCheckAdmGrpReq)PermBuilder.of(DelCheckAdmGrpReq::new).with(DelCheckAdmGrpReq::setCurAdmGrpOrg, (Object)curAdmGrpOrg).with(DelCheckAdmGrpReq::setCanOperAdmGroupIdSet, canSavePermAdmGroupIdSet).with(DelCheckAdmGrpReq::setCurUserIsAdmin, (Object)curUserIsAdmin).with(DelCheckAdmGrpReq::setCurEnableSchemeId, (Object)curEnableSchemeId).build());
            if (check.isOk()) continue;
            this.addErrorMessage(extendedData, check.getMsg());
        }
        if (!Objects.equals(billNo, curAdmGrpNum)) {
            willDelOrgMap.remove(billNo);
        }
        willDelOrgMap.put(curAdmGrpNum, willDelSet);
    }

    private void checkAddAdmGrpOrg(Map<String, Set<AdmGrpOrg>> willAddOrgMap, Set<String> canSavePermAdmGroupIdSet, Map<Object, DynamicObject> orgDynMap, ExtendedDataEntity extendedData, boolean fromDataBase, String billNo, Long curEnableSchemeId, boolean curUserIsAdmin) {
        Set<AdmGrpOrg> willAddSet = willAddOrgMap.get(billNo);
        if (null == willAddSet || willAddSet.isEmpty()) {
            return;
        }
        DynamicObject curAdmGrpDyn = extendedData.getDataEntity();
        String curAdmGrpNum = curAdmGrpDyn.getString("number");
        Long parentId = AdmGrpSaveValidator.getParentId(curAdmGrpDyn);
        Map hasPermMap = AdmGrpOrgService.getAssignableAdmGrpHasPerm((Set)Sets.newHashSet((Object[])new Long[]{parentId}));
        AdmGrpHasPermResp admGrpHasPermResp = (AdmGrpHasPermResp)hasPermMap.get(parentId);
        for (AdmGrpOrg one : willAddSet) {
            PermResult check = AdmGrpOrgSaveValidator.check((SaveCheckAdmGrpReq)PermBuilder.of(SaveCheckAdmGrpReq::new).with(SaveCheckAdmGrpReq::setAdmGrpFromDB, (Object)fromDataBase).with(SaveCheckAdmGrpReq::setCanOperAdmGroupIdSet, canSavePermAdmGroupIdSet).with(SaveCheckAdmGrpReq::setAdmGrpHasPermResp, (Object)admGrpHasPermResp).with(SaveCheckAdmGrpReq::setCurAdmGrpDyn, (Object)curAdmGrpDyn).with(SaveCheckAdmGrpReq::setOrgDynMap, orgDynMap).with(SaveCheckAdmGrpReq::setCurOrgId, (Object)one.getOrgId()).with(SaveCheckAdmGrpReq::setCurUserIsAdmin, (Object)curUserIsAdmin).with(SaveCheckAdmGrpReq::setCurEnableSchemeId, (Object)curEnableSchemeId).build());
            if (check.isOk()) continue;
            this.addErrorMessage(extendedData, check.getMsg());
        }
        if (!Objects.equals(billNo, curAdmGrpNum)) {
            willAddOrgMap.remove(billNo);
        }
        willAddOrgMap.put(curAdmGrpNum, willAddSet);
    }

    private void checkDelAdmGrpBizUnit(Map<String, Set<AdmGrpBizUnit>> willDelBizUnitMap, Set<String> canSavePermAdmGroupIdSet, ExtendedDataEntity extendedData, String billNo, Long curEnableSchemeId, boolean curUserIsAdmin) {
        Set<AdmGrpBizUnit> willDelSet = willDelBizUnitMap.get(billNo);
        if (null == willDelSet || willDelSet.isEmpty()) {
            return;
        }
        DynamicObject curAdmGrpDyn = extendedData.getDataEntity();
        String curAdmGrpNum = curAdmGrpDyn.getString("number");
        for (AdmGrpBizUnit one : willDelSet) {
            AdmGrpBizUnit curAdmGrpBizUnit = new AdmGrpBizUnit(null, Long.valueOf(curAdmGrpDyn.getLong("id")), curAdmGrpNum, curAdmGrpDyn.getString("name"), one.getOrgId(), null, null, null, false);
            curAdmGrpBizUnit.setAdminScheme(Long.valueOf(curAdmGrpDyn.getLong("adminscheme_id")));
            PermResult check = AdmGrpBizUnitDelValidator.check((DelCheckAdmGrpReq)PermBuilder.of(DelCheckAdmGrpReq::new).with(DelCheckAdmGrpReq::setCurAdmGrpBizUnit, (Object)curAdmGrpBizUnit).with(DelCheckAdmGrpReq::setCanOperAdmGroupIdSet, canSavePermAdmGroupIdSet).with(DelCheckAdmGrpReq::setCurUserIsAdmin, (Object)curUserIsAdmin).with(DelCheckAdmGrpReq::setCurEnableSchemeId, (Object)curEnableSchemeId).build());
            if (check.isOk()) continue;
            this.addErrorMessage(extendedData, check.getMsg());
        }
        if (!Objects.equals(billNo, curAdmGrpNum)) {
            willDelBizUnitMap.remove(billNo);
        }
        willDelBizUnitMap.put(curAdmGrpNum, willDelSet);
    }

    private void checkAddAdmGrpBizUnit(Map<String, Set<AdmGrpBizUnit>> willAddBizUnitMap, Set<String> canSavePermAdmGroupIdSet, Map<Object, DynamicObject> orgDynMap, ExtendedDataEntity extendedData, boolean fromDataBase, String billNo, Long curEnableSchemeId, boolean curUserIsAdmin) {
        Set<AdmGrpBizUnit> willAddSet = willAddBizUnitMap.get(billNo);
        if (null == willAddSet || willAddSet.isEmpty()) {
            return;
        }
        DynamicObject curAdmGrpDyn = extendedData.getDataEntity();
        String curAdmGrpNum = curAdmGrpDyn.getString("number");
        Long parentId = AdmGrpSaveValidator.getParentId(curAdmGrpDyn);
        Map hasPermMap = AdmGrpBizUnitService.getAssignableAdmGrpHasPerm((Set)Sets.newHashSet((Object[])new Long[]{parentId}));
        AdmGrpHasPermResp admGrpHasPermResp = (AdmGrpHasPermResp)hasPermMap.get(parentId);
        for (AdmGrpBizUnit one : willAddSet) {
            PermResult check = AdmGrpBizUnitSaveValidator.check((SaveCheckAdmGrpReq)PermBuilder.of(SaveCheckAdmGrpReq::new).with(SaveCheckAdmGrpReq::setAdmGrpFromDB, (Object)fromDataBase).with(SaveCheckAdmGrpReq::setCanOperAdmGroupIdSet, canSavePermAdmGroupIdSet).with(SaveCheckAdmGrpReq::setAdmGrpHasPermResp, (Object)admGrpHasPermResp).with(SaveCheckAdmGrpReq::setCurAdmGrpDyn, (Object)curAdmGrpDyn).with(SaveCheckAdmGrpReq::setOrgDynMap, orgDynMap).with(SaveCheckAdmGrpReq::setCurOrgId, (Object)one.getOrgId()).with(SaveCheckAdmGrpReq::setCurUserIsAdmin, (Object)curUserIsAdmin).with(SaveCheckAdmGrpReq::setCurEnableSchemeId, (Object)curEnableSchemeId).build());
            if (check.isOk()) continue;
            this.addErrorMessage(extendedData, check.getMsg());
        }
        if (!Objects.equals(billNo, curAdmGrpNum)) {
            willAddBizUnitMap.remove(billNo);
        }
        willAddBizUnitMap.put(curAdmGrpNum, willAddSet);
    }

    private void checkDelAdmGrpFunperm(Map<String, Set<AdmGrpFunperm>> willDelFunpermMap, Set<String> canSavePermAdmGroupIdSet, ExtendedDataEntity extendedData, String billNo, Long curEnableSchemeId, boolean curUserIsAdmin) {
        Set<AdmGrpFunperm> willDelSet = willDelFunpermMap.get(billNo);
        if (null == willDelSet || willDelSet.isEmpty()) {
            return;
        }
        DynamicObject curAdmGrpDyn = extendedData.getDataEntity();
        String curAdmGrpNum = curAdmGrpDyn.getString("number");
        for (AdmGrpFunperm one : willDelSet) {
            AdmGrpFunperm curAdmGrpFunperm = new AdmGrpFunperm(null, Long.valueOf(curAdmGrpDyn.getLong("id")), curAdmGrpNum, curAdmGrpDyn.getString("name"), one.getAppId(), null, null, one.getEntNum(), null, one.getPermItemId(), null, null);
            curAdmGrpFunperm.setAdminScheme(Long.valueOf(curAdmGrpDyn.getLong("adminscheme_id")));
            PermResult check = AdmGrpFunpermDelValidator.check((DelCheckAdmGrpReq)PermBuilder.of(DelCheckAdmGrpReq::new).with(DelCheckAdmGrpReq::setCurAdmGrpFunperm, (Object)curAdmGrpFunperm).with(DelCheckAdmGrpReq::setCanOperAdmGroupIdSet, canSavePermAdmGroupIdSet).with(DelCheckAdmGrpReq::setCurUserIsAdmin, (Object)curUserIsAdmin).with(DelCheckAdmGrpReq::setCurEnableSchemeId, (Object)curEnableSchemeId).build());
            if (check.isOk()) continue;
            this.addErrorMessage(extendedData, check.getMsg());
        }
        if (!Objects.equals(billNo, curAdmGrpNum)) {
            willDelFunpermMap.remove(billNo);
        }
        willDelFunpermMap.put(curAdmGrpNum, willDelSet);
    }

    private void checkAddAdmGrpFunperm(Map<String, Set<AdmGrpFunperm>> willAddFunpermMap, Set<String> canSavePermAdmGroupIdSet, AdminType adminType, Map<Object, DynamicObject> entDynMap, Map<Object, DynamicObject> permitemDynMap, ExtendedDataEntity extendedData, boolean fromDataBase, String billNo, Long curEnableSchemeId, boolean curUserIsAdmin) {
        Set<AdmGrpFunperm> willAddSet = willAddFunpermMap.get(billNo);
        if (null == willAddSet || willAddSet.isEmpty()) {
            return;
        }
        DynamicObject curAdmGrpDyn = extendedData.getDataEntity();
        String curAdmGrpNum = curAdmGrpDyn.getString("number");
        Long parentId = AdmGrpSaveValidator.getParentId(curAdmGrpDyn);
        AdmGrpHasPermResp admGrpHasPermResp = AdmGrpFunpermService.getAssignableAdmGrpHasPerm((DynamicObject)curAdmGrpDyn, (Long)parentId, (AdminType)adminType, (boolean)false);
        for (AdmGrpFunperm one : willAddSet) {
            PermResult check = AdmGrpFunpermSaveValidator.check((SaveCheckAdmGrpReq)PermBuilder.of(SaveCheckAdmGrpReq::new).with(SaveCheckAdmGrpReq::setAdmGrpFromDB, (Object)fromDataBase).with(SaveCheckAdmGrpReq::setCanOperAdmGroupIdSet, canSavePermAdmGroupIdSet).with(SaveCheckAdmGrpReq::setAdmGrpHasPermResp, (Object)admGrpHasPermResp).with(SaveCheckAdmGrpReq::setCurAdmGrpDyn, (Object)curAdmGrpDyn).with(SaveCheckAdmGrpReq::setEntDynMap, entDynMap).with(SaveCheckAdmGrpReq::setPermitemDynMap, permitemDynMap).with(SaveCheckAdmGrpReq::setCurAppId, (Object)one.getAppId()).with(SaveCheckAdmGrpReq::setCurEntNum, (Object)one.getEntNum()).with(SaveCheckAdmGrpReq::setCurPermItemId, (Object)one.getPermItemId()).with(SaveCheckAdmGrpReq::setCurUserIsAdmin, (Object)curUserIsAdmin).with(SaveCheckAdmGrpReq::setCurEnableSchemeId, (Object)curEnableSchemeId).build());
            if (check.isOk()) continue;
            this.addErrorMessage(extendedData, check.getMsg());
        }
        if (!Objects.equals(billNo, curAdmGrpNum)) {
            willAddFunpermMap.remove(billNo);
        }
        willAddFunpermMap.put(curAdmGrpNum, willAddSet);
    }

    private GetBaseDataDynMapResp getRelatedBd(ExtendedDataEntity[] dataEntities, Map<String, Set<AdmGrpFunperm>> willAddFunpermMap, Map<String, Set<AdmGrpBizUnit>> willAddBizUnitMap, Map<String, Set<AdmGrpOrg>> willAddOrgMap, Map<String, Set<AdmGrpOrgAddUser>> willAddOrgAddUserMap, Map<String, Set<AdmGrpApp>> willAddAppMap) {
        HashSet<Long> admGrpIdSet = new HashSet<Long>(8);
        HashSet<String> appIdSet = new HashSet<String>(8);
        HashSet<String> funperm_entNumSet = new HashSet<String>(8);
        HashSet<String> funperm_permItemIdSet = new HashSet<String>(8);
        HashSet<Long> bizunitAndOrg_orgIdSet = new HashSet<Long>(8);
        HashSet<Long> userIdSet = new HashSet<Long>(8);
        for (ExtendedDataEntity extendedData : dataEntities) {
            Set<AdmGrpApp> set;
            Set<AdmGrpOrgAddUser> orgAddUserSet;
            Set<AdmGrpOrg> set2;
            Set<AdmGrpBizUnit> bizUnitSet;
            Set<AdmGrpFunperm> admGrpFunpermSet;
            String billNo;
            DynamicObject dyn = extendedData.getDataEntity();
            if (null == dyn || StringUtils.isEmpty((String)(billNo = extendedData.getBillNo()))) continue;
            Object billPkId = extendedData.getBillPkId();
            if (null != billPkId) {
                admGrpIdSet.add((Long)billPkId);
            }
            if (null != (admGrpFunpermSet = willAddFunpermMap.get(billNo)) && !admGrpFunpermSet.isEmpty()) {
                for (AdmGrpFunperm admGrpFunperm : admGrpFunpermSet) {
                    appIdSet.add(admGrpFunperm.getAppId());
                    funperm_entNumSet.add(admGrpFunperm.getEntNum());
                    funperm_permItemIdSet.add(admGrpFunperm.getPermItemId());
                }
            }
            if (null != (bizUnitSet = willAddBizUnitMap.get(billNo)) && !bizUnitSet.isEmpty()) {
                for (Object admGrpBizUnit : bizUnitSet) {
                    bizunitAndOrg_orgIdSet.add(admGrpBizUnit.getOrgId());
                }
            }
            if (null != (set2 = willAddOrgMap.get(billNo)) && !set2.isEmpty()) {
                Object admGrpBizUnit;
                admGrpBizUnit = set2.iterator();
                while (admGrpBizUnit.hasNext()) {
                    AdmGrpOrg admGrpOrg = (AdmGrpOrg)admGrpBizUnit.next();
                    bizunitAndOrg_orgIdSet.add(admGrpOrg.getOrgId());
                }
            }
            if (null != (orgAddUserSet = willAddOrgAddUserMap.get(billNo)) && !orgAddUserSet.isEmpty()) {
                for (AdmGrpOrgAddUser admGrpOrgAddUser : orgAddUserSet) {
                    userIdSet.add(admGrpOrgAddUser.getUserId());
                }
            }
            if (null == (set = willAddAppMap.get(billNo)) || set.isEmpty()) continue;
            for (AdmGrpApp admGrpApp : set) {
                appIdSet.add(admGrpApp.getAppId());
            }
        }
        GetBaseDataDynMapReq baseDataDynMapReq = (GetBaseDataDynMapReq)PermBuilder.of(GetBaseDataDynMapReq::new).with(GetBaseDataDynMapReq::setAdmGrpIdSet, admGrpIdSet).with(GetBaseDataDynMapReq::setAppIdSet, appIdSet).with(GetBaseDataDynMapReq::setEntNumSet, funperm_entNumSet).with(GetBaseDataDynMapReq::setPermItemIdSet, funperm_permItemIdSet).with(GetBaseDataDynMapReq::setOrgIdSet, bizunitAndOrg_orgIdSet).with(GetBaseDataDynMapReq::setUserIdSet, userIdSet).build();
        GetBaseDataDynMapResp baseDataDynMapResp = PermCommonUtil.getBaseDataDynMap((GetBaseDataDynMapReq)baseDataDynMapReq);
        return baseDataDynMapResp;
    }

    private PermResult check(SaveCheckAdmGrpReq req) {
        boolean parentIsDomain;
        boolean curUserIsAdmin = req.isCurUserIsAdmin();
        if (!curUserIsAdmin) {
            return PermResult.fail((String)ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u4e0d\u662f\u7ba1\u7406\u5458\u3002", (String)"AdmGrpSaveValidator_1", (String)"bos-permission-opplugin", (Object[])new Object[0]));
        }
        DynamicObject dyn = req.getCurAdmGrpDyn();
        if (null == dyn) {
            return PermResult.fail((String)ResManager.loadKDString((String)"\u6570\u636e\u5305\u5185\u5bb9\u4e3a\u7a7a\u3002", (String)"AdmGrpSaveValidator_5", (String)"bos-permission-opplugin", (Object[])new Object[0]));
        }
        boolean fromDataBase = req.isAdmGrpFromDB();
        Long adminGroupId = fromDataBase ? dyn.getLong("id") : AdmGrpSaveValidator.getParentId(dyn).longValue();
        DynamicObject adminGroup = BusinessDataServiceHelper.loadSingleFromCache((Object)adminGroupId, (String)"perm_admingroup");
        if (adminGroup == null) {
            return PermResult.fail((String)ResManager.loadKDString((String)"\u8be5\u7ba1\u7406\u5458\u7ec4\u4e0d\u5b58\u5728\u3002", (String)"AdmGrpSaveValidator_2", (String)"bos-permission-opplugin", (Object[])new Object[0]));
        }
        long curGroupAdminSchemeId = adminGroup.getLong("adminscheme.id");
        Long curEnableSchemeId = req.getCurEnableSchemeId();
        if (curEnableSchemeId != curGroupAdminSchemeId) {
            return PermResult.fail((String)String.format(ResManager.loadKDString((String)"\u8be5\u7ba1\u7406\u5458\u7ec4\u201c%1$s\u201d\u4e0d\u5c5e\u4e8e\u5f53\u524d\u865a\u62df\u7ba1\u7406\u5458\u63a7\u5236\u7b56\u7565\u3002", (String)"AdmGrpSaveValidator_3", (String)"bos-permission-opplugin", (Object[])new Object[0]), adminGroup.getString("name")));
        }
        Set canOperAdmGroupIdSet = req.getCanOperAdmGroupIdSet();
        if (CollectionUtils.isEmpty((Collection)canOperAdmGroupIdSet)) {
            return PermResult.fail((String)String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5206\u7ec4\u201c%1$s\u201d\u4e0d\u5728\u60a8\u7684\u63a7\u5236\u8303\u56f4\u5185\uff0c\u60a8\u65e0\u6743\u8fdb\u884c\u65b0\u589e\u5220\u9664\u7b49\u64cd\u4f5c\u3002", (String)"UserAdmGrpSaveValidator_0", (String)"bos-permission-opplugin", (Object[])new Object[0]), adminGroup.getString("name")));
        }
        if (!canOperAdmGroupIdSet.contains(String.valueOf(adminGroupId))) {
            return PermResult.fail((String)String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5206\u7ec4\u201c%1$s\u201d\u4e0d\u5728\u60a8\u7684\u63a7\u5236\u8303\u56f4\u5185\uff0c\u60a8\u65e0\u6743\u8fdb\u884c\u65b0\u589e\u5220\u9664\u7b49\u64cd\u4f5c\u3002", (String)"UserAdmGrpSaveValidator_0", (String)"bos-permission-opplugin", (Object[])new Object[0]), adminGroup.getString("name")));
        }
        String name = dyn.getString("name");
        String number = dyn.getString("number");
        if (!fromDataBase && (StringUtils.isEmpty((String)name) || StringUtils.isEmpty((String)number))) {
            return PermResult.fail((String)String.format(ResManager.loadKDString((String)"\u65b0\u589e\u7ba1\u7406\u5458\u5206\u7ec4\u7f16\u7801\u6216\u540d\u79f0\u7f3a\u5931[number=%1$s, name=%2$s]\u3002", (String)"AdmGrpSaveValidator_4", (String)"bos-permission-opplugin", (Object[])new Object[0]), number, name));
        }
        if (fromDataBase) {
            boolean isDomain;
            boolean parentIsDomain2;
            String description;
            if (StringUtils.isNotEmpty((String)name)) {
                OrmLocaleValue reqNameOLV = (OrmLocaleValue)dyn.get("name");
                adminGroup.set("name", (Object)reqNameOLV);
            }
            if (StringUtils.isNotEmpty((String)(description = dyn.getString("description")))) {
                OrmLocaleValue reqDescOLV = (OrmLocaleValue)dyn.get("description");
                adminGroup.set("description", (Object)reqDescOLV);
            }
            if (!(parentIsDomain2 = adminGroup.getBoolean("parent.isdomain")) && (isDomain = dyn.getBoolean("isdomain"))) {
                adminGroup.set("isdomain", (Object)true);
                Long domainId = AdmGrpSaveValidator.getDomainId(dyn);
                adminGroup.set("domain", (Object)domainId);
            }
            return PermResult.ok((Object)adminGroup);
        }
        int adminLevelLimit = req.getAdminLevelLimit();
        int level = dyn.getInt("level");
        if (level > adminLevelLimit) {
            return PermResult.fail((String)String.format(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u521b\u5efa%s\u7ea7\u7ba1\u7406\u5458\u3002", (String)"AdmGrpSaveValidator_0", (String)"bos-permission-opplugin", (Object[])new Object[0]), adminLevelLimit));
        }
        DynamicObject parentAdminGroup = adminGroup;
        String parentLongNumber = parentAdminGroup.getString("longnumber");
        Long parentLevel = parentAdminGroup.getLong("level");
        Long adminSchemeId = parentAdminGroup.getLong("adminscheme.id");
        Long adminTypeId = parentAdminGroup.getLong("admintype.id");
        if (StringUtils.isNotEmpty((String)name) && StringUtils.isNotEmpty((String)number)) {
            dyn.set("longnumber", (Object)(parentLongNumber + "." + number));
        }
        if (!(parentIsDomain = parentAdminGroup.getBoolean("parent.isdomain"))) {
            boolean isDomain = dyn.getBoolean("isdomain");
            if (isDomain) {
                dyn.set("isdomain", (Object)true);
                Long domainId = AdmGrpSaveValidator.getDomainId(dyn);
                dyn.set("domain", (Object)domainId);
            }
        } else {
            Long parentDomainId = parentAdminGroup.getLong("parent.domain.id");
            dyn.set("isdomain", (Object)true);
            dyn.set("domain", (Object)parentDomainId);
        }
        dyn.set("isleaf", (Object)true);
        dyn.set("level", (Object)(parentLevel + 1L));
        dyn.set("status", (Object)"C");
        dyn.set("adminscheme", (Object)adminSchemeId);
        dyn.set("admintype", (Object)adminTypeId);
        dyn.set("enable", (Object)"1");
        dyn.set("masterid", (Object)dyn.getLong("id"));
        return PermResult.ok((Object)dyn);
    }

    public static Long getParentId(DynamicObject curAdmGrpDyn) {
        if (null == curAdmGrpDyn) {
            return 0L;
        }
        Object IdObj = curAdmGrpDyn.get("parent_id");
        if (null != IdObj && IdObj instanceof Long && (Long)IdObj > 0L) {
            return (Long)IdObj;
        }
        Object dynObj = curAdmGrpDyn.get("parent");
        if (null != dynObj) {
            if (dynObj instanceof Long && (Long)dynObj > 0L) {
                return (Long)dynObj;
            }
            if (dynObj instanceof DynamicObject) {
                return ((DynamicObject)dynObj).getLong("id");
            }
        }
        return 0L;
    }

    public static Long getAdminschemeId(DynamicObject curAdmGrpDyn) {
        if (null == curAdmGrpDyn) {
            return 0L;
        }
        Object IdObj = curAdmGrpDyn.get("adminscheme_id");
        if (null != IdObj && IdObj instanceof Long && (Long)IdObj > 0L) {
            return (Long)IdObj;
        }
        Object dynObj = curAdmGrpDyn.get("adminscheme");
        if (null != dynObj) {
            if (dynObj instanceof Long && (Long)dynObj > 0L) {
                return (Long)dynObj;
            }
            if (dynObj instanceof DynamicObject) {
                return ((DynamicObject)dynObj).getLong("id");
            }
        }
        return 0L;
    }

    private static Long getDomainId(DynamicObject curAdmGrpDyn) {
        if (null == curAdmGrpDyn) {
            return 0L;
        }
        Object IdObj = curAdmGrpDyn.get("domain_id");
        if (null != IdObj && IdObj instanceof Long && (Long)IdObj > 0L) {
            return (Long)IdObj;
        }
        Object dynObj = curAdmGrpDyn.get("domain");
        if (null != dynObj) {
            if (dynObj instanceof Long && (Long)dynObj > 0L) {
                return (Long)dynObj;
            }
            if (dynObj instanceof DynamicObject) {
                return ((DynamicObject)dynObj).getLong("id");
            }
        }
        return 0L;
    }
}

