/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.opplugin.validator.save.admingroup;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.permission.cache.helper.AdminSchemeHelper;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.model.PermResult;
import kd.bos.permission.model.perm.AdmGroup;
import kd.bos.permission.model.perm.PermBuilder;
import kd.bos.permission.model.perm.admingroup.AdmGrp;
import kd.bos.permission.model.perm.req.admin.savecheck.SaveCheckUserAdmGrpReq;
import kd.bos.permission.model.perm.req.common.GetBaseDataDynMapReq;
import kd.bos.permission.model.perm.resp.common.GetBaseDataDynMapResp;
import kd.bos.permission.model.perm.user.PermUser;
import kd.bos.permission.opplugin.validator.save.admingroup.AdmGrpSaveValidator;
import kd.bos.permission.service.AdminGroupService;
import kd.bos.permission.service.admingroup.UserAdmGrpService;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class UserAdmGrpSaveValidator
extends AbstractValidator {
    private static final Log log = LogFactory.getLog(UserAdmGrpSaveValidator.class);

    private Map<String, String> getOptionVariables() {
        Map variables = this.getOption().getVariables();
        variables = null == variables ? new HashMap(8) : variables;
        return variables;
    }

    public void validate() {
        Map<String, String> optionVariables = this.getOptionVariables();
        String alreadyCheckBusiParam = optionVariables.get("ALREADY_CHECKBUSIPARAM");
        if (!StringUtils.isEmpty((Object)alreadyCheckBusiParam) && Objects.equals("1", alreadyCheckBusiParam)) {
            return;
        }
        long currUserId = RequestContext.get().getCurrUserId();
        boolean curUserIsAdmin = PermissionServiceHelper.isAdminUser((long)currUserId);
        Long curEnableSchemeId = AdminSchemeHelper.getCurEnableSchemeId();
        Set canSavePermAdmGroupIdSet = AdminGroupService.getCanOperAdmGroupIdSet((Long)currUserId, (boolean)false, (String)optionVariables.get("canSavePermAdmGroupIdSet_useThreadCache"));
        HashSet admGrpIdSet = new HashSet(8);
        HashSet userIdSet = new HashSet(8);
        Arrays.stream(this.dataEntities).forEach(extendedData -> {
            Object userIdObj;
            Object grpIdObj = extendedData.getValue("usergroup_id");
            if (null != grpIdObj) {
                admGrpIdSet.add((Long)grpIdObj);
            }
            if (null != (userIdObj = extendedData.getValue("user_id"))) {
                userIdSet.add((Long)userIdObj);
            }
        });
        Map admGrpAddUserF7Map = UserAdmGrpService.getAdmGrpAddUserF7Map(admGrpIdSet);
        GetBaseDataDynMapResp baseDataDynMap = PermCommonUtil.getBaseDataDynMap((GetBaseDataDynMapReq)((GetBaseDataDynMapReq)PermBuilder.of(GetBaseDataDynMapReq::new).with(GetBaseDataDynMapReq::setAdmGrpIdSet, admGrpIdSet).with(GetBaseDataDynMapReq::setUserIdSet, userIdSet).build()));
        Map admGrpDynMap = baseDataDynMap.getAdmGrpDynMap();
        Map userDynMap = baseDataDynMap.getUserDynMap();
        StringBuilder errorInfo = new StringBuilder();
        for (ExtendedDataEntity extendedData2 : this.dataEntities) {
            try {
                Object grpIdObj = extendedData2.getValue("usergroup_id");
                if (null == grpIdObj) {
                    String info = ResManager.loadKDString((String)"\u7ba1\u7406\u5458\u7ec4\u4e0d\u5b58\u5728\u3002", (String)"AdmGrpFunpermSaveValidator_0", (String)"bos-permission-opplugin", (Object[])new Object[0]);
                    this.appendErrorInfo(errorInfo, extendedData2, info);
                    return;
                }
                Long adminGroupId = (Long)grpIdObj;
                DynamicObject admGrpDyn = (DynamicObject)admGrpDynMap.get(adminGroupId);
                if (null == admGrpDyn) {
                    String info = ResManager.loadKDString((String)"\u7ba1\u7406\u5458\u7ec4\u4e0d\u5b58\u5728\u3002", (String)"AdmGrpFunpermSaveValidator_0", (String)"bos-permission-opplugin", (Object[])new Object[0]);
                    this.appendErrorInfo(errorInfo, extendedData2, info);
                    return;
                }
                Object userIdObj = extendedData2.getValue("user_id");
                if (null == userIdObj) {
                    String info = ResManager.loadKDString((String)"\u7528\u6237\u4e0d\u5b58\u5728\u3002", (String)"UserAdmGrpSaveValidator_1", (String)"bos-permission-opplugin", (Object[])new Object[0]);
                    this.appendErrorInfo(errorInfo, extendedData2, info);
                    return;
                }
                Long userId = (Long)userIdObj;
                AdmGrp curAdmGrp = (AdmGrp)PermBuilder.of(AdmGrp::new).with(AdmGroup::setId, (Object)adminGroupId).with(AdmGroup::setName, (Object)admGrpDyn.getString("name")).with(AdmGroup::setNumber, (Object)admGrpDyn.getString("number")).with(AdmGroup::setAdminScheme, (Object)AdmGrpSaveValidator.getAdminschemeId(admGrpDyn)).with(AdmGroup::setLevel, (Object)admGrpDyn.getInt("level")).build();
                PermResult checkRes = UserAdmGrpSaveValidator.check((SaveCheckUserAdmGrpReq)PermBuilder.of(SaveCheckUserAdmGrpReq::new).with(SaveCheckUserAdmGrpReq::setAdmGrpFromDB, (Object)true).with(SaveCheckUserAdmGrpReq::setCanSavePermAdmGroupIdSet, (Object)canSavePermAdmGroupIdSet).with(SaveCheckUserAdmGrpReq::setAdmGrpAddUserF7Map, (Object)admGrpAddUserF7Map).with(SaveCheckUserAdmGrpReq::setCurAdmGrp, (Object)curAdmGrp).with(SaveCheckUserAdmGrpReq::setUserDynMap, (Object)userDynMap).with(SaveCheckUserAdmGrpReq::setCurUserId, (Object)userId).with(SaveCheckUserAdmGrpReq::setCurUserIsAdmin, (Object)curUserIsAdmin).with(SaveCheckUserAdmGrpReq::setCurEnableSchemeId, (Object)curEnableSchemeId).build());
                if (checkRes.isOk()) continue;
                this.appendErrorInfo(errorInfo, extendedData2, checkRes.getMsg());
                return;
            }
            catch (Exception e) {
                log.error("{}.{} error.", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), Thread.currentThread().getStackTrace()[1].getMethodName(), e});
                this.addErrorMessage(extendedData2, e.getMessage());
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a%1$s", (String)"RoleSaveOP_0", (String)"bos-permission-opplugin", (Object[])new Object[0]), e.getMessage()));
            }
        }
    }

    private static PermResult check(SaveCheckUserAdmGrpReq saveCheckParam) {
        boolean admGrpFromDB = saveCheckParam.isAdmGrpFromDB();
        Set canSavePermAdmGroupIdSet = saveCheckParam.getCanSavePermAdmGroupIdSet();
        Map admGrpAddUserF7Map = saveCheckParam.getAdmGrpAddUserF7Map();
        AdmGrp curAdmGrp = saveCheckParam.getCurAdmGrp();
        Map userDynMap = saveCheckParam.getUserDynMap();
        Long curUserId = saveCheckParam.getCurUserId();
        boolean curUserIsAdmin = saveCheckParam.isCurUserIsAdmin();
        if (!curUserIsAdmin) {
            String info = ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u4e0d\u662f\u7ba1\u7406\u5458\u3002", (String)"AdmGrpSaveValidator_1", (String)"bos-permission-opplugin", (Object[])new Object[0]);
            return PermResult.fail((String)info);
        }
        if (null == curAdmGrp) {
            String info = ResManager.loadKDString((String)"\u7ba1\u7406\u5458\u7ec4\u4e0d\u5b58\u5728\u3002", (String)"AdmGrpFunpermSaveValidator_0", (String)"bos-permission-opplugin", (Object[])new Object[0]);
            return PermResult.fail((String)info);
        }
        Long curAdmGrpId = curAdmGrp.getId();
        if (admGrpFromDB && (null == curAdmGrpId || Objects.equals(0L, curAdmGrpId))) {
            String info = ResManager.loadKDString((String)"\u7ba1\u7406\u5458\u7ec4\u4e0d\u5b58\u5728\u3002", (String)"AdmGrpFunpermSaveValidator_0", (String)"bos-permission-opplugin", (Object[])new Object[0]);
            return PermResult.fail((String)info);
        }
        if (null == userDynMap || userDynMap.isEmpty() || null == userDynMap.get(curUserId)) {
            String info = ResManager.loadKDString((String)"\u7528\u6237\u4e0d\u5b58\u5728\u3002", (String)"UserAdmGrpSaveValidator_1", (String)"bos-permission-opplugin", (Object[])new Object[0]);
            return PermResult.fail((String)info);
        }
        DynamicObject curUser = (DynamicObject)userDynMap.get(curUserId);
        String curUserName = null == curUser ? String.valueOf(curUserId) : curUser.getString("name");
        String curAdmGrpName = curAdmGrp.getName();
        long curGroupAdminSchemeId = curAdmGrp.getAdminScheme();
        Long curEnableSchemeId = saveCheckParam.getCurEnableSchemeId();
        if (!Objects.equals(curEnableSchemeId, curGroupAdminSchemeId)) {
            return PermResult.fail((String)String.format(ResManager.loadKDString((String)"\u8be5\u7ba1\u7406\u5458\u7ec4\u201c%1$s\u201d\u4e0d\u5c5e\u4e8e\u5f53\u524d\u865a\u62df\u7ba1\u7406\u5458\u63a7\u5236\u7b56\u7565\u3002", (String)"AdmGrpSaveValidator_3", (String)"bos-permission-opplugin", (Object[])new Object[0]), curAdmGrpName));
        }
        long level = curAdmGrp.getLevel().intValue();
        if (level == 1L) {
            return PermResult.fail((String)ResManager.loadKDString((String)"\u865a\u62df\u7ba1\u7406\u5458\u7ec4\u4e0d\u5141\u8bb8\u6dfb\u52a0\u6216\u5220\u9664\u7528\u6237\u3002", (String)"UserAdmGrpSaveValidator_3", (String)"bos-permission-opplugin", (Object[])new Object[0]));
        }
        if (admGrpFromDB && CollectionUtils.isEmpty((Collection)canSavePermAdmGroupIdSet)) {
            String info = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5206\u7ec4\u201c%1$s\u201d\u4e0d\u5728\u60a8\u7684\u63a7\u5236\u8303\u56f4\u5185\uff0c\u60a8\u65e0\u6743\u8fdb\u884c\u65b0\u589e\u5220\u9664\u7b49\u64cd\u4f5c\u3002", (String)"UserAdmGrpSaveValidator_0", (String)"bos-permission-opplugin", (Object[])new Object[0]), curAdmGrpName);
            return PermResult.fail((String)info);
        }
        if (admGrpFromDB && !canSavePermAdmGroupIdSet.contains(String.valueOf(curAdmGrpId))) {
            String info = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5206\u7ec4\u201c%1$s\u201d\u4e0d\u5728\u60a8\u7684\u63a7\u5236\u8303\u56f4\u5185\uff0c\u60a8\u65e0\u6743\u8fdb\u884c\u65b0\u589e\u5220\u9664\u7b49\u64cd\u4f5c\u3002", (String)"UserAdmGrpSaveValidator_0", (String)"bos-permission-opplugin", (Object[])new Object[0]), curAdmGrpName);
            return PermResult.fail((String)info);
        }
        if (null == admGrpAddUserF7Map) {
            String info = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5206\u7ec4\u201c%1$s\u201d\u8981\u5206\u914d\u7684\u7528\u6237\u201c%2$s\u201d\u4e0d\u5728\u53ef\u9009\u8303\u56f4\u5185\u3002", (String)"UserAdmGrpSaveValidator_2", (String)"bos-permission-opplugin", (Object[])new Object[0]), curAdmGrpName, curUserName);
            return PermResult.fail((String)info);
        }
        Set permUsers = (Set)admGrpAddUserF7Map.get(curAdmGrpId);
        if (null == permUsers || permUsers.isEmpty()) {
            String info = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5206\u7ec4\u201c%1$s\u201d\u8981\u5206\u914d\u7684\u7528\u6237\u201c%2$s\u201d\u4e0d\u5728\u53ef\u9009\u8303\u56f4\u5185\u3002", (String)"UserAdmGrpSaveValidator_2", (String)"bos-permission-opplugin", (Object[])new Object[0]), curAdmGrpName, curUserName);
            return PermResult.fail((String)info);
        }
        PermUser permUser = permUsers.stream().filter(x -> Objects.equals(curUserId, x.getUserId())).findFirst().orElse(null);
        if (null == permUser) {
            String info = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5206\u7ec4\u201c%1$s\u201d\u8981\u5206\u914d\u7684\u7528\u6237\u201c%2$s\u201d\u4e0d\u5728\u53ef\u9009\u8303\u56f4\u5185\u3002", (String)"UserAdmGrpSaveValidator_2", (String)"bos-permission-opplugin", (Object[])new Object[0]), curAdmGrpName, curUserName);
            return PermResult.fail((String)info);
        }
        return PermResult.ok();
    }

    private void appendErrorInfo(StringBuilder errorInfo, ExtendedDataEntity extendedData, String info) {
        errorInfo.setLength(0);
        errorInfo.append(info);
        this.addErrorMessage(extendedData, errorInfo.toString());
    }
}

