/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.opplugin.validator.save.busirole;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.factory.PermServiceFactory;
import kd.bos.permission.log.helper.PermBusiRoleLogHelper;
import kd.bos.permission.log.model.PermLogBusiType;
import kd.bos.permission.log.service.PermLogService;
import kd.bos.permission.model.perm.PermBuilder;
import kd.bos.permission.model.perm.req.PermLogReq;
import kd.bos.permission.model.perm.req.PermOperationReq;
import kd.bos.permission.model.perm.req.bat.aftersave.BusiRoleAfterSaveReq;
import kd.bos.permission.service.BusiRoleService;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.util.StringUtils;

public class BusiRoleSaveOP
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(BusiRoleSaveOP.class);

    private static BusiRoleService getBusiRoleService() {
        return (BusiRoleService)PermServiceFactory.getService((String)"BusiRoleService");
    }

    private Map<String, String> getOptionVariables() {
        Map variables = this.getOption().getVariables();
        variables = null == variables ? new HashMap(8) : variables;
        return variables;
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        try {
            super.beginOperationTransaction(e);
            DynamicObject[] dataEntities = e.getDataEntities();
            if (null == dataEntities || Objects.equals(0, dataEntities.length)) {
                return;
            }
            Map<String, String> variables = this.getOptionVariables();
            String preDataMapStr = variables.get("preDataMap");
            if (StringUtils.isEmpty((String)preDataMapStr)) {
                Set bizRoleIdSet = Arrays.stream(dataEntities).map(x -> String.valueOf(x.getPkValue())).collect(Collectors.toSet());
                Map preDataMap = PermBusiRoleLogHelper.busiRoleEventImage(bizRoleIdSet, (boolean)false, (boolean)true);
                this.getOption().setVariableValue("preDataMap", StrUtil.compress((String)new ObjectMapper().writeValueAsString((Object)preDataMap)));
            }
        }
        catch (Exception ex) {
            log.error("BusiRoleSaveOP.beginOperationTransaction error.", (Throwable)ex);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a%1$s", (String)"RoleSaveOP_0", (String)"bos-permission-opplugin", (Object[])new Object[0]), ex.getMessage()));
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        try {
            super.endOperationTransaction(e);
            DynamicObject[] dataEntities = e.getDataEntities();
            if (null == dataEntities || Objects.equals(0, dataEntities.length)) {
                return;
            }
            HashSet<String> bizRoleIdSet = new HashSet<String>(8);
            for (DynamicObject dyn : dataEntities) {
                if (null == dyn) continue;
                String roleId = dyn.getString("id");
                bizRoleIdSet.add(roleId);
            }
            String entNum = dataEntities[0].getDynamicObjectType().getName();
            Map<String, String> variables = this.getOptionVariables();
            PermLogReq permLogReq = this.wrapPermLogReq(variables, entNum);
            String preDataMapStr = variables.get("preDataMap");
            String appNum = variables.get("currbizappid");
            PermOperationReq afterSaveReq = (PermOperationReq)PermBuilder.of(BusiRoleAfterSaveReq::new).with(PermOperationReq::setMainIdSet, bizRoleIdSet).with(PermOperationReq::setCurAppNum, (Object)appNum).with(PermOperationReq::setPermLogReq, (Object)permLogReq).with(PermOperationReq::setPreDataMapStr, (Object)preDataMapStr).build();
            BusiRoleSaveOP.getBusiRoleService().afterMainEntitySave(afterSaveReq);
        }
        catch (Exception ex) {
            log.error("BusiRoleSaveOP.endOperationTransaction error.", (Throwable)ex);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a%1$s", (String)"RoleSaveOP_0", (String)"bos-permission-opplugin", (Object[])new Object[0]), ex.getMessage()));
        }
    }

    private PermLogReq wrapPermLogReq(Map<String, String> variables, String entNum) {
        try {
            if (!PermCommonUtil.isEnablePermLog()) {
                return null;
            }
            String entSavePermLog = "";
            String formNum = StringUtils.isEmpty((String)variables.get("permlog_formnum")) ? entNum : variables.get("permlog_formnum");
            String permlog_busitype = "";
            String op = "";
            String opbtn = "";
            String interfacemethod = "";
            String batchimport = variables.get("batchimport");
            if (Objects.equals("true", batchimport)) {
                entSavePermLog = "1";
                permlog_busitype = "busirole_role_import";
                op = "importdata";
                opbtn = ConstantsHelper.getImportData();
                interfacemethod = "kd.bos.permission.formplugin.plugin.impexp.imp.BusiRoleImportPlugin.save";
            } else {
                entSavePermLog = variables.get("ENTSAVE_PERMLOG");
                permlog_busitype = variables.get("permlog_busitype");
                op = variables.get("permlog_op");
                opbtn = variables.get("permlog_opbtn");
                interfacemethod = variables.get("permlog_interfacemethod");
            }
            if (!Objects.equals("1", entSavePermLog)) {
                return null;
            }
            String appNum = variables.get("currbizappid");
            String appId = AppHelper.getMetaAppInfo((String)appNum).getId();
            String appIdByFormNum = StringUtils.isEmpty((String)appId) ? BizAppServiceHelp.getAppIdByFormNum((String)formNum) : appId;
            String cloudId = AppHelper.getMetaAppInfo((String)appId).getCloudId();
            PermLogReq permLogReq = new PermLogReq();
            PermLogBusiType permLogBusiType = PermLogService.getPermLogBusiType((String)permlog_busitype);
            permLogReq.setBusiFrom(null == permLogBusiType ? "" : permLogBusiType.getBusiTypeDesc());
            permLogReq.setBusiType(null == permLogBusiType ? "" : permLogBusiType.getBusiType());
            permLogReq.setFormIdentity(formNum);
            permLogReq.setAppId(appIdByFormNum);
            permLogReq.setCloudId(cloudId);
            permLogReq.setOp(op);
            permLogReq.setOpbtn(opbtn);
            permLogReq.setInterfaceMethod(interfacemethod);
            permLogReq.setQueryFL(true);
            Map preDataMap = new HashMap(8);
            String preDataMapStr = variables.get("preDataMap");
            if (StringUtils.isNotEmpty((String)preDataMapStr)) {
                String uncompress = StrUtil.uncompress((String)preDataMapStr);
                preDataMap = (Map)new ObjectMapper().readValue(uncompress, Map.class);
            }
            permLogReq.setPreDataMap(preDataMap);
            permLogReq.setOperTime(TimeServiceHelper.now());
            permLogReq.setClientType(RequestContext.get().getClient());
            permLogReq.setClientIp(RequestContext.get().getLoginIP());
            return permLogReq;
        }
        catch (Exception e) {
            log.error("BusiRoleSaveOP.wrapPermLogReq error.", (Throwable)e);
            return null;
        }
    }
}

