/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.opplugin.validator.save.comrole;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.api.ext.IPermExt;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.PermRoleHelper;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.factory.PermServiceFactory;
import kd.bos.permission.log.helper.PermLogHelper;
import kd.bos.permission.model.perm.ComRole;
import kd.bos.permission.model.perm.PermBuilder;
import kd.bos.permission.model.perm.req.PermLogReq;
import kd.bos.permission.model.perm.req.PermOperationReq;
import kd.bos.permission.model.perm.req.comrole.get.ComRoleOperationReq;
import kd.bos.permission.model.perm.req.comrole.get.GetComRoleFuncPermReq;
import kd.bos.permission.opplugin.validator.save.comrole.ComRoleFuncPermSaveValidator;
import kd.bos.permission.service.comrole.ComRoleFuncPermService;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;

public class ComRoleFuncPermSaveOp
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(ComRoleFuncPermSaveOp.class);

    private Map<String, String> getOptionVariables() {
        Map variables = this.getOption().getVariables();
        variables = null == variables ? new HashMap(8) : variables;
        return variables;
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new ComRoleFuncPermSaveValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        try {
            super.beginOperationTransaction(e);
            Map<String, String> variables = this.getOptionVariables();
            DynamicObject[] dataEntities = e.getDataEntities();
            if (null == dataEntities || Objects.equals(0, dataEntities.length)) {
                return;
            }
            String preDataMapStr = variables.get("preDataMap");
            if (StringUtils.isEmpty((String)preDataMapStr)) {
                Set mainIdSet = Arrays.stream(dataEntities).map(x -> String.valueOf(x.getPkValue())).collect(Collectors.toSet());
                GetComRoleFuncPermReq req = new GetComRoleFuncPermReq(mainIdSet, null, null, null, null, null, null, null, null);
                Map comRoleFuncPermSetMap = ComRoleFuncPermService.getComRoleFuncPermSetMap((GetComRoleFuncPermReq)req);
                this.getOption().setVariableValue("preDataMap", StrUtil.compress((String)new ObjectMapper().writeValueAsString((Object)comRoleFuncPermSetMap)));
                Map preComRoleBaseMap = new HashMap(0);
                Set comRoleIdSet = Arrays.stream(dataEntities).map(x -> x.getString("role_id")).collect(Collectors.toSet());
                if (PermCommonUtil.isEnablePermLog() && CollectionUtils.isNotEmpty(comRoleIdSet)) {
                    preComRoleBaseMap = PermRoleHelper.getComRoleBaseMap(comRoleIdSet, null);
                }
                this.getOption().setVariableValue("preComRoleBaseMap", StrUtil.compress((String)new ObjectMapper().writeValueAsString(preComRoleBaseMap)));
            }
        }
        catch (Exception ex) {
            log.error("{}.{} error.", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), Thread.currentThread().getStackTrace()[1].getMethodName(), ex});
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a%1$s", (String)"RoleSaveOP_0", (String)"bos-permission-opplugin", (Object[])new Object[0]), ex.getMessage()));
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        try {
            String currbizappNum;
            super.endOperationTransaction(e);
            Map<String, String> variables = this.getOptionVariables();
            DynamicObject[] dataEntities = e.getDataEntities();
            if (null == dataEntities || Objects.equals(0, dataEntities.length)) {
                return;
            }
            HashSet<String> mainIdSet = new HashSet<String>(8);
            for (DynamicObject dyn : dataEntities) {
                if (null == dyn) continue;
                mainIdSet.add(dyn.getString("id"));
            }
            variables.put("ENTSAVE_PERMLOG", StringUtils.isEmpty((String)variables.get("ENTSAVE_PERMLOG")) ? "1" : variables.get("ENTSAVE_PERMLOG"));
            String defaultFormFlag = StringUtils.isEmpty((String)variables.get("permlog_formnum")) ? dataEntities[0].getDynamicObjectType().getName() : variables.get("permlog_formnum");
            String defaultPermlogBusitype = StringUtils.isEmpty((String)variables.get("permlog_busitype")) ? "common_role_modify_save" : variables.get("permlog_busitype");
            String defaultOp = StringUtils.isEmpty((String)variables.get("permlog_op")) ? "save" : variables.get("permlog_op");
            String defaultOpbtn = StringUtils.isEmpty((String)variables.get("permlog_opbtn")) ? ConstantsHelper.getSave() : variables.get("permlog_opbtn");
            String defaultPermlogInterfacemethod = StringUtils.isEmpty((String)variables.get("permlog_interfacemethod")) ? "ComRoleFuncPermSaveOp.endOperationTransaction" : variables.get("permlog_interfacemethod");
            String batchimport = variables.get("batchimport");
            if (Objects.equals("true", batchimport)) {
                defaultOp = "importdata";
                defaultOpbtn = ConstantsHelper.getImportData();
            }
            if (StringUtils.isEmpty((String)(currbizappNum = variables.get("currbizappid")))) {
                currbizappNum = "devportal";
                variables.put("currbizappid", currbizappNum);
            }
            PermLogReq permLogReq = PermLogHelper.wrapOperPermLogReq(variables, (String)defaultFormFlag, (String)defaultPermlogBusitype, (String)defaultOp, (String)defaultOpbtn, (String)defaultPermlogInterfacemethod);
            String preDataMapStr = variables.get("preDataMap");
            Map preComRoleBaseMap = null;
            String preComRoleBaseMapStr = variables.get("preComRoleBaseMap");
            if (StringUtils.isNotEmpty((String)preComRoleBaseMapStr)) {
                String uncompress = StrUtil.uncompress((String)preComRoleBaseMapStr);
                preComRoleBaseMap = (Map)new ObjectMapper().readValue(uncompress, (TypeReference)new TypeReference<Map<String, ComRole>>(){});
            }
            ComRoleOperationReq afterSaveReq = (ComRoleOperationReq)PermBuilder.of(ComRoleOperationReq::new).with(PermOperationReq::setCurAppNum, (Object)currbizappNum).with(PermOperationReq::setCurFormNum, (Object)defaultFormFlag).with(PermOperationReq::setMainIdSet, mainIdSet).with(PermOperationReq::setPermLogReq, (Object)permLogReq).with(PermOperationReq::setPreDataMapStr, (Object)preDataMapStr).with(ComRoleOperationReq::setPreComRoleBaseMap, (Object)preComRoleBaseMap).with(PermOperationReq::setNeedClearAllCache, (Object)variables.get("NEED_CLEARALLCACHE")).with(PermOperationReq::setDoDelExcessData, (Object)variables.get("DO_DELEXCESSDATA")).build();
            ((IPermExt)PermServiceFactory.getService((String)"ComRoleFuncPermService")).afterMainEntitySave((PermOperationReq)afterSaveReq);
        }
        catch (Exception ex) {
            log.error("{}.{} error.", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), Thread.currentThread().getStackTrace()[1].getMethodName(), ex});
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a%1$s", (String)"RoleSaveOP_0", (String)"bos-permission-opplugin", (Object[])new Object[0]), ex.getMessage()));
        }
    }
}

