/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.opplugin.validator.save.comrole;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppInfo;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.StringUtils;
import kd.bos.permission.cache.AdminPermCache;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.PermItemHelper;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.model.PermResult;
import kd.bos.permission.model.perm.PermBuilder;
import kd.bos.permission.model.perm.PermItem;
import kd.bos.permission.model.perm.req.common.GetBaseDataDynMapReq;
import kd.bos.permission.model.perm.req.comrole.savecheck.SaveCheckComRoleReq;
import kd.bos.permission.model.perm.req.permitem.GetPlainPermItemListReq;
import kd.bos.permission.model.perm.resp.common.GetBaseDataDynMapResp;
import kd.bos.permission.service.AdminGroupService;

public class ComRoleFuncPermSaveValidator
extends AbstractValidator {
    private static final Log log = LogFactory.getLog(ComRoleFuncPermSaveValidator.class);

    private Map<String, String> getOptionVariables() {
        Map variables = this.getOption().getVariables();
        variables = null == variables ? new HashMap(8) : variables;
        return variables;
    }

    public void validate() {
        Map<String, String> optionVariables = this.getOptionVariables();
        String alreadyCheckBusiParam = optionVariables.get("ALREADY_CHECKBUSIPARAM");
        if (!StringUtils.isEmpty((Object)alreadyCheckBusiParam) && Objects.equals("1", alreadyCheckBusiParam)) {
            return;
        }
        long currUserId = RequestContext.get().getCurrUserId();
        HashSet adminChargeAppSet = new HashSet(AdminPermCache.getAdminChargeApps((Long)currUserId, null));
        GetPlainPermItemListReq req = new GetPlainPermItemListReq();
        req.setDimType("DIM_ORG");
        req.setDimDiffHide("0");
        req.setReturnByField(true);
        req.setReturnFieldSet((Set)Sets.newHashSet((Object[])new String[]{"appId", "appNumber", "entityNumber", "permItemId", "permItemNumber"}));
        List plainPermItemList = PermItemHelper.getPlainPermItemList((GetPlainPermItemListReq)req);
        HashSet roleIdSet = new HashSet(8);
        HashSet entNumSet = new HashSet(8);
        HashSet permItemIdSet = new HashSet(8);
        Arrays.stream(this.dataEntities).forEach(extendedData -> {
            Object permitemIdObj;
            Object entNumObj;
            Object roleIdObj = extendedData.getValue("role_id");
            if (null != roleIdObj) {
                roleIdSet.add((String)roleIdObj);
            }
            if (null != (entNumObj = extendedData.getValue("entity_id"))) {
                entNumSet.add((String)entNumObj);
            }
            if (null != (permitemIdObj = extendedData.getValue("permitem_id"))) {
                permItemIdSet.add((String)permitemIdObj);
            }
        });
        GetBaseDataDynMapResp baseDataDynMap = PermCommonUtil.getBaseDataDynMap((GetBaseDataDynMapReq)((GetBaseDataDynMapReq)PermBuilder.of(GetBaseDataDynMapReq::new).with(GetBaseDataDynMapReq::setComRoleIdSet, roleIdSet).with(GetBaseDataDynMapReq::setEntNumSet, entNumSet).with(GetBaseDataDynMapReq::setPermItemIdSet, permItemIdSet).build()));
        Map comRoleDynMap = baseDataDynMap.getComRoleDynMap();
        Map entDynMap = baseDataDynMap.getEntDynMap();
        Map permitemDynMap = baseDataDynMap.getPermItemDynMap();
        Map canModifyRoleIdMap = AdminGroupService.canModifyRole((Long)currUserId, new ArrayList(roleIdSet));
        StringBuilder errorInfo = new StringBuilder();
        for (ExtendedDataEntity extendedData2 : this.dataEntities) {
            try {
                Object roleIdObj = extendedData2.getValue("role_id");
                if (null == roleIdObj) {
                    String info = ResManager.loadKDString((String)"\u901a\u7528\u89d2\u8272\u4e0d\u5b58\u5728\u3002", (String)"ComRoleFuncPermSaveValidator_0", (String)"bos-permission-opplugin", (Object[])new Object[0]);
                    this.appendErrorInfo(errorInfo, extendedData2, info);
                    return;
                }
                String roleId = (String)roleIdObj;
                DynamicObject comRoleDyn = (DynamicObject)comRoleDynMap.get(roleId);
                if (null == comRoleDyn) {
                    String info = ResManager.loadKDString((String)"\u901a\u7528\u89d2\u8272\u4e0d\u5b58\u5728\u3002", (String)"ComRoleFuncPermSaveValidator_0", (String)"bos-permission-opplugin", (Object[])new Object[0]);
                    this.appendErrorInfo(errorInfo, extendedData2, info);
                    return;
                }
                Object appIdObj = extendedData2.getValue("bizapp_id");
                if (null == appIdObj) {
                    String info = ResManager.loadKDString((String)"\u5e94\u7528\u4e0d\u5b58\u5728\u3002", (String)"AdmGrpFunpermSaveValidator_4", (String)"bos-permission-opplugin", (Object[])new Object[0]);
                    this.appendErrorInfo(errorInfo, extendedData2, info);
                    return;
                }
                String appId = (String)appIdObj;
                Object entNumObj = extendedData2.getValue("entity_id");
                if (null == entNumObj) {
                    String info = ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u4e0d\u5b58\u5728\u3002", (String)"AdmGrpFunpermSaveValidator_5", (String)"bos-permission-opplugin", (Object[])new Object[0]);
                    this.appendErrorInfo(errorInfo, extendedData2, info);
                    return;
                }
                String entNum = (String)entNumObj;
                Object permitemIdObj = extendedData2.getValue("permitem_id");
                if (null == permitemIdObj) {
                    String info = ResManager.loadKDString((String)"\u6743\u9650\u9879\u4e0d\u5b58\u5728\u3002", (String)"AdmGrpFunpermSaveValidator_6", (String)"bos-permission-opplugin", (Object[])new Object[0]);
                    this.appendErrorInfo(errorInfo, extendedData2, info);
                    return;
                }
                String permitemId = (String)permitemIdObj;
                PermResult checkRes = ComRoleFuncPermSaveValidator.check((SaveCheckComRoleReq)PermBuilder.of(SaveCheckComRoleReq::new).with(SaveCheckComRoleReq::setComRoleFromDB, (Object)true).with(SaveCheckComRoleReq::setCanModifyRoleIdMap, (Object)canModifyRoleIdMap).with(SaveCheckComRoleReq::setCurUserOwnerPermItemList, (Object)plainPermItemList).with(SaveCheckComRoleReq::setAdminChargeAppSet, adminChargeAppSet).with(SaveCheckComRoleReq::setCurComRoleDyn, (Object)comRoleDyn).with(SaveCheckComRoleReq::setEntDynMap, (Object)entDynMap).with(SaveCheckComRoleReq::setPermitemDynMap, (Object)permitemDynMap).with(SaveCheckComRoleReq::setCurAppId, (Object)appId).with(SaveCheckComRoleReq::setCurEntNum, (Object)entNum).with(SaveCheckComRoleReq::setCurPermItemId, (Object)permitemId).build());
                if (checkRes.isOk()) continue;
                this.appendErrorInfo(errorInfo, extendedData2, checkRes.getMsg());
                return;
            }
            catch (Exception e) {
                log.error("{}.{} error.", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), Thread.currentThread().getStackTrace()[1].getMethodName(), e});
                this.addErrorMessage(extendedData2, e.getMessage());
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a%1$s", (String)"RoleSaveOP_0", (String)"bos-permission-opplugin", (Object[])new Object[0]), e.getMessage()));
            }
        }
    }

    public static PermResult check(SaveCheckComRoleReq saveCheckParam) {
        boolean comRoleFromDB = saveCheckParam.isComRoleFromDB();
        Map canModifyRoleIdMap = saveCheckParam.getCanModifyRoleIdMap();
        Set adminChargeAppSet = saveCheckParam.getAdminChargeAppSet();
        DynamicObject curComRoleDyn = saveCheckParam.getCurComRoleDyn();
        Map curEntDynMap = saveCheckParam.getEntDynMap();
        Map curPermitemDynMap = saveCheckParam.getPermitemDynMap();
        String curAppId = saveCheckParam.getCurAppId();
        String curEntNum = saveCheckParam.getCurEntNum();
        String curPermItemId = saveCheckParam.getCurPermItemId();
        if (null == curComRoleDyn) {
            String info = ResManager.loadKDString((String)"\u901a\u7528\u89d2\u8272\u4e0d\u5b58\u5728\u3002", (String)"ComRoleFuncPermSaveValidator_0", (String)"bos-permission-opplugin", (Object[])new Object[0]);
            return PermResult.fail((String)info);
        }
        String curComRoleId = curComRoleDyn.getString("id");
        if (comRoleFromDB && StringUtils.isEmpty((Object)curComRoleId)) {
            String info = ResManager.loadKDString((String)"\u901a\u7528\u89d2\u8272\u4e0d\u5b58\u5728\u3002", (String)"ComRoleFuncPermSaveValidator_0", (String)"bos-permission-opplugin", (Object[])new Object[0]);
            return PermResult.fail((String)info);
        }
        if (comRoleFromDB && null != canModifyRoleIdMap.get(curComRoleId) && !((Boolean)canModifyRoleIdMap.get(curComRoleId)).booleanValue()) {
            String curComRoleNumber = curComRoleDyn.getString("number");
            String info = String.format(ResManager.loadKDString((String)"\u901a\u7528\u89d2\u8272\u7f16\u7801\u201c%1$s\u201d\u4e0d\u5728\u5f53\u524d\u7ba1\u7406\u5458\u7ba1\u8f96\u8303\u56f4\u5185\u3002", (String)"ComRoleFuncPermSaveValidator_7", (String)"bos-permission-opplugin", (Object[])new Object[0]), curComRoleNumber);
            return PermResult.fail((String)info);
        }
        AppInfo curApp = AppHelper.getMetaAppInfo((String)curAppId);
        if (null == curApp) {
            String info = ResManager.loadKDString((String)"\u5e94\u7528\u4e0d\u5b58\u5728\u3002", (String)"AdmGrpFunpermSaveValidator_4", (String)"bos-permission-opplugin", (Object[])new Object[0]);
            return PermResult.fail((String)info);
        }
        List curUserOwnerPermItemList = null == saveCheckParam.getCurUserOwnerPermItemList() ? new ArrayList(0) : saveCheckParam.getCurUserOwnerPermItemList();
        HashSet<PermItem> curUserOwnerPermItemSet = new HashSet<PermItem>(curUserOwnerPermItemList);
        Map<String, Object> map = ComRoleFuncPermSaveValidator.readyPermItemCheckInfo(curUserOwnerPermItemSet);
        Map appNumEntNumSetMap = (Map)map.get("appNumEntNumSetMap");
        Map entNumPermItemNumSetMap = (Map)map.get("entNumPermItemNumSetMap");
        String appNumber = curApp.getNumber();
        if (!adminChargeAppSet.contains(curAppId)) {
            String info = String.format(ResManager.loadKDString((String)"\u5e94\u7528\u7f16\u7801\u201c%1$s\u201d\u4e0d\u5728\u5f53\u524d\u7528\u6237\u7684\u7ba1\u7406\u5458\u5206\u7ec4\u7684\u5e94\u7528\u8303\u56f4\u5185\u3002", (String)"ComRoleFuncPermSaveValidator_6", (String)"bos-permission-opplugin", (Object[])new Object[0]), appNumber);
            return PermResult.fail((String)info);
        }
        if (null == curEntDynMap || curEntDynMap.isEmpty() || null == curEntDynMap.get(curEntNum)) {
            String info = String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u7f16\u7801\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"ComRoleFuncPermSaveValidator_2", (String)"bos-permission-opplugin", (Object[])new Object[0]), curEntNum);
            return PermResult.fail((String)info);
        }
        DynamicObject curEnt = (DynamicObject)curEntDynMap.get(curEntNum);
        String curEntityName = curEnt.getString("name");
        DynamicObject curPermItem = (DynamicObject)curPermitemDynMap.get(curPermItemId);
        String curPermItemNumber = curPermItem.getString("number");
        String curPermItemName = curPermItem.getString("name");
        if (null == curPermitemDynMap || curPermitemDynMap.isEmpty() || null == curPermitemDynMap.get(curPermItemId)) {
            String info = String.format(ResManager.loadKDString((String)"\u6743\u9650\u9879\u7f16\u7801\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"ComRoleFuncPermSaveValidator_3", (String)"bos-permission-opplugin", (Object[])new Object[0]), curPermItemNumber);
            return PermResult.fail((String)info);
        }
        Set entNumSet = (Set)appNumEntNumSetMap.get(appNumber);
        if (null != entNumSet && !entNumSet.contains(curEntNum)) {
            String info = String.format(ResManager.loadKDString((String)"\u5e94\u7528\u7f16\u7801\u201c%1$s\u201d\u4e0b\u65e0\u4e1a\u52a1\u5bf9\u8c61\u7f16\u7801\u201c%2$s\u201d\u3002", (String)"ComRoleFuncPermSaveValidator_4", (String)"bos-permission-opplugin", (Object[])new Object[0]), appNumber, curEntNum);
            return PermResult.fail((String)info);
        }
        Set permItemSet = (Set)entNumPermItemNumSetMap.get(curEntNum);
        if (null != permItemSet && !permItemSet.contains(curPermItemNumber)) {
            String info = String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u7f16\u7801\u201c%1$s\u201d\u4e0b\u65e0\u6743\u9650\u9879\u7f16\u7801\u201c%2$s\u201d\u3002", (String)"ComRoleFuncPermSaveValidator_5", (String)"bos-permission-opplugin", (Object[])new Object[0]), curEntNum, curPermItemNumber);
            return PermResult.fail((String)info);
        }
        long count = curUserOwnerPermItemSet.stream().filter(x -> Objects.equals(curAppId, x.getAppId()) && Objects.equals(curEntNum, x.getEntityNumber()) && Objects.equals(curPermItemId, x.getPermItemId())).count();
        if (0L == count) {
            String info = String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u4ee5\u4e0b\u6743\u9650\uff1a\r\n%1$s-%2$s-%3$s\u3002", (String)"ComRoleFuncPermSaveValidator_8", (String)"bos-permission-opplugin", (Object[])new Object[0]), curApp.getName(), curEntityName, curPermItemName);
            return PermResult.fail((String)info);
        }
        return PermResult.ok();
    }

    private static Map<String, Object> readyPermItemCheckInfo(Set<PermItem> curUserOwnerPermItemSet) {
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        HashMap<String, Set> appNumEntNumSetMap = new HashMap<String, Set>(8);
        HashMap<String, Set> entNumPermItemNumSetMap = new HashMap<String, Set>(8);
        for (PermItem permItem : curUserOwnerPermItemSet) {
            String appNumber = permItem.getAppNumber();
            String entityNumber = permItem.getEntityNumber();
            String permItemNumber = permItem.getPermItemNumber();
            appNumEntNumSetMap.computeIfAbsent(appNumber, k -> new HashSet(8)).add(entityNumber);
            entNumPermItemNumSetMap.computeIfAbsent(entityNumber, k -> new HashSet(8)).add(permItemNumber);
        }
        map.put("appNumEntNumSetMap", appNumEntNumSetMap);
        map.put("entNumPermItemNumSetMap", entNumPermItemNumSetMap);
        return map;
    }

    private void appendErrorInfo(StringBuilder errorInfo, ExtendedDataEntity extendedData, String info) {
        errorInfo.setLength(0);
        errorInfo.append(info);
        this.addErrorMessage(extendedData, errorInfo.toString());
    }
}

