/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.opplugin.validator.save.userdirect;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.IsoDimHelper;
import kd.bos.permission.cache.util.SqlUtil;
import kd.bos.permission.factory.PermServiceFactory;
import kd.bos.permission.log.helper.PermLogHelper;
import kd.bos.permission.model.perm.PermBuilder;
import kd.bos.permission.model.perm.req.PermLogReq;
import kd.bos.permission.model.perm.req.PermOperationReq;
import kd.bos.permission.model.perm.req.bat.aftersave.UserDirectPermAfterSaveReq;
import kd.bos.permission.model.perm.req.user.GetUserFuncDimReq;
import kd.bos.permission.model.perm.user.UserFuncDim;
import kd.bos.permission.opplugin.validator.save.userdirect.UserDirectPermDetailSaveValidator;
import kd.bos.permission.service.UserDirectPermService;
import kd.bos.util.StringUtils;

public class UserDirectPermDetailSaveOP
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(UserDirectPermDetailSaveOP.class);

    private Map<String, String> getOptionVariables() {
        Map variables = this.getOption().getVariables();
        variables = null == variables ? new HashMap(8) : variables;
        return variables;
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new UserDirectPermDetailSaveValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        try {
            PermLogReq permLogReq;
            String currbizappNum;
            super.endOperationTransaction(e);
            DynamicObject[] dataEntities = e.getDataEntities();
            if (null == dataEntities || Objects.equals(0, dataEntities.length)) {
                return;
            }
            HashSet<String> mainIdSet = new HashSet<String>(8);
            for (DynamicObject dyn : dataEntities) {
                if (null == dyn) continue;
                mainIdSet.add(dyn.getString("id"));
            }
            if (null == mainIdSet || mainIdSet.isEmpty()) {
                return;
            }
            this.fullUserperm(mainIdSet);
            Map<String, String> variables = this.getOptionVariables();
            String defaultFormFlag = StringUtils.isEmpty((String)variables.get("permlog_formnum")) ? dataEntities[0].getDynamicObjectType().getName() : variables.get("permlog_formnum");
            String defaultPermlogBusitype = StringUtils.isEmpty((String)variables.get("permlog_busitype")) ? "userdirect_save" : variables.get("permlog_busitype");
            String defaultOp = StringUtils.isEmpty((String)variables.get("permlog_op")) ? "save" : variables.get("permlog_op");
            String defaultOpbtn = StringUtils.isEmpty((String)variables.get("permlog_opbtn")) ? ConstantsHelper.getSave() : variables.get("permlog_opbtn");
            String defaultPermlogInterfacemethod = StringUtils.isEmpty((String)variables.get("permlog_interfacemethod")) ? "UserDirectPermDetailSaveOP.endOperationTransaction" : variables.get("permlog_interfacemethod");
            String batchimport = variables.get("batchimport");
            if (Objects.equals("true", batchimport)) {
                defaultOp = "importdata";
                defaultOpbtn = ConstantsHelper.getImportData();
                defaultPermlogBusitype = "userdirectlist_import";
                defaultPermlogInterfacemethod = "UserDirectPermDetailImportPlugin.save";
            }
            if (StringUtils.isEmpty((String)(currbizappNum = variables.get("currbizappid")))) {
                currbizappNum = "secm";
                variables.put("currbizappid", currbizappNum);
            }
            if (null != (permLogReq = PermLogHelper.wrapOperPermLogReq(variables, (String)defaultFormFlag, (String)defaultPermlogBusitype, (String)defaultOp, (String)defaultOpbtn, (String)defaultPermlogInterfacemethod))) {
                permLogReq.setAppId(AppHelper.getCurAppId((String)defaultFormFlag, (String)currbizappNum));
            }
            UserDirectPermAfterSaveReq afterSaveReq = (UserDirectPermAfterSaveReq)PermBuilder.of(UserDirectPermAfterSaveReq::new).with(PermOperationReq::setPermLogReq, (Object)permLogReq).with(UserDirectPermAfterSaveReq::setAddUserUFDMap, UserDirectPermDetailSaveOP.getAddUserUFDMap(mainIdSet)).build();
            UserDirectPermService service = (UserDirectPermService)PermServiceFactory.getService((String)"UserDirectPermService");
            service.afterMainEntitySave((PermOperationReq)afterSaveReq);
        }
        catch (Exception ex) {
            log.error("UserDirectPermDetailSaveOP.endOperationTransaction error.", (Throwable)ex);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a%1$s", (String)"RoleSaveOP_0", (String)"bos-permission-opplugin", (Object[])new Object[0]), ex.getMessage()));
        }
    }

    private static Map<Long, Set<UserFuncDim>> getAddUserUFDMap(Set<String> mainIdSet) {
        HashMap<Long, Set<UserFuncDim>> addUserUFDMap = new HashMap<Long, Set<UserFuncDim>>(8);
        GetUserFuncDimReq userFuncDimReq = new GetUserFuncDimReq();
        userFuncDimReq.setReturnType(Integer.valueOf(2));
        userFuncDimReq.setMainIdSet(mainIdSet);
        Map userFuncDimMap = UserDirectPermService.getUserFuncDimMap((GetUserFuncDimReq)userFuncDimReq);
        for (Map.Entry userFuncDim : userFuncDimMap.entrySet()) {
            UserFuncDim value = (UserFuncDim)userFuncDim.getValue();
            if (null == value) continue;
            addUserUFDMap.computeIfAbsent(value.getUserId(), k -> new HashSet(8)).add(value);
        }
        return addUserUFDMap;
    }

    private void fullUserperm(Set<String> mainIdSet) {
        GetUserFuncDimReq userFuncDimReq = new GetUserFuncDimReq();
        userFuncDimReq.setReturnType(Integer.valueOf(2));
        userFuncDimReq.setMainIdSet(mainIdSet);
        Map userFuncDimMap = UserDirectPermService.getUserFuncDimMap((GetUserFuncDimReq)userFuncDimReq);
        if (null == userFuncDimMap || userFuncDimMap.isEmpty()) {
            return;
        }
        HashMap<String, Set> upermdetaildimFidSetMap = new HashMap<String, Set>(8);
        Map permCtrlTypeBigMap = IsoDimHelper.permCtrlTypeBigMap();
        HashSet<Long> userIdSet = new HashSet<Long>(8);
        HashSet<String> dimTypeBigSet = new HashSet<String>(8);
        HashSet<Long> dimIdSet = new HashSet<Long>(8);
        for (Map.Entry userFuncDim : userFuncDimMap.entrySet()) {
            UserFuncDim value = (UserFuncDim)userFuncDim.getValue();
            if (null == value) continue;
            Long userId = value.getUserId();
            userIdSet.add(userId);
            String permCtrlTypeNum = (String)permCtrlTypeBigMap.get(value.getDimType());
            dimTypeBigSet.add(permCtrlTypeNum);
            Long l = value.getDimId();
            dimIdSet.add(l);
            upermdetaildimFidSetMap.computeIfAbsent(userId + "|" + (String)permCtrlTypeNum + "|" + l + "|" + (value.getIncludeSub() != false ? "1" : "0"), k -> new HashSet(8)).add(value.getId());
        }
        Map<String, String> udimFidMap = UserDirectPermDetailSaveOP.getUserPermDimFidMap(userIdSet, dimTypeBigSet, dimIdSet);
        HashMap<String, Integer> upermNewFidIdxMap = new HashMap<String, Integer>(8);
        int needGenUserpermFidCount = 0;
        ArrayList<Object[]> updateUserpermDetail = new ArrayList<Object[]>(10);
        for (Map.Entry entry : upermdetaildimFidSetMap.entrySet()) {
            String key = (String)entry.getKey();
            Set valueSet = (Set)entry.getValue();
            if (StringUtils.isEmpty((String)key) || null == valueSet || valueSet.isEmpty()) continue;
            String userPermFid = udimFidMap.get(key);
            if (StringUtils.isEmpty((String)userPermFid)) {
                upermNewFidIdxMap.put(key, needGenUserpermFidCount++);
                continue;
            }
            for (String value : valueSet) {
                updateUserpermDetail.add(new Object[]{userPermFid, value});
            }
        }
        ArrayList<Object[]> insertUserperm = new ArrayList<Object[]>(10);
        if (needGenUserpermFidCount > 0) {
            String[] stringArray = ID.genStringIds((int)needGenUserpermFidCount);
            for (Map.Entry upermNewFidIdx : upermNewFidIdxMap.entrySet()) {
                String[] split;
                String key = (String)upermNewFidIdx.getKey();
                Integer value = (Integer)upermNewFidIdx.getValue();
                if (StringUtils.isEmpty((String)key) || null == value || null == (split = key.split("\\|", 4)) || !Objects.equals(4, split.length)) continue;
                Long userId = Long.valueOf(split[0]);
                String permCtrlTypeNum = split[1];
                Long dimId = Long.valueOf(split[2]);
                String includeSub = split[3];
                String newFid = stringArray[value];
                insertUserperm.add(new Object[]{newFid, userId, dimId, includeSub, permCtrlTypeNum});
                Set fentryIdSet = (Set)upermdetaildimFidSetMap.get(key);
                if (null == fentryIdSet || fentryIdSet.isEmpty()) continue;
                for (String fentryId : fentryIdSet) {
                    updateUserpermDetail.add(new Object[]{newFid, fentryId});
                }
            }
        }
        if (null != insertUserperm && !insertUserperm.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)"INSERT INTO t_perm_userperm (fid, fuserid, forgid, fisincludesuborg, fdimtype) VALUES(?, ?, ?, ?, ?)", insertUserperm);
        }
        if (null != updateUserpermDetail && !updateUserpermDetail.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)"update t_perm_userpermdetail set fid =? where fentryid = ?", updateUserpermDetail);
        }
    }

    private static Map<String, String> getUserPermDimFidMap(Set<Long> userIdSet, Set<String> dimTypeBigSet, Set<Long> dimIdSet) {
        String inStr;
        final HashMap<String, String> udimFidMap = new HashMap<String, String>(8);
        ArrayList paramList = new ArrayList(10);
        StringBuilder sb = new StringBuilder();
        sb.append("select fuserid, fdimtype, forgid, fisincludesuborg, fid");
        sb.append(" from t_perm_userperm where 1=1 ");
        if (null != userIdSet && !userIdSet.isEmpty() && StringUtils.isNotEmpty((String)(inStr = SqlUtil.wrapInParam(userIdSet.stream().map(x -> x).collect(Collectors.toSet()), paramList)))) {
            sb.append(" and fuserid in (").append(inStr).append(") ");
        }
        if (null != dimTypeBigSet && !dimTypeBigSet.isEmpty() && StringUtils.isNotEmpty((String)(inStr = SqlUtil.wrapInParam(dimTypeBigSet.stream().map(x -> x).collect(Collectors.toSet()), paramList)))) {
            sb.append(" and fdimtype in (").append(inStr).append(") ");
        }
        if (null != dimIdSet && !dimIdSet.isEmpty() && StringUtils.isNotEmpty((String)(inStr = SqlUtil.wrapInParam(dimIdSet.stream().map(x -> x).collect(Collectors.toSet()), paramList)))) {
            sb.append(" and forgid in (").append(inStr).append(") ");
        }
        DB.query((DBRoute)DBRoute.permission, (String)sb.toString(), (Object[])paramList.toArray(new Object[paramList.size()]), (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    udimFidMap.put(rs.getString("fuserid") + "|" + rs.getString("fdimtype") + "|" + rs.getString("forgid") + "|" + rs.getString("fisincludesuborg"), rs.getString("fid"));
                }
                return null;
            }
        });
        return udimFidMap;
    }
}

