/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sec.user;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.license.api.ILicenseService;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.sec.user.UserOperPlugin;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.yzj.interfaces.IYzjUserService;
import kd.bos.yzj.model.YzjConfig;
import kd.bos.yzj.model.user.YzjUserModel;

public class SubscriberDisableServicePlugin
extends UserOperPlugin {
    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        IYzjUserService userService = this.getYzjUserService();
        YzjConfig yzjConfig = userService.getConfig();
        ArrayList<String> openIds = new ArrayList<String>();
        ArrayList<YzjUserModel> changeUserList = new ArrayList<YzjUserModel>();
        DynamicObject[] userArr = this.genSelectedUserChangeInfo(e, "13", false, openIds, changeUserList);
        if (userArr == null) {
            logger.info("\u6ca1\u6709\u67e5\u8be2\u5230\u4eba\u5458\u4fe1\u606f\u3002");
            return;
        }
        if (!CollectionUtils.isEmpty(changeUserList)) {
            userService.update(changeUserList);
        }
        for (YzjUserModel yzjUserModel : changeUserList) {
            if (yzjUserModel.isOperSuccess()) continue;
            logger.info(e.getOperationKey() + yzjUserModel.getName() + yzjUserModel.getOperMsg());
        }
        this.disableUser(userArr, e);
    }

    private void disableUser(DynamicObject[] users, BeforeOperationArgs e) {
        HashSet<Long> userIdSet = new HashSet<Long>(users.length);
        for (DynamicObject userObj : users) {
            userIdSet.add(userObj.getLong("id"));
        }
        Long currentUserId = RequestContext.get().getCurrUserId();
        if (userIdSet.contains(currentUserId)) {
            Map numberObj = BusinessDataServiceHelper.loadFromCache((String)"bos_user", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)currentUserId)});
            OperationResult operationResults = this.getOperationResult();
            ArrayList<OperateErrorInfo> operateErrorInfos = new ArrayList<OperateErrorInfo>(1);
            OperateErrorInfo errorInfo = new OperateErrorInfo();
            errorInfo.setLevel(ErrorLevel.FatalError);
            errorInfo.setMessage(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u4e0d\u80fd\u7981\u7528\u81ea\u5df1\u3002", (String)"SubscriberDisableServicePlugin_0", (String)"bos-sec-user", (Object[])new Object[0]), ((DynamicObject)numberObj.get(currentUserId)).get("number")));
            operateErrorInfos.add(errorInfo);
            ValidateResultCollection validateResultCollection = operationResults.getValidateResult();
            ValidateResult validateResult = new ValidateResult();
            validateResult.setValidatorKey(ResManager.loadKDString((String)"\u7528\u6237\u7981\u7528\u3002", (String)"SubscriberDisableServicePlugin_1", (String)"bos-sec-user", (Object[])new Object[0]));
            validateResult.setSuccess(false);
            validateResult.setAllErrorInfo(operateErrorInfos);
            validateResultCollection.addValidateError(ResManager.loadKDString((String)"\u7528\u6237\u7981\u7528\u3002", (String)"SubscriberDisableServicePlugin_1", (String)"bos-sec-user", (Object[])new Object[0]), validateResult);
            this.getOperationResult().setValidateResult(validateResultCollection);
            e.setCancel(true);
            return;
        }
        ILicenseService service = (ILicenseService)ServiceFactory.getService(ILicenseService.class);
        service.disposeDisableUserLic(userIdSet);
        SaveServiceHelper.save((DynamicObject[])users);
    }
}

