/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sec.user;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.license.api.ILicenseService;
import kd.bos.orm.query.QFilter;
import kd.bos.sec.user.UserOperPlugin;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class UserDisableServicePlugin
extends UserOperPlugin {
    @Override
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new UserDisableValidatorService());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        ArrayList<String> openIds = new ArrayList<String>();
        DynamicObject[] userArr = this.genSelectedUserChangeInfo(e, "4", true, openIds, null);
        if (this.delYzjUser(e, openIds)) {
            List dataEntityList = e.getValidExtDataEntities();
            HashSet<Long> userIdSet = new HashSet<Long>(dataEntityList.size());
            for (ExtendedDataEntity obj : dataEntityList) {
                userIdSet.add(obj.getDataEntity().getLong("id"));
            }
            ILicenseService service = (ILicenseService)ServiceFactory.getService(ILicenseService.class);
            service.disposeDisableUserLic(userIdSet);
            SaveServiceHelper.save((DynamicObject[])userArr);
        } else {
            e.cancel = true;
            logger.info(e.getOperationKey() + "\uff1a\u4eba\u5458\u6267\u884c\u7981\u7528\u64cd\u4f5c\u524d\uff0c\u4ece\u4e91\u4e4b\u5bb6\u5220\u9664\u4eba\u5458\u5931\u8d25\uff0c\u53d6\u6d88\u64cd\u4f5c\u3002");
        }
    }

    @Override
    protected void operateBizPartnerUser(List<Long> userIds) {
        String selectFields = "enable,disabler,disabledate";
        QFilter userFilter = new QFilter("user", "in", userIds);
        QFilter[] filters = new QFilter[]{userFilter};
        DynamicObject[] partnerObjArr = BusinessDataServiceHelper.load((String)"bos_bizpartneruser", (String)selectFields, (QFilter[])filters);
        if (partnerObjArr == null || partnerObjArr.length == 0) {
            return;
        }
        long currUserId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        for (DynamicObject partnerObj : partnerObjArr) {
            partnerObj.set("enable", (Object)"0");
            partnerObj.set("disabler", (Object)currUserId);
            partnerObj.set("disabledate", (Object)date);
        }
        SaveServiceHelper.save((DynamicObject[])partnerObjArr);
    }

    private static class UserDisableValidatorService
    extends AbstractValidator {
        private UserDisableValidatorService() {
        }

        public void validate() {
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                DynamicObject userObj = dataEntity.getDataEntity();
                long userId = userObj.getLong("id");
                if (userId != 1L && userId != 2L && userId != 3L && userId != 10L) continue;
                String msg = ResManager.loadKDString((String)"\u9884\u7f6e\u7684\u7ba1\u7406\u5458\u4e0d\u5141\u8bb8\u7981\u7528\u3002", (String)"UserDisableServicePlugin_0", (String)"bos-sec-user", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, msg);
            }
        }
    }
}

